/*
 * Copyright (C) 2024 Uniontech Technology Co., Ltd.
 *
 * Author:     liuzheng <liuzheng@uniontech.com>
 *
 * Maintainer: liuzheng <liuzheng@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef CLIPDATA_H
#define CLIPDATA_H

#include <vector>
#include <string>
#include <iostream>
#include <fstream>

using namespace std;
class ClipDataRecord;
class ClipDataProperty;
class ClipData
{
public:
    explicit ClipData();
    ~ClipData();

    // 获取记录数
    int getRecordCount();
    // 获取指定索引的记录的MIME类型
    string getRecordMimeType(int index);
    // 获取指定索引的记录
    ClipDataRecord *getRecordAt(int index);
    // 移除指定索引的记录
    void removeRecordAt(int index);

    // 创建记录数据
    ClipDataRecord *createRecordData();
    // 添加记录数据
    int addRecordData(ClipDataRecord *_data);

    // 获取MIME类型列表
    vector<string> getMimeTypes();
    // 获取属性数据
    ClipDataProperty *getProperty();
    // 设置属性数据
    void setProperty(ClipDataProperty *propetry);

    // 获取数据状态
    bool getDataState();
    // 设置数据状态
    void setDataState(bool flag);

    // 清空数据
    void clear();

    // 保存到文件
    void save(ofstream &file);
    // 从文件中加载
    void load(ifstream &file);

    // 设置剪切板名字
    void setName(string name);
    // 获取剪切板名字
    string getName();

private:
    vector<ClipDataRecord *> m_listrecorddata; // 多个记录数据
    ClipDataProperty *m_propertys;             // 属性数据
    bool m_enable;                             // 是否被激活
    string    m_name;                          // 剪切板名字
};

#endif // CLIPDATA_H
