package diStorm3;

import java.util.HashMap;
import java.util.Map;

public class Opcodes {
	private static Map<Integer, OpcodeEnum> mOpcodes;
	
	public static OpcodeEnum lookup(int op)
	{
		return mOpcodes.get(op);
	}
	
	static {
		mOpcodes.put(0, OpcodeEnum.UNDEFINED);
		mOpcodes.put(0x679, OpcodeEnum.SLDT);
		mOpcodes.put(0x62, OpcodeEnum.POPA);
		mOpcodes.put(0x910, OpcodeEnum.UNPCKHPS);
		mOpcodes.put(0x115, OpcodeEnum.POPF);
		mOpcodes.put(0x11db, OpcodeEnum.CMPLTSS);
		mOpcodes.put(0x881, OpcodeEnum.VMOVSD);
		mOpcodes.put(0x7ab, OpcodeEnum.PFPNACC);
		mOpcodes.put(0xb36, OpcodeEnum.VMOVMSKPD);
		mOpcodes.put(0x759, OpcodeEnum.INVLPGA);
		mOpcodes.put(0x91a, OpcodeEnum.UNPCKHPD);
		mOpcodes.put(0x270, OpcodeEnum.SYSEXIT);
		mOpcodes.put(0x7d4, OpcodeEnum.PFSUB);
		mOpcodes.put(0x122a, OpcodeEnum.CMPLTSD);
		mOpcodes.put(0x1a7f, OpcodeEnum.VPMULHUW);
		mOpcodes.put(0x1d57, OpcodeEnum.VPHSUBSW);
		mOpcodes.put(0x12d4, OpcodeEnum.VCMPNGEPS);
		mOpcodes.put(0x879, OpcodeEnum.VMOVSS);
		mOpcodes.put(0x6f, OpcodeEnum.ARPL);
		mOpcodes.put(0x53a, OpcodeEnum.FICOMP);
		mOpcodes.put(0x162, OpcodeEnum.RETF);
		mOpcodes.put(0x45d, OpcodeEnum.FCHS);
		mOpcodes.put(0x1146, OpcodeEnum.CMPLEPS);
		mOpcodes.put(0xf14, OpcodeEnum.PUNPCKHDQ);
		mOpcodes.put(0x2423, OpcodeEnum.VAESDEC);
		mOpcodes.put(0x5fe, OpcodeEnum.FUCOM);
		mOpcodes.put(0x12bc, OpcodeEnum.VCMPORDPS);
		mOpcodes.put(0x19cd, OpcodeEnum.PSUBUSW);
		mOpcodes.put(0x1b67, OpcodeEnum.PXOR);
		mOpcodes.put(0x1e31, OpcodeEnum.VPABSB);
		mOpcodes.put(0x24a, OpcodeEnum.WRMSR);
		mOpcodes.put(0x12c7, OpcodeEnum.VCMPEQ_UQPS);
		mOpcodes.put(0x22d8, OpcodeEnum.VFMADDSUB231PD);
		mOpcodes.put(0x7eb, OpcodeEnum.PFMAX);
		mOpcodes.put(0x16ef, OpcodeEnum.VCMPNEQ_OSSS);
		mOpcodes.put(0x2266, OpcodeEnum.VFNMADD213PD);
		mOpcodes.put(0x3b8, OpcodeEnum.MOVNTI);
		mOpcodes.put(0x7e2, OpcodeEnum.PFCMPGT);
		mOpcodes.put(0x238c, OpcodeEnum.VFNMADD231SS);
		mOpcodes.put(0x2472, OpcodeEnum.ROUNDPD);
		mOpcodes.put(0x130f, OpcodeEnum.VCMPGTPS);
		mOpcodes.put(0xbc1, OpcodeEnum.VRCPSS);
		mOpcodes.put(0x215c, OpcodeEnum.VFNMADD132SS);
		mOpcodes.put(0x1466, OpcodeEnum.VCMPNGEPD);
		mOpcodes.put(0x2231, OpcodeEnum.VFMSUB213PD);
		mOpcodes.put(0x1881, OpcodeEnum.VCMPNEQ_OSSD);
		mOpcodes.put(0x26a1, OpcodeEnum.VPSLLDQ);
		mOpcodes.put(0x7b4, OpcodeEnum.PFCMPGE);
		mOpcodes.put(0x14a1, OpcodeEnum.VCMPGTPD);
		mOpcodes.put(0x1aa5, OpcodeEnum.CVTDQ2PD);
		mOpcodes.put(0x1233, OpcodeEnum.CMPLESD);
		mOpcodes.put(0xae, OpcodeEnum.JNS);
		mOpcodes.put(0xdfa, OpcodeEnum.VDIVSD);
		mOpcodes.put(0xb7, OpcodeEnum.JNP);
		mOpcodes.put(0x252a, OpcodeEnum.EXTRACTPS);
		mOpcodes.put(0x1f65, OpcodeEnum.PMOVZXBQ);
		mOpcodes.put(0x9c, OpcodeEnum.JNZ);
		mOpcodes.put(0x5e8, OpcodeEnum.FCOMI);
		mOpcodes.put(0xf08, OpcodeEnum.VPUNPCKHWD);
		mOpcodes.put(0x1f50, OpcodeEnum.PMOVZXBD);
		mOpcodes.put(0x1aec, OpcodeEnum.VMOVNTDQ);
		mOpcodes.put(0x1e96, OpcodeEnum.PMOVSXWD);
		mOpcodes.put(0x1114, OpcodeEnum.POPCNT);
		mOpcodes.put(0x8a, OpcodeEnum.JNO);
		mOpcodes.put(0x1cb1, OpcodeEnum.FNSAVE);
		mOpcodes.put(0x1a5, OpcodeEnum.LOOP);
		mOpcodes.put(0xb2b, OpcodeEnum.VMOVMSKPS);
		mOpcodes.put(0x47b, OpcodeEnum.FLDL2T);
		mOpcodes.put(0x12d, OpcodeEnum.CMPS);
		mOpcodes.put(0x418, OpcodeEnum.FSUB);
		mOpcodes.put(0xdc6, OpcodeEnum.DIVPS);
		mOpcodes.put(0x1d3d, OpcodeEnum.PHSUBD);
		mOpcodes.put(0x11d2, OpcodeEnum.CMPEQSS);
		mOpcodes.put(0x1e7, OpcodeEnum.CMC);
		mOpcodes.put(0xd21, OpcodeEnum.CVTTPS2DQ);
		mOpcodes.put(0xdcd, OpcodeEnum.DIVPD);
		mOpcodes.put(0xf7e, OpcodeEnum.VMOVD);
		mOpcodes.put(0x104, OpcodeEnum.CALL_FAR);
		mOpcodes.put(0x1d94, OpcodeEnum.PMULHRSW);
		mOpcodes.put(0x1d9e, OpcodeEnum.VPMULHRSW);
		mOpcodes.put(0x1d2c, OpcodeEnum.PHSUBW);
		mOpcodes.put(0x1221, OpcodeEnum.CMPEQSD);
		mOpcodes.put(0x3b2, OpcodeEnum.XADD);
		mOpcodes.put(0x2ae, OpcodeEnum.CMOVBE);
		mOpcodes.put(0x47, OpcodeEnum.CMP);
		mOpcodes.put(0x24, OpcodeEnum.SBB);
		mOpcodes.put(0x1090, OpcodeEnum.VHADDPS);
		mOpcodes.put(0x26cf, OpcodeEnum.FXRSTOR64);
		mOpcodes.put(0x2086, OpcodeEnum.INVVPID);
		mOpcodes.put(0x20f, OpcodeEnum.LSL);
		mOpcodes.put(0x167f, OpcodeEnum.VCMPNEQ_USSS);
		mOpcodes.put(0x1087, OpcodeEnum.VHADDPD);
		mOpcodes.put(0x38b, OpcodeEnum.LSS);
		mOpcodes.put(0x2119, OpcodeEnum.VFMSUB132PD);
		mOpcodes.put(0x121, OpcodeEnum.LAHF);
		mOpcodes.put(0x80e, OpcodeEnum.PFACC);
		mOpcodes.put(0x825, OpcodeEnum.PFRCPIT2);
		mOpcodes.put(0xe49, OpcodeEnum.VPUNPCKLBW);
		mOpcodes.put(0x7f2, OpcodeEnum.PFRCPIT1);
		mOpcodes.put(0x1fb9, OpcodeEnum.PCMPGTQ);
		mOpcodes.put(0x4af, OpcodeEnum.FYL2X);
		mOpcodes.put(0x183b, OpcodeEnum.VCMPORD_SSD);
		mOpcodes.put(0x1955, OpcodeEnum.PSRLD);
		mOpcodes.put(0x1103, OpcodeEnum.SFENCE);
		mOpcodes.put(0xd17, OpcodeEnum.CVTPS2DQ);
		mOpcodes.put(0x24d1, OpcodeEnum.PBLENDW);
		mOpcodes.put(0x21d0, OpcodeEnum.VFMSUBADD213PS);
		mOpcodes.put(0x2564, OpcodeEnum.VPINSRB);
		mOpcodes.put(0xe98, OpcodeEnum.PCMPGTB);
		mOpcodes.put(0xebe, OpcodeEnum.PCMPGTD);
		mOpcodes.put(0x23f9, OpcodeEnum.VAESENC);
		mOpcodes.put(0x979, OpcodeEnum.VMOVSHDUP);
		mOpcodes.put(0x25be, OpcodeEnum.MPSADBW);
		mOpcodes.put(0x1509, OpcodeEnum.VCMPNLE_UQPD);
		mOpcodes.put(0x72c, OpcodeEnum.VMMCALL);
		mOpcodes.put(0x1051, OpcodeEnum.INSERTQ);
		mOpcodes.put(0x2274, OpcodeEnum.VFNMADD213SS);
		mOpcodes.put(0x9e1, OpcodeEnum.CVTPI2PD);
		mOpcodes.put(0x16f, OpcodeEnum.INT);
		mOpcodes.put(0x1da9, OpcodeEnum.VPERMILPS);
		mOpcodes.put(0x1e2, OpcodeEnum.HLT);
		mOpcodes.put(0x2065, OpcodeEnum.PHMINPOSUW);
		mOpcodes.put(0x5c1, OpcodeEnum.FCMOVNU);
		mOpcodes.put(0x208f, OpcodeEnum.INVPCID);
		mOpcodes.put(0x7b, OpcodeEnum.INS);
		mOpcodes.put(0x657, OpcodeEnum.FCOMIP);
		mOpcodes.put(0x9d7, OpcodeEnum.CVTPI2PS);
		mOpcodes.put(0x2282, OpcodeEnum.VFNMADD213SD);
		mOpcodes.put(0xed1, OpcodeEnum.PACKUSWB);
		mOpcodes.put(0xe4, OpcodeEnum.CBW);
		mOpcodes.put(0x73d, OpcodeEnum.VMSAVE);
		mOpcodes.put(0x10e, OpcodeEnum.PUSHF);
		mOpcodes.put(0x65f, OpcodeEnum.NOT);
		mOpcodes.put(0x5a5, OpcodeEnum.FCMOVNB);
		mOpcodes.put(0x245, OpcodeEnum.NOP);
		mOpcodes.put(0x4f8, OpcodeEnum.FSQRT);
		mOpcodes.put(0x1db4, OpcodeEnum.VPERMILPD);
		mOpcodes.put(0x51, OpcodeEnum.INC);
		mOpcodes.put(0x239, OpcodeEnum.UD2);
		mOpcodes.put(0x1009, OpcodeEnum.VPCMPEQW);
		mOpcodes.put(0x2637, OpcodeEnum.PCMPISTRM);
		mOpcodes.put(0x1eef, OpcodeEnum.VPCMPEQQ);
		mOpcodes.put(0x116f, OpcodeEnum.CMPNLEPS);
		mOpcodes.put(0x1848, OpcodeEnum.VCMPEQ_USSD);
		mOpcodes.put(0x1420, OpcodeEnum.VCMPUNORDPD);
		mOpcodes.put(0x60d, OpcodeEnum.FADDP);
		mOpcodes.put(0x145, OpcodeEnum.RET);
		mOpcodes.put(0x101c, OpcodeEnum.VPCMPEQD);
		mOpcodes.put(0x1fe5, OpcodeEnum.VPMINSD);
		mOpcodes.put(0xff6, OpcodeEnum.VPCMPEQB);
		mOpcodes.put(0x191c, OpcodeEnum.ADDSUBPD);
		mOpcodes.put(0x22c8, OpcodeEnum.VFMADDSUB231PS);
		mOpcodes.put(0x16b6, OpcodeEnum.VCMPEQ_USSS);
		mOpcodes.put(0x1d72, OpcodeEnum.PSIGNW);
		mOpcodes.put(0x1eca, OpcodeEnum.VPMOVSXDQ);
		mOpcodes.put(0x2029, OpcodeEnum.VPMAXSD);
		mOpcodes.put(0x35b, OpcodeEnum.SETG);
		mOpcodes.put(0x2018, OpcodeEnum.VPMAXSB);
		mOpcodes.put(0x327, OpcodeEnum.SETA);
		mOpcodes.put(0x306, OpcodeEnum.SETB);
		mOpcodes.put(0x2701, OpcodeEnum.STMXCSR);
		mOpcodes.put(0x347, OpcodeEnum.SETL);
		mOpcodes.put(0x1adb, OpcodeEnum.MOVNTQ);
		mOpcodes.put(0x2f9, OpcodeEnum.SETO);
		mOpcodes.put(0x6fb, OpcodeEnum.CLAC);
		mOpcodes.put(0x1128, OpcodeEnum.BSR);
		mOpcodes.put(0x8dc, OpcodeEnum.VMOVDDUP);
		mOpcodes.put(0x1b5e, OpcodeEnum.VPMAXSW);
		mOpcodes.put(0x1d83, OpcodeEnum.PSIGND);
		mOpcodes.put(0x33a, OpcodeEnum.SETP);
		mOpcodes.put(0x1d61, OpcodeEnum.PSIGNB);
		mOpcodes.put(0x395, OpcodeEnum.LFS);
		mOpcodes.put(0x32d, OpcodeEnum.SETS);
		mOpcodes.put(0x15b2, OpcodeEnum.VCMPUNORDSS);
		mOpcodes.put(0xbe7, OpcodeEnum.ANDNPS);
		mOpcodes.put(0x2730, OpcodeEnum.VMXON);
		mOpcodes.put(0xbd7, OpcodeEnum.VANDPS);
		mOpcodes.put(0x70f, OpcodeEnum.XSETBV);
		mOpcodes.put(0x1c3, OpcodeEnum.OUT);
		mOpcodes.put(0x68a, OpcodeEnum.LTR);
		mOpcodes.put(0x2592, OpcodeEnum.VPINSRD);
		mOpcodes.put(0x1121, OpcodeEnum.TZCNT);
		mOpcodes.put(0xa79, OpcodeEnum.VCVTTSS2SI);
		mOpcodes.put(0x2690, OpcodeEnum.VPSRLDQ);
		mOpcodes.put(0x4d6, OpcodeEnum.FDECSTP);
		mOpcodes.put(0x2688, OpcodeEnum.PSRLDQ);
		mOpcodes.put(0x188f, OpcodeEnum.VCMPGE_OQSD);
		mOpcodes.put(0x2699, OpcodeEnum.PSLLDQ);
		mOpcodes.put(0x51f, OpcodeEnum.FCOS);
		mOpcodes.put(0x4c5, OpcodeEnum.FXTRACT);
		mOpcodes.put(0x16fd, OpcodeEnum.VCMPGE_OQSS);
		mOpcodes.put(0x1f03, OpcodeEnum.VMOVNTDQA);
		mOpcodes.put(0x153f, OpcodeEnum.VCMPNGT_UQPD);
		mOpcodes.put(0x405, OpcodeEnum.FMUL);
		mOpcodes.put(0x13e6, OpcodeEnum.VCMPGT_OQPS);
		mOpcodes.put(0x61b, OpcodeEnum.FCOMPP);
		mOpcodes.put(0x79c, OpcodeEnum.PF2ID);
		mOpcodes.put(0xf5, OpcodeEnum.CWD);
		mOpcodes.put(0x134c, OpcodeEnum.VCMPUNORD_SPS);
		mOpcodes.put(0x2ea, OpcodeEnum.CMOVLE);
		mOpcodes.put(0xfd9, OpcodeEnum.VPSHUFHW);
		mOpcodes.put(0x1578, OpcodeEnum.VCMPGT_OQPD);
		mOpcodes.put(0x1d02, OpcodeEnum.PHADDSW);
		mOpcodes.put(0x795, OpcodeEnum.PF2IW);
		mOpcodes.put(0xa43, OpcodeEnum.VMOVNTPD);
		mOpcodes.put(0x411, OpcodeEnum.FCOMP);
		mOpcodes.put(0x8e6, OpcodeEnum.UNPCKLPS);
		mOpcodes.put(0x1bf1, OpcodeEnum.MASKMOVDQU);
		mOpcodes.put(0x570, OpcodeEnum.FCMOVBE);
		mOpcodes.put(0x14c4, OpcodeEnum.VCMPLT_OQPD);
		mOpcodes.put(0xe36, OpcodeEnum.VMAXSD);
		mOpcodes.put(0x1438, OpcodeEnum.VCMPNLTPD);
		mOpcodes.put(0x9a9, OpcodeEnum.PREFETCHT2);
		mOpcodes.put(0x99d, OpcodeEnum.PREFETCHT1);
		mOpcodes.put(0x991, OpcodeEnum.PREFETCHT0);
		mOpcodes.put(0x8f0, OpcodeEnum.UNPCKLPD);
		mOpcodes.put(0xa63, OpcodeEnum.CVTTSS2SI);
		mOpcodes.put(0x66e, OpcodeEnum.DIV);
		mOpcodes.put(0x1ec0, OpcodeEnum.PMOVSXDQ);
		mOpcodes.put(0x1629, OpcodeEnum.VCMPGESS);
		mOpcodes.put(0xef, OpcodeEnum.CDQE);
		mOpcodes.put(0x2714, OpcodeEnum.VSTMXCSR);
		mOpcodes.put(0x549, OpcodeEnum.FISUBR);
		mOpcodes.put(0x1fd4, OpcodeEnum.VPMINSB);
		mOpcodes.put(0x2224, OpcodeEnum.VFMSUB213PS);
		mOpcodes.put(0x1332, OpcodeEnum.VCMPLT_OQPS);
		mOpcodes.put(0x11e4, OpcodeEnum.CMPLESS);
		mOpcodes.put(0x1b20, OpcodeEnum.VPMINSW);
		mOpcodes.put(0x1c7c, OpcodeEnum.FSTENV);
		mOpcodes.put(0x17bb, OpcodeEnum.VCMPGESD);
		mOpcodes.put(0x1df6, OpcodeEnum.VPTEST);
		mOpcodes.put(0x542, OpcodeEnum.FISUB);
		mOpcodes.put(0x205, OpcodeEnum.STD);
		mOpcodes.put(0xf35, OpcodeEnum.VPACKSSDW);
		mOpcodes.put(0x3d, OpcodeEnum.XOR);
		mOpcodes.put(0xca1, OpcodeEnum.VMULPD);
		mOpcodes.put(0x1f1, OpcodeEnum.STC);
		mOpcodes.put(0x1fb, OpcodeEnum.STI);
		mOpcodes.put(0x26e4, OpcodeEnum.LDMXCSR);
		mOpcodes.put(0x118c, OpcodeEnum.CMPLTPD);
		mOpcodes.put(0xc09, OpcodeEnum.ORPS);
		mOpcodes.put(0x1f18, OpcodeEnum.VPACKUSDW);
		mOpcodes.put(0x62b, OpcodeEnum.FSUBP);
		mOpcodes.put(0x67f, OpcodeEnum.STR);
		mOpcodes.put(0x41e, OpcodeEnum.FSUBR);
		mOpcodes.put(0x113d, OpcodeEnum.CMPLTPS);
		mOpcodes.put(0x232f, OpcodeEnum.VFMADD231SD);
		mOpcodes.put(0x273f, OpcodeEnum.PAUSE);
		mOpcodes.put(0x1aaf, OpcodeEnum.CVTPD2DQ);
		mOpcodes.put(0x372, OpcodeEnum.RSM);
		mOpcodes.put(0xb7c, OpcodeEnum.VSQRTSD);
		mOpcodes.put(0xc15, OpcodeEnum.VORPS);
		mOpcodes.put(0x21b0, OpcodeEnum.VFMADDSUB213PS);
		mOpcodes.put(0x23f1, OpcodeEnum.AESENC);
		mOpcodes.put(0x1459, OpcodeEnum.VCMPEQ_UQPD);
		mOpcodes.put(0x924, OpcodeEnum.VUNPCKHPS);
		mOpcodes.put(0x1d15, OpcodeEnum.PMADDUBSW);
		mOpcodes.put(0x1377, OpcodeEnum.VCMPNLE_UQPS);
		mOpcodes.put(0x1b8a, OpcodeEnum.VPSLLW);
		mOpcodes.put(0x1be7, OpcodeEnum.MASKMOVQ);
		mOpcodes.put(0x1c8, OpcodeEnum.CALL);
		mOpcodes.put(0xb73, OpcodeEnum.VSQRTSS);
		mOpcodes.put(0x19fe, OpcodeEnum.PADDUSB);
		mOpcodes.put(0x1042, OpcodeEnum.VMREAD);
		mOpcodes.put(0x10f7, OpcodeEnum.XSAVEOPT64);
		mOpcodes.put(0x92f, OpcodeEnum.VUNPCKHPD);
		mOpcodes.put(0xd6a, OpcodeEnum.VSUBPS);
		mOpcodes.put(0xcf7, OpcodeEnum.VCVTSS2SD);
		mOpcodes.put(0x2438, OpcodeEnum.VAESDECLAST);
		mOpcodes.put(0x10a1, OpcodeEnum.HSUBPS);
		mOpcodes.put(0xab9, OpcodeEnum.VCVTSS2SI);
		mOpcodes.put(0x25fe, OpcodeEnum.VPBLENDVB);
		mOpcodes.put(0x17c5, OpcodeEnum.VCMPGTSD);
		mOpcodes.put(0x58a, OpcodeEnum.FILD);
		mOpcodes.put(0xb05, OpcodeEnum.VCOMISS);
		mOpcodes.put(0x1099, OpcodeEnum.HSUBPD);
		mOpcodes.put(0x23c4, OpcodeEnum.VFNMSUB231SS);
		mOpcodes.put(0x1a5f, OpcodeEnum.VPSRAD);
		mOpcodes.put(0x12b1, OpcodeEnum.VCMPNLEPS);
		mOpcodes.put(0x3e5, OpcodeEnum.SAL);
		mOpcodes.put(0x214, OpcodeEnum.SYSCALL);
		mOpcodes.put(0xba1, OpcodeEnum.VRSQRTSS);
		mOpcodes.put(0x259b, OpcodeEnum.VPINSRQ);
		mOpcodes.put(0x270a, OpcodeEnum.WRGSBASE);
		mOpcodes.put(0xfd0, OpcodeEnum.VPSHUFD);
		mOpcodes.put(0x1e57, OpcodeEnum.PMOVSXBW);
		mOpcodes.put(0x1a50, OpcodeEnum.VPSRAW);
		mOpcodes.put(0x1443, OpcodeEnum.VCMPNLEPD);
		mOpcodes.put(0x3ff, OpcodeEnum.FADD);
		mOpcodes.put(0x3ea, OpcodeEnum.SAR);
		mOpcodes.put(0x71f, OpcodeEnum.XEND);
		mOpcodes.put(0x2665, OpcodeEnum.AESKEYGENASSIST);
		mOpcodes.put(0xf2b, OpcodeEnum.PACKSSDW);
		mOpcodes.put(0x220a, OpcodeEnum.VFMADD213SS);
		mOpcodes.put(0xf9c, OpcodeEnum.VMOVDQA);
		mOpcodes.put(0x8d1, OpcodeEnum.VMOVSLDUP);
		mOpcodes.put(0x508, OpcodeEnum.FRNDINT);
		mOpcodes.put(0x1982, OpcodeEnum.PMULLW);
		mOpcodes.put(0xddb, OpcodeEnum.DIVSD);
		mOpcodes.put(0xb17, OpcodeEnum.MOVMSKPS);
		mOpcodes.put(0x203a, OpcodeEnum.VPMAXUW);
		mOpcodes.put(0xdea, OpcodeEnum.VDIVPD);
		mOpcodes.put(0x1e61, OpcodeEnum.VPMOVSXBW);
		mOpcodes.put(0x1eab, OpcodeEnum.PMOVSXWQ);
		mOpcodes.put(0x2054, OpcodeEnum.PMULLD);
		mOpcodes.put(0xfa5, OpcodeEnum.VMOVDQU);
		mOpcodes.put(0x22ba, OpcodeEnum.VFNMSUB213SD);
		mOpcodes.put(0x297, OpcodeEnum.CMOVAE);
		mOpcodes.put(0x14b7, OpcodeEnum.VCMPEQ_OSPD);
		mOpcodes.put(0xde2, OpcodeEnum.VDIVPS);
		mOpcodes.put(0x93, OpcodeEnum.JAE);
		mOpcodes.put(0xb21, OpcodeEnum.MOVMSKPD);
		mOpcodes.put(0xdd4, OpcodeEnum.DIVSS);
		mOpcodes.put(0x1cb9, OpcodeEnum.FSAVE);
		mOpcodes.put(0x1ee6, OpcodeEnum.PCMPEQQ);
		mOpcodes.put(0xfe3, OpcodeEnum.VPSHUFLW);
		mOpcodes.put(0x1000, OpcodeEnum.PCMPEQW);
		mOpcodes.put(0x26f7, OpcodeEnum.VLDMXCSR);
		mOpcodes.put(0x2126, OpcodeEnum.VFMSUB132SS);
		mOpcodes.put(0x11c8, OpcodeEnum.CMPORDPD);
		mOpcodes.put(0xbb2, OpcodeEnum.RCPSS);
		mOpcodes.put(0x1b99, OpcodeEnum.VPSLLD);
		mOpcodes.put(0x673, OpcodeEnum.IDIV);
		mOpcodes.put(0x144e, OpcodeEnum.VCMPORDPD);
		mOpcodes.put(0xfed, OpcodeEnum.PCMPEQB);
		mOpcodes.put(0x1013, OpcodeEnum.PCMPEQD);
		mOpcodes.put(0x1ba8, OpcodeEnum.VPSLLQ);
		mOpcodes.put(0x1f6f, OpcodeEnum.VPMOVZXBQ);
		mOpcodes.put(0x21e0, OpcodeEnum.VFMSUBADD213PD);
		mOpcodes.put(0x25f3, OpcodeEnum.VBLENDVPD);
		mOpcodes.put(0x1179, OpcodeEnum.CMPORDPS);
		mOpcodes.put(0xf40, OpcodeEnum.PUNPCKLQDQ);
		mOpcodes.put(0x19f7, OpcodeEnum.VPAND);
		mOpcodes.put(0x1489, OpcodeEnum.VCMPNEQ_OQPD);
		mOpcodes.put(0x1077, OpcodeEnum.HADDPD);
		mOpcodes.put(0x193b, OpcodeEnum.VADDSUBPS);
		mOpcodes.put(0x18f3, OpcodeEnum.VSHUFPD);
		mOpcodes.put(0xd82, OpcodeEnum.VSUBSD);
		mOpcodes.put(0xb61, OpcodeEnum.VSQRTPS);
		mOpcodes.put(0x953, OpcodeEnum.MOVSHDUP);
		mOpcodes.put(0x239a, OpcodeEnum.VFNMADD231SD);
		mOpcodes.put(0x6cf, OpcodeEnum.VMLAUNCH);
		mOpcodes.put(0x1f2f, OpcodeEnum.VMASKMOVPD);
		mOpcodes.put(0x107f, OpcodeEnum.HADDPS);
		mOpcodes.put(0x701, OpcodeEnum.STAC);
		mOpcodes.put(0x12f7, OpcodeEnum.VCMPNEQ_OQPS);
		mOpcodes.put(0xe55, OpcodeEnum.PUNPCKLWD);
		mOpcodes.put(0x16d1, OpcodeEnum.VCMPNGT_UQSS);
		mOpcodes.put(0xb6a, OpcodeEnum.VSQRTPD);
		mOpcodes.put(0xd7a, OpcodeEnum.VSUBSS);
		mOpcodes.put(0x18ea, OpcodeEnum.VSHUFPS);
		mOpcodes.put(0x15bf, OpcodeEnum.VCMPNEQSS);
		mOpcodes.put(0x1b7b, OpcodeEnum.VLDDQU);
		mOpcodes.put(0x1656, OpcodeEnum.VCMPLT_OQSS);
		mOpcodes.put(0x274c, OpcodeEnum.RDRAND);
		mOpcodes.put(0x1b45, OpcodeEnum.PADDSW);
		mOpcodes.put(0x1392, OpcodeEnum.VCMPEQ_USPS);
		mOpcodes.put(0xc0f, OpcodeEnum.ORPD);
		mOpcodes.put(0x1a2b, OpcodeEnum.PANDN);
		mOpcodes.put(0x4b6, OpcodeEnum.FPTAN);
		mOpcodes.put(0x551, OpcodeEnum.FIDIV);
		mOpcodes.put(0x17e8, OpcodeEnum.VCMPLT_OQSD);
		mOpcodes.put(0x271e, OpcodeEnum.VMPTRLD);
		mOpcodes.put(0x233c, OpcodeEnum.VFMSUB231PS);
		mOpcodes.put(0x1751, OpcodeEnum.VCMPNEQSD);
		mOpcodes.put(0x1edd, OpcodeEnum.VPMULDQ);
		mOpcodes.put(0x196, OpcodeEnum.LOOPNZ);
		mOpcodes.put(0x128e, OpcodeEnum.VCMPUNORDPS);
		mOpcodes.put(0x3e0, OpcodeEnum.SHR);
		mOpcodes.put(0x37c, OpcodeEnum.SHRD);
		mOpcodes.put(0x6eb, OpcodeEnum.MONITOR);
		mOpcodes.put(0x3ef, OpcodeEnum.XABORT);
		mOpcodes.put(0x2402, OpcodeEnum.AESENCLAST);
		mOpcodes.put(0x860, OpcodeEnum.MOVSD);
		mOpcodes.put(0x18c0, OpcodeEnum.VPINSRW);
		mOpcodes.put(0x735, OpcodeEnum.VMLOAD);
		mOpcodes.put(0x93a, OpcodeEnum.MOVLHPS);
		mOpcodes.put(0x8c8, OpcodeEnum.VMOVLPD);
		mOpcodes.put(0x1993, OpcodeEnum.MOVQ2DQ);
		mOpcodes.put(0xb51, OpcodeEnum.SQRTSS);
		mOpcodes.put(0x25aa, OpcodeEnum.VDPPS);
		mOpcodes.put(0xd5c, OpcodeEnum.SUBSS);
		mOpcodes.put(0x3ab, OpcodeEnum.MOVSX);
		mOpcodes.put(0x95d, OpcodeEnum.VMOVLHPS);
		mOpcodes.put(0x8bf, OpcodeEnum.VMOVLPS);
		mOpcodes.put(0xf1f, OpcodeEnum.VPUNPCKHDQ);
		mOpcodes.put(0x1ad0, OpcodeEnum.VCVTPD2DQ);
		mOpcodes.put(0x3db, OpcodeEnum.SHL);
		mOpcodes.put(0x859, OpcodeEnum.MOVSS);
		mOpcodes.put(0x258a, OpcodeEnum.PINSRQ);
		mOpcodes.put(0x7a3, OpcodeEnum.PFNACC);
		mOpcodes.put(0xf94, OpcodeEnum.MOVDQU);
		mOpcodes.put(0x80, OpcodeEnum.OUTS);
		mOpcodes.put(0x1c0a, OpcodeEnum.PSUBB);
		mOpcodes.put(0x377, OpcodeEnum.BTS);
		mOpcodes.put(0x390, OpcodeEnum.BTR);
		mOpcodes.put(0x1811, OpcodeEnum.VCMPNEQ_USSD);
		mOpcodes.put(0x69b, OpcodeEnum.SGDT);
		mOpcodes.put(0x2322, OpcodeEnum.VFMADD231SS);
		mOpcodes.put(0x511, OpcodeEnum.FSCALE);
		mOpcodes.put(0x1c19, OpcodeEnum.PSUBW);
		mOpcodes.put(0x11b4, OpcodeEnum.CMPNLTPD);
		mOpcodes.put(0x1f0e, OpcodeEnum.PACKUSDW);
		mOpcodes.put(0x20a, OpcodeEnum.LAR);
		mOpcodes.put(0x3a6, OpcodeEnum.BTC);
		mOpcodes.put(0x216a, OpcodeEnum.VFNMADD132SD);
		mOpcodes.put(0x1471, OpcodeEnum.VCMPNGTPD);
		mOpcodes.put(0x1f45, OpcodeEnum.VPMOVZXBW);
		mOpcodes.put(0x2133, OpcodeEnum.VFMSUB132SD);
		mOpcodes.put(0x23e0, OpcodeEnum.AESIMC);
		mOpcodes.put(0x40b, OpcodeEnum.FCOM);
		mOpcodes.put(0x1f5a, OpcodeEnum.VPMOVZXBD);
		mOpcodes.put(0x1930, OpcodeEnum.VADDSUBPD);
		mOpcodes.put(0x1caa, OpcodeEnum.FINIT);
		mOpcodes.put(0x1217, OpcodeEnum.CMPORDSS);
		mOpcodes.put(0x231, OpcodeEnum.WBINVD);
		mOpcodes.put(0x19f1, OpcodeEnum.PAND);
		mOpcodes.put(0x120d, OpcodeEnum.CMPNLESS);
		mOpcodes.put(0x24ed, OpcodeEnum.VPALIGNR);
		mOpcodes.put(0x1266, OpcodeEnum.CMPORDSD);
		mOpcodes.put(0x1b6d, OpcodeEnum.VPXOR);
		mOpcodes.put(0xa1, OpcodeEnum.JBE);
		mOpcodes.put(0x46f, OpcodeEnum.FXAM);
		mOpcodes.put(0x10ed, OpcodeEnum.XSAVEOPT);
		mOpcodes.put(0x669, OpcodeEnum.MUL);
		mOpcodes.put(0x19e8, OpcodeEnum.VPMINUB);
		mOpcodes.put(0x1b4d, OpcodeEnum.VPADDSW);
		mOpcodes.put(0x1b56, OpcodeEnum.PMAXSW);
		mOpcodes.put(0x2577, OpcodeEnum.VINSERTPS);
		mOpcodes.put(0x1402, OpcodeEnum.VCMPEQPD);
		mOpcodes.put(0x5f7, OpcodeEnum.FFREE);
		mOpcodes.put(0x1f23, OpcodeEnum.VMASKMOVPS);
		mOpcodes.put(0x18fc, OpcodeEnum.CMPXCHG8B);
		mOpcodes.put(0x2021, OpcodeEnum.PMAXSD);
		mOpcodes.put(0x1b3c, OpcodeEnum.VPADDSB);
		mOpcodes.put(0x10, OpcodeEnum.PUSH);
		mOpcodes.put(0x25dc, OpcodeEnum.VPCLMULQDQ);
		mOpcodes.put(0x1270, OpcodeEnum.VCMPEQPS);
		mOpcodes.put(0x7fc, OpcodeEnum.PFRSQIT1);
		mOpcodes.put(0x245f, OpcodeEnum.ROUNDPS);
		mOpcodes.put(0x2ff, OpcodeEnum.SETNO);
		mOpcodes.put(0x707, OpcodeEnum.XGETBV);
		mOpcodes.put(0x1fdd, OpcodeEnum.PMINSD);
		mOpcodes.put(0x1c46, OpcodeEnum.PADDB);
		mOpcodes.put(0x4ce, OpcodeEnum.FPREM1);
		mOpcodes.put(0x200, OpcodeEnum.CLD);
		mOpcodes.put(0x52c, OpcodeEnum.FIMUL);
		mOpcodes.put(0xc2a, OpcodeEnum.XORPD);
		mOpcodes.put(0x1ec, OpcodeEnum.CLC);
		mOpcodes.put(0x43c, OpcodeEnum.FSTP);
		mOpcodes.put(0x24be, OpcodeEnum.BLENDPD);
		mOpcodes.put(0x1a11, OpcodeEnum.PADDUSW);
		mOpcodes.put(0x1ca2, OpcodeEnum.FNINIT);
		mOpcodes.put(0x319, OpcodeEnum.SETNZ);
		mOpcodes.put(0x1973, OpcodeEnum.PADDQ);
		mOpcodes.put(0xc23, OpcodeEnum.XORPS);
		mOpcodes.put(0x22ac, OpcodeEnum.VFNMSUB213SS);
		mOpcodes.put(0x333, OpcodeEnum.SETNS);
		mOpcodes.put(0x525, OpcodeEnum.FIADD);
		mOpcodes.put(0x340, OpcodeEnum.SETNP);
		mOpcodes.put(0xf65, OpcodeEnum.VPUNPCKHQDQ);
		mOpcodes.put(0xd4e, OpcodeEnum.SUBPS);
		mOpcodes.put(0x1252, OpcodeEnum.CMPNLTSD);
		mOpcodes.put(0x684, OpcodeEnum.LLDT);
		mOpcodes.put(0x224b, OpcodeEnum.VFMSUB213SD);
		mOpcodes.put(0x1def, OpcodeEnum.PTEST);
		mOpcodes.put(0x2186, OpcodeEnum.VFNMSUB132PD);
		mOpcodes.put(0x279, OpcodeEnum.GETSEC);
		mOpcodes.put(0x1d8b, OpcodeEnum.VPSIGND);
		mOpcodes.put(0x1ab, OpcodeEnum.JCXZ);
		mOpcodes.put(0x1203, OpcodeEnum.CMPNLTSS);
		mOpcodes.put(0x34d, OpcodeEnum.SETGE);
		mOpcodes.put(0x1134, OpcodeEnum.CMPEQPS);
		mOpcodes.put(0x1bd6, OpcodeEnum.PSADBW);
		mOpcodes.put(0x2737, OpcodeEnum.MOVSXD);
		mOpcodes.put(0x2178, OpcodeEnum.VFNMSUB132PS);
		mOpcodes.put(0x185, OpcodeEnum.AAD);
		mOpcodes.put(0x240e, OpcodeEnum.VAESENCLAST);
		mOpcodes.put(0xf59, OpcodeEnum.PUNPCKHQDQ);
		mOpcodes.put(0x89a, OpcodeEnum.MOVLPD);
		mOpcodes.put(0x1a07, OpcodeEnum.VPADDUSW);
		mOpcodes.put(0x12ea, OpcodeEnum.VCMPFALSEPS);
		mOpcodes.put(0x180, OpcodeEnum.AAM);
		mOpcodes.put(0xf4c, OpcodeEnum.VPUNPCKLQDQ);
		mOpcodes.put(0xd98, OpcodeEnum.MINSS);
		mOpcodes.put(0x1c64, OpcodeEnum.PADDD);
		mOpcodes.put(0x147c, OpcodeEnum.VCMPFALSEPD);
		mOpcodes.put(0xe60, OpcodeEnum.VPUNPCKLWD);
		mOpcodes.put(0x892, OpcodeEnum.MOVLPS);
		mOpcodes.put(0x74b, OpcodeEnum.CLGI);
		mOpcodes.put(0x4c, OpcodeEnum.AAS);
		mOpcodes.put(0x139, OpcodeEnum.LODS);
		mOpcodes.put(0x2d3, OpcodeEnum.CMOVNP);
		mOpcodes.put(0xd9f, OpcodeEnum.MINSD);
		mOpcodes.put(0x1f6, OpcodeEnum.CLI);
		mOpcodes.put(0xa6e, OpcodeEnum.CVTTSD2SI);
		mOpcodes.put(0x533, OpcodeEnum.FICOM);
		mOpcodes.put(0x1f3b, OpcodeEnum.PMOVZXBW);
		mOpcodes.put(0xc48, OpcodeEnum.ADDPD);
		mOpcodes.put(0x77c, OpcodeEnum.PREFETCHW);
		mOpcodes.put(0x135b, OpcodeEnum.VCMPNEQ_USPS);
		mOpcodes.put(0xc39, OpcodeEnum.VXORPD);
		mOpcodes.put(0x1b29, OpcodeEnum.POR);
		mOpcodes.put(0x16, OpcodeEnum.POP);
		mOpcodes.put(0x2453, OpcodeEnum.VPERM2F128);
		mOpcodes.put(0x19e, OpcodeEnum.LOOPZ);
		mOpcodes.put(0x1ae3, OpcodeEnum.MOVNTDQ);
		mOpcodes.put(0x1dc, OpcodeEnum.INT1);
		mOpcodes.put(0x382, OpcodeEnum.CMPXCHG);
		mOpcodes.put(0x1e1a, OpcodeEnum.VBROADCASTF128);
		mOpcodes.put(0x1531, OpcodeEnum.VCMPNGE_UQPD);
		mOpcodes.put(0x1ce0, OpcodeEnum.PHADDW);
		mOpcodes.put(0xc31, OpcodeEnum.VXORPS);
		mOpcodes.put(0x14ed, OpcodeEnum.VCMPNEQ_USPD);
		mOpcodes.put(0xc41, OpcodeEnum.ADDPS);
		mOpcodes.put(0x81e, OpcodeEnum.PFMUL);
		mOpcodes.put(0x6a7, OpcodeEnum.LGDT);
		mOpcodes.put(0x68f, OpcodeEnum.VERR);
		mOpcodes.put(0x695, OpcodeEnum.VERW);
		mOpcodes.put(0x10a9, OpcodeEnum.VHSUBPD);
		mOpcodes.put(0x198a, OpcodeEnum.VPMULLW);
		mOpcodes.put(0x867, OpcodeEnum.VMOVUPS);
		mOpcodes.put(0x174, OpcodeEnum.INTO);
		mOpcodes.put(0x1c9b, OpcodeEnum.FCLEX);
		mOpcodes.put(0x10b2, OpcodeEnum.VHSUBPS);
		mOpcodes.put(0xcd7, OpcodeEnum.CVTSD2SS);
		mOpcodes.put(0x48b, OpcodeEnum.FLDPI);
		mOpcodes.put(0x1e39, OpcodeEnum.PABSW);
		mOpcodes.put(0xe26, OpcodeEnum.VMAXPD);
		mOpcodes.put(0x1d3, OpcodeEnum.JMP_FAR);
		mOpcodes.put(0xedb, OpcodeEnum.VPACKUSWB);
		mOpcodes.put(0x581, OpcodeEnum.FUCOMPP);
		mOpcodes.put(0x870, OpcodeEnum.VMOVUPD);
		mOpcodes.put(0x838, OpcodeEnum.PSWAPD);
		mOpcodes.put(0x24a1, OpcodeEnum.VROUNDSD);
		mOpcodes.put(0x1c55, OpcodeEnum.PADDW);
		mOpcodes.put(0x1b92, OpcodeEnum.PSLLD);
		mOpcodes.put(0x762, OpcodeEnum.SWAPGS);
		mOpcodes.put(0x8a2, OpcodeEnum.MOVSLDUP);
		mOpcodes.put(0x9eb, OpcodeEnum.CVTSI2SS);
		mOpcodes.put(0x17cf, OpcodeEnum.VCMPTRUESD);
		mOpcodes.put(0x11ed, OpcodeEnum.CMPUNORDSS);
		mOpcodes.put(0xd42, OpcodeEnum.VCVTTPS2DQ);
		mOpcodes.put(0xb59, OpcodeEnum.SQRTSD);
		mOpcodes.put(0x1e0c, OpcodeEnum.VBROADCASTSD);
		mOpcodes.put(0x1c28, OpcodeEnum.PSUBD);
		mOpcodes.put(0xce, OpcodeEnum.TEST);
		mOpcodes.put(0x39a, OpcodeEnum.LGS);
		mOpcodes.put(0x163d, OpcodeEnum.VCMPTRUESS);
		mOpcodes.put(0x266, OpcodeEnum.SYSENTER);
		mOpcodes.put(0x9f5, OpcodeEnum.CVTSI2SD);
		mOpcodes.put(0x1767, OpcodeEnum.VCMPNLESD);
		mOpcodes.put(0x1dc8, OpcodeEnum.VTESTPD);
		mOpcodes.put(0x98, OpcodeEnum.JZ);
		mOpcodes.put(0xdf2, OpcodeEnum.VDIVSS);
		mOpcodes.put(0xc1c, OpcodeEnum.VORPD);
		mOpcodes.put(0xb3, OpcodeEnum.JP);
		mOpcodes.put(0xaa, OpcodeEnum.JS);
		mOpcodes.put(0xbc, OpcodeEnum.JL);
		mOpcodes.put(0xb8e, OpcodeEnum.RSQRTSS);
		mOpcodes.put(0x1dbf, OpcodeEnum.VTESTPS);
		mOpcodes.put(0x86, OpcodeEnum.JO);
		mOpcodes.put(0xe1e, OpcodeEnum.VMAXPS);
		mOpcodes.put(0x19ba, OpcodeEnum.PSUBUSB);
		mOpcodes.put(0xca, OpcodeEnum.JG);
		mOpcodes.put(0x1dfe, OpcodeEnum.VBROADCASTSS);
		mOpcodes.put(0xa6, OpcodeEnum.JA);
		mOpcodes.put(0x8f, OpcodeEnum.JB);
		mOpcodes.put(0xe9, OpcodeEnum.CWDE);
		mOpcodes.put(0x1416, OpcodeEnum.VCMPLEPD);
		mOpcodes.put(0x105a, OpcodeEnum.VMWRITE);
		mOpcodes.put(0x1284, OpcodeEnum.VCMPLEPS);
		mOpcodes.put(0x19a5, OpcodeEnum.PMOVMSKB);
		mOpcodes.put(0x256d, OpcodeEnum.INSERTPS);
		mOpcodes.put(0x2620, OpcodeEnum.PCMPESTRI);
		mOpcodes.put(0x2746, OpcodeEnum.WAIT);
		mOpcodes.put(0x154d, OpcodeEnum.VCMPFALSE_OSPD);
		mOpcodes.put(0x2609, OpcodeEnum.PCMPESTRM);
		mOpcodes.put(0xe6c, OpcodeEnum.PUNPCKLDQ);
		mOpcodes.put(0xc8b, OpcodeEnum.MULSS);
		mOpcodes.put(0xd72, OpcodeEnum.VSUBPD);
		mOpcodes.put(0x1183, OpcodeEnum.CMPEQPD);
		mOpcodes.put(0x17ad, OpcodeEnum.VCMPNEQ_OQSD);
		mOpcodes.put(0xb0e, OpcodeEnum.VCOMISD);
		mOpcodes.put(0xdb6, OpcodeEnum.VMINSS);
		mOpcodes.put(0x1c6b, OpcodeEnum.VPADDD);
		mOpcodes.put(0x258, OpcodeEnum.RDMSR);
		mOpcodes.put(0x1d7a, OpcodeEnum.VPSIGNW);
		mOpcodes.put(0x1b1, OpcodeEnum.JECXZ);
		mOpcodes.put(0xc92, OpcodeEnum.MULSD);
		mOpcodes.put(0x154, OpcodeEnum.ENTER);
		mOpcodes.put(0x2445, OpcodeEnum.MOVBE);
		mOpcodes.put(0x1038, OpcodeEnum.VZEROALL);
		mOpcodes.put(0x2754, OpcodeEnum._3DNOW);
		mOpcodes.put(0xdbe, OpcodeEnum.VMINSD);
		mOpcodes.put(0x161b, OpcodeEnum.VCMPNEQ_OQSS);
		mOpcodes.put(0x806, OpcodeEnum.PFSUBR);
		mOpcodes.put(0x1305, OpcodeEnum.VCMPGEPS);
		mOpcodes.put(0x19c3, OpcodeEnum.VPSUBUSB);
		mOpcodes.put(0x2363, OpcodeEnum.VFMSUB231SD);
		mOpcodes.put(0x2043, OpcodeEnum.PMAXUD);
		mOpcodes.put(0x26aa, OpcodeEnum.FXSAVE);
		mOpcodes.put(0x590, OpcodeEnum.FISTTP);
		mOpcodes.put(0x1497, OpcodeEnum.VCMPGEPD);
		mOpcodes.put(0x24ab, OpcodeEnum.BLENDPS);
		mOpcodes.put(0x173a, OpcodeEnum.VCMPLESD);
		mOpcodes.put(0x5b7, OpcodeEnum.FCMOVNBE);
		mOpcodes.put(0x2356, OpcodeEnum.VFMSUB231SS);
		mOpcodes.put(0x25e8, OpcodeEnum.VBLENDVPS);
		mOpcodes.put(0x25c7, OpcodeEnum.VMPSADBW);
		mOpcodes.put(0x19d6, OpcodeEnum.VPSUBUSW);
		mOpcodes.put(0x1730, OpcodeEnum.VCMPLTSD);
		mOpcodes.put(0x1ef9, OpcodeEnum.MOVNTDQA);
		mOpcodes.put(0x18e2, OpcodeEnum.SHUFPD);
		mOpcodes.put(0xd55, OpcodeEnum.SUBPD);
		mOpcodes.put(0xb49, OpcodeEnum.SQRTPD);
		mOpcodes.put(0x970, OpcodeEnum.VMOVHPD);
		mOpcodes.put(0x6c7, OpcodeEnum.VMCALL);
		mOpcodes.put(0x20e5, OpcodeEnum.VFMADD132PD);
		mOpcodes.put(0x15b, OpcodeEnum.LEAVE);
		mOpcodes.put(0x18da, OpcodeEnum.SHUFPS);
		mOpcodes.put(0x1325, OpcodeEnum.VCMPEQ_OSPS);
		mOpcodes.put(0x262b, OpcodeEnum.VPCMPESTRI);
		mOpcodes.put(0x159e, OpcodeEnum.VCMPLTSS);
		mOpcodes.put(0x2614, OpcodeEnum.VPCMPESTRM);
		mOpcodes.put(0x20d8, OpcodeEnum.VFMADD132PS);
		mOpcodes.put(0x6ad, OpcodeEnum.LIDT);
		mOpcodes.put(0x4a8, OpcodeEnum.F2XM1);
		mOpcodes.put(0x967, OpcodeEnum.VMOVHPS);
		mOpcodes.put(0x1fa4, OpcodeEnum.PMOVZXDQ);
		mOpcodes.put(0x102c, OpcodeEnum.VZEROUPPER);
		mOpcodes.put(0xb41, OpcodeEnum.SQRTPS);
		mOpcodes.put(0xbf7, OpcodeEnum.VANDNPS);
		mOpcodes.put(0x197a, OpcodeEnum.VPADDQ);
		mOpcodes.put(0x4e8, OpcodeEnum.FPREM);
		mOpcodes.put(0x1c5c, OpcodeEnum.VPADDW);
		mOpcodes.put(0x24e4, OpcodeEnum.PALIGNR);
		mOpcodes.put(0x1fcc, OpcodeEnum.PMINSB);
		mOpcodes.put(0xeab, OpcodeEnum.PCMPGTW);
		mOpcodes.put(0x36c, OpcodeEnum.SHLD);
		mOpcodes.put(0x14f, OpcodeEnum.LDS);
		mOpcodes.put(0x1c4d, OpcodeEnum.VPADDB);
		mOpcodes.put(0x725, OpcodeEnum.VMRUN);
		mOpcodes.put(0x26bc, OpcodeEnum.RDFSBASE);
		mOpcodes.put(0xc00, OpcodeEnum.VANDNPD);
		mOpcodes.put(0x190, OpcodeEnum.XLAT);
		mOpcodes.put(0xd4, OpcodeEnum.XCHG);
		mOpcodes.put(0x4df, OpcodeEnum.FINCSTP);
		mOpcodes.put(0x199c, OpcodeEnum.MOVDQ2Q);
		mOpcodes.put(0x1b18, OpcodeEnum.PMINSW);
		mOpcodes.put(0x6b3, OpcodeEnum.SMSW);
		mOpcodes.put(0x1d69, OpcodeEnum.VPSIGNB);
		mOpcodes.put(0x10d3, OpcodeEnum.XRSTOR);
		mOpcodes.put(0x24c7, OpcodeEnum.VBLENDPD);
		mOpcodes.put(0xc0, OpcodeEnum.JGE);
		mOpcodes.put(0x1369, OpcodeEnum.VCMPNLT_UQPS);
		mOpcodes.put(0x1772, OpcodeEnum.VCMPORDSD);
		mOpcodes.put(0x24b4, OpcodeEnum.VBLENDPS);
		mOpcodes.put(0x469, OpcodeEnum.FTST);
		mOpcodes.put(0x1a9a, OpcodeEnum.CVTTPD2DQ);
		mOpcodes.put(0x15e0, OpcodeEnum.VCMPORDSS);
		mOpcodes.put(0x14fb, OpcodeEnum.VCMPNLT_UQPD);
		mOpcodes.put(0x2194, OpcodeEnum.VFNMSUB132SS);
		mOpcodes.put(0x10db, OpcodeEnum.XRSTOR64);
		mOpcodes.put(0x29, OpcodeEnum.AND);
		mOpcodes.put(0xb97, OpcodeEnum.VRSQRTPS);
		mOpcodes.put(0x110b, OpcodeEnum.CLFLUSH);
		mOpcodes.put(0x1ccf, OpcodeEnum.PSHUFB);
		mOpcodes.put(0x442, OpcodeEnum.FLDENV);
		mOpcodes.put(0xda, OpcodeEnum.MOV);
		mOpcodes.put(0xfb6, OpcodeEnum.PSHUFD);
		mOpcodes.put(0xc5, OpcodeEnum.JLE);
		mOpcodes.put(0x5d0, OpcodeEnum.FEDISI);
		mOpcodes.put(0x717, OpcodeEnum.VMFUNC);
		mOpcodes.put(0xeb4, OpcodeEnum.VPCMPGTW);
		mOpcodes.put(0x815, OpcodeEnum.PFCMPEQ);
		mOpcodes.put(0x16a9, OpcodeEnum.VCMPORD_SSS);
		mOpcodes.put(0xfae, OpcodeEnum.PSHUFW);
		mOpcodes.put(0x24ff, OpcodeEnum.VPEXTRB);
		mOpcodes.put(0x1ac5, OpcodeEnum.VCVTDQ2PD);
		mOpcodes.put(0xf85, OpcodeEnum.VMOVQ);
		mOpcodes.put(0x483, OpcodeEnum.FLDL2E);
		mOpcodes.put(0x2518, OpcodeEnum.VPEXTRD);
		mOpcodes.put(0x1d34, OpcodeEnum.VPHSUBW);
		mOpcodes.put(0x2290, OpcodeEnum.VFNMSUB213PS);
		mOpcodes.put(0x21fd, OpcodeEnum.VFMADD213PD);
		mOpcodes.put(0x745, OpcodeEnum.STGI);
		mOpcodes.put(0x4bd, OpcodeEnum.FPATAN);
		mOpcodes.put(0x2521, OpcodeEnum.VPEXTRQ);
		mOpcodes.put(0x437, OpcodeEnum.FST);
		mOpcodes.put(0x168, OpcodeEnum.INT_3);
		mOpcodes.put(0x598, OpcodeEnum.FIST);
		mOpcodes.put(0x2727, OpcodeEnum.VMCLEAR);
		mOpcodes.put(0x1e81, OpcodeEnum.PMOVSXBQ);
		mOpcodes.put(0x42, OpcodeEnum.AAA);
		mOpcodes.put(0x1d45, OpcodeEnum.VPHSUBD);
		mOpcodes.put(0xa4d, OpcodeEnum.CVTTPS2PI);
		mOpcodes.put(0x115b, OpcodeEnum.CMPNEQPS);
		mOpcodes.put(0x156b, OpcodeEnum.VCMPGE_OQPD);
		mOpcodes.put(0x1b74, OpcodeEnum.LDDQU);
		mOpcodes.put(0xb85, OpcodeEnum.RSQRTPS);
		mOpcodes.put(0xc65, OpcodeEnum.VADDPD);
		mOpcodes.put(0x7c4, OpcodeEnum.PFRCP);
		mOpcodes.put(0xccd, OpcodeEnum.CVTSS2SD);
		mOpcodes.put(0x21a2, OpcodeEnum.VFNMSUB132SD);
		mOpcodes.put(0x632, OpcodeEnum.FDIVRP);
		mOpcodes.put(0x641, OpcodeEnum.FBLD);
		mOpcodes.put(0x361, OpcodeEnum.CPUID);
		mOpcodes.put(0x251, OpcodeEnum.RDTSC);
		mOpcodes.put(0x24da, OpcodeEnum.VPBLENDW);
		mOpcodes.put(0xd37, OpcodeEnum.VCVTPS2DQ);
		mOpcodes.put(0x1b2e, OpcodeEnum.VPOR);
		mOpcodes.put(0xc5d, OpcodeEnum.VADDPS);
		mOpcodes.put(0x787, OpcodeEnum.PI2FW);
		mOpcodes.put(0xd8a, OpcodeEnum.MINPS);
		mOpcodes.put(0x17db, OpcodeEnum.VCMPEQ_OSSD);
		mOpcodes.put(0x1bb9, OpcodeEnum.VPMULUDQ);
		mOpcodes.put(0xe17, OpcodeEnum.MAXSD);
		mOpcodes.put(0x205c, OpcodeEnum.VPMULLD);
		mOpcodes.put(0x558, OpcodeEnum.FIDIVR);
		mOpcodes.put(0xae1, OpcodeEnum.VUCOMISS);
		mOpcodes.put(0x8ac, OpcodeEnum.MOVDDUP);
		mOpcodes.put(0x1cd7, OpcodeEnum.VPSHUFB);
		mOpcodes.put(0x1d4e, OpcodeEnum.PHSUBSW);
		mOpcodes.put(0x2659, OpcodeEnum.VPCMPISTRI);
		mOpcodes.put(0xe10, OpcodeEnum.MAXSS);
		mOpcodes.put(0x1a41, OpcodeEnum.VPAVGB);
		mOpcodes.put(0x16df, OpcodeEnum.VCMPFALSE_OSSS);
		mOpcodes.put(0xd91, OpcodeEnum.MINPD);
		mOpcodes.put(0x4ef, OpcodeEnum.FYL2XP1);
		mOpcodes.put(0xaeb, OpcodeEnum.VUCOMISD);
		mOpcodes.put(0x23b6, OpcodeEnum.VFNMSUB231PD);
		mOpcodes.put(0x1855, OpcodeEnum.VCMPNGE_UQSD);
		mOpcodes.put(0xc56, OpcodeEnum.ADDSD);
		mOpcodes.put(0x6e3, OpcodeEnum.VMXOFF);
		mOpcodes.put(0x1964, OpcodeEnum.PSRLQ);
		mOpcodes.put(0x129b, OpcodeEnum.VCMPNEQPS);
		mOpcodes.put(0x1946, OpcodeEnum.PSRLW);
		mOpcodes.put(0x1a58, OpcodeEnum.PSRAD);
		mOpcodes.put(0x6a1, OpcodeEnum.SIDT);
		mOpcodes.put(0xe83, OpcodeEnum.PACKSSWB);
		mOpcodes.put(0x10bb, OpcodeEnum.XSAVE);
		mOpcodes.put(0x142d, OpcodeEnum.VCMPNEQPD);
		mOpcodes.put(0xfa, OpcodeEnum.CDQ);
		mOpcodes.put(0xc4f, OpcodeEnum.ADDSS);
		mOpcodes.put(0x16c3, OpcodeEnum.VCMPNGE_UQSS);
		mOpcodes.put(0x244c, OpcodeEnum.CRC32);
		mOpcodes.put(0x23e8, OpcodeEnum.VAESIMC);
		mOpcodes.put(0x2010, OpcodeEnum.PMAXSB);
		mOpcodes.put(0x2535, OpcodeEnum.VEXTRACTPS);
		mOpcodes.put(0x181f, OpcodeEnum.VCMPNLT_UQSD);
		mOpcodes.put(0x1c11, OpcodeEnum.VPSUBB);
		mOpcodes.put(0x1f99, OpcodeEnum.VPMOVZXWQ);
		mOpcodes.put(0x13cb, OpcodeEnum.VCMPNEQ_OSPS);
		mOpcodes.put(0xa27, OpcodeEnum.MOVNTSS);
		mOpcodes.put(0x254e, OpcodeEnum.VEXTRACTF128);
		mOpcodes.put(0x1b34, OpcodeEnum.PADDSB);
		mOpcodes.put(0x75, OpcodeEnum.IMUL);
		mOpcodes.put(0x3d6, OpcodeEnum.RCR);
		mOpcodes.put(0x14de, OpcodeEnum.VCMPUNORD_SPD);
		mOpcodes.put(0x3d1, OpcodeEnum.RCL);
		mOpcodes.put(0xa30, OpcodeEnum.MOVNTSD);
		mOpcodes.put(0x155d, OpcodeEnum.VCMPNEQ_OSPD);
		mOpcodes.put(0x168d, OpcodeEnum.VCMPNLT_UQSS);
		mOpcodes.put(0xd63, OpcodeEnum.SUBSD);
		mOpcodes.put(0x13f, OpcodeEnum.SCAS);
		mOpcodes.put(0x25d1, OpcodeEnum.PCLMULQDQ);
		mOpcodes.put(0x7cb, OpcodeEnum.PFRSQRT);
		mOpcodes.put(0x2582, OpcodeEnum.PINSRD);
		mOpcodes.put(0x623, OpcodeEnum.FSUBRP);
		mOpcodes.put(0x5b, OpcodeEnum.PUSHA);
		mOpcodes.put(0x1a22, OpcodeEnum.VPMAXUB);
		mOpcodes.put(0x114f, OpcodeEnum.CMPUNORDPS);
		mOpcodes.put(0x204b, OpcodeEnum.VPMAXUD);
		mOpcodes.put(0x463, OpcodeEnum.FABS);
		mOpcodes.put(0x1e8b, OpcodeEnum.VPMOVSXBQ);
		mOpcodes.put(0x14ab, OpcodeEnum.VCMPTRUEPD);
		mOpcodes.put(0x23e, OpcodeEnum.FEMMS);
		mOpcodes.put(0x1649, OpcodeEnum.VCMPEQ_OSSS);
		mOpcodes.put(0x2217, OpcodeEnum.VFMADD213SD);
		mOpcodes.put(0x1e76, OpcodeEnum.VPMOVSXBD);
		mOpcodes.put(0x119e, OpcodeEnum.CMPUNORDPD);
		mOpcodes.put(0x1913, OpcodeEnum.VMPTRST);
		mOpcodes.put(0x1907, OpcodeEnum.CMPXCHG16B);
		mOpcodes.put(0x1319, OpcodeEnum.VCMPTRUEPS);
		mOpcodes.put(0x12df, OpcodeEnum.VCMPNGTPS);
		mOpcodes.put(0x1c93, OpcodeEnum.FNCLEX);
		mOpcodes.put(0x1248, OpcodeEnum.CMPNEQSD);
		mOpcodes.put(0x177d, OpcodeEnum.VCMPEQ_UQSD);
		mOpcodes.put(0x579, OpcodeEnum.FCMOVU);
		mOpcodes.put(0x104a, OpcodeEnum.EXTRQ);
		mOpcodes.put(0x25b1, OpcodeEnum.DPPD);
		mOpcodes.put(0x2e2, OpcodeEnum.CMOVGE);
		mOpcodes.put(0x255c, OpcodeEnum.PINSRB);
		mOpcodes.put(0x15eb, OpcodeEnum.VCMPEQ_UQSS);
		mOpcodes.put(0x1d20, OpcodeEnum.VPMADDUBSW);
		mOpcodes.put(0x11f9, OpcodeEnum.CMPNEQSS);
		mOpcodes.put(0x2315, OpcodeEnum.VFMADD231PD);
		mOpcodes.put(0x519, OpcodeEnum.FSIN);
		mOpcodes.put(0x1bf, OpcodeEnum.IN);
		mOpcodes.put(0x568, OpcodeEnum.FCMOVE);
		mOpcodes.put(0x44a, OpcodeEnum.FLDCW);
		mOpcodes.put(0x25a4, OpcodeEnum.DPPS);
		mOpcodes.put(0x560, OpcodeEnum.FCMOVB);
		mOpcodes.put(0x194d, OpcodeEnum.VPSRLW);
		mOpcodes.put(0x10cb, OpcodeEnum.LFENCE);
		mOpcodes.put(0xaaf, OpcodeEnum.CVTSD2SI);
		mOpcodes.put(0x30c, OpcodeEnum.SETAE);
		mOpcodes.put(0x2a6, OpcodeEnum.CMOVNZ);
		mOpcodes.put(0x196b, OpcodeEnum.VPSRLQ);
		mOpcodes.put(0x614, OpcodeEnum.FMULP);
		mOpcodes.put(0x9ce, OpcodeEnum.VMOVAPD);
		mOpcodes.put(0x1663, OpcodeEnum.VCMPLE_OQSS);
		mOpcodes.put(0x2c4, OpcodeEnum.CMOVNS);
		mOpcodes.put(0x5ae, OpcodeEnum.FCMOVNE);
		mOpcodes.put(0x288, OpcodeEnum.CMOVNO);
		mOpcodes.put(0x1a91, OpcodeEnum.VPMULHW);
		mOpcodes.put(0x195c, OpcodeEnum.VPSRLD);
		mOpcodes.put(0x106d, OpcodeEnum.CVTPS2PH);
		mOpcodes.put(0xa91, OpcodeEnum.CVTPS2PI);
		mOpcodes.put(0x1cf1, OpcodeEnum.PHADDD);
		mOpcodes.put(0xcb9, OpcodeEnum.CVTPS2PD);
		mOpcodes.put(0x1e40, OpcodeEnum.VPABSW);
		mOpcodes.put(0x17f5, OpcodeEnum.VCMPLE_OQSD);
		mOpcodes.put(0x9c5, OpcodeEnum.VMOVAPS);
		mOpcodes.put(0x1c20, OpcodeEnum.VPSUBW);
		mOpcodes.put(0x82f, OpcodeEnum.PMULHRW);
		mOpcodes.put(0x9b5, OpcodeEnum.MOVAPS);
		mOpcodes.put(0x7bd, OpcodeEnum.PFMIN);
		mOpcodes.put(0xf72, OpcodeEnum.MOVD);
		mOpcodes.put(0x943, OpcodeEnum.MOVHPS);
		mOpcodes.put(0xc7d, OpcodeEnum.MULPS);
		mOpcodes.put(0x127a, OpcodeEnum.VCMPLTPS);
		mOpcodes.put(0x368, OpcodeEnum.BT);
		mOpcodes.put(0x9bd, OpcodeEnum.MOVAPD);
		mOpcodes.put(0x139f, OpcodeEnum.VCMPNGE_UQPS);
		mOpcodes.put(0x1b8, OpcodeEnum.JRCXZ);
		mOpcodes.put(0xc84, OpcodeEnum.MULPD);
		mOpcodes.put(0x127, OpcodeEnum.MOVS);
		mOpcodes.put(0x6bf, OpcodeEnum.INVLPG);
		mOpcodes.put(0xf78, OpcodeEnum.MOVQ);
		mOpcodes.put(0xdae, OpcodeEnum.VMINPD);
		mOpcodes.put(0x1e48, OpcodeEnum.PABSD);
		mOpcodes.put(0x11b, OpcodeEnum.SAHF);
		mOpcodes.put(0x13f3, OpcodeEnum.VCMPTRUE_USPS);
		mOpcodes.put(0x78e, OpcodeEnum.PI2FD);
		mOpcodes.put(0x1e2a, OpcodeEnum.PABSB);
		mOpcodes.put(0x1a32, OpcodeEnum.VPANDN);
		mOpcodes.put(0xe77, OpcodeEnum.VPUNPCKLDQ);
		mOpcodes.put(0x63a, OpcodeEnum.FDIVP);
		mOpcodes.put(0x1c37, OpcodeEnum.PSUBQ);
		mOpcodes.put(0x42b, OpcodeEnum.FDIVR);
		mOpcodes.put(0x425, OpcodeEnum.FDIV);
		mOpcodes.put(0x1585, OpcodeEnum.VCMPTRUE_USPD);
		mOpcodes.put(0x772, OpcodeEnum.PREFETCH);
		mOpcodes.put(0x1026, OpcodeEnum.EMMS);
		mOpcodes.put(0xda6, OpcodeEnum.VMINPS);
		mOpcodes.put(0x2308, OpcodeEnum.VFMADD231PS);
		mOpcodes.put(0x229e, OpcodeEnum.VFNMSUB213PD);
		mOpcodes.put(0xaa5, OpcodeEnum.CVTSS2SI);
		mOpcodes.put(0x94b, OpcodeEnum.MOVHPD);
		mOpcodes.put(0x29f, OpcodeEnum.CMOVZ);
		mOpcodes.put(0x1a6e, OpcodeEnum.VPAVGW);
		mOpcodes.put(0xff, OpcodeEnum.CQO);
		mOpcodes.put(0x1c2f, OpcodeEnum.VPSUBD);
		mOpcodes.put(0x2cc, OpcodeEnum.CMOVP);
		mOpcodes.put(0x1594, OpcodeEnum.VCMPEQSS);
		mOpcodes.put(0x2bd, OpcodeEnum.CMOVS);
		mOpcodes.put(0x1e6c, OpcodeEnum.PMOVSXBD);
		mOpcodes.put(0x248e, OpcodeEnum.VROUNDSS);
		mOpcodes.put(0x1c3e, OpcodeEnum.VPSUBQ);
		mOpcodes.put(0x2db, OpcodeEnum.CMOVL);
		mOpcodes.put(0x1926, OpcodeEnum.ADDSUBPS);
		mOpcodes.put(0x281, OpcodeEnum.CMOVO);
		mOpcodes.put(0x2b6, OpcodeEnum.CMOVA);
		mOpcodes.put(0x290, OpcodeEnum.CMOVB);
		mOpcodes.put(0xee6, OpcodeEnum.PUNPCKHBW);
		mOpcodes.put(0x264e, OpcodeEnum.PCMPISTRI);
		mOpcodes.put(0x2f2, OpcodeEnum.CMOVG);
		mOpcodes.put(0x19af, OpcodeEnum.VPMOVMSKB);
		mOpcodes.put(0x242c, OpcodeEnum.AESDECLAST);
		mOpcodes.put(0x851, OpcodeEnum.MOVUPD);
		mOpcodes.put(0x20c8, OpcodeEnum.VFMSUBADD132PD);
		mOpcodes.put(0x1bde, OpcodeEnum.VPSADBW);
		mOpcodes.put(0x3f7, OpcodeEnum.XBEGIN);
		mOpcodes.put(0x247b, OpcodeEnum.VROUNDPD);
		mOpcodes.put(0x6b9, OpcodeEnum.LMSW);
		mOpcodes.put(0x207e, OpcodeEnum.INVEPT);
		mOpcodes.put(0x39f, OpcodeEnum.MOVZX);
		mOpcodes.put(0xbc9, OpcodeEnum.ANDPS);
		mOpcodes.put(0x20b8, OpcodeEnum.VFMSUBADD132PS);
		mOpcodes.put(0x849, OpcodeEnum.MOVUPS);
		mOpcodes.put(0x1633, OpcodeEnum.VCMPGTSS);
		mOpcodes.put(0x1a76, OpcodeEnum.PMULHUW);
		mOpcodes.put(0x25b7, OpcodeEnum.VDPPD);
		mOpcodes.put(0x2508, OpcodeEnum.PEXTRD);
		mOpcodes.put(0x160e, OpcodeEnum.VCMPFALSESS);
		mOpcodes.put(0x26da, OpcodeEnum.RDGSBASE);
		mOpcodes.put(0x1b, OpcodeEnum.OR);
		mOpcodes.put(0x18d1, OpcodeEnum.VPEXTRW);
		mOpcodes.put(0x1afe, OpcodeEnum.VPSUBSB);
		mOpcodes.put(0x26c6, OpcodeEnum.FXRSTOR);
		mOpcodes.put(0x21d, OpcodeEnum.CLTS);
		mOpcodes.put(0x1863, OpcodeEnum.VCMPNGT_UQSD);
		mOpcodes.put(0x1603, OpcodeEnum.VCMPNGTSS);
		mOpcodes.put(0x5ef, OpcodeEnum.FRSTOR);
		mOpcodes.put(0x17a0, OpcodeEnum.VCMPFALSESD);
		mOpcodes.put(0x49a, OpcodeEnum.FLDLN2);
		mOpcodes.put(0x2541, OpcodeEnum.VINSERTF128);
		mOpcodes.put(0x1b0f, OpcodeEnum.VPSUBSW);
		mOpcodes.put(0x1bb0, OpcodeEnum.PMULUDQ);
		mOpcodes.put(0x56, OpcodeEnum.DEC);
		mOpcodes.put(0x13bb, OpcodeEnum.VCMPFALSE_OSPS);
		mOpcodes.put(0x432, OpcodeEnum.FLD);
		mOpcodes.put(0x1fae, OpcodeEnum.VPMOVZXDQ);
		mOpcodes.put(0x2485, OpcodeEnum.ROUNDSS);
		mOpcodes.put(0x9ff, OpcodeEnum.VCVTSI2SS);
		mOpcodes.put(0x18c9, OpcodeEnum.PEXTRW);
		mOpcodes.put(0x26b2, OpcodeEnum.FXSAVE64);
		mOpcodes.put(0x3c7, OpcodeEnum.ROL);
		mOpcodes.put(0x20ff, OpcodeEnum.VFMADD132SD);
		mOpcodes.put(0x1195, OpcodeEnum.CMPLEPD);
		mOpcodes.put(0xd02, OpcodeEnum.VCVTSD2SS);
		mOpcodes.put(0x605, OpcodeEnum.FUCOMP);
		mOpcodes.put(0x1ce, OpcodeEnum.JMP);
		mOpcodes.put(0x1726, OpcodeEnum.VCMPEQSD);
		mOpcodes.put(0xd0d, OpcodeEnum.CVTDQ2PS);
		mOpcodes.put(0x170a, OpcodeEnum.VCMPGT_OQSS);
		mOpcodes.put(0x5e0, OpcodeEnum.FUCOMI);
		mOpcodes.put(0x112d, OpcodeEnum.LZCNT);
		mOpcodes.put(0xbb9, OpcodeEnum.VRCPPS);
		mOpcodes.put(0x1a1a, OpcodeEnum.PMAXUB);
		mOpcodes.put(0x1cf9, OpcodeEnum.VPHADDD);
		mOpcodes.put(0xa0a, OpcodeEnum.VCVTSI2SD);
		mOpcodes.put(0x189c, OpcodeEnum.VCMPGT_OQSD);
		mOpcodes.put(0x3cc, OpcodeEnum.ROR);
		mOpcodes.put(0x22b, OpcodeEnum.INVD);
		mOpcodes.put(0xac4, OpcodeEnum.VCVTSD2SI);
		mOpcodes.put(0x241b, OpcodeEnum.AESDEC);
		mOpcodes.put(0x125c, OpcodeEnum.CMPNLESD);
		mOpcodes.put(0x354, OpcodeEnum.SETLE);
		mOpcodes.put(0x22e8, OpcodeEnum.VFMSUBADD231PS);
		mOpcodes.put(0x2370, OpcodeEnum.VFNMADD231PS);
		mOpcodes.put(0x10c2, OpcodeEnum.XSAVE64);
		mOpcodes.put(0xefd, OpcodeEnum.PUNPCKHWD);
		mOpcodes.put(0x1ea0, OpcodeEnum.VPMOVSXWD);
		mOpcodes.put(0xcc3, OpcodeEnum.CVTPD2PS);
		mOpcodes.put(0x8b5, OpcodeEnum.VMOVHLPS);
		mOpcodes.put(0x22f8, OpcodeEnum.VFMSUBADD231PD);
		mOpcodes.put(0xa9b, OpcodeEnum.CVTPD2PI);
		mOpcodes.put(0xbef, OpcodeEnum.ANDNPD);
		mOpcodes.put(0x1ed5, OpcodeEnum.PMULDQ);
		mOpcodes.put(0x1eb5, OpcodeEnum.VPMOVSXWQ);
		mOpcodes.put(0x175c, OpcodeEnum.VCMPNLTSD);
		mOpcodes.put(0x210c, OpcodeEnum.VFMSUB132PS);
		mOpcodes.put(0x237e, OpcodeEnum.VFNMADD231PD);
		mOpcodes.put(0x1cc8, OpcodeEnum.FSTSW);
		mOpcodes.put(0x76a, OpcodeEnum.RDTSCP);
		mOpcodes.put(0x10e5, OpcodeEnum.MFENCE);
		mOpcodes.put(0x20f2, OpcodeEnum.VFMADD132SS);
		mOpcodes.put(0x1fff, OpcodeEnum.PMINUD);
		mOpcodes.put(0x5ca, OpcodeEnum.FENI);
		mOpcodes.put(0x68, OpcodeEnum.BOUND);
		mOpcodes.put(0x2468, OpcodeEnum.VROUNDPS);
		mOpcodes.put(0xfc7, OpcodeEnum.PSHUFLW);
		mOpcodes.put(0xca9, OpcodeEnum.VMULSS);
		mOpcodes.put(0x1871, OpcodeEnum.VCMPFALSE_OSSD);
		mOpcodes.put(0xd2c, OpcodeEnum.VCVTDQ2PS);
		mOpcodes.put(0x15a8, OpcodeEnum.VCMPLESS);
		mOpcodes.put(0x457, OpcodeEnum.FNOP);
		mOpcodes.put(0x1165, OpcodeEnum.CMPNLTPS);
		mOpcodes.put(0x12a6, OpcodeEnum.VCMPNLTPS);
		mOpcodes.put(0x492, OpcodeEnum.FLDLG2);
		mOpcodes.put(0x223, OpcodeEnum.SYSRET);
		mOpcodes.put(0x1c8c, OpcodeEnum.FSTCW);
		mOpcodes.put(0x223e, OpcodeEnum.VFMSUB213SS);
		mOpcodes.put(0x751, OpcodeEnum.SKINIT);
		mOpcodes.put(0xbdf, OpcodeEnum.VANDPD);
		mOpcodes.put(0x4a2, OpcodeEnum.FLDZ);
		mOpcodes.put(0x33, OpcodeEnum.SUB);
		mOpcodes.put(0x1ce8, OpcodeEnum.VPHADDW);
		mOpcodes.put(0x664, OpcodeEnum.NEG);
		mOpcodes.put(0x1fee, OpcodeEnum.PMINUW);
		mOpcodes.put(0xe09, OpcodeEnum.MAXPD);
		mOpcodes.put(0x1385, OpcodeEnum.VCMPORD_SPS);
		mOpcodes.put(0x133, OpcodeEnum.STOS);
		mOpcodes.put(0x23d2, OpcodeEnum.VFNMSUB231SD);
		mOpcodes.put(0x1744, OpcodeEnum.VCMPUNORDSD);
		mOpcodes.put(0x840, OpcodeEnum.PAVGUSB);
		mOpcodes.put(0x1517, OpcodeEnum.VCMPORD_SPD);
		mOpcodes.put(0xe02, OpcodeEnum.MAXPS);
		mOpcodes.put(0x19e0, OpcodeEnum.PMINUB);
		mOpcodes.put(0x1bfd, OpcodeEnum.VMASKMOVDQU);
		mOpcodes.put(0x647, OpcodeEnum.FBSTP);
		mOpcodes.put(0x18b8, OpcodeEnum.PINSRW);
		mOpcodes.put(0x1f84, OpcodeEnum.VPMOVZXWD);
		mOpcodes.put(0x1ff6, OpcodeEnum.VPMINUW);
		mOpcodes.put(0x182d, OpcodeEnum.VCMPNLE_UQSD);
		mOpcodes.put(0x18a, OpcodeEnum.SALC);
		mOpcodes.put(0x24f7, OpcodeEnum.PEXTRB);
		mOpcodes.put(0x8fa, OpcodeEnum.VUNPCKLPS);
		mOpcodes.put(0x169b, OpcodeEnum.VCMPNLE_UQSS);
		mOpcodes.put(0xf8c, OpcodeEnum.MOVDQA);
		mOpcodes.put(0x15ca, OpcodeEnum.VCMPNLTSS);
		mOpcodes.put(0x1ba1, OpcodeEnum.PSLLQ);
		mOpcodes.put(0xa39, OpcodeEnum.VMOVNTPS);
		mOpcodes.put(0x2007, OpcodeEnum.VPMINUD);
		mOpcodes.put(0x984, OpcodeEnum.PREFETCHNTA);
		mOpcodes.put(0x905, OpcodeEnum.VUNPCKLPD);
		mOpcodes.put(0x1063, OpcodeEnum.CVTPH2PS);
		mOpcodes.put(0x2676, OpcodeEnum.VAESKEYGENASSIST);
		mOpcodes.put(0x1b07, OpcodeEnum.PSUBSW);
		mOpcodes.put(0x178a, OpcodeEnum.VCMPNGESD);
		mOpcodes.put(0x1c73, OpcodeEnum.FNSTENV);
		mOpcodes.put(0x1cc0, OpcodeEnum.FNSTSW);
		mOpcodes.put(0x11aa, OpcodeEnum.CMPNEQPD);
		mOpcodes.put(0x1a67, OpcodeEnum.PAVGW);
		mOpcodes.put(0xa1e, OpcodeEnum.MOVNTPD);
		mOpcodes.put(0x1524, OpcodeEnum.VCMPEQ_USPD);
		mOpcodes.put(0x5d8, OpcodeEnum.FSETPM);
		mOpcodes.put(0x1ddb, OpcodeEnum.BLENDVPS);
		mOpcodes.put(0x21c0, OpcodeEnum.VFMADDSUB213PD);
		mOpcodes.put(0xb, OpcodeEnum.ADD);
		mOpcodes.put(0x15f8, OpcodeEnum.VCMPNGESS);
		mOpcodes.put(0x1f, OpcodeEnum.ADC);
		mOpcodes.put(0x1af6, OpcodeEnum.PSUBSB);
		mOpcodes.put(0x1de5, OpcodeEnum.BLENDVPD);
		mOpcodes.put(0xef1, OpcodeEnum.VPUNPCKHBW);
		mOpcodes.put(0x25f, OpcodeEnum.RDPMC);
		mOpcodes.put(0xa15, OpcodeEnum.MOVNTPS);
		mOpcodes.put(0x111c, OpcodeEnum.BSF);
		mOpcodes.put(0x140c, OpcodeEnum.VCMPLTPD);
		mOpcodes.put(0x1a3a, OpcodeEnum.PAVGB);
		mOpcodes.put(0xdf, OpcodeEnum.LEA);
		mOpcodes.put(0x1ab9, OpcodeEnum.VCVTTPD2DQ);
		mOpcodes.put(0xea1, OpcodeEnum.VPCMPGTB);
		mOpcodes.put(0xec7, OpcodeEnum.VPCMPGTD);
		mOpcodes.put(0x475, OpcodeEnum.FLD1);
		mOpcodes.put(0x1bcc, OpcodeEnum.VPMADDWD);
		mOpcodes.put(0x1802, OpcodeEnum.VCMPUNORD_SSD);
		mOpcodes.put(0x14a, OpcodeEnum.LES);
		mOpcodes.put(0x313, OpcodeEnum.SETZ);
		mOpcodes.put(0x1fc2, OpcodeEnum.VPCMPGTQ);
		mOpcodes.put(0xcb1, OpcodeEnum.VMULSD);
		mOpcodes.put(0x21f0, OpcodeEnum.VFMADD213PS);
		mOpcodes.put(0x15d5, OpcodeEnum.VCMPNLESS);
		mOpcodes.put(0x889, OpcodeEnum.MOVHLPS);
		mOpcodes.put(0x2071, OpcodeEnum.VPHMINPOSUW);
		mOpcodes.put(0x1e4f, OpcodeEnum.VPABSD);
		mOpcodes.put(0x1a49, OpcodeEnum.PSRAW);
		mOpcodes.put(0x7db, OpcodeEnum.PFADD);
		mOpcodes.put(0x20a8, OpcodeEnum.VFMADDSUB132PD);
		mOpcodes.put(0xafd, OpcodeEnum.COMISD);
		mOpcodes.put(0x13d9, OpcodeEnum.VCMPGE_OQPS);
		mOpcodes.put(0xe2e, OpcodeEnum.VMAXSS);
		mOpcodes.put(0x123c, OpcodeEnum.CMPUNORDSD);
		mOpcodes.put(0x4ff, OpcodeEnum.FSINCOS);
		mOpcodes.put(0xaf5, OpcodeEnum.COMISS);
		mOpcodes.put(0x2098, OpcodeEnum.VFMADDSUB132PS);
		mOpcodes.put(0xbab, OpcodeEnum.RCPPS);
		mOpcodes.put(0x214e, OpcodeEnum.VFNMADD132PD);
		mOpcodes.put(0x451, OpcodeEnum.FXCH);
		mOpcodes.put(0x2e, OpcodeEnum.DAA);
		mOpcodes.put(0x320, OpcodeEnum.SETBE);
		mOpcodes.put(0xce1, OpcodeEnum.VCVTPS2PD);
		mOpcodes.put(0x1bc3, OpcodeEnum.PMADDWD);
		mOpcodes.put(0xbd0, OpcodeEnum.ANDPD);
		mOpcodes.put(0x133f, OpcodeEnum.VCMPLE_OQPS);
		mOpcodes.put(0x1795, OpcodeEnum.VCMPNGTSD);
		mOpcodes.put(0x23a8, OpcodeEnum.VFNMSUB231PS);
		mOpcodes.put(0x64e, OpcodeEnum.FUCOMIP);
		mOpcodes.put(0xc99, OpcodeEnum.VMULPS);
		mOpcodes.put(0x2140, OpcodeEnum.VFNMADD132PS);
		mOpcodes.put(0x26ed, OpcodeEnum.WRFSBASE);
		mOpcodes.put(0x38, OpcodeEnum.DAS);
		mOpcodes.put(0x14d1, OpcodeEnum.VCMPLE_OQPD);
		mOpcodes.put(0x17a, OpcodeEnum.IRET);
		mOpcodes.put(0x3c0, OpcodeEnum.BSWAP);
		mOpcodes.put(0xe3e, OpcodeEnum.PUNPCKLBW);
		mOpcodes.put(0x2032, OpcodeEnum.PMAXUW);
		mOpcodes.put(0x2642, OpcodeEnum.VPCMPISTRM);
		mOpcodes.put(0x1b83, OpcodeEnum.PSLLW);
		mOpcodes.put(0x1670, OpcodeEnum.VCMPUNORD_SSS);
		mOpcodes.put(0x2258, OpcodeEnum.VFNMADD213PS);
		mOpcodes.put(0xa85, OpcodeEnum.VCVTTSD2SI);
		mOpcodes.put(0x2349, OpcodeEnum.VFMSUB231PD);
		mOpcodes.put(0x13ad, OpcodeEnum.VCMPNGT_UQPS);
		mOpcodes.put(0x1c84, OpcodeEnum.FNSTCW);
		mOpcodes.put(0x2498, OpcodeEnum.ROUNDSD);
		mOpcodes.put(0x11be, OpcodeEnum.CMPNLEPD);
		mOpcodes.put(0x2510, OpcodeEnum.PEXTRQ);
		mOpcodes.put(0x1a89, OpcodeEnum.PMULHW);
		mOpcodes.put(0x1d0b, OpcodeEnum.VPHADDSW);
		mOpcodes.put(0x59e, OpcodeEnum.FISTP);
		mOpcodes.put(0x1f8f, OpcodeEnum.PMOVZXWQ);
		mOpcodes.put(0xcec, OpcodeEnum.VCVTPD2PS);
		mOpcodes.put(0x1717, OpcodeEnum.VCMPTRUE_USSS);
		mOpcodes.put(0xc75, OpcodeEnum.VADDSD);
		mOpcodes.put(0x1dd1, OpcodeEnum.PBLENDVB);
		mOpcodes.put(0x6d9, OpcodeEnum.VMRESUME);
		mOpcodes.put(0xad8, OpcodeEnum.UCOMISD);
		mOpcodes.put(0x1f7a, OpcodeEnum.PMOVZXWD);
		mOpcodes.put(0xa58, OpcodeEnum.CVTTPD2PI);
		mOpcodes.put(0xacf, OpcodeEnum.UCOMISS);
		mOpcodes.put(0xe8d, OpcodeEnum.VPACKSSWB);
		mOpcodes.put(0xc6d, OpcodeEnum.VADDSS);
		mOpcodes.put(0xfbe, OpcodeEnum.PSHUFHW);
		mOpcodes.put(0x18a9, OpcodeEnum.VCMPTRUE_USSD);
		mOpcodes.put(0x6f4, OpcodeEnum.MWAIT);
	}
}
