/** @file readwritelockable.h  Read-write lock.
 *
 * @authors Copyright © 2013-2017 Jaakko Keränen <jaakko.keranen@iki.fi>
 *
 * @par License
 * LGPL: http://www.gnu.org/licenses/lgpl.html
 *
 * <small>This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at your
 * option) any later version. This program is distributed in the hope that it
 * will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
 * General Public License for more details. You should have received a copy of
 * the GNU Lesser General Public License along with this program; if not, see:
 * http://www.gnu.org/licenses</small>
 */

#ifndef LIBDENG2_READWRITELOCKABLE_H
#define LIBDENG2_READWRITELOCKABLE_H

#include "../libcore.h"

namespace de {

/**
 * Read-write lock.
 *
 * @ingroup concurrency
 */
class DENG2_PUBLIC ReadWriteLockable
{
public:
    ReadWriteLockable();
    virtual ~ReadWriteLockable();

    /// Acquire the lock for reading.  Blocks until the operation succeeds.
    void lockForRead() const;

    /// Acquire the lock for writing.  Blocks until the operation succeeds.
    void lockForWrite() const;

    /// Release the lock.
    void unlock() const;

private:
    DENG2_PRIVATE(d)
};

} // namespace de

#endif // LIBDENG2_READWRITELOCKABLE_H
