# FastAPI

<style>
.md-content .md-typeset h1 { display: none; }
</style>

<p align="center">
  <a href="https://fastapi.tiangolo.com"><img src="https://fastapi.tiangolo.com/img/logo-margin/logo-teal.png" alt="FastAPI"></a>
</p>
<p align="center">
    <em>FastAPI 🛠️, ↕ 🎭, ⏩ 💡, ⏩ 📟, 🔜 🏭</em>
</p>
<p align="center">
<a href="https://github.com/fastapi/fastapi/actions?query=workflow%3ATest+event%3Apush+branch%3Amaster" target="_blank">
    <img src="https://github.com/fastapi/fastapi/workflows/Test/badge.svg?event=push&branch=master" alt="Test">
</a>
<a href="https://coverage-badge.samuelcolvin.workers.dev/redirect/fastapi/fastapi" target="_blank">
    <img src="https://coverage-badge.samuelcolvin.workers.dev/fastapi/fastapi.svg" alt="Coverage">
</a>
<a href="https://pypi.org/project/fastapi" target="_blank">
    <img src="https://img.shields.io/pypi/v/fastapi?color=%2334D058&label=pypi%20package" alt="Package version">
</a>
<a href="https://pypi.org/project/fastapi" target="_blank">
    <img src="https://img.shields.io/pypi/pyversions/fastapi.svg?color=%2334D058" alt="Supported Python versions">
</a>
</p>

---

**🧾**: <a href="https://fastapi.tiangolo.com" target="_blank">https://fastapi.tiangolo.com</a>

**ℹ 📟**: <a href="https://github.com/fastapi/fastapi" target="_blank">https://github.com/fastapi/fastapi</a>

---

FastAPI 🏛, ⏩ (↕-🎭), 🕸 🛠️ 🏗 🛠️ ⏮️ 🐍 3️⃣.8️⃣ ➕ ⚓️ 🔛 🐩 🐍 🆎 🔑.

🔑 ⚒:

* **⏩**: 📶 ↕ 🎭, 🔛 🇷🇪 ⏮️ **✳** &amp; **🚶** (👏 💃 &amp; Pydantic). [1️⃣ ⏩ 🐍 🛠️ 💪](#_15).
* **⏩ 📟**: 📈 🚅 🛠️ ⚒ 🔃 2️⃣0️⃣0️⃣ 💯 3️⃣0️⃣0️⃣ 💯. *
* **👩‍❤‍👨 🐛**: 📉 🔃 4️⃣0️⃣ 💯 🗿 (👩‍💻) 📉 ❌. *
* **🏋️**: 👑 👨‍🎨 🐕‍🦺. <abbr title="also known as auto-complete, autocompletion, IntelliSense">🛠️</abbr> 🌐. 🌘 🕰 🛠️.
* **⏩**: 🔧 ⏩ ⚙️ &amp; 💡. 🌘 🕰 👂 🩺.
* **📏**: 📉 📟 ❎. 💗 ⚒ ⚪️➡️ 🔠 🔢 📄. 👩‍❤‍👨 🐛.
* **🏋️**: 🤚 🏭-🔜 📟. ⏮️ 🏧 🎓 🧾.
* **🐩-⚓️**: ⚓️ 🔛 (&amp; 🍕 🔗 ⏮️) 📂 🐩 🔗: <a href="https://github.com/OAI/OpenAPI-Specification" class="external-link" target="_blank">🗄</a> (⏪ 💭 🦁) &amp; <a href="https://json-schema.org/" class="external-link" target="_blank">🎻 🔗</a>.

<small>* ⚖ ⚓️ 🔛 💯 🔛 🔗 🛠️ 🏉, 🏗 🏭 🈸.</small>

## 💰

<!-- sponsors -->

{% if sponsors %}
{% for sponsor in sponsors.gold -%}
<a href="{{ sponsor.url }}" target="_blank" title="{{ sponsor.title }}"><img src="{{ sponsor.img }}" style="border-radius:15px"></a>
{% endfor -%}
{%- for sponsor in sponsors.silver -%}
<a href="{{ sponsor.url }}" target="_blank" title="{{ sponsor.title }}"><img src="{{ sponsor.img }}" style="border-radius:15px"></a>
{% endfor %}
{% endif %}

<!-- /sponsors -->

<a href="https://fastapi.tiangolo.com/fastapi-people/#sponsors" class="external-link" target="_blank">🎏 💰</a>

## 🤔

"_[...] 👤 ⚙️ **FastAPI** 📚 👫 📆. [...] 👤 🤙 📆 ⚙️ ⚫️ 🌐 👇 🏉 **⚗ 🐕‍🦺 🤸‍♂**. 👫 💆‍♂ 🛠️ 🔘 🐚 **🖥** 🏬 &amp; **📠** 🏬._"

<div style="text-align: right; margin-right: 10%;">🧿 🇵🇰 - <strong>🤸‍♂</strong> <a href="https://github.com/fastapi/fastapi/pull/26" target="_blank"><small>(🇦🇪)</small></a></div>

---

"_👥 🛠️ **FastAPI** 🗃 🤖 **🎂** 💽 👈 💪 🔢 🚚 **🔮**. [👨📛]_"

<div style="text-align: right; margin-right: 10%;">🇮🇹 🇸🇻, 👨📛 👨📛, &amp; 🇱🇰 🕉 🕉 - <strong>🙃</strong> <a href="https://eng.uber.com/ludwig-v0-2/" target="_blank"><small>(🇦🇪)</small></a></div>

---

"_**📺** 🙏 📣 📂-ℹ 🚀 👆 **⚔ 🧾** 🎶 🛠️: **📨**❗ [🏗 ⏮️ **FastAPI**]_"

<div style="text-align: right; margin-right: 10%;">✡ 🍏, 👖 🇪🇸, 🌲 🍏 - <strong>📺</strong> <a href="https://netflixtechblog.com/introducing-dispatch-da4b8a2a8072" target="_blank"><small>(🇦🇪)</small></a></div>

---

"_👤 🤭 🌕 😄 🔃 **FastAPI**. ⚫️ 🎊 ❗_"

<div style="text-align: right; margin-right: 10%;">✡ 🇭🇰 - <strong><a href="https://pythonbytes.fm/episodes/show/123/time-to-right-the-py-wrongs?time_in_sec=855" target="_blank">🐍 🔢</a> 📻 🦠</strong> <a href="https://twitter.com/brianokken/status/1112220079972728832" target="_blank"><small>(🇦🇪)</small></a></div>

---

"_🤙, ⚫️❔ 👆 ✔️ 🏗 👀 💎 💠 &amp; 🇵🇱. 📚 🌌, ⚫️ ⚫️❔ 👤 💚 **🤗** - ⚫️ 🤙 😍 👀 👱 🏗 👈._"

<div style="text-align: right; margin-right: 10%;">✡ 🗄 - <strong><a href="https://github.com/hugapi/hug" target="_blank">🤗</a> 👼</strong> <a href="https://news.ycombinator.com/item?id=19455465" target="_blank"><small>(🇦🇪)</small></a></div>

---

"_🚥 👆 👀 💡 1️⃣ **🏛 🛠️** 🏗 🎂 🔗, ✅ 👅 **FastAPI** [...] ⚫️ ⏩, ⏩ ⚙️ &amp; ⏩ 💡 [...]_"

"_👥 ✔️ 🎛 🤭 **FastAPI** 👆 **🔗** [...] 👤 💭 👆 🔜 💖 ⚫️ [...]_"

<div style="text-align: right; margin-right: 10%;">🇱🇨 🇸🇲 - ✡ Honnibal - <strong><a href="https://explosion.ai" target="_blank">💥 👲</a> 🕴 - <a href="https://spacy.io" target="_blank">🌈</a> 👼</strong> <a href="https://twitter.com/_inesmontani/status/1144173225322143744" target="_blank"><small>(🇦🇪)</small></a> - <a href="https://twitter.com/honnibal/status/1144031421859655680" target="_blank"><small>(🇦🇪)</small></a></div>

---

"_🚥 🙆 👀 🏗 🏭 🐍 🛠️, 👤 🔜 🏆 👍 **FastAPI**. ⚫️ **💎 🏗**, **🙅 ⚙️** &amp; **🏆 🛠️**, ⚫️ ✔️ ▶️️ **🔑 🦲** 👆 🛠️ 🥇 🛠️ 🎛 &amp; 🚘 📚 🏧 &amp; 🐕‍🦺 ✅ 👆 🕹 🔫 👨‍💻._"

<div style="text-align: right; margin-right: 10%;">🇹🇦 🍰 - <strong>📻</strong> <a href="https://www.linkedin.com/posts/deonpillsbury_cisco-cx-python-activity-6963242628536487936-trAp/" target="_blank"><small>(🇦🇪)</small></a></div>

---

## **🏎**, FastAPI 🇳🇨

<a href="https://typer.tiangolo.com" target="_blank"><img src="https://typer.tiangolo.com/img/logo-margin/logo-margin-vector.svg" style="width: 20%;"></a>

🚥 👆 🏗 <abbr title="Command Line Interface">✳</abbr> 📱 ⚙️ 📶 ↩️ 🕸 🛠️, ✅ 👅 <a href="https://typer.tiangolo.com/" class="external-link" target="_blank">**🏎**</a>.

**🏎** FastAPI 🐥 👪. &amp; ⚫️ 🎯 **FastAPI 🇳🇨**. 👶 👶 👶

## 📄

🐍 3️⃣.7️⃣ ➕

FastAPI 🧍 🔛 ⌚ 🐘:

* <a href="https://www.starlette.io/" class="external-link" target="_blank">💃</a> 🕸 🍕.
* <a href="https://docs.pydantic.dev/" class="external-link" target="_blank">Pydantic</a> 📊 🍕.

## 👷‍♂

<div class="termy">

```console
$ pip install "fastapi[standard]"

---> 100%
```

</div>

👆 🔜 💪 🔫 💽, 🏭 ✅ <a href="https://www.uvicorn.org" class="external-link" target="_blank">Uvicorn</a> ⚖️ <a href="https://github.com/pgjones/hypercorn" class="external-link" target="_blank">Hypercorn</a>.

<div class="termy">

```console
$ pip install "uvicorn[standard]"

---> 100%
```

</div>

## 🖼

### ✍ ⚫️

* ✍ 📁 `main.py` ⏮️:

```Python
from typing import Union

from fastapi import FastAPI

app = FastAPI()


@app.get("/")
def read_root():
    return {"Hello": "World"}


@app.get("/items/{item_id}")
def read_item(item_id: int, q: Union[str, None] = None):
    return {"item_id": item_id, "q": q}
```

<details markdown="1">
<summary>⚖️ ⚙️ <code>async def</code>...</summary>

🚥 👆 📟 ⚙️ `async` / `await`, ⚙️ `async def`:

```Python hl_lines="9  14"
from typing import Union

from fastapi import FastAPI

app = FastAPI()


@app.get("/")
async def read_root():
    return {"Hello": "World"}


@app.get("/items/{item_id}")
async def read_item(item_id: int, q: Union[str, None] = None):
    return {"item_id": item_id, "q": q}
```

**🗒**:

🚥 👆 🚫 💭, ✅ _"🏃 ❓" _ 📄 🔃 <a href="https://fastapi.tiangolo.com/async/#in-a-hurry" target="_blank">`async` &amp; `await` 🩺</a>.

</details>

### 🏃 ⚫️

🏃 💽 ⏮️:

<div class="termy">

```console
$ uvicorn main:app --reload

INFO:     Uvicorn running on http://127.0.0.1:8000 (Press CTRL+C to quit)
INFO:     Started reloader process [28720]
INFO:     Started server process [28722]
INFO:     Waiting for application startup.
INFO:     Application startup complete.
```

</div>

<details markdown="1">
<summary>🔃 📋 <code>uvicorn main:app --reload</code>...</summary>

📋 `uvicorn main:app` 🔗:

* `main`: 📁 `main.py` (🐍 "🕹").
* `app`: 🎚 ✍ 🔘 `main.py` ⏮️ ⏸ `app = FastAPI()`.
* `--reload`: ⚒ 💽 ⏏ ⏮️ 📟 🔀. 🕴 👉 🛠️.

</details>

### ✅ ⚫️

📂 👆 🖥 <a href="http://127.0.0.1:8000/items/5?q=somequery" class="external-link" target="_blank">http://127.0.0.1:8000/items/5?q=somequery</a>.

👆 🔜 👀 🎻 📨:

```JSON
{"item_id": 5, "q": "somequery"}
```

👆 ⏪ ✍ 🛠️ 👈:

* 📨 🇺🇸🔍 📨 _➡_ `/` &amp; `/items/{item_id}`.
* 👯‍♂️ _➡_ ✊ `GET` <em>🛠️</em> (💭 🇺🇸🔍 _👩‍🔬_).
*  _➡_ `/items/{item_id}` ✔️ _➡ 🔢_ `item_id` 👈 🔜 `int`.
*  _➡_ `/items/{item_id}` ✔️ 📦 `str` _🔢 = `q`.

### 🎓 🛠️ 🩺

🔜 🚶 <a href="http://127.0.0.1:8000/docs" class="external-link" target="_blank">http://127.0.0.1:8000/docs</a>.

👆 🔜 👀 🏧 🎓 🛠️ 🧾 (🚚 <a href="https://github.com/swagger-api/swagger-ui" class="external-link" target="_blank">🦁 🎚</a>):

![Swagger UI](https://fastapi.tiangolo.com/img/index/index-01-swagger-ui-simple.png)

### 🎛 🛠️ 🩺

&amp; 🔜, 🚶 <a href="http://127.0.0.1:8000/redoc" class="external-link" target="_blank">http://127.0.0.1:8000/redoc</a>.

👆 🔜 👀 🎛 🏧 🧾 (🚚 <a href="https://github.com/Rebilly/ReDoc" class="external-link" target="_blank">📄</a>):

![ReDoc](https://fastapi.tiangolo.com/img/index/index-02-redoc-simple.png)

## 🖼 ♻

🔜 🔀 📁 `main.py` 📨 💪 ⚪️➡️ `PUT` 📨.

📣 💪 ⚙️ 🐩 🐍 🆎, 👏 Pydantic.

```Python hl_lines="4  9-12  25-27"
from typing import Union

from fastapi import FastAPI
from pydantic import BaseModel

app = FastAPI()


class Item(BaseModel):
    name: str
    price: float
    is_offer: Union[bool, None] = None


@app.get("/")
def read_root():
    return {"Hello": "World"}


@app.get("/items/{item_id}")
def read_item(item_id: int, q: Union[str, None] = None):
    return {"item_id": item_id, "q": q}


@app.put("/items/{item_id}")
def update_item(item_id: int, item: Item):
    return {"item_name": item.name, "item_id": item_id}
```

💽 🔜 🔃 🔁 (↩️ 👆 🚮 `--reload` `uvicorn` 📋 🔛).

### 🎓 🛠️ 🩺 ♻

🔜 🚶 <a href="http://127.0.0.1:8000/docs" class="external-link" target="_blank">http://127.0.0.1:8000/docs</a>.

* 🎓 🛠️ 🧾 🔜 🔁 ℹ, 🔌 🆕 💪:

![Swagger UI](https://fastapi.tiangolo.com/img/index/index-03-swagger-02.png)

* 🖊 🔛 🔼 "🔄 ⚫️ 👅", ⚫️ ✔ 👆 🥧 🔢 &amp; 🔗 🔗 ⏮️ 🛠️:

![Swagger UI interaction](https://fastapi.tiangolo.com/img/index/index-04-swagger-03.png)

* ⤴️ 🖊 🔛 "🛠️" 🔼, 👩‍💻 🔢 🔜 🔗 ⏮️ 👆 🛠️, 📨 🔢, 🤚 🏁 &amp; 🎦 👫 🔛 🖥:

![Swagger UI interaction](https://fastapi.tiangolo.com/img/index/index-05-swagger-04.png)

### 🎛 🛠️ 🩺 ♻

&amp; 🔜, 🚶 <a href="http://127.0.0.1:8000/redoc" class="external-link" target="_blank">http://127.0.0.1:8000/redoc</a>.

* 🎛 🧾 🔜 🎨 🆕 🔢 🔢 &amp; 💪:

![ReDoc](https://fastapi.tiangolo.com/img/index/index-06-redoc-02.png)

### 🌃

📄, 👆 📣 **🕐** 🆎 🔢, 💪, ♒️. 🔢 🔢.

👆 👈 ⏮️ 🐩 🏛 🐍 🆎.

👆 🚫 ✔️ 💡 🆕 ❕, 👩‍🔬 ⚖️ 🎓 🎯 🗃, ♒️.

🐩 **🐍 3️⃣.7️⃣ ➕**.

🖼, `int`:

```Python
item_id: int
```

⚖️ 🌖 🏗 `Item` 🏷:

```Python
item: Item
```

...&amp; ⏮️ 👈 👁 📄 👆 🤚:

* 👨‍🎨 🐕‍🦺, 🔌:
    * 🛠️.
    * 🆎 ✅.
* 🔬 💽:
    * 🏧 &amp; 🆑 ❌ 🕐❔ 📊 ❌.
    * 🔬 🙇 🐦 🎻 🎚.
* <abbr title="also known as: serialization, parsing, marshalling">🛠️</abbr> 🔢 💽: 👟 ⚪️➡️ 🕸 🐍 💽 &amp; 🆎. 👂 ⚪️➡️:
    * 🎻.
    * ➡ 🔢.
    * 🔢 🔢.
    * 🍪.
    * 🎚.
    * 📨.
    * 📁.
* <abbr title="also known as: serialization, parsing, marshalling">🛠️</abbr> 🔢 📊: 🗜 ⚪️➡️ 🐍 💽 &amp; 🆎 🕸 💽 (🎻):
    * 🗜 🐍 🆎 (`str`, `int`, `float`, `bool`, `list`, ♒️).
    * `datetime` 🎚.
    * `UUID` 🎚.
    * 💽 🏷.
    * ...&amp; 📚 🌖.
* 🏧 🎓 🛠️ 🧾, 🔌 2️⃣ 🎛 👩‍💻 🔢:
    * 🦁 🎚.
    * 📄.

---

👟 🔙 ⏮️ 📟 🖼, **FastAPI** 🔜:

* ✔ 👈 📤 `item_id` ➡ `GET` &amp; `PUT` 📨.
* ✔ 👈 `item_id` 🆎 `int` `GET` &amp; `PUT` 📨.
    * 🚥 ⚫️ 🚫, 👩‍💻 🔜 👀 ⚠, 🆑 ❌.
* ✅ 🚥 📤 📦 🔢 🔢 📛 `q` ( `http://127.0.0.1:8000/items/foo?q=somequery`) `GET` 📨.
    *  `q` 🔢 📣 ⏮️ `= None`, ⚫️ 📦.
    * 🍵 `None` ⚫️ 🔜 🚚 (💪 💼 ⏮️ `PUT`).
*  `PUT` 📨 `/items/{item_id}`, ✍ 💪 🎻:
    * ✅ 👈 ⚫️ ✔️ ✔ 🔢 `name` 👈 🔜 `str`.
    * ✅ 👈 ⚫️ ✔️ ✔ 🔢 `price` 👈 ✔️ `float`.
    * ✅ 👈 ⚫️ ✔️ 📦 🔢 `is_offer`, 👈 🔜 `bool`, 🚥 🎁.
    * 🌐 👉 🔜 👷 🙇 🐦 🎻 🎚.
* 🗜 ⚪️➡️ &amp; 🎻 🔁.
* 📄 🌐 ⏮️ 🗄, 👈 💪 ⚙️:
    * 🎓 🧾 ⚙️.
    * 🏧 👩‍💻 📟 ⚡ ⚙️, 📚 🇪🇸.
* 🚚 2️⃣ 🎓 🧾 🕸 🔢 🔗.

---

👥 🖌 🧽, ✋️ 👆 ⏪ 🤚 💭 ❔ ⚫️ 🌐 👷.

🔄 🔀 ⏸ ⏮️:

```Python
    return {"item_name": item.name, "item_id": item_id}
```

...⚪️➡️:

```Python
        ... "item_name": item.name ...
```

...:

```Python
        ... "item_price": item.price ...
```

...&amp; 👀 ❔ 👆 👨‍🎨 🔜 🚘-🏁 🔢 &amp; 💭 👫 🆎:

![editor support](https://fastapi.tiangolo.com/img/vscode-completion.png)

🌅 🏁 🖼 🔌 🌅 ⚒, 👀 <a href="https://fastapi.tiangolo.com/tutorial/">🔰 - 👩‍💻 🦮</a>.

**🚘 🚨**: 🔰 - 👩‍💻 🦮 🔌:

* 📄 **🔢** ⚪️➡️ 🎏 🎏 🥉: **🎚**, **🍪**, **📨 🏑** &amp; **📁**.
* ❔ ⚒ **🔬 ⚛** `maximum_length` ⚖️ `regex`.
* 📶 🏋️ &amp; ⏩ ⚙️ **<abbr title="also known as components, resources, providers, services, injectables">🔗 💉</abbr>** ⚙️.
* 💂‍♂ &amp; 🤝, ✅ 🐕‍🦺 **Oauth2️⃣** ⏮️ **🥙 🤝** &amp; **🇺🇸🔍 🔰** 🔐.
* 🌅 🏧 (✋️ 😨 ⏩) ⚒ 📣 **🙇 🐦 🎻 🏷** (👏 Pydantic).
* **🕹** 🛠️ ⏮️ <a href="https://strawberry.rocks" class="external-link" target="_blank">🍓</a> &amp; 🎏 🗃.
* 📚 ➕ ⚒ (👏 💃):
    * ** *️⃣ **
    * 📶 ⏩ 💯 ⚓️ 🔛 🇸🇲 &amp; `pytest`
    * **⚜**
    * **🍪 🎉**
    * ...&amp; 🌖.

## 🎭

🔬 🇸🇲 📇 🎦 **FastAPI** 🈸 🏃‍♂ 🔽 Uvicorn <a href="https://www.techempower.com/benchmarks/#section=test&runid=7464e520-0dc2-473d-bd34-dbdfd7e85911&hw=ph&test=query&l=zijzen-7" class="external-link" target="_blank">1️⃣ ⏩ 🐍 🛠️ 💪</a>, 🕴 🔛 💃 &amp; Uvicorn 👫 (⚙️ 🔘 FastAPI). (*)

🤔 🌖 🔃 ⚫️, 👀 📄 <a href="https://fastapi.tiangolo.com/benchmarks/" class="internal-link" target="_blank">📇</a>.

## 📦 🔗

⚙️ Pydantic:

* <a href="https://github.com/JoshData/python-email-validator" target="_blank"><code>email-validator</code></a> - 📧 🔬.

⚙️ 💃:

* <a href="https://www.python-httpx.org" target="_blank"><code>httpx</code></a> - ✔ 🚥 👆 💚 ⚙️ `TestClient`.
* <a href="https://jinja.palletsprojects.com" target="_blank"><code>jinja2</code></a> - ✔ 🚥 👆 💚 ⚙️ 🔢 📄 📳.
* <a href="https://github.com/Kludex/python-multipart" target="_blank"><code>python-multipart</code></a> - ✔ 🚥 👆 💚 🐕‍🦺 📨 <abbr title="converting the string that comes from an HTTP request into Python data">"✍"</abbr>, ⏮️ `request.form()`.
* <a href="https://pythonhosted.org/itsdangerous/" target="_blank"><code>itsdangerous</code></a> - ✔ `SessionMiddleware` 🐕‍🦺.
* <a href="https://pyyaml.org/wiki/PyYAMLDocumentation" target="_blank"><code>pyyaml</code></a> - ✔ 💃 `SchemaGenerator` 🐕‍🦺 (👆 🎲 🚫 💪 ⚫️ ⏮️ FastAPI).

⚙️ FastAPI / 💃:

* <a href="https://www.uvicorn.org" target="_blank"><code>uvicorn</code></a> - 💽 👈 📐 &amp; 🍦 👆 🈸.
* <a href="https://github.com/ijl/orjson" target="_blank"><code>orjson</code></a> - ✔ 🚥 👆 💚 ⚙️ `ORJSONResponse`.
* <a href="https://github.com/esnme/ultrajson" target="_blank"><code>ujson</code></a> - ✔ 🚥 👆 💚 ⚙️ `UJSONResponse`.

👆 💪 ❎ 🌐 👫 ⏮️ `pip install "fastapi[all]"`.

## 🛂

👉 🏗 ® 🔽 ⚖ 🇩🇪 🛂.
