/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __CALLABLE_HPP_INCLUDED
#define __CALLABLE_HPP_INCLUDED

#include "frontend/ast/AttributableDeclaration.hpp"
#include "frontend/ast/ValDeclaration.hpp"
#include "frontend/ast/SubprogBody.hpp"
#include "frontend/misc/Driver.hpp"

namespace ast {

/** Abstract declaration of anything that can be called.
 *  Basically a function or a procedure.
 */
class Callable : public AttributableDeclaration {
public:
	//! c'tor
	/** @param declName declared name of the function or procedure.
          * @param args interface of the function or procedure.
	  * @param knd kind of callable
	  * @param loc location of the Callable.
          */
	Callable(
		std::string* declName,
		std::list<ValDeclaration*> *args,
		enum SubprogBody::ProgKind knd,
		Location loc
		) : 	AttributableDeclaration(declName, loc),
			arguments(args),
			kind(knd),
			definition(NULL),
			seen(false),
			containsWait(false) {

		if (this->arguments == NULL) {
			this->arguments = new std::list<ValDeclaration*>();
		}
	}
	
	/** interface of the function or procedure, i.e. list of arguments */
	std::list<ValDeclaration*> *arguments;

	/** kind of subprogram (func/proc) */
	enum SubprogBody::ProgKind kind;

	/** corresponding SubprogBody, in case this Callable has also got an
	 *  implementation.
	 */
	SubprogBody *definition;

	/** only for parser: if true, this declaration is already part of the 
	 *  SyntaxTree and should not get registered.
	 */
	bool seen;

	/** list of drivers */
	std::list<Driver*> drivers;

	/** does the Callable contain a wait statement? 
	 *  (set by WaitConditions visitor) */
	bool containsWait;

protected:
	/** Destructor */
	virtual ~Callable() {
		util::MiscUtil::lterminate(arguments);
		util::MiscUtil::terminate(definition);
	}
};

}; /* namespace ast */

#endif /* __CALLABLE_HPP_INCLUDED */
