/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SEQ_STAT_HPP_INCLUDED
#define __SEQ_STAT_HPP_INCLUDED

#include <string>
#include "frontend/ast/SymbolDeclaration.hpp"

namespace ast {

//! generic sequential statement.
/** generic base class for sequential statements.
 */
class SeqStat : public SymbolDeclaration {
public:
	//! c'tor
	/** @param loc Location of the sequential statement.
	 */
	SeqStat(Location loc) : SymbolDeclaration(NULL, loc) {}

	//! c'tor
	/** 
	 * @param lbl label of the sequential statement.
	 * @param loc Location of the sequential statement.
	 */
	SeqStat(
		std::string *lbl,
		Location loc
		) : 	SymbolDeclaration(lbl, loc) {}
};

}; /* namespace ast */

#endif /* __SEQ_STAT_HPP_INCLUDED */
