import abc
from _typeshed import Incomplete

class Credentials(metaclass=abc.ABCMeta):
    token: Incomplete
    expiry: Incomplete
    def __init__(self) -> None: ...
    @property
    def expired(self): ...
    @property
    def valid(self): ...
    @abc.abstractmethod
    def refresh(self, request): ...
    def apply(self, headers, token: Incomplete | None = None) -> None: ...
    def before_request(self, request, method, url, headers) -> None: ...

class AnonymousCredentials(Credentials):
    @property
    def expired(self): ...
    @property
    def valid(self): ...
    def refresh(self, request) -> None: ...
    def apply(self, headers, token: Incomplete | None = None) -> None: ...
    def before_request(self, request, method, url, headers) -> None: ...

class ReadOnlyScoped(metaclass=abc.ABCMeta):
    def __init__(self) -> None: ...
    @property
    def scopes(self): ...
    @property
    @abc.abstractmethod
    def requires_scopes(self): ...
    def has_scopes(self, scopes): ...

class Scoped(ReadOnlyScoped, metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def with_scopes(self, scopes): ...

def with_scopes_if_required(credentials, scopes): ...

class Signing(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def sign_bytes(self, message): ...
    @property
    @abc.abstractmethod
    def signer_email(self): ...
    @property
    @abc.abstractmethod
    def signer(self): ...
