# 个人博客

麻烦点star，不要fork

> 或许现在很多企业和团队尚未重视前端工程，或许前端工程在很多人眼里还只是“构建工具”的代名词，又或许未来前端领域的变革使得一切工程问题从根本上得到解决。不管怎样，我只是希望当下能认真的记录自己在前端工程领域的所见所想，与正在经历前端工程化改进，并被此过程困扰的同学交流心得。

[欢迎一起探讨各自在前端开发中遇到的工程问题](https://github.com/fouber/blog/issues/8)

目录

* 系列专题
    * [前端工程——基础篇](https://github.com/fouber/blog/issues/10)
* 工程杂谈
    * [浅谈前端集成解决方案](https://github.com/fouber/blog/issues/1)
    * [前端工程与性能优化](https://github.com/fouber/blog/issues/3)
    * [前端开发体系建设日记](https://github.com/fouber/blog/issues/2)
    * [前端开发体与模块化框架](https://github.com/fouber/blog/issues/4)
    * [大公司里怎样开发和部署前端代码？](https://github.com/fouber/blog/issues/6)
    * [如何进行前端自动化测试？](https://github.com/fouber/blog/issues/7)
    * [md5戳计算过程](https://github.com/fouber/blog/issues/5)
* 示例项目
    * [php版静态资源管理系统示例](https://github.com/fouber/static-resource-management-system-demo)
    * [模块化开发组合php版静态资源管理示例](https://github.com/fouber/fis-php-md.js)
    * [java版静态资源管理系统示例](https://github.com/fouber/fis-java-jsp)
    * [静态资源缓存控制演示项目](https://github.com/fouber/static-resource-digest-project)
* 业界实践
    * [前端组件化开发实践](http://tech.meituan.com/frontend-component-practice.html) by 美团 
    * [2015前端组件化框架之路](https://github.com/xufei/blog/issues/19) by [@民工精髓](http://weibo.com/sharpmaster)
    * [前端工程之模块化](http://fex.baidu.com/blog/2014/03/fis-module/) by [@沈洪顺](http://weibo.com/u/1916384703)
    * 前端xss防火墙系列文章 by [@ＥtherＤream](https://github.com/zjcqoo)
        * [内联事件拦截](http://fex.baidu.com/blog/2014/06/xss-frontend-firewall-1/)
        * [可疑模块拦截](http://fex.baidu.com/blog/2014/06/xss-frontend-firewall-2/)
        * [无懈可击的钩子](http://fex.baidu.com/blog/2014/06/xss-frontend-firewall-3/)
        * [天衣无缝的防护](http://fex.baidu.com/blog/2014/06/xss-frontend-firewall-4/)
        * [整装待发](http://fex.baidu.com/blog/2014/06/xss-frontend-firewall-5)
* 经典图书
    * 《[High Performance Web Sites](http://book.douban.com/subject/2084131/)》（[高性能网站建设指南](http://book.douban.com/subject/3132277/)）
    * 《[Even Faster Web Sites](http://book.douban.com/subject/3686503/)》（[高性能网站建设进阶指南](http://book.douban.com/subject/4719162/)）
    * 《[High Performance Browser Networking](http://book.douban.com/subject/21866396/)》（[Web性能权威指南](http://book.douban.com/subject/25856314/)）
* 经典文章
    * [Best Practices for Speeding Up Your Web Site（雅虎35条）](https://developer.yahoo.com/performance/rules.html)
    * [Facebook静态网页资源的管理和优化](http://v.youku.com/v_show/id_XMjI5OTUxMjE2.html) [[PDF](http://velocity.oreilly.com.cn/2010/ppts/VelocityChina2010Dec7StaticResource.pdf)] by [@David Wei](http://weibo.com/weixiaoliang9)
    * [Facebook移动互联网应用的性能优化](http://v.youku.com/v_show/id_XMzUwOTQzMzA4.html) [[PDF](http://velocity.oreilly.com.cn/2011/ppts/MobilePerformanceVelocity2011_DavidWei.pdf)] by [@David Wei](http://weibo.com/weixiaoliang9)
    * [PageSpeed Insights规则](https://developers.google.com/speed/docs/insights/rules?csw=1)
    * [Mobile Analysis in PageSpeed Insights](https://developers.google.com/speed/docs/insights/mobile)
    * Optimizing the Critical Rendering Path for Instant Mobile Websites [[slides](https://docs.google.com/presentation/d/1IRHyU7_crIiCjl0Gvue0WY3eY_eYvFQvSfwQouW9368/present?slide=id.p19),[video](https://www.youtube.com/watch?v=YV1nKLWoARQ)]
    * Instant Mobile Websites: Techniques and Best Practices [[slides](http://storage.googleapis.com/io-2013/presentations/239-%20Instant%20Mobile%20Websites-%20Techniques%20and%20Best%20Practices.pdf), [video](https://www.youtube.com/watch?v=Bzw8-ZLpwtw)]
    * [Critical Rendering Path（关键呈现路径）](https://developers.google.com/web/fundamentals/performance/critical-rendering-path/)
    * [Optimizing Content Efficienc（优化内容效率）](https://developers.google.com/web/fundamentals/performance/optimizing-content-efficiency/?hl=zh-cn)
    * [Rendering（渲染性能）](https://developers.google.com/web/fundamentals/performance/rendering/?hl=zh-cn)
    * [How browsers work](http://taligarsiel.com/Projects/howbrowserswork1.htm)

微博 [@前端农民工](http://www.weibo.com/fouber)
