// Code generated by command: avogen -output zoptab.go optab. DO NOT EDIT.

package x86

import (
	"github.com/mmcloughlin/avo/operand"
	"github.com/mmcloughlin/avo/reg"
)

// maxoperands is the maximum number of operands in an instruction form, including implicit operands.
const maxoperands = 6

type oprndtype uint8

const (
	oprndtypeNone oprndtype = iota
	oprndtype1
	oprndtype3
	oprndtypeAL
	oprndtypeAX
	oprndtypeCL
	oprndtypeEAX
	oprndtypeIMM16
	oprndtypeIMM2U
	oprndtypeIMM32
	oprndtypeIMM64
	oprndtypeIMM8
	oprndtypeK
	oprndtypeM
	oprndtypeM128
	oprndtypeM16
	oprndtypeM256
	oprndtypeM32
	oprndtypeM512
	oprndtypeM64
	oprndtypeM8
	oprndtypeR16
	oprndtypeR32
	oprndtypeR64
	oprndtypeR8
	oprndtypeRAX
	oprndtypeREL32
	oprndtypeREL8
	oprndtypeVM32X
	oprndtypeVM32Y
	oprndtypeVM32Z
	oprndtypeVM64X
	oprndtypeVM64Y
	oprndtypeVM64Z
	oprndtypeXMM
	oprndtypeXMM0
	oprndtypeYMM
	oprndtypeZMM
	oprndtypemax
)

func (o oprndtype) Match(op operand.Op) bool {
	switch o {
	default:
		return false
	case oprndtype1:
		return operand.Is1(op)
	case oprndtype3:
		return operand.Is3(op)
	case oprndtypeAL:
		return operand.IsAL(op)
	case oprndtypeAX:
		return operand.IsAX(op)
	case oprndtypeCL:
		return operand.IsCL(op)
	case oprndtypeEAX:
		return operand.IsEAX(op)
	case oprndtypeIMM16:
		return operand.IsIMM16(op)
	case oprndtypeIMM2U:
		return operand.IsIMM2U(op)
	case oprndtypeIMM32:
		return operand.IsIMM32(op)
	case oprndtypeIMM64:
		return operand.IsIMM64(op)
	case oprndtypeIMM8:
		return operand.IsIMM8(op)
	case oprndtypeK:
		return operand.IsK(op)
	case oprndtypeM:
		return operand.IsM(op)
	case oprndtypeM128:
		return operand.IsM128(op)
	case oprndtypeM16:
		return operand.IsM16(op)
	case oprndtypeM256:
		return operand.IsM256(op)
	case oprndtypeM32:
		return operand.IsM32(op)
	case oprndtypeM512:
		return operand.IsM512(op)
	case oprndtypeM64:
		return operand.IsM64(op)
	case oprndtypeM8:
		return operand.IsM8(op)
	case oprndtypeR16:
		return operand.IsR16(op)
	case oprndtypeR32:
		return operand.IsR32(op)
	case oprndtypeR64:
		return operand.IsR64(op)
	case oprndtypeR8:
		return operand.IsR8(op)
	case oprndtypeRAX:
		return operand.IsRAX(op)
	case oprndtypeREL32:
		return operand.IsREL32(op)
	case oprndtypeREL8:
		return operand.IsREL8(op)
	case oprndtypeVM32X:
		return operand.IsVM32X(op)
	case oprndtypeVM32Y:
		return operand.IsVM32Y(op)
	case oprndtypeVM32Z:
		return operand.IsVM32Z(op)
	case oprndtypeVM64X:
		return operand.IsVM64X(op)
	case oprndtypeVM64Y:
		return operand.IsVM64Y(op)
	case oprndtypeVM64Z:
		return operand.IsVM64Z(op)
	case oprndtypeXMM:
		return operand.IsXMM(op)
	case oprndtypeXMM0:
		return operand.IsXMM0(op)
	case oprndtypeYMM:
		return operand.IsYMM(op)
	case oprndtypeZMM:
		return operand.IsZMM(op)
	}
}

type implreg uint8

const (
	implregNone implreg = iota
	implregAL
	implregAX
	implregDX
	implregEAX
	implregEBX
	implregECX
	implregEDX
	implregR11
	implregRAX
	implregRBX
	implregRCX
	implregRDI
	implregRDX
	implregX0
	implregmax
)

func (i implreg) Register() reg.Register {
	switch i {
	default:
		panic("unexpected implicit register type")
	case implregAL:
		return reg.AL
	case implregAX:
		return reg.AX
	case implregDX:
		return reg.DX
	case implregEAX:
		return reg.EAX
	case implregEBX:
		return reg.EBX
	case implregECX:
		return reg.ECX
	case implregEDX:
		return reg.EDX
	case implregR11:
		return reg.R11
	case implregRAX:
		return reg.RAX
	case implregRBX:
		return reg.RBX
	case implregRCX:
		return reg.RCX
	case implregRDI:
		return reg.RDI
	case implregRDX:
		return reg.RDX
	case implregX0:
		return reg.X0
	}
}

type sffx uint8

const (
	sffxNone sffx = iota
	sffxBCST
	sffxRD_SAE
	sffxRN_SAE
	sffxRU_SAE
	sffxRZ_SAE
	sffxSAE
	sffxZ
	sffxmax
)

// maxsuffixes is the maximum number of suffixes an instruction can have.
const maxsuffixes = 2

type sffxs [maxsuffixes]sffx

func (s sffxs) Strings() []string {
	return sffxsstringsmap[s]
}

var sffxsstringsmap = map[sffxs][]string{
	{sffxBCST, sffxZ}:   {"BCST", "Z"},
	{sffxBCST}:          {"BCST"},
	{sffxRD_SAE, sffxZ}: {"RD_SAE", "Z"},
	{sffxRD_SAE}:        {"RD_SAE"},
	{sffxRN_SAE, sffxZ}: {"RN_SAE", "Z"},
	{sffxRN_SAE}:        {"RN_SAE"},
	{sffxRU_SAE, sffxZ}: {"RU_SAE", "Z"},
	{sffxRU_SAE}:        {"RU_SAE"},
	{sffxRZ_SAE, sffxZ}: {"RZ_SAE", "Z"},
	{sffxRZ_SAE}:        {"RZ_SAE"},
	{sffxSAE, sffxZ}:    {"SAE", "Z"},
	{sffxSAE}:           {"SAE"},
	{sffxZ}:             {"Z"},
	{}:                  nil,
}

type sffxscls uint8

const (
	sffxsclsNone sffxscls = iota
	sffxsclsBCST
	sffxsclsBCST_Z
	sffxsclsER
	sffxsclsER_Z
	sffxsclsNIL
	sffxsclsSAE
	sffxsclsSAE_Z
	sffxsclsZ
	sffxsclsmax
)

func (s sffxscls) SuffixesSet() map[sffxs]bool {
	if sffxsclsNone < s && s < sffxsclsmax {
		return sffxsclssuffixessettable[s-1]
	}
	return nil
}

var sffxsclssuffixessettable = []map[sffxs]bool{
	{sffxs{sffxBCST}: true},
	{sffxs{sffxBCST, sffxZ}: true},
	{sffxs{sffxRD_SAE}: true, sffxs{sffxRN_SAE}: true, sffxs{sffxRU_SAE}: true, sffxs{sffxRZ_SAE}: true},
	{sffxs{sffxRD_SAE, sffxZ}: true, sffxs{sffxRN_SAE, sffxZ}: true, sffxs{sffxRU_SAE, sffxZ}: true, sffxs{sffxRZ_SAE, sffxZ}: true},
	{sffxs{}: true},
	{sffxs{sffxSAE}: true},
	{sffxs{sffxSAE, sffxZ}: true},
	{sffxs{sffxZ}: true},
}

type isas uint8

const (
	isasNone isas = iota
	isasBase
	isasADX
	isasSSE2
	isasSSE
	isasSSE3
	isasAES
	isasBMI
	isasSSE41
	isasBMI2
	isasCLFLUSH
	isasCLFLUSHOPT
	isasCMOV
	isasCPUID
	isasSSE42
	isasAVX512DQ
	isasAVX512BW
	isasAVX512F
	isasLZCNT
	isasMONITOR
	isasMOVBE
	isasSSSE3
	isasPCLMULQDQ
	isasPOPCNT
	isasMMX
	isasRDRAND
	isasRDSEED
	isasRDTSC
	isasRDTSCP
	isasSHA
	isasAVX
	isasAVX512F_AVX512VL
	isasAES_AVX
	isasAVX512DQ_AVX512VL
	isasAVX2
	isasF16C
	isasAVX512VL
	isasAVX512BW_AVX512VL
	isasAVX512ER
	isasFMA3
	isasAVX512CD_AVX512VL
	isasAVX512CD
	isasAVX_PCLMULQDQ
	isasAVX512VBMI_AVX512VL
	isasAVX512VBMI
	isasAVX512IFMA_AVX512VL
	isasAVX512IFMA
	isasAVX512VPOPCNTDQ
	isasAVX512BW_AVX512F
	isasmax
)

func (i isas) List() []string {
	if isasNone < i && i < isasmax {
		return isaslisttable[i-1]
	}
	return nil
}

var isaslisttable = [][]string{
	nil,
	{"ADX"},
	{"SSE2"},
	{"SSE"},
	{"SSE3"},
	{"AES"},
	{"BMI"},
	{"SSE4.1"},
	{"BMI2"},
	{"CLFLUSH"},
	{"CLFLUSHOPT"},
	{"CMOV"},
	{"CPUID"},
	{"SSE4.2"},
	{"AVX512DQ"},
	{"AVX512BW"},
	{"AVX512F"},
	{"LZCNT"},
	{"MONITOR"},
	{"MOVBE"},
	{"SSSE3"},
	{"PCLMULQDQ"},
	{"POPCNT"},
	{"MMX+"},
	{"RDRAND"},
	{"RDSEED"},
	{"RDTSC"},
	{"RDTSCP"},
	{"SHA"},
	{"AVX"},
	{"AVX512F", "AVX512VL"},
	{"AES", "AVX"},
	{"AVX512DQ", "AVX512VL"},
	{"AVX2"},
	{"F16C"},
	{"AVX512VL"},
	{"AVX512BW", "AVX512VL"},
	{"AVX512ER"},
	{"FMA3"},
	{"AVX512CD", "AVX512VL"},
	{"AVX512CD"},
	{"AVX", "PCLMULQDQ"},
	{"AVX512VBMI", "AVX512VL"},
	{"AVX512VBMI"},
	{"AVX512IFMA", "AVX512VL"},
	{"AVX512IFMA"},
	{"AVX512VPOPCNTDQ"},
	{"AVX512BW", "AVX512F"},
}

type opc uint16

const (
	opcNone opc = iota
	opcADCB
	opcADCL
	opcADCQ
	opcADCW
	opcADCXL
	opcADCXQ
	opcADDB
	opcADDL
	opcADDPD
	opcADDPS
	opcADDQ
	opcADDSD
	opcADDSS
	opcADDSUBPD
	opcADDSUBPS
	opcADDW
	opcADOXL
	opcADOXQ
	opcAESDEC
	opcAESDECLAST
	opcAESENC
	opcAESENCLAST
	opcAESIMC
	opcAESKEYGENASSIST
	opcANDB
	opcANDL
	opcANDNL
	opcANDNPD
	opcANDNPS
	opcANDNQ
	opcANDPD
	opcANDPS
	opcANDQ
	opcANDW
	opcBEXTRL
	opcBEXTRQ
	opcBLENDPD
	opcBLENDPS
	opcBLENDVPD
	opcBLENDVPS
	opcBLSIL
	opcBLSIQ
	opcBLSMSKL
	opcBLSMSKQ
	opcBLSRL
	opcBLSRQ
	opcBSFL
	opcBSFQ
	opcBSFW
	opcBSRL
	opcBSRQ
	opcBSRW
	opcBSWAPL
	opcBSWAPQ
	opcBTCL
	opcBTCQ
	opcBTCW
	opcBTL
	opcBTQ
	opcBTRL
	opcBTRQ
	opcBTRW
	opcBTSL
	opcBTSQ
	opcBTSW
	opcBTW
	opcBZHIL
	opcBZHIQ
	opcCALL
	opcCBW
	opcCDQ
	opcCDQE
	opcCLC
	opcCLD
	opcCLFLUSH
	opcCLFLUSHOPT
	opcCMC
	opcCMOVLCC
	opcCMOVLCS
	opcCMOVLEQ
	opcCMOVLGE
	opcCMOVLGT
	opcCMOVLHI
	opcCMOVLLE
	opcCMOVLLS
	opcCMOVLLT
	opcCMOVLMI
	opcCMOVLNE
	opcCMOVLOC
	opcCMOVLOS
	opcCMOVLPC
	opcCMOVLPL
	opcCMOVLPS
	opcCMOVQCC
	opcCMOVQCS
	opcCMOVQEQ
	opcCMOVQGE
	opcCMOVQGT
	opcCMOVQHI
	opcCMOVQLE
	opcCMOVQLS
	opcCMOVQLT
	opcCMOVQMI
	opcCMOVQNE
	opcCMOVQOC
	opcCMOVQOS
	opcCMOVQPC
	opcCMOVQPL
	opcCMOVQPS
	opcCMOVWCC
	opcCMOVWCS
	opcCMOVWEQ
	opcCMOVWGE
	opcCMOVWGT
	opcCMOVWHI
	opcCMOVWLE
	opcCMOVWLS
	opcCMOVWLT
	opcCMOVWMI
	opcCMOVWNE
	opcCMOVWOC
	opcCMOVWOS
	opcCMOVWPC
	opcCMOVWPL
	opcCMOVWPS
	opcCMPB
	opcCMPL
	opcCMPPD
	opcCMPPS
	opcCMPQ
	opcCMPSD
	opcCMPSS
	opcCMPW
	opcCMPXCHG16B
	opcCMPXCHG8B
	opcCMPXCHGB
	opcCMPXCHGL
	opcCMPXCHGQ
	opcCMPXCHGW
	opcCOMISD
	opcCOMISS
	opcCPUID
	opcCQO
	opcCRC32B
	opcCRC32L
	opcCRC32Q
	opcCRC32W
	opcCVTPD2PL
	opcCVTPD2PS
	opcCVTPL2PD
	opcCVTPL2PS
	opcCVTPS2PD
	opcCVTPS2PL
	opcCVTSD2SL
	opcCVTSD2SS
	opcCVTSL2SD
	opcCVTSL2SS
	opcCVTSQ2SD
	opcCVTSQ2SS
	opcCVTSS2SD
	opcCVTSS2SL
	opcCVTTPD2PL
	opcCVTTPS2PL
	opcCVTTSD2SL
	opcCVTTSD2SQ
	opcCVTTSS2SL
	opcCWD
	opcCWDE
	opcDECB
	opcDECL
	opcDECQ
	opcDECW
	opcDIVB
	opcDIVL
	opcDIVPD
	opcDIVPS
	opcDIVQ
	opcDIVSD
	opcDIVSS
	opcDIVW
	opcDPPD
	opcDPPS
	opcEXTRACTPS
	opcHADDPD
	opcHADDPS
	opcHSUBPD
	opcHSUBPS
	opcIDIVB
	opcIDIVL
	opcIDIVQ
	opcIDIVW
	opcIMUL3L
	opcIMUL3Q
	opcIMUL3W
	opcIMULB
	opcIMULL
	opcIMULQ
	opcIMULW
	opcINCB
	opcINCL
	opcINCQ
	opcINCW
	opcINSERTPS
	opcINT
	opcJA
	opcJAE
	opcJB
	opcJBE
	opcJC
	opcJCC
	opcJCS
	opcJCXZL
	opcJCXZQ
	opcJE
	opcJEQ
	opcJG
	opcJGE
	opcJGT
	opcJHI
	opcJHS
	opcJL
	opcJLE
	opcJLO
	opcJLS
	opcJLT
	opcJMI
	opcJMP
	opcJNA
	opcJNAE
	opcJNB
	opcJNBE
	opcJNC
	opcJNE
	opcJNG
	opcJNGE
	opcJNL
	opcJNLE
	opcJNO
	opcJNP
	opcJNS
	opcJNZ
	opcJO
	opcJOC
	opcJOS
	opcJP
	opcJPC
	opcJPE
	opcJPL
	opcJPO
	opcJPS
	opcJS
	opcJZ
	opcKADDB
	opcKADDD
	opcKADDQ
	opcKADDW
	opcKANDB
	opcKANDD
	opcKANDNB
	opcKANDND
	opcKANDNQ
	opcKANDNW
	opcKANDQ
	opcKANDW
	opcKMOVB
	opcKMOVD
	opcKMOVQ
	opcKMOVW
	opcKNOTB
	opcKNOTD
	opcKNOTQ
	opcKNOTW
	opcKORB
	opcKORD
	opcKORQ
	opcKORTESTB
	opcKORTESTD
	opcKORTESTQ
	opcKORTESTW
	opcKORW
	opcKSHIFTLB
	opcKSHIFTLD
	opcKSHIFTLQ
	opcKSHIFTLW
	opcKSHIFTRB
	opcKSHIFTRD
	opcKSHIFTRQ
	opcKSHIFTRW
	opcKTESTB
	opcKTESTD
	opcKTESTQ
	opcKTESTW
	opcKUNPCKBW
	opcKUNPCKDQ
	opcKUNPCKWD
	opcKXNORB
	opcKXNORD
	opcKXNORQ
	opcKXNORW
	opcKXORB
	opcKXORD
	opcKXORQ
	opcKXORW
	opcLDDQU
	opcLDMXCSR
	opcLEAL
	opcLEAQ
	opcLEAW
	opcLFENCE
	opcLZCNTL
	opcLZCNTQ
	opcLZCNTW
	opcMASKMOVDQU
	opcMASKMOVOU
	opcMAXPD
	opcMAXPS
	opcMAXSD
	opcMAXSS
	opcMFENCE
	opcMINPD
	opcMINPS
	opcMINSD
	opcMINSS
	opcMONITOR
	opcMOVAPD
	opcMOVAPS
	opcMOVB
	opcMOVBELL
	opcMOVBEQQ
	opcMOVBEWW
	opcMOVBLSX
	opcMOVBLZX
	opcMOVBQSX
	opcMOVBQZX
	opcMOVBWSX
	opcMOVBWZX
	opcMOVD
	opcMOVDDUP
	opcMOVDQ2Q
	opcMOVHLPS
	opcMOVHPD
	opcMOVHPS
	opcMOVL
	opcMOVLHPS
	opcMOVLPD
	opcMOVLPS
	opcMOVLQSX
	opcMOVLQZX
	opcMOVMSKPD
	opcMOVMSKPS
	opcMOVNTDQ
	opcMOVNTDQA
	opcMOVNTIL
	opcMOVNTIQ
	opcMOVNTO
	opcMOVNTPD
	opcMOVNTPS
	opcMOVO
	opcMOVOA
	opcMOVOU
	opcMOVQ
	opcMOVSD
	opcMOVSHDUP
	opcMOVSLDUP
	opcMOVSS
	opcMOVUPD
	opcMOVUPS
	opcMOVW
	opcMOVWLSX
	opcMOVWLZX
	opcMOVWQSX
	opcMOVWQZX
	opcMPSADBW
	opcMULB
	opcMULL
	opcMULPD
	opcMULPS
	opcMULQ
	opcMULSD
	opcMULSS
	opcMULW
	opcMULXL
	opcMULXQ
	opcMWAIT
	opcNEGB
	opcNEGL
	opcNEGQ
	opcNEGW
	opcNOP
	opcNOTB
	opcNOTL
	opcNOTQ
	opcNOTW
	opcORB
	opcORL
	opcORPD
	opcORPS
	opcORQ
	opcORW
	opcPABSB
	opcPABSD
	opcPABSW
	opcPACKSSLW
	opcPACKSSWB
	opcPACKUSDW
	opcPACKUSWB
	opcPADDB
	opcPADDD
	opcPADDL
	opcPADDQ
	opcPADDSB
	opcPADDSW
	opcPADDUSB
	opcPADDUSW
	opcPADDW
	opcPALIGNR
	opcPAND
	opcPANDN
	opcPAUSE
	opcPAVGB
	opcPAVGW
	opcPBLENDVB
	opcPBLENDW
	opcPCLMULQDQ
	opcPCMPEQB
	opcPCMPEQL
	opcPCMPEQQ
	opcPCMPEQW
	opcPCMPESTRI
	opcPCMPESTRM
	opcPCMPGTB
	opcPCMPGTL
	opcPCMPGTQ
	opcPCMPGTW
	opcPCMPISTRI
	opcPCMPISTRM
	opcPDEPL
	opcPDEPQ
	opcPEXTL
	opcPEXTQ
	opcPEXTRB
	opcPEXTRD
	opcPEXTRQ
	opcPEXTRW
	opcPHADDD
	opcPHADDSW
	opcPHADDW
	opcPHMINPOSUW
	opcPHSUBD
	opcPHSUBSW
	opcPHSUBW
	opcPINSRB
	opcPINSRD
	opcPINSRQ
	opcPINSRW
	opcPMADDUBSW
	opcPMADDWL
	opcPMAXSB
	opcPMAXSD
	opcPMAXSW
	opcPMAXUB
	opcPMAXUD
	opcPMAXUW
	opcPMINSB
	opcPMINSD
	opcPMINSW
	opcPMINUB
	opcPMINUD
	opcPMINUW
	opcPMOVMSKB
	opcPMOVSXBD
	opcPMOVSXBQ
	opcPMOVSXBW
	opcPMOVSXDQ
	opcPMOVSXWD
	opcPMOVSXWQ
	opcPMOVZXBD
	opcPMOVZXBQ
	opcPMOVZXBW
	opcPMOVZXDQ
	opcPMOVZXWD
	opcPMOVZXWQ
	opcPMULDQ
	opcPMULHRSW
	opcPMULHUW
	opcPMULHW
	opcPMULLD
	opcPMULLW
	opcPMULULQ
	opcPOPCNTL
	opcPOPCNTQ
	opcPOPCNTW
	opcPOPQ
	opcPOPW
	opcPOR
	opcPREFETCHNTA
	opcPREFETCHT0
	opcPREFETCHT1
	opcPREFETCHT2
	opcPSADBW
	opcPSHUFB
	opcPSHUFD
	opcPSHUFHW
	opcPSHUFL
	opcPSHUFLW
	opcPSIGNB
	opcPSIGND
	opcPSIGNW
	opcPSLLDQ
	opcPSLLL
	opcPSLLO
	opcPSLLQ
	opcPSLLW
	opcPSRAL
	opcPSRAW
	opcPSRLDQ
	opcPSRLL
	opcPSRLO
	opcPSRLQ
	opcPSRLW
	opcPSUBB
	opcPSUBL
	opcPSUBQ
	opcPSUBSB
	opcPSUBSW
	opcPSUBUSB
	opcPSUBUSW
	opcPSUBW
	opcPTEST
	opcPUNPCKHBW
	opcPUNPCKHLQ
	opcPUNPCKHQDQ
	opcPUNPCKHWL
	opcPUNPCKLBW
	opcPUNPCKLLQ
	opcPUNPCKLQDQ
	opcPUNPCKLWL
	opcPUSHQ
	opcPUSHW
	opcPXOR
	opcRCLB
	opcRCLL
	opcRCLQ
	opcRCLW
	opcRCPPS
	opcRCPSS
	opcRCRB
	opcRCRL
	opcRCRQ
	opcRCRW
	opcRDRANDL
	opcRDSEEDL
	opcRDTSC
	opcRDTSCP
	opcRET
	opcRETFL
	opcRETFQ
	opcRETFW
	opcROLB
	opcROLL
	opcROLQ
	opcROLW
	opcRORB
	opcRORL
	opcRORQ
	opcRORW
	opcRORXL
	opcRORXQ
	opcROUNDPD
	opcROUNDPS
	opcROUNDSD
	opcROUNDSS
	opcRSQRTPS
	opcRSQRTSS
	opcSALB
	opcSALL
	opcSALQ
	opcSALW
	opcSARB
	opcSARL
	opcSARQ
	opcSARW
	opcSARXL
	opcSARXQ
	opcSBBB
	opcSBBL
	opcSBBQ
	opcSBBW
	opcSETCC
	opcSETCS
	opcSETEQ
	opcSETGE
	opcSETGT
	opcSETHI
	opcSETLE
	opcSETLS
	opcSETLT
	opcSETMI
	opcSETNE
	opcSETOC
	opcSETOS
	opcSETPC
	opcSETPL
	opcSETPS
	opcSFENCE
	opcSHA1MSG1
	opcSHA1MSG2
	opcSHA1NEXTE
	opcSHA1RNDS4
	opcSHA256MSG1
	opcSHA256MSG2
	opcSHA256RNDS2
	opcSHLB
	opcSHLL
	opcSHLQ
	opcSHLW
	opcSHLXL
	opcSHLXQ
	opcSHRB
	opcSHRL
	opcSHRQ
	opcSHRW
	opcSHRXL
	opcSHRXQ
	opcSHUFPD
	opcSHUFPS
	opcSQRTPD
	opcSQRTPS
	opcSQRTSD
	opcSQRTSS
	opcSTC
	opcSTD
	opcSTMXCSR
	opcSUBB
	opcSUBL
	opcSUBPD
	opcSUBPS
	opcSUBQ
	opcSUBSD
	opcSUBSS
	opcSUBW
	opcSYSCALL
	opcTESTB
	opcTESTL
	opcTESTQ
	opcTESTW
	opcTZCNTL
	opcTZCNTQ
	opcTZCNTW
	opcUCOMISD
	opcUCOMISS
	opcUD2
	opcUNPCKHPD
	opcUNPCKHPS
	opcUNPCKLPD
	opcUNPCKLPS
	opcVADDPD
	opcVADDPS
	opcVADDSD
	opcVADDSS
	opcVADDSUBPD
	opcVADDSUBPS
	opcVAESDEC
	opcVAESDECLAST
	opcVAESENC
	opcVAESENCLAST
	opcVAESIMC
	opcVAESKEYGENASSIST
	opcVALIGND
	opcVALIGNQ
	opcVANDNPD
	opcVANDNPS
	opcVANDPD
	opcVANDPS
	opcVBLENDMPD
	opcVBLENDMPS
	opcVBLENDPD
	opcVBLENDPS
	opcVBLENDVPD
	opcVBLENDVPS
	opcVBROADCASTF128
	opcVBROADCASTF32X2
	opcVBROADCASTF32X4
	opcVBROADCASTF32X8
	opcVBROADCASTF64X2
	opcVBROADCASTF64X4
	opcVBROADCASTI128
	opcVBROADCASTI32X2
	opcVBROADCASTI32X4
	opcVBROADCASTI32X8
	opcVBROADCASTI64X2
	opcVBROADCASTI64X4
	opcVBROADCASTSD
	opcVBROADCASTSS
	opcVCMPPD
	opcVCMPPS
	opcVCMPSD
	opcVCMPSS
	opcVCOMISD
	opcVCOMISS
	opcVCOMPRESSPD
	opcVCOMPRESSPS
	opcVCVTDQ2PD
	opcVCVTDQ2PS
	opcVCVTPD2DQ
	opcVCVTPD2DQX
	opcVCVTPD2DQY
	opcVCVTPD2PS
	opcVCVTPD2PSX
	opcVCVTPD2PSY
	opcVCVTPD2QQ
	opcVCVTPD2UDQ
	opcVCVTPD2UDQX
	opcVCVTPD2UDQY
	opcVCVTPD2UQQ
	opcVCVTPH2PS
	opcVCVTPS2DQ
	opcVCVTPS2PD
	opcVCVTPS2PH
	opcVCVTPS2QQ
	opcVCVTPS2UDQ
	opcVCVTPS2UQQ
	opcVCVTQQ2PD
	opcVCVTQQ2PS
	opcVCVTQQ2PSX
	opcVCVTQQ2PSY
	opcVCVTSD2SI
	opcVCVTSD2SIQ
	opcVCVTSD2SS
	opcVCVTSD2USIL
	opcVCVTSD2USIQ
	opcVCVTSI2SDL
	opcVCVTSI2SDQ
	opcVCVTSI2SSL
	opcVCVTSI2SSQ
	opcVCVTSS2SD
	opcVCVTSS2SI
	opcVCVTSS2SIQ
	opcVCVTSS2USIL
	opcVCVTSS2USIQ
	opcVCVTTPD2DQ
	opcVCVTTPD2DQX
	opcVCVTTPD2DQY
	opcVCVTTPD2QQ
	opcVCVTTPD2UDQ
	opcVCVTTPD2UDQX
	opcVCVTTPD2UDQY
	opcVCVTTPD2UQQ
	opcVCVTTPS2DQ
	opcVCVTTPS2QQ
	opcVCVTTPS2UDQ
	opcVCVTTPS2UQQ
	opcVCVTTSD2SI
	opcVCVTTSD2SIQ
	opcVCVTTSD2USIL
	opcVCVTTSD2USIQ
	opcVCVTTSS2SI
	opcVCVTTSS2SIQ
	opcVCVTTSS2USIL
	opcVCVTTSS2USIQ
	opcVCVTUDQ2PD
	opcVCVTUDQ2PS
	opcVCVTUQQ2PD
	opcVCVTUQQ2PS
	opcVCVTUQQ2PSX
	opcVCVTUQQ2PSY
	opcVCVTUSI2SDL
	opcVCVTUSI2SDQ
	opcVCVTUSI2SSL
	opcVCVTUSI2SSQ
	opcVDBPSADBW
	opcVDIVPD
	opcVDIVPS
	opcVDIVSD
	opcVDIVSS
	opcVDPPD
	opcVDPPS
	opcVEXP2PD
	opcVEXP2PS
	opcVEXPANDPD
	opcVEXPANDPS
	opcVEXTRACTF128
	opcVEXTRACTF32X4
	opcVEXTRACTF32X8
	opcVEXTRACTF64X2
	opcVEXTRACTF64X4
	opcVEXTRACTI128
	opcVEXTRACTI32X4
	opcVEXTRACTI32X8
	opcVEXTRACTI64X2
	opcVEXTRACTI64X4
	opcVEXTRACTPS
	opcVFIXUPIMMPD
	opcVFIXUPIMMPS
	opcVFIXUPIMMSD
	opcVFIXUPIMMSS
	opcVFMADD132PD
	opcVFMADD132PS
	opcVFMADD132SD
	opcVFMADD132SS
	opcVFMADD213PD
	opcVFMADD213PS
	opcVFMADD213SD
	opcVFMADD213SS
	opcVFMADD231PD
	opcVFMADD231PS
	opcVFMADD231SD
	opcVFMADD231SS
	opcVFMADDSUB132PD
	opcVFMADDSUB132PS
	opcVFMADDSUB213PD
	opcVFMADDSUB213PS
	opcVFMADDSUB231PD
	opcVFMADDSUB231PS
	opcVFMSUB132PD
	opcVFMSUB132PS
	opcVFMSUB132SD
	opcVFMSUB132SS
	opcVFMSUB213PD
	opcVFMSUB213PS
	opcVFMSUB213SD
	opcVFMSUB213SS
	opcVFMSUB231PD
	opcVFMSUB231PS
	opcVFMSUB231SD
	opcVFMSUB231SS
	opcVFMSUBADD132PD
	opcVFMSUBADD132PS
	opcVFMSUBADD213PD
	opcVFMSUBADD213PS
	opcVFMSUBADD231PD
	opcVFMSUBADD231PS
	opcVFNMADD132PD
	opcVFNMADD132PS
	opcVFNMADD132SD
	opcVFNMADD132SS
	opcVFNMADD213PD
	opcVFNMADD213PS
	opcVFNMADD213SD
	opcVFNMADD213SS
	opcVFNMADD231PD
	opcVFNMADD231PS
	opcVFNMADD231SD
	opcVFNMADD231SS
	opcVFNMSUB132PD
	opcVFNMSUB132PS
	opcVFNMSUB132SD
	opcVFNMSUB132SS
	opcVFNMSUB213PD
	opcVFNMSUB213PS
	opcVFNMSUB213SD
	opcVFNMSUB213SS
	opcVFNMSUB231PD
	opcVFNMSUB231PS
	opcVFNMSUB231SD
	opcVFNMSUB231SS
	opcVFPCLASSPDX
	opcVFPCLASSPDY
	opcVFPCLASSPDZ
	opcVFPCLASSPSX
	opcVFPCLASSPSY
	opcVFPCLASSPSZ
	opcVFPCLASSSD
	opcVFPCLASSSS
	opcVGATHERDPD
	opcVGATHERDPS
	opcVGATHERQPD
	opcVGATHERQPS
	opcVGETEXPPD
	opcVGETEXPPS
	opcVGETEXPSD
	opcVGETEXPSS
	opcVGETMANTPD
	opcVGETMANTPS
	opcVGETMANTSD
	opcVGETMANTSS
	opcVHADDPD
	opcVHADDPS
	opcVHSUBPD
	opcVHSUBPS
	opcVINSERTF128
	opcVINSERTF32X4
	opcVINSERTF32X8
	opcVINSERTF64X2
	opcVINSERTF64X4
	opcVINSERTI128
	opcVINSERTI32X4
	opcVINSERTI32X8
	opcVINSERTI64X2
	opcVINSERTI64X4
	opcVINSERTPS
	opcVLDDQU
	opcVLDMXCSR
	opcVMASKMOVDQU
	opcVMASKMOVPD
	opcVMASKMOVPS
	opcVMAXPD
	opcVMAXPS
	opcVMAXSD
	opcVMAXSS
	opcVMINPD
	opcVMINPS
	opcVMINSD
	opcVMINSS
	opcVMOVAPD
	opcVMOVAPS
	opcVMOVD
	opcVMOVDDUP
	opcVMOVDQA
	opcVMOVDQA32
	opcVMOVDQA64
	opcVMOVDQU
	opcVMOVDQU16
	opcVMOVDQU32
	opcVMOVDQU64
	opcVMOVDQU8
	opcVMOVHLPS
	opcVMOVHPD
	opcVMOVHPS
	opcVMOVLHPS
	opcVMOVLPD
	opcVMOVLPS
	opcVMOVMSKPD
	opcVMOVMSKPS
	opcVMOVNTDQ
	opcVMOVNTDQA
	opcVMOVNTPD
	opcVMOVNTPS
	opcVMOVQ
	opcVMOVSD
	opcVMOVSHDUP
	opcVMOVSLDUP
	opcVMOVSS
	opcVMOVUPD
	opcVMOVUPS
	opcVMPSADBW
	opcVMULPD
	opcVMULPS
	opcVMULSD
	opcVMULSS
	opcVORPD
	opcVORPS
	opcVPABSB
	opcVPABSD
	opcVPABSQ
	opcVPABSW
	opcVPACKSSDW
	opcVPACKSSWB
	opcVPACKUSDW
	opcVPACKUSWB
	opcVPADDB
	opcVPADDD
	opcVPADDQ
	opcVPADDSB
	opcVPADDSW
	opcVPADDUSB
	opcVPADDUSW
	opcVPADDW
	opcVPALIGNR
	opcVPAND
	opcVPANDD
	opcVPANDN
	opcVPANDND
	opcVPANDNQ
	opcVPANDQ
	opcVPAVGB
	opcVPAVGW
	opcVPBLENDD
	opcVPBLENDMB
	opcVPBLENDMD
	opcVPBLENDMQ
	opcVPBLENDMW
	opcVPBLENDVB
	opcVPBLENDW
	opcVPBROADCASTB
	opcVPBROADCASTD
	opcVPBROADCASTMB2Q
	opcVPBROADCASTMW2D
	opcVPBROADCASTQ
	opcVPBROADCASTW
	opcVPCLMULQDQ
	opcVPCMPB
	opcVPCMPD
	opcVPCMPEQB
	opcVPCMPEQD
	opcVPCMPEQQ
	opcVPCMPEQW
	opcVPCMPESTRI
	opcVPCMPESTRM
	opcVPCMPGTB
	opcVPCMPGTD
	opcVPCMPGTQ
	opcVPCMPGTW
	opcVPCMPISTRI
	opcVPCMPISTRM
	opcVPCMPQ
	opcVPCMPUB
	opcVPCMPUD
	opcVPCMPUQ
	opcVPCMPUW
	opcVPCMPW
	opcVPCOMPRESSD
	opcVPCOMPRESSQ
	opcVPCONFLICTD
	opcVPCONFLICTQ
	opcVPERM2F128
	opcVPERM2I128
	opcVPERMB
	opcVPERMD
	opcVPERMI2B
	opcVPERMI2D
	opcVPERMI2PD
	opcVPERMI2PS
	opcVPERMI2Q
	opcVPERMI2W
	opcVPERMILPD
	opcVPERMILPS
	opcVPERMPD
	opcVPERMPS
	opcVPERMQ
	opcVPERMT2B
	opcVPERMT2D
	opcVPERMT2PD
	opcVPERMT2PS
	opcVPERMT2Q
	opcVPERMT2W
	opcVPERMW
	opcVPEXPANDD
	opcVPEXPANDQ
	opcVPEXTRB
	opcVPEXTRD
	opcVPEXTRQ
	opcVPEXTRW
	opcVPGATHERDD
	opcVPGATHERDQ
	opcVPGATHERQD
	opcVPGATHERQQ
	opcVPHADDD
	opcVPHADDSW
	opcVPHADDW
	opcVPHMINPOSUW
	opcVPHSUBD
	opcVPHSUBSW
	opcVPHSUBW
	opcVPINSRB
	opcVPINSRD
	opcVPINSRQ
	opcVPINSRW
	opcVPLZCNTD
	opcVPLZCNTQ
	opcVPMADD52HUQ
	opcVPMADD52LUQ
	opcVPMADDUBSW
	opcVPMADDWD
	opcVPMASKMOVD
	opcVPMASKMOVQ
	opcVPMAXSB
	opcVPMAXSD
	opcVPMAXSQ
	opcVPMAXSW
	opcVPMAXUB
	opcVPMAXUD
	opcVPMAXUQ
	opcVPMAXUW
	opcVPMINSB
	opcVPMINSD
	opcVPMINSQ
	opcVPMINSW
	opcVPMINUB
	opcVPMINUD
	opcVPMINUQ
	opcVPMINUW
	opcVPMOVB2M
	opcVPMOVD2M
	opcVPMOVDB
	opcVPMOVDW
	opcVPMOVM2B
	opcVPMOVM2D
	opcVPMOVM2Q
	opcVPMOVM2W
	opcVPMOVMSKB
	opcVPMOVQ2M
	opcVPMOVQB
	opcVPMOVQD
	opcVPMOVQW
	opcVPMOVSDB
	opcVPMOVSDW
	opcVPMOVSQB
	opcVPMOVSQD
	opcVPMOVSQW
	opcVPMOVSWB
	opcVPMOVSXBD
	opcVPMOVSXBQ
	opcVPMOVSXBW
	opcVPMOVSXDQ
	opcVPMOVSXWD
	opcVPMOVSXWQ
	opcVPMOVUSDB
	opcVPMOVUSDW
	opcVPMOVUSQB
	opcVPMOVUSQD
	opcVPMOVUSQW
	opcVPMOVUSWB
	opcVPMOVW2M
	opcVPMOVWB
	opcVPMOVZXBD
	opcVPMOVZXBQ
	opcVPMOVZXBW
	opcVPMOVZXDQ
	opcVPMOVZXWD
	opcVPMOVZXWQ
	opcVPMULDQ
	opcVPMULHRSW
	opcVPMULHUW
	opcVPMULHW
	opcVPMULLD
	opcVPMULLQ
	opcVPMULLW
	opcVPMULTISHIFTQB
	opcVPMULUDQ
	opcVPOPCNTD
	opcVPOPCNTQ
	opcVPOR
	opcVPORD
	opcVPORQ
	opcVPROLD
	opcVPROLQ
	opcVPROLVD
	opcVPROLVQ
	opcVPRORD
	opcVPRORQ
	opcVPRORVD
	opcVPRORVQ
	opcVPSADBW
	opcVPSCATTERDD
	opcVPSCATTERDQ
	opcVPSCATTERQD
	opcVPSCATTERQQ
	opcVPSHUFB
	opcVPSHUFD
	opcVPSHUFHW
	opcVPSHUFLW
	opcVPSIGNB
	opcVPSIGND
	opcVPSIGNW
	opcVPSLLD
	opcVPSLLDQ
	opcVPSLLQ
	opcVPSLLVD
	opcVPSLLVQ
	opcVPSLLVW
	opcVPSLLW
	opcVPSRAD
	opcVPSRAQ
	opcVPSRAVD
	opcVPSRAVQ
	opcVPSRAVW
	opcVPSRAW
	opcVPSRLD
	opcVPSRLDQ
	opcVPSRLQ
	opcVPSRLVD
	opcVPSRLVQ
	opcVPSRLVW
	opcVPSRLW
	opcVPSUBB
	opcVPSUBD
	opcVPSUBQ
	opcVPSUBSB
	opcVPSUBSW
	opcVPSUBUSB
	opcVPSUBUSW
	opcVPSUBW
	opcVPTERNLOGD
	opcVPTERNLOGQ
	opcVPTEST
	opcVPTESTMB
	opcVPTESTMD
	opcVPTESTMQ
	opcVPTESTMW
	opcVPTESTNMB
	opcVPTESTNMD
	opcVPTESTNMQ
	opcVPTESTNMW
	opcVPUNPCKHBW
	opcVPUNPCKHDQ
	opcVPUNPCKHQDQ
	opcVPUNPCKHWD
	opcVPUNPCKLBW
	opcVPUNPCKLDQ
	opcVPUNPCKLQDQ
	opcVPUNPCKLWD
	opcVPXOR
	opcVPXORD
	opcVPXORQ
	opcVRANGEPD
	opcVRANGEPS
	opcVRANGESD
	opcVRANGESS
	opcVRCP14PD
	opcVRCP14PS
	opcVRCP14SD
	opcVRCP14SS
	opcVRCP28PD
	opcVRCP28PS
	opcVRCP28SD
	opcVRCP28SS
	opcVRCPPS
	opcVRCPSS
	opcVREDUCEPD
	opcVREDUCEPS
	opcVREDUCESD
	opcVREDUCESS
	opcVRNDSCALEPD
	opcVRNDSCALEPS
	opcVRNDSCALESD
	opcVRNDSCALESS
	opcVROUNDPD
	opcVROUNDPS
	opcVROUNDSD
	opcVROUNDSS
	opcVRSQRT14PD
	opcVRSQRT14PS
	opcVRSQRT14SD
	opcVRSQRT14SS
	opcVRSQRT28PD
	opcVRSQRT28PS
	opcVRSQRT28SD
	opcVRSQRT28SS
	opcVRSQRTPS
	opcVRSQRTSS
	opcVSCALEFPD
	opcVSCALEFPS
	opcVSCALEFSD
	opcVSCALEFSS
	opcVSCATTERDPD
	opcVSCATTERDPS
	opcVSCATTERQPD
	opcVSCATTERQPS
	opcVSHUFF32X4
	opcVSHUFF64X2
	opcVSHUFI32X4
	opcVSHUFI64X2
	opcVSHUFPD
	opcVSHUFPS
	opcVSQRTPD
	opcVSQRTPS
	opcVSQRTSD
	opcVSQRTSS
	opcVSTMXCSR
	opcVSUBPD
	opcVSUBPS
	opcVSUBSD
	opcVSUBSS
	opcVTESTPD
	opcVTESTPS
	opcVUCOMISD
	opcVUCOMISS
	opcVUNPCKHPD
	opcVUNPCKHPS
	opcVUNPCKLPD
	opcVUNPCKLPS
	opcVXORPD
	opcVXORPS
	opcVZEROALL
	opcVZEROUPPER
	opcXADDB
	opcXADDL
	opcXADDQ
	opcXADDW
	opcXCHGB
	opcXCHGL
	opcXCHGQ
	opcXCHGW
	opcXGETBV
	opcXLAT
	opcXORB
	opcXORL
	opcXORPD
	opcXORPS
	opcXORQ
	opcXORW
	opcmax
)

func (o opc) String() string {
	if opcNone < o && o < opcmax {
		return opcstringtable[o-1]
	}
	return ""
}

var opcstringtable = []string{
	"ADCB",
	"ADCL",
	"ADCQ",
	"ADCW",
	"ADCXL",
	"ADCXQ",
	"ADDB",
	"ADDL",
	"ADDPD",
	"ADDPS",
	"ADDQ",
	"ADDSD",
	"ADDSS",
	"ADDSUBPD",
	"ADDSUBPS",
	"ADDW",
	"ADOXL",
	"ADOXQ",
	"AESDEC",
	"AESDECLAST",
	"AESENC",
	"AESENCLAST",
	"AESIMC",
	"AESKEYGENASSIST",
	"ANDB",
	"ANDL",
	"ANDNL",
	"ANDNPD",
	"ANDNPS",
	"ANDNQ",
	"ANDPD",
	"ANDPS",
	"ANDQ",
	"ANDW",
	"BEXTRL",
	"BEXTRQ",
	"BLENDPD",
	"BLENDPS",
	"BLENDVPD",
	"BLENDVPS",
	"BLSIL",
	"BLSIQ",
	"BLSMSKL",
	"BLSMSKQ",
	"BLSRL",
	"BLSRQ",
	"BSFL",
	"BSFQ",
	"BSFW",
	"BSRL",
	"BSRQ",
	"BSRW",
	"BSWAPL",
	"BSWAPQ",
	"BTCL",
	"BTCQ",
	"BTCW",
	"BTL",
	"BTQ",
	"BTRL",
	"BTRQ",
	"BTRW",
	"BTSL",
	"BTSQ",
	"BTSW",
	"BTW",
	"BZHIL",
	"BZHIQ",
	"CALL",
	"CBW",
	"CDQ",
	"CDQE",
	"CLC",
	"CLD",
	"CLFLUSH",
	"CLFLUSHOPT",
	"CMC",
	"CMOVLCC",
	"CMOVLCS",
	"CMOVLEQ",
	"CMOVLGE",
	"CMOVLGT",
	"CMOVLHI",
	"CMOVLLE",
	"CMOVLLS",
	"CMOVLLT",
	"CMOVLMI",
	"CMOVLNE",
	"CMOVLOC",
	"CMOVLOS",
	"CMOVLPC",
	"CMOVLPL",
	"CMOVLPS",
	"CMOVQCC",
	"CMOVQCS",
	"CMOVQEQ",
	"CMOVQGE",
	"CMOVQGT",
	"CMOVQHI",
	"CMOVQLE",
	"CMOVQLS",
	"CMOVQLT",
	"CMOVQMI",
	"CMOVQNE",
	"CMOVQOC",
	"CMOVQOS",
	"CMOVQPC",
	"CMOVQPL",
	"CMOVQPS",
	"CMOVWCC",
	"CMOVWCS",
	"CMOVWEQ",
	"CMOVWGE",
	"CMOVWGT",
	"CMOVWHI",
	"CMOVWLE",
	"CMOVWLS",
	"CMOVWLT",
	"CMOVWMI",
	"CMOVWNE",
	"CMOVWOC",
	"CMOVWOS",
	"CMOVWPC",
	"CMOVWPL",
	"CMOVWPS",
	"CMPB",
	"CMPL",
	"CMPPD",
	"CMPPS",
	"CMPQ",
	"CMPSD",
	"CMPSS",
	"CMPW",
	"CMPXCHG16B",
	"CMPXCHG8B",
	"CMPXCHGB",
	"CMPXCHGL",
	"CMPXCHGQ",
	"CMPXCHGW",
	"COMISD",
	"COMISS",
	"CPUID",
	"CQO",
	"CRC32B",
	"CRC32L",
	"CRC32Q",
	"CRC32W",
	"CVTPD2PL",
	"CVTPD2PS",
	"CVTPL2PD",
	"CVTPL2PS",
	"CVTPS2PD",
	"CVTPS2PL",
	"CVTSD2SL",
	"CVTSD2SS",
	"CVTSL2SD",
	"CVTSL2SS",
	"CVTSQ2SD",
	"CVTSQ2SS",
	"CVTSS2SD",
	"CVTSS2SL",
	"CVTTPD2PL",
	"CVTTPS2PL",
	"CVTTSD2SL",
	"CVTTSD2SQ",
	"CVTTSS2SL",
	"CWD",
	"CWDE",
	"DECB",
	"DECL",
	"DECQ",
	"DECW",
	"DIVB",
	"DIVL",
	"DIVPD",
	"DIVPS",
	"DIVQ",
	"DIVSD",
	"DIVSS",
	"DIVW",
	"DPPD",
	"DPPS",
	"EXTRACTPS",
	"HADDPD",
	"HADDPS",
	"HSUBPD",
	"HSUBPS",
	"IDIVB",
	"IDIVL",
	"IDIVQ",
	"IDIVW",
	"IMUL3L",
	"IMUL3Q",
	"IMUL3W",
	"IMULB",
	"IMULL",
	"IMULQ",
	"IMULW",
	"INCB",
	"INCL",
	"INCQ",
	"INCW",
	"INSERTPS",
	"INT",
	"JA",
	"JAE",
	"JB",
	"JBE",
	"JC",
	"JCC",
	"JCS",
	"JCXZL",
	"JCXZQ",
	"JE",
	"JEQ",
	"JG",
	"JGE",
	"JGT",
	"JHI",
	"JHS",
	"JL",
	"JLE",
	"JLO",
	"JLS",
	"JLT",
	"JMI",
	"JMP",
	"JNA",
	"JNAE",
	"JNB",
	"JNBE",
	"JNC",
	"JNE",
	"JNG",
	"JNGE",
	"JNL",
	"JNLE",
	"JNO",
	"JNP",
	"JNS",
	"JNZ",
	"JO",
	"JOC",
	"JOS",
	"JP",
	"JPC",
	"JPE",
	"JPL",
	"JPO",
	"JPS",
	"JS",
	"JZ",
	"KADDB",
	"KADDD",
	"KADDQ",
	"KADDW",
	"KANDB",
	"KANDD",
	"KANDNB",
	"KANDND",
	"KANDNQ",
	"KANDNW",
	"KANDQ",
	"KANDW",
	"KMOVB",
	"KMOVD",
	"KMOVQ",
	"KMOVW",
	"KNOTB",
	"KNOTD",
	"KNOTQ",
	"KNOTW",
	"KORB",
	"KORD",
	"KORQ",
	"KORTESTB",
	"KORTESTD",
	"KORTESTQ",
	"KORTESTW",
	"KORW",
	"KSHIFTLB",
	"KSHIFTLD",
	"KSHIFTLQ",
	"KSHIFTLW",
	"KSHIFTRB",
	"KSHIFTRD",
	"KSHIFTRQ",
	"KSHIFTRW",
	"KTESTB",
	"KTESTD",
	"KTESTQ",
	"KTESTW",
	"KUNPCKBW",
	"KUNPCKDQ",
	"KUNPCKWD",
	"KXNORB",
	"KXNORD",
	"KXNORQ",
	"KXNORW",
	"KXORB",
	"KXORD",
	"KXORQ",
	"KXORW",
	"LDDQU",
	"LDMXCSR",
	"LEAL",
	"LEAQ",
	"LEAW",
	"LFENCE",
	"LZCNTL",
	"LZCNTQ",
	"LZCNTW",
	"MASKMOVDQU",
	"MASKMOVOU",
	"MAXPD",
	"MAXPS",
	"MAXSD",
	"MAXSS",
	"MFENCE",
	"MINPD",
	"MINPS",
	"MINSD",
	"MINSS",
	"MONITOR",
	"MOVAPD",
	"MOVAPS",
	"MOVB",
	"MOVBELL",
	"MOVBEQQ",
	"MOVBEWW",
	"MOVBLSX",
	"MOVBLZX",
	"MOVBQSX",
	"MOVBQZX",
	"MOVBWSX",
	"MOVBWZX",
	"MOVD",
	"MOVDDUP",
	"MOVDQ2Q",
	"MOVHLPS",
	"MOVHPD",
	"MOVHPS",
	"MOVL",
	"MOVLHPS",
	"MOVLPD",
	"MOVLPS",
	"MOVLQSX",
	"MOVLQZX",
	"MOVMSKPD",
	"MOVMSKPS",
	"MOVNTDQ",
	"MOVNTDQA",
	"MOVNTIL",
	"MOVNTIQ",
	"MOVNTO",
	"MOVNTPD",
	"MOVNTPS",
	"MOVO",
	"MOVOA",
	"MOVOU",
	"MOVQ",
	"MOVSD",
	"MOVSHDUP",
	"MOVSLDUP",
	"MOVSS",
	"MOVUPD",
	"MOVUPS",
	"MOVW",
	"MOVWLSX",
	"MOVWLZX",
	"MOVWQSX",
	"MOVWQZX",
	"MPSADBW",
	"MULB",
	"MULL",
	"MULPD",
	"MULPS",
	"MULQ",
	"MULSD",
	"MULSS",
	"MULW",
	"MULXL",
	"MULXQ",
	"MWAIT",
	"NEGB",
	"NEGL",
	"NEGQ",
	"NEGW",
	"NOP",
	"NOTB",
	"NOTL",
	"NOTQ",
	"NOTW",
	"ORB",
	"ORL",
	"ORPD",
	"ORPS",
	"ORQ",
	"ORW",
	"PABSB",
	"PABSD",
	"PABSW",
	"PACKSSLW",
	"PACKSSWB",
	"PACKUSDW",
	"PACKUSWB",
	"PADDB",
	"PADDD",
	"PADDL",
	"PADDQ",
	"PADDSB",
	"PADDSW",
	"PADDUSB",
	"PADDUSW",
	"PADDW",
	"PALIGNR",
	"PAND",
	"PANDN",
	"PAUSE",
	"PAVGB",
	"PAVGW",
	"PBLENDVB",
	"PBLENDW",
	"PCLMULQDQ",
	"PCMPEQB",
	"PCMPEQL",
	"PCMPEQQ",
	"PCMPEQW",
	"PCMPESTRI",
	"PCMPESTRM",
	"PCMPGTB",
	"PCMPGTL",
	"PCMPGTQ",
	"PCMPGTW",
	"PCMPISTRI",
	"PCMPISTRM",
	"PDEPL",
	"PDEPQ",
	"PEXTL",
	"PEXTQ",
	"PEXTRB",
	"PEXTRD",
	"PEXTRQ",
	"PEXTRW",
	"PHADDD",
	"PHADDSW",
	"PHADDW",
	"PHMINPOSUW",
	"PHSUBD",
	"PHSUBSW",
	"PHSUBW",
	"PINSRB",
	"PINSRD",
	"PINSRQ",
	"PINSRW",
	"PMADDUBSW",
	"PMADDWL",
	"PMAXSB",
	"PMAXSD",
	"PMAXSW",
	"PMAXUB",
	"PMAXUD",
	"PMAXUW",
	"PMINSB",
	"PMINSD",
	"PMINSW",
	"PMINUB",
	"PMINUD",
	"PMINUW",
	"PMOVMSKB",
	"PMOVSXBD",
	"PMOVSXBQ",
	"PMOVSXBW",
	"PMOVSXDQ",
	"PMOVSXWD",
	"PMOVSXWQ",
	"PMOVZXBD",
	"PMOVZXBQ",
	"PMOVZXBW",
	"PMOVZXDQ",
	"PMOVZXWD",
	"PMOVZXWQ",
	"PMULDQ",
	"PMULHRSW",
	"PMULHUW",
	"PMULHW",
	"PMULLD",
	"PMULLW",
	"PMULULQ",
	"POPCNTL",
	"POPCNTQ",
	"POPCNTW",
	"POPQ",
	"POPW",
	"POR",
	"PREFETCHNTA",
	"PREFETCHT0",
	"PREFETCHT1",
	"PREFETCHT2",
	"PSADBW",
	"PSHUFB",
	"PSHUFD",
	"PSHUFHW",
	"PSHUFL",
	"PSHUFLW",
	"PSIGNB",
	"PSIGND",
	"PSIGNW",
	"PSLLDQ",
	"PSLLL",
	"PSLLO",
	"PSLLQ",
	"PSLLW",
	"PSRAL",
	"PSRAW",
	"PSRLDQ",
	"PSRLL",
	"PSRLO",
	"PSRLQ",
	"PSRLW",
	"PSUBB",
	"PSUBL",
	"PSUBQ",
	"PSUBSB",
	"PSUBSW",
	"PSUBUSB",
	"PSUBUSW",
	"PSUBW",
	"PTEST",
	"PUNPCKHBW",
	"PUNPCKHLQ",
	"PUNPCKHQDQ",
	"PUNPCKHWL",
	"PUNPCKLBW",
	"PUNPCKLLQ",
	"PUNPCKLQDQ",
	"PUNPCKLWL",
	"PUSHQ",
	"PUSHW",
	"PXOR",
	"RCLB",
	"RCLL",
	"RCLQ",
	"RCLW",
	"RCPPS",
	"RCPSS",
	"RCRB",
	"RCRL",
	"RCRQ",
	"RCRW",
	"RDRANDL",
	"RDSEEDL",
	"RDTSC",
	"RDTSCP",
	"RET",
	"RETFL",
	"RETFQ",
	"RETFW",
	"ROLB",
	"ROLL",
	"ROLQ",
	"ROLW",
	"RORB",
	"RORL",
	"RORQ",
	"RORW",
	"RORXL",
	"RORXQ",
	"ROUNDPD",
	"ROUNDPS",
	"ROUNDSD",
	"ROUNDSS",
	"RSQRTPS",
	"RSQRTSS",
	"SALB",
	"SALL",
	"SALQ",
	"SALW",
	"SARB",
	"SARL",
	"SARQ",
	"SARW",
	"SARXL",
	"SARXQ",
	"SBBB",
	"SBBL",
	"SBBQ",
	"SBBW",
	"SETCC",
	"SETCS",
	"SETEQ",
	"SETGE",
	"SETGT",
	"SETHI",
	"SETLE",
	"SETLS",
	"SETLT",
	"SETMI",
	"SETNE",
	"SETOC",
	"SETOS",
	"SETPC",
	"SETPL",
	"SETPS",
	"SFENCE",
	"SHA1MSG1",
	"SHA1MSG2",
	"SHA1NEXTE",
	"SHA1RNDS4",
	"SHA256MSG1",
	"SHA256MSG2",
	"SHA256RNDS2",
	"SHLB",
	"SHLL",
	"SHLQ",
	"SHLW",
	"SHLXL",
	"SHLXQ",
	"SHRB",
	"SHRL",
	"SHRQ",
	"SHRW",
	"SHRXL",
	"SHRXQ",
	"SHUFPD",
	"SHUFPS",
	"SQRTPD",
	"SQRTPS",
	"SQRTSD",
	"SQRTSS",
	"STC",
	"STD",
	"STMXCSR",
	"SUBB",
	"SUBL",
	"SUBPD",
	"SUBPS",
	"SUBQ",
	"SUBSD",
	"SUBSS",
	"SUBW",
	"SYSCALL",
	"TESTB",
	"TESTL",
	"TESTQ",
	"TESTW",
	"TZCNTL",
	"TZCNTQ",
	"TZCNTW",
	"UCOMISD",
	"UCOMISS",
	"UD2",
	"UNPCKHPD",
	"UNPCKHPS",
	"UNPCKLPD",
	"UNPCKLPS",
	"VADDPD",
	"VADDPS",
	"VADDSD",
	"VADDSS",
	"VADDSUBPD",
	"VADDSUBPS",
	"VAESDEC",
	"VAESDECLAST",
	"VAESENC",
	"VAESENCLAST",
	"VAESIMC",
	"VAESKEYGENASSIST",
	"VALIGND",
	"VALIGNQ",
	"VANDNPD",
	"VANDNPS",
	"VANDPD",
	"VANDPS",
	"VBLENDMPD",
	"VBLENDMPS",
	"VBLENDPD",
	"VBLENDPS",
	"VBLENDVPD",
	"VBLENDVPS",
	"VBROADCASTF128",
	"VBROADCASTF32X2",
	"VBROADCASTF32X4",
	"VBROADCASTF32X8",
	"VBROADCASTF64X2",
	"VBROADCASTF64X4",
	"VBROADCASTI128",
	"VBROADCASTI32X2",
	"VBROADCASTI32X4",
	"VBROADCASTI32X8",
	"VBROADCASTI64X2",
	"VBROADCASTI64X4",
	"VBROADCASTSD",
	"VBROADCASTSS",
	"VCMPPD",
	"VCMPPS",
	"VCMPSD",
	"VCMPSS",
	"VCOMISD",
	"VCOMISS",
	"VCOMPRESSPD",
	"VCOMPRESSPS",
	"VCVTDQ2PD",
	"VCVTDQ2PS",
	"VCVTPD2DQ",
	"VCVTPD2DQX",
	"VCVTPD2DQY",
	"VCVTPD2PS",
	"VCVTPD2PSX",
	"VCVTPD2PSY",
	"VCVTPD2QQ",
	"VCVTPD2UDQ",
	"VCVTPD2UDQX",
	"VCVTPD2UDQY",
	"VCVTPD2UQQ",
	"VCVTPH2PS",
	"VCVTPS2DQ",
	"VCVTPS2PD",
	"VCVTPS2PH",
	"VCVTPS2QQ",
	"VCVTPS2UDQ",
	"VCVTPS2UQQ",
	"VCVTQQ2PD",
	"VCVTQQ2PS",
	"VCVTQQ2PSX",
	"VCVTQQ2PSY",
	"VCVTSD2SI",
	"VCVTSD2SIQ",
	"VCVTSD2SS",
	"VCVTSD2USIL",
	"VCVTSD2USIQ",
	"VCVTSI2SDL",
	"VCVTSI2SDQ",
	"VCVTSI2SSL",
	"VCVTSI2SSQ",
	"VCVTSS2SD",
	"VCVTSS2SI",
	"VCVTSS2SIQ",
	"VCVTSS2USIL",
	"VCVTSS2USIQ",
	"VCVTTPD2DQ",
	"VCVTTPD2DQX",
	"VCVTTPD2DQY",
	"VCVTTPD2QQ",
	"VCVTTPD2UDQ",
	"VCVTTPD2UDQX",
	"VCVTTPD2UDQY",
	"VCVTTPD2UQQ",
	"VCVTTPS2DQ",
	"VCVTTPS2QQ",
	"VCVTTPS2UDQ",
	"VCVTTPS2UQQ",
	"VCVTTSD2SI",
	"VCVTTSD2SIQ",
	"VCVTTSD2USIL",
	"VCVTTSD2USIQ",
	"VCVTTSS2SI",
	"VCVTTSS2SIQ",
	"VCVTTSS2USIL",
	"VCVTTSS2USIQ",
	"VCVTUDQ2PD",
	"VCVTUDQ2PS",
	"VCVTUQQ2PD",
	"VCVTUQQ2PS",
	"VCVTUQQ2PSX",
	"VCVTUQQ2PSY",
	"VCVTUSI2SDL",
	"VCVTUSI2SDQ",
	"VCVTUSI2SSL",
	"VCVTUSI2SSQ",
	"VDBPSADBW",
	"VDIVPD",
	"VDIVPS",
	"VDIVSD",
	"VDIVSS",
	"VDPPD",
	"VDPPS",
	"VEXP2PD",
	"VEXP2PS",
	"VEXPANDPD",
	"VEXPANDPS",
	"VEXTRACTF128",
	"VEXTRACTF32X4",
	"VEXTRACTF32X8",
	"VEXTRACTF64X2",
	"VEXTRACTF64X4",
	"VEXTRACTI128",
	"VEXTRACTI32X4",
	"VEXTRACTI32X8",
	"VEXTRACTI64X2",
	"VEXTRACTI64X4",
	"VEXTRACTPS",
	"VFIXUPIMMPD",
	"VFIXUPIMMPS",
	"VFIXUPIMMSD",
	"VFIXUPIMMSS",
	"VFMADD132PD",
	"VFMADD132PS",
	"VFMADD132SD",
	"VFMADD132SS",
	"VFMADD213PD",
	"VFMADD213PS",
	"VFMADD213SD",
	"VFMADD213SS",
	"VFMADD231PD",
	"VFMADD231PS",
	"VFMADD231SD",
	"VFMADD231SS",
	"VFMADDSUB132PD",
	"VFMADDSUB132PS",
	"VFMADDSUB213PD",
	"VFMADDSUB213PS",
	"VFMADDSUB231PD",
	"VFMADDSUB231PS",
	"VFMSUB132PD",
	"VFMSUB132PS",
	"VFMSUB132SD",
	"VFMSUB132SS",
	"VFMSUB213PD",
	"VFMSUB213PS",
	"VFMSUB213SD",
	"VFMSUB213SS",
	"VFMSUB231PD",
	"VFMSUB231PS",
	"VFMSUB231SD",
	"VFMSUB231SS",
	"VFMSUBADD132PD",
	"VFMSUBADD132PS",
	"VFMSUBADD213PD",
	"VFMSUBADD213PS",
	"VFMSUBADD231PD",
	"VFMSUBADD231PS",
	"VFNMADD132PD",
	"VFNMADD132PS",
	"VFNMADD132SD",
	"VFNMADD132SS",
	"VFNMADD213PD",
	"VFNMADD213PS",
	"VFNMADD213SD",
	"VFNMADD213SS",
	"VFNMADD231PD",
	"VFNMADD231PS",
	"VFNMADD231SD",
	"VFNMADD231SS",
	"VFNMSUB132PD",
	"VFNMSUB132PS",
	"VFNMSUB132SD",
	"VFNMSUB132SS",
	"VFNMSUB213PD",
	"VFNMSUB213PS",
	"VFNMSUB213SD",
	"VFNMSUB213SS",
	"VFNMSUB231PD",
	"VFNMSUB231PS",
	"VFNMSUB231SD",
	"VFNMSUB231SS",
	"VFPCLASSPDX",
	"VFPCLASSPDY",
	"VFPCLASSPDZ",
	"VFPCLASSPSX",
	"VFPCLASSPSY",
	"VFPCLASSPSZ",
	"VFPCLASSSD",
	"VFPCLASSSS",
	"VGATHERDPD",
	"VGATHERDPS",
	"VGATHERQPD",
	"VGATHERQPS",
	"VGETEXPPD",
	"VGETEXPPS",
	"VGETEXPSD",
	"VGETEXPSS",
	"VGETMANTPD",
	"VGETMANTPS",
	"VGETMANTSD",
	"VGETMANTSS",
	"VHADDPD",
	"VHADDPS",
	"VHSUBPD",
	"VHSUBPS",
	"VINSERTF128",
	"VINSERTF32X4",
	"VINSERTF32X8",
	"VINSERTF64X2",
	"VINSERTF64X4",
	"VINSERTI128",
	"VINSERTI32X4",
	"VINSERTI32X8",
	"VINSERTI64X2",
	"VINSERTI64X4",
	"VINSERTPS",
	"VLDDQU",
	"VLDMXCSR",
	"VMASKMOVDQU",
	"VMASKMOVPD",
	"VMASKMOVPS",
	"VMAXPD",
	"VMAXPS",
	"VMAXSD",
	"VMAXSS",
	"VMINPD",
	"VMINPS",
	"VMINSD",
	"VMINSS",
	"VMOVAPD",
	"VMOVAPS",
	"VMOVD",
	"VMOVDDUP",
	"VMOVDQA",
	"VMOVDQA32",
	"VMOVDQA64",
	"VMOVDQU",
	"VMOVDQU16",
	"VMOVDQU32",
	"VMOVDQU64",
	"VMOVDQU8",
	"VMOVHLPS",
	"VMOVHPD",
	"VMOVHPS",
	"VMOVLHPS",
	"VMOVLPD",
	"VMOVLPS",
	"VMOVMSKPD",
	"VMOVMSKPS",
	"VMOVNTDQ",
	"VMOVNTDQA",
	"VMOVNTPD",
	"VMOVNTPS",
	"VMOVQ",
	"VMOVSD",
	"VMOVSHDUP",
	"VMOVSLDUP",
	"VMOVSS",
	"VMOVUPD",
	"VMOVUPS",
	"VMPSADBW",
	"VMULPD",
	"VMULPS",
	"VMULSD",
	"VMULSS",
	"VORPD",
	"VORPS",
	"VPABSB",
	"VPABSD",
	"VPABSQ",
	"VPABSW",
	"VPACKSSDW",
	"VPACKSSWB",
	"VPACKUSDW",
	"VPACKUSWB",
	"VPADDB",
	"VPADDD",
	"VPADDQ",
	"VPADDSB",
	"VPADDSW",
	"VPADDUSB",
	"VPADDUSW",
	"VPADDW",
	"VPALIGNR",
	"VPAND",
	"VPANDD",
	"VPANDN",
	"VPANDND",
	"VPANDNQ",
	"VPANDQ",
	"VPAVGB",
	"VPAVGW",
	"VPBLENDD",
	"VPBLENDMB",
	"VPBLENDMD",
	"VPBLENDMQ",
	"VPBLENDMW",
	"VPBLENDVB",
	"VPBLENDW",
	"VPBROADCASTB",
	"VPBROADCASTD",
	"VPBROADCASTMB2Q",
	"VPBROADCASTMW2D",
	"VPBROADCASTQ",
	"VPBROADCASTW",
	"VPCLMULQDQ",
	"VPCMPB",
	"VPCMPD",
	"VPCMPEQB",
	"VPCMPEQD",
	"VPCMPEQQ",
	"VPCMPEQW",
	"VPCMPESTRI",
	"VPCMPESTRM",
	"VPCMPGTB",
	"VPCMPGTD",
	"VPCMPGTQ",
	"VPCMPGTW",
	"VPCMPISTRI",
	"VPCMPISTRM",
	"VPCMPQ",
	"VPCMPUB",
	"VPCMPUD",
	"VPCMPUQ",
	"VPCMPUW",
	"VPCMPW",
	"VPCOMPRESSD",
	"VPCOMPRESSQ",
	"VPCONFLICTD",
	"VPCONFLICTQ",
	"VPERM2F128",
	"VPERM2I128",
	"VPERMB",
	"VPERMD",
	"VPERMI2B",
	"VPERMI2D",
	"VPERMI2PD",
	"VPERMI2PS",
	"VPERMI2Q",
	"VPERMI2W",
	"VPERMILPD",
	"VPERMILPS",
	"VPERMPD",
	"VPERMPS",
	"VPERMQ",
	"VPERMT2B",
	"VPERMT2D",
	"VPERMT2PD",
	"VPERMT2PS",
	"VPERMT2Q",
	"VPERMT2W",
	"VPERMW",
	"VPEXPANDD",
	"VPEXPANDQ",
	"VPEXTRB",
	"VPEXTRD",
	"VPEXTRQ",
	"VPEXTRW",
	"VPGATHERDD",
	"VPGATHERDQ",
	"VPGATHERQD",
	"VPGATHERQQ",
	"VPHADDD",
	"VPHADDSW",
	"VPHADDW",
	"VPHMINPOSUW",
	"VPHSUBD",
	"VPHSUBSW",
	"VPHSUBW",
	"VPINSRB",
	"VPINSRD",
	"VPINSRQ",
	"VPINSRW",
	"VPLZCNTD",
	"VPLZCNTQ",
	"VPMADD52HUQ",
	"VPMADD52LUQ",
	"VPMADDUBSW",
	"VPMADDWD",
	"VPMASKMOVD",
	"VPMASKMOVQ",
	"VPMAXSB",
	"VPMAXSD",
	"VPMAXSQ",
	"VPMAXSW",
	"VPMAXUB",
	"VPMAXUD",
	"VPMAXUQ",
	"VPMAXUW",
	"VPMINSB",
	"VPMINSD",
	"VPMINSQ",
	"VPMINSW",
	"VPMINUB",
	"VPMINUD",
	"VPMINUQ",
	"VPMINUW",
	"VPMOVB2M",
	"VPMOVD2M",
	"VPMOVDB",
	"VPMOVDW",
	"VPMOVM2B",
	"VPMOVM2D",
	"VPMOVM2Q",
	"VPMOVM2W",
	"VPMOVMSKB",
	"VPMOVQ2M",
	"VPMOVQB",
	"VPMOVQD",
	"VPMOVQW",
	"VPMOVSDB",
	"VPMOVSDW",
	"VPMOVSQB",
	"VPMOVSQD",
	"VPMOVSQW",
	"VPMOVSWB",
	"VPMOVSXBD",
	"VPMOVSXBQ",
	"VPMOVSXBW",
	"VPMOVSXDQ",
	"VPMOVSXWD",
	"VPMOVSXWQ",
	"VPMOVUSDB",
	"VPMOVUSDW",
	"VPMOVUSQB",
	"VPMOVUSQD",
	"VPMOVUSQW",
	"VPMOVUSWB",
	"VPMOVW2M",
	"VPMOVWB",
	"VPMOVZXBD",
	"VPMOVZXBQ",
	"VPMOVZXBW",
	"VPMOVZXDQ",
	"VPMOVZXWD",
	"VPMOVZXWQ",
	"VPMULDQ",
	"VPMULHRSW",
	"VPMULHUW",
	"VPMULHW",
	"VPMULLD",
	"VPMULLQ",
	"VPMULLW",
	"VPMULTISHIFTQB",
	"VPMULUDQ",
	"VPOPCNTD",
	"VPOPCNTQ",
	"VPOR",
	"VPORD",
	"VPORQ",
	"VPROLD",
	"VPROLQ",
	"VPROLVD",
	"VPROLVQ",
	"VPRORD",
	"VPRORQ",
	"VPRORVD",
	"VPRORVQ",
	"VPSADBW",
	"VPSCATTERDD",
	"VPSCATTERDQ",
	"VPSCATTERQD",
	"VPSCATTERQQ",
	"VPSHUFB",
	"VPSHUFD",
	"VPSHUFHW",
	"VPSHUFLW",
	"VPSIGNB",
	"VPSIGND",
	"VPSIGNW",
	"VPSLLD",
	"VPSLLDQ",
	"VPSLLQ",
	"VPSLLVD",
	"VPSLLVQ",
	"VPSLLVW",
	"VPSLLW",
	"VPSRAD",
	"VPSRAQ",
	"VPSRAVD",
	"VPSRAVQ",
	"VPSRAVW",
	"VPSRAW",
	"VPSRLD",
	"VPSRLDQ",
	"VPSRLQ",
	"VPSRLVD",
	"VPSRLVQ",
	"VPSRLVW",
	"VPSRLW",
	"VPSUBB",
	"VPSUBD",
	"VPSUBQ",
	"VPSUBSB",
	"VPSUBSW",
	"VPSUBUSB",
	"VPSUBUSW",
	"VPSUBW",
	"VPTERNLOGD",
	"VPTERNLOGQ",
	"VPTEST",
	"VPTESTMB",
	"VPTESTMD",
	"VPTESTMQ",
	"VPTESTMW",
	"VPTESTNMB",
	"VPTESTNMD",
	"VPTESTNMQ",
	"VPTESTNMW",
	"VPUNPCKHBW",
	"VPUNPCKHDQ",
	"VPUNPCKHQDQ",
	"VPUNPCKHWD",
	"VPUNPCKLBW",
	"VPUNPCKLDQ",
	"VPUNPCKLQDQ",
	"VPUNPCKLWD",
	"VPXOR",
	"VPXORD",
	"VPXORQ",
	"VRANGEPD",
	"VRANGEPS",
	"VRANGESD",
	"VRANGESS",
	"VRCP14PD",
	"VRCP14PS",
	"VRCP14SD",
	"VRCP14SS",
	"VRCP28PD",
	"VRCP28PS",
	"VRCP28SD",
	"VRCP28SS",
	"VRCPPS",
	"VRCPSS",
	"VREDUCEPD",
	"VREDUCEPS",
	"VREDUCESD",
	"VREDUCESS",
	"VRNDSCALEPD",
	"VRNDSCALEPS",
	"VRNDSCALESD",
	"VRNDSCALESS",
	"VROUNDPD",
	"VROUNDPS",
	"VROUNDSD",
	"VROUNDSS",
	"VRSQRT14PD",
	"VRSQRT14PS",
	"VRSQRT14SD",
	"VRSQRT14SS",
	"VRSQRT28PD",
	"VRSQRT28PS",
	"VRSQRT28SD",
	"VRSQRT28SS",
	"VRSQRTPS",
	"VRSQRTSS",
	"VSCALEFPD",
	"VSCALEFPS",
	"VSCALEFSD",
	"VSCALEFSS",
	"VSCATTERDPD",
	"VSCATTERDPS",
	"VSCATTERQPD",
	"VSCATTERQPS",
	"VSHUFF32X4",
	"VSHUFF64X2",
	"VSHUFI32X4",
	"VSHUFI64X2",
	"VSHUFPD",
	"VSHUFPS",
	"VSQRTPD",
	"VSQRTPS",
	"VSQRTSD",
	"VSQRTSS",
	"VSTMXCSR",
	"VSUBPD",
	"VSUBPS",
	"VSUBSD",
	"VSUBSS",
	"VTESTPD",
	"VTESTPS",
	"VUCOMISD",
	"VUCOMISS",
	"VUNPCKHPD",
	"VUNPCKHPS",
	"VUNPCKLPD",
	"VUNPCKLPS",
	"VXORPD",
	"VXORPS",
	"VZEROALL",
	"VZEROUPPER",
	"XADDB",
	"XADDL",
	"XADDQ",
	"XADDW",
	"XCHGB",
	"XCHGL",
	"XCHGQ",
	"XCHGW",
	"XGETBV",
	"XLAT",
	"XORB",
	"XORL",
	"XORPD",
	"XORPS",
	"XORQ",
	"XORW",
}

var forms = []form{
	{opcADCB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeAL), false, actionRW}}},
	{opcADCB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcADCB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcADCB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcADCB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcADCB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcADCL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeEAX), false, actionRW}}},
	{opcADCL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcADCL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcADCL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcADCL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcADCL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcADCL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcADCL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcADCQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcADCQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcADCQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeRAX), false, actionRW}}},
	{opcADCQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcADCQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcADCQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcADCQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcADCQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcADCW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeAX), false, actionRW}}},
	{opcADCW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcADCW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcADCW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcADCW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcADCW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcADCW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcADCW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcADCXL, sffxsclsNIL, 0, isasADX, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcADCXL, sffxsclsNIL, 0, isasADX, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcADCXQ, sffxsclsNIL, 0, isasADX, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcADCXQ, sffxsclsNIL, 0, isasADX, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcADDB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeAL), false, actionRW}}},
	{opcADDB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcADDB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcADDB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcADDB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcADDB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcADDL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeEAX), false, actionRW}}},
	{opcADDL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcADDL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcADDL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcADDL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcADDL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcADDL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcADDL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcADDPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcADDPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcADDPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcADDPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcADDQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcADDQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcADDQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeRAX), false, actionRW}}},
	{opcADDQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcADDQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcADDQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcADDQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcADDQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcADDSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcADDSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcADDSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcADDSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcADDSUBPD, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcADDSUBPD, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcADDSUBPS, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcADDSUBPS, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcADDW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeAX), false, actionRW}}},
	{opcADDW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcADDW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcADDW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcADDW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcADDW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcADDW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcADDW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcADOXL, sffxsclsNIL, 0, isasADX, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcADOXL, sffxsclsNIL, 0, isasADX, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcADOXQ, sffxsclsNIL, 0, isasADX, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcADOXQ, sffxsclsNIL, 0, isasADX, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcAESDEC, sffxsclsNIL, 0, isasAES, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcAESDEC, sffxsclsNIL, 0, isasAES, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcAESDECLAST, sffxsclsNIL, 0, isasAES, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcAESDECLAST, sffxsclsNIL, 0, isasAES, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcAESENC, sffxsclsNIL, 0, isasAES, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcAESENC, sffxsclsNIL, 0, isasAES, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcAESENCLAST, sffxsclsNIL, 0, isasAES, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcAESENCLAST, sffxsclsNIL, 0, isasAES, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcAESIMC, sffxsclsNIL, 0, isasAES, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcAESIMC, sffxsclsNIL, 0, isasAES, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcAESKEYGENASSIST, sffxsclsNIL, 0, isasAES, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcAESKEYGENASSIST, sffxsclsNIL, 0, isasAES, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcANDB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeAL), false, actionRW}}},
	{opcANDB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcANDB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcANDB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcANDB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcANDB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcANDL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeEAX), false, actionRW}}},
	{opcANDL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcANDL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcANDL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcANDL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcANDL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcANDL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcANDL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcANDNL, sffxsclsNIL, 0, isasBMI, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcANDNL, sffxsclsNIL, featureCancellingInputs, isasBMI, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcANDNPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcANDNPD, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcANDNPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcANDNPS, sffxsclsNIL, featureCancellingInputs, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcANDNQ, sffxsclsNIL, 0, isasBMI, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcANDNQ, sffxsclsNIL, featureCancellingInputs, isasBMI, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcANDPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcANDPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcANDPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcANDPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcANDQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcANDQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcANDQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeRAX), false, actionRW}}},
	{opcANDQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcANDQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcANDQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcANDQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcANDQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcANDW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeAX), false, actionRW}}},
	{opcANDW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcANDW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcANDW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcANDW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcANDW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcANDW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcANDW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcBEXTRL, sffxsclsNIL, 0, isasBMI, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcBEXTRL, sffxsclsNIL, 0, isasBMI, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcBEXTRQ, sffxsclsNIL, 0, isasBMI, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcBEXTRQ, sffxsclsNIL, 0, isasBMI, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcBLENDPD, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcBLENDPD, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcBLENDPS, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcBLENDPS, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcBLENDVPD, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeXMM0), false, actionR}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcBLENDVPD, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeXMM0), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcBLENDVPS, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeXMM0), false, actionR}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcBLENDVPS, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeXMM0), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcBLSIL, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcBLSIL, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcBLSIQ, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcBLSIQ, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcBLSMSKL, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcBLSMSKL, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcBLSMSKQ, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcBLSMSKQ, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcBLSRL, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcBLSRL, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcBLSRQ, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcBLSRQ, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcBSFL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcBSFL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcBSFQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcBSFQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcBSFW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcBSFW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcBSRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcBSRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcBSRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcBSRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcBSRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcBSRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcBSWAPL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR32), false, actionRW}}},
	{opcBSWAPQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR64), false, actionRW}}},
	{opcBTCL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcBTCL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcBTCL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcBTCL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcBTCQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcBTCQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcBTCQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcBTCQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcBTCW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcBTCW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcBTCW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcBTCW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcBTL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}}},
	{opcBTL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionR}}},
	{opcBTL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionR}}},
	{opcBTL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionR}}},
	{opcBTQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}}},
	{opcBTQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionR}}},
	{opcBTQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionR}}},
	{opcBTQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionR}}},
	{opcBTRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcBTRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcBTRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcBTRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcBTRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcBTRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcBTRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcBTRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcBTRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcBTRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcBTRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcBTRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcBTSL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcBTSL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcBTSL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcBTSL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcBTSQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcBTSQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcBTSQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcBTSQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcBTSW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcBTSW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcBTSW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcBTSW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcBTW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionR}}},
	{opcBTW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionR}}},
	{opcBTW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionR}}},
	{opcBTW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionR}}},
	{opcBZHIL, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcBZHIL, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcBZHIQ, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcBZHIQ, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcCALL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcCBW, sffxsclsNIL, 0, isasBase, 0, oprnds{{uint8(implregAX), true, actionW}, {uint8(implregAL), true, actionR}}},
	{opcCDQ, sffxsclsNIL, 0, isasBase, 0, oprnds{{uint8(implregEAX), true, actionR}, {uint8(implregEDX), true, actionW}}},
	{opcCDQE, sffxsclsNIL, 0, isasBase, 0, oprnds{{uint8(implregEAX), true, actionR}, {uint8(implregRAX), true, actionW}}},
	{opcCLC, sffxsclsNIL, 0, isasBase, 0, oprnds{}},
	{opcCLD, sffxsclsNIL, 0, isasBase, 0, oprnds{}},
	{opcCLFLUSH, sffxsclsNIL, 0, isasCLFLUSH, 1, oprnds{{uint8(oprndtypeM8), false, actionR}}},
	{opcCLFLUSHOPT, sffxsclsNIL, 0, isasCLFLUSHOPT, 1, oprnds{{uint8(oprndtypeM8), false, actionR}}},
	{opcCMC, sffxsclsNIL, 0, isasBase, 0, oprnds{}},
	{opcCMOVLCC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLCC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLCS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLCS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLEQ, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLEQ, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLGE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLGE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLGT, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLGT, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLHI, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLHI, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLLE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLLE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLLS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLLS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLLT, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLLT, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLMI, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLMI, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLNE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLNE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLOC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLOC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLOS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLOS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLPC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLPC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLPL, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLPL, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLPS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVLPS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMOVQCC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQCC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQCS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQCS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQEQ, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQEQ, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQGE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQGE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQGT, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQGT, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQHI, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQHI, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQLE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQLE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQLS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQLS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQLT, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQLT, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQMI, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQMI, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQNE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQNE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQOC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQOC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQOS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQOS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQPC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQPC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQPL, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQPL, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQPS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVQPS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMOVWCC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWCC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWCS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWCS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWEQ, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWEQ, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWGE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWGE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWGT, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWGT, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWHI, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWHI, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWLE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWLE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWLS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWLS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWLT, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWLT, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWMI, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWMI, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWNE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWNE, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWOC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWOC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWOS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWOS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWPC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWPC, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWPL, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWPL, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWPS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMOVWPS, sffxsclsNIL, 0, isasCMOV, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCMPB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeAL), false, actionR}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeR8), false, actionR}}},
	{opcCMPB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeM8), false, actionR}}},
	{opcCMPB, sffxsclsNIL, featureCancellingInputs, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR8), false, actionR}}},
	{opcCMPL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeEAX), false, actionR}, {uint8(oprndtypeIMM32), false, actionN}}},
	{opcCMPL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeIMM32), false, actionN}}},
	{opcCMPL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionR}}},
	{opcCMPL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeIMM32), false, actionN}}},
	{opcCMPL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionR}}},
	{opcCMPL, sffxsclsNIL, featureCancellingInputs, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionR}}},
	{opcCMPPD, sffxsclsNIL, 0, isasSSE2, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPPD, sffxsclsNIL, 0, isasSSE2, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPPS, sffxsclsNIL, 0, isasSSE, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPPS, sffxsclsNIL, 0, isasSSE, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeIMM32), false, actionN}}},
	{opcCMPQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionR}}},
	{opcCMPQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeIMM32), false, actionN}}},
	{opcCMPQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionR}}},
	{opcCMPQ, sffxsclsNIL, featureCancellingInputs, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionR}}},
	{opcCMPQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeRAX), false, actionR}, {uint8(oprndtypeIMM32), false, actionN}}},
	{opcCMPSD, sffxsclsNIL, 0, isasSSE2, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPSD, sffxsclsNIL, 0, isasSSE2, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPSS, sffxsclsNIL, 0, isasSSE, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPSS, sffxsclsNIL, 0, isasSSE, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeAX), false, actionR}, {uint8(oprndtypeIMM16), false, actionN}}},
	{opcCMPW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeIMM16), false, actionN}}},
	{opcCMPW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionR}}},
	{opcCMPW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeIMM16), false, actionN}}},
	{opcCMPW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeIMM8), false, actionN}}},
	{opcCMPW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionR}}},
	{opcCMPW, sffxsclsNIL, featureCancellingInputs, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionR}}},
	{opcCMPXCHG16B, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(implregRAX), true, actionRW}, {uint8(implregRBX), true, actionR}, {uint8(implregRCX), true, actionR}, {uint8(implregRDX), true, actionRW}}},
	{opcCMPXCHG8B, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(implregEAX), true, actionRW}, {uint8(implregEBX), true, actionR}, {uint8(implregECX), true, actionR}, {uint8(implregEDX), true, actionRW}}},
	{opcCMPXCHGB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcCMPXCHGB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcCMPXCHGL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcCMPXCHGL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCMPXCHGQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcCMPXCHGQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCMPXCHGW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcCMPXCHGW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcCOMISD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}}},
	{opcCOMISD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}}},
	{opcCOMISS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}}},
	{opcCOMISS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}}},
	{opcCPUID, sffxsclsNIL, 0, isasCPUID, 0, oprnds{{uint8(implregEAX), true, actionRW}, {uint8(implregEBX), true, actionW}, {uint8(implregECX), true, actionRW}, {uint8(implregEDX), true, actionW}}},
	{opcCQO, sffxsclsNIL, 0, isasBase, 0, oprnds{{uint8(implregRAX), true, actionR}, {uint8(implregRDX), true, actionW}}},
	{opcCRC32B, sffxsclsNIL, 0, isasSSE42, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCRC32B, sffxsclsNIL, 0, isasSSE42, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCRC32B, sffxsclsNIL, 0, isasSSE42, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCRC32B, sffxsclsNIL, 0, isasSSE42, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCRC32L, sffxsclsNIL, 0, isasSSE42, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCRC32L, sffxsclsNIL, 0, isasSSE42, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCRC32Q, sffxsclsNIL, 0, isasSSE42, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCRC32Q, sffxsclsNIL, 0, isasSSE42, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcCRC32W, sffxsclsNIL, 0, isasSSE42, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCRC32W, sffxsclsNIL, 0, isasSSE42, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcCVTPD2PL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcCVTPD2PL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcCVTPD2PS, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcCVTPD2PS, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcCVTPL2PD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcCVTPL2PD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcCVTPL2PS, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcCVTPL2PS, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcCVTPS2PD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcCVTPS2PD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcCVTPS2PL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcCVTPS2PL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcCVTSD2SL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcCVTSD2SL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcCVTSD2SL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcCVTSD2SL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcCVTSD2SS, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcCVTSD2SS, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcCVTSL2SD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcCVTSL2SD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcCVTSL2SS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcCVTSL2SS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcCVTSQ2SD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcCVTSQ2SD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcCVTSQ2SS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcCVTSQ2SS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcCVTSS2SD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcCVTSS2SD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcCVTSS2SL, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcCVTSS2SL, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcCVTSS2SL, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcCVTSS2SL, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcCVTTPD2PL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcCVTTPD2PL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcCVTTPS2PL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcCVTTPS2PL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcCVTTSD2SL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcCVTTSD2SL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcCVTTSD2SQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcCVTTSD2SQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcCVTTSS2SL, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcCVTTSS2SL, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcCVTTSS2SL, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcCVTTSS2SL, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcCWD, sffxsclsNIL, 0, isasBase, 0, oprnds{{uint8(implregAX), true, actionR}, {uint8(implregDX), true, actionW}}},
	{opcCWDE, sffxsclsNIL, 0, isasBase, 0, oprnds{{uint8(implregAX), true, actionR}, {uint8(implregEAX), true, actionW}}},
	{opcDECB, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionRW}}},
	{opcDECB, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionRW}}},
	{opcDECL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM32), false, actionRW}}},
	{opcDECL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR32), false, actionRW}}},
	{opcDECQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM64), false, actionRW}}},
	{opcDECQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR64), false, actionRW}}},
	{opcDECW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM16), false, actionRW}}},
	{opcDECW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR16), false, actionRW}}},
	{opcDIVB, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(implregAX), true, actionRW}}},
	{opcDIVB, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(implregAX), true, actionRW}}},
	{opcDIVL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(implregEAX), true, actionRW}, {uint8(implregEDX), true, actionRW}}},
	{opcDIVL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(implregEAX), true, actionRW}, {uint8(implregEDX), true, actionRW}}},
	{opcDIVPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcDIVPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcDIVPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcDIVPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcDIVQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(implregRAX), true, actionRW}, {uint8(implregRDX), true, actionRW}}},
	{opcDIVQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(implregRAX), true, actionRW}, {uint8(implregRDX), true, actionRW}}},
	{opcDIVSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcDIVSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcDIVSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcDIVSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcDIVW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(implregAX), true, actionRW}, {uint8(implregDX), true, actionRW}}},
	{opcDIVW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(implregAX), true, actionRW}, {uint8(implregDX), true, actionRW}}},
	{opcDPPD, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcDPPD, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcDPPS, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcDPPS, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcEXTRACTPS, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM2U), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM32), false, actionW}}},
	{opcEXTRACTPS, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM2U), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcHADDPD, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcHADDPD, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcHADDPS, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcHADDPS, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcHSUBPD, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcHSUBPD, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcHSUBPS, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcHSUBPS, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcIDIVB, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(implregAX), true, actionRW}}},
	{opcIDIVB, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(implregAX), true, actionRW}}},
	{opcIDIVL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(implregEAX), true, actionRW}, {uint8(implregEDX), true, actionRW}}},
	{opcIDIVL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(implregEAX), true, actionRW}, {uint8(implregEDX), true, actionRW}}},
	{opcIDIVQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(implregRAX), true, actionRW}, {uint8(implregRDX), true, actionRW}}},
	{opcIDIVQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(implregRAX), true, actionRW}, {uint8(implregRDX), true, actionRW}}},
	{opcIDIVW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(implregAX), true, actionRW}, {uint8(implregDX), true, actionRW}}},
	{opcIDIVW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(implregAX), true, actionRW}, {uint8(implregDX), true, actionRW}}},
	{opcIMUL3L, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcIMUL3L, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcIMUL3L, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcIMUL3L, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcIMUL3Q, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcIMUL3Q, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcIMUL3Q, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcIMUL3Q, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcIMUL3W, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcIMUL3W, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcIMUL3W, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcIMUL3W, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcIMULB, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(implregAX), true, actionW}, {uint8(implregAL), true, actionR}}},
	{opcIMULB, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(implregAX), true, actionW}, {uint8(implregAL), true, actionR}}},
	{opcIMULL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcIMULL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(implregEAX), true, actionRW}, {uint8(implregEDX), true, actionW}}},
	{opcIMULL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcIMULL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(implregEAX), true, actionRW}, {uint8(implregEDX), true, actionW}}},
	{opcIMULQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcIMULQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(implregRAX), true, actionRW}, {uint8(implregRDX), true, actionW}}},
	{opcIMULQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcIMULQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(implregRAX), true, actionRW}, {uint8(implregRDX), true, actionW}}},
	{opcIMULW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcIMULW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(implregAX), true, actionRW}, {uint8(implregDX), true, actionW}}},
	{opcIMULW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcIMULW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(implregAX), true, actionRW}, {uint8(implregDX), true, actionW}}},
	{opcINCB, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionRW}}},
	{opcINCB, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionRW}}},
	{opcINCL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM32), false, actionRW}}},
	{opcINCL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR32), false, actionRW}}},
	{opcINCQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM64), false, actionRW}}},
	{opcINCQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR64), false, actionRW}}},
	{opcINCW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM16), false, actionRW}}},
	{opcINCW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR16), false, actionRW}}},
	{opcINSERTPS, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcINSERTPS, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcINT, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtype3), false, actionN}}},
	{opcINT, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeIMM8), false, actionN}}},
	{opcJA, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJA, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJAE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJAE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJB, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJB, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJBE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJBE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJC, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJC, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJCC, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJCC, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJCS, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJCS, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJCXZL, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}, {uint8(implregECX), true, actionR}}},
	{opcJCXZQ, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}, {uint8(implregRCX), true, actionR}}},
	{opcJE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJEQ, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJEQ, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJG, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJG, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJGE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJGE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJGT, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJGT, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJHI, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJHI, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJHS, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJHS, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJL, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJL, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJLE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJLE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJLO, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJLO, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJLS, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJLS, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJLT, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJLT, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJMI, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJMI, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJMP, sffxsclsNIL, featureBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJMP, sffxsclsNIL, featureBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJMP, sffxsclsNIL, featureBranch, isasBase, 1, oprnds{{uint8(oprndtypeM64), false, actionR}}},
	{opcJMP, sffxsclsNIL, featureBranch, isasBase, 1, oprnds{{uint8(oprndtypeR64), false, actionR}}},
	{opcJNA, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJNA, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJNAE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJNAE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJNB, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJNB, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJNBE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJNBE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJNC, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJNC, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJNE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJNE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJNG, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJNG, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJNGE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJNGE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJNL, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJNL, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJNLE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJNLE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJNO, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJNO, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJNP, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJNP, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJNS, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJNS, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJNZ, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJNZ, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJO, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJO, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJOC, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJOC, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJOS, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJOS, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJP, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJP, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJPC, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJPC, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJPE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJPE, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJPL, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJPL, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJPO, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJPO, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJPS, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJPS, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJS, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJS, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcJZ, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL32), false, actionN}}},
	{opcJZ, sffxsclsNIL, featureBranch | featureConditionalBranch, isasBase, 1, oprnds{{uint8(oprndtypeREL8), false, actionN}}},
	{opcKADDB, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKADDD, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKADDQ, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKADDW, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKANDB, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKANDD, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKANDNB, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKANDND, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKANDNQ, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKANDNW, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKANDQ, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKANDW, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKMOVB, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKMOVB, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM8), false, actionW}}},
	{opcKMOVB, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcKMOVB, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKMOVB, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKMOVD, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKMOVD, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM32), false, actionW}}},
	{opcKMOVD, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcKMOVD, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKMOVD, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKMOVQ, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKMOVQ, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcKMOVQ, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcKMOVQ, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKMOVQ, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKMOVW, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKMOVW, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM16), false, actionW}}},
	{opcKMOVW, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcKMOVW, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKMOVW, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKNOTB, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKNOTD, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKNOTQ, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKNOTW, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKORB, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKORD, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKORQ, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKORTESTB, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}}},
	{opcKORTESTD, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}}},
	{opcKORTESTQ, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}}},
	{opcKORTESTW, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}}},
	{opcKORW, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKSHIFTLB, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKSHIFTLD, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKSHIFTLQ, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKSHIFTLW, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKSHIFTRB, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKSHIFTRD, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKSHIFTRQ, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKSHIFTRW, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKTESTB, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}}},
	{opcKTESTD, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}}},
	{opcKTESTQ, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}}},
	{opcKTESTW, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}}},
	{opcKUNPCKBW, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKUNPCKDQ, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKUNPCKWD, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKXNORB, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKXNORD, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKXNORQ, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKXNORW, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKXORB, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKXORD, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKXORQ, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcKXORW, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcLDDQU, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcLDMXCSR, sffxsclsNIL, 0, isasSSE, 1, oprnds{{uint8(oprndtypeM32), false, actionR}}},
	{opcLEAL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcLEAQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcLEAW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcLFENCE, sffxsclsNIL, 0, isasSSE2, 0, oprnds{}},
	{opcLZCNTL, sffxsclsNIL, 0, isasLZCNT, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcLZCNTL, sffxsclsNIL, 0, isasLZCNT, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcLZCNTQ, sffxsclsNIL, 0, isasLZCNT, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcLZCNTQ, sffxsclsNIL, 0, isasLZCNT, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcLZCNTW, sffxsclsNIL, 0, isasLZCNT, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcLZCNTW, sffxsclsNIL, 0, isasLZCNT, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcMASKMOVDQU, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(implregRDI), true, actionR}}},
	{opcMASKMOVOU, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(implregRDI), true, actionR}}},
	{opcMAXPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMAXPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMAXPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMAXPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMAXSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMAXSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMAXSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMAXSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMFENCE, sffxsclsNIL, 0, isasSSE2, 0, oprnds{}},
	{opcMINPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMINPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMINPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMINPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMINSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMINSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMINSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMINSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMONITOR, sffxsclsNIL, 0, isasMONITOR, 0, oprnds{{uint8(implregRAX), true, actionR}, {uint8(implregECX), true, actionR}, {uint8(implregEDX), true, actionR}}},
	{opcMOVAPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVAPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcMOVAPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVAPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVAPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcMOVAPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionW}}},
	{opcMOVB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR8), false, actionW}}},
	{opcMOVB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeR8), false, actionW}}},
	{opcMOVB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeM8), false, actionW}}},
	{opcMOVB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR8), false, actionW}}},
	{opcMOVBELL, sffxsclsNIL, 0, isasMOVBE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVBELL, sffxsclsNIL, 0, isasMOVBE, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionW}}},
	{opcMOVBEQQ, sffxsclsNIL, 0, isasMOVBE, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVBEQQ, sffxsclsNIL, 0, isasMOVBE, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcMOVBEWW, sffxsclsNIL, 0, isasMOVBE, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcMOVBEWW, sffxsclsNIL, 0, isasMOVBE, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionW}}},
	{opcMOVBLSX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVBLSX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVBLZX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVBLZX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVBQSX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVBQSX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVBQZX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVBQZX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVBWSX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcMOVBWSX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcMOVBWZX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcMOVBWZX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcMOVD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM32), false, actionW}}},
	{opcMOVD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcMOVD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVD, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM64), false, actionW}}},
	{opcMOVD, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVD, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM64), false, actionN}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVD, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVD, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcMOVD, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVDDUP, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVDDUP, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVDQ2Q, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVDQ2Q, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVDQ2Q, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVDQ2Q, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVDQ2Q, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM32), false, actionW}}},
	{opcMOVDQ2Q, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcMOVDQ2Q, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVDQ2Q, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVDQ2Q, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVDQ2Q, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM64), false, actionW}}},
	{opcMOVDQ2Q, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVDQ2Q, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM64), false, actionN}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVDQ2Q, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVDQ2Q, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcMOVDQ2Q, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVHLPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMOVHPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMOVHPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcMOVHPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMOVHPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcMOVL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM32), false, actionW}}},
	{opcMOVL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionW}}},
	{opcMOVL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVLHPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMOVLPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMOVLPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcMOVLPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMOVLPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcMOVLQSX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVLQSX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVLQZX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVMSKPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVMSKPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVNTDQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcMOVNTDQA, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVNTIL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionW}}},
	{opcMOVNTIQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcMOVNTO, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcMOVNTPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcMOVNTPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcMOVO, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVO, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcMOVO, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVOA, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVOA, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcMOVOA, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVOU, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVOU, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcMOVOU, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM32), false, actionW}}},
	{opcMOVQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcMOVQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM64), false, actionW}}},
	{opcMOVQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM64), false, actionN}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcMOVQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcMOVSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMOVSHDUP, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVSHDUP, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVSLDUP, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVSLDUP, sffxsclsNIL, 0, isasSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM32), false, actionW}}},
	{opcMOVSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMOVUPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVUPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcMOVUPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVUPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVUPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcMOVUPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcMOVW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeM16), false, actionW}}},
	{opcMOVW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeR16), false, actionW}}},
	{opcMOVW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcMOVW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionW}}},
	{opcMOVW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcMOVWLSX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVWLSX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVWLZX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVWLZX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcMOVWQSX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVWQSX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVWQZX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMOVWQZX, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcMPSADBW, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMPSADBW, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMULB, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(implregAX), true, actionW}, {uint8(implregAL), true, actionR}}},
	{opcMULB, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(implregAX), true, actionW}, {uint8(implregAL), true, actionR}}},
	{opcMULL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(implregEAX), true, actionRW}, {uint8(implregEDX), true, actionW}}},
	{opcMULL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(implregEAX), true, actionRW}, {uint8(implregEDX), true, actionW}}},
	{opcMULPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMULPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMULPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMULPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMULQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(implregRAX), true, actionRW}, {uint8(implregRDX), true, actionW}}},
	{opcMULQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(implregRAX), true, actionRW}, {uint8(implregRDX), true, actionW}}},
	{opcMULSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMULSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMULSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMULSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcMULW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(implregAX), true, actionRW}, {uint8(implregDX), true, actionW}}},
	{opcMULW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(implregAX), true, actionRW}, {uint8(implregDX), true, actionW}}},
	{opcMULXL, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}, {uint8(oprndtypeR32), false, actionW}, {uint8(implregEDX), true, actionR}}},
	{opcMULXL, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}, {uint8(oprndtypeR32), false, actionW}, {uint8(implregEDX), true, actionR}}},
	{opcMULXQ, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}, {uint8(oprndtypeR64), false, actionW}, {uint8(implregRDX), true, actionR}}},
	{opcMULXQ, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}, {uint8(oprndtypeR64), false, actionW}, {uint8(implregRDX), true, actionR}}},
	{opcMWAIT, sffxsclsNIL, 0, isasMONITOR, 0, oprnds{{uint8(implregEAX), true, actionR}, {uint8(implregECX), true, actionR}}},
	{opcNEGB, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionRW}}},
	{opcNEGB, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionRW}}},
	{opcNEGL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM32), false, actionRW}}},
	{opcNEGL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR32), false, actionRW}}},
	{opcNEGQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM64), false, actionRW}}},
	{opcNEGQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR64), false, actionRW}}},
	{opcNEGW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM16), false, actionRW}}},
	{opcNEGW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR16), false, actionRW}}},
	{opcNOP, sffxsclsNIL, 0, isasBase, 0, oprnds{}},
	{opcNOTB, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionRW}}},
	{opcNOTB, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionRW}}},
	{opcNOTL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM32), false, actionRW}}},
	{opcNOTL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR32), false, actionRW}}},
	{opcNOTQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM64), false, actionRW}}},
	{opcNOTQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR64), false, actionRW}}},
	{opcNOTW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM16), false, actionRW}}},
	{opcNOTW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR16), false, actionRW}}},
	{opcORB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeAL), false, actionRW}}},
	{opcORB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcORB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcORB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcORB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcORB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcORL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeEAX), false, actionRW}}},
	{opcORL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcORL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcORL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcORL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcORL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcORL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcORL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcORPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcORPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcORPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcORPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcORQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcORQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcORQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeRAX), false, actionRW}}},
	{opcORQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcORQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcORQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcORQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcORQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcORW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeAX), false, actionRW}}},
	{opcORW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcORW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcORW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcORW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcORW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcORW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcORW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcPABSB, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPABSB, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPABSD, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPABSD, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPABSW, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPABSW, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPACKSSLW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPACKSSLW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPACKSSWB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPACKSSWB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPACKUSDW, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPACKUSDW, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPACKUSWB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPACKUSWB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDSB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDSB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDSW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDSW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDUSB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDUSB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDUSW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDUSW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPADDW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPALIGNR, sffxsclsNIL, 0, isasSSSE3, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPALIGNR, sffxsclsNIL, 0, isasSSSE3, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPAND, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPAND, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPANDN, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPANDN, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPAUSE, sffxsclsNIL, 0, isasBase, 0, oprnds{}},
	{opcPAVGB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPAVGB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPAVGW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPAVGW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPBLENDVB, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeXMM0), false, actionR}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPBLENDVB, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeXMM0), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPBLENDW, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPBLENDW, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCLMULQDQ, sffxsclsNIL, 0, isasPCLMULQDQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCLMULQDQ, sffxsclsNIL, 0, isasPCLMULQDQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPEQB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPEQB, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPEQL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPEQL, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPEQQ, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPEQQ, sffxsclsNIL, featureCancellingInputs, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPEQW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPEQW, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPESTRI, sffxsclsNIL, 0, isasSSE42, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(implregEAX), true, actionR}, {uint8(implregECX), true, actionW}, {uint8(implregEDX), true, actionR}}},
	{opcPCMPESTRI, sffxsclsNIL, 0, isasSSE42, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(implregEAX), true, actionR}, {uint8(implregECX), true, actionW}, {uint8(implregEDX), true, actionR}}},
	{opcPCMPESTRM, sffxsclsNIL, 0, isasSSE42, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(implregEAX), true, actionR}, {uint8(implregEDX), true, actionR}, {uint8(implregX0), true, actionW}}},
	{opcPCMPESTRM, sffxsclsNIL, 0, isasSSE42, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(implregEAX), true, actionR}, {uint8(implregEDX), true, actionR}, {uint8(implregX0), true, actionW}}},
	{opcPCMPGTB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPGTB, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPGTL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPGTL, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPGTQ, sffxsclsNIL, 0, isasSSE42, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPGTQ, sffxsclsNIL, featureCancellingInputs, isasSSE42, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPGTW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPGTW, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPCMPISTRI, sffxsclsNIL, 0, isasSSE42, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(implregECX), true, actionW}}},
	{opcPCMPISTRI, sffxsclsNIL, 0, isasSSE42, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(implregECX), true, actionW}}},
	{opcPCMPISTRM, sffxsclsNIL, 0, isasSSE42, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(implregX0), true, actionW}}},
	{opcPCMPISTRM, sffxsclsNIL, 0, isasSSE42, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(implregX0), true, actionW}}},
	{opcPDEPL, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcPDEPL, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcPDEPQ, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcPDEPQ, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcPEXTL, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcPEXTL, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcPEXTQ, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcPEXTQ, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcPEXTRB, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM8), false, actionW}}},
	{opcPEXTRB, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcPEXTRD, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM32), false, actionW}}},
	{opcPEXTRD, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcPEXTRQ, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcPEXTRQ, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcPEXTRW, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM16), false, actionW}}},
	{opcPEXTRW, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcPHADDD, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPHADDD, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPHADDSW, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPHADDSW, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPHADDW, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPHADDW, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPHMINPOSUW, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPHMINPOSUW, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPHSUBD, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPHSUBD, sffxsclsNIL, featureCancellingInputs, isasSSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPHSUBSW, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPHSUBSW, sffxsclsNIL, featureCancellingInputs, isasSSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPHSUBW, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPHSUBW, sffxsclsNIL, featureCancellingInputs, isasSSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPINSRB, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPINSRB, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPINSRD, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPINSRD, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPINSRQ, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPINSRQ, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPINSRW, sffxsclsNIL, 0, isasSSE2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPINSRW, sffxsclsNIL, 0, isasSSE2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMADDUBSW, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMADDUBSW, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMADDWL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMADDWL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMAXSB, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMAXSB, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMAXSD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMAXSD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMAXSW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMAXSW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMAXUB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMAXUB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMAXUD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMAXUD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMAXUW, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMAXUW, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMINSB, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMINSB, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMINSD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMINSD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMINSW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMINSW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMINUB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMINUB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMINUD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMINUD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMINUW, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMINUW, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMOVMSKB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcPMOVSXBD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVSXBD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVSXBQ, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVSXBQ, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVSXBW, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVSXBW, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVSXDQ, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVSXDQ, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVSXWD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVSXWD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVSXWQ, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVSXWQ, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVZXBD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVZXBD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVZXBQ, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVZXBQ, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVZXBW, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVZXBW, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVZXDQ, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVZXDQ, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVZXWD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVZXWD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVZXWQ, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMOVZXWQ, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPMULDQ, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMULDQ, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMULHRSW, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMULHRSW, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMULHUW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMULHUW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMULHW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMULHW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMULLD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMULLD, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMULLW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMULLW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMULULQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPMULULQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPOPCNTL, sffxsclsNIL, 0, isasPOPCNT, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcPOPCNTL, sffxsclsNIL, 0, isasPOPCNT, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcPOPCNTQ, sffxsclsNIL, 0, isasPOPCNT, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcPOPCNTQ, sffxsclsNIL, 0, isasPOPCNT, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcPOPCNTW, sffxsclsNIL, 0, isasPOPCNT, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcPOPCNTW, sffxsclsNIL, 0, isasPOPCNT, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcPOPQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM64), false, actionW}}},
	{opcPOPQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR64), false, actionW}}},
	{opcPOPW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM16), false, actionW}}},
	{opcPOPW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR16), false, actionW}}},
	{opcPOR, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPOR, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPREFETCHNTA, sffxsclsNIL, 0, isasMMX, 1, oprnds{{uint8(oprndtypeM8), false, actionR}}},
	{opcPREFETCHT0, sffxsclsNIL, 0, isasMMX, 1, oprnds{{uint8(oprndtypeM8), false, actionR}}},
	{opcPREFETCHT1, sffxsclsNIL, 0, isasMMX, 1, oprnds{{uint8(oprndtypeM8), false, actionR}}},
	{opcPREFETCHT2, sffxsclsNIL, 0, isasMMX, 1, oprnds{{uint8(oprndtypeM8), false, actionR}}},
	{opcPSADBW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSADBW, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSHUFB, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSHUFB, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSHUFD, sffxsclsNIL, 0, isasSSE2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPSHUFD, sffxsclsNIL, 0, isasSSE2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPSHUFHW, sffxsclsNIL, 0, isasSSE2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSHUFHW, sffxsclsNIL, 0, isasSSE2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSHUFL, sffxsclsNIL, 0, isasSSE2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPSHUFL, sffxsclsNIL, 0, isasSSE2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPSHUFLW, sffxsclsNIL, 0, isasSSE2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSHUFLW, sffxsclsNIL, 0, isasSSE2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSIGNB, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPSIGNB, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPSIGND, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPSIGND, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPSIGNW, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPSIGNW, sffxsclsNIL, 0, isasSSSE3, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcPSLLDQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSLLL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSLLL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSLLL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSLLO, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSLLQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSLLQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSLLQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSLLW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSLLW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSLLW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRAL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRAL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRAL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRAW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRAW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRAW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRLDQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRLL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRLL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRLL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRLO, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRLQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRLQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRLQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRLW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRLW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSRLW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSUBB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSUBB, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSUBL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSUBL, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSUBQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSUBQ, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSUBSB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSUBSB, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSUBSW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSUBSW, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSUBUSB, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSUBUSB, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSUBUSW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSUBUSW, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSUBW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPSUBW, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPTEST, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}}},
	{opcPTEST, sffxsclsNIL, 0, isasSSE41, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}}},
	{opcPUNPCKHBW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPUNPCKHBW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPUNPCKHLQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPUNPCKHLQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPUNPCKHQDQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPUNPCKHQDQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPUNPCKHWL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPUNPCKHWL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPUNPCKLBW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPUNPCKLBW, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPUNPCKLLQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPUNPCKLLQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPUNPCKLQDQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPUNPCKLQDQ, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPUNPCKLWL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPUNPCKLWL, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPUSHQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeIMM32), false, actionN}}},
	{opcPUSHQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeIMM8), false, actionN}}},
	{opcPUSHQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM64), false, actionR}}},
	{opcPUSHQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR64), false, actionR}}},
	{opcPUSHW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM16), false, actionR}}},
	{opcPUSHW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR16), false, actionR}}},
	{opcPXOR, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcPXOR, sffxsclsNIL, featureCancellingInputs, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcRCLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcRCLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcRCLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcRCLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcRCLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcRCLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcRCLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcRCLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcRCLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcRCLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcRCLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcRCLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcRCLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcRCLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcRCLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcRCLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcRCLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcRCLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcRCLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcRCLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcRCLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcRCLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcRCLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcRCLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcRCPPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcRCPPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcRCPSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcRCPSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcRCRB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcRCRB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcRCRB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcRCRB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcRCRB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcRCRB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcRCRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcRCRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcRCRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcRCRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcRCRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcRCRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcRCRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcRCRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcRCRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcRCRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcRCRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcRCRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcRCRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcRCRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcRCRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcRCRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcRCRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcRCRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcRDRANDL, sffxsclsNIL, 0, isasRDRAND, 1, oprnds{{uint8(oprndtypeR16), false, actionW}}},
	{opcRDRANDL, sffxsclsNIL, 0, isasRDRAND, 1, oprnds{{uint8(oprndtypeR32), false, actionW}}},
	{opcRDRANDL, sffxsclsNIL, 0, isasRDRAND, 1, oprnds{{uint8(oprndtypeR64), false, actionW}}},
	{opcRDSEEDL, sffxsclsNIL, 0, isasRDSEED, 1, oprnds{{uint8(oprndtypeR16), false, actionW}}},
	{opcRDSEEDL, sffxsclsNIL, 0, isasRDSEED, 1, oprnds{{uint8(oprndtypeR32), false, actionW}}},
	{opcRDSEEDL, sffxsclsNIL, 0, isasRDSEED, 1, oprnds{{uint8(oprndtypeR64), false, actionW}}},
	{opcRDTSC, sffxsclsNIL, 0, isasRDTSC, 0, oprnds{{uint8(implregEAX), true, actionW}, {uint8(implregEDX), true, actionW}}},
	{opcRDTSCP, sffxsclsNIL, 0, isasRDTSCP, 0, oprnds{{uint8(implregEAX), true, actionW}, {uint8(implregECX), true, actionW}, {uint8(implregEDX), true, actionW}}},
	{opcRET, sffxsclsNIL, featureTerminal, isasBase, 0, oprnds{}},
	{opcRETFL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeIMM16), false, actionN}}},
	{opcRETFQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeIMM16), false, actionN}}},
	{opcRETFW, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeIMM16), false, actionN}}},
	{opcROLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcROLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcROLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcROLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcROLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcROLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcROLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcROLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcROLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcROLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcROLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcROLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcROLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcROLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcROLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcROLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcROLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcROLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcROLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcROLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcROLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcROLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcROLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcROLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcRORB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcRORB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcRORB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcRORB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcRORB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcRORB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcRORL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcRORL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcRORL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcRORL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcRORL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcRORL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcRORQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcRORQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcRORQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcRORQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcRORQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcRORQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcRORW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcRORW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcRORW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcRORW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcRORW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcRORW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcRORXL, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcRORXL, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcRORXQ, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcRORXQ, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcROUNDPD, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcROUNDPD, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcROUNDPS, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcROUNDPS, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcROUNDSD, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcROUNDSD, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcROUNDSS, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcROUNDSS, sffxsclsNIL, 0, isasSSE41, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcRSQRTPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcRSQRTPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcRSQRTSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcRSQRTSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSALB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcSALB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSALB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcSALB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSALB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcSALB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSALL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSALL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSALL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSALL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSALL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSALL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSALQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSALQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSALQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSALQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSALQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSALQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSALW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSALW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSALW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSALW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSALW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSALW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSARB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcSARB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSARB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcSARB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSARB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcSARB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSARL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSARL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSARL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSARL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSARL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSARL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSARQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSARQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSARQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSARQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSARQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSARQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSARW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSARW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSARW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSARW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSARW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSARW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSARXL, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcSARXL, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcSARXQ, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcSARXQ, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcSBBB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeAL), false, actionRW}}},
	{opcSBBB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcSBBB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSBBB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSBBB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcSBBB, sffxsclsNIL, featureCancellingInputs, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSBBL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeEAX), false, actionRW}}},
	{opcSBBL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSBBL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSBBL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSBBL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSBBL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSBBL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSBBL, sffxsclsNIL, featureCancellingInputs, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSBBQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSBBQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSBBQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeRAX), false, actionRW}}},
	{opcSBBQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSBBQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSBBQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSBBQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSBBQ, sffxsclsNIL, featureCancellingInputs, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSBBW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeAX), false, actionRW}}},
	{opcSBBW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSBBW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSBBW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSBBW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSBBW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSBBW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSBBW, sffxsclsNIL, featureCancellingInputs, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSETCC, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionW}}},
	{opcSETCC, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionW}}},
	{opcSETCS, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionW}}},
	{opcSETCS, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionW}}},
	{opcSETEQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionW}}},
	{opcSETEQ, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionW}}},
	{opcSETGE, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionW}}},
	{opcSETGE, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionW}}},
	{opcSETGT, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionW}}},
	{opcSETGT, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionW}}},
	{opcSETHI, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionW}}},
	{opcSETHI, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionW}}},
	{opcSETLE, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionW}}},
	{opcSETLE, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionW}}},
	{opcSETLS, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionW}}},
	{opcSETLS, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionW}}},
	{opcSETLT, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionW}}},
	{opcSETLT, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionW}}},
	{opcSETMI, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionW}}},
	{opcSETMI, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionW}}},
	{opcSETNE, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionW}}},
	{opcSETNE, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionW}}},
	{opcSETOC, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionW}}},
	{opcSETOC, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionW}}},
	{opcSETOS, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionW}}},
	{opcSETOS, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionW}}},
	{opcSETPC, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionW}}},
	{opcSETPC, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionW}}},
	{opcSETPL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionW}}},
	{opcSETPL, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionW}}},
	{opcSETPS, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeM8), false, actionW}}},
	{opcSETPS, sffxsclsNIL, 0, isasBase, 1, oprnds{{uint8(oprndtypeR8), false, actionW}}},
	{opcSFENCE, sffxsclsNIL, 0, isasMMX, 0, oprnds{}},
	{opcSHA1MSG1, sffxsclsNIL, 0, isasSHA, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHA1MSG1, sffxsclsNIL, 0, isasSHA, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHA1MSG2, sffxsclsNIL, 0, isasSHA, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHA1MSG2, sffxsclsNIL, 0, isasSHA, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHA1NEXTE, sffxsclsNIL, 0, isasSHA, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHA1NEXTE, sffxsclsNIL, 0, isasSHA, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHA1RNDS4, sffxsclsNIL, 0, isasSHA, 3, oprnds{{uint8(oprndtypeIMM2U), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHA1RNDS4, sffxsclsNIL, 0, isasSHA, 3, oprnds{{uint8(oprndtypeIMM2U), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHA256MSG1, sffxsclsNIL, 0, isasSHA, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHA256MSG1, sffxsclsNIL, 0, isasSHA, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHA256MSG2, sffxsclsNIL, 0, isasSHA, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHA256MSG2, sffxsclsNIL, 0, isasSHA, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHA256RNDS2, sffxsclsNIL, 0, isasSHA, 3, oprnds{{uint8(oprndtypeXMM0), false, actionR}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHA256RNDS2, sffxsclsNIL, 0, isasSHA, 3, oprnds{{uint8(oprndtypeXMM0), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcSHLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSHLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcSHLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSHLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcSHLB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSHLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSHLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSHLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSHLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSHLL, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSHLL, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSHLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSHLL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSHLL, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSHLL, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSHLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSHLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSHLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSHLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSHLQ, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSHLQ, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSHLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSHLQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSHLQ, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSHLQ, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSHLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSHLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSHLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSHLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSHLW, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSHLW, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSHLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSHLW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSHLW, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSHLW, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSHLXL, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcSHLXL, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcSHLXQ, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcSHLXQ, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcSHRB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcSHRB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSHRB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcSHRB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSHRB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcSHRB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSHRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSHRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSHRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSHRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSHRL, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSHRL, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSHRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSHRL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSHRL, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSHRL, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSHRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSHRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSHRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSHRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSHRQ, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSHRQ, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSHRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSHRQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSHRQ, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSHRQ, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSHRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSHRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtype1), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSHRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSHRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSHRW, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSHRW, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeCL), false, actionR}, {uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSHRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSHRW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSHRW, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSHRW, sffxsclsNIL, 0, isasBase, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSHRXL, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcSHRXL, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcSHRXQ, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcSHRXQ, sffxsclsNIL, 0, isasBMI2, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcSHUFPD, sffxsclsNIL, 0, isasSSE2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHUFPD, sffxsclsNIL, 0, isasSSE2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHUFPS, sffxsclsNIL, 0, isasSSE, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSHUFPS, sffxsclsNIL, 0, isasSSE, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSQRTPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcSQRTPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcSQRTPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcSQRTPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcSQRTSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSQRTSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSQRTSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSQRTSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSTC, sffxsclsNIL, 0, isasBase, 0, oprnds{}},
	{opcSTD, sffxsclsNIL, 0, isasBase, 0, oprnds{}},
	{opcSTMXCSR, sffxsclsNIL, 0, isasSSE, 1, oprnds{{uint8(oprndtypeM32), false, actionW}}},
	{opcSUBB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeAL), false, actionRW}}},
	{opcSUBB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcSUBB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSUBB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM8), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSUBB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeM8), false, actionRW}}},
	{opcSUBB, sffxsclsNIL, featureCancellingInputs, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR8), false, actionRW}}},
	{opcSUBL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeEAX), false, actionRW}}},
	{opcSUBL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSUBL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSUBL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSUBL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSUBL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSUBL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionRW}}},
	{opcSUBL, sffxsclsNIL, featureCancellingInputs, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionRW}}},
	{opcSUBPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSUBPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSUBPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSUBPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSUBQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSUBQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSUBQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeRAX), false, actionRW}}},
	{opcSUBQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSUBQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSUBQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSUBQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcSUBQ, sffxsclsNIL, featureCancellingInputs, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionRW}}},
	{opcSUBSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSUBSD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSUBSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSUBSS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcSUBW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeAX), false, actionRW}}},
	{opcSUBW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSUBW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSUBW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSUBW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSUBW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSUBW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionRW}}},
	{opcSUBW, sffxsclsNIL, featureCancellingInputs, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionRW}}},
	{opcSYSCALL, sffxsclsNIL, 0, isasBase, 0, oprnds{{uint8(implregR11), true, actionW}, {uint8(implregRCX), true, actionW}}},
	{opcTESTB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeAL), false, actionR}}},
	{opcTESTB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM8), false, actionR}}},
	{opcTESTB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeR8), false, actionR}}},
	{opcTESTB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeM8), false, actionR}}},
	{opcTESTB, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR8), false, actionR}, {uint8(oprndtypeR8), false, actionR}}},
	{opcTESTL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeEAX), false, actionR}}},
	{opcTESTL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM32), false, actionR}}},
	{opcTESTL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR32), false, actionR}}},
	{opcTESTL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeM32), false, actionR}}},
	{opcTESTL, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionR}}},
	{opcTESTQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeM64), false, actionR}}},
	{opcTESTQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeR64), false, actionR}}},
	{opcTESTQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM32), false, actionN}, {uint8(oprndtypeRAX), false, actionR}}},
	{opcTESTQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeM64), false, actionR}}},
	{opcTESTQ, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionR}}},
	{opcTESTW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeAX), false, actionR}}},
	{opcTESTW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeM16), false, actionR}}},
	{opcTESTW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeIMM16), false, actionN}, {uint8(oprndtypeR16), false, actionR}}},
	{opcTESTW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeM16), false, actionR}}},
	{opcTESTW, sffxsclsNIL, 0, isasBase, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionR}}},
	{opcTZCNTL, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcTZCNTL, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcTZCNTQ, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcTZCNTQ, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcTZCNTW, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeM16), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcTZCNTW, sffxsclsNIL, 0, isasBMI, 2, oprnds{{uint8(oprndtypeR16), false, actionR}, {uint8(oprndtypeR16), false, actionW}}},
	{opcUCOMISD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}}},
	{opcUCOMISD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}}},
	{opcUCOMISS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}}},
	{opcUCOMISS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}}},
	{opcUD2, sffxsclsNIL, 0, isasBase, 0, oprnds{}},
	{opcUNPCKHPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcUNPCKHPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcUNPCKHPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcUNPCKHPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcUNPCKLPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcUNPCKLPD, sffxsclsNIL, 0, isasSSE2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcUNPCKLPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcUNPCKLPS, sffxsclsNIL, 0, isasSSE, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVADDPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVADDPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVADDPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVADDPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVADDPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVADDPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVADDPD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVADDPD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVADDPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVADDPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVADDPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVADDPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVADDPD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVADDPD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVADDPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVADDPD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVADDPD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVADDPD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVADDPD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVADDPD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVADDPD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVADDPD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVADDPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVADDPD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVADDPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVADDPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVADDPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVADDPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVADDPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVADDPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVADDPS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVADDPS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVADDPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVADDPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVADDPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVADDPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVADDPS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVADDPS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVADDPS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVADDPS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVADDPS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVADDPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVADDPS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVADDPS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVADDPS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVADDPS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVADDPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVADDPS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVADDSD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDSD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVADDSD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVADDSD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVADDSD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDSD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDSD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDSS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDSS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVADDSS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVADDSS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVADDSS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDSS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDSS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDSUBPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDSUBPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVADDSUBPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDSUBPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVADDSUBPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDSUBPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVADDSUBPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVADDSUBPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVAESDEC, sffxsclsNIL, 0, isasAES_AVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVAESDEC, sffxsclsNIL, 0, isasAES_AVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVAESDECLAST, sffxsclsNIL, 0, isasAES_AVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVAESDECLAST, sffxsclsNIL, 0, isasAES_AVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVAESENC, sffxsclsNIL, 0, isasAES_AVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVAESENC, sffxsclsNIL, 0, isasAES_AVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVAESENCLAST, sffxsclsNIL, 0, isasAES_AVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVAESENCLAST, sffxsclsNIL, 0, isasAES_AVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVAESIMC, sffxsclsNIL, 0, isasAES_AVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVAESIMC, sffxsclsNIL, 0, isasAES_AVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVAESKEYGENASSIST, sffxsclsNIL, 0, isasAES_AVX, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVAESKEYGENASSIST, sffxsclsNIL, 0, isasAES_AVX, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVALIGND, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVALIGND, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVALIGND, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVALIGND, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVALIGND, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVALIGND, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVALIGND, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVALIGND, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVALIGND, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVALIGND, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVALIGND, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVALIGND, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVALIGND, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVALIGND, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVALIGND, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVALIGND, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVALIGND, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVALIGND, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVALIGND, sffxsclsBCST, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVALIGND, sffxsclsBCST_Z, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVALIGND, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVALIGND, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVALIGND, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVALIGND, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVALIGND, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVALIGND, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVALIGND, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVALIGNQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVALIGNQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVALIGNQ, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVALIGNQ, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVALIGNQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVALIGNQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVALIGNQ, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsBCST, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVALIGNQ, sffxsclsBCST_Z, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVALIGNQ, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVALIGNQ, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDNPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDNPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDNPD, sffxsclsNIL, featureCancellingInputs, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDNPD, sffxsclsNIL, featureCancellingInputs, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDNPD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVANDNPD, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDNPD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVANDNPD, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDNPD, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVANDNPD, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDNPD, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDNPD, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVANDNPD, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDNPD, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDNPD, sffxsclsNIL, featureCancellingInputs, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVANDNPD, sffxsclsZ, featureCancellingInputs, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDNPD, sffxsclsNIL, featureCancellingInputs, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVANDNPD, sffxsclsZ, featureCancellingInputs, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDNPD, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVANDNPD, sffxsclsZ, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDNPD, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDNPD, sffxsclsBCST, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVANDNPD, sffxsclsBCST_Z, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDNPD, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDNPD, sffxsclsNIL, featureCancellingInputs, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVANDNPD, sffxsclsZ, featureCancellingInputs, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDNPD, sffxsclsNIL, featureCancellingInputs, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDNPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDNPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDNPS, sffxsclsNIL, featureCancellingInputs, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDNPS, sffxsclsNIL, featureCancellingInputs, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDNPS, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVANDNPS, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDNPS, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVANDNPS, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDNPS, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVANDNPS, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDNPS, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDNPS, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVANDNPS, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDNPS, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDNPS, sffxsclsNIL, featureCancellingInputs, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVANDNPS, sffxsclsZ, featureCancellingInputs, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDNPS, sffxsclsNIL, featureCancellingInputs, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVANDNPS, sffxsclsZ, featureCancellingInputs, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDNPS, sffxsclsBCST, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVANDNPS, sffxsclsBCST_Z, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDNPS, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDNPS, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVANDNPS, sffxsclsZ, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDNPS, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDNPS, sffxsclsNIL, featureCancellingInputs, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVANDNPS, sffxsclsZ, featureCancellingInputs, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDNPS, sffxsclsNIL, featureCancellingInputs, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDPD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVANDPD, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDPD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVANDPD, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDPD, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVANDPD, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDPD, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDPD, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVANDPD, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDPD, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDPD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVANDPD, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDPD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVANDPD, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDPD, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVANDPD, sffxsclsZ, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDPD, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDPD, sffxsclsBCST, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVANDPD, sffxsclsBCST_Z, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDPD, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDPD, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVANDPD, sffxsclsZ, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDPD, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDPS, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVANDPS, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDPS, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVANDPS, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDPS, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVANDPS, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDPS, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDPS, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVANDPS, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDPS, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDPS, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVANDPS, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVANDPS, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVANDPS, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVANDPS, sffxsclsBCST, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVANDPS, sffxsclsBCST_Z, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDPS, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDPS, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVANDPS, sffxsclsZ, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDPS, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDPS, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVANDPS, sffxsclsZ, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVANDPS, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVBLENDMPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBLENDMPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVBLENDMPD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBLENDMPD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVBLENDMPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBLENDMPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBLENDMPD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBLENDMPD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBLENDMPD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBLENDMPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVBLENDMPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBLENDMPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVBLENDMPS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBLENDMPS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVBLENDMPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBLENDMPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBLENDMPS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBLENDMPS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBLENDMPS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBLENDMPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBLENDPD, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDPD, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDPD, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDPD, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDVPD, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDVPD, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDVPD, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDVPD, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDVPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDVPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBLENDVPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBLENDVPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTF128, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTF32X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBROADCASTF32X2, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTF32X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTF32X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBROADCASTF32X2, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTF32X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTF32X2, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBROADCASTF32X2, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTF32X2, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTF32X2, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBROADCASTF32X2, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTF32X2, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTF32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBROADCASTF32X4, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTF32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTF32X4, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBROADCASTF32X4, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTF32X4, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTF32X8, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBROADCASTF32X8, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTF32X8, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTF64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBROADCASTF64X2, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTF64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTF64X2, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBROADCASTF64X2, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTF64X2, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTF64X4, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBROADCASTF64X4, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTF64X4, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTI128, sffxsclsNIL, 0, isasAVX2, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTI32X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVBROADCASTI32X2, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBROADCASTI32X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBROADCASTI32X2, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTI32X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBROADCASTI32X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTI32X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVBROADCASTI32X2, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBROADCASTI32X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBROADCASTI32X2, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTI32X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBROADCASTI32X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTI32X2, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBROADCASTI32X2, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTI32X2, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTI32X2, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBROADCASTI32X2, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTI32X2, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTI32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBROADCASTI32X4, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTI32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTI32X4, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBROADCASTI32X4, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTI32X4, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTI32X8, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBROADCASTI32X8, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTI32X8, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTI64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBROADCASTI64X2, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTI64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTI64X2, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBROADCASTI64X2, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTI64X2, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTI64X4, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBROADCASTI64X4, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTI64X4, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTSD, sffxsclsNIL, 0, isasAVX2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTSD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTSD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBROADCASTSD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTSD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBROADCASTSD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTSD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBROADCASTSD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTSD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTSD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBROADCASTSD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTSD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTSS, sffxsclsNIL, 0, isasAVX2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBROADCASTSS, sffxsclsNIL, 0, isasAVX2, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTSS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVBROADCASTSS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTSS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBROADCASTSS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTSS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVBROADCASTSS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVBROADCASTSS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBROADCASTSS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTSS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTSS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVBROADCASTSS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVBROADCASTSS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCMPPD, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCMPPD, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCMPPD, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCMPPD, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCMPPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsBCST, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsSAE, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPD, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCMPPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCMPPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCMPPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCMPPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsBCST, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsSAE, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPPS, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPSD, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCMPSD, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCMPSD, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPSD, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPSD, sffxsclsSAE, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPSD, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPSS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCMPSS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCMPSS, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPSS, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPSS, sffxsclsSAE, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCMPSS, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVCOMISD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}}},
	{opcVCOMISD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}}},
	{opcVCOMISD, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}}},
	{opcVCOMISS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}}},
	{opcVCOMISS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}}},
	{opcVCOMISS, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}}},
	{opcVCOMPRESSPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVCOMPRESSPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVCOMPRESSPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCOMPRESSPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCOMPRESSPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVCOMPRESSPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCOMPRESSPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionRW}}},
	{opcVCOMPRESSPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVCOMPRESSPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCOMPRESSPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCOMPRESSPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVCOMPRESSPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCOMPRESSPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionRW}}},
	{opcVCOMPRESSPD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVCOMPRESSPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCOMPRESSPD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCOMPRESSPD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVCOMPRESSPD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCOMPRESSPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVCOMPRESSPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVCOMPRESSPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCOMPRESSPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCOMPRESSPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVCOMPRESSPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCOMPRESSPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionRW}}},
	{opcVCOMPRESSPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVCOMPRESSPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCOMPRESSPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCOMPRESSPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVCOMPRESSPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCOMPRESSPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionRW}}},
	{opcVCOMPRESSPS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVCOMPRESSPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCOMPRESSPS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCOMPRESSPS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVCOMPRESSPS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTDQ2PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTDQ2PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTDQ2PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTDQ2PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTDQ2PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTDQ2PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTDQ2PD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTDQ2PD, sffxsclsBCST_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsBCST, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTDQ2PD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTDQ2PD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTDQ2PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTDQ2PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTDQ2PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTDQ2PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTDQ2PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTDQ2PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTDQ2PS, sffxsclsBCST_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsBCST, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTDQ2PS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTDQ2PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTDQ2PS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsER_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTDQ2PS, sffxsclsER, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPD2DQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2DQ, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2DQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2DQ, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2DQ, sffxsclsBCST_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2DQ, sffxsclsBCST, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2DQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2DQ, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2DQ, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2DQ, sffxsclsER_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2DQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2DQ, sffxsclsER, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2DQX, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2DQX, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2DQX, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2DQX, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2DQX, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2DQX, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2DQX, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2DQX, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2DQX, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2DQY, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2DQY, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2DQY, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2DQY, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2DQY, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2DQY, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2DQY, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2DQY, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2DQY, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2PS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2PS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2PS, sffxsclsBCST_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2PS, sffxsclsBCST, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2PS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2PS, sffxsclsER_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2PS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2PS, sffxsclsER, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2PSX, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2PSX, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2PSX, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2PSX, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2PSX, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2PSX, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2PSX, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2PSX, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2PSX, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2PSY, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2PSY, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2PSY, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2PSY, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2PSY, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2PSY, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2PSY, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2PSY, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2PSY, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2QQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2QQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2QQ, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2QQ, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2QQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2QQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPD2QQ, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPD2QQ, sffxsclsBCST_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsBCST, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPD2QQ, sffxsclsER, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPD2QQ, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsER_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPD2QQ, sffxsclsER, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPD2UDQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2UDQ, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2UDQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2UDQ, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2UDQ, sffxsclsBCST_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2UDQ, sffxsclsBCST, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2UDQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2UDQ, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2UDQ, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2UDQ, sffxsclsER_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2UDQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2UDQ, sffxsclsER, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2UDQX, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2UDQX, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UDQX, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UDQX, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2UDQX, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UDQX, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UDQX, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2UDQX, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UDQX, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UDQY, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2UDQY, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UDQY, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UDQY, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2UDQY, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UDQY, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UDQY, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2UDQY, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UDQY, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2UQQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2UQQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2UQQ, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2UQQ, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPD2UQQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPD2UQQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPD2UQQ, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPD2UQQ, sffxsclsBCST_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsBCST, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPD2UQQ, sffxsclsER, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPD2UQQ, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsER_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPD2UQQ, sffxsclsER, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPH2PS, sffxsclsNIL, 0, isasF16C, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPH2PS, sffxsclsNIL, 0, isasF16C, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPH2PS, sffxsclsNIL, 0, isasF16C, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPH2PS, sffxsclsNIL, 0, isasF16C, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPH2PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPH2PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPH2PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPH2PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPH2PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPH2PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPH2PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPH2PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPH2PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPH2PS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPH2PS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPH2PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPH2PS, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPH2PS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPH2PS, sffxsclsSAE_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPH2PS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPH2PS, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2DQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2DQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2DQ, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2DQ, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2DQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2DQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2DQ, sffxsclsBCST_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsBCST, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2DQ, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2DQ, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2DQ, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsER_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2DQ, sffxsclsER, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2PD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2PD, sffxsclsBCST_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsBCST, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2PD, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2PD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsSAE_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsNIL, 0, isasAVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2PD, sffxsclsZ, 0, isasAVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsBCST, 0, isasAVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2PD, sffxsclsBCST_Z, 0, isasAVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsBCST, 0, isasAVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2PD, sffxsclsNIL, 0, isasAVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2PD, sffxsclsZ, 0, isasAVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2PH, sffxsclsNIL, 0, isasF16C, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcVCVTPS2PH, sffxsclsNIL, 0, isasF16C, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2PH, sffxsclsNIL, 0, isasF16C, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVCVTPS2PH, sffxsclsNIL, 0, isasF16C, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2PH, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM64), false, actionRW}}},
	{opcVCVTPS2PH, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcVCVTPS2PH, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2PH, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2PH, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVCVTPS2PH, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVCVTPS2PH, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2PH, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2PH, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionRW}}},
	{opcVCVTPS2PH, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVCVTPS2PH, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2PH, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2PH, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2PH, sffxsclsSAE_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2PH, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVCVTPS2PH, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2PH, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2QQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2QQ, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2QQ, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2QQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2QQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2QQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2QQ, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2QQ, sffxsclsBCST_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsBCST, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2QQ, sffxsclsER, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2QQ, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsER_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2QQ, sffxsclsER, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2UDQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2UDQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2UDQ, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2UDQ, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2UDQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2UDQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2UDQ, sffxsclsBCST_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsBCST, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2UDQ, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2UDQ, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2UDQ, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsER_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2UDQ, sffxsclsER, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2UQQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2UQQ, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2UQQ, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2UQQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTPS2UQQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTPS2UQQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2UQQ, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2UQQ, sffxsclsBCST_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsBCST, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2UQQ, sffxsclsER, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTPS2UQQ, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsER_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTPS2UQQ, sffxsclsER, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTQQ2PD, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTQQ2PD, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTQQ2PD, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTQQ2PD, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTQQ2PD, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTQQ2PD, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTQQ2PD, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTQQ2PD, sffxsclsBCST_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsBCST, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTQQ2PD, sffxsclsER, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTQQ2PD, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsER_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTQQ2PD, sffxsclsER, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTQQ2PS, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTQQ2PS, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTQQ2PS, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTQQ2PS, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTQQ2PS, sffxsclsBCST_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTQQ2PS, sffxsclsBCST, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTQQ2PS, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTQQ2PS, sffxsclsER, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTQQ2PS, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTQQ2PS, sffxsclsER_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTQQ2PS, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTQQ2PS, sffxsclsER, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTQQ2PSX, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTQQ2PSX, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PSX, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PSX, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTQQ2PSX, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PSX, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PSX, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTQQ2PSX, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PSX, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PSY, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTQQ2PSY, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PSY, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PSY, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTQQ2PSY, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PSY, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PSY, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTQQ2PSY, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTQQ2PSY, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSD2SI, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTSD2SI, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTSD2SI, sffxsclsER, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTSD2SIQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTSD2SIQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTSD2SIQ, sffxsclsER, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTSD2SS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSD2SS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSD2SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTSD2SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSD2SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTSD2SS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTSD2SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSD2SS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSD2SS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSD2USIL, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTSD2USIL, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTSD2USIL, sffxsclsER, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTSD2USIQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTSD2USIQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTSD2USIQ, sffxsclsER, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTSI2SDL, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSI2SDL, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSI2SDQ, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSI2SDQ, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSI2SDQ, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSI2SSL, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSI2SSL, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSI2SSL, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSI2SSQ, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSI2SSQ, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSI2SSQ, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSS2SD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSS2SD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSS2SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTSS2SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSS2SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTSS2SD, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTSS2SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSS2SD, sffxsclsSAE_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSS2SD, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTSS2SI, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTSS2SI, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTSS2SI, sffxsclsER, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTSS2SIQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTSS2SIQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTSS2SIQ, sffxsclsER, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTSS2USIL, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTSS2USIL, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTSS2USIL, sffxsclsER, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTSS2USIQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTSS2USIQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTSS2USIQ, sffxsclsER, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTTPD2DQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPD2DQ, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2DQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2DQ, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPD2DQ, sffxsclsBCST_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2DQ, sffxsclsBCST, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2DQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPD2DQ, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPD2DQ, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2DQ, sffxsclsSAE_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2DQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2DQ, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2DQX, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2DQX, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2DQX, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2DQX, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2DQX, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2DQX, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2DQX, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2DQX, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2DQX, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2DQY, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2DQY, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2DQY, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2DQY, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2DQY, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2DQY, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2DQY, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2DQY, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2DQY, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2QQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPD2QQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2QQ, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPD2QQ, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2QQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPD2QQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPD2QQ, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPD2QQ, sffxsclsBCST_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsBCST, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPD2QQ, sffxsclsSAE, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPD2QQ, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsSAE_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPD2QQ, sffxsclsSAE, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPD2UDQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPD2UDQ, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2UDQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2UDQ, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPD2UDQ, sffxsclsBCST_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2UDQ, sffxsclsBCST, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2UDQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPD2UDQ, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPD2UDQ, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2UDQ, sffxsclsSAE_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2UDQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2UDQ, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2UDQX, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2UDQX, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UDQX, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UDQX, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2UDQX, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UDQX, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UDQX, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2UDQX, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UDQX, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UDQY, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2UDQY, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UDQY, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UDQY, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2UDQY, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UDQY, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UDQY, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2UDQY, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UDQY, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2UQQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPD2UQQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2UQQ, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPD2UQQ, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPD2UQQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPD2UQQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPD2UQQ, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPD2UQQ, sffxsclsBCST_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsBCST, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPD2UQQ, sffxsclsSAE, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPD2UQQ, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsSAE_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPD2UQQ, sffxsclsSAE, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPS2DQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPS2DQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPS2DQ, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPS2DQ, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPS2DQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPS2DQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPS2DQ, sffxsclsBCST_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsBCST, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPS2DQ, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPS2DQ, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPS2DQ, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsSAE_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2DQ, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPS2QQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPS2QQ, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPS2QQ, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPS2QQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPS2QQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPS2QQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPS2QQ, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPS2QQ, sffxsclsBCST_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsBCST, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPS2QQ, sffxsclsSAE, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPS2QQ, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsSAE_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2QQ, sffxsclsSAE, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPS2UDQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPS2UDQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPS2UDQ, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPS2UDQ, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPS2UDQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPS2UDQ, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPS2UDQ, sffxsclsBCST_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsBCST, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPS2UDQ, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPS2UDQ, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPS2UDQ, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsSAE_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2UDQ, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPS2UQQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPS2UQQ, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPS2UQQ, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPS2UQQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTTPS2UQQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTTPS2UQQ, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPS2UQQ, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPS2UQQ, sffxsclsBCST_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsBCST, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPS2UQQ, sffxsclsSAE, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTTPS2UQQ, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsSAE_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTPS2UQQ, sffxsclsSAE, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTTSD2SI, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTTSD2SI, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTTSD2SI, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTTSD2SIQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTTSD2SIQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTTSD2SIQ, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTTSD2USIL, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTTSD2USIL, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTTSD2USIL, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTTSD2USIQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTTSD2USIQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTTSD2USIQ, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTTSS2SI, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTTSS2SI, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTTSS2SI, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTTSS2SIQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTTSS2SIQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTTSS2SIQ, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTTSS2USIL, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTTSS2USIL, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTTSS2USIL, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVCVTTSS2USIQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTTSS2USIQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTTSS2USIQ, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTUDQ2PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTUDQ2PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTUDQ2PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTUDQ2PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTUDQ2PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTUDQ2PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTUDQ2PD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTUDQ2PD, sffxsclsBCST_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsBCST, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTUDQ2PD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUDQ2PD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTUDQ2PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTUDQ2PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTUDQ2PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTUDQ2PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTUDQ2PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTUDQ2PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTUDQ2PS, sffxsclsBCST_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsBCST, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTUDQ2PS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTUDQ2PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTUDQ2PS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsER_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUDQ2PS, sffxsclsER, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTUQQ2PD, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTUQQ2PD, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTUQQ2PD, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTUQQ2PD, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTUQQ2PD, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTUQQ2PD, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTUQQ2PD, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTUQQ2PD, sffxsclsBCST_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsBCST, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTUQQ2PD, sffxsclsER, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVCVTUQQ2PD, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsER_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUQQ2PD, sffxsclsER, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVCVTUQQ2PS, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTUQQ2PS, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUQQ2PS, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUQQ2PS, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTUQQ2PS, sffxsclsBCST_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUQQ2PS, sffxsclsBCST, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUQQ2PS, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTUQQ2PS, sffxsclsER, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVCVTUQQ2PS, sffxsclsZ, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUQQ2PS, sffxsclsER_Z, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUQQ2PS, sffxsclsNIL, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUQQ2PS, sffxsclsER, 0, isasAVX512DQ, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVCVTUQQ2PSX, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTUQQ2PSX, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PSX, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PSX, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTUQQ2PSX, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PSX, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PSX, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTUQQ2PSX, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PSX, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PSY, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTUQQ2PSY, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PSY, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PSY, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTUQQ2PSY, sffxsclsBCST_Z, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PSY, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PSY, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVCVTUQQ2PSY, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUQQ2PSY, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUSI2SDL, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUSI2SDL, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUSI2SDQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUSI2SDQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUSI2SDQ, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUSI2SSL, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUSI2SSL, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUSI2SSL, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUSI2SSQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUSI2SSQ, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVCVTUSI2SSQ, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDBPSADBW, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVDBPSADBW, sffxsclsZ, 0, isasAVX512BW_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDBPSADBW, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDBPSADBW, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVDBPSADBW, sffxsclsZ, 0, isasAVX512BW_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDBPSADBW, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDBPSADBW, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVDBPSADBW, sffxsclsZ, 0, isasAVX512BW_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDBPSADBW, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDBPSADBW, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVDBPSADBW, sffxsclsZ, 0, isasAVX512BW_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDBPSADBW, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDBPSADBW, sffxsclsNIL, 0, isasAVX512BW, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVDBPSADBW, sffxsclsZ, 0, isasAVX512BW, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDBPSADBW, sffxsclsNIL, 0, isasAVX512BW, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDBPSADBW, sffxsclsNIL, 0, isasAVX512BW, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVDBPSADBW, sffxsclsZ, 0, isasAVX512BW, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDBPSADBW, sffxsclsNIL, 0, isasAVX512BW, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDIVPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDIVPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVDIVPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVDIVPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDIVPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVDIVPD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVDIVPD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDIVPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDIVPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVDIVPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVDIVPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDIVPD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVDIVPD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVPD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVDIVPD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVPD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVPD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVDIVPD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVDIVPD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVPD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVPD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDIVPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDIVPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVDIVPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVDIVPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDIVPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVDIVPS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVDIVPS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDIVPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDIVPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVDIVPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVDIVPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDIVPS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVDIVPS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVPS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVPS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVDIVPS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVPS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVDIVPS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVDIVPS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVPS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVPS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVDIVSD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVSD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVDIVSD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVDIVSD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVDIVSD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVSD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVSD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVSS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVSS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVDIVSS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVDIVSS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVDIVSS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVSS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDIVSS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDPPD, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDPPD, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDPPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDPPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVDPPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVDPPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXP2PD, sffxsclsNIL, 0, isasAVX512ER, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVEXP2PD, sffxsclsZ, 0, isasAVX512ER, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXP2PD, sffxsclsNIL, 0, isasAVX512ER, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXP2PD, sffxsclsBCST, 0, isasAVX512ER, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVEXP2PD, sffxsclsBCST_Z, 0, isasAVX512ER, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXP2PD, sffxsclsBCST, 0, isasAVX512ER, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXP2PD, sffxsclsNIL, 0, isasAVX512ER, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVEXP2PD, sffxsclsSAE, 0, isasAVX512ER, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVEXP2PD, sffxsclsZ, 0, isasAVX512ER, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXP2PD, sffxsclsSAE_Z, 0, isasAVX512ER, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXP2PD, sffxsclsNIL, 0, isasAVX512ER, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXP2PD, sffxsclsSAE, 0, isasAVX512ER, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXP2PS, sffxsclsBCST, 0, isasAVX512ER, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVEXP2PS, sffxsclsBCST_Z, 0, isasAVX512ER, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXP2PS, sffxsclsBCST, 0, isasAVX512ER, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXP2PS, sffxsclsNIL, 0, isasAVX512ER, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVEXP2PS, sffxsclsZ, 0, isasAVX512ER, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXP2PS, sffxsclsNIL, 0, isasAVX512ER, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXP2PS, sffxsclsNIL, 0, isasAVX512ER, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVEXP2PS, sffxsclsSAE, 0, isasAVX512ER, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVEXP2PS, sffxsclsZ, 0, isasAVX512ER, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXP2PS, sffxsclsSAE_Z, 0, isasAVX512ER, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXP2PS, sffxsclsNIL, 0, isasAVX512ER, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXP2PS, sffxsclsSAE, 0, isasAVX512ER, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXPANDPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVEXPANDPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXPANDPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXPANDPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVEXPANDPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXPANDPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXPANDPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVEXPANDPD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXPANDPD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXPANDPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVEXPANDPD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXPANDPD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXPANDPD, sffxsclsNIL, 0, isasAVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVEXPANDPD, sffxsclsZ, 0, isasAVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXPANDPD, sffxsclsNIL, 0, isasAVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXPANDPD, sffxsclsNIL, 0, isasAVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVEXPANDPD, sffxsclsZ, 0, isasAVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXPANDPD, sffxsclsNIL, 0, isasAVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXPANDPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVEXPANDPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXPANDPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXPANDPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVEXPANDPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXPANDPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXPANDPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVEXPANDPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXPANDPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXPANDPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVEXPANDPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXPANDPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXPANDPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVEXPANDPS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXPANDPS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXPANDPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVEXPANDPS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXPANDPS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVEXTRACTF128, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTF128, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTF32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVEXTRACTF32X4, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTF32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVEXTRACTF32X4, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTF32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTF32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTF32X4, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVEXTRACTF32X4, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTF32X4, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVEXTRACTF32X4, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTF32X4, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTF32X4, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTF32X8, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionRW}}},
	{opcVEXTRACTF32X8, sffxsclsZ, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVEXTRACTF32X8, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVEXTRACTF32X8, sffxsclsZ, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXTRACTF32X8, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVEXTRACTF32X8, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXTRACTF64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVEXTRACTF64X2, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTF64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVEXTRACTF64X2, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTF64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTF64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTF64X2, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVEXTRACTF64X2, sffxsclsZ, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTF64X2, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVEXTRACTF64X2, sffxsclsZ, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTF64X2, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTF64X2, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTF64X4, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionRW}}},
	{opcVEXTRACTF64X4, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVEXTRACTF64X4, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVEXTRACTF64X4, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXTRACTF64X4, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVEXTRACTF64X4, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXTRACTI128, sffxsclsNIL, 0, isasAVX2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTI128, sffxsclsNIL, 0, isasAVX2, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTI32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVEXTRACTI32X4, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTI32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVEXTRACTI32X4, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTI32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTI32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTI32X4, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVEXTRACTI32X4, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTI32X4, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVEXTRACTI32X4, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTI32X4, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTI32X4, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTI32X8, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionRW}}},
	{opcVEXTRACTI32X8, sffxsclsZ, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVEXTRACTI32X8, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVEXTRACTI32X8, sffxsclsZ, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXTRACTI32X8, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVEXTRACTI32X8, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXTRACTI64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVEXTRACTI64X2, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTI64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVEXTRACTI64X2, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTI64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTI64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTI64X2, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVEXTRACTI64X2, sffxsclsZ, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTI64X2, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVEXTRACTI64X2, sffxsclsZ, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTI64X2, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVEXTRACTI64X2, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVEXTRACTI64X4, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionRW}}},
	{opcVEXTRACTI64X4, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVEXTRACTI64X4, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVEXTRACTI64X4, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXTRACTI64X4, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVEXTRACTI64X4, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVEXTRACTPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM32), false, actionW}}},
	{opcVEXTRACTPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVFIXUPIMMPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsBCST, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsBCST_Z, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsSAE, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsSAE_Z, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPD, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsBCST, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsBCST_Z, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsSAE, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsSAE_Z, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsNIL, 0, isasAVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsZ, 0, isasAVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsNIL, 0, isasAVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsBCST, 0, isasAVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsBCST_Z, 0, isasAVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsBCST, 0, isasAVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsNIL, 0, isasAVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsZ, 0, isasAVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMPS, sffxsclsNIL, 0, isasAVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSD, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSD, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSD, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSD, sffxsclsSAE, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSD, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSD, sffxsclsSAE_Z, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSD, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSS, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSS, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSS, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSS, sffxsclsSAE, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSS, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSS, sffxsclsSAE_Z, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFIXUPIMMSS, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD132SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD132SS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD213SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD213SS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADD231SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADD231SS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB132PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB213PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMADDSUB231PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB132SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB132SS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB213SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB213SS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUB231SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUB231SS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD132PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD213PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFMSUBADD231PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD132SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD132SS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD213SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD213SS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMADD231SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMADD231SS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB132SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB132SS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB213SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB213SS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231PS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVFNMSUB231SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SD, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SD, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SD, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SD, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SS, sffxsclsNIL, 0, isasFMA3, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SS, sffxsclsER, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SS, sffxsclsER_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFNMSUB231SS, sffxsclsER, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVFPCLASSPDX, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDX, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDX, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDX, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDX, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDX, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDY, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDY, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDY, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDY, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDY, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDY, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDZ, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDZ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDZ, sffxsclsBCST, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDZ, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDZ, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPDZ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSX, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSX, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSX, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSX, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSX, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSX, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSY, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSY, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSY, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSY, sffxsclsBCST, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSY, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSY, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSZ, sffxsclsBCST, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSZ, sffxsclsBCST, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSZ, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSZ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSZ, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSPSZ, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSSD, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSSD, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSSD, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSSD, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSSS, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSSS, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSSS, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVFPCLASSSS, sffxsclsNIL, 0, isasAVX512DQ, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionW}}},
	{opcVGATHERDPD, sffxsclsNIL, 0, isasAVX2, 3, oprnds{{uint8(oprndtypeXMM), false, actionRW}, {uint8(oprndtypeVM32X), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGATHERDPD, sffxsclsNIL, 0, isasAVX2, 3, oprnds{{uint8(oprndtypeYMM), false, actionRW}, {uint8(oprndtypeVM32X), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGATHERDPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeVM32X), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGATHERDPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeVM32X), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGATHERDPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeVM32Y), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGATHERDPS, sffxsclsNIL, 0, isasAVX2, 3, oprnds{{uint8(oprndtypeXMM), false, actionRW}, {uint8(oprndtypeVM32X), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGATHERDPS, sffxsclsNIL, 0, isasAVX2, 3, oprnds{{uint8(oprndtypeYMM), false, actionRW}, {uint8(oprndtypeVM32Y), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGATHERDPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeVM32X), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGATHERDPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeVM32Y), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGATHERDPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeVM32Z), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGATHERQPD, sffxsclsNIL, 0, isasAVX2, 3, oprnds{{uint8(oprndtypeXMM), false, actionRW}, {uint8(oprndtypeVM64X), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGATHERQPD, sffxsclsNIL, 0, isasAVX2, 3, oprnds{{uint8(oprndtypeYMM), false, actionRW}, {uint8(oprndtypeVM64Y), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGATHERQPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeVM64X), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGATHERQPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeVM64Y), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGATHERQPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeVM64Z), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGATHERQPS, sffxsclsNIL, 0, isasAVX2, 3, oprnds{{uint8(oprndtypeXMM), false, actionRW}, {uint8(oprndtypeVM64X), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGATHERQPS, sffxsclsNIL, 0, isasAVX2, 3, oprnds{{uint8(oprndtypeXMM), false, actionRW}, {uint8(oprndtypeVM64Y), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGATHERQPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeVM64X), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGATHERQPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeVM64Y), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGATHERQPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeVM64Z), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGETEXPPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETEXPPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGETEXPPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETEXPPD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGETEXPPD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETEXPPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGETEXPPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGETEXPPD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGETEXPPD, sffxsclsBCST_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsBCST, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGETEXPPD, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGETEXPPD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsSAE_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETEXPPD, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETEXPPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGETEXPPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETEXPPS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGETEXPPS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETEXPPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGETEXPPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGETEXPPS, sffxsclsBCST_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsBCST, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGETEXPPS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGETEXPPS, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGETEXPPS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsSAE_Z, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETEXPPS, sffxsclsSAE, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETEXPSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETEXPSD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPSD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETEXPSD, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETEXPSD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPSD, sffxsclsSAE_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPSD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPSD, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETEXPSS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPSS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETEXPSS, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETEXPSS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPSS, sffxsclsSAE_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPSS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETEXPSS, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETMANTPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGETMANTPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETMANTPD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGETMANTPD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETMANTPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGETMANTPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGETMANTPD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGETMANTPD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGETMANTPD, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGETMANTPD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsSAE_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETMANTPD, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETMANTPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGETMANTPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETMANTPS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGETMANTPS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETMANTPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVGETMANTPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGETMANTPS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGETMANTPS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGETMANTPS, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVGETMANTPS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsSAE_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETMANTPS, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVGETMANTSD, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETMANTSD, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTSD, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETMANTSD, sffxsclsSAE, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETMANTSD, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTSD, sffxsclsSAE_Z, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTSD, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTSS, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETMANTSS, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTSS, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETMANTSS, sffxsclsSAE, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVGETMANTSS, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTSS, sffxsclsSAE_Z, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVGETMANTSS, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVHADDPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVHADDPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVHADDPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVHADDPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVHADDPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVHADDPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVHADDPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVHADDPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVHSUBPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVHSUBPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVHSUBPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVHSUBPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVHSUBPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVHSUBPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVHSUBPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVHSUBPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTF128, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTF128, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTF32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVINSERTF32X4, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTF32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTF32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVINSERTF32X4, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTF32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTF32X4, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVINSERTF32X4, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTF32X4, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTF32X4, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVINSERTF32X4, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTF32X4, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTF32X8, sffxsclsNIL, 0, isasAVX512DQ, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVINSERTF32X8, sffxsclsZ, 0, isasAVX512DQ, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTF32X8, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTF32X8, sffxsclsNIL, 0, isasAVX512DQ, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVINSERTF32X8, sffxsclsZ, 0, isasAVX512DQ, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTF32X8, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTF64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVINSERTF64X2, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTF64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTF64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVINSERTF64X2, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTF64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTF64X2, sffxsclsNIL, 0, isasAVX512DQ, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVINSERTF64X2, sffxsclsZ, 0, isasAVX512DQ, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTF64X2, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTF64X2, sffxsclsNIL, 0, isasAVX512DQ, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVINSERTF64X2, sffxsclsZ, 0, isasAVX512DQ, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTF64X2, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTF64X4, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVINSERTF64X4, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTF64X4, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTF64X4, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVINSERTF64X4, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTF64X4, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTI128, sffxsclsNIL, 0, isasAVX2, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTI128, sffxsclsNIL, 0, isasAVX2, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTI32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVINSERTI32X4, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTI32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTI32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVINSERTI32X4, sffxsclsZ, 0, isasAVX512F_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTI32X4, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTI32X4, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVINSERTI32X4, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTI32X4, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTI32X4, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVINSERTI32X4, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTI32X4, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTI32X8, sffxsclsNIL, 0, isasAVX512DQ, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVINSERTI32X8, sffxsclsZ, 0, isasAVX512DQ, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTI32X8, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTI32X8, sffxsclsNIL, 0, isasAVX512DQ, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVINSERTI32X8, sffxsclsZ, 0, isasAVX512DQ, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTI32X8, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTI64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVINSERTI64X2, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTI64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTI64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVINSERTI64X2, sffxsclsZ, 0, isasAVX512DQ_AVX512VL, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTI64X2, sffxsclsNIL, 0, isasAVX512DQ_AVX512VL, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVINSERTI64X2, sffxsclsNIL, 0, isasAVX512DQ, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVINSERTI64X2, sffxsclsZ, 0, isasAVX512DQ, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTI64X2, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTI64X2, sffxsclsNIL, 0, isasAVX512DQ, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVINSERTI64X2, sffxsclsZ, 0, isasAVX512DQ, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTI64X2, sffxsclsNIL, 0, isasAVX512DQ, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTI64X4, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVINSERTI64X4, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTI64X4, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTI64X4, sffxsclsNIL, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVINSERTI64X4, sffxsclsZ, 0, isasAVX512F, 5, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTI64X4, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVINSERTPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVINSERTPS, sffxsclsNIL, 0, isasAVX, 4, oprnds{{uint8(oprndtypeIMM8), false, actionN}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVLDDQU, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVLDDQU, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVLDMXCSR, sffxsclsNIL, 0, isasAVX, 1, oprnds{{uint8(oprndtypeM32), false, actionR}}},
	{opcVMASKMOVDQU, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(implregRDI), true, actionR}}},
	{opcVMASKMOVPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMASKMOVPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMASKMOVPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMASKMOVPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMASKMOVPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMASKMOVPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMASKMOVPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMASKMOVPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMAXPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMAXPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMAXPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMAXPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMAXPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMAXPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMAXPD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMAXPD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMAXPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMAXPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMAXPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMAXPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMAXPD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMAXPD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMAXPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMAXPD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMAXPD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMAXPD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMAXPD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMAXPD, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMAXPD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMAXPD, sffxsclsSAE_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMAXPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMAXPD, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMAXPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMAXPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMAXPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMAXPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMAXPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMAXPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMAXPS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMAXPS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMAXPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMAXPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMAXPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMAXPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMAXPS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMAXPS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMAXPS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMAXPS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMAXPS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMAXPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMAXPS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMAXPS, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMAXPS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMAXPS, sffxsclsSAE_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMAXPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMAXPS, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMAXSD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXSD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMAXSD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMAXSD, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMAXSD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXSD, sffxsclsSAE_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXSD, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXSS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXSS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMAXSS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMAXSS, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMAXSS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXSS, sffxsclsSAE_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMAXSS, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMINPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMINPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMINPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMINPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMINPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMINPD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMINPD, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMINPD, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMINPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMINPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMINPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMINPD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMINPD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMINPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMINPD, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMINPD, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMINPD, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMINPD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMINPD, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMINPD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMINPD, sffxsclsSAE_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMINPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMINPD, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMINPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMINPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMINPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMINPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMINPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMINPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMINPS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMINPS, sffxsclsBCST_Z, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMINPS, sffxsclsBCST, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMINPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMINPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMINPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 4, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMINPS, sffxsclsBCST, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMINPS, sffxsclsBCST_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMINPS, sffxsclsBCST, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMINPS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMINPS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMINPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMINPS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMINPS, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMINPS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMINPS, sffxsclsSAE_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMINPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMINPS, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMINSD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINSD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMINSD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMINSD, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMINSD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINSD, sffxsclsSAE_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINSD, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINSS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINSS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMINSS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMINSS, sffxsclsSAE, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMINSS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINSS, sffxsclsSAE_Z, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMINSS, sffxsclsSAE, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVAPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVAPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVMOVAPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVAPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionRW}}},
	{opcVMOVAPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVAPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVAPD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionRW}}},
	{opcVMOVAPD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVAPD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVAPD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVAPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVAPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVMOVAPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVAPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionRW}}},
	{opcVMOVAPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVAPS, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVAPS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionRW}}},
	{opcVMOVAPS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVAPS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVAPS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeR32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM32), false, actionW}}},
	{opcVMOVD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVMOVDDUP, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDDUP, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDDUP, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDDUP, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDDUP, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVDDUP, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDDUP, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVDDUP, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDDUP, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVDDUP, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDDUP, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVDDUP, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDDUP, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVDDUP, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDDUP, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDDUP, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVDDUP, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDDUP, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQA, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQA, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQA, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVDQA, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQA, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVDQA, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVDQA32, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVDQA32, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVMOVDQA32, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVDQA32, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionRW}}},
	{opcVMOVDQA32, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVDQA32, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVDQA32, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionRW}}},
	{opcVMOVDQA32, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVDQA32, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVDQA32, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVDQA64, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVDQA64, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVMOVDQA64, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVDQA64, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionRW}}},
	{opcVMOVDQA64, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVDQA64, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVDQA64, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionRW}}},
	{opcVMOVDQA64, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVDQA64, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVDQA64, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQU, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVDQU, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVDQU, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVDQU16, sffxsclsZ, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVDQU16, sffxsclsZ, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVMOVDQU16, sffxsclsZ, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVDQU16, sffxsclsZ, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionRW}}},
	{opcVMOVDQU16, sffxsclsZ, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVDQU16, sffxsclsZ, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVDQU16, sffxsclsZ, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionRW}}},
	{opcVMOVDQU16, sffxsclsZ, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVDQU16, sffxsclsZ, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVDQU16, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVDQU32, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVDQU32, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVMOVDQU32, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVDQU32, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionRW}}},
	{opcVMOVDQU32, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVDQU32, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVDQU32, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionRW}}},
	{opcVMOVDQU32, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVDQU32, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVDQU32, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVDQU64, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVDQU64, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVMOVDQU64, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVDQU64, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionRW}}},
	{opcVMOVDQU64, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVDQU64, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVDQU64, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionRW}}},
	{opcVMOVDQU64, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVDQU64, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVDQU64, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVDQU8, sffxsclsZ, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVDQU8, sffxsclsZ, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVMOVDQU8, sffxsclsZ, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVDQU8, sffxsclsZ, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionRW}}},
	{opcVMOVDQU8, sffxsclsZ, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVDQU8, sffxsclsZ, 0, isasAVX512BW_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW_AVX512VL, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVDQU8, sffxsclsZ, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionRW}}},
	{opcVMOVDQU8, sffxsclsZ, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVDQU8, sffxsclsZ, 0, isasAVX512BW, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVDQU8, sffxsclsNIL, 0, isasAVX512BW, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVHLPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVHPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVHPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcVMOVHPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVHPS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcVMOVLHPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVLPD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVLPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcVMOVLPS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVLPS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcVMOVMSKPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVMOVMSKPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVMOVMSKPS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVMOVMSKPS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeR32), false, actionW}}},
	{opcVMOVNTDQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVNTDQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVNTDQ, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVNTDQA, sffxsclsNIL, 0, isasAVX2, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVNTDQA, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVNTDQA, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVNTPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVNTPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVNTPD, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVNTPS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVNTPS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVNTPS, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeM512), false, actionW}}},
	{opcVMOVQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeR64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcVMOVQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeR64), false, actionW}}},
	{opcVMOVQ, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVSD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVSD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcVMOVSD, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVSD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVSD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM64), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVSD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM64), false, actionW}}},
	{opcVMOVSD, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVSD, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVSHDUP, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVSHDUP, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVSHDUP, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVSHDUP, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVSHDUP, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVSHDUP, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVSHDUP, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVSHDUP, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVSHDUP, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVSHDUP, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVSHDUP, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVSHDUP, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVSHDUP, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVSHDUP, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVSHDUP, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVSHDUP, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVSHDUP, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVSHDUP, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVSLDUP, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVSLDUP, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVSLDUP, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVSLDUP, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVSLDUP, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVSLDUP, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVSLDUP, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVSLDUP, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVSLDUP, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVSLDUP, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVSLDUP, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVSLDUP, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVSLDUP, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVSLDUP, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVSLDUP, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVSLDUP, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVSLDUP, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVSLDUP, sffxsclsNIL, 0, isasAVX512F, 2, oprnds{{uint8(oprndtypeZMM), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVSS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVSS, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM32), false, actionW}}},
	{opcVMOVSS, sffxsclsNIL, 0, isasAVX, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVSS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVSS, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM32), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVSS, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM32), false, actionW}}},
	{opcVMOVSS, sffxsclsNIL, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVSS, sffxsclsZ, 0, isasAVX512F, 4, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVUPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVUPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVUPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVUPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVUPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVUPD, sffxsclsNIL, 0, isasAVX, 2, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVUPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVUPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM128), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVUPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVUPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeM256), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVUPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionRW}}},
	{opcVMOVUPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM128), false, actionW}}},
	{opcVMOVUPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionRW}}},
	{opcVMOVUPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeXMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeXMM), false, actionW}}},
	{opcVMOVUPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionRW}}},
	{opcVMOVUPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeM256), false, actionW}}},
	{opcVMOVUPD, sffxsclsNIL, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionRW}}},
	{opcVMOVUPD, sffxsclsZ, 0, isasAVX512F_AVX512VL, 3, oprnds{{uint8(oprndtypeYMM), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeYMM), false, actionW}}},
	{opcVMOVUPD, sffxsclsNIL, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionRW}}},
	{opcVMOVUPD, sffxsclsZ, 0, isasAVX512F, 3, oprnds{{uint8(oprndtypeM512), false, actionR}, {uint8(oprndtypeK), false, actionR}, {uint8(oprndtypeZMM), false, actionW}}},
	{opcVMOVUPD, sffxsclsNIL, 0, isasAVX512F, 