/*
 * Copyright 2010-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jetbrains.uast.test.env.kotlin

import com.intellij.mock.MockProject
import java.io.File

abstract class AbstractCoreEnvironment {
    abstract val project: MockProject

    open fun dispose() {
        // Do nothing
    }

    abstract fun addJavaSourceRoot(root: File)
    abstract fun addJar(root: File)
}