* $Id: openIP.inc,v 1.2 2010/11/19 19:22:59 john_doty Exp $
*
*   Copyright (C) 2010 Hirokazu Ikeda and John P. Doty            	 *
*                                                                        *
*   This program is free software; you can redistribute it and/or modify *
*   it under the terms of the GNU General Public License as published by *
*   the Free Software Foundation; either version 2 of the License, or    *
*   (at your option) any later version.                                  *
*                                                                        *
*   This program is distributed in the hope that it will be useful,      *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
*   GNU General Public License for more details.                         *
*                                                                        *
*   You should have received a copy of the GNU General Public License    *
*   along with this program; if not, write to the                        *
*   Free Software Foundation, Inc.,                                      *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.            *
*
* Subcircuit library for OpenIP. See:
* http://research.kek.jp/people/ikeda/openIP/
* for details.
* Collected and published under the GPL by John P. Doty with permission
* from Hirokazu Ikeda.
*
* Address questions, comments, and corrections to jpd@noqsi.com.
*
* PAD is "commented out" here because ngspice (and probably some other
* SPICE dialects) can't handle an empty subcircuit.
*
*.SUBCKT PAD PAD
*.ENDS
*
.SUBCKT PATHR A Y
*M1 A N6 VSSE VSS nch L=0.5u W=400u
*M2 N6 N2 VSSE VSS nch L=50u W=25u
M3 Y N10 VSSE VSS nch L=0.35u W=20u
*M4 A N4 VDDE VDDE pch L=0.5u W=400u
*M5 N4 N1 VDDE VDDE pch L=50u W=25u
M6 Y N5 VDDE VDDE pch L=0.35u W=20u
*R7 N2 VDDE 1164 TC=0.0, 0.0
*R8 N1 VSSE 1192 TC=0.0, 0.0
R9 A Y 225.4 TC=0.0, 0.0
R10 N5 VDDE 1164 TC=0.0, 0.0
R11 N10 VSSE 1192 TC=0.0, 0.0
.ENDS
.SUBCKT PATH A
*M1 A N3 VSSE VSS nch L=0.5u W=400u
*M2 N3 N4 VSSE VSS nch L=50u W=25u
*M3 A N1 VDDE VDDE pch L=0.5u W=400u
*M4 N1 N5 VDDE VDDE pch L=50u W=25u
*R5 N4 VDDE 1164 TC=0.0, 0.0
*R6 N5 VSSE 1192 TC=0.0, 0.0
.ENDS
.SUBCKT PDIN D Y
*M1 D N5 VSS0 VSS nch L=0.5u W=400u
*M2 N5 N8 VSS0 VSS nch L=50u W=25u
M3 N1 N2 VSS0 VSS nch L=0.35u W=20u
M4 N3 N1 VSS0 VSS nch L=0.35u W=1.5u
M5 Y N3 VSS0 VSS nch L=0.35u W=6u
*M6 D N9 VDD0 VDD0 pch L=0.5u W=400u
*M7 N9 N6 VDD0 VDD0 pch L=50u W=25u
M8 N1 N4 VDD0 VDD0 pch L=0.35u W=20u
M9 N3 N1 VDD0 VDD0 pch L=0.35u W=3u
M10 Y N3 VDD0 VDD0 pch L=0.35u W=12u
*R11 N8 VDD0 1164 TC=0.0, 0.0
*R12 N6 VSS0 1192 TC=0.0, 0.0
R13 D N1 225.4 TC=0.0, 0.0
R14 N4 VDD0 1164 TC=0.0, 0.0
R15 N2 VSS0 1192 TC=0.0, 0.0
.ENDS
.SUBCKT PDOUT DIN DOUT
*M1 DOUT N6 VSS0 VSS nch L=0.5u W=400u
*M2 N6 N5 VSS0 VSS nch L=50u W=25u
M3 N4 DIN VSS0 VSS nch L=0.35u W=6u
M4 DOUT N4 VSS0 VSS nch L=0.5u W=50u
*M5 DOUT N2 VDD0 VDD0 pch L=0.5u W=400u
*M6 N2 N1 VDD0 VDD0 pch L=50u W=25u
M7 N4 DIN VDD0 VDD0 pch L=0.35u W=10u
M8 DOUT N4 VDD0 VDD0 pch L=0.8u W=120u
*R9 N5 VDD0 1164 TC=0.0, 0.0
*R10 N1 VSS0 1192 TC=0.0, 0.0
.ENDS
.SUBCKT PDTHR D Y
*M1 D N2 VSS0 VSS nch L=0.5u W=400u
*M2 N2 N7 VSS0 VSS nch L=50u W=25u
M3 Y N1 VSS0 VSS nch L=0.35u W=20u
*M4 D N5 VDD0 VDD0 pch L=0.5u W=400u
*M5 N5 N4 VDD0 VDD0 pch L=50u W=25u
M6 Y N3 VDD0 VDD0 pch L=0.35u W=20u
*R7 N7 VDD0 1164 TC=0.0, 0.0
*R8 N4 VSS0 1192 TC=0.0, 0.0
R9 D Y 225.4 TC=0.0, 0.0
R10 N3 VDD0 1164 TC=0.0, 0.0
R11 N1 VSS0 1192 TC=0.0, 0.0
.ENDS
.SUBCKT PDTH D
*M1 D N3 VSS0 VSS nch L=0.5u W=400u
*M2 N3 N2 VSS0 VSS nch L=50u W=25u
*M3 D N4 VDD0 VDD0 pch L=0.5u W=400u
*M4 N4 N5 VDD0 VDD0 pch L=50u W=25u
*R5 N2 VDD0 1164 TC=0.0, 0.0
*R6 N5 VSS0 1192 TC=0.0, 0.0
.ENDS
.SUBCKT PVDD0 VDD0
*M1 VDD0 N1 VSS0 VSS nch L=0.5u W=400u
*M2 N1 N3 VSS0 VSS nch L=50u W=25u
*R3 N3 VDD0 1164 TC=0.0, 0.0
.ENDS
.SUBCKT PVDD1 VDD1
*M1 VDD1 N1 VSS0 VSS nch L=0.5u W=400u
*M2 N1 N3 VSS0 VSS nch L=50u W=25u
*R3 N3 VDD1 1164 TC=0.0, 0.0
.ENDS
.SUBCKT PVDDE VDDE
*M1 VDDE N1 VSSE VSS nch L=0.5u W=400u
*M2 N1 N3 VSSE VSS nch L=50u W=25u
*R3 N3 VDDE 1164 TC=0.0, 0.0
.ENDS
.SUBCKT PVDD VDD
*M1 VDD N2 VSSE VSS nch L=0.5u W=400u
*M2 N2 N1 VSSE VSS nch L=50u W=25u
*R3 N1 VDD 1164 TC=0.0, 0.0
.ENDS
.SUBCKT PVSS0 VSS0
*M1 VSS0 N2 VDD0 VDD0 pch L=0.5u W=400u
*M2 N2 N3 VDD0 VDD0 pch L=50u W=25u
*R3 N3 VSS0 1192 TC=0.0, 0.0
.ENDS
.SUBCKT PVSS1 VSS1
*M1 VSS1 N2 VDD0 VDD0 pch L=0.5u W=400u
*M2 N2 N3 VDD0 VDD0 pch L=50u W=25u
*R3 N3 VSS1 1192 TC=0.0, 0.0
.ENDS
.SUBCKT PVSSE VSSE
*M1 VSSE N2 VDDE VDDE pch L=0.5u W=400u
*M2 N2 N3 VDDE VDDE pch L=50u W=25u
*R3 N3 VSSE 1192 TC=0.0, 0.0
.ENDS
.SUBCKT PVSS VSS
*M1 VSS N2 VDDE VDDE pch L=0.5u W=400u
*M2 N2 N1 VDDE VDDE pch L=50u W=25u
*R3 N1 VSS 1192 TC=0.0, 0.0
.ENDS
.SUBCKT PNOT A Y
M1 Y A VSS0 VSS nch L=0.4u W=1.5u
M2 Y A VDD0 VDD0 pch L=0.4u W=3u
.ENDS
.SUBCKT TROUT DIN DOUT ENB
M1 DOUT NN N9 VSS nch L=0.5u W=50u
M2 PP N11 VSS0 VSS nch L=0.35u W=6u
M3 NN N2 VSS0 VSS nch L=0.35u W=6u
M4 N9 N10 VSS0 VSS nch L=0.5u W=50u
M5 N10 DIN VSS0 VSS nch L=0.35u W=6u
*M6 N13 N1 VSS0 VSS nch L=50u W=25u
*M7 DOUT N13 VSS0 VSS nch L=0.5u W=400u
M8 DOUT PP N6 VDD0 pch L=0.8u W=120u
M9 N10 DIN VDD0 VDD0 pch L=0.35u W=10u
M10 NN N2 VDD0 VDD0 pch L=0.35u W=10u
M11 N6 N10 VDD0 VDD0 pch L=0.8u W=120u
M12 PP N11 VDD0 VDD0 pch L=0.35u W=10u
*M13 N12 N15 VDD0 VDD0 pch L=50u W=25u
*M14 DOUT N12 VDD0 VDD0 pch L=0.5u W=400u
XPNOT_1 ENB N2 PNOT
XPNOT_2 N2 N11 PNOT
*R15 N15 VSS0 1192 TC=0.0, 0.0
*R16 N1 VDD0 1164 TC=0.0, 0.0
.ENDS
.SUBCKT inv1 A Y
M1 Y A Vss Vss nch L=1.2u W=3u M=1
M2 Y A Vdd Vdd pch L=0.4u W=3u M=1
.ENDS
.SUBCKT inv1P A Y
M1 Y A VSS1 VSS nch L=1.2u W=3.u M=1
M2 Y A VDD1 VDD1 pch L=0.4u W=3.u M=1
.ENDS
.SUBCKT inv1F A Y
M1 Y A VSS1 VSS nch L=0.4u W=1.2u M=1
M2 Y A VDD1 VDD1 pch L=0.4u W=3u M=1
.ENDS
.SUBCKT INV1S A Y
M1 N1 A VSS1 VSS nch L=0.4u W=1.2u M=1
M2 Y A N1 VSS nch L=0.4u W=1.2u M=1
M3 Y A N2 VDD1 pch L=0.4u W=3u M=1
M4 N2 A VDD1 VDD1 pch L=0.4u W=3u M=1
M5 VDD1 Y N1 VSS nch L=1.2u W=1.2u M=1
M6 VSS1 Y N2 VDD1 pch L=1.2u W=3u M=1
.ENDS
.SUBCKT inv4P A Y
M1 Y A VSS1 VSS nch L=1.2u W=12u M=1
M2 Y A VDD1 VDD1 pch L=0.4u W=12u M=1
.ENDS
.SUBCKT inv4 A Y
M1 Y A VSS VSS nch L=1.2u W=12u M=1
M2 Y A VDD VDD pch L=0.4u W=12u M=1
.ENDS
.SUBCKT NAND3P A B C Y
M1 N3 C VSS1 Vss nch L=0.4u W=1.2u M=1
M2 N6 B N3 Vss nch L=0.4u W=1.2u M=1
M3 Y A N6 Vss nch L=0.4u W=1.2u M=1
M4 Y A VDD1 VDD1 pch L=0.4u W=1.2u M=1
M5 Y B VDD1 VDD1 pch L=0.4u W=1.2u M=1
M6 Y C VDD1 VDD1 pch L=0.4u W=1.2u M=1
.ENDS
.SUBCKT NAND3 A B C Y
M1 N3 C Vss Vss nch L=0.4u W=1.2u M=1
M2 N2 B N3 Vss nch L=0.4u W=1.2u M=1
M3 Y A N2 Vss nch L=0.4u W=1.2u M=1
M4 Y A Vdd Vdd pch L=0.4u W=1.2u M=1
M5 Y B Vdd Vdd pch L=0.4u W=1.2u M=1
M6 Y C Vdd Vdd pch L=0.4u W=1.2u M=1
.ENDS
.SUBCKT NANDP A B Y
M1 N3 B VSS1 VSS nch L=0.4u W=1.2u M=1
M2 Y A N3 VSS nch L=0.4u W=1.2u M=1
M3 Y A VDD1 VDD1 pch L=0.4u W=1.2u M=1
M4 Y B VDD1 VDD1 pch L=0.4u W=1.2u M=1
.ENDS
.SUBCKT NAND A B Y
M1 N2 B Vss Vss nch L=0.4u W=1.2u M=1 off
M2 Y A N2 Vss nch L=0.4u W=1.2u M=1 off
M3 Y A Vdd Vdd pch L=0.4u W=1.2u M=1
M4 Y B Vdd Vdd pch L=0.4u W=1.2u M=1
.ENDS
.SUBCKT NORP A B Y
M1 Y B VSS1 VSS nch L=1.2u W=3u M=1
M2 Y A VSS1 VSS nch L=1.2u W=3u M=1
M3 Y A N3 VDD1 pch L=0.4u W=3u M=1
M4 N3 B VDD1 VDD1 pch L=0.4u W=3u M=1
.ENDS
.SUBCKT NOR A B Y
M1 Y B VSS VSS nch L=1.2u W=3u M=1
M2 Y A VSS VSS nch L=1.2u W=3u M=1
M3 Y A N9 VDD pch L=0.4u W=3u M=1
M4 N9 B VDD VDD pch L=0.4u W=3u M=1
.ENDS
.SUBCKT TRBUF IN OE OUT
X1 IN N2 inv1P
X2 OE IN N3 NANDP
X3 OE N2 N4 NANDP
X4 N4 N1 inv1P
M1 OUT N1 VSS1 VSS nch L=1.2u W=12u M=1
M2 OUT N3 VDD1 VDD1 pch L=0.4u W=12u M=1
.ENDS
.SUBCKT ANDP A B Y
X1 N3 Y inv1P
M1 N2 B VSS1 VSS nch L=0.4u W=1.2u M=1
M2 N3 A N2 VSS nch L=0.4u W=1.2u M=1
M3 N3 A VDD1 VDD1 pch L=0.4u W=1.2u M=1
M4 N3 B VDD1 VDD1 pch L=0.4u W=1.2u M=1
.ENDS
.SUBCKT AND3P A B C Y
X1 N2 Y inv1P
M1 N4 C VSS1 VSS nch L=0.4u W=1.2u M=1
M2 N3 B N4 VSS nch L=0.4u W=1.2u M=1
M3 N2 A N3 VSS nch L=0.4u W=1.2u M=1
M4 N2 A VDD1 VDD1 pch L=0.4u W=1.2u M=1
M5 N2 B VDD1 VDD1 pch L=0.4u W=1.2u M=1
M6 N2 C VDD1 VDD1 pch L=0.4u W=1.2u M=1
.ENDS
.SUBCKT AND4P A B C D Y
X1 N1 Y inv1P
M1 N5 D VSS1 VSS nch L=0.4u W=1.2u M=1
M2 N4 C N5 VSS nch L=0.4u W=1.2u M=1
M3 N3 B N4 VSS nch L=0.4u W=1.2u M=1
M4 N1 A N3 VSS nch L=0.4u W=1.2u M=1
M5 N1 A VDD1 VDD1 pch L=0.4u W=1.2u M=1
M6 N1 B VDD1 VDD1 pch L=0.4u W=1.2u M=1
M7 N1 C VDD1 VDD1 pch L=0.4u W=1.2u M=1
M8 N1 D VDD1 VDD1 pch L=0.4u W=1.2u M=1
.ENDS
.SUBCKT AND5P A B C D E Y
X1 N33 Y inv1P
M1 N37 D N38 VSS nch L=0.4u W=1.2u M=1
M2 N36 C N37 VSS nch L=0.4u W=1.2u M=1
M3 N35 B N36 VSS nch L=0.4u W=1.2u M=1
M4 N33 A N35 VSS nch L=0.4u W=1.2u M=1
M5 N33 A VDD1 VDD1 pch L=0.4u W=1.2u M=1
M6 N33 B VDD1 VDD1 pch L=0.4u W=1.2u M=1
M7 N33 C VDD1 VDD1 pch L=0.4u W=1.2u M=1
M8 N33 D VDD1 VDD1 pch L=0.4u W=1.2u M=1
M9 N38 E VSS1 VSS nch L=0.4u W=1.2u M=1
M10 N33 E VDD1 VDD1 pch L=0.4u W=1.2u M=1
.ENDS
.SUBCKT RSFF1 Q QB R S
X1 S N3 inv1P
X2 R N1 inv1P
X3 N3 QB Q NANDP
X4 Q N1 QB NANDP
.ENDS
.SUBCKT RSFF2 Q QB R S
X1 S N2 N3 NANDP
X2 R N2 inv1P
X3 N3 QB Q NANDP
X4 Q N2 QB NANDP
.ENDS
.SUBCKT GINVP A CK CKB Y
M1 N3 CK VSS1 VSS nch L=1.2u W=1.2u M=1
M2 Y A N3 VSS nch L=1.2u W=1.2u M=1
M3 Y A N8 VDD1 pch L=0.4u W=1.2u M=1
M4 N8 CKB VDD1 VDD1 pch L=0.4u W=1.2u M=1
.ENDS
.SUBCKT LatchP CK CKB D Q RB
X1 D CKB CK IQ GINVP
X2 IQ Q inv1P
X3 Q CK CKB IQ GINVP
M1 IQ RB VDD1 VDD1 pch L=0.4u W=3u M=1
.ENDS
.SUBCKT DFFP CK D Q QB RB
X1 CK ICKB inv1P
X2 ICKB ICK inv1P
X3 Q QB inv1P
X4 ICK ICKB D IQ RB LatchP
X5 ICKB ICK IQ Q RB LatchP
.ENDS
.SUBCKT EDFFP CK D E Q QB RB
X1 CK N3 Q QB RB DFFP
X2 N1 N2 N3 NANDP
X3 Q N5 N1 NANDP
X4 D E N2 NANDP
X5 E N5 inv1P
.ENDS
.SUBCKT SHIFT4 CK DIN DOUT EIN Q0 Q1 Q2 Q3 RST
X1 EIN N2 inv1P
X2 N2 N13 inv4P
X3 CK N1 inv1P
X4 N1 N9 inv4P
X5 RST N8 inv4P
X6 N3 Q0 inv1P
X7 N7 Q1 inv1P
X8 N4 Q2 inv1P
X9 N5 Q3 inv1P
X10 N9 DIN N13 N12 N3 N8 EDFFP
X11 N9 N12 N13 N6 N7 N8 EDFFP
X12 N9 N6 N13 N10 N4 N8 EDFFP
X13 N9 N10 N13 DOUT N5 N8 EDFFP
.ENDS
.SUBCKT SELECTOR D0 D1 SEL Y
X1 SEL N1 inv1P
X2 D1 SEL N11 NANDP
X3 D0 N1 N6 NANDP
X4 N11 N6 Y NANDP
.ENDS
.SUBCKT COUNTA CK EIN EOUT MODE Q0 Q1 Q2 Q3 RST
X1 EIN N66 inv1P
X2 N66 N71 inv4P
X3 MODE N69 inv1P
X4 N69 N73 inv4P
X5 CK N70 inv1P
X6 N70 N72 inv4P
X7 RST N79 inv4P
X8 Q0 QB0 inv1P
X9 Q1 QB1 inv1P
X10 Q2 QB2 inv1P
X11 Q3 QB3 inv1P
X12 QB0 N71 N65 ANDP
X13 Q0 N71 N81 ANDP
X14 QB0 QB1 N71 N75 AND3P
X15 Q0 Q1 N71 N82 AND3P
X16 QB0 QB1 QB2 N71 N76 AND4P
X17 Q0 Q1 Q2 N71 N83 AND4P
X18 QB0 QB1 QB2 QB3 N71 N78 AND5P
X19 Q0 Q1 Q2 Q3 N71 N74 AND5P
X20 N81 N65 N73 N84 SELECTOR
X21 N82 N75 N73 N85 SELECTOR
X22 N83 N76 N73 N86 SELECTOR
X23 N74 N78 N73 EOUT SELECTOR
X24 N72 QB0 N71 Q0 N80 N79 EDFFP
X25 N72 QB1 N84 Q1 N67 N79 EDFFP
X26 N72 QB2 N85 Q2 N77 N79 EDFFP
X27 N72 QB3 N86 Q3 N68 N79 EDFFP
.ENDS
.SUBCKT BIAS IIN VH VL VM Gnd
C1 IIN VH 1pF
C2 N2 VL 1pF
M4 IIN IIN N2 VSS nch L=1u W=3u M=10
M3 VH IIN VL VSS nch L=1u W=3u M=10
M2 VL VL VSS VSS nch L=3u W=3u M=10
M1 N2 VL VSS VSS nch L=3u W=3u M=10
M5 VH VH VDD VDD pch L=3u W=3.u M=10
R3 Gnd VM 1K TC=0.0, 0.0
.ENDS
.SUBCKT BIASP DG IIN VH VL VM
C1 IIN VH 1pF
C2 N8 VL 1pF
M4 IIN IIN N8 VSS nch L=1u W=3u M=10
M3 VH IIN VL VSS nch L=1u W=3u M=10
M2 VL VL VSS1 VSS nch L=3u W=3u M=10
M1 N8 VL VSS1 VSS nch L=3u W=3u M=10
M5 VH VH VDD1 VDD1 pch L=3u W=3.u M=10
R3 DG VM 1K TC=0.0, 0.0
.ENDS
.SUBCKT BIAS1 IIN VH VL
M1 VL VL VSS VSS nch L=3u W=3u M=10
M2 VH IIN VL VSS nch L=1u W=3u M=10
M3 VH VH VDD VDD pch L=3u W=3.u M=10
C4 VH IIN 1pF
C5 VL N3 1pF
M6 IIN IIN N3 VSS nch L=1u W=3u M=10
M7 N3 VL VSS VSS nch L=3u W=3u M=10
.ENDS
.SUBCKT BIAS2 IIN IOUT
C1 N2 N5 1pF
C2 IIN N3 1pF
M3 N2 N5 VSS VSS nch L=3u W=3u M=10
M4 IIN IIN N2 VSS nch L=1u W=3u M=10
M5 N5 N5 VSS VSS nch L=3u W=3u M=10
M6 N3 IIN N5 VSS nch L=1u W=3u M=10
M7 IOUT N3 VDD VDD pch L=3u W=3.u M=10
M8 N3 N3 VDD VDD pch L=3u W=3.u M=20
.ENDS
.SUBCKT BIAS4 IIN IOUT
C1 N10 N12 1pF
C2 IIN N3 1pF
M3 IIN IIN N10 VSS nch L=1u W=3u M=10
M4 N10 N12 VSS VSS nch L=3u W=3u M=10
M5 N12 N12 VSS VSS nch L=3u W=3u M=10
M6 N3 IIN N12 VSS nch L=1u W=3u M=10
M7 IOUT N3 VDD VDD pch L=3u W=3.u M=10
M8 N3 N3 VDD VDD pch L=3u W=3.u M=40
.ENDS
.SUBCKT BIAS8 IIN IOUT
M1 M1D M1D VSS VSS nch L=3u W=3u M=10
M2 N1 IIN M1D VSS nch L=1u W=3u M=10
M3 N1 N1 VDD VDD pch L=3u W=3.u M=80
M4 IOUT N1 VDD VDD pch L=3u W=3.u M=10
C5 N2 M1D 1pF
C6 IIN N1 1pF
M7 N2 M1D VSS VSS nch L=3u W=3u M=10
M8 IIN IIN N2 VSS nch L=1u W=3u M=10
.ENDS
.SUBCKT BIASF D0 D1 D2 D3 IIN IOUT Gnd
XBIAS_1 IIN N42 N34 N35 Gnd BIAS
C1 N38 N34 4pF
M2 N38 D0 N33 VSS nch L=1u W=3u M=1
M3 N33 N34 VSS VSS nch L=3u W=3u M=1
M4 N38 D1 N40 VSS nch L=1u W=3u M=2
M5 N40 N34 VSS VSS nch L=3u W=3u M=2
M6 N38 D2 N41 VSS nch L=1u W=3u M=4
M7 N41 N34 VSS VSS nch L=3u W=3u M=4
M8 N38 D3 N37 VSS nch L=1u W=3u M=8
M9 N37 N34 VSS VSS nch L=3u W=3u M=8
M10 N39 N35 N38 VSS nch L=1u W=3u M=10
M11 IOUT N39 VDD VDD pch L=3u W=3u M=10
M12 N39 N39 VDD VDD pch L=3u W=3u M=10
.ENDS
.SUBCKT BIASGEN IIN IOUT2 IOUT3 IOUT4 IOUT5 VH1 VL1
C1 N1 VL1 1pF
C2 IIN VH1 1pF
M3 N1 VL1 VSS VSS nch L=3u W=3u M=10
M4 VL1 VL1 VSS VSS nch L=3u W=3u M=10
M5 VH1 IIN VL1 VSS nch L=1u W=3u M=10
M6 IIN IIN N1 VSS nch L=1u W=3u M=10
M7 VH1 VH1 VDD VDD pch L=3u W=3.u M=10
M8 IOUT2 VH1 VDD VDD pch L=3u W=3.u M=10
M9 IOUT3 VH1 VDD VDD pch L=3u W=3.u M=10
M10 IOUT4 VH1 VDD VDD pch L=3u W=3.u M=10
M11 IOUT5 VH1 VDD VDD pch L=3u W=3.u M=10
.ENDS
.SUBCKT LVD D DGND VH Y0 Y1
X1 D N1 inv1P
M1 N3 VH VDD1 VDD1 pch L=3u W=3.u M=36
M2 N3 N1 Y0 Vss nch L=0.4u W=1.2u M=18
M3 N3 D Y1 Vss nch L=0.4u W=1.2u M=18
M4 Y0 D DGND Vss nch L=0.4u W=1.2u M=18
M5 Y1 N1 DGND Vss nch L=0.4u W=1.2u M=18
R6 Y1 Y0 10K TC=0.0, 0.0
.ENDS
.SUBCKT LVR D0 D1 VL VM Y
X2 N1 Y inv4P
XINV1S_1 N34 N1 INV1S
M1 N15 N15 VDD1 VDD1 pch L=0.4u W=3u M=1
M2 N36 N15 VDD1 VDD1 pch L=0.4u W=3u M=1
M3 N15 D1 N33 Vss nch L=0.4u W=1.2u M=1
M4 VDD1 D0 N33 Vss nch L=0.4u W=1.2u M=1
M5 N33 VL VSS1 Vss nch L=3u W=3u M=2
M6 N35 VL VSS1 Vss nch L=3u W=3u M=1
M7 N34 VM N35 Vss nch L=0.4u W=3u M=1
M8 N34 VM N36 VDD1 pch L=0.4u W=3u M=1
.ENDS
.SUBCKT LVR2 D0 D1 ENB VL VM Y
X2 N34 Y inv4P
M1 N35 VM N33 VSS nch L=0.4u W=3u M=1
M2 N35 VM N42 VDD1 pch L=0.4u W=3u M=1
M3 N37 ENB N40 VSS nch L=1u W=3u M=2
XINV1S_1 N35 N34 INV1S
M4 N38 N38 VDD1 VDD1 pch L=0.4u W=3u M=1
M5 N42 N38 VDD1 VDD1 pch L=0.4u W=3u M=1
M6 N38 D1 N37 VSS nch L=0.4u W=1.2u M=1
M7 VDD1 D0 N37 VSS nch L=0.4u W=1.2u M=1
M8 N40 VL VSS1 VSS nch L=3u W=3u M=2
M9 N33 VL VSS1 VSS nch L=3u W=3u M=1
.ENDS
.SUBCKT LVR3 D0 D1 ENB Y
X1 N36 N33 inv1F
X2 N33 Y inv4P
X3 N35 N35 inv1F
M1 N34 ENB N37 VSS nch L=0.4u W=1.2u M=2
M2 N39 N39 VDD1 VDD1 pch L=0.4u W=3u M=1
M3 N39 D1 N34 VSS nch L=0.4u W=1.2u M=2
M4 VDD1 D0 N34 VSS nch L=0.4u W=1.2u M=2
M5 N37 N35 VSS1 VSS nch L=0.4u W=1.2u M=2
M6 N36 N35 VSS1 VSS nch L=0.4u W=1.2u M=1
M7 N36 N39 VDD1 VDD1 pch L=0.4u W=3u M=1
.ENDS
.SUBCKT LVR4 D0 D1 ENB VL Y
X1 N3 N7 inv1F
X2 N7 Y inv4P
M1 N1 ENB N4 VSS nch L=1u W=3u M=2
Xinv1P_1 ENB N9 inv1P
M2 N6 N6 VDD1 VDD1 pch L=0.4u W=3u M=1
M3 N6 D1 N1 VSS nch L=0.4u W=1.2u M=2
M4 N2 D0 N1 VSS nch L=0.4u W=1.2u M=2
M5 N4 VL VSS1 VSS nch L=3u W=3u M=2
M6 N3 N10 VSS1 VSS nch L=0.4u W=1.2u M=1
M7 N10 N10 VSS1 VSS1 nch L=0.4u W=1.2u M=1
M8 N3 N9 VSS1 VSS nch L=0.4u W=1.2u M=1
M9 N2 N2 VDD1 VDD1 pch L=0.4u W=3u M=1
M10 N10 N2 VDD1 VDD1 pch L=0.4u W=3u M=1
M11 N3 N6 VDD1 VDD1 pch L=0.4u W=3u M=1
.ENDS
.SUBCKT HITR2 HIT OUT VL VM
XINV1S_1 N5 N1 INV1S
Xinv4P_1 N1 OUT inv4P
M1 N5 VM N7 VSS nch L=1u W=3u M=1
M2 HIT HIT N10 VSS nch L=1u W=3u M=1
M3 N10 N10 VSS1 VSS nch L=3u W=3u M=1
M4 N3 HIT N17 VSS nch L=1u W=3u M=1
M5 N17 N10 VSS1 VSS nch L=3u W=3u M=1
M6 N7 VL VSS1 VSS nch L=3u W=3u M=1
M7 N5 N3 N6 VDD1 pch L=1u W=3u M=2
M8 N3 N3 N2 VDD1 pch L=1u W=3u M=1
M9 N2 N2 VDD1 VDD1 pch L=3u W=3u M=1
M10 N6 N2 VDD1 VDD1 pch L=3u W=3u M=2
.ENDS
.SUBCKT HITR1 HIT OUT VL VM
XINV1S_1 N37 N34 INV1S
Xinv4P_1 N34 OUT inv4P
M1 N37 VM N33 VSS nch L=1u W=3u M=1
M2 N33 VL VSS1 VSS nch L=3u W=3u M=1
M3 N37 HIT N36 VDD1 pch L=1u W=3u M=2
M4 HIT HIT N35 VDD1 pch L=1u W=3u M=1
M5 N35 N35 VDD1 VDD1 pch L=3u W=3u M=1
M6 N36 N35 VDD1 VDD1 pch L=3u W=3u M=2
.ENDS
.SUBCKT MUX1 AIN AOUT0 AOUT1 ENB VH VL VM
Xinv1_1 ENB N3 inv1
M1 AOUT1 AIN N6 VSS nch L=1u W=3u M=10
M2 AOUT0 VM N6 VSS nch L=1u W=3u M=10
M3 N6 ENB N5 VSS nch L=1u W=3u M=10
M4 N5 VL VSS VSS nch L=3u W=3u M=10
M5 AOUT1 AIN N2 VDD pch L=1u W=8u M=10
M6 AOUT0 VM N2 VDD pch L=1u W=8u M=10
M7 N2 N3 N4 VDD pch L=1u W=3u M=10
M8 N4 VH VDD VDD pch L=3u W=3u M=10
.ENDS
.SUBCKT MUX2B AIN AOUT0 AOUT1 ENB VH VL VM
Xinv1_1 ENB N72 inv1
M1 AOUT1 AIN N65 VSS nch L=1u W=3u M=10
M2 AOUT0 VM N69 VSS nch L=1u W=3u M=10
M3 N69 ENB N78 VSS nch L=1u W=3u M=10
M4 N78 VL VSS VSS nch L=3u W=3u M=10
M5 N66 VL VSS VSS nch L=3u W=3u M=10
M6 N65 ENB N66 VSS nch L=1u W=3u M=10
M7 N67 VDD N70 VSS nch L=1u W=1.2u M=1
M8 N69 VDD N65 VSS nch L=1u W=1.2u M=1
M9 AOUT1 AIN N67 VDD pch L=1u W=8u M=10
M10 AOUT0 VM N70 VDD pch L=1u W=8u M=10
M11 N70 N72 N77 VDD pch L=1u W=3u M=10
M12 N77 VH VDD VDD pch L=3u W=3u M=10
M13 N65 VSS N69 VDD pch L=1u W=3u M=1
M14 N70 VSS N67 VDD pch L=1u W=3u M=1
M15 N71 VH VDD VDD pch L=3u W=3u M=10
M16 N67 N72 N71 VDD pch L=1u W=3u M=10
.ENDS
.SUBCKT MUX3B AIN AOUT0 AOUT1 ENB VH VM
Xinv1_1 ENB N70 inv1
M1 N66 VDD N71 VSS nch L=1u W=1.2u M=1
M2 N31 N65 VSS VSS nch L=1u W=1.2u M=10
M3 N47 N68 VSS VSS nch L=1u W=1.2u M=10
M4 N68 N68 VSS VSS nch L=1u W=1.2u M=10
M5 AOUT1 ENB N37 VSS nch L=1u W=1.2u M=10
M6 N65 N65 VSS VSS nch L=1u W=1.2u M=10
M7 AOUT0 ENB N31 VSS nch L=1u W=1.2u M=10
M8 N37 N68 VSS VSS nch L=1u W=1.2u M=10
M9 N92 VM N45 VSS nch L=1u W=1.2u M=10
M10 N45 N65 VSS VSS nch L=1u W=1.2u M=10
M11 N96 VM N47 VSS nch L=1u W=1.2u M=10
M12 N65 AIN N66 VDD pch L=1u W=8u M=10
M13 N68 VM N71 VDD pch L=1u W=8u M=10
M14 N71 N70 N69 VDD pch L=1u W=3u M=10
M15 N69 VH VDD VDD pch L=3u W=3u M=10
M16 N71 VSS N66 VDD pch L=1u W=3u M=1
M17 N67 VH VDD VDD pch L=3u W=3u M=10
M18 N66 N70 N67 VDD pch L=1u W=3u M=10
M19 AOUT1 N70 N83 VDD pch L=1u W=3u M=10
M20 AOUT0 N70 N87 VDD pch L=1u W=3u M=10
M21 N83 N92 VDD VDD pch L=1u W=3u M=10
M22 N87 N96 VDD VDD pch L=1u W=3u M=10
M23 N96 N96 VDD VDD pch L=1u W=3u M=10
M24 N92 N92 VDD VDD pch L=1u W=3u M=10
.ENDS
.SUBCKT SHPR2 AOUT NEG POS VH VL VM
M4 N9 VH Vdd Vdd pch L=3u W=3.u M=2
M5 N7 NEG N9 N9 pch L=1u W=3.u M=20
M6 N11 POS N9 N9 pch L=1u W=3.u M=20
M7 N7 VL Vss Vss nch L=3u W=3u M=2
M8 N11 VL Vss Vss nch L=3u W=3u M=2
M9 AOUT VM N7 Vss nch L=1u W=3.u M=1
M10 N30 VM N11 Vss nch L=1u W=3.u M=1
M11 AOUT N30 N39 Vdd pch L=1u W=3.u M=1
M12 N30 N30 N42 Vdd pch L=1u W=3.u M=1
M13 N39 N42 Vdd Vdd pch L=1u W=3.u M=1
M14 N42 N42 Vdd Vdd pch L=1u W=3.u M=1
.ENDS
.SUBCKT MUX4 AIN AOUT ENB LOAD VH VL VM
Xinv1_1 ENB ENBB inv1
M1 N6 N2 N5 VSS nch L=0.4u W=3u M=10
M2 N5 VM N3 VSS nch L=1u W=3u M=10
M3 N4 VM N1 VSS nch L=1u W=3u M=10
M4 N3 VL VSS VSS nch L=3u W=3u M=10
M5 N1 VL VSS VSS nch L=3u W=3u M=10
M6 AOUT ENB N4 VSS nch L=1u W=1.2u M=10
M7 N5 ENB LOAD VSS nch L=1u W=1.2u M=10
M8 N6 N6 VDD VDD pch L=0.4u W=3u M=10
M9 N7 N6 VDD VDD pch L=0.4u W=3u M=10
M10 N4 ENBB AOUT VDD pch L=1u W=3u M=10
M11 LOAD ENBB N5 VDD pch L=1u W=3u M=10
M12 N4 VM N7 VDD pch L=0.4u W=3u M=10
XSHPR2_1 N2 N5 AIN VH VL VM SHPR2
.ENDS
.SUBCKT RF1 IOUT VH VIN1 VIN2 VM
M1 N4 VIN1 N1 N1 pch L=1u W=3.u M=1
M2 IOUT VIN2 N1 N1 pch L=1u W=3.u M=1
M3 N1 VH VDD VDD pch L=3u W=3.u M=2
M4 IOUT VM N3 VSS nch L=1u W=3u M=1
M5 N4 N4 VSS VSS nch L=3u W=3u M=1
M6 N3 N4 VSS VSS nch L=3u W=3u M=1
.ENDS
.SUBCKT RF2 IOUT VH VIN1 VIN2 VL VM
M1 N38 VIN1 N33 N33 pch L=1u W=3.u M=1
M2 N35 N35 N33 N33 pch L=1u W=3.u M=1
M3 N35 N35 N34 N34 pch L=1u W=3.u M=1
M4 IOUT VIN2 N34 N34 pch L=1u W=3.u M=1
M5 N33 VH VDD VDD pch L=3u W=3.u M=2
M6 N34 VH VDD VDD pch L=3u W=3.u M=2
M7 IOUT VM N36 VSS nch L=1u W=3u M=1
M8 N38 N38 VSS VSS nch L=3u W=3u M=1
M9 N35 VL VSS VSS nch L=3u W=3u M=2
M10 N36 N38 VSS VSS nch L=3u W=3u M=1
.ENDS
.SUBCKT RF3 IOUT VH VIN1 VIN2 VL VM
M1 N33 VIN1 N37 N37 pch L=1u W=3.u M=1
M2 N35 N35 N37 N37 pch L=1u W=3.u M=1
M3 N35 N35 N40 N40 pch L=1u W=3.u M=1
M4 N34 N34 N40 N40 pch L=1u W=3.u M=1
M5 N34 N34 N38 N38 pch L=1u W=3.u M=1
M6 IOUT VIN2 N38 N38 pch L=1u W=3.u M=1
M7 N37 VH VDD VDD pch L=3u W=3.u M=2
M8 N40 VH VDD VDD pch L=3u W=3.u M=2
M9 N38 VH VDD VDD pch L=3u W=3.u M=2
M10 N33 N33 VSS VSS nch L=3u W=3u M=1
M11 N35 VL VSS VSS nch L=3u W=3u M=2
M12 N34 VL VSS VSS nch L=3u W=3u M=2
M13 N39 N33 VSS VSS nch L=3u W=3u M=1
M14 IOUT VM N39 VSS nch L=1u W=3u M=1
.ENDS
.SUBCKT CFINV AIN AOUT VH VL VM
M1 N38 N38 VSS VSS nch L=3u W=3u M=10
M2 N2 N34 AIN VSS nch L=0.4u W=3u M=1
M3 AIN N38 VSS VSS nch L=3u W=3u M=1
M4 N35 N38 VSS VSS nch L=3u W=3u M=1
M5 AOUT VM N35 VSS nch L=1u W=3u M=1
M6 N33 VH VDD VDD pch L=3u W=3.u M=1
M7 N38 VM N33 VDD pch L=1u W=3.u M=1
M8 N2 N2 VDD VDD pch L=1u W=3u M=1
M9 N37 N2 VDD VDD pch L=1u W=3u M=1
M10 AOUT VM N37 VDD pch L=1u W=3u M=1
XSHPR2_1 N34 AIN VM VH VL VM SHPR2
.ENDS
.SUBCKT FB1 IOUT VH VIN1 VIN2 VL VM
M1 VSS VIN1 N3 N3 pch L=1u W=3.u M=1
M2 IOUT VIN2 N3 N3 pch L=1u W=3.u M=1
M3 N3 VH VDD VDD pch L=3u W=3.u M=2
M4 IOUT VM N1 VSS nch L=1u W=3u M=1
M5 N1 VL VSS VSS nch L=3u W=3u M=1
.ENDS
.SUBCKT FB2 IOUT VH VIN1 VIN2 VL VM
C1 N2 VSS 1pF
M2 N2 VIN1 N1 N1 pch L=1u W=3.u M=1
M3 IOUT VIN2 N1 N1 pch L=1u W=3.u M=1
M4 N1 VH VDD VDD pch L=3u W=3.u M=2
M5 IOUT VM N3 VSS nch L=1u W=3u M=1
M6 N3 N2 VSS VSS nch L=3u W=3u M=1
M7 N2 VL VSS VSS nch L=3u W=3u M=1
.ENDS
.SUBCKT FB3 VG VIN1 VIN2 VL Gnd
M1 N2 VG VIN2 Gnd pch L=1u W=3.u M=1
M2 VDD VIN1 N2 VSS nch L=1u W=3u M=1
M3 N2 VL VSS VSS nch L=3u W=3u M=1
.ENDS
.SUBCKT FB4 VH VIN1 VIN2 VL VLS VM
C1 N34 VSS 2pF
C2 N35 VSS 0.075pF
.ic v(VIN2,VP)=0
M3 N36 N34 VSS VSS nch L=3u W=3u M=1
M4 VP VLS VSS VSS nch L=3u W=3u M=1
M5 VDD VIN1 VP VSS nch L=0.4u W=3u M=1
M6 N35 VL VSS VSS nch L=3u W=3u M=1
M7 N34 VL VSS VSS nch L=3u W=3u M=1
M8 VDD VH N33 VDD pch L=3u W=3.u M=1
M9 VIN2 N35 N36 VIN2 pch L=0.4u W=3.u M=1
M10 N33 VM VIN2 VDD pch L=1u W=3.u M=1
M11 N39 VM N37 VDD pch L=1u W=3.u M=1
M12 N35 N35 VP VP pch L=0.4u W=3.u M=1
M13 VDD VH N39 VDD pch L=3u W=3.u M=1
M14 N37 N35 N34 N37 pch L=0.4u W=3.u M=1
.ENDS
.SUBCKT FB4B VH VIN1 VIN2 VL VLS VM
M1 VDD VH N7 VDD pch L=3u W=3.u M=1
M2 N7 VM VIN2 VDD pch L=1u W=3.u M=1
M3 VIN2 N3 N10 VIN2 pch L=0.4u W=3.u M=1
M4 N10 VL VSS VSS nch L=3u W=3u M=1
M5 N3 VL VSS VSS nch L=3u W=3u M=1
M6 VP1 N3 N3 VP1 pch L=0.4u W=3.u M=1
M7 VDD VIN1 VP1 VSS nch L=0.4u W=3u M=1
M8 VP1 VLS VSS VSS nch L=3u W=3u M=1
.ic v(VIN2,VP1)=0
.ENDS
.SUBCKT FB5 AUX RB VIN1 VIN2 VL
Xinv1_1 RB N1 inv1
M1 AUX RB VIN2 AUX pch L=0.4u W=0.6u M=2
M2 VDD VIN1 AUX VSS nch L=1u W=3u M=1
M3 AUX VL VSS VSS nch L=3u W=3u M=1
M4 VIN2 N1 VIN2 AUX pch L=0.4u W=0.6u M=1
.ENDS
.SUBCKT FBAMP VH VIN VL VM VOUT Gnd
M1 VDD N1 VOUT VSS nch L=0.4u W=3u M=10
M2 VOUT VL VSS VSS nch L=3u W=3u M=10
R3 Gnd N4 1K TC=0.0, 0.0
R4 N4 VOUT 9K TC=0.0, 0.0
XSHPR2_1 N1 N4 VIN VH VL VM SHPR2
.ENDS
.SUBCKT prB AIN AOUT VH VL VM
M1 N2 AIN GND GND pch L=0.5u W=15u M=150
M2 N2 VL Vss Vss nch L=3u W=3u M=51
M3 AOUT VM N2 Vss nch L=1u W=3.u M=1
M4 AOUT VM N1 Vdd pch L=1u W=3.u M=1
M5 N1 VH Vdd Vdd pch L=3u W=3.u M=1
.ENDS
.SUBCKT prC AIN AOUT VH VL VM
M1 N2 AIN GND GND pch L=0.5u W=8u M=100
M2 N2 VL Vss Vss nch L=3u W=3u M=11
M3 AOUT VM N2 Vss nch L=1u W=3.u M=1
M4 AOUT VM N1 Vdd pch L=1u W=3.u M=1
M5 N1 VH Vdd Vdd pch L=3u W=3.u M=1
.ENDS
.SUBCKT prD AIN AOUT VH VL VM
M1 N7 AIN GND GND pch L=0.5u W=3u M=25
M2 N7 VL VSS VSS nch L=3u W=3u M=11
M3 AOUT VM N7 VSS nch L=1u W=3.u M=1
M4 AOUT VM N13 VDD pch L=1u W=3.u M=1
M5 N13 VH VDD VDD pch L=3u W=3.u M=1
.ENDS
.SUBCKT prC2 AIN AOUT VH VL VM
M1 N1 AIN GND GND pch L=0.5u W=8u M=100
M2 N1 VL VSS VSS nch L=3u W=3u M=11
M3 AOUT N2 N1 VSS nch L=1u W=3.u M=1
M4 AOUT VM N3 VDD pch L=1u W=3.u M=1
M5 N3 VH VDD VDD pch L=3u W=3.u M=1
M6 N2 N1 GND GND pch L=1u W=3u M=1
M7 N2 VL VSS VSS nch L=3u W=3u M=1
.ENDS
.SUBCKT prE AIN AOUT VH VM
M1 N4 AIN VSS VSS nch L=0.5u W=8u M=100
M2 AOUT VM N4 VSS nch L=1u W=3u M=1
M3 AOUT VM N3 VDD pch L=1u W=3.u M=1
M4 N3 VH VDD VDD pch L=3u W=3.u M=1
M5 N2 VH VDD VDD pch L=3u W=3.u M=9
M6 N4 VM N2 VDD pch L=1u W=3.u M=9
.ENDS
.SUBCKT prE2 AIN AOUT VH VHS VM
C1 N1 VSS 0.2pF
M2 N3 AIN VSS VSS nch L=0.5u W=8u M=100
M3 AOUT N1 N3 VSS nch L=1u W=3u M=1
M4 AOUT VM N5 VDD pch L=1u W=3.u M=1
M5 N5 VH VDD VDD pch L=3u W=3.u M=1
M6 N1 N3 VSS VSS nch L=1u W=1.2u M=1
M7 N2 VH VDD VDD pch L=3u W=3.u M=9
M8 N3 VM N2 VDD pch L=1u W=3.u M=9
M9 N6 VHS VDD VDD pch L=3u W=3u M=1
M10 N1 VM N6 VDD pch L=1u W=3u M=1
.ENDS
.SUBCKT prF AIN AOUT VH VL VM
M1 N4 AIN Vss Vss nch L=0.5u W=8u M=100
M2 N3 VH VDD VDD pch L=3u W=3.u M=11
M3 N1 VL Vss Vss nch L=1u W=3u M=1
M4 AOUT VM N1 Vss nch L=1u W=3u M=1
M5 N3 VM N4 Vss nch L=1u W=3u M=10
M6 AOUT VM N3 VDD pch L=1u W=3.u M=1
.ENDS
.SUBCKT COMP0 INN INP OUTB VH VL
M1 N1 N1 VSS VSS nch L=1u W=3u M=1
M2 VF N1 VSS VSS nch L=1u W=3u M=1
M3 OUTB VF VSS1 VSS nch L=1u W=3u M=1
M4 VN INP N9 VSS nch L=0.4u W=1.2u M=4
M5 VP INN N9 VSS nch L=0.4u W=1.2u M=4
M6 N9 VL VSS VSS nch L=3u W=3u M=4
M7 VP VP VDD VDD pch L=3u W=3u M=1
M8 VDD VH N6 VDD pch L=3u W=3u M=2
M9 VN VN VDD VDD pch L=3u W=3u M=1
M10 VDD1 VH OUTB VDD1 pch L=3u W=3u M=1
M11 VF VN N6 VDD pch L=0.4u W=3u M=2
M12 N1 VP N6 VDD pch L=0.4u W=3u M=2
.ENDS
.SUBCKT COMP1 AIN DOUT HLD RST VH VL VM VTH
X1 HLD N7 inv1P
X3 N2 AIN VTH VH VL VM SHPR2
X4 RST N3 inv1P
X5 N2 N1 INV1S
XDFFP_1 N1 N7 DOUT N5 N3 DFFP
.ENDS
.SUBCKT COMP2 AIN DOUT INH VH VL VM VTH
X2 N2 AIN VTH VH VL VM SHPR2
X5 INH N3 inv1P
XINV1S_1 N2 N5 INV1S
Xinv4P_1 N4 DOUT inv4P
XNANDP_1 N3 N5 N4 NANDP
.ENDS
.SUBCKT HYS1 FB IN1 IN2 OUT1 OUT2 VL VM
Xinv1P_1 FB N52 inv1P
M1 N33 VL VSS VSS nch L=3u W=3u M=1
M2 N34 VM N33 VSS nch L=0.4u W=3u M=1
M3 N34 N34 VDD VDD pch L=3u W=3u M=1
M4 OUT2 N34 VDD VDD pch L=3u W=3u M=1
M5 VSS IN2 OUT2 OUT2 pch L=0.4u W=3u M=10
M6 OUT1 N34 VDD VDD pch L=3u W=3u M=1
M7 VSS IN1 OUT1 OUT1 pch L=0.4u W=3u M=10
M8 N37 N34 VDD VDD pch L=3u W=3u M=1
M9 N36 VM N37 VDD pch L=0.4u W=3u M=1
M10 N36 N36 VSS VSS nch L=3u W=3u M=10
M11 N35 N36 VSS VSS nch L=3u W=3u M=1
M12 OUT2 FB N35 VSS nch L=1u W=1.2u M=1
M13 OUT1 N52 N35 VSS nch L=1u W=1.2u M=1
M14 OUT1 FB OUT1 VSS nch L=1u W=1.2u M=1
M15 OUT2 N52 OUT2 VSS nch L=1u W=1.2u M=1
.ENDS
.SUBCKT COMP3 AIN AUX HIT INH VH VL VM VTH
X1 HIT AIN AUX IN1 IN2 VL VM HYS1
C1 AUX VSS 1pF
Xinv1P_2 INH N1 inv1P
XINV1S_1 OUTY N2 INV1S
Xinv4P_1 N4 HIT inv4P
XNANDP_1 N2 N1 N4 NANDP
R2 VTH AUX 10K TC=0.0, 0.0
XSHPR2_1 OUTY IN1 IN2 VH VL VM SHPR2
.ENDS
.SUBCKT DTA1 INN INP OUTN OUTP VH VL VM
M1 N35 VL VSS VSS nch L=3u W=3u M=1
M2 OUTP VM N35 VSS nch L=1u W=1.2u M=1
M3 OUTN VM N35 VSS nch L=1u W=1.2u M=1
M4 OUTN INP N34 VSS nch L=0.4u W=1.2u M=4
M5 OUTP INN N34 VSS nch L=0.4u W=1.2u M=4
M6 N34 VL VSS VSS nch L=3u W=3u M=4
M7 OUTP OUTP N37 VDD pch L=1u W=3u M=1
M8 N37 N37 VDD VDD pch L=3u W=3u M=1
M9 OUTN OUTN N37 VDD pch L=1u W=3u M=1
M10 OUTN INP N33 VDD pch L=0.4u W=3u M=4
M11 N33 VH VDD VDD pch L=3u W=3u M=4
M12 OUTP INN N33 VDD pch L=0.4u W=3u M=4
.ENDS
.SUBCKT HYS2 FB OUTN OUTP VH VL
Xinv1P_1 FB N12 inv1P
M1 N2 VL VSS VSS nch L=3u W=3u M=2
M2 OUTN FB N2 VSS nch L=1u W=1.2u M=1
M3 OUTP N12 N2 VSS nch L=1u W=1.2u M=1
M4 OUTP FB OUTP VSS nch L=1u W=1.2u M=1
M5 OUTN N12 OUTN VSS nch L=1u W=1.2u M=1
M6 OUTN VH VDD VDD pch L=3u W=3u M=1
M7 OUTP VH VDD VDD pch L=3u W=3u M=1
.ENDS
.SUBCKT COMP4 AIN AUX0 AUX1 MON0 MON1 OUT VH1 VH2 VL1 VL2 VL3 VM1 VM3 VTH
XDTA1_1 VTH AIN AUX0 AUX1 VH1 VL1 VM1 DTA1
XDTA1_2 AUX0 AUX1 MON0 MON1 VH1 VL1 VM1 DTA1
XHYS2_1 OUT AUX0 AUX1 VH2 VL2 HYS2
XLVR_1 MON0 MON1 VL3 VM3 OUT LVR
.ENDS
.SUBCKT DTA2P INN INP OUTN OUTP SGND VH VL
M1 OUTN INP N2 VSS nch L=0.4u W=1.2u M=4
M2 OUTP INN N2 VSS nch L=0.4u W=1.2u M=4
M3 N2 VL VSS1 VSS nch L=3u W=3u M=8
M4 OUTN INP N1 VDD1 pch L=0.4u W=3u M=4
M5 N1 VH VDD1 VDD1 pch L=3u W=3u M=8
M6 OUTP INN N1 VDD1 pch L=0.4u W=3u M=4
R7 OUTN SGND 10K TC=0.0, 0.0
R8 OUTP SGND 10K TC=0.0, 0.0
.ENDS
.SUBCKT DTA2R INN INP OUTN OUTP SGND VH VL
M1 OUTN INP N3 VSS nch L=0.4u W=1.2u M=4
M2 OUTP INN N3 VSS nch L=0.4u W=1.2u M=4
M3 N3 VL VSS VSS nch L=3u W=3u M=8
M4 OUTN INP N2 VDD pch L=0.4u W=3u M=4
M5 N2 VH VDD VDD pch L=3u W=3u M=8
M6 OUTP INN N2 VDD pch L=0.4u W=3u M=4
R7 OUTN SGND 10K TC=0.0, 0.0
R8 OUTP SGND 10K TC=0.0, 0.0
.ENDS
.SUBCKT COMP5 AUX0 AUX1 DGND ENB INN INP MON0 MON1 OUT VH1 VH2 VH3 VL1 VL2 VL3
+ Gnd
XDTA2P_1 N2 N1 N3 N6 DGND VH3 VL3 DTA2P
XDTA2P_2 N3 N6 MON0 MON1 DGND VH3 VL3 DTA2P
XDTA2R_1 INN INP N5 N4 Gnd VH1 VL1 DTA2R
XDTA2R_2 AUX0 AUX1 N8 N7 Gnd VH1 VL1 DTA2R
XDTA2R_3 N8 N7 N2 N1 Gnd VH1 VL1 DTA2R
XDTA2R_6 N5 N4 AUX0 AUX1 Gnd VH1 VL1 DTA2R
XHYS2_1 OUT AUX0 AUX1 VH2 VL2 HYS2
XLVR4_1 MON0 MON1 ENB VL3 OUT LVR4
.ENDS
.SUBCKT DTA2 INN INP OUTN OUTP VH VL
M1 OUTN INP N3 VSS nch L=0.4u W=1.2u M=4
M2 OUTP INN N3 VSS nch L=0.4u W=1.2u M=4
M3 N3 VL VSS VSS nch L=3u W=3u M=8
M4 OUTN INP N2 VDD pch L=0.4u W=3u M=4
M5 N2 VH VDD VDD pch L=3u W=3u M=8
M6 OUTP INN N2 VDD pch L=0.4u W=3u M=4
.ENDS
.SUBCKT COMPF AUX0 AUX1 DGND ENB INN INP MON0 MON1 OUT VH1 VH3 VL1 VL3 Gnd
C1 Gnd N8 0.5pF
C2 Gnd N1 0.5pF
XDTA2P_1 N3 N6 N5 N7 DGND VH3 VL3 DTA2P
XDTA2P_2 N5 N7 MON0 MON1 DGND VH3 VL3 DTA2P
XDTA2R_1 INN INP N9 N2 Gnd VH1 VL1 DTA2R
XDTA2R_2 N1 N8 AUX0 AUX1 Gnd VH1 VL1 DTA2R
XDTA2R_3 AUX0 AUX1 N3 N6 Gnd VH1 VL1 DTA2R
XDTA2R_6 N9 N2 N1 N8 Gnd VH1 VL1 DTA2R
XDTA2_1 N9 N2 AUX1 AUX0 VH1 VL1 DTA2
XLVR4_1 MON0 MON1 ENB VL3 OUT LVR4
.ENDS
.SUBCKT COMP6 AUX0F AUX0L AUX1F AUX1L DGND ENB FOUT INNF INNL INPF INPL LOUT
+ MON0F MON0L MON1F MON1L OUT RB VH1 VH2 VH3 VL1 VL2 VL3 Gnd
XCOMP5_1 AUX0L AUX1L DGND ENB INNL INPL MON0L MON1L LOUT VH1 VH2 VH3 VL1 VL2 VL3
+ Gnd COMP5
XCOMPF_1 AUX0F AUX1F DGND ENB INNF INPF MON0F MON1F FOUT VH1 VH3 VL1 VL3 Gnd
+ COMPF
XDFF_1 FOUT LOUT OUT N1 RB DFF
.ENDS
.SUBCKT DAC1 D0 D1 D2 D3 D4 IOUT VH VM
X1 D4 N20 inv1
C1 IOUT N36 1pF
C2 VH IOUT 1pF
M3 N33 VH VDD VDD pch L=3u W=3u M=1
M4 N36 VM N33 VDD pch L=1u W=3u M=1
M5 N36 N36 VSS VSS nch L=3u W=3u M=1
M6 N34 VH VDD VDD pch L=3u W=3u M=16
M7 IOUT N20 N34 VDD pch L=1u W=3u M=16
M8 IOUT D0 N39 VSS nch L=1u W=3u M=1
M9 N39 N36 VSS VSS nch L=3u W=3u M=1
M10 IOUT D1 N35 VSS nch L=1u W=3u M=2
M11 N35 N36 VSS VSS nch L=3u W=3u M=2
M12 IOUT D2 N38 VSS nch L=1u W=3u M=4
M13 N38 N36 VSS VSS nch L=3u W=3u M=4
M14 IOUT D3 N40 VSS nch L=1u W=3u M=8
M15 N40 N36 VSS VSS nch L=3u W=3u M=8
.ENDS
.SUBCKT DAC2 D0 D1 D2 D3 IOUTN IOUTP VL
M1 N68 D0 N72 VSS nch L=1u W=3u M=1
M2 N72 VL VSS VSS nch L=3u W=3u M=1
M3 N68 D1 N74 VSS nch L=1u W=3u M=2
M4 N74 VL VSS VSS nch L=3u W=3u M=2
M5 N68 D2 N69 VSS nch L=1u W=3u M=4
M6 N69 VL VSS VSS nch L=3u W=3u M=4
M7 N68 D3 N66 VSS nch L=1u W=3u M=8
M8 N66 VL VSS VSS nch L=3u W=3u M=8
M9 N75 N75 VDD VDD pch L=3u W=3u M=1
M10 N68 N68 N75 VDD pch L=1u W=3u M=1
M11 N67 N75 VDD VDD pch L=3u W=3u M=1
M12 N71 N68 N67 VDD pch L=1u W=3u M=1
M13 N71 N71 N70 VSS nch L=1u W=3u M=1
M14 N70 N70 VSS VSS nch L=3u W=3u M=1
M15 N73 N75 VDD VDD pch L=3u W=3u M=1
M16 IOUTP N68 N73 VDD pch L=1u W=3u M=1
M17 IOUTN N71 N76 VSS nch L=1u W=3u M=1
M18 N76 N70 VSS VSS nch L=3u W=3u M=1
C19 N68 VL 1pF
.ENDS
.SUBCKT SHPR1 AOUT NEG POS VH VL VM
M1 N33 VL VSS VSS nch L=3u W=3u M=2
M2 AOUT VM N34 VDD pch L=1u W=3.u M=1
M3 N34 NEG N33 VSS nch L=1u W=1.2u M=20
M4 N35 POS N33 VSS nch L=1u W=1.2u M=20
M5 AOUT N43 N23 VSS nch L=1u W=1.2u M=1
M6 N23 N30 VSS VSS nch L=1u W=1.2u M=1
M7 N43 N43 N30 VSS nch L=1u W=1.2u M=1
M8 N30 N30 VSS VSS nch L=1u W=1.2u M=1
M9 N34 VH VDD VDD pch L=3u W=3.u M=2
M10 N35 VH VDD VDD pch L=3u W=3.u M=2
M11 N43 VM N35 VDD pch L=1u W=3.u M=1
.ENDS
.SUBCKT OP1 AOUT INN INP VL
M1 N4 INP N2 VSS nch L=1u W=1.2u M=10
M2 AOUT INN N2 VSS nch L=1u W=1.2u M=10
M3 N2 VL VSS VSS nch L=3u W=3u M=2
M4 AOUT N4 VDD VDD pch L=1u W=3u M=1
M5 N4 N4 VDD VDD pch L=1u W=3u M=1
.ENDS
.SUBCKT OP1B AOUT INN INP VL VM
M1 N6 N6 VDD VDD pch L=1u W=3u M=1
M2 N4 N6 VDD VDD pch L=1u W=3u M=1
M3 N6 INP N2 VSS nch L=1u W=1.2u M=10
M4 N7 INN N2 VSS nch L=1u W=1.2u M=10
M5 N2 VL VSS VSS nch L=3u W=3u M=2
M6 N5 N1 VSS VSS nch L=1u W=3u M=1
M7 N1 N1 VSS VSS nch L=1u W=3u M=1
M8 AOUT VM N5 VSS nch L=1u W=3u M=1
M9 N7 N7 VDD VDD pch L=1u W=3u M=1
M10 N3 N7 VDD VDD pch L=1u W=3u M=1
M11 N1 VM N3 VDD pch L=1u W=3u M=1
M12 AOUT VM N4 VDD pch L=1u W=3u M=1
.ENDS
.SUBCKT OP2 AOUT INN INP VL VM
C1 N34 N2 0.2pF
M2 N35 VL VSS VSS nch L=3u W=3u M=1
M3 AOUT VM N35 VSS nch L=1u W=3u M=1
M4 N2 VDD AOUT VSS nch L=1u W=1.2u M=1
M5 N37 N34 VDD VDD pch L=1u W=3u M=1
M6 AOUT VM N37 VDD pch L=1u W=3u M=1
M7 AOUT VSS N2 VDD pch L=1u W=3u M=1
XOP1_1 N34 INP INN VL OP1
.ENDS
.SUBCKT OP3 AOUT INN INP VL VM
C1 N3 N9 0.2pF
C2 N5 N9 0.2pF
M3 N1 N5 VSS VSS nch L=3u W=3u M=1
M4 AOUT VM N1 VSS nch L=1u W=3u M=1
M5 N9 VDD AOUT VSS nch L=1u W=1.2u M=1
M6 VDD N3 N5 VSS nch L=1u W=1.2u M=1
M7 N5 VL VSS VSS nch L=3u W=3u M=1
M8 N4 N3 VDD VDD pch L=1u W=3u M=1
M9 AOUT VM N4 VDD pch L=1u W=3u M=1
M10 AOUT VSS N9 VDD pch L=1u W=3u M=1
XOP1_1 N3 INP INN VL OP1
.ENDS
.SUBCKT SW0 IN ON OUT
Xinv1_1 ON ONB inv1
M1 OUT ONB IN VDD pch L=0.4u W=1.2u M=2
M2 IN ON IN VDD pch L=0.4u W=1.2u M=1
M3 OUT ON OUT VDD pch L=0.4u W=1.2u M=1
.ENDS
.SUBCKT PH1 AIN AOUT HOLD TRK VL VM
X4 HOLD N6 inv1
C1 AOUT VSS 1pF
.ic v(WW,AOUT)=0
M2 N5 VSS AOUT VDD pch L=0.4u W=1.2u M=1
M3 N5 VDD AOUT VSS nch L=1.2u W=1.2u M=1
M4 N1 VDD N1 WW pch L=0.4u W=1.2u M=1
M5 N1 VDD N1 N4 pch L=0.4u W=1.2u M=1
M6 N1 VH VDD VDD pch L=1u W=3u M=1
XOP3_1 N4 N5 AIN VL VM OP3
XSW0_1 WW N6 N5 SW0
XSW0_2 N4 TRK WW SW0
.ENDS
.SUBCKT PH2 AIN AOUT HOLD TRK VL VM
X4 HOLD N4 inv1
C1 AOUT VSS 1pF
.ic v(WW,AOUT)=0
M2 N1 VSS AOUT VDD pch L=0.4u W=1.2u M=1
M3 N1 VDD AOUT VSS nch L=1.2u W=1.2u M=1
M4 N3 VDD N3 WW pch L=0.4u W=1.2u M=1
XOP3_1 N3 N1 AIN VL VM OP3
XSW0_1 WW N4 N1 SW0
XSW0_2 N3 TRK WW SW0
.ENDS
.SUBCKT PH3 AIN AOUT HOLD TRK VL VM
X4 HOLD N2 inv1
C1 AOUT VSS 1pF
.ic v(WW,AOUT)=0
M2 N1 VSS AOUT VDD pch L=0.4u W=1.2u M=1
M3 N1 VDD AOUT VSS nch L=1.2u W=1.2u M=1
M4 WW WW N3 VDD pch L=0.4u W=1.2u M=1
XOP3_1 N3 N1 AIN VL VM OP3
XSW0_1 WW N2 N1 SW0
XSW0_2 N3 TRK WW SW0
.ENDS
.SUBCKT OST IN MON VL VM Y
X1 MON N37 INV1S
X2 N37 Y inv4P
X3 IN INB inv1P
C1 MON VSS1 0.2pF
M2 N39 N39 VDD1 VDD1 pch L=0.4u W=3u M=1
M3 N35 N39 VDD1 VDD1 pch L=0.4u W=3u M=1
M4 N39 IN N34 VSS nch L=0.4u W=1.2u M=1
M5 VDD1 INB N34 VSS nch L=0.4u W=1.2u M=1
M6 N34 VL VSS1 VSS nch L=3u W=3u M=2
M7 N33 VL VSS1 VSS nch L=3u W=3u M=1
M8 MON VM N33 VSS nch L=1u W=3u M=1
M9 MON VM N35 VDD1 pch L=0.4u W=3u M=1
M10 MON INB VSS1 VSS nch L=1u W=1.2u M=1
.ENDS
*
* $Log: openIP.inc,v $
* Revision 1.2  2010/11/19 19:22:59  john_doty
* Added missing flip flops.
*
* Revision 1.1  2010/05/03 01:33:10  john_doty
* Open-IP models.
*
