/****************************************************************************
(c) 2006 Melanie Thielker

This file is part of libdjconsole.

libdjconsole is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

libdjconsole is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
more details.

You should have received a copy of the GNU General Public License along with
libdjconsole; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA 
****************************************************************************/

#ifndef _DELTA_H_INCLUDED
#define _DELTA_H_INCLUDED

#include <pthread.h>
#include <vector>

using namespace std;

class DeltaSpec;

class DeltaEvent
{
public:
	DeltaEvent();
	DeltaEvent(int code, int value);
	DeltaEvent(const DeltaEvent&);
	~DeltaEvent();

	DeltaEvent& operator= (const DeltaEvent&);

	int code();
	int value();

protected:
	int Code;
	int Value;
};

class Delta
{
public:
	Delta();
	~Delta();

	bool load(const char *file);
	void set(const unsigned char *data, int len);
	void inject(int code, int value);
	DeltaEvent event();

	const unsigned char *rawbits();
	int size();

protected:
	unsigned char *Buffer;
	int Length;

	vector<DeltaEvent> Events;
	vector<DeltaSpec *> Specs;

	pthread_mutex_t EventLock;
};

#endif
