/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * - Neither the name of intarsys nor the names of its contributors may be used
 *   to endorse or promote products derived from this software without specific
 *   prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package de.intarsys.tools.functor;

import java.util.HashSet;
import java.util.Set;

/**
 * Helper implementation for empty argument list.
 * 
 */
public class EmptyArgs implements IArgs {

	public void add(Object object) {
		throw new UnsupportedOperationException("can't write to EmptyArgs");
	}

	public void clear() {
		throw new UnsupportedOperationException("can't write to EmptyArgs");
	}

	public IArgs declare(String name, int index, Object value) {
		Args result = new Args();
		return result.declare(name, index, value);
	}

	public Object get(int index) {
		return null;
	}

	public Object get(int index, Object defaultValue) {
		return defaultValue;
	}

	public Object get(String name) {
		return null;
	}

	public Object get(String name, Object defaultValue) {
		return defaultValue;
	}

	public boolean isDefined(int index) {
		return false;
	}

	public boolean isDefined(String name) {
		return false;
	}

	public boolean isIndexed() {
		return false;
	}

	public boolean isNamed() {
		return false;
	}

	public Set names() {
		return new HashSet();
	}

	public void put(int index, Object value) {
		throw new UnsupportedOperationException("can't write to EmptyArgs");
	}

	public void put(String name, Object value) {
		throw new UnsupportedOperationException("can't write to EmptyArgs");
	}

	public int size() {
		return 0;
	}

	@Override
	public String toString() {
		return ArgTools.toString(this, "");
	}
}
