//start of StaticHuffman.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * StaticHuffman.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces

//import exceptions
import jp.gr.java_conf.dangan.util.lha.BadHuffmanTableException;


/**
 * ÓInt}p[eBeB֐QێB<br>
 * nt}͍ő16rbgɐB<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: StaticHuffman.java,v $
 * Revision 1.0  2002/07/24 00:00:00  dangan
 * add to version control
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.0 $
 */
public class StaticHuffman{


    //------------------------------------------------------------------
    //  class field
    //------------------------------------------------------------------
    //  public static final int LimitLen
    //------------------------------------------------------------------
    /**
     * LHADOS16bit[hgpčꂽƂɂ
     * nt}̐B
     */
    public static final int LimitLen = 16;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private StaticHuffman()
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private StaticHuffman(){  }


    //------------------------------------------------------------------
    //  shared method
    //------------------------------------------------------------------
    //  convert
    //------------------------------------------------------------------
    //  public static int[] FreqListToLenList( int[] FreqList )
    //  public static int[] FreqListToLenListOriginal( int[] FreqList )
    //  public static int[] LenListToCodeList( int[] LenList )
    //------------------------------------------------------------------
    /**
     * px\ nt}̃rbg̕\쐬B
     * 
     * @param FreqList px\
     * 
     * @return nt}̃rbg̕\
     */
    public static int[] FreqListToLenList( int[] FreqList ){
        /**
         * nt}؂\zQ
         * nt}؂ 0`FreqList.length ܂ł͑SĂtłA
         * ̃m[hԍ͕łB؂񊮐
         * TreeCount-1[gm[hƂȂB
         * NodeWeight:: ̃m[h̏d݂
         * SmallNode::  Ȏqm[h̃m[hԍ
         * LargeNode::  傫Ȏqm[h̃m[hԍ
         * TreeCount::  Lȃm[ȟ
         */
        int[] NodeWeight = new int[ FreqList.length * 2 - 1 ];
        int[] SmallNode  = new int[ FreqList.length * 2 - 1 ];
        int[] LargeNode  = new int[ FreqList.length * 2 - 1 ];
        int TreeCount    = FreqList.length;

        /**
         * nt}؂̗t̃m[hԍȏɊi[XgB
         * Leafs::     Xg{
         * LeafCount:: ť
         */
        int[] Leafs     = new int[ FreqList.length ];
        int LeafCount   = 0;

        /**
         * nt}؂̗tłȂm[h̃m[hԍ
         * ȏɊi[Xgi[B
         * Nodes::     Xg{
         * NodeCount:: tłȂm[ȟ
         */
        int[] Nodes     = new int[ FreqList.length - 1 ];
        int NodeCount   = 0;

        //؂ɗtZbgA
        //Leafsɕpx1ȏ̗t̂݃ZbgB
        for( int i = 0 ; i < FreqList.length ; i++ ){
            NodeWeight[i] = FreqList[i];

            if( 0 < FreqList[i] )
                Leafs[ LeafCount++ ] = i;
        }

        if( 2 <= LeafCount ){
            //=================================
            //nt}؂쐬
            //=================================

            //nt}؂̗tƂȂׂvf𐮗񂳂B
            StaticHuffman.MergeSort( Leafs, 0, LeafCount - 1, 
                                 FreqList, new int[ ( LeafCount / 2 ) + 1 ] );

            //tAm[h̍ŏ̂2Vm[h
            //т鎖JԂA[gm[h܂ō쐬B
            //̏ɂănt}؂B
            int LeafIndex = 0;
            int NodeIndex = 0;
            do{
                int small;
                if( NodeCount <= NodeIndex )
                    small = Leafs[ LeafIndex++ ];
                else if( LeafCount <= LeafIndex )
                    small = Nodes[ NodeIndex++ ];
                else if( NodeWeight[Leafs[LeafIndex]] <= NodeWeight[Nodes[NodeIndex]] )
                    small = Leafs[ LeafIndex++ ];
                else 
                    small = Nodes[ NodeIndex++ ];

                int large;
                if( NodeCount <= NodeIndex )
                    large = Leafs[ LeafIndex++ ];
                else if( LeafCount <= LeafIndex )
                    large = Nodes[ NodeIndex++ ];
                else if( NodeWeight[Leafs[LeafIndex]] <= NodeWeight[Nodes[NodeIndex]] )
                    large = Leafs[ LeafIndex++ ];
                else 
                    large = Nodes[ NodeIndex++ ];

                int newNode = TreeCount++;
                NodeWeight[newNode] = NodeWeight[small] + NodeWeight[large];
                SmallNode[newNode]  = small;
                LargeNode[newNode]  = large;
                Nodes[NodeCount++]  = newNode;
            }while( NodeIndex + LeafIndex < NodeCount + LeafCount - 1 );

            //============================================
            //nt}؂nt}̕\쐬B
            //============================================
            //nt}؂nt}̕px\쐬B
            int[] LenFreq = StaticHuffman.HuffmanTreeToLenFreq( SmallNode, 
                                               LargeNode, TreeCount - 1 );

            //nt}̕px畄̕\쐬B
            int[] LenList = new int[ FreqList.length ];
            LeafIndex = 0;
            for( int len = StaticHuffman.LimitLen ; 0 < len ; len-- )
                while( 0 < LenFreq[len]-- )
                    LenList[Leafs[LeafIndex++]] = len;

            return LenList;
        }else{
            return new int[ FreqList.length ];
        }
    }

    /**
     * px\ nt}̃rbg̕\쐬B
     * IWiLHAƓR[ho͂B
     * 
     * @param FreqList px\
     * 
     * @return nt}̃rbg̕\
     */
    public static int[] FreqListToLenListOriginal( int[] FreqList ){
        /**
         * nt}؂\zQ
         * nt}؂ 0`FreqList.length ܂ł͑SĂtłA
         * ̃m[hԍ͕łB؂񊮐
         * TreeCount-1[gm[hƂȂB
         * NodeWeight:: ̃m[h̏d݂
         * SmallNode::  Ȏqm[h̃m[hԍ
         * LargeNode::  傫Ȏqm[h̃m[hԍ
         * TreeCount::  Lȃm[ȟ
         */
        int[] NodeWeight = new int[ FreqList.length * 2 - 1 ];
        int[] SmallNode  = new int[ FreqList.length * 2 - 1 ];
        int[] LargeNode  = new int[ FreqList.length * 2 - 1 ];
        int TreeCount    = FreqList.length;

        /**
         * nt}؂̗t̃m[hԍȏɊi[XgB
         * Leafs::     Xg{
         * LeafCount:: ť
         */
        int[] Leafs     = new int[ FreqList.length ];
        int LeafCount   = 0;

        /**
         * nt}؂̑SẴm[h̃m[hԍ
         * ȏɊi[Xgi[B
         * q[v\[ggp邽߁AHeap[0]͎gpȂ
         * Heap::     Xg{
         * HeapLast:: Heap̍Ō̗vf
         */
        int[] Heap     = new int[ FreqList.length * 2 ];
        int HeapLast   = 0;

        //؂ɗtZbgA
        //Heapɕpx1ȏ̗t̂݃ZbgB
        for( int i = 0 ; i < FreqList.length ; i++ ){
            NodeWeight[i] = FreqList[i];

            if( 0 < FreqList[i] )
                Heap[ ++HeapLast ] = i;
        }

        if( 2 <= HeapLast ){
            //=================================
            //nt}؂쐬
            //=================================

            //nt}؂̗tƂȂׂvf𐮗񂳂B
            for( int i = HeapLast / 2 ; 1 <= i ; i-- )
                StaticHuffman.DownHeap( Heap, HeapLast, NodeWeight, i );

            //tAm[h̍ŏ̂2Vm[h
            //т鎖JԂA[gm[h܂ō쐬B
            //̏ɂănt}؂B
            do{
                int small = Heap[1];
                if( small < FreqList.length ) Leafs[LeafCount++] = small;

                Heap[1] = Heap[HeapLast--];
                StaticHuffman.DownHeap( Heap, HeapLast, NodeWeight, 1 );
                int large = Heap[1];
                if( large < FreqList.length ) Leafs[LeafCount++] = large;

                int newNode = TreeCount++;
                NodeWeight[newNode] = NodeWeight[small] + NodeWeight[large];
                SmallNode[newNode]  = small;
                LargeNode[newNode]  = large;

                Heap[1]             = newNode;
                StaticHuffman.DownHeap( Heap, HeapLast, NodeWeight, 1 );
            }while( 1 < HeapLast );

            //============================================
            //nt}؂nt}̕\쐬B
            //============================================

            //nt}؂nt}̕px\쐬B
            int[] LenFreq = StaticHuffman.HuffmanTreeToLenFreq( SmallNode, 
                                               LargeNode, TreeCount - 1 );
            //nt}̕px畄̕\쐬B
            int[] LenList = new int[ FreqList.length ];
            int LeafIndex = 0;
            for( int len = StaticHuffman.LimitLen ; 0 < len ; len-- )
                while( 0 < LenFreq[len]-- )
                    LenList[Leafs[LeafIndex++]] = len;

            return LenList;
        }else{
            return new int[ FreqList.length ];
        }
    }

    /**
     * nt}̃Xg nt}\쐬B
     * 
     * @param LenList nt}̃Xg
     * 
     * @return nt}\
     *
     * @exception BadHuffmanTableException
     *                LenListsȂ߁A
     *                nt}\oȂꍇ
     */
    public static int[] LenListToCodeList( int[] LenList )
                                        throws BadHuffmanTableException {
        //nt}̕px\
        int[] LenFreq   = new int[ StaticHuffman.LimitLen + 1 ];
        //nt}ɑΉ
        int[] CodeStart = new int[ StaticHuffman.LimitLen + 2 ];

        //nt}̕px\쐬
        for( int i = 0 ; i < LenList.length ; i++ )
            LenFreq[LenList[i]]++;

        if( LenFreq[0] < LenList.length ){

            //CodeStart[1] = 0; //Javał͕Kv̂ŃRgAEgĂB
            for( int i = 1 ; i <= StaticHuffman.LimitLen ; i++ )
                CodeStart[i + 1] = CodeStart[i] + LenFreq[i] << 1;

            if( CodeStart[ StaticHuffman.LimitLen + 1 ] != 0x20000 )
                throw new BadHuffmanTableException();

            int[] CodeList = new int[ LenList.length ];
            for( int i = 0 ; i < CodeList.length ; i++ )
                if( 0 < LenList[i] )
                    CodeList[i] = CodeStart[ LenList[i] ]++;

            return CodeList;
        }else{
            return new int[ LenList.length ];
        }
    }


    //------------------------------------------------------------------
    //  shared method
    //------------------------------------------------------------------
    //  utility for decoder
    //------------------------------------------------------------------
    //  public static short[] createTable( int[] LenList )
    //  public static short[][] createTableAndTree( int[] LenList, int TableBits )
    //------------------------------------------------------------------
    /**
     * LenList Ant}p̃e[u𐶐B<br>
     * 
     * @param LenList nt}̕\
     * 
     * @return nt}pe[uB
     * 
     * @exception BadHuffmanTableException
     *                  LenListsȂ߁A
     *                  nt}\oȂꍇ
     */
    public static short[] createTable( int[] LenList ) 
                                            throws BadHuffmanTableException {
        int[] CodeList = StaticHuffman.LenListToCodeList( LenList );            //throws BadHuffmanTableException
        int TableBits  = 0;
        int LastCode   = 0;

        for( int i = 0 ; i < LenList.length ; i++ ){
            if( TableBits <= LenList[i] ){
                TableBits = LenList[i];
                LastCode  = i;
            }
        }

        short[] Table = new short[ 1 << TableBits ];
        for( int i = 0 ; i < LenList.length ; i++ ){
            if( 0 < LenList[i] ){
                int start = CodeList[i] << ( TableBits - LenList[i] );
                int end   = ( i != LastCode 
                              ? start + ( 1 << ( TableBits - LenList[i] ) )
                              : Table.length );

                for( int j = start ; j < end ; j++ )
                    Table[j] = (short)i;
            }
        }
        return Table;
    }


    /**
     * LenList Ant}p̃e[uƖ؂𐶐B
     * e[u TableBits ̑傫Aȏ͖̕؂Ɋi[B<br>
     * ߂l new short[][]{ Table, Tree[0], Tree[1] } ƂȂB<br>
     * e[uʂ͖؂𑖍ہA̒l𓾂ꍇA
     * ͕ꂽR[hSrbg]̂łB
     * ̒lł΂ ؂𑖍邽߂ index łA
     * Tree[bit][index] ̂悤ɎgpB 
     * 
     * @param LenList   nt}̕\
     * @param TableBits nt}pe[ȗ傫B
     * 
     * @return nt}pe[uƖ؁B
     * 
     * @exception BadHuffmanTableException
     *                  LenListsȂ߁A
     *                  nt}\oȂꍇ
     */
    public static short[][] createTableAndTree( int[] LenList, int TableBits ) 
                                               throws BadHuffmanTableException {

        //------------------------------------------------------------------
        //nt}Xg nt}̃Xg𓾂B
        int[] CodeList = StaticHuffman.LenListToCodeList( LenList );            //throws BadHuffmanTableException

        //------------------------------------------------------------------
        //nt}̃Xg𑖍A
        //LastCode 𓾂B
        //܂ ؂\̂ɕKvȔzTCY𓾂邽߂̏sB
        short[] Table  = new short[ 1 << TableBits ];
        int LastCode   = 0;
        for( int i = 0 ; i < LenList.length ; i++ ){
            if( LenList[LastCode] <= LenList[i] ) LastCode = i;

            if( TableBits < LenList[i] ){
                Table[ CodeList[i] >> ( LenList[i] - TableBits ) ]++;
            }
        }

        //------------------------------------------------------------------
        //؂\̂ɕKvȔzTCY𓾁Ae[uB
        final short INIT = -1;
        int count = 0;
        for( int i = 0 ; i < Table.length ; i++ ){
            if( 0 < Table[i] ) count += Table[i] - 1;
            Table[i] = INIT;
        }
        short[] Small = new short[ count ];
        short[] Large = new short[ count ];


        //------------------------------------------------------------------
        //e[uƖ؂\B
        int avail = 0;
        for( int i = 0 ; i < LenList.length ; i++ ){
            if( 0 < LenList[i] ){
                int TreeBits  = LenList[i] - TableBits;
                if( TreeBits <= 0 ){
                    int start = CodeList[i] << ( TableBits - LenList[i] );
                    int end   = ( i != LastCode 
                                  ? start + ( 1 << ( TableBits - LenList[i] ) )
                                  : Table.length );
                    for( int j = start ; j < end ; j++ ){
                        Table[ j ] = (short)~i;
                    }
                }else{
                    int TableCode = CodeList[i] >> TreeBits;
                    int node;
                    if( Table[ TableCode ] == INIT ){
                        node = Table[ TableCode ] = (short)(avail++);
                    }else{
                        node = Table[ TableCode ];
                    }
                    for( int j = TableBits + 1 ; j < LenList[i] ; j++ ){
                        if( 0 == ( CodeList[i] & ( 1 << ( LenList[i] - j ) ) ) ){
                            if( Small[node] == 0 ) node = Small[node] = (short)(avail++);
                            else                   node = Small[node];
                        }else{
                            if( Large[node] == 0 ) node = Large[node] = (short)(avail++);
                            else                   node = Large[node];
                        }
                    }
                    if( 0 == ( CodeList[i] & 0x01 ) ) Small[node] = (short)~i;
                    else                              Large[node] = (short)~i;
                }
            }
        }
        return new short[][]{ Table, Small, Large };
    }


    //------------------------------------------------------------------
    //  local method
    //------------------------------------------------------------------
    //  stuff of converter
    //------------------------------------------------------------------
    //  private static void MergeSort( int[] array, int first, int last,
    //                                 int[] weight, int[] work )
    //  private static int[] HuffmanTreeToLenFreq( int[] SmallNode, 
    //                                     int[] LargeNode, int root )
    //  private static void internalCountLenFreq( int[] SmallNode,
    //               int[] LargeNode, int node, int len, int[] LenFreq )
    //------------------------------------------------------------------
    /**
     * }[W\[gAċA֐<br>
     * array weight̓YAarrayfirstlast̋ԓ
     * weightɕԂ悤Ƀ\[gB
     * work͂̂߂̍Ɨ̈B
     * 
     * @param array  \[gΏۂ̔z
     * @param first  \[gԂ̍ŏ
     * @param last   \[gԂ̍Ō
     * @param weight \[g̍ۂɎQƂd݂̃Xg
     * @param work   }[W\[gpƗ̈
     */
    private static void MergeSort( int[] array, 
                                   int   first, 
                                   int   last, 
                                   int[] weight, 
                                   int[] work ){
        if( first < last ){
            int middle = ( first + last ) / 2 + ( first + last ) % 2;
            //O\[g
            StaticHuffman.MergeSort( array, first, middle - 1, weight, work );
            //㔼\[g
            StaticHuffman.MergeSort( array, middle,      last, weight, work );

            //O work
            System.arraycopy( array, first, work, 0, middle - first );

            //\[gꂽO \[gꂽ㔼
            //񂵂}[WB
            int srcIndex  = middle;
            int workIndex = 0;
            int dstIndex  = first;
            while( srcIndex <= last && workIndex < middle - first )
                array[ dstIndex++ ] = 
                  ( weight[work[workIndex]] < weight[array[srcIndex]] 
                      ? work[ workIndex++ ] : array[ srcIndex++ ] );

            //workɎcvf arrayɖ߂
            if( workIndex < middle - first )
                System.arraycopy( work, workIndex, array, dstIndex,
                                  middle - first - workIndex );
        }
    }

    /**
     * heapweight̓Y
     * num*2, num*2+1̒n_Ńq[voĂ邱Ƃ
     * OƂ heap  num𒸓_Ƃq[vB<br>
     * q[v\[g̈ꕔB
     * 
     * @param heap   q[v𐶐z
     * @param size   q[ṽTCY
     * @param weight ̊ƂȂd݂̃Xg
     * @param num    쐬q[v̒_
     */
    private static void DownHeap( int[] heap, int size, int[] weight, int num ){

        int top = heap[num];
        int i;
        while( ( i = 2 * num ) <= size ){
            if( i < size && weight[heap[i]] > weight[heap[i + 1]] ) i++;
            if( weight[top] <= weight[heap[i]] ) break;

            heap[num] = heap[i];
            num = i;
        }
        heap[num] = top;
    }

    /**
     * nt}؂ nt}̕px\쐬B<br>
     * nt}؂H nt}̕px\쐬B
     * ܂A 16rbgɐ邽߂̏ōsB
     * 
     * @param SmallNode qm[h̃m[hԍ̕\
     * @param LargeNode 傫qm[h̃m[hԍ̕\
     * @param root      nt}؂̃[gm[h
     * 
     * @return nt}ő16rbgɐ
     *         nt}\
     */
    private static int[] HuffmanTreeToLenFreq( int[] SmallNode, 
                                               int[] LargeNode,
                                               int   root ){
        int[] LenFreq = new int[ StaticHuffman.LimitLen + 1 ];

        //nt}؂px\쐬
        StaticHuffman.internalHuffmanTreeToLenFreq( SmallNode, LargeNode, 
                                                   root, 0, LenFreq );

//      System.out.println( "B::StaticHuffman.HuffmanTreeToLenFreq--nt}؂nt}̃Xg擾--" );

        //ő16rbg̐ɂAC󂯂Ăꍇ
        //̕\Aʂ̃m[hʂւƈ肨낷
        //Ƃɂĕ̕\CB
        int weight = 0;
        for( int i = StaticHuffman.LimitLen ; 0 < i ; i-- )
            weight += LenFreq[i] << ( StaticHuffman.LimitLen - i );

//      System.out.println( "weight::" + weight );

        while( ( 1 << StaticHuffman.LimitLen ) < weight ){
            LenFreq[ StaticHuffman.LimitLen ]--;
            for( int i = StaticHuffman.LimitLen - 1 ; 0 < i ; i-- )
                if( 0 < LenFreq[i] ){
                    LenFreq[i]--;
                    LenFreq[i + 1] += 2;
                    break;
                }

            weight--;
        }

        return LenFreq;
    }

    /**
     * nt}ؒT\bhAċA֐B<br>
     * nt}؂TĂAnodetł
     * nꂽ̕px\XVA
     * m[hł΁AƑ傫̗
     * qm[hċAIɒTB<br>
     * 
     * @param SmallNode qm[h̃m[hԍ̕\
     * @param LargeNode 傫qm[h̃m[hԍ̕\
     * @param node      m[hԍ
     * @param len       nt}؂root̒
     * @param LenFreq   ̕px\
     */
    private static void internalHuffmanTreeToLenFreq( int[] SmallNode,
                                                      int[] LargeNode,
                                                      int   node,
                                                      int   len,
                                                      int[] LenFreq ){
        if( node < ( SmallNode.length + 1 ) / 2 ){
            //nodetȂpx\XV
            LenFreq[ ( len < StaticHuffman.LimitLen
                     ? len : StaticHuffman.LimitLen ) ]++;
        }else{
            //nodem[hȂ痼̃m[hċAIɒT
            StaticHuffman.internalHuffmanTreeToLenFreq( SmallNode, LargeNode, 
                                               SmallNode[node], len + 1, LenFreq );
            StaticHuffman.internalHuffmanTreeToLenFreq( SmallNode, LargeNode, 
                                               LargeNode[node], len + 1, LenFreq );
        }
    }

}
//end of StaticHuffman.java
