/* ----- decode/1277xint32, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_1277xint32_checksums[] = {
  "e151ed1b6c9d21ee74522212ddb88623dcbab6e220dced357339f547a99080d9",
  "42e71d92e37a5470c27cc2bcc7814c0b447cff5451d1e361fd7f9f0ba8338d90",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_1277xint32_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_1277xint32_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_1277xint32_ITEMBYTES

static void *storage_decode_1277xint32_x;
static unsigned char *test_decode_1277xint32_x;
static void *storage_decode_1277xint32_s;
static unsigned char *test_decode_1277xint32_s;
static void *storage_decode_1277xint32_x2;
static unsigned char *test_decode_1277xint32_x2;
static void *storage_decode_1277xint32_s2;
static unsigned char *test_decode_1277xint32_s2;

#define precomputed_decode_1277xint32_NUM 4

static const uint32_t precomputed_decode_1277xint32_x[precomputed_decode_1277xint32_NUM][crypto_decode_ITEMS] = {
  {3796181728,2379962077,1510737036,2163096092,3170633802,2847583424,2718607256,407072877,1432015619,1715206242,3338219547,1455041877,494367388,222290056,2031243301,2057030730,4131591166,2242611847,2718905622,988368962,3736480167,2863524122,3956121500,2297597554,3017814766,1413704968,2565765630,3078365102,1529434725,1517019883,2450882780,1820283357,895772849,236673545,121132236,1172603939,2705042420,239236381,3978421828,2346258987,3533246235,3749066498,1437201949,642179825,742720551,2726311903,2163996421,1202429082,317695462,3904780434,3433199145,3320122527,2228814935,4242918265,1753015241,3467794773,3764509826,242147741,2708971686,1262434654,2490964389,2911683316,3660033934,491246538,1290385515,3804115594,2473650873,2030776674,1816350153,3979007473,3485374697,692346302,3555432828,2179258162,3524623813,3324194892,2172072896,2901940503,627776698,524662905,368455935,2966961451,210748881,3314944371,2293535128,1339025604,3949259321,3849167592,1901294368,742719704,2522772147,2617184951,1037429418,3475725634,3757492260,4059610162,2050928723,1684815317,1828984842,3583722770,48030020,2049168717,3372702655,102525265,1111519223,3129322795,2900778249,1846478483,991982844,1277380858,3961589038,2770934774,317247148,1590645074,1640385395,1430456724,2879869536,342149558,1679945682,1851334714,2402089844,1872251915,3355661554,330215045,1338623377,1898385664,164027628,3329848436,1909158438,2470315809,1016227546,3129410220,2642245658,2733462473,463379173,1230070750,3460769658,3662389938,2185591800,2755480957,822212969,3904811449,349748731,2795158708,878594131,1132586355,632181337,4171530775,2022027776,1845367366,240855157,3442946109,32798736,1438637194,2242169023,3207827881,4274747263,2631146032,714247336,753604202,1472904274,954696125,4179227970,4006223409,2424588471,1683680634,1162581631,3678942342,382453084,1728971337,1078957331,3500438703,822158058,3410797043,1719657880,3472062776,337978183,3801220943,2843577931,3057945497,3190287532,1077495532,2217372927,989534523,4263283289,20821988,2852431557,3898634612,156202805,3198146974,3454255864,3295286397,2978657464,2143010468,2223353346,287278704,3911781624,250610133,3562970867,1610694543,2590268391,712702233,3252863626,3987771028,1159401048,3813037532,3744388445,1459907056,1157727393,3483580994,829393799,2461206259,1448767911,177102527,2887992320,3930245756,3950999427,69856397,364886818,2880666516,1144253133,1104411145,2110370066,1134576485,2568013379,3565944111,2188077321,2741060727,3044800514,2512668465,2981666348,3675094870,3970731468,3287723691,2069225859,3388105852,29635721,3024240714,558832492,287287914,4077344859,259926355,964728501,2113878818,2287874352,3804718597,1452098536,2173483396,668797148,2778517824,1688069893,4098309938,3209811533,52392537,1670448344,2446911289,2155632889,2349415765,1489062481,1997351543,2947007400,600237520,2687509140,3038723614,1167993514,1371031347,3545237683,1023807490,949570719,2046212932,1312047869,851274919,4143678149,1536595296,2170954602,704246975,862836601,1328304752,4083651735,3136269533,2268505859,3959165222,2358380543,2325562282,1940572234,1136081102,1843039277,1406940339,1118020999,2206091678,3878535248,4163666141,3889509485,3974152318,3145693589,1295561899,3509632400,211940493,1902419788,2996945896,2228811751,3932366203,4056748636,2041788698,149588572,4147079975,637747378,555690736,3440851927,1973495749,39548808,4069682427,1382688064,1774235686,501541671,1829734698,2181315139,3983644998,3800854538,2972932304,1167198940,3092320687,2620631796,3583211515,612732611,3389453503,949625079,478426408,389381071,1721148601,1202899345,1296415473,1577525376,1838453280,2664518039,3387731284,1728708348,3909846121,3842432047,4255381525,1436634656,1092473985,1409669602,1166491358,989895028,1195332399,3707124679,2636848752,481565644,588995546,665537683,3571889151,2334549367,248532371,1972438996,1920076287,567854454,2352692675,3418957578,715082511,1475536396,1068441126,2517331145,488237500,537578746,3042387394,1231546165,563023900,528159353,120648947,1053818735,73912505,4285303520,1276775713,3111048505,397595135,2045110741,755909106,3355785090,260031279,2142083220,2638540516,298245214,162426678,3143500614,4235143648,4130612585,2416318600,1515588245,2511286587,3274201490,1521548877,1740346114,1591527326,517095293,1956515356,2512927572,685230153,758473070,2886130228,240878471,4119039427,370577633,1714755179,2247734735,2871872751,1333329126,589639507,1319345138,3970431050,2900653305,1819339113,3633068788,4181474448,227974365,825591922,3798152305,1187079635,1022761733,1137614675,1248598108,3634500197,3047153582,3820189274,3068593600,3461780102,3965459903,3596300159,1155668751,2866096608,2322434073,3525696009,3696023456,2859982979,1239353111,1374620773,186085393,3507772380,3779707023,4105436847,2464474171,3377547055,3807640410,2473951457,409308060,1435563362,3619772018,444055760,3531536924,2599641974,3060166580,1682597208,2867321673,1889020973,1672196320,1809197201,3335095742,397342031,712807698,824359219,1863046,2011683368,2876345244,1220107793,3734756894,762753964,3931740005,4174155366,3815410342,2385838627,3411143325,3807269722,3936735395,1715674072,241000525,2350470398,587410016,2135834166,1997305000,3044584665,1399612845,1777497965,4238630024,2057687694,2435113974,333018472,4021699615,3290660791,4135921111,1391775990,463472949,3697516526,1964954465,52354920,400657274,1482860869,3423506069,2309341932,2230466389,2080448339,4047691985,2258163663,2772315883,1724612565,1597079572,385307018,666136745,86767371,1835145309,4016170587,1850040348,2595915025,4292927272,298210090,2428530982,3140595043,988613309,3315597969,1007524601,2334630536,3336535236,2942792977,1691321501,3981297034,3735634554,4139444313,678243303,315185762,2407315028,332447629,935455470,4218512743,2857527317,2513067940,1689388618,2919601523,3148272153,3466552877,3281500472,1982329284,2499162348,3979695137,1091308173,3086149400,2934911167,1865854269,3308517850,4293420220,1655355215,4222968150,1466522894,1532510213,2940916367,1614515744,418181543,613471406,356100159,160858176,1933510635,2136651198,2171897754,4153847953,3694657657,706739982,2161733671,2297566001,2285322889,4281548205,3103585436,3871980314,1568544572,423882106,476216988,2045019117,1639001817,3134871392,4223004488,2885436145,334696377,1850484562,2644053884,3237209768,2495183766,361154197,3920530952,631315479,1959315420,3607030508,1172773289,38654692,2220789050,3983226129,2128154713,2335735934,939083573,590471143,4143426611,2905596083,1045229603,3644425977,3805637159,3814720267,666692374,2985386150,1746806632,203668857,304703841,2781960890,4165280897,3722701073,2035812120,3957079890,3688315154,2674681814,1472220419,702937993,1131423887,432289239,2915541765,2738442873,81501883,1893650004,1744933114,1697556203,815062064,3807877437,3850263873,564000244,708110089,732240910,3543577464,4423835,341684088,3612910421,3386489277,4015751881,3807656987,3070061237,558590155,1377594340,3946497290,706790054,4190717644,3397640367,1919216944,379441306,2350567185,2198276062,764232885,3285701528,2655895826,1615067379,2188476538,53511848,3113368991,1230898923,2684079062,3504666519,2917359866,3242730759,4092451084,4134053630,673378750,3806515430,725203063,3603328740,1077577315,4178753559,2796258385,2259562925,4288317305,1767147276,3169718059,4007519494,266563989,2811323281,3157963598,2600396086,3422788334,1319504619,3510301667,83293557,2857115369,2846249929,459459675,1414545242,1724979766,2482758883,1642295507,3269033971,2372053609,3503771479,2406335069,223269677,3865638009,1955078470,2930481650,301662893,1608139120,3238107855,2914479250,599634449,2718749721,302523232,2310105997,895765888,1226278062,1515154908,3753314565,186889219,459519534,2897794960,671700247,1171754439,1110775680,4059567784,1210436050,3462242112,3091722140,3246783180,3307566875,687517838,3818562299,1118016850,1318762694,799416896,3220616827,3500143717,3842961841,3357808836,3164846681,324101734,2166199046,3160306583,1113679291,4134830744,1215891100,1948068007,2376181997,637312848,1834745685,3806937559,4025500216,1421056033,4187247201,1860905769,2562019853,951247139,1512643634,429900788,4166195049,2995734782,3690987960,3187891449,417293638,2010156035,30257122,2563326692,3650833059,2448573126,4012624872,944689275,2126314326,2734476327,3283276396,3106133441,3065852581,3805098381,921677484,119177458,3161344740,2067805039,1086061978,1641928830,1495095509,533810714,2844856476,760164377,1081284647,4017036330,919742892,4036169196,3797998379,2918868103,3552330147,2618109571,122827640,2376267018,4101016501,909646946,399462027,1363439091,962893011,2167825651,3983750244,2959662231,2764366890,1481303802,3123152919,1852311339,30315426,1630009719,233032131,1098836892,2951993338,2756961849,4209553507,4207022309,2533985725,3904995361,863449817,3049536861,3656965218,3303088244,361664294,21488095,553668124,4203252226,3606691978,3371728461,3930849654,2047963898,4024558487,3065140819,3877267054,3457176514,882904260,2737014726,2210178571,1042483732,1735069764,3172839624,2986888337,2770431852,3739614081,1738819977,2356879713,3332016102,1961457547,2877750221,3942033447,2769675064,2823840765,138907331,263059405,2697274080,4034106082,3789562436,3052372955,161694430,2371698878,4150774756,1966795802,2349374577,1295401247,3314428521,450048887,3353545783,3596012727,2667501099,3413103263,1035123115,746545782,1806673559,3623109928,2986976337,4224275098,315352462,697539956,170969636,2252564235,2858573140,611294068,3837156775,396366878,2517635804,1267160913,2086083400,895090606,2373012889,4290671111,634916553,2725018930,98813022,4036163822,260232303,834414095,409797123,3012641125,1178659431,2693200425,2671089873,887759748,1938312610,1374426230,2539859902,3108809664,3083845057,3198792463,2589767994,4053841962,972159365,27493707,2030585709,811812763,296256229,2994355724,512398408,2631253096,23666802,371017017,2454022945,2211991875,979350400,741179003,2752907237,313637276,1105265098,365332163,3812769570,2555949432,3295012473,3170084688,4251659598,2151362325,3188622389,2465903453,3959471922,3736773874,2959364614,270679059,3287959631,3838042635,3107714290,2515410503,3122169757,916795284,2125170453,3393643477,1658069443,3681874577,2716796959,3549112632,1218633896,2006424673,1760207737,2006139465,2440634155,3965061863,1516187993,3458881150,1726412635,502342434,4018264376,3131409451,3161051100,4196072270,2450532846,1957781732,2822693272,2730434769,749146764,731808104,1493789240,3926928613,2249340699,3934179962,1690050797,2751092479,252167718,401899554,2996430176,3998417385,983112053,4211221347,419220576,3489721925,3182695336,949907486,3502732674,2871166250,4220952362,440037904,1228180825,477077570,2065401649,1978003498,2455086158,1790226739,3914721006,2973905292,3503386844,3621188236,1373800204,3457174990,2790944352,2613778901,912011375,713883011,2693615841,3763979435,430882289,3751731466,2350131365,2167199778,3288513102,894039342,1595084926,4226478802,3392562840,57553006,1541192478,3210976602,2903581626,2000860309,548204707,1518037850,4233249403,4063510248,4039369266,3110676560,1290586877,762588404,2340616495,1743273901,1602155412,754376023,2413581934,1610501396,1731794203,3094735218,3511731713,1450763049,2938686608,3380236488,3958791234,762741621,2493441861,2670218783,2251966151,833232787,3831746750,572146722,4101524522,3167319642,2438843941,4043907025,2092726757,4114174524,4246801039,34050357,4152434274,932708441,2110906752,2202077018,1176981174,2119949746,3141671238,104832488,2900553158,2211338310,903320589,723272696,40357205,1063084489,332847387,2613989278,1839974366,1700880254,3607082870,723214650,1044182110,2152449168,206687923,1870981256,4048149084,798588419,2341461108,896919825,1234780519,2576265867,646557686,1782032305,123288757,2257341958,2133003296,1851454482,3755094379,2163887570,1880658372,2953524309,547178393,2168321757,1875815715,3373096048,3046222686,4210134332,426426009,3739606837,1561389331,223252857,2282837875,4119414357,519521293,4076454388,3303450793,3229932265,1146195011,788759229,3883857336,4151545691,1863115363,3230882918,3916726384,130386061,3949316714,342291090,1038327869,3536277308,383069726,2558934952,1678554832,4000975442,2052603333,3983374528,3363719109,1309149482,4168798031,3364118278,975686372,1373764684,2703188280,1826292212,3061858802,3787226083,1606751872,3718535646,1474885102,3548683503,3879933708,221484526,1913306366,3006668787,3575551822,1090917717,3349021418,2963010505,3823725364,577757118,3203286751,154185704,1153998885,3735612230,2990411713,2778732005,931653674,4018888011,4207887706,1982926310,2507094509,933240759,3808391947,2841201977,410742802,105521223,3754933645,2926200396,2192075233,200939584,899007772,118845190,268048374,4150574012,1497187229,2583623689,2880881331,1086723818,3640258913,3763018076,3787023427,3526337260,1250249529,2430951229,513747717,3814351124,2903973294,212451079,3014543007,4268081837,1948957569,401596076,615741968,2412692136,1740086729,912648237,129362371,2567430420,3329463722,2504534626,2226461789,2390582397,3066335861,322091055,723328850,2120212840,3169749988,1889152569,2501546849,2166615372,3223313833,1255093836,1783800777,2680611297,3651487796,918497456,1298026203,1275461648,2837481441,2766001285,2126922686,3711130753,1789792989,4268583901,1944773270,1428901580,1583832336,4214094432,523411245,736293599,492188177,3967031047,2814747612,2531921191,1637570664,987210756,2418587078,2802820232,3550529358,617158945,2174452804,380786035,3118572611,3399256056,1567513787,3267332154,3634565356,3715273185,3082952580,37706409,1226663945,2976801234,2075238341,695161817,1701772057,2490365396,2795333729,3329944004,3034081999,3815986183,229983065,2529818125,4069712306,1574114011,201687434,3947706908,3510020855,3401195930,3633475795,1030070469,1091711950,2949636033,3533121477,319500986,637848769,2070226210,3228941553,3130224083},
  {3430971708,2519854573,1038518366,2518441110,1013841342,1711621881,81671653,2484598601,4145905352,1374705893,4268066808,1173285422,3338256203,1639898259,3898735101,3375246113,428245053,603653470,1773126887,980601149,3933507144,3865694790,82505921,213277082,890667932,2787179773,3161989275,3892814296,2386282630,3933276364,3294027711,2252048759,2047831329,3854581595,3087264436,4084252343,3565607446,3865273870,280466331,1984600782,1132961170,1260617478,1029646700,3622363676,3896760198,683090286,154028568,519611923,1417447803,2153625398,1618393999,4195274559,1485647939,1038679576,2307592100,3609337747,43140781,2203968620,305517139,2495879412,386167386,3663343390,970754773,2526389664,3073807020,3541899748,817866868,3089313052,3183731315,1855774229,3706766405,2851228910,1671049797,155512786,2898748573,2481831244,1415623448,721513222,1016499051,926501061,1143441854,3113884192,676276121,1799596254,2112082689,132916471,1311543279,1768618722,1607973304,1497906444,3068941710,3178649411,1536622945,953261620,306630483,1418486908,4229471872,4019103993,3915954437,2830210122,41797204,1982053628,3454337999,493642596,2282912038,1317714593,165240170,919187169,4235360848,657721554,3148742920,389216591,127545550,47698338,4151662174,3819642014,617824127,540572713,670230448,1637027083,1632803343,166976458,2477002813,2398067059,4099498641,2712059117,3584453990,1022073522,1715480966,2911234287,2506137080,2992909224,126620305,1018325455,4068541223,1996857854,3651256858,2582168430,2101341232,2724507491,3980973389,1943537903,805339847,102010605,2384383906,1614715585,3337656274,2825311873,4080031183,2619008727,1631883283,4099755393,1919922176,2114745573,3208917944,4250893817,1453419674,2582007505,3539763560,1549674364,1869080824,270072495,4146813228,817002479,4092480354,910681237,3845799960,1981061254,3637029813,3240945954,412039052,1338098809,3877020900,353913327,2908922267,1165810826,3714366330,2915219567,3935066835,3335659635,1806369080,1368466719,3380299184,3562816309,2015975759,3639457733,4169936938,3605496362,916207222,3560299068,1067321205,2817322344,3955785195,913916848,3582293904,1610366826,1874613281,959697327,3416192159,299230370,1665593796,3162013844,679621731,1326055979,521999820,2149173739,3049615225,3985288103,3927750359,3246816059,4229759824,2431697091,2539226029,2711446606,2465987517,2526540155,262365949,3552670494,1288294050,2373415670,4069350530,2153295962,4113319208,2944514369,1580177917,2192768720,1707000668,1486714757,2552024281,3717717395,2117577815,1105849800,995890463,1444392917,1349567926,2191534615,2807288418,132495662,2797430980,2177761729,3739760335,3963956502,3943307164,3662892429,2389625092,2519347512,2764443773,2127252649,3863690837,368831688,3674748804,1658877957,1256041091,962140037,3960218318,2258229533,4213891843,2613957643,216276907,2308047560,4109256753,2455677429,2328444060,706495005,1112500502,1436211680,3732878181,2363458406,2026608126,167439818,4012361755,3668385344,4229465008,2361048022,4269004116,2209267425,3400065789,1190528721,568160224,4015090882,2063501474,1294071020,2041817754,1557909853,3038205483,4234143358,3643770282,925037062,2987218042,3016416541,298849447,3127755621,2902171998,3920889591,147352533,2950995775,3354625222,2443094540,3251567413,3786488201,3315793908,3107975753,582539559,1354254292,407728262,3946576355,1568434632,2334418950,3638820909,2386016309,1852427057,1917184257,2741002682,4275118621,1553098493,764626429,2744127338,1851922934,3565558756,372862576,2954804192,1428854912,3392156382,914517616,2997313505,1613785482,3137830135,977868026,595942170,2863098249,3313084407,2628181572,1816209224,842702779,2432461071,1672922657,3728503699,451500216,3854404432,3824362232,2835050645,2582884324,2139023832,2550050243,435140000,1040418807,3789971418,423391309,3578105312,229717847,3936782882,4024624667,446073680,70710304,1524484575,3238889819,300608658,1185145333,1844294352,2796325249,158498678,2111898675,2316780350,336982436,1098024143,2256560990,3032978373,3295588939,2139651771,139113658,556093165,3190640255,176755289,512229105,3730956092,2574350344,4079517055,191878501,1169368448,3948329613,2622010308,308118464,3449416459,159916867,877136564,2723920078,754928269,1400317587,830607524,2556097465,3303384315,2097709619,4187390029,3727658080,2460931020,2267151639,958515056,3658725434,2942427285,3238797111,2431642154,2370255421,4132725038,2663627881,412300720,1642773269,2871933903,1475267797,194742965,1144611787,1357790982,711141522,202834173,3309354486,2954632893,3202314422,1978011226,3552461449,2739721111,551140614,4258529099,979234867,1886748952,3290018526,3616680644,327904855,1262210793,1937051822,3535561077,1526548074,4012951009,2646683085,3140410452,906922034,717376693,270735612,2990649635,3138966746,520318805,3131176154,3704804429,4246146029,971337078,3002020325,1520076572,3023756707,846812528,865823932,3841749283,1028759663,1490948867,1805964129,3388078647,3761491210,2973547381,4093977622,83625712,1547141187,2647127320,492012236,2545901226,2576598301,808911313,1589438567,3458255853,1545281865,188998665,690273498,2756352422,3896854510,221450855,1921675502,2863969380,3264446652,927248933,3254089484,801395441,4126532443,1845222537,1144141875,3526905097,614954290,2302273396,1081972285,3872688080,1141758753,1234361777,2442003790,832944551,1586553750,1050161851,1474242275,3789248595,388656446,1888863296,2942779517,3858945961,1818660524,2913927686,15626296,2652457317,3418620685,950166257,399430563,2663152132,927836424,3757381680,920555584,2835967736,3308615961,2137327957,112394493,1087129912,4235077745,3515460558,3342074238,1556453661,3669958474,1134092033,343447556,699260862,685269144,3237126571,2384772294,670652131,3412786559,2756798957,298949087,1537001510,2144542505,566802147,4260424638,2867297806,1673534782,1079021423,3182489980,1734700531,3864387324,1557839269,2919923514,3694383688,422423998,1612280837,1554941106,2244020981,1968751610,4268568299,40470598,355060425,1653283883,4182854203,1861676857,983316906,1989460923,1474018113,3107291730,2983774243,2848193209,43152255,1439225410,2762921481,2589443398,3167598292,3290472214,1158487723,549156674,3443797764,1696220883,840884052,2856436563,2739474447,1479911563,3109902243,505999423,2639561457,310102826,4003612600,1462544814,2835370998,2058944179,2948162175,535943439,3161889855,3898414477,189833036,1535371621,3910736245,1827953693,807041080,3665578011,2288117653,1179443451,906550240,2482301837,2836791148,1842665906,1659852338,3478747546,150490546,3426697033,3090195150,1567626479,2753492301,2506467814,2097927817,1110054117,2234182863,1270300910,3535679847,1478852600,3323805205,1846805041,2652183765,2763441258,1760783268,2010406105,1986050615,2856317835,398381366,3587655169,1000393164,3650441133,3366463583,740796976,463467295,3547788049,2214167552,51867948,1492068651,1173041505,3076253609,230472487,2302672855,903273183,1226990359,1533993450,2034799571,103376288,2078839085,915845718,4047181946,423943666,4287831361,2723117666,3958446342,682465521,1083465463,878704466,1973532121,641983078,1558422863,9138711,1933884585,3610743841,4241298287,210487035,244393784,2100878953,1973683499,931309395,453504975,3578618614,1943290408,2605009162,626615765,2830277254,1741321616,4111382417,2359571410,1503428682,512496978,3791026338,119385904,291971935,147601267,3107759700,287773430,2368751073,2091179716,1864117103,3896503558,4154440233,2935288458,3987248469,398993808,1886685027,3700954322,2808511635,1449478728,3600398207,1509403586,2735216882,2827285701,1959074862,944744273,3812921745,1295925714,571948870,2061615223,2650138431,292543294,1404519503,391114539,864905770,825528577,754933703,1817615555,2690691178,380780449,1453534837,1538576122,1879232593,3929465799,18995997,2468873962,1567904187,1668467269,26613637,1447197605,2471187823,2137632906,3514472444,1119625799,424171153,713323420,1623353937,1368848846,863694781,1538027597,3404215087,189838488,3225239373,2080582066,1974829568,2735464009,1601770306,2467382409,1729744387,2602607864,3446095168,258766864,1405258027,281842121,2497770173,1821486272,485661200,2626136691,1811654673,3722771059,95035830,1352510841,420982156,190355595,660579364,3841708412,4011972289,1430877551,3903840044,3567924786,3769524672,2479135836,3294440421,518675782,2661151059,1144584834,2578986937,3473894740,2409991301,3025072243,1756517133,2366901847,1840375168,1523470255,2519252050,2176010588,2043680343,1322818388,564658672,545084893,2810436410,1330578101,4114704648,367006887,1116085977,2102854224,2103402110,3466516879,4018092925,52344709,1344330813,554508353,4103650629,1108663664,3076175138,1321989543,2417807896,549640904,3920113317,3253331542,2913420847,3171480782,185529576,1437653779,670262310,1886876992,3696276206,1160449613,2838316455,3270366040,3541213181,4214929768,1085528211,3488649875,408469870,2483267514,449387201,44258337,3108615393,3676098076,1396227723,1314050888,3415721661,3904674696,54096283,2348471275,1899200701,3189997780,1937370650,405175869,2556214651,3282208315,3517363289,4103304515,231422638,1181536226,3797681802,1581608043,3419314040,1751744841,3948101029,3471899064,1678839680,1104739322,684894220,3324481717,259414057,1609694255,3946725110,1892300534,4287744980,2898797357,2035521409,3285983798,875777369,2357794557,534774755,3129558221,2440918887,754354756,3367591601,1450229964,2865602963,2724335228,388924497,1000770558,1299189604,1603179376,4149319952,3780358322,608998118,2783393042,2849183528,589138127,1086602159,1971774046,3913061717,1997030457,4011066652,770987872,4176253073,85626452,2893558652,2653963145,1398021252,181013250,96277043,1342232621,666315751,4071250259,4114325872,441390171,1880234352,1745424045,158737675,2984084971,1330658091,430197710,2392791329,3021528963,68726523,1287424984,2885324799,1393412451,955931901,1639258062,4158788154,1744219677,2451052382,2777669773,109053403,719839567,609330380,2934790175,1226574336,3717091618,2368953133,974040608,17825171,2165764796,1437467722,2026658351,905038622,2620820180,2223084065,1483142887,3903947598,1446316363,31333745,2942983109,3581656170,3046503852,2649785670,3050677493,2358978198,4095104313,4179063454,3164836025,592136296,1181804009,2878067491,1395072439,2077461609,2166658597,114894022,1842943406,1437137779,1876756792,3730163940,4114525035,569067684,1033499432,3631235945,3770737294,2476592229,3270023272,4238758162,944015213,153745215,165612263,1174575197,597926207,2613320801,1358238980,3237032501,3751224824,3672996696,1870568208,2869740335,2984814848,3571623108,3205187525,3496390539,1339408570,667243384,34913585,1058924003,3283149923,3325550942,3628912598,2711131678,1581342742,36776924,2282554442,3846108247,76283772,1790149465,946673728,1912335795,3323248494,3758823039,3049796606,3600061090,171779895,3833785642,1655800088,1702114342,3470947076,778442803,1616417370,3000309219,3813109118,3322593170,487151647,3720861527,1024624530,1588437802,4069002049,4044430637,1647061280,441759878,1336773959,1955140912,3275681061,735646709,1325485933,2216334174,3203019434,2075374014,136480455,1026439488,1003384027,466949944,3511017089,1671777027,3706105519,1481060150,926980244,1410853881,1500058783,2565924758,3031285454,546143155,2006961631,4072666335,1425979152,2639209888,3204196625,1672486952,1183821371,1446560723,3329293514,1143434730,3569247423,1493831361,190987442,1850154799,2126476436,2957170923,4278569760,1167478137,3961056002,1074422070,3086293287,3932172619,116719152,3241124145,962901101,2762934292,4126747631,1709410533,2545241130,929042903,425248727,3116327511,4244026783,1211091525,1210757030,1758615479,3359816347,2624140011,3742018609,3987284242,3586982141,1874836594,2668354279,2136681567,1522316681,2089899348,2814329990,1796419369,3625079451,4083216258,3301299959,2509937345,2767561774,3080274028,1407721573,3559100148,253207824,1353972944,3749751492,1325986927,193051874,3951789635,2340963352,737176844,2634173671,499457989,3830486966,35973163,2543463632,1541427221,804214228,4148132532,743813712,317104021,3585978830,3537754374,213278203,2301441882,3776514175,900421948,983767885,1464374547,207788460,3376726115,1933169421,2297232031,2101491274,2848419750,3861284507,2858542108,646558480,2830713945,3540548857,442609347,1979142271,190010918,3163658432,3343882114,226448581,1558764617,3790032208,2142522487,4103901480,1507933699,3618564438,2171369197,1949066657,3642569808,1443257011,117244617,2540689788,946760713,1595206580,1126922217,135654864,2920641572,2235619422,1619517028,1612201041,981369603,2579365193,3655439435,3930307783,686049493,1188415508,52566662,680625364,3385377408,310004870,1408912738,3315933865,415607526,4147609554,365187163,55976774,673193143,720966496,3838477447,1814307643,3548598957,3969220369,4270102542,1753100320,3396827774,3090999798,3507942126,1771241739,138682118,3364616194,3102638750,1748375766,1597897375,1960347260,1687894734,2418949616,2967259763,386202663,1666877969,2728642691,2713067750,2832726200,1585546768,1524489650,3017120570,1045056747,1374496769,4080022261,2385084165,362925037,4204937575,134050597,2422308981,3106436201,2043571392,1925399466,1963854883,1622859331,3369058089,212746578,2111111690,4288736498,3427940774,1373804991,2007232485,1020230362,2011824058,1301435658,1167306909,2254316657,1366461329,3703348571,3877041521,178086957,3829743491,1491014230,2831267781,131857958,2415799598,780820301,3063209800,1372843965,3911720632,651304127,1262488402,1537951468,2871014669,1708882297,1705750426,1109585020,3207638245,624923327,4175522467,2576369291,3152934724,2219340855,2677593858,3697016266,4208569586,4153807029,292155887,2199610989,1920460554,437646854,614239335,1628920849,4076242204,598300616,3585564767,3097839535,988726156,406768519,3260058612,4191496560,3405950448,2563821072,2429928867,3603389670,406627883,1316985033,3479977856,4255864357,1361280516,2338363466,432926371,3382294743},
  {1480138674,347268812,362067483,989417034,1669174106,3049791451,1560934511,1915385187,880978516,340734446,2047750291,4111950362,2050670572,598129817,932001588,2748648747,1916863205,3689176989,2847746793,3843661662,2234099119,3366537087,322729273,1654151484,3994999572,2924904640,845959576,590268872,2496590091,1523612689,1323322757,2903384267,2708623673,3125623592,457726763,3731724389,663289408,827326740,1829105454,2041008192,1545938109,1936485635,4185387054,2097995735,4010832292,633993755,1710224260,2385713956,3909373866,947845745,4119592341,2131005751,1586481026,1138871692,3585731213,264428076,2123293623,2099305899,308598554,46017327,1436352084,3525266733,2296427102,2739850411,1425787749,1942365492,1399408931,2056277835,3959932878,1470955690,3518552542,3520779848,675001369,1749389516,4167800602,3818330855,3397543646,1138949035,3670336962,2935050115,2363569699,738701115,678309054,269649758,1652397258,1728197508,3280709078,1969711033,682188642,2998163278,1546997219,1739644603,1144977324,1714725589,2701033521,1494997304,1447114965,3759136261,3871709527,1585030696,3227449220,3041976263,4033952839,282811217,1381692648,2234578937,1968866241,2514400537,3735199595,3493642865,963550647,2745368418,662693453,1613456771,3497039091,382187994,4258157360,2653158275,2276489491,2075403466,1949225794,685043503,4004899997,2898362200,1559588308,2868519639,1466165772,3659475173,4053115827,3509725674,2124680672,2681312705,2629358706,3808520735,613127485,2331750056,2356260547,2859609073,3560061907,2847213647,3845213177,2140358372,3244662739,2667245840,1654844302,3593171146,1548605497,3110633939,1826472263,2392058061,3293162845,3339504762,3204090937,894251600,3324000284,1805959427,42245057,1942688605,2562560263,3313275931,4111072637,1415017404,2203753134,996586780,2083249757,72634198,1235173325,2276868745,3738132147,2003203415,2333333242,495003490,76640,647109821,3623267447,1761821759,3330515057,3514020081,1530952671,3751447757,1177790950,932777133,3875106448,96501375,4036329000,2498236232,3419200599,2147700787,1734608639,1178355201,1738119805,892429288,1900955375,485930658,2566178353,3777241731,2967433037,2148063899,3316895621,2039563510,1289340165,4090255965,886853381,3164259679,1956375188,2495391619,3168095589,4240362964,1322663933,4217697861,563081400,1421773204,2577984242,4171903838,1448398187,3227051349,2062898857,2749660055,3314905014,721453389,1433363703,3514916098,3157398105,1028322109,2544306439,2177710411,4034022909,359716163,224692362,3359760499,238644029,520565102,110158306,1213654198,3836842086,1327827055,4165969489,1745377987,3781244444,2855465502,1099913156,2172767174,2125053064,4246242052,2683175416,4141875452,2846798155,2264305583,1217342669,2249614359,2073916154,3896053994,4021260931,2310458403,3678946989,591173327,1616075042,3711376489,315251256,797917505,2885670733,184980594,999546232,3645452733,131852621,3638053247,3723173601,1432714967,575943567,1998032686,1912733601,2381857839,2188386848,2608387914,269140899,272490902,1530653972,857911686,3456463911,2788078602,4137704030,1853042304,4064911628,2135057972,134421295,3161229376,768114218,3279371610,3796630984,1314767986,1350837222,3468268964,4051836832,2560138870,2072545869,2325522871,346602379,1920838815,1273721927,317634774,1645640851,587221605,3635944382,3334491650,3922557951,3981495888,479767277,3766059135,1975980872,2935181652,2137847700,1981808616,3796344673,3360856050,1475256584,1533760774,3531550446,3663388817,1870940252,1257231280,4070049134,686374766,2318585290,3219394517,1729974545,2139667260,3027177957,3403177467,404582185,1418369429,3991549462,3709581380,1738951548,3578472064,2583313284,12772384,3745687939,2944169815,1995507376,1454449075,2423550252,4188131216,1612586097,1986955962,2898165722,1890426725,1758189559,2035154338,896960897,2410132217,591839241,2161374157,4014599131,3485227733,2342861154,2946840850,3595209427,1975699656,3986221214,3608989390,1522631855,4160748307,2418165341,4255775670,1687500758,357816612,667057840,3108161805,1188793609,343863290,418882019,3346436217,2216753162,195805613,518954407,3627277126,2705126679,4277330130,2514220425,1099871612,3965313232,1156250023,1085218627,3098551161,3797433017,2812801045,2027851245,3863949598,2110022103,1427405113,1814484513,600960946,15901017,862267533,175947978,2147077360,940587789,2225139168,994443646,223260188,249593879,4293251126,1921385963,3274911440,1262283025,1138990022,2595987588,1863589200,1709860745,1954900419,1964982671,3211239401,1557156768,1000893296,773130305,3390955353,1349804552,831024977,1373318343,1980179719,3318582898,650230420,3888734653,1848398605,125899173,179529707,2211567268,4204313827,3641355396,3747352155,2473398111,2022924782,1269733603,3936953785,1405895752,1599138942,2862136579,2616029096,230842950,143905574,2049947567,2940043388,820797900,2873174401,1650257220,110680680,3918650472,4195450033,2046304911,2244479868,304317813,2041722704,1182689083,3179868588,2477123305,283043727,3623453258,2235760167,515749121,358712587,478048191,3401276194,2517125123,1207156579,3231208818,1628128904,2739222651,1930556493,1123603412,866327796,2591328915,2194753308,2335582164,1370559180,3604720294,1067406419,517100580,457422276,3409683274,3123581123,2358146700,3923940411,3494700749,2760882246,544516876,123377826,476756668,2765840025,3263725953,1500405284,3424768029,548090601,4181973060,4270913057,701485029,3821435327,315071934,1330622867,3295727010,888281906,2802757219,3308356433,1043354525,2413631586,2931448830,37198712,969496420,1864050943,2880446503,1576002770,3742807000,3185844186,637552951,4053163014,383742242,1289717333,4260326938,3227445340,1680189949,1929408527,3981097434,2752133352,193150147,2779636754,1672518872,2337765682,849954292,3297248163,4100435480,1688607206,1234812252,1692333734,864204098,3963485381,1368567351,2661610365,3769142121,2366491768,3696711190,145926569,977705186,3965936650,1394044244,252108377,1854493216,1293184290,2139899507,2400967516,3147249724,2372881253,3278440370,2423931423,1459359693,1093652182,376789518,2753342460,1468985281,3106130379,5783100,437568097,1064977867,132927723,3747224937,1042295953,3022912037,1563853374,2552042675,1994470395,928449850,3045751941,12578588,2985262233,761174230,3630394321,1590626364,2460945383,2449362862,898796601,2463354002,2721433432,3005119853,969303434,3841769689,3651974002,1275987032,890530371,1886192343,3001567866,2463112279,345786752,1187558355,1256258945,1333380621,2391272816,3828398909,3269467685,4293843591,3963856920,1674509818,3337556804,1498534357,3497862998,85630666,1074911655,1791488179,422368354,469498587,4092646487,2617302640,1674019977,3312838753,3678631109,4241621872,3123199014,3065288923,91402446,2471542686,3049491186,1105566468,414553438,4148154100,2322680307,1721507972,2856735518,2950584096,1066442198,2166300812,3450821757,3727127670,2177918574,3612357918,4188344823,1234244430,210127284,2844051525,1235434856,2554760000,2736218413,621312756,4291796547,1187942412,1602537351,4046959831,2230330210,4122910104,4224616656,1924604130,2339932609,295659062,3924640108,12619868,2060619921,4075386547,2704569756,3740724455,1026527703,4276438577,2262726475,624355493,3857294171,2448750003,2376333082,4026055784,3536877646,1806248238,1672031262,3058299120,1076290384,2098487620,859332432,3736147131,3004382717,1772758847,2645293004,2314978917,1476178265,105988821,2970917526,1092238271,3376980743,2198039142,1654432964,807534921,717465095,8654454,3317654855,1470588976,1011489786,506447031,312327350,3719701306,614616342,2628917985,2392988314,3825915398,3897716677,1671322279,4239977488,3413510214,747827556,2915741938,4167493919,1322459003,3284822524,3212786922,2275694922,3630738991,1208825694,964058868,1331183717,3674210822,3182493452,2112174887,2456087707,2360977867,341830770,4070616111,1142001509,3364512739,1025681745,1922603861,319512946,3855522636,2502914965,3870885149,538386295,1302007920,1619176873,1584251513,349790465,835357692,553094657,2799229844,3666297969,479310578,2489540513,1678667528,2806788064,2048636189,130877592,3178710252,2553286542,746481855,623444079,3063144231,2824424787,3665415635,2761892306,1733902538,1180367342,1359505310,1166874216,2084082434,1010002288,2485704588,2448004883,3781345118,544291167,878111988,2411147615,2386312531,2942583606,945096199,2079750842,2224511615,816361726,3014138725,3643838703,247392099,1048930020,3427394831,4281523244,761640885,919860524,182151474,3843327087,2924130019,4194001330,3379870261,4237813314,1400162244,3456945025,120585442,2838893500,4206397233,4068731384,485896638,3794894664,99349938,36560822,3000366114,2452963182,2472946798,2577367931,147626675,4250750245,561764967,3618349754,1475437731,2495143462,1805377722,754710550,3514361329,352406187,4009889862,3788144432,1915308586,907917335,2511595111,2778052829,3773004837,279471141,4039114541,3991013255,2104328117,224592111,3736508587,2172986974,1526612914,489100041,97054173,1176111876,1578727853,124062001,4210562807,645771797,1256331348,3735061864,811075282,3571699485,870612686,1514310950,3570914893,1588097180,3431269822,1843313318,4288084235,1297798705,2731768518,897897004,1505777708,487359802,4292045224,1356209752,2103630661,14711295,3198302183,1392873832,1399374453,2060881839,2138782607,1686456941,217439397,218409723,201233547,88264749,1074443550,1596077845,3611077517,613551078,512908356,641524843,1940114314,297659994,2059352948,4075626549,2709203742,3550675250,553113441,3753686806,4059408700,1626204333,3383765607,3897276788,85024919,1235737384,2128161281,580386525,4148061755,1983252533,2568609633,1950895610,1392010652,2160314823,4012999964,1321408353,2778067830,4136152004,3866124611,3119261487,2646033016,601249811,695113708,1279929591,958230240,2869439129,3110984849,3791568838,352282882,2348701369,1072153556,2901822006,2824274956,742608258,3051510940,994289446,457848302,1052196197,1614913445,1659159229,3278577718,1184482017,2437645755,2922608473,3383837898,620383339,3994711782,2270662795,2883335464,448082903,2487750676,1741387876,3441319547,1874924230,1693375234,4094761580,3968525905,3600489144,4062976298,1903763678,1927097376,2523216310,275928957,1862256569,2338335547,53940260,2765816345,1444646580,66235010,4089182937,2162416079,3242317176,671309010,2596739008,2450015464,2099994366,2881426049,3422141186,671304849,2398109,3455166289,484015694,3438902533,2094873428,2374290879,840739681,4270672696,2208929149,126317559,1052104387,3034893503,232552617,3838900580,95920068,621559689,1660568414,2383892172,2652203713,740266886,1153495354,3321771127,2701779256,912467266,694935341,1235828539,1858346939,2044801812,466362892,2625634337,322853674,3477750004,670639252,991990911,2877891066,3329034081,1859170156,1829480758,638178738,864182849,3994317672,1845290101,2498416137,281914739,4077983403,4032964554,2556543134,1587141083,3101038148,3670823518,375054631,3237298430,2919256230,1761043876,117299628,1668449624,1424167195,2327557675,1653414924,4163160963,3495222604,3290993362,3789201961,2872594403,1246149373,2086722005,100156955,3819273041,1348813092,3320823874,1320931708,1924030198,1292204518,2652316062,4163206379,1710659679,1385398535,229955407,3335889652,2071576477,507208240,1036344604,609710555,1684649288,1510196713,2209533344,2202924661,1543502252,3727138458,312290215,1940521874,678104486,2311606058,973486710,3041049647,698746812,2471052050,4133236960,2420293235,387465308,4052434922,1881610420,2871009099,2294189142,4246032285,16042862,3498626197,3386311475,703552895,3596764392,1944589924,3434163274,282338347,1010138758,3729918297,2838832317,3336303638,760095364,4224686242,3597061523,3205755386,4243664412,941094130,1385156649,4165251036,936607607,3866943064,3963344300,3042855772,2738964411,2225263502,3334913933,888519811,83778824,3077906340,3071718908,3742700307,1691699758,1799702897,2864250181,2287910672,1600667957,3188654440,2897793386,3243768144,2715820006,2610479879,3605982265,2328352359,3183284817,279701595,2914043637,2691606130,1485968487,3223467002,3864606498,3828328699,3268960261,3290059107,2077103266,4198987194,4080410063,3410526682,2095174409,3383744121,1444578353,3537138648,295377318,203917145,3437432088,390049958,4250919193,309149941,1073889829,3761999553,2475309577,3361761023,1867790645,3913161853,1696728419,3532900826,3489529941,1528814874,2977858678,786530173,1901638867,3930267812,1991326205,2896618385,230558563,2512975327,801174772,119336125,2268382295,2340724535,2626420735,2143058736,3345677472,3670642497,1821301976,3487836145,1773992352,3469198596,3525292911,2254003691,4201252913,4262379921,1641768473,976672921,2637050270,109624782,858898884,4248427266,474670240,974247267,539298157,1735625642,2988356566,226163700,428337253,3499494136,1288963272,2362814755,889451334,519977651,787646452,3910335067,1511255390,1835558664,2645196937,1496301781,3485814832,4119634423,3968061419,863933590,2329992372,1580465881,1016918205,167924518,201937934,2474374958,937921730,3598314427,2683230240,2103829527,1066811023,286709848,3751864765,3439329511,1217334516,2594408887,1947521196,3855931834,1651561317,1499012901,1599921738,40378508,709180713,2017032586,2418214788,2712433920,1160939146,4205522203,4238265764,892075782,183293489,3395947541,3755127920,2000239710,2645993340,3137773534,1115013421,4226000207,456697390,3434608226,1246651759,577428578,968257093,3537292764,3041747314,4140116489,3421261317,1678006819,3733103695,491560467,1319786215,647313692,2480493614,1826475497,2714976303,2199619443,426982940,1863866723,1459226410,111404117,2345631576,2381870259,4178998184,133935781,1889141977,3551259221,3735056842,2735700289,109631480,844288405,308314916,840217309,379467627,4172989671,943636583,247601033,4273221791,4193879140,2118751921,3671312309,3189604343,4211005008,1699141471,3918456638,465215170,3910994166,847893275,2606598799,474997864,1449775254,1327330194,1503478424,2777965743},
  {3233531611,4048831167,2987791068,3987118525,2994463678,3474976535,2127741371,1018081595,3233881563,370747183,1374243894,3170930689,3643702237,130792918,148294446,3144174243,2143746109,3200709991,313928865,3660112722,3676377510,281364994,1578415407,1439512263,1919954363,4018223849,1491805827,994001196,4060283352,2456936490,196114376,521665488,1566668279,894968639,768432373,987270686,2003139446,909568388,53089237,4049247713,3776571925,3657867938,966980624,2756924879,1968166236,969334446,2016931889,123722754,3365693725,1498335791,2283445003,2756454298,3317879242,460902273,112285920,4103815786,407802295,598613900,1784562550,616771536,1463664770,1338630436,2419755623,1365822951,4285443385,468471363,696070246,16450824,3507017581,2077297149,515689186,1487244503,940460287,1401370349,4039557976,174761985,185756487,3900837283,2425516780,798644227,4251161845,2812749926,482926711,1880490459,521414487,2861537639,3721740406,359273626,620705711,2971288914,1952648312,968163325,1181470657,2028951836,2545875041,1947303729,3666715932,2292588468,1424165086,3045421658,1631451127,2739397775,1579118637,2417416747,3187888096,496163235,1294567525,2672154271,1996004198,150911226,709400605,2129726250,1513505569,3445765349,1389397368,1010169604,876372344,304575193,234220916,3098342888,2049589822,861767998,87073658,1304060793,2343097670,1421514403,2604199825,972801358,3404350627,3217417013,2280378639,411155941,1182404736,896643718,3176925715,3241936704,3215776554,1218970468,1085133749,2114706409,2690202676,358214403,1541526501,3137256364,1752794930,4221038699,4236383391,2967249843,2730912434,628286893,929060550,2263324171,1405193271,2453859510,3601486914,4140420203,2832048386,2089199211,3391539355,50658265,3906785098,1960617942,945627084,2733968599,3398981923,2176299883,525964166,1928516683,2018506959,1349831070,1570748095,2395245630,916217380,2559394676,809072532,560013621,1150504060,3033429186,182920609,670253072,4133253286,2506767439,3838058465,2177900413,2782897869,539723356,725933284,1654789792,2916821413,2059583275,757269188,3044926683,2403347708,108693490,1995298329,1214645533,1834551308,1809943315,1014851263,658960503,3024520476,2896740789,2131201439,837985857,340684247,76287384,2902461232,303065216,2479423507,2077117714,4206119547,760311448,1801934915,1125127036,3690085203,3346131036,457158568,742505855,996819054,3216327244,1460705215,2867465854,274100264,861056412,3002233974,2113035995,2496145754,4035167984,3270399734,4153983691,2224582185,3003781925,1748680572,3245646874,512981521,871740282,1863332385,1554106820,236666973,2555548158,950571856,1677055928,901044090,3269282146,582413936,187497022,754560592,4054077874,354239223,3760078034,3092937880,3349776486,2318515863,2287824591,2149196087,1729932502,549759099,3634898937,2638825563,1512662631,968034020,1546090060,3891240585,4170570760,1424814063,1351974072,1458799566,2943051228,3302633065,3455069191,3680307035,379483354,2252584776,217522408,1760106120,648793819,4112572659,3692712333,529784159,540882399,464430699,1399671760,285389787,2674610325,3360294127,2695773202,2962196415,494727328,3929978965,1980933008,3953677663,955259206,2648107856,2135281355,1527568190,675524121,466367249,2108083217,542721289,3972282810,165748122,178979644,1118870540,310887276,3559855506,1247864797,2245046799,4056639359,1965946719,555051037,1666448456,1109243297,340027747,932515807,4056606201,2663574147,3487189852,2559720623,2324331548,3625983541,20588039,2303717422,20681409,1748157074,1281032861,1827803748,2723373586,3015191811,2408993697,378908358,3003731332,217907837,2898900806,1194873514,2508724091,4094553373,3036640610,3070880094,1900218745,2493423358,2567245169,678026759,2062399606,3119711043,1534932201,671559011,662585099,2563186267,3485556584,1943305122,778697660,997482985,3401800863,1123131402,212863348,1713419035,3270978330,2181076865,2119622454,3035057147,341413787,3006746516,2168275966,3566191901,2734064041,672014950,2455873237,3102278225,3745295255,1063035528,601602424,1802957960,195324236,439621425,2214675482,722274700,3349813996,3641454593,1851806856,633181735,2222135573,2093271546,1442291269,1603786080,2776544227,298266304,3731789337,72092108,3331718642,2403874349,328603214,789667919,472817674,53522059,3905806955,2471465635,2349378193,1990733779,3739272163,2540071874,2978173768,1482522246,358063783,1990229924,2747441810,4255719120,4219258367,2553870145,314347885,3201681504,1938485666,2610804750,264067583,13293586,287914877,2660706497,3904659415,676935197,812838627,1644107135,2105096089,2337184598,768444585,2576605856,2345782468,2019975826,1871354155,16301271,1095884491,89673422,2836102186,1802185850,953440857,588262573,2966527338,1599317801,3805854098,3346178228,1367091699,509394232,1469322045,180204893,206949082,4259684576,3183493887,1071516507,3751163543,3504598046,2505127087,3519861882,2927271903,2776634811,1647400607,2019132086,1434333675,3319854244,2833805120,3803554003,2364983092,618947957,3823467444,1890563441,286620269,4024864295,1622265916,2904034277,2497517088,176782992,1475701066,2403100570,2986410348,470686660,4024501550,3365980630,920294020,2607029543,3716598564,411489863,376131750,1498159960,501647685,1723370864,1248390759,3107377770,2900698312,1400517009,1835470877,4027263164,1820512898,1096220364,3693042131,3806223829,3924215679,2566720440,1319310393,3105503181,1714500834,2075428519,396417543,2191745844,422371104,72388106,1347381190,461490359,1807462739,3825528551,2472281406,2131619577,567174270,1800030912,2406937897,1455068917,228429431,1189944279,1035607215,2252790337,1772446631,2800837065,1596255605,3396496145,1952504374,3324344597,1840920589,1750549903,1146669425,3581404864,422989147,1972950671,3686269893,312091513,1641553324,731455732,7687278,441610344,4149536418,3618150828,811586497,4031488139,4157599414,2341844951,349687001,3191262338,2727622686,4122819674,1816111805,1121865967,3925802068,2378250858,1428989618,3507931905,430486343,3265396472,4164616146,1918196039,2330947398,1983870520,3768656486,693503908,1320107012,1041166264,2047109459,3736321683,247465310,3723175505,3134012288,2528862431,959469407,3286691267,1144071729,1605318674,1188286466,3423249646,240367818,1983903119,1153093314,4119635122,888645672,3398884602,3721017663,3110820290,1962285712,2100143238,896152966,4221821465,2261682598,2552355194,1173920974,3835974396,521908329,3440389834,26926489,2116312159,440589136,1758565634,1713460633,1386791638,1098127479,3137178516,2606744616,3312319130,2779286436,1544031325,2731130236,2016505885,2087910344,1397271392,3119646728,601285759,2841871905,257940855,2418962707,3566326360,3111469665,4134335694,2444957855,846508425,1548528669,2595610033,3515150812,1200113957,121280273,1730286959,4181797690,3206136361,3373138570,4052363473,3195372108,1141982770,3954313496,3805102302,4292753373,1697961621,3354478998,1534124459,2048818744,2946330253,3320152846,3363625549,669583172,2404562500,2736153337,3440264253,910194706,1824991199,2299758379,488503536,2447527227,4103602754,4190822085,1924062877,2826838752,2081352080,2122032882,2810259890,573436656,2706352504,2726672860,868223697,3667054982,2159458032,1571521227,2245542885,91227304,1275863346,2962091212,1875527237,1294809279,3253780389,2555780726,2621431482,1773117975,2202166552,693664363,3017800597,134055758,2568118906,2671543300,1321777175,3978607963,3091921370,3027735371,71718211,1631150366,91475724,3949057020,3030883308,3980080881,2190253840,706263574,2383801007,44637833,3600591978,1535714647,278274549,3430494908,895816154,630252233,2395142377,3437154414,184743122,634904878,1029764396,417773386,268452775,3294869190,2199980194,900862637,3810419365,641313785,2749325830,2953586066,3893056888,912070186,169842233,862992233,949318364,109424662,3533734578,468240858,3195059010,1155789582,4139875335,2589957337,2802549604,3616628063,168733077,807383721,3740753657,2226292800,2376827768,345832159,351168978,2199292370,583200228,737958647,3667027384,274555168,3546134361,1052884183,570792712,400727142,3404853386,628417629,2025548985,2804212935,370458313,287452955,3389009489,3111242135,3679679901,43743222,727763724,2079368700,1755614485,3555768171,3536092241,2226750784,738702326,2496079183,171475035,3978174865,3268458738,2723919450,4008606193,2272336742,2441177,4074301436,683674655,3064956662,3879165143,601735926,3792306541,742831213,1819891045,3078342984,2186218758,3583164671,2017099336,1428990650,1237450206,1916043496,749804595,547176280,3754790505,3345147519,2748425201,3445391997,1917190520,3821274834,2979498088,1234532397,2692019867,529045835,259243480,3843717143,936234361,3364681324,578069706,577797724,408246025,4273145219,1548724394,155947287,1381494640,2474554321,3891565000,44072379,1137074995,1622203568,1904176710,1406088034,3805731959,3226046433,2800700219,1087211769,3507241127,3908963270,2051466956,3667026636,2376976342,2510674166,1017353392,1002225045,3524131972,2086047004,2834120293,2833051433,2805552577,644441947,1167634244,1990897768,144065926,3673019464,2254166315,4039023844,2308118942,483384829,3282752238,3128487507,3111319665,2418499173,2938043946,1159221370,1238871089,1640731772,654364835,799113474,2895513963,2506859055,2245212471,3699247007,2263155996,2178495707,1392704430,2443114952,2041880196,1242765176,3658369997,791599237,2814553101,3590736666,506439966,2165789947,2950404679,3880670763,1495757633,1855431672,72700982,312102961,1218764557,424727682,3895324666,2846620766,2025675617,499406139,4024325948,3182791939,1134462035,10676425,2162008469,1068585081,1039330472,1621420575,2142522168,462077132,183885964,820742610,4058593292,711339058,386841029,2419396124,3920064316,2874676608,1533007506,51762520,3526020535,2914557141,2936929955,2363439298,3299678528,1809077169,1072845034,3662684507,4280332245,4065900491,311765946,3317953810,1991045297,15165093,2221894215,1230699829,4233612028,1184734460,2432642872,3735506298,1414833804,6726838,3624416819,2687275791,911674554,2676538391,4077703532,960035364,1428646786,2261181854,523581359,3668539057,2203355684,3038417412,3703270295,4042335953,603271964,1178658191,2173853294,3280859621,560071624,10534440,2847711077,78089525,4228159454,2906636398,330616100,754380093,1486373161,554620746,2400617761,4135069678,2430691096,2873413901,2522516561,1310996280,3514375355,3306672896,1847574309,608362527,2015272204,1129428663,1938190852,3235003548,3980191412,2812956455,4251805270,1534678675,2976787586,2951773381,211546653,383114966,1343656651,4005139141,1910524174,348526471,26593140,1706052637,2690069336,427565708,4132544229,1139380439,1345333109,3914287513,2194191400,3170589671,343377865,197829082,3436616972,1621554462,1687929627,3646552825,3550464761,1631367676,3800559220,4167733725,1247386052,2031857235,860707369,3753763404,1165884267,3328549543,3614641148,2802271877,4097423143,841036050,852514160,3556224717,3307383162,2116747961,4085845391,4117405442,3948624812,2781545769,3048475640,2334397842,2246616491,930299848,9835698,3768979414,3089397988,873960235,34327700,579724625,4237131427,4188490280,812312217,2619922356,3773103468,1995664402,3660380188,2680263091,3844771303,51710849,3090285978,1934256108,416750873,3480610731,1489649262,3936980894,2784282799,2811882618,2166319679,3423032368,3089018015,2370619161,44162547,3602271237,2686636272,758664497,437766747,2665029633,3585091362,1169676498,3827802478,152939306,1421413212,2272519425,3933352898,1646113091,2489865009,3334175911,2718308058,2297738876,1212431654,1433902310,2048042739,2362604591,3286873862,3005637512,4135133169,3369509162,3239211423,3048279099,2983808466,2621306751,3340989310,2497891942,1778806746,3123299150,3142694635,2452850302,2030017461,2048132365,999770425,4027108293,1842173842,3743306036,1369074415,3806906463,3794877971,1399558616,1836037967,3425257720,1200252099,3562285477,1914185129,715940491,3993486617,1289625429,4064427152,2289962801,3915446706,1518359061,4000807075,2134379628,1796062693,844561183,1280620538,3956760364,428149682,1150298335,1802733113,590402995,3193641620,1083324243,4049036061,2582751733,3467192861,4158362782,225858745,1970528591,2025889562,3010139452,3614872725,2431616469,1588184450,1265390203,2257756035,2908098200,2184054575,1299452302,1696932635,2805532021,1952573456,4262710199,3287449154,565339969,819931358,1680855593,3286315020,3720884096,1172989599,1756086175,1519200953,4130664651,971775114,2401059509,302368628,332864611,1604001033,586887007,917151868,287474617,2259212298,1138659790,3949773511,819611691,918064666,2994917534,1809018198,1435322657,2842718410,2909980728,3969527973,917160228,3371874603,3919315640,310644927,3492332537,3723173882,3990070898,2490108512,245284545,93420402,3285832727,2847796052,2434563349,4737641,61234701,4035128148,3454604629,3640052980,3783387437,1403751819,3634149668,2495860323,1297059293,1763415037,759783468,4215344516,1535546972,2881418788,2286852940,1712919137,12813897,3839000956,2217301276,3299276318,1135691170,348536729,2067370838,4242506879,4035203740,607939744,327095906,389397608,174573402,584234068,1344652049,1465565127,2463525788,3357911865,1569299621,3965484242,3341840391,1354256372,136019983,2633616419,3488387215,1717072142,2310794463,2189911281,650264694,3823737792,1596518358,1440918112,3790452134,1914909315,1996855632,750350850,459716046,3039448535,1442348291,1788353616,3669144680,1960512879,1813355756,3370605348,2224714029,2200864436,3947751360,727343414,810592400,1893505526,2741981247,575606299,1838457933,2229498176,2737260632,3649792584,3865454405,1811564861,299774109,2261465652,905276232,860140727,85732324,3454935992,4288074892,1663668131,3535407212,3392057682,174719699,2706613362,167508262,2062627692,3936150868,1680423316,463408428,4063854140,3319687663,428552670,2145020290,3139265329,138478238,2583082607,3670811155,414306301,2546001802,2992324604,3396728609},
} ;

static const unsigned char precomputed_decode_1277xint32_s[precomputed_decode_1277xint32_NUM][crypto_decode_STRBYTES] = {
  {224,34,69,226,221,86,219,141,140,4,12,90,28,58,238,128,74,8,252,188,192,172,186,169,152,167,10,162,109,112,67,24,3,211,90,85,98,248,59,102,27,48,249,198,85,45,186,86,156,114,119,29,136,224,63,13,37,80,18,121,74,204,155,122,254,19,67,246,135,138,171,133,22,53,15,162,66,80,233,58,167,41,182,222,26,233,173,170,156,159,205,235,114,142,242,136,238,50,224,179,8,109,67,84,254,121,238,152,174,31,124,183,101,82,41,91,235,226,107,90,220,128,21,146,221,81,127,108,177,104,100,53,9,90,27,14,204,84,56,7,35,132,228,69,244,171,59,161,29,117,66,14,68,230,33,237,43,18,217,139,27,15,153,210,2,55,118,223,29,246,169,85,241,226,70,38,39,4,69,44,223,55,128,162,5,247,251,128,154,156,171,71,230,165,239,18,146,56,190,232,41,118,162,204,159,12,229,197,87,4,217,132,121,203,229,252,201,227,124,104,85,89,178,206,130,220,97,224,157,225,110,14,166,160,119,161,94,57,63,75,165,25,121,148,244,194,140,173,142,175,39,218,202,211,71,29,107,184,233,76,138,50,190,226,185,234,112,147,98,49,11,121,201,77,67,108,241,213,42,237,233,152,190,207,190,93,68,41,124,153,235,211,50,215,228,129,197,125,21,210,76,48,35,198,192,51,119,129,23,25,248,172,186,28,107,37,121,184,69,31,255,48,246,21,43,61,216,176,209,197,143,12,115,9,150,197,152,145,180,136,196,232,207,79,57,234,100,235,232,162,109,229,32,115,83,113,216,0,69,44,179,114,94,150,183,18,255,155,170,234,213,61,66,93,43,207,36,200,246,223,50,188,248,241,83,176,62,122,213,61,108,100,10,24,4,109,18,69,155,213,68,225,220,2,77,213,35,122,191,91,7,201,81,105,28,6,247,111,64,66,43,173,133,186,9,93,230,172,147,6,15,110,252,116,32,59,250,72,35,76,46,13,33,236,246,27,41,165,172,206,232,18,82,81,207,94,115,75,198,97,148,9,67,85,96,82,167,171,182,201,100,20,210,239,33,100,58,32,89,110,116,251,44,143,11,76,152,111,242,84,3,200,133,174,174,19,145,197,201,79,0,17,39,113,236,220,198,9,116,116,121,198,38,114,203,113,33,7,62,147,218,102,146,60,172,2,135,186,26,120,125,157,201,83,237,162,229,154,158,27,222,99,81,73,122,39,71,206,178,162,75,218,248,123,69,130,125,77,61,164,105,249,1,49,185,177,190,232,251,189,216,20,180,188,154,166,83,72,94,52,115,229,129,67,89,82,174,37,23,130,164,248,0,178,133,120,70,18,254,109,117,40,91,14,61,48,55,205,16,120,244,1,138,220,191,85,191,200,164,133,169,145,51,191,127,119,203,254,48,26,212,156,168,140,146,42,106,22,235,44,82,188,202,87,189,129,231,56,66,245,25,249,49,30,202,238,183,72,132,144,122,237,90,100,127,150,75,69,134,52,72,219,92,197,203,22,73,2,14,103,19,149,79,64,175,116,164,208,234,34,1,49,243,161,76,203,152,229,127,102,56,121,243,206,71,35,37,20,79,7,146,226,75,142,125,169,153,139,68,182,172,236,39,190,236,70,57,64,255,108,42,132,59,25,251,58,89,138,28,254,228,183,61,1,197,166,4,170,116,113,96,232,53,119,79,9,158,217,159,190,248,194,227,205,125,20,106,196,184,180,138,177,164,190,187,127,2,174,133,132,112,134,31,17,248,12,41,233,213,1,240,14,243,158,94,212,143,63,1,96,231,91,100,154,25,249,122,42,138,194,226,193,148,142,176,237,88,14,27,69,220,85,70,227,93,213,46,223,240,105,4,87,161,132,1,69,66,58,163,207,135,139,111,49,243,6,179,146,167,113,90,86,191,94,142,10,0,68,35,172,124,202,66,234,131,119,127,235,141,236,41,4,34,187,191,21,148,123,179,171,205,234,51,68,9,250,211,65,18,177,201,125,101,67,160,67,67,198,16,153,47,253,139,212,9,105,107,130,119,68,97,163,2,248,123,181,49,71,196,149,44,158,184,177,86,127,13,219,204,141,172,236,171,174,246,195,131,225,85,123,124,100,242,201,137,52,196,1,74,64,66,180,108,27,79,33,106,170,31,17,91,88,7,243,83,41,126,15,181,150,128,57,34,59,255,125,48,49,94,136,5,102,199,226,232,67,141,86,132,185,140,129,220,8,221,39,64,209,156,165,5,231,157,100,50,63,71,244,77,214,81,191,89,114,31,3,216,4,145,99,57,231,216,145,249,88,124,128,85,61,9,140,81,74,193,88,119,42,13,119,168,195,167,175,208,229,198,35,148,34,48,160,30,62,31,181,170,42,158,69,51,71,184,81,179,8,80,211,2,16,6,61,159,76,153,56,68,187,246,121,253,66,52,78,167,108,189,50,197,130,251,246,96,149,150,91,106,35,102,129,191,244,249,41,121,215,109,51,112,82,44,79,151,148,103,243,221,172,239,186,3,167,54,135,38,17,252,235,255,7,146,140,170,67,157,138,74,200,170,115,206,56,183,67,45,140,218,109,179,52,220,83,135,165,163,66,158,73,126,131,80,192,45,231,221,128,44,248,109,52,213,231,126,192,224,236,149,121,127,187,171,180,56,77,144,189,48,209,141,244,161,12,76,159,100,113,232,195,161,178,231,247,216,132,123,37,99,234,92,18,205,241,26,57,179,121,92,138,234,8,39,107,47,247,178,64,3,38,240,42,31,33,215,59,23,205,197,39,161,117,136,119,91,2,251,108,146,242,64,37,106,82,38,176,192,105,39,235,228,29,42,137,15,109,67,58,4,130,70,153,113,237,10,112,140,226,208,88,51,177,220,10,146,69,175,17,81,184,244,170,51,156,251,119,147,213,195,142,133,36,191,244,6,202,247,32,154,56,40,53,132,28,207,123,53,23,185,164,150,102,145,201,178,71,241,186,69,77,128,32,7,94,32,146,148,109,151,81,209,158,84,173,236,201,252,254,9,103,105,132,11,233,47,220,6,229,21,248,163,253,32,78,161,85,129,212,29,65,226,217,5,84,222,62,135,69,116,153,0,59,47,83,63,71,199,59,246,220,112,30,43,157,204,27,180,28,218,91,27,35,147,76,171,39,255,179,230,212,119,101,38,139,147,77,208,14,212,7,145,117,255,9,114,114,118,197,216,33,195,61,59,140,10,39,201,203,15,75,159,42,12,230,242,87,38,30,175,63,201,108,11,150,188,233,25,29,250,204,10,32,194,37,87,181,53,231,103,73,28,16,143,33,121,18,123,31,243,244,48,7,111,255,207,62,185,208,103,4,224,138,108,255,33,13,26,76,57,213,110,185,255,209,178,23,213,233,229,121,242,65,14,45,130,55,5,200,47,195,127,15,148,152,173,127,228,238,68,157,94,220,198,17,54,111,174,9,70,3,94,187,224,41,111,252,105,37,52,246,136,24,6,144,149,10,86,90,59,49,175,149,146,89,40,195,77,254,176,90,2,147,187,103,158,199,220,94,125,63,210,30,28,14,158,116,84,59,200,149,73,200,215,40,110,97,53,45,52,218,6,172,135,131,91,14,195,141,131,245,225,144,22,22,107,22,53,102,207,181,249,133,239,76,45,171,230,252,120,79,83,47,37,35,242,155,163,78,74,248,167,236,249,116,228,172,105,233,112,108,244,58,140,216,144,60,60,249,221,156,150,13,114,136,53,49,113,52,99,226,211,101,193,70,5,27,246,60,83,159,206,67,92,24,108,74,101,18,162,216,174,223,159,181,90,118,179,227,192,5,231,182,134,146,86,206,191,29,92,236,127,47,91,214,15,27,226,68,224,41,213,170,25,136,109,138,9,218,37,210,160,215,76,220,131,224,119,170,23,7,223,73,101,12,239,81,17,112,23,11,220,91,20,209,143,192,73,225,175,254,179,244,59,228,228,146,47,71,81,201,90,251,243,226,225,128,117,147,156,139,101,24,98,245,144,85,114,86,193,215,208,192,119,26,28,250,126,210,118,99,243,154,180,111,102,182,88,101,74,100,73,219,231,170,45,44,152,112,224,176,171,99,145,40,214,107,190,133,201,198,79,245,174,23,18,149,124,42,51,185,34,49,134,109,28,0,40,218,231,119,156,139,113,171,17,94,185,72,30,222,155,222,172,179,118,45,101,151,89,234,102,142,204,248,166,138,106,227,35,2,53,142,157,234,81,203,90,83,238,226,163,208,165,234,216,27,67,102,77,96,93,14,254,84,25,140,96,42,3,35,54,62,78,127,168,116,12,119,217,172,120,181,173,101,108,83,109,119,242,105,136,92,164,252,142,210,165,122,246,227,36,145,104,117,217,19,31,68,182,239,183,127,35,196,215,37,133,246,246,208,244,82,53,9,160,27,238,159,99,220,97,211,30,117,104,223,30,3,122,139,225,23,69,169,98,88,149,142,14,204,236,194,165,137,85,55,242,132,83,31,1,124,209,224,66,241,207,215,152,134,235,46,62,165,213,127,203,102,20,128,49,95,138,81,247,22,169,112,180,39,11,247,43,5,93,24,98,109,91,230,97,239,28,96,69,110,17,133,186,154,40,223,224,255,42,83,198,17,38,113,192,144,99,173,49,187,189,10,237,58,145,2,160,197,249,154,13,60,136,162,39,139,196,124,223,198,17,117,103,175,157,132,207,100,138,197,77,237,122,66,169,222,89,232,186,246,231,43,109,40,98,90,201,18,84,182,124,143,141,191,208,19,238,234,193,55,103,101,113,251,21,104,82,170,164,95,202,149,74,6,178,100,115,149,5,174,25,210,166,187,45,102,159,206,56,185,151,195,196,241,39,118,236,48,246,148,33,84,53,237,141,10,12,65,24,231,242,183,191,48,239,174,61,173,54,111,218,249,51,197,188,100,232,255,79,183,170,98,86,97,181,251,14,93,105,87,5,64,88,91,143,210,74,175,32,142,59,96,167,241,236,24,174,212,144,36,63,168,57,21,64,128,150,9,235,7,63,115,190,181,90,127,154,135,116,129,145,176,150,247,121,0,56,220,14,255,31,42,39,112,217,128,49,19,242,136,137,66,55,136,173,61,51,255,156,244,252,184,26,187,201,230,60,23,126,93,122,237,67,25,156,126,98,28,237,131,228,121,217,46,177,97,96,87,218,186,72,239,181,251,241,66,252,171,185,15,243,19,82,39,76,110,124,15,153,157,168,230,243,192,150,123,185,148,149,198,134,21,8,142,174,233,23,28,161,37,220,199,200,116,236,234,254,214,169,25,231,69,228,210,77,2,58,141,94,132,17,53,107,237,89,16,217,126,126,128,56,139,53,71,249,55,231,223,49,35,51,172,247,246,179,224,47,173,35,240,76,62,249,134,57,217,39,106,213,226,11,3,96,227,22,235,188,39,166,96,241,177,104,39,30,104,121,189,35,12,97,105,41,18,186,90,209,165,129,36,69,248,17,233,227,221,24,7,88,121,82,63,220,235,18,57,215,219,214,103,108,159,3,77,192,87,137,251,229,41,143,40,112,67,215,53,196,25,5,163,199,173,121,82,57,163,187,158,219,4,84,206,222,112,250,144,1,104,235,166,46,101,48,220,148,48,61,153,247,226,65,93,126,229,244,245,157,33,9,231,52,42,14,28,165,43,120,179,54,211,155,128,67,0,120,175,93,20,85,163,88,215,189,185,217,201,201,130,91,239,27,60,244,226,181,106,253,182,203,104,75,33,228,107,28,82,10,197,58,235,166,194,32,42,204,70,201,249,175,224,131,202,48,237,100,114,154,208,157,22,17,207,26,140,222,7,7,131,181,68,141,45,152,211,215,195,18,193,77,158,243,248,67,96,122,128,113,130,168,134,48,3,159,61,146,185,235,6,94,73,214,203,251,159,151,247,228,208,250,96,227,173,7,37,72,193,12,217,237,243,254,166,104,246,190,241,34,40,230,208,226,226,119,184,57,43,228,110,198,214,99,134,58,64,23,184,18,249,81,132,171,166,173,49,174,134,121,135,154,255,12,135,84,105,43,15,238,188,6,229,221,238,149,113,227,15,145,99,145,167,78,179,58,188,54,229,254,154,238,154,3,204,235,10,166,78,227,243,58,209,117,245,246,4,233,30,76,170,201,83,166,169,91,204,98,27,90,63,80,84,54,26,209,102,227,228,251,147,211,112,227,97,243,127,217,194,105,170,98,141,87,79,215,208,93,194,109,143,45,211,78,13,121,244,104,230,70,33,136,116,242,153,171,174,173,2,251,17,112,65,218,95,207,154,1,193,146,108,183,173,17,178,189,35,25,212,12,162,96,35,8,18,141,107,177,137,128,77,100,53,174,132,23,73,220,109,79,90,5,9,183,223,3,180,35,11,46,182,99,27,144,215,184,172,23,85,9,40,199,141,215,69,128,23,53,66,168,22,248,241,210,201,37,72,64,159,93,206,156,239,71,184,204,250,133,193,27,119,37,197,142,176,250,40,251,162,154,227,82,149,163,66,198,184,154,78,64,34,166,47,123,182,246,191,101,244,159,208,177,241,14,229,196,24,36,200,89,186,163,188,102,102,81,19,6,147,29,129,151,115,94,188,187,101,97,66,152,130,116,246,156,6,121,72,167,40,29,116,237,168,161,141,80,159,252,37,85,255,91,109,215,65,233,226,56,66,240,239,33,152,179,84,97,82,148,249,41,43,235,110,13,82,181,152,35,225,178,56,50,28,41,90,244,195,159,25,105,23,83,248,254,72,143,178,184,1,0,220,249,92,3,190,70,101,223,24,3,140,208,119,226,175,205,1,228,66,201,152,163,74,155,217,198,66,242,145,232,203,43,239,123,208,78,56,86,251,188,126,39,204,252,162,108,210,178,195,193,213,35,185,165,50,189,182,141,49,205,226,172,174,239,54,242,128,26,7,228,74,110,188,111,51,64,123,154,253,187,64,126,216,221,97,213,88,29,89,26,78,209,31,156,16,145,169,25,48,79,45,39,24,115,64,42,28,111,239,172,41,210,54,236,13,147,240,43,219,96,226,135,100,250,173,163,65,188,211,131,46,13,156,120,51,82,7,10,245,162,141,181,139,112,244,98,28,56,54,139,78,207,23,243,109,68,81,211,148,100,57,243,100,54,129,100,52,115,237,151,220,104,176,42,228,196,164,250,230,74,88,23,136,39,186,43,7,104,110,162,147,206,1,119,249,39,97,195,201,227,13,156,235,126,65,250,215,243,175,57,230,83,164,99,176,232,250,229,16,194,250,189,141,9,151,33,128,193,232,217,50,119,51,93,61,196,181,98,220,248,217,116,32,225,196,38,143,142,21,223,225,71,1,28,78,0,33,2,138,136,250,138,192,249,214,77,126,248,200,118,1,76,234,250,114,17,122,151,227,225,239,83,86,178,182,110,102,26,231,194,83,16,206,196,12,160,52,198,135,35,163,11,166,188,131,20,10,35,62,68,16,107,103,200,176,29,189,145,76,8,178,108,111,33,165,129,251,229,222,137,73,164,103,97,33,123,140,230,135,154,198,139,119,233,116,205,251,134,171,39,168,246,234,56,227,21,165,253,99,80,168,195,142,71,8,205,247,173,15,224,34,197,160,226,146,115,240,68,34,224,225,219,131,239,181,222,66,163,9,190,64,93,141,228,203,103,247,26,236,58,117,113,156,8,140,31,65,54,77,105,42,142,197,119,51,211,26,55,12,227,199,183,204,86,214,43,214,254,158,159,210,111,203,171,185,178,61,118,98,127,44,151,166,175,107,40,69,244,215,81,164,9,178,154,82,201,251,142,229,203,18,116,157,147,41,36,202,48,10,11,103,67,134,84,93,98,170,116,155,111,36,167,93,182,228,30,20,160,23,220,18,16,150,81,87,135,75,72,27,87,124,174,255,89,53,153,77,113,141,7,114,190,255,201,14,216,37,50,125,108,162,94,196,227,5,238,248,146,240,111,212,130,15,15,38,188,49,3,2,109,24,101,65,145,179,103,234,64,70,41,250,134,160,209,152,53,159,132,35,234,52,162,77,136,115,118,20,236,81,190,47,99,151,192,171,76,185,193,189,207,183,15,179,169,190,58,185,92,154,42,184,160,241,133,249,241,57,75,133,163,1,109,71,8,121,155,71,99,48,229,130,168,17,12,62,122,178,72,148,138,30,104,188,213,156,114,32,105,1,57,69,29,22,33,107,69,146,67,81,216,131,128,179,95,58,123,126,45,44,229,7,22,164,156,185,177,18,202,1,225,65,195,134,198,21,34,63,66,227,120,177,88,152,121,230,101,196,80,167,243,188,78,45,107,253,21,47,59,128,53,132,14,190,93,179,250,146,50,191,0,236,242,164,186,222,6,82,100,176,19,60,34,16,79,72,250,195,11,226,195,228,242,244,59,185,71,30,238,149,157,135,24,186,148,47,165,54,21,135,171,126,213,227,70,202,195,33,212,98,145,242,116,219,31,8,239,161,56,41,139,211,168,224,162,72,97,156,151,119,121,163,234,104,73,66,147,119,43,31,121,145,231,10,86,236,89,49,95,90,126,86,42,206,91,247,230,102,34,35,241,29,56,217,129,239,43,132,165,186,220,207,105,188,78,251,26,250,238,41,16,146,228,96,177,116,152,225,62,168,209,32,191,162,140,18,167,44,104,129,158,43,56,106,9,89,229,44,16,234,27,55,18,134,122,210,126,234,237,32,188,100,255,86,250,163,38,198,7,15,34,128,244,23,96,229,153,178,233,1,83,238,117,25,153,58,99,35,2,251,96,204,252,24,69,238,0,208,168,19,180,189,30,112,158,56,130,117,199,208,42,133,34,171,42,159,150,251,16,114,58,26,89,141,52,73,66,160,111,28,49,135,27,123,42,240,229,117,78,164,85,146,51,177,180,106,238,230,85,233,140,49,66,177,220,112,209,208,140,242,214,215,12,135,226,81,206,77,16,206,96,110,90,166,213,25,203,155,111,48,92,54,131,253,140,42,225,80,141,160,171,196,89,224,241,189,174,25,10,225,158,223,165,40,20,140,34,216,44,129,78,186,2,196,46,245,73,53,126,16,19,95,210,242,234,251,152,102,54,202,110,48,110,3,30,187,220,91,90,157,99,191,186,35,17,173,149,180,66,119,163,240,172,32,90,107,123,90,123,66,82,252,232,62,52,242,50,226,195,240,80,40,105,185,253,202,236,76,244,44,116,45,47,249,130,139,173,63,232,103,148,243,126,95,87,221,246,44,110,86,220,143,20,77,254,95,27,21,57,103,114,233,117,184,1,198,80,209,41,227,120,86,144,204,40,175,200,80,122,201,66,92,246,235,117,131,118,45,69,231,158,148,31,78,40,159,199,70,58,134,147,31,170,49,190,208,99,228,34,68,26,34,42,76,120,244,90,118,201,188,37,206,93,145,209,31,9,241,229,121,188,124,60,82,57,245,143,10,33,253,53,145,7,2,98,30,129,247,89,0,152,55,128,225,209,125,90,7,65,131,182,78,39,70,178,221,91,126,70,25,66,187,232,157,63,6,198,237,226,172,70,88,206,131,13,148,215,53,248,67,28,43,85,205,103,2,201,97,93,63,27,217,214,19,158,79,206,155,222,199,171,109,126,95,97,101,118,183,255,214,58,97,27,43,94,244,60,62,144,196,75,128,179,206,81,12,136,232,132,111,92,218,73,241,3,126,153,47,116,220,143,139,17,233,117,53,103,65,153,73,139,178,142,153,246,175,137,38,177,167,55,106,181,60,89,7,6,78,140,134,32,12,35,127,18,244,90,110,107,49,210,223,210,77,250,128,196,145,24,112,85,52,11,176,153,71,157,32,221,246,61,129,35,173,206,111,112,92,13,201,94,171,145,181,60,141,241,250,153,190,106,25,53,223,229,222,19,233,16,93,121,145,78,13,115,87,17,136,85,70,137,245,13,68,247,30,244,193,249,242,169,168,230,196,233,218,132,192,67,140,81,68,189,130,3,47,184,245,126,231,91,143,115,247,99,226,12,111,102,92,147,192,112,128,116,233,141,136,197,7,106,202,101,235,146,242,102,20,61,160,227,61,60,79,199,210,30,46,213,22,168,63,134,152,208,182,12,100,82,10,122,238,197,61,88,122,192,120,109,237,197,71,126,200,42,9,8,78,79,207,122,248,6,95,132,200,228,202,39,58,76,252,225,81,56,97,31,161,244,1,219,108,242,65,128,182,227,123,188,225,128,22,197,95,222,89,164,221,238,245,232,87,239,156,132,211,12,23,67,231,238,149,51,13,254,188,10,114,243,31,54,179,78,151,30,213,85,21,6,65,234,2,158,199,201,243,155,176,52,107,233,227,190,223,111,34,223,70,238,190,232,175,48,9,37,160,200,68,70,235,168,222,193,15,62,178,229,21,160,165,42,232,135,55,75,93,139,239,90,69,207,250,230,13,49,118,237,57,111,149,183,31,160,55,11,115,255,226,57,77,89,169,18,112,123,24,71,32,74,6,141,189,207,223,76,70,106,174,225,105,168,130,64,24,250,11,28,197,149,53,6,111,21,7,246,23,250,15,188,187,100,247,157,67,61,89,9,248,254,153,179,194,182,171,234,22,198,64,97,241,249,216,92,25,75,224,67,100,185,225,236,162,47,210,57,75,133,74,61,95,229,144,5,43,159,30,20,97,90,227,174,29,23,173,7,191,169,12,159,70,174,179,173,194,101,254,129,187,42,116,172,222,239,23,16,122,179,36,168,194,206,143,201,157,183,103,45,232,101,54,195,233,181,7,20,225,7,153,170,149,115,198,98,42,72,149,93,28,181,132,125,100,125,142,117,146,196,182,47,184,50,19,82,31,29,43,104,225,95,126,228,139,238,188,57,46,154,112,97,147,26,149,76,237,35,129,169,221,31,192,76,54,207,74,201,163,82,106,225,225,198,159,52,72,165,217,176,40,191,54,219,78,94,77,16,0,6,76,225,135,32,169,133,212,221,164,190,67,198,126,129,92,51,221,221,18,174,106,221,107,109,254,150,226,234,115,204,78,43,85,16,93,103,94,96,250,45,251,45,159,50,31,223,242,226,43,17,50,86,29,7,23,116,236,220,163,197,167,39,13,234,150,104,88,155,97,4,164,215,58,198,181,40,144,136,164,15,167,78,199,160,211,33,25,201,36,68,132,155,129,115,85,178,22,67,164,225,185,248,135,156,202,187,92,110,93,58,136,191,194,236,16,163,216,225,145,114,221,132,31,194,183,169,90,63,2,9,104,29,73,210,97,110,177,197,159,177,123,217,83,111,41,25,251,110,101,212,245,111,148,97,104,157,166,196,233,122,198,207,106,216,180,7,84,115,227,89,67,181,13,13,246,201,150,178,225,146,242,219,18,211,93,138,129,5,12,28,58,77,235,247,170,54,209,154,33,186,202,211,112,146,216,197,160,101,61,206,51,18,65,193,223,207,175,197,39,151,210,186,50,11,19,193,204,4,38,34,37,101,123,241,188,117,192,211,109,147,186},
  {60,121,128,204,237,237,49,150,94,136,230,61,150,92,28,150,190,253,109,60,249,70,5,102,229,53,222,4,73,247,23,148,200,126,29,247,229,88,240,81,248,135,101,254,46,234,238,69,75,191,249,198,147,220,190,97,253,249,97,232,33,43,46,201,61,128,134,25,94,5,251,35,231,196,175,105,61,201,114,58,72,142,116,234,70,210,105,230,193,240,234,4,154,89,182,12,156,131,22,53,253,252,32,166,155,32,120,188,216,161,7,232,134,200,59,142,204,8,113,234,191,223,86,196,119,137,59,134,33,109,15,122,91,63,192,229,180,234,3,184,183,190,112,243,22,218,134,212,14,102,99,230,155,147,183,16,206,154,74,118,146,157,135,67,6,127,35,75,108,41,95,61,28,226,232,215,134,215,67,232,110,33,183,40,24,74,46,9,19,166,248,30,123,137,124,84,54,183,93,128,143,187,118,96,63,207,14,250,67,48,141,88,24,254,232,61,164,15,139,137,147,31,34,215,173,70,146,2,108,228,93,131,83,210,53,18,244,24,196,148,90,114,4,23,30,47,90,218,213,138,220,57,160,165,149,150,172,146,54,183,228,25,29,211,116,168,191,48,28,45,35,184,115,226,195,189,21,222,156,110,69,196,240,220,238,76,242,169,69,50,154,99,210,239,68,9,157,100,199,172,76,189,237,147,24,179,96,84,6,107,1,43,107,139,150,60,197,72,57,55,190,137,39,68,32,26,154,185,153,39,79,40,222,168,67,107,1,211,227,125,247,36,236,7,239,143,44,78,226,250,106,105,184,185,215,95,12,61,72,89,142,85,236,182,67,87,118,189,97,1,151,91,52,158,209,56,83,207,70,18,124,100,140,84,128,158,24,252,249,168,142,239,5,185,104,233,74,148,177,168,84,198,125,2,252,188,35,118,207,3,229,205,100,99,108,29,38,121,18,136,161,186,138,78,106,93,217,9,225,174,201,54,80,122,114,252,210,8,52,39,8,1,174,187,79,249,50,23,206,48,154,7,162,209,215,2,94,86,117,247,158,28,171,227,127,63,211,36,41,124,56,32,176,231,242,39,11,13,147,97,15,154,82,97,202,219,243,9,61,16,164,147,115,153,239,142,145,98,89,244,237,188,166,161,102,109,166,213,178,154,235,60,134,41,64,102,239,232,133,173,248,157,96,149,168,43,100,178,145,18,140,7,207,105,178,60,39,3,129,242,254,161,5,119,26,194,161,217,110,195,232,153,48,236,63,125,99,175,100,162,77,213,72,237,239,8,216,115,199,130,0,48,237,142,20,6,162,207,30,142,193,154,62,96,210,151,240,198,129,214,102,168,207,85,48,243,215,230,26,156,19,144,68,97,129,77,93,244,0,176,111,114,229,116,12,126,184,51,68,191,249,125,95,253,154,108,161,86,209,78,230,153,104,129,252,210,124,39,94,92,248,232,103,111,175,250,24,16,44,89,43,247,239,119,178,48,98,75,238,243,149,228,71,54,24,64,58,229,134,152,20,118,181,171,200,216,34,233,44,193,140,55,143,24,121,196,193,79,228,164,22,231,239,73,24,21,155,161,98,173,138,220,124,69,122,187,100,221,111,184,194,173,211,90,140,234,115,32,210,198,56,1,171,107,31,37,145,81,176,69,123,201,53,67,92,212,79,89,41,120,197,183,237,216,42,48,140,248,42,130,231,214,118,54,156,54,60,218,53,212,117,7,158,63,104,237,236,167,235,125,200,235,176,67,121,54,144,119,133,213,106,63,252,95,33,84,188,111,175,209,51,57,159,244,158,203,162,228,213,17,196,241,70,99,148,128,120,188,99,52,130,40,43,2,10,79,204,21,29,31,235,201,25,128,121,111,197,181,167,171,138,237,215,182,28,234,59,123,134,193,80,3,29,252,195,192,240,144,173,131,89,151,78,100,157,161,189,251,251,146,123,241,151,150,253,98,163,15,30,115,193,211,162,206,201,76,246,114,119,141,130,92,141,242,90,176,88,128,40,69,44,245,65,185,129,175,253,153,47,94,208,254,178,130,92,195,190,101,133,119,157,88,217,204,28,152,147,221,151,221,87,172,55,126,200,237,233,65,31,21,92,59,213,175,23,86,182,197,112,80,23,42,160,130,98,210,83,167,46,185,229,7,196,104,189,166,193,1,206,129,207,54,232,222,22,45,69,236,156,23,10,235,141,77,83,218,4,201,110,142,56,49,42,150,125,16,198,164,169,76,203,126,85,62,75,230,200,236,251,21,132,55,8,219,5,120,224,98,131,170,221,74,133,23,89,57,206,34,12,236,29,217,153,134,3,227,42,251,11,212,205,155,171,31,228,12,200,2,146,137,49,72,238,244,245,169,94,146,156,60,201,138,29,66,28,42,22,105,79,66,224,217,154,85,101,51,127,222,102,131,223,140,254,149,203,120,202,237,250,9,27,200,39,239,64,30,167,218,176,131,24,252,214,187,186,140,84,213,115,254,225,190,174,131,253,226,168,202,209,6,246,70,224,111,221,33,194,108,81,239,162,136,254,122,236,244,33,77,154,170,179,121,93,209,219,92,43,86,23,181,126,230,95,252,170,133,47,217,6,242,34,55,122,84,13,178,29,221,202,179,167,20,208,17,101,195,109,186,94,161,251,172,247,6,180,233,213,107,200,8,63,159,228,175,198,132,243,199,12,170,158,145,53,251,206,193,137,57,177,225,244,255,162,197,73,242,63,185,39,217,184,34,212,71,184,80,134,112,77,24,227,249,59,235,200,105,124,93,6,104,36,139,45,0,228,216,53,184,55,142,49,203,105,110,1,233,69,114,186,97,96,163,29,34,209,254,253,102,146,92,253,69,147,45,106,15,144,163,246,25,98,110,228,27,134,212,112,110,57,22,224,187,30,176,128,152,42,85,222,50,48,202,112,110,130,54,225,95,167,178,138,105,48,96,247,124,7,187,250,20,73,58,26,91,133,35,137,105,167,170,247,167,121,197,68,222,166,156,72,39,65,108,187,159,58,50,15,105,252,144,33,198,182,99,147,115,60,222,184,88,233,26,80,139,189,229,248,34,243,227,149,112,251,168,228,175,243,153,216,233,126,127,195,173,254,151,160,181,239,25,247,135,3,62,218,95,230,225,77,112,60,25,224,141,69,213,87,55,177,13,34,138,166,234,27,230,226,239,80,139,150,26,32,244,54,4,223,201,221,90,91,137,13,193,146,236,234,17,245,225,163,70,208,178,237,109,129,137,172,166,118,127,114,9,51,4,225,125,62,67,23,138,164,241,21,20,207,132,114,65,94,99,128,134,197,147,199,180,75,178,110,196,187,126,136,127,186,180,74,8,237,78,37,33,127,78,45,190,89,18,137,10,241,254,135,30,60,223,97,222,8,120,113,153,127,125,40,243,101,213,111,11,128,37,179,69,141,186,86,235,196,179,72,156,192,131,93,18,11,235,153,205,67,35,136,9,180,10,72,52,206,184,91,162,141,74,255,44,147,38,119,83,164,16,130,49,185,243,90,152,251,164,229,196,51,130,8,125,77,128,150,249,96,140,47,222,204,211,174,146,23,253,33,135,112,199,33,57,58,184,19,218,149,224,97,175,55,31,12,193,42,234,239,144,61,58,71,141,46,97,84,246,105,188,195,158,176,53,147,24,21,187,234,97,207,59,46,171,213,204,238,87,181,138,155,11,203,99,57,68,6,63,238,80,146,40,99,42,253,0,23,12,246,189,64,197,189,30,28,176,182,112,223,190,90,14,230,117,137,66,190,211,151,211,76,163,6,189,217,32,75,255,211,253,51,240,93,58,24,129,117,112,222,178,25,196,196,42,146,215,87,110,139,19,233,206,59,75,174,16,117,115,117,97,188,210,106,70,253,90,225,197,48,239,205,45,193,157,84,220,46,187,50,136,14,54,181,76,194,42,252,24,35,16,35,177,65,178,218,212,24,187,85,111,3,31,218,244,161,186,77,212,210,220,237,11,23,253,118,109,229,57,229,49,239,178,28,135,154,90,163,221,58,180,112,85,121,50,188,108,155,51,35,113,252,228,111,160,81,61,3,19,222,88,97,211,164,107,55,250,241,201,10,205,51,224,117,187,60,177,22,36,5,244,240,6,252,4,67,128,55,92,24,245,199,157,204,130,83,29,170,94,191,151,29,197,147,153,209,1,55,48,103,232,188,94,237,203,32,206,73,33,27,92,9,228,67,11,218,188,36,41,166,153,74,164,238,71,69,232,103,18,51,13,238,112,138,114,100,180,180,170,188,128,147,194,37,178,68,55,12,119,245,193,241,82,196,47,91,227,245,245,137,220,251,109,51,56,50,68,9,77,56,210,50,117,167,36,116,231,57,137,61,150,125,64,208,135,212,230,33,219,13,68,177,221,146,73,78,5,142,145,167,185,165,49,150,227,144,94,187,50,152,62,227,38,223,87,83,88,219,225,62,109,42,23,64,196,149,112,125,64,103,175,169,215,2,230,172,142,102,108,6,2,175,173,56,112,238,0,101,73,25,158,13,3,196,203,241,98,162,56,163,211,206,23,4,122,188,158,8,169,77,55,48,24,245,223,64,144,222,54,248,110,9,169,25,121,53,197,85,9,101,127,253,0,179,6,56,73,204,64,113,40,110,252,206,171,137,209,126,1,52,199,29,153,197,92,74,31,191,218,1,223,152,67,4,152,120,20,190,223,173,41,152,96,216,40,171,161,242,192,198,188,36,142,227,86,249,39,127,253,106,203,237,105,81,164,223,153,209,17,38,200,156,91,41,31,211,127,227,182,200,33,190,235,240,253,14,126,231,170,62,29,192,99,111,143,80,64,124,241,176,189,243,109,101,103,252,222,85,230,165,189,218,92,58,127,10,174,72,210,51,220,190,173,45,25,5,116,25,96,178,132,174,92,245,10,193,133,250,195,88,117,235,46,109,254,70,136,105,2,201,202,41,21,43,28,139,98,59,74,81,249,57,239,246,110,170,57,156,58,187,195,148,118,65,187,219,87,82,130,53,185,35,200,216,177,185,250,195,169,127,115,146,2,66,214,200,85,9,214,174,164,70,197,87,154,212,182,205,188,22,159,32,196,171,30,13,69,66,119,187,32,4,47,68,205,211,70,26,101,84,223,30,50,83,195,65,170,15,16,73,163,139,168,53,88,163,87,93,185,63,240,40,30,241,130,84,157,42,203,123,18,184,71,162,238,174,169,44,87,246,83,0,169,179,254,184,122,127,98,185,175,15,217,241,31,63,156,118,188,141,21,93,232,76,159,80,11,101,233,131,91,117,25,25,233,29,92,244,108,56,120,26,48,27,72,124,218,149,231,97,136,251,224,76,70,224,219,8,54,141,235,244,147,108,255,21,169,178,217,212,109,50,86,239,98,154,121,89,207,178,77,248,8,73,63,63,204,206,162,48,184,239,20,112,93,77,245,30,164,230,169,101,149,137,214,11,125,229,20,42,66,207,236,42,133,238,64,183,75,103,49,190,210,248,127,37,88,21,62,29,198,49,2,20,110,213,28,21,158,106,196,182,164,164,107,243,104,217,92,212,119,55,186,96,118,139,243,63,170,54,209,190,23,1,70,215,213,204,201,160,59,173,79,149,217,95,40,168,200,48,170,39,44,31,243,159,27,17,243,118,211,0,132,249,131,44,113,23,3,43,41,239,88,97,49,235,69,169,231,91,183,39,187,188,13,215,255,63,137,223,218,214,53,23,99,34,73,234,225,110,91,211,147,72,121,160,101,41,6,45,145,232,123,86,178,150,54,122,24,59,241,242,221,68,25,65,29,147,255,98,122,79,162,6,25,241,235,241,152,173,40,247,94,148,64,82,247,95,52,217,181,161,117,102,226,67,38,79,165,227,92,23,114,139,0,169,188,68,115,33,148,55,215,111,19,205,252,251,198,139,12,56,39,145,14,105,222,56,125,43,5,164,117,83,167,130,55,207,239,7,27,246,98,77,213,40,66,212,115,10,73,69,155,213,101,89,37,134,154,178,168,144,117,202,103,145,183,14,245,210,51,164,140,74,128,156,89,82,21,140,30,162,120,246,225,48,175,29,7,95,35,103,17,115,55,204,8,84,166,60,185,246,18,39,17,225,69,48,141,196,222,164,124,111,43,28,111,6,237,63,232,41,186,159,247,138,242,244,174,85,149,168,237,144,41,200,23,99,135,116,112,210,20,152,220,147,124,102,167,72,74,101,86,127,183,153,214,194,171,247,89,242,24,8,163,197,244,132,168,46,28,197,116,81,167,79,56,145,145,68,227,210,65,62,77,70,63,23,34,119,192,225,122,63,231,245,157,62,219,111,17,79,68,183,83,43,239,79,23,42,106,141,51,1,145,52,49,199,95,255,44,195,156,86,108,106,176,96,160,161,63,178,22,117,46,163,86,250,206,180,91,81,208,2,112,199,227,54,234,29,219,33,1,234,6,40,147,187,81,116,93,69,202,114,99,133,23,150,1,165,123,66,86,111,85,75,147,138,176,105,127,252,151,122,209,71,34,188,66,145,86,72,25,156,115,132,42,81,106,194,96,206,249,150,81,189,239,122,51,77,112,172,91,47,51,232,202,152,180,80,11,77,63,61,192,178,41,3,124,0,130,181,117,73,222,11,163,66,19,121,95,137,68,17,147,3,206,25,103,248,164,32,155,64,61,103,205,16,120,108,15,43,137,194,83,201,145,204,16,189,242,224,148,192,172,145,108,16,154,242,28,115,170,135,156,17,168,251,107,115,250,228,221,182,33,170,5,121,173,157,80,140,173,23,25,139,152,88,11,36,164,95,39,124,209,251,228,193,214,33,239,111,117,73,85,44,223,175,232,50,54,170,212,192,97,174,224,92,156,196,147,229,43,93,196,70,93,234,30,83,241,157,158,130,250,56,68,185,55,184,153,84,109,15,207,133,140,165,143,115,240,78,180,13,83,178,104,87,14,20,141,128,229,177,109,175,79,206,90,82,188,40,150,92,73,179,129,87,22,208,121,84,155,216,78,240,1,168,33,221,85,125,32,58,219,131,167,181,2,79,79,8,105,65,245,167,20,224,21,217,30,134,66,80,2,87,125,126,94,95,125,143,217,158,206,125,59,127,239,133,183,30,3,61,220,32,80,65,32,13,33,69,189,152,244,112,221,20,66,34,181,90,183,167,245,203,78,24,210,28,144,200,218,194,32,165,46,168,233,86,230,233,193,47,70,167,173,206,244,8,189,232,244,14,11,19,219,176,85,38,100,243,39,64,117,119,112,238,178,80,220,77,14,43,69,167,69,45,169,88,211,237,194,253,159,18,211,104,185,58,251,147,216,179,64,147,146,240,207,110,193,88,24,186,167,3,148,193,26,201,26,33,84,163,2,225,180,73,185,28,206,28,219,139,190,56,83,72,211,82,78,189,198,151,203,136,155,188,232,155,113,57,3,235,211,250,139,189,128,51,113,212,128,35,190,26,238,121,115,61,126,38,24,123,189,92,152,59,134,162,195,89,180,166,209,67,117,147,244,174,58,203,13,226,207,108,70,138,6,92,226,107,108,69,94,120,151,206,203,73,129,105,104,165,61,83,235,184,249,240,206,128,15,17,100,250,251,216,65,12,168,210,40,181,144,39,198,41,88,118,15,47,252,241,95,246,62,62,235,246,54,202,112,212,203,145,255,45,35,200,172,129,151,83,121,54,34,220,195,89,77,51,52,253,22,137,140,227,3,224,31,205,68,137,186,103,119,125,145,68,138,246,44,177,94,185,200,204,192,112,86,147,161,205,170,124,14,98,162,81,132,46,23,254,139,166,59,100,15,112,77,112,147,142,95,16,153,81,247,178,176,83,225,230,146,76,36,18,53,231,165,40,23,211,169,207,136,29,35,175,59,196,64,94,226,134,117,85,149,60,233,57,68,8,119,28,5,20,239,96,87,244,45,145,144,236,248,84,142,26,5,124,51,120,172,137,67,48,158,132,28,84,83,2,11,202,10,51,18,189,5,45,216,0,80,231,43,183,39,83,89,170,242,112,161,59,245,91,20,79,26,112,25,18,112,173,14,9,104,11,37,118,9,235,133,221,177,43,59,80,79,206,75,164,25,33,25,159,142,131,223,24,180,251,174,24,4,216,139,188,76,255,143,250,171,99,201,13,83,253,92,250,56,206,23,181,97,58,18,226,247,29,174,246,103,94,23,24,146,141,224,143,165,219,5,128,6,79,225,231,42,204,164,81,36,31,88,237,174,0,10,28,73,34,81,142,221,45,91,51,141,32,174,14,58,147,253,15,1,188,242,22,129,74,4,174,85,47,90,204,120,30,203,241,53,212,138,54,156,33,146,129,132,231,246,102,88,78,131,177,232,75,9,53,86,113,29,222,1,197,91,106,175,106,188,123,213,172,245,149,181,70,133,240,157,245,164,213,181,150,38,155,140,57,85,22,244,158,114,23,249,185,144,163,188,104,72,75,35,233,229,112,70,35,211,139,171,183,29,39,83,105,140,211,123,37,150,36,129,198,36,217,6,174,21,217,109,115,251,168,85,56,9,221,111,228,200,85,222,107,171,62,245,164,72,235,33,40,243,153,61,105,67,112,216,142,226,192,224,101,204,157,147,104,152,232,194,18,81,166,252,109,135,68,56,63,247,41,9,231,10,223,9,93,152,2,70,63,161,163,35,97,28,196,155,4,21,245,80,53,50,241,192,248,37,151,223,88,123,237,218,16,155,126,111,47,195,12,171,0,169,232,177,196,164,226,212,197,71,11,191,139,175,102,208,186,192,213,79,120,83,197,39,49,189,20,2,227,229,29,63,99,228,176,195,94,225,55,198,214,207,76,216,30,150,152,161,22,96,65,94,220,43,49,2,74,4,13,136,87,244,62,229,124,255,139,4,89,131,179,106,64,24,109,56,179,237,251,113,110,191,20,198,127,22,11,224,254,51,200,181,162,146,148,214,55,39,61,10,42,237,130,228,24,129,177,98,38,52,116,101,4,115,226,206,51,24,102,46,90,146,88,96,227,21,213,178,126,109,71,227,146,191,10,198,31,88,9,29,87,215,199,221,146,135,18,61,42,163,173,94,65,11,136,242,45,29,17,241,32,41,44,98,134,184,84,26,71,141,173,79,48,21,137,116,37,237,62,195,245,19,217,43,109,79,1,79,94,147,26,132,170,50,234,190,190,177,179,123,199,134,34,8,64,57,46,61,219,108,206,59,56,23,213,27,129,222,69,209,3,75,165,99,175,174,230,220,54,47,71,88,148,152,64,55,249,235,23,84,159,20,105,89,150,231,240,152,206,190,173,180,179,123,141,32,223,205,159,119,223,244,191,242,16,183,254,84,160,37,79,157,17,41,252,190,40,32,176,99,59,174,143,70,211,195,56,86,202,252,112,198,234,109,39,68,191,100,190,212,193,14,10,89,178,60,98,11,47,31,71,110,148,116,191,126,235,216,66,176,32,203,5,255,121,77,150,69,2,235,24,236,54,97,10,64,39,25,245,183,75,49,96,234,48,254,244,6,49,161,47,193,109,180,100,57,20,8,175,164,239,43,249,245,229,136,227,101,42,76,181,151,215,17,96,55,215,199,88,25,87,98,191,185,159,181,246,252,69,202,47,72,166,175,42,72,183,87,210,104,155,186,66,200,235,50,105,156,49,172,10,223,18,33,169,237,253,0,205,213,114,188,191,111,231,218,11,159,95,44,91,127,137,181,188,90,84,85,145,124,134,68,191,167,41,47,19,107,155,82,18,216,130,239,96,243,247,214,197,196,193,154,154,149,46,164,245,164,108,64,153,183,101,32,232,83,244,142,35,212,16,165,23,15,208,252,179,80,196,170,128,223,111,244,8,79,226,188,129,11,67,134,139,235,24,68,136,139,12,109,240,43,231,76,2,157,197,31,197,29,182,151,80,228,43,232,36,2,208,44,154,151,21,80,224,91,212,85,239,47,180,122,63,247,80,178,85,44,149,159,230,18,206,177,189,213,6,217,221,210,251,93,182,12,90,55,45,137,127,8,25,225,60,89,171,53,77,27,163,58,19,149,72,87,172,153,98,12,99,192,68,201,13,211,57,115,159,250,236,136,74,54,66,125,166,111,199,169,155,134,38,230,28,228,97,170,16,179,137,38,89,68,185,168,249,124,8,211,195,174,97,26,127,80,247,117,38,86,83,11,192,152,145,188,130,151,79,199,197,84,127,13,73,220,232,92,80,77,231,225,119,76,180,127,40,145,156,244,3,62,225,89,86,233,174,215,237,118,108,129,161,101,44,116,80,52,29,217,179,90,6,86,201,2,253,6,124,217,111,151,9,108,110,56,180,235,20,95,233,119,43,67,208,237,21,8,36,116,21,174,94,216,64,133,100,222,135,96,81,60,24,96,3,131,126,58,73,253,189,153,75,148,225,217,199,188,67,234,213,72,228,40,20,200,213,70,134,26,34,3,212,132,145,40,128,194,200,201,134,76,122,18,98,77,250,83,169,34,165,197,230,170,197,24,210,127,55,247,91,80,196,21,70,35,86,3,183,28,32,40,96,19,249,42,135,132,202,228,59,35,36,108,173,82,131,211,17,127,149,236,14,152,132,254,32,48,126,104,126,122,119,202,246,233,60,184,238,242,22,209,11,1,147,105,6,31,68,8,2,248,139,200,158,130,238,184,214,24,54,104,159,250,61,95,124,134,216,116,206,58,155,100,240,61,46,144,115,202,220,176,39,252,4,23,17,138,90,99,131,200,163,162,230,32,182,161,184,248,215,168,16,134,129,94,178,221,221,90,58,155,213,179,235,76,74,62,1,40,237,81,245,50,48,243,5,127,41,142,237,203,161,21,103,65,162,250,37,115,253,7,117,128,97,144,105,116,40,185,192,108,206,121,170,67,195,114,35,12,14,117,67,222,186,96,41,191,207,200,82,65,174,12,10,2,213,125,242,236,160,255,166,57,82,204,191,153,226,81,229,239,163,119,218,122,207,60,186,255,233,119,10,85,146,77,157,176,147,69,113,36,94,134,145,139,114,81,91,157,188,220,113,245,22,231,45,100,157,10,131,63,69,228,86,18,223,88,197,183,193,168,38,254,219,7,46,45,254,143,77,95,138,46,72,223,148,182,189,239,211,81,184,30,40,233,191,28,210,38,82,11,64,75,236,70,171,91,13,53,32,171,121,121,219,101,154,175,171,101,124,236,34,66,229,172,48,191,191,146,63,37,163,106,225,248,139,70,144,153,68,247,237,187,55,116,72,132,2,215,152,159,202,253,91,220,242,172,217,250,181,16,150,247,239,241,105,17,109,102,27,131,10,231,119,114,6,246,21,26,103,140,156,36,17,92,23,97,28,133,246,242,200,87,169,35,95,96,183,213,175,71,165,184,140,195,238,58,135,203,62,24,244,139,80,194,112,41,213,249,240,173,2,203,16,206,208,152,163,197,213,144,230,92,199,214,43,166,60,24,201,152,127,78,128,63,108,207,37,86,171,253,4,126,35,81,74,152,96,139,163,238,205,25,215,184,153,201},
  {178,31,57,88,204,230,178,20,27,182,148,21,74,78,249,58,90,147,125,99,219,31,200,181,111,248,9,93,99,117,42,114,84,170,130,52,238,49,79,20,147,48,14,122,26,98,23,245,236,191,58,122,153,188,166,35,52,55,141,55,43,13,213,163,229,2,65,114,157,95,228,219,233,42,189,169,94,159,25,229,175,165,41,133,127,71,169,200,57,117,60,19,60,89,152,98,20,219,30,238,192,128,86,174,152,81,108,50,200,201,46,35,11,241,206,148,17,124,208,90,133,77,224,78,203,32,14,173,57,81,114,161,40,59,77,186,43,91,72,27,101,152,109,222,64,254,136,39,20,1,80,49,46,239,5,109,64,80,167,121,189,36,37,92,3,109,108,115,46,240,119,249,215,223,12,125,164,113,16,239,27,250,201,37,132,243,239,101,36,27,51,142,170,79,4,233,113,250,126,56,149,253,139,245,55,145,4,127,130,199,143,94,140,205,225,67,141,234,185,213,44,218,194,15,183,227,142,126,171,221,32,125,26,215,100,18,47,43,190,2,84,254,156,85,45,77,31,210,94,178,224,136,171,204,78,163,101,203,251,84,52,37,198,115,35,73,105,83,75,79,144,122,206,199,7,236,170,0,173,87,222,217,184,209,72,214,218,209,25,180,59,40,204,144,69,104,26,151,107,248,231,26,151,227,222,102,130,202,171,251,226,67,194,229,196,218,131,79,241,174,35,54,225,140,59,175,7,44,190,44,110,40,94,135,18,16,202,148,125,98,132,51,2,103,214,165,139,195,185,103,103,117,98,95,169,40,78,87,180,178,227,77,53,92,187,222,176,103,172,247,62,68,213,162,52,102,49,128,254,160,56,217,27,89,213,56,65,86,5,222,15,224,87,153,197,230,40,166,121,94,132,247,94,192,199,223,80,181,71,60,113,240,81,91,219,16,232,244,90,82,249,247,48,133,193,131,90,117,25,181,222,149,107,159,162,222,113,194,60,208,183,157,110,57,98,255,162,163,77,230,127,39,131,101,43,96,243,148,112,208,218,185,199,22,48,83,206,253,131,251,35,158,19,121,176,135,202,36,180,123,66,211,46,116,47,239,212,40,157,236,181,238,88,127,193,172,212,109,245,92,215,34,250,170,12,234,99,87,229,40,31,218,179,163,149,241,234,41,50,209,224,13,164,126,193,149,209,159,114,212,184,156,31,106,1,227,61,149,139,36,168,174,251,138,195,174,113,140,241,43,114,170,211,59,50,212,79,8,181,169,249,75,49,229,228,70,147,127,211,159,101,193,16,241,250,158,142,235,162,98,202,112,43,214,57,216,77,92,211,129,104,185,71,193,221,108,205,232,147,142,93,173,73,196,122,204,12,199,57,140,250,190,80,50,77,53,28,56,32,198,3,193,164,107,193,155,132,2,93,19,203,115,7,145,189,152,27,148,124,197,125,253,9,245,188,115,87,84,174,154,90,131,28,181,102,59,93,222,43,124,86,79,84,4,205,63,159,73,137,66,182,135,179,94,207,222,87,117,102,119,250,214,19,139,98,39,129,29,96,43,1,0,189,28,146,38,119,172,246,215,63,68,3,105,113,160,131,198,241,176,115,209,223,123,64,91,205,140,154,223,230,169,51,70,173,12,153,55,144,110,249,230,127,126,192,5,40,126,149,240,72,15,232,148,87,220,204,203,51,80,3,128,255,6,100,103,1,70,60,70,125,154,153,103,232,99,49,53,239,70,78,113,162,182,246,28,49,198,244,152,131,34,36,225,77,111,223,176,155,218,8,128,133,207,179,197,246,68,145,121,5,197,217,76,93,90,204,243,5,79,220,52,95,197,154,188,148,234,155,116,131,167,188,148,101,77,213,188,212,205,190,252,253,63,214,78,69,246,100,251,184,240,143,33,148,137,190,84,242,234,168,153,94,51,170,248,107,205,84,86,85,229,88,192,169,86,245,122,151,123,228,163,182,111,149,197,77,129,0,43,247,100,111,85,2,93,129,209,89,18,50,188,61,243,74,61,7,9,167,151,75,57,205,129,253,77,114,240,67,213,112,21,138,136,100,13,115,224,65,200,61,107,57,14,110,49,7,31,226,225,144,6,182,228,86,72,102,144,177,228,111,8,37,79,81,166,79,248,195,90,8,104,28,54,97,225,30,242,50,170,196,87,143,65,198,203,129,129,136,188,169,126,4,131,24,253,248,1,238,159,252,0,224,246,75,177,174,169,175,143,246,134,205,44,143,72,23,100,22,134,250,114,157,123,234,16,57,232,131,146,175,239,35,204,182,137,173,70,72,219,207,150,60,35,34,89,83,96,105,28,55,221,56,90,202,18,65,65,143,47,77,215,255,171,114,148,6,11,120,221,147,59,189,49,73,217,77,233,219,7,127,73,216,216,225,30,235,221,215,126,101,85,143,51,84,34,46,143,23,119,161,255,1,114,47,68,248,141,32,34,112,130,74,215,120,155,163,195,10,16,150,225,61,16,20,237,59,91,134,177,34,51,39,116,5,206,10,180,46,166,94,90,160,246,128,46,115,110,12,161,73,242,52,102,66,127,47,27,3,8,64,136,108,188,42,126,200,45,90,61,119,195,200,253,75,226,114,196,93,78,230,35,132,80,164,149,185,206,160,31,130,241,118,158,152,152,77,138,136,123,183,169,156,138,139,187,168,20,159,172,125,114,71,116,235,75,214,184,238,18,147,124,22,98,101,74,0,35,190,27,184,216,2,78,192,198,255,123,205,233,80,206,80,237,237,170,152,28,127,128,121,224,72,19,199,117,84,81,243,174,148,247,108,127,232,255,31,118,97,159,71,226,242,151,82,200,8,161,238,87,6,85,107,91,238,46,127,210,145,224,90,218,92,72,132,111,176,211,239,74,110,5,152,242,110,63,233,40,202,205,50,138,213,15,228,191,17,81,29,103,60,187,136,127,229,17,111,180,251,93,216,202,41,111,29,24,149,153,138,84,22,54,234,237,68,184,27,221,124,75,166,103,128,38,75,213,132,59,250,153,32,228,194,0,131,169,66,223,87,119,124,175,176,6,241,118,179,33,177,86,44,113,116,144,144,207,161,249,113,28,30,96,186,138,110,118,218,127,190,172,101,159,173,112,247,215,203,104,162,253,77,121,129,137,118,53,249,178,167,143,9,192,70,35,205,243,211,128,219,235,73,239,213,90,188,207,98,57,165,139,18,57,165,175,211,138,74,214,200,200,194,117,158,232,152,237,206,206,28,215,175,132,193,90,19,251,255,247,93,70,34,144,182,251,169,253,214,55,149,100,36,217,83,21,176,126,194,39,13,201,66,185,9,141,219,70,250,239,126,20,227,161,247,24,121,144,118,199,10,248,32,132,173,193,171,11,167,157,238,30,70,219,51,216,23,245,60,161,210,224,242,254,137,245,219,149,124,181,142,65,208,224,89,236,167,249,234,68,67,31,175,64,121,35,176,184,185,58,88,226,21,240,167,167,237,141,222,120,30,49,79,230,215,97,196,125,57,121,20,85,33,214,38,108,178,239,209,35,89,161,242,0,141,40,101,51,202,192,124,10,240,204,249,127,13,59,16,56,224,237,160,132,126,1,70,59,28,174,78,13,23,128,224,14,54,208,229,255,235,5,134,114,208,46,51,195,17,233,60,75,198,155,227,67,132,160,187,154,80,29,20,111,137,103,234,101,195,105,133,116,143,65,31,117,233,159,103,191,160,83,208,92,112,107,168,59,65,8,21,46,89,223,29,202,8,98,116,80,81,111,136,49,199,44,219,81,7,37,7,118,114,142,205,197,148,186,193,38,189,97,201,231,13,83,44,110,165,17,129,7,235,103,179,10,164,214,209,131,227,188,152,250,132,172,10,217,91,14,92,223,95,15,109,147,238,97,147,120,227,152,174,75,185,37,169,234,72,68,204,83,126,236,80,95,3,189,152,170,168,111,237,155,70,98,194,13,38,211,147,8,175,183,47,122,124,128,61,175,204,97,236,48,129,41,65,171,68,237,92,98,104,218,152,6,104,220,145,233,177,124,17,250,143,34,248,121,124,11,200,133,117,133,35,18,80,55,178,121,59,103,126,70,172,241,136,189,233,230,165,147,143,231,222,16,74,130,249,215,39,254,66,133,1,181,189,30,11,133,97,21,191,111,126,28,34,91,187,202,3,72,8,150,99,191,243,71,114,85,152,192,136,70,11,97,123,56,69,163,77,244,17,115,212,211,248,66,244,28,163,51,147,138,116,154,28,71,209,130,212,39,54,139,204,18,177,81,166,170,219,214,83,84,159,63,36,84,210,30,196,181,67,27,74,163,59,203,195,16,46,186,140,118,142,140,59,148,226,233,205,230,76,208,70,184,143,164,12,171,116,32,162,152,90,7,188,186,106,28,153,94,219,164,129,129,136,194,36,94,110,89,29,208,33,204,233,50,171,32,68,216,67,249,33,246,144,254,229,207,207,41,191,121,198,227,190,157,199,18,147,177,79,79,162,205,112,196,50,27,242,52,99,174,14,167,81,131,49,197,157,83,48,62,98,24,221,143,254,91,186,174,120,155,55,2,100,87,201,57,255,40,27,111,39,32,176,171,210,228,239,93,216,179,22,223,218,31,228,189,55,73,0,38,6,92,150,241,34,113,223,22,85,134,223,76,26,110,239,253,92,232,94,192,253,169,37,100,15,112,0,115,218,185,74,237,232,56,10,164,195,60,131,11,18,228,173,165,216,156,176,99,50,121,87,139,244,69,169,50,163,3,136,196,24,174,103,244,230,25,166,100,92,189,153,73,166,246,222,100,66,181,130,51,197,252,61,236,55,174,146,81,125,243,164,158,105,139,168,224,120,204,13,141,22,86,87,220,169,169,178,8,226,152,70,58,10,100,99,236,84,109,23,83,89,222,6,15,32,82,137,110,34,109,20,77,115,70,140,127,92,219,27,143,60,56,151,187,101,75,111,141,178,7,105,195,31,66,122,144,205,15,252,86,214,206,47,65,14,90,117,22,252,171,28,164,193,239,142,87,203,201,35,185,60,62,88,0,97,194,20,26,203,69,122,63,235,80,236,7,105,29,90,223,145,44,32,62,37,250,45,180,62,130,54,93,179,20,29,152,251,51,225,118,58,5,87,55,133,124,138,181,28,239,191,0,153,124,239,177,214,152,94,45,209,107,99,216,60,8,207,94,231,11,175,146,174,79,254,145,57,140,146,53,146,204,211,146,88,199,53,162,109,125,30,179,138,101,198,57,217,192,252,228,114,179,172,217,88,4,14,76,67,106,20,53,215,2,109,112,122,74,232,178,87,28,208,146,128,73,156,20,211,179,200,70,129,253,224,74,13,198,121,79,112,237,135,142,61,187,48,228,37,30,224,194,135,218,238,255,24,168,67,236,250,253,206,99,68,19,239,198,213,209,81,89,86,39,125,208,202,158,26,5,167,217,17,64,179,240,199,106,98,212,44,25,219,250,251,27,87,212,240,243,112,222,0,156,137,132,199,99,97,232,117,197,197,116,67,219,112,3,210,252,38,60,40,186,219,152,180,182,206,176,114,5,158,191,80,147,242,138,195,181,4,155,229,65,94,149,181,24,244,206,63,247,243,73,113,138,132,32,156,102,30,83,70,170,32,87,222,175,214,157,144,63,140,32,31,129,125,92,175,205,118,116,39,222,110,102,208,129,30,53,80,215,247,17,165,249,78,19,145,73,180,73,134,12,69,200,132,169,104,61,163,73,64,139,70,152,45,97,23,163,244,122,8,37,67,158,207,255,12,144,206,70,135,199,132,95,215,180,55,241,98,35,240,132,152,157,190,245,208,136,206,251,226,32,183,114,193,137,120,139,54,102,159,17,108,65,237,233,92,144,192,0,145,144,210,122,179,118,233,242,156,117,52,161,231,236,246,222,215,145,47,61,49,70,229,254,75,119,222,134,165,232,54,37,91,163,233,229,179,245,244,145,26,247,163,141,104,188,248,239,78,120,208,210,46,41,169,107,30,44,169,99,240,240,73,182,80,227,38,64,68,97,20,125,80,95,56,51,187,20,177,222,253,61,19,179,63,39,170,105,204,247,171,157,101,198,251,137,89,177,252,87,213,66,81,6,150,154,20,177,191,59,26,65,7,163,72,201,102,106,3,131,196,164,156,98,73,1,34,48,7,166,195,42,118,14,132,0,71,101,191,197,48,104,167,87,250,27,74,60,183,196,47,30,182,188,157,18,58,35,182,221,22,77,162,36,225,26,178,156,154,26,162,142,6,214,10,228,197,111,82,232,167,90,158,99,16,236,184,252,70,8,118,203,100,241,146,44,242,176,202,173,31,233,102,248,123,31,211,78,252,105,202,195,234,60,127,191,74,89,164,135,47,174,104,216,94,55,13,72,244,94,118,57,101,64,88,79,6,2,0,219,12,255,176,189,39,59,229,125,155,236,100,146,203,169,185,140,114,236,95,20,47,172,160,242,101,143,17,68,227,99,138,200,81,169,34,61,85,155,152,114,114,97,11,19,76,155,206,229,149,115,47,149,29,5,185,230,119,31,23,32,112,16,155,77,169,173,130,96,121,194,109,94,1,97,217,20,252,139,202,49,1,142,247,32,148,219,216,166,113,68,135,218,242,178,145,28,161,95,99,148,8,111,14,100,224,47,76,167,29,181,27,122,152,8,205,7,236,68,119,189,142,15,48,152,191,104,126,44,111,0,41,37,39,223,147,182,83,77,89,168,211,205,121,218,210,33,159,164,202,64,89,103,238,249,90,70,158,103,8,81,104,22,141,69,2,147,56,124,112,105,51,60,140,215,40,148,19,151,233,145,94,191,98,225,95,57,113,32,244,236,86,52,95,49,183,143,83,61,60,142,54,67,100,175,7,6,85,56,186,122,246,123,127,90,151,132,254,176,168,48,101,27,168,179,239,144,48,217,99,231,190,14,228,102,133,62,15,229,73,204,44,220,50,255,181,183,101,45,44,245,211,54,50,105,219,10,111,132,20,229,227,174,74,174,178,97,251,249,53,186,116,201,66,230,151,252,196,199,116,83,129,203,12,206,226,252,47,7,188,19,54,169,49,135,184,250,248,233,131,242,190,49,246,28,72,127,49,226,178,245,235,5,182,223,45,2,34,244,213,178,110,63,53,146,110,44,102,147,123,131,159,153,179,154,204,8,37,77,93,253,103,218,123,33,186,162,171,215,163,100,241,87,38,222,184,148,186,224,155,107,22,248,251,44,241,229,120,209,171,74,1,21,70,16,2,239,48,127,202,225,42,74,41,114,23,184,29,54,103,230,179,149,221,184,149,165,37,124,227,224,37,100,168,16,45,255,191,240,135,7,226,237,181,127,109,125,239,0,99,13,171,152,182,222,94,38,133,129,178,67,254,90,9,19,39,29,221,237,200,5,4,11,26,70,173,121,25,94,49,9,101,7,247,22,248,250,21,178,125,38,84,24,226,74,104,133,160,222,210,6,88,48,29,207,227,212,206,126,228,51,38,141,66,90,77,214,215,212,156,112,168,94,190,5,133,204,166,186,222,109,11,249,150,255,49,214,90,77,198,122,211,162,44,210,132,53,44,88,192,89,58,133,12,29,168,105,211,255,88,30,214,80,69,219,98,125,255,121,224,0,231,55,162,190,104,145,5,83,117,194,104,83,175,143,214,122,143,59,123,127,109,74,133,100,165,220,245,12,251,170,4,13,139,148,254,11,45,208,66,5,30,181,10,64,21,55,34,95,141,171,60,215,230,11,146,36,68,92,146,30,107,228,60,38,138,203,163,115,90,238,189,17,116,59,191,122,53,32,237,242,30,43,123,161,50,1,163,211,97,215,247,32,22,183,188,223,60,169,245,241,173,232,237,96,103,42,176,201,116,185,75,232,151,96,17,5,40,219,167,73,1,42,217,126,221,254,151,34,59,102,62,247,53,8,54,118,97,223,25,153,250,77,72,116,156,101,248,82,199,201,195,128,28,133,49,239,97,23,195,78,118,243,149,165,196,171,136,246,67,97,112,230,47,39,236,185,120,66,183,157,19,88,214,35,236,151,110,41,247,44,74,76,224,110,29,57,153,42,8,171,145,220,109,185,198,191,254,225,2,105,255,20,185,86,254,139,212,195,231,63,54,74,246,172,12,4,87,168,130,77,67,44,156,92,226,181,38,167,67,59,238,53,74,27,101,61,183,62,165,159,65,96,189,194,228,98,54,32,107,195,225,194,153,70,187,133,75,145,89,119,51,174,202,68,177,201,107,76,250,36,230,118,26,238,139,144,87,135,40,53,220,171,215,51,181,26,20,16,72,148,100,120,203,103,123,94,30,205,198,18,193,111,2,219,238,100,108,26,17,244,81,230,138,236,184,26,155,214,42,25,44,242,222,32,121,113,32,44,221,114,182,57,101,150,125,87,114,16,185,199,255,110,59,43,96,139,36,16,55,3,25,2,219,164,180,142,27,86,130,170,242,3,217,250,187,243,207,217,227,128,120,213,65,193,210,92,3,40,192,23,199,154,232,68,8,146,254,94,43,125,129,18,191,171,2,187,249,203,145,76,3,40,157,151,36,0,81,167,241,205,78,126,217,28,5,125,249,204,84,59,221,124,191,205,132,141,97,171,28,50,56,75,141,254,125,149,169,131,247,115,135,7,195,214,181,62,191,204,228,180,169,120,220,13,100,249,208,228,196,159,183,5,137,63,12,37,94,67,250,98,204,78,23,142,193,106,21,158,134,147,31,44,58,241,192,68,119,52,254,197,56,225,9,161,66,37,99,54,45,223,107,41,59,63,169,73,187,31,196,110,20,51,225,121,12,34,204,27,33,0,128,156,42,91,62,19,244,64,74,207,148,36,249,39,127,148,32,59,250,33,137,171,97,7,109,198,108,175,208,110,54,169,11,109,178,213,9,38,65,98,130,51,104,115,20,238,117,228,252,109,9,206,234,148,115,173,205,16,171,22,17,243,202,39,98,240,158,192,97,152,219,217,153,94,68,22,214,184,94,82,204,218,39,225,90,22,254,64,245,192,166,80,0,174,164,101,247,104,172,217,253,6,88,133,114,99,27,17,227,84,43,182,187,138,12,28,141,98,131,203,36,248,76,221,84,208,210,146,40,196,41,162,218,225,227,79,56,171,253,186,70,74,213,217,96,124,27,70,248,5,81,123,165,227,36,65,101,80,66,192,239,197,124,209,187,78,246,94,174,114,230,121,5,77,158,33,23,158,235,124,37,248,95,152,246,101,7,129,147,82,79,215,180,13,244,162,213,198,157,191,121,123,48,98,59,30,28,93,197,61,219,113,87,36,72,181,105,100,233,197,3,90,160,205,178,131,117,246,77,131,172,249,255,91,154,158,39,222,167,43,157,18,146,3,170,115,166,13,107,40,42,79,200,137,118,58,6,58,47,188,66,181,188,7,166,41,18,67,73,147,224,48,92,246,115,190,66,144,92,64,24,23,234,63,139,241,180,24,39,112,75,31,32,171,86,140,190,136,157,79,21,253,110,203,244,0,149,204,136,208,51,3,215,201,127,93,239,41,232,68,98,214,100,22,232,115,74,44,177,204,43,36,212,16,134,126,53,60,89,9,82,222,189,36,53,169,22,244,219,198,132,34,78,45,162,152,207,251,147,205,102,214,250,241,19,191,28,46,241,252,242,244,23,56,41,208,143,82,220,175,68,248,119,127,211,55,88,222,124,230,172,213,59,236,92,75,94,181,187,71,65,163,142,211,162,132,141,191,198,198,131,188,245,52,8,93,254,4,164,31,117,183,252,181,22,183,19,19,21,223,46,74,213,100,113,73,69,107,69,253,184,170,16,191,94,136,53,65,104,95,104,1,15,190,106,209,184,172,80,249,87,193,230,31,224,161,7,195,152,155,57,236,238,214,103,214,199,138,81,18,189,189,91,232,171,16,245,198,176,173,114,166,110,160,103,20,146,88,250,51,34,192,34,55,89,230,251,168,47,228,5,96,216,194,99,81,26,196,162,20,206,123,186,117,71,250,207,29,54,243,218,129,72,203,9,211,225,124,121,214,175,201,49,132,26,86,216,115,212,210,166,25,155,17,89,135,39,12,24,13,227,204,166,176,63,23,25,225,95,253,245,64,109,18,37,66,2,64,193,142,59,224,9,58,138,147,255,102,96,200,53,57,84,111,125,28,62,233,99,5,34,101,218,201,147,210,85,0,254,207,26,221,31,91,118,132,126,177,125,127,225,46,211,180,88,113,164,32,67,234,253,57,177,118,145,227,166,172,99,11,190,13,223,245,200,149,244,244,192,47,189,236,28,7,87,196,52,135,55,159,132,139,255,255,139,156,48,123,188,127,160,252,106,199,65,143,201,218,216,220,142,108,241,39,228,207,160,249,188,105,4,197,199,206,111,179,31,210,235,93,89,134,49,8,106,250,145,193,14,254,25,102,219,97,153,216,54,58,158,49,46,157,206,189,136,6,196,193,49,51,2,219,57,253,160,228,74,28,99,213,17,58,109,9,37,32,170,139,115,103,214,179,30,178,244,251,122,13,101,232,135,25,248,10,150,208,200,4,212,76,35,177,213,140,70,243,3,53,179,58,254,30,244,135,242,46,91,250,18,233,94,237,19,90,8,103,104,109,137,128,170,157,213,192,47,89,48,80,197,207,247,161,140,245,235,207,131,236,150,148,126,51,180,220,224,138,217,254,51,94,189,240,156,60,38,83,2,10,14,84,9,12,46,247,123,147,194,140,231,55,187,235,121,214,32,216,238,159,23,228,101,125,143,62,150,63,88,216,22,17,189,233,160,223,231,0,0,205,244,12,143,72,183,137,163,154,172,208,20,116,186,217,212,229,101,211,112,98,37,31,89,89,74,222,92,95,140,32,104,2,41,61,69,42,138,121,57,120,132,7,35,144,0,117,172,161,138,134,50,69,27,45,171,250,164,205,158,252,6,255,43,53,49,214,236,10,21,12,106,202,112,180,210,223,94,60,57,119,124,167,182,157,222,159,6,187,45,193,117,66,79,165,227,251,46,166,56,27,98,246,183,204,111,101,78,74,98,220,106,34,69,110,182,57,220,205,214,210,114,97,77,181,9,42,197,246,5,78,236,203,35,90,4,100,79,164,130,222,19,158,76,29,231,86,170,78,28,57,149,38,46,84,217,147,233,205,221,108,47,64,211,161,115,135,27,131,28,62,115,25,99,89,24,111,42,7,250,86,85,228,163,6,88,127,207,139,179,116,248,141,168,115,22,249,165,178,251,7,217,4,154,112,85,234,171,211,202,113,160,222,65,121,15,163,248,215,136,6,149,209,82,50,36,131,96,18,221,178,20,50,107,55,158,22,231,196,186,248,103,192,62,56,137,23,194,14,159,48,180,254,100,132,249,249,177,150,73,126,181,199,211,218,247,127,29,190,80,214,254,250,95,215,70,101,62,231,142,233,194,158,186,27,246,8,29,233,27,211,137,50,143,138,93,155,104,228,79,28,150,208,105,86,146,115,29,79,152,66,157,89,175,100,148,165},
  {219,198,187,192,191,66,84,241,220,18,22,178,189,153,166,237,190,227,123,178,23,239,31,207,187,193,210,126,59,177,174,60,219,29,193,192,47,39,25,22,54,76,233,81,1,144,0,189,221,123,46,217,214,189,203,7,46,203,214,8,163,74,104,187,61,248,198,127,103,245,198,190,161,44,182,18,82,227,40,218,166,17,33,219,2,74,197,16,47,181,20,94,199,54,205,85,187,45,112,114,233,58,129,239,131,38,235,88,44,65,63,59,216,1,3,242,42,224,113,146,200,119,176,11,208,251,23,31,247,117,97,93,63,35,88,53,245,88,205,45,30,142,216,58,118,123,101,119,132,233,54,54,213,19,42,3,225,157,90,241,21,234,25,225,162,162,6,218,16,244,162,57,207,85,83,164,92,213,79,117,174,222,198,57,49,240,55,120,2,220,95,7,29,105,156,200,47,202,78,89,11,155,26,136,154,39,76,164,202,209,194,197,129,207,120,27,224,88,177,6,106,66,155,244,183,145,78,24,140,31,174,35,118,67,94,106,208,47,195,36,130,192,61,87,36,225,201,79,103,138,58,144,231,205,104,81,57,173,110,255,67,78,236,27,102,48,125,41,8,5,251,0,109,215,8,209,253,9,209,123,226,202,188,30,215,140,165,88,255,72,14,56,237,54,135,83,88,195,198,240,1,168,106,10,71,107,18,11,163,13,130,232,236,114,146,144,3,88,154,47,245,148,99,253,102,40,167,167,119,224,200,28,219,1,22,112,87,39,20,31,103,153,143,170,118,64,213,221,154,20,106,21,175,55,255,36,82,69,26,177,120,12,99,116,253,255,180,57,193,207,107,70,28,89,239,120,97,248,190,151,49,127,17,116,28,165,141,218,180,31,166,136,222,8,227,84,90,114,133,181,247,247,61,97,143,228,71,163,45,112,31,94,43,218,22,144,224,79,3,190,163,217,146,29,101,136,41,77,159,214,69,159,102,155,248,118,250,184,254,8,29,152,72,42,42,11,241,126,33,67,54,90,229,52,98,205,120,133,208,82,4,247,53,60,120,97,60,52,217,114,39,18,116,237,245,13,232,245,172,184,62,66,42,122,62,137,93,51,122,163,48,5,121,99,186,77,70,213,168,139,163,150,186,84,145,239,56,155,78,197,251,57,163,68,234,202,53,227,197,191,15,209,235,135,229,189,129,24,128,16,122,70,134,178,113,53,19,10,92,189,64,7,60,193,42,219,172,191,100,3,168,72,181,211,173,64,233,219,11,126,52,60,89,160,3,235,89,21,229,211,225,91,172,187,254,186,50,135,121,104,107,240,151,251,159,20,130,252,179,163,220,176,178,106,198,162,173,229,114,37,198,86,96,55,11,150,231,134,55,140,193,83,182,236,66,146,66,84,170,214,107,204,201,246,2,161,205,168,107,166,134,124,155,200,38,202,217,251,4,3,74,207,220,232,214,167,220,116,204,31,93,56,215,12,245,162,35,89,152,202,107,179,183,129,134,147,89,31,75,212,242,114,207,248,79,120,158,201,116,80,191,182,159,93,62,140,196,142,36,94,156,54,116,67,141,152,148,119,57,48,53,33,97,33,124,76,147,68,194,116,206,180,161,37,231,10,16,64,243,39,166,112,92,246,79,60,106,149,225,31,196,228,125,31,208,129,205,166,223,165,92,134,43,32,228,220,68,43,160,22,162,98,165,41,219,173,43,191,194,122,196,2,35,45,219,228,125,181,252,44,64,143,242,135,122,6,25,214,237,118,29,5,102,72,12,8,89,109,19,139,225,107,191,102,125,60,119,240,70,39,28,133,70,180,181,193,168,172,159,141,7,127,65,166,242,49,215,109,78,20,152,13,140,4,48,11,0,173,128,104,16,18,19,0,201,147,18,77,206,123,123,74,180,250,152,110,81,45,67,88,103,107,124,19,16,67,83,59,242,219,92,232,113,199,168,175,63,27,127,189,65,44,110,64,106,59,76,66,181,191,191,151,16,87,126,14,234,170,40,112,86,16,156,173,82,51,118,116,242,178,219,94,242,125,90,41,200,148,240,198,131,240,246,86,238,194,203,194,152,247,41,110,152,132,37,19,10,179,124,191,58,104,26,164,116,193,17,122,147,30,122,179,245,51,33,50,16,111,196,201,161,92,93,64,27,14,254,145,82,152,80,147,168,56,184,215,245,99,122,215,180,53,98,73,221,194,112,238,182,34,62,250,44,11,80,174,249,44,178,81,164,241,247,66,29,21,210,60,30,224,152,124,90,184,102,136,169,199,151,190,49,138,207,110,93,136,55,33,26,128,214,172,28,103,123,168,196,32,249,39,168,216,91,72,73,157,103,102,41,90,228,6,179,57,76,118,39,92,137,158,239,231,8,220,149,248,239,239,236,84,184,124,149,80,206,131,243,86,220,101,107,175,105,46,218,196,7,44,240,205,91,7,93,219,218,116,158,22,72,183,67,134,232,32,247,12,136,22,233,104,219,206,171,38,243,224,32,245,141,81,26,220,95,221,147,31,223,53,61,32,107,166,174,27,208,75,109,83,219,179,2,17,149,80,107,159,239,4,74,200,18,60,174,160,191,135,143,176,160,240,124,29,85,184,62,234,144,163,18,118,95,85,168,235,70,25,240,56,80,235,214,157,203,206,69,127,62,215,12,91,25,174,67,40,17,51,204,27,17,204,166,125,9,69,89,32,186,57,196,236,154,29,225,9,60,3,171,10,12,156,176,66,108,195,135,18,146,21,47,212,221,231,96,74,15,178,208,133,127,103,203,241,95,247,45,117,29,104,21,33,72,252,83,99,161,181,29,66,99,105,68,20,223,15,149,55,249,229,202,241,131,234,194,158,92,75,218,207,175,60,146,152,28,124,138,138,53,30,32,216,7,38,58,1,46,240,79,137,193,146,59,1,146,194,50,104,157,2,91,76,100,18,242,108,18,98,83,162,3,45,184,179,161,83,150,143,198,174,149,22,132,77,9,179,125,2,253,12,70,183,201,172,170,82,56,71,123,23,136,149,29,237,13,244,98,117,255,180,94,233,9,183,121,9,67,113,254,158,158,148,113,13,5,153,7,222,105,40,118,184,237,122,67,3,243,185,233,52,125,91,99,45,7,40,11,63,126,39,91,30,199,152,104,95,193,207,162,123,212,115,188,251,105,46,233,97,116,59,159,92,195,202,10,160,241,66,116,9,176,12,27,179,32,102,26,43,247,194,129,151,0,130,54,223,86,126,251,75,231,180,155,143,89,20,148,79,55,179,254,67,61,129,29,197,143,212,169,129,246,162,102,34,14,40,213,166,97,146,81,2,233,184,151,171,60,223,136,162,92,63,120,185,219,35,136,244,118,107,76,105,164,11,49,23,52,26,26,68,1,132,140,9,13,43,236,26,170,199,1,48,12,217,136,84,96,110,39,150,189,37,21,25,115,132,250,201,196,124,69,158,247,85,96,213,151,95,227,179,126,165,192,46,199,17,25,150,110,222,204,9,76,4,242,253,149,198,45,54,72,143,78,22,150,19,79,96,17,47,10,160,46,28,139,174,48,3,107,226,205,232,163,146,79,147,145,170,8,140,211,47,168,118,227,195,224,222,194,107,102,151,72,83,131,177,134,126,93,88,167,158,87,21,164,127,160,118,146,162,194,163,208,30,169,253,255,197,124,251,65,247,56,152,109,145,188,18,96,200,213,190,162,241,138,115,14,184,157,155,255,89,189,15,18,216,202,0,125,59,41,17,193,40,151,158,215,95,188,232,29,54,89,40,227,238,114,48,127,21,255,97,153,55,121,125,86,155,78,139,169,136,205,45,160,226,147,153,196,204,209,139,146,98,102,120,43,153,138,111,215,188,248,0,203,222,81,65,206,78,88,5,42,124,11,169,122,44,107,107,89,90,212,56,173,44,16,35,106,157,209,176,41,167,83,95,146,185,216,226,180,160,114,199,243,41,124,81,56,189,92,30,61,19,148,87,93,181,189,10,218,202,85,12,224,160,229,253,255,66,192,189,91,11,222,63,151,54,150,223,30,236,227,208,175,52,81,149,122,212,204,209,223,159,122,174,187,21,128,165,159,86,49,98,182,130,89,120,235,49,126,85,164,244,224,197,64,111,232,168,211,160,181,226,52,199,246,140,117,101,228,36,180,123,229,227,113,181,175,112,109,122,21,17,39,142,230,239,60,208,177,96,229,11,24,173,32,22,221,148,144,126,137,10,74,105,245,87,154,103,60,143,108,1,1,178,196,27,14,28,46,5,225,239,214,201,160,200,132,146,218,54,39,29,100,155,36,203,134,221,71,214,134,24,166,80,107,22,88,27,76,89,69,137,230,29,112,141,184,102,103,238,104,74,106,210,54,185,200,36,229,172,145,49,122,83,29,16,103,109,188,40,11,240,130,210,130,108,204,254,86,65,211,89,31,220,213,93,222,226,127,199,230,233,184,11,253,152,57,20,163,78,205,55,26,185,226,52,49,102,167,134,180,123,7,218,160,23,52,99,163,130,32,223,44,25,10,142,80,4,198,103,79,80,183,200,129,27,83,177,187,107,231,238,4,228,62,5,92,147,249,238,13,127,126,100,206,33,192,74,74,107,41,245,118,143,245,150,186,86,119,142,157,13,215,27,237,70,175,28,186,61,65,218,70,134,167,99,165,105,201,97,241,166,117,237,36,95,17,107,114,202,54,218,96,116,21,121,37,198,13,56,186,109,143,69,87,104,113,201,88,68,192,230,119,213,91,77,54,25,143,214,152,117,197,3,184,219,121,35,154,18,172,29,216,97,244,32,153,43,110,76,117,0,104,112,82,26,162,230,84,247,172,153,168,215,193,211,95,48,139,160,75,240,182,238,207,247,215,183,149,139,217,204,215,20,130,204,54,190,30,56,148,162,90,60,189,245,189,170,63,108,239,80,222,66,84,252,254,233,106,58,193,141,178,166,44,85,1,203,22,209,71,179,168,25,248,254,161,194,210,255,58,248,71,89,85,114,70,111,239,138,56,118,63,118,102,34,161,224,164,7,86,41,4,60,175,78,184,239,14,62,83,105,4,122,147,190,179,222,94,5,192,14,81,38,235,221,128,59,205,186,223,96,187,150,95,87,48,57,195,237,230,195,49,38,49,68,18,56,175,95,2,208,211,70,238,164,10,204,202,184,83,14,143,245,63,118,194,206,186,68,178,164,140,245,40,168,247,52,250,220,150,202,63,57,202,221,194,89,107,185,144,26,246,116,134,164,45,125,134,53,106,53,25,226,163,251,166,137,206,134,122,217,33,152,206,156,248,69,252,82,164,228,105,176,27,31,202,46,16,205,153,221,154,1,95,92,36,126,80,219,66,26,2,149,209,104,153,85,33,102,214,194,168,82,119,24,116,65,148,139,253,186,40,196,95,155,154,250,109,197,164,139,168,165,93,12,8,92,124,189,201,162,29,112,49,120,200,251,114,124,96,171,72,83,8,8,242,185,127,228,214,35,33,134,99,169,119,221,95,15,19,113,46,144,88,210,145,212,97,66,117,185,206,244,108,246,159,24,187,145,137,177,116,50,29,172,76,92,177,221,181,154,220,241,132,209,37,73,136,71,17,151,58,7,111,21,34,103,58,43,65,249,41,194,25,191,138,2,14,201,209,40,138,241,76,130,117,190,50,70,17,68,24,9,178,235,222,64,205,226,221,55,222,255,149,214,52,101,150,73,241,199,171,225,112,91,56,126,30,122,141,110,157,175,14,131,229,197,77,218,124,200,68,7,233,39,68,182,82,143,249,98,22,163,61,68,14,205,18,120,64,54,223,39,199,108,43,135,19,137,240,248,29,29,59,77,226,145,66,2,152,244,197,222,202,249,157,222,174,114,224,34,126,168,144,233,14,124,242,166,123,126,178,41,129,167,240,242,45,34,120,169,79,161,220,185,133,162,209,10,192,51,134,209,146,218,240,182,182,128,203,130,171,93,229,67,216,133,168,4,112,5,50,33,12,76,204,236,141,176,69,70,202,111,191,56,45,77,165,191,240,193,118,30,86,152,186,222,63,156,23,162,175,105,24,101,66,131,107,122,88,41,149,251,223,179,78,135,253,7,122,98,18,153,4,132,60,159,23,184,200,78,91,189,36,237,218,249,74,184,75,147,119,180,67,85,70,4,30,97,57,97,12,207,115,5,252,211,97,235,236,155,167,180,241,54,59,237,16,159,140,130,22,186,24,42,175,234,21,142,137,30,169,2,106,172,156,214,87,37,137,91,245,33,150,16,188,50,121,204,218,17,101,53,201,226,144,37,233,248,194,142,110,208,222,204,210,244,2,11,46,225,215,37,44,245,96,61,74,183,230,24,167,67,0,16,198,182,99,196,162,8,33,131,173,18,178,53,165,98,30,227,249,171,57,38,6,98,223,163,146,37,12,176,120,85,11,232,42,22,93,54,57,150,31,10,105,55,112,51,220,114,149,56,22,176,133,6,178,130,160,210,218,201,232,27,66,187,112,190,14,243,227,68,7,124,193,246,217,156,95,154,100,131,11,167,95,93,145,215,149,169,14,10,169,178,31,48,249,94,247,222,64,136,178,132,120,131,171,141,223,250,156,20,210,105,238,20,210,137,22,131,228,237,194,34,247,90,252,43,184,101,146,218,32,97,93,16,89,183,93,211,215,188,193,62,8,155,5,34,102,156,226,23,138,240,241,202,93,228,116,37,185,108,187,120,199,228,36,167,201,190,20,22,27,47,34,17,81,46,0,202,151,201,113,185,157,117,83,219,246,119,155,2,12,203,96,43,252,165,240,123,21,141,164,104,107,183,240,211,81,124,196,210,64,133,185,132,246,179,7,44,79,37,199,148,91,128,56,10,145,33,30,237,242,184,208,194,90,182,91,162,241,121,238,238,102,27,113,135,217,63,37,0,252,231,216,242,31,12,192,40,246,134,175,182,215,92,55,231,246,194,221,35,109,1,10,226,109,180,70,44,101,85,121,108,72,201,123,183,6,13,79,130,255,192,146,213,72,126,58,120,186,170,44,85,222,253,193,73,232,128,52,114,51,28,177,44,88,63,157,32,105,142,205,223,127,230,98,199,241,163,209,163,125,130,92,205,120,1,70,114,210,6,196,227,104,136,151,177,45,120,149,73,155,246,116,160,75,153,136,31,216,189,115,15,23,120,26,229,121,205,205,55,108,246,140,200,202,164,116,34,92,126,112,34,9,87,85,24,131,5,179,254,170,168,79,92,23,145,75,9,112,239,87,82,209,179,126,147,200,145,244,231,187,125,160,2,51,99,198,67,176,220,176,96,70,110,127,113,98,51,207,83,119,220,214,226,225,143,73,192,59,75,239,166,249,136,205,64,167,64,12,209,198,11,254,232,204,230,70,122,204,98,146,218,214,199,173,141,246,216,165,149,176,148,163,60,149,189,188,59,132,252,13,210,28,141,86,124,101,62,237,168,41,239,220,168,193,85,57,167,91,103,105,38,68,175,152,69,104,176,170,118,134,69,150,8,72,212,237,218,43,217,91,134,228,156,190,240,158,25,147,137,253,221,207,28,238,210,170,195,83,238,120,186,113,248,114,185,101,94,39,144,42,254,30,175,122,80,24,69,49,172,215,73,124,148,203,97,163,208,0,39,2,129,161,47,107,9,150,172,47,162,107,149,55,57,211,133,159,7,126,220,28,5,229,134,219,52,217,129,174,251,2,83,200,249,158,145,132,158,180,121,120,23,19,74,205,75,14,218,133,216,46,47,13,172,194,167,26,75,6,214,30,169,47,30,251,84,23,129,71,154,219,175,43,86,78,231,65,115,39,89,248,163,151,110,54,84,85,4,49,80,154,18,13,223,164,72,130,212,80,25,250,239,45,232,94,252,171,169,97,91,189,120,59,85,196,29,60,87,222,239,3,141,181,189,83,132,158,67,201,232,162,0,149,161,221,128,121,80,177,63,168,236,242,61,31,234,164,96,56,75,180,127,204,188,138,27,140,224,245,10,210,137,235,48,12,56,233,241,50,44,102,42,197,185,14,23,28,14,53,144,60,111,167,233,128,21,88,171,146,214,95,91,88,213,21,3,183,205,42,210,213,156,184,173,163,254,13,175,194,56,223,140,64,25,173,196,177,83,212,107,234,80,242,63,91,33,80,218,213,175,32,255,203,183,88,242,186,43,149,18,18,245,195,197,177,240,172,118,165,102,231,0,71,106,111,132,53,253,90,73,252,202,87,252,252,156,157,70,56,47,255,144,122,77,167,222,140,166,84,84,182,164,102,0,51,54,8,216,15,147,44,160,186,12,87,54,23,188,136,159,108,209,12,243,36,250,56,57,130,107,39,85,158,229,198,134,175,55,53,31,177,118,169,218,36,138,84,131,4,146,26,181,151,107,187,220,209,38,241,240,28,51,245,35,143,229,64,70,110,94,146,129,229,241,141,195,200,3,98,33,40,190,160,0,101,159,188,169,53,141,167,4,222,151,4,252,110,192,63,173,36,205,180,19,61,237,246,44,41,65,152,88,74,215,14,33,33,133,22,143,238,39,120,246,24,103,225,144,13,209,68,171,81,140,90,150,56,55,36,78,187,28,121,209,0,211,23,197,37,191,31,110,31,224,66,36,12,157,30,120,183,182,81,67,4,114,134,115,156,60,210,192,180,230,60,237,39,79,170,167,86,102,109,253,147,86,121,91,130,44,110,177,197,124,240,175,29,242,155,12,214,222,213,22,203,146,22,80,197,146,185,238,14,73,224,113,135,23,198,20,116,199,149,1,29,76,176,101,88,51,87,160,140,34,124,25,229,158,81,246,215,144,233,67,117,39,48,80,153,73,79,233,40,180,200,130,231,91,251,188,201,135,119,20,218,161,202,11,12,157,214,204,30,245,166,96,27,195,155,100,249,250,89,217,249,202,159,211,252,177,60,97,116,238,135,226,221,145,106,248,196,153,89,74,83,174,27,121,41,90,77,51,76,226,189,223,107,251,125,69,167,162,101,198,252,11,115,215,133,70,7,167,39,183,57,244,18,49,33,50,112,85,208,50,205,174,247,211,122,169,34,197,185,2,43,126,143,13,137,243,2,159,106,245,172,59,91,235,41,5,203,165,248,11,180,181,146,21,36,139,171,165,232,133,200,63,115,55,178,20,150,0,214,15,166,224,228,120,36,184,43,147,23,52,148,204,11,2,81,229,141,34,163,126,141,252,40,74,167,249,153,230,106,48,180,215,40,156,108,253,228,224,18,108,243,118,28,248,44,218,179,145,193,159,231,141,42,229,129,11,21,3,154,5,50,184,236,103,74,115,25,29,215,24,171,231,117,207,110,62,202,88,158,143,169,234,175,200,244,165,122,236,153,167,63,106,31,129,48,84,7,204,159,172,30,184,25,199,76,141,243,221,161,2,5,76,182,214,240,208,34,160,49,77,56,45,91,202,23,26,1,32,217,158,34,39,176,213,210,216,183,69,110,161,39,228,42,171,29,9,92,11,185,84,1,229,115,135,194,51,114,234,67,177,29,98,49,83,104,148,167,124,187,198,218,22,6,162,124,182,244,136,38,61,68,72,230,156,119,85,243,166,18,122,47,124,210,140,6,183,233,195,136,99,38,179,241,31,121,246,42,161,214,200,159,113,18,193,59,12,177,181,210,77,217,177,127,247,61,156,126,115,35,199,102,206,226,148,218,111,6,106,78,195,41,186,235,182,81,187,126,134,51,146,181,155,255,120,13,5,20,122,57,73,151,59,197,203,8,240,146,87,205,109,52,81,30,223,239,106,154,81,95,200,232,226,19,62,49,226,216,145,107,83,79,183,111,109,248,72,41,204,195,100,138,71,165,41,84,212,169,37,24,114,139,98,172,42,25,197,7,238,85,31,222,76,144,60,66,242,49,15,126,136,178,249,96,233,21,82,128,90,163,120,119,238,108,12,56,127,229,189,13,107,31,251,86,50,250,183,84,76,44,95,215,235,178,11,133,25,223,40,144,68,57,134,115,107,179,213,48,35,148,26,91,190,83,55,146,64,29,99,87,241,245,169,241,153,29,42,169,206,158,148,219,247,185,84,118,13,79,225,115,117,26,159,192,120,60,21,107,179,149,148,118,215,213,133,239,144,130,197,169,94,123,82,108,75,131,159,146,134,152,14,86,173,47,7,46,130,142,17,116,77,27,35,37,101,117,5,57,167,16,232,97,116,183,203,19,254,66,126,242,195,65,103,178,33,222,40,223,48,41,210,47,100,12,48,225,195,128,47,200,221,159,102,234,69,159,191,171,104,185,42,141,90,203,240,52,246,138,28,236,57,181,66,29,143,116,199,5,18,99,28,215,19,9,29,155,95,95,47,251,34,124,160,170,54,185,131,34,17,10,216,168,134,206,145,222,67,199,194,108,235,43,72,218,48,26,142,184,54,158,208,130,178,86,109,211,107,33,73,141,85,202,112,112,169,56,200,114,173,165,48,154,236,36,193,170,54,43,185,250,200,184,2,156,233,191,16,132,18,249,195,40,208,250,31,235,221,114,166,211,237,96,10,108,148,193,190,158,14,114,123,145,5,23,212,217,195,84,235,189,169,21,125,28,145,105,74,72,0,13,94,166,3,84,43,131,240,85,21,233,205,244,204,246,216,45,233,129,225,139,141,171,83,36,185,156,216,99,206,195,148,221,141,79,77,253,147,27,105,44,96,73,45,132,13,65,251,92,150,134,91,36,246,190,171,76,155,78,136,97,18,25,102,73,134,195,0,124,129,210,228,28,85,41,132,30,246,166,196,162,69,177,67,153,63,198,20,86,147,57,123,127,132,223,252,156,82,132,240,160,108,60,36,98,22,127,19,104,188,53,23,90,199,103,10,84,180,210,34,17,195,37,80,199,191,90,87,156,107,214,146,57,171,37,200,165,156,137,93,210,124,92,236,7,112,48,199,244,79,184,80,15,128,27,8,35,204,249,156,143,144,236,207,14,113,88,102,223,236,187,137,241,100,135,130,118,64,194,38,192,155,233,227,214,239,40,95,96,170,226,85,166,181,237,225,131,50,35,114,80,153,5,119,2,114,185,44,206,181,102,27,215,77,42,181,3,125,248,85,80,28,152,106,104,180,178,218,111,13,219,116,236,156,21,108,36,91,231,200,45,113,154,132,180,134,46,131,192,231,77,235,54,97,90,43,144,168,80,48,246,153,220,112,63,80,111,163,27,14,79,34,77,164,148,109,64,113,227,132,88,72,39,163,72,106,139,217,69,39,102,230,61,73,250,107,157,48,222,17,52,58,203,134,72,107,245,53,183,180,68,51,228,43,28,5,184,35,238,205,140,212,150,255,163,143,41,99,108,8,186,210,82,177,46,202,211,2,106,10,114,164,83,161,38,249,251,9,108,51,241,122,84,229,156,234,148,57,41,100,44,13,159,27,60,126,57,242,239,105,222,197,222,49,139,25,130,105,218,127,49,99,29,187,158,2,65,8,111,182,246,153,19,34,204,218,253,207,177,24,138,231,192,151,252,63,91,178,33,247,117,202},
} ;

static void test_decode_1277xint32_impl(long long impl)
{
  unsigned char *x = test_decode_1277xint32_x;
  unsigned char *s = test_decode_1277xint32_s;
  unsigned char *x2 = test_decode_1277xint32_x2;
  unsigned char *s2 = test_decode_1277xint32_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_1277xint32_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_1277xint32(impl);
    printf("decode_1277xint32 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1277xint32_implementation(impl),ntruprime_dispatch_decode_1277xint32_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_1277xint32;
    printf("decode_1277xint32 selected implementation %s compiler %s\n",ntruprime_decode_1277xint32_implementation(),ntruprime_decode_1277xint32_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_1277xint32_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_1277xint32_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_1277xint32_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_1277xint32_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_1277xint32_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_1277xint32_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_1277xint32(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1277xint32")) return;
  storage_decode_1277xint32_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_1277xint32_x = aligned(storage_decode_1277xint32_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_1277xint32_s = callocplus(crypto_decode_STRBYTES);
  test_decode_1277xint32_s = aligned(storage_decode_1277xint32_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_1277xint32_x2 = callocplus(maxalloc);
  test_decode_1277xint32_x2 = aligned(storage_decode_1277xint32_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_1277xint32_s2 = callocplus(maxalloc);
  test_decode_1277xint32_s2 = aligned(storage_decode_1277xint32_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_1277xint32 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_1277xint32();++impl)
      forked(test_decode_1277xint32_impl,impl);
    ++test_decode_1277xint32_x;
    ++test_decode_1277xint32_s;
    ++test_decode_1277xint32_x2;
    ++test_decode_1277xint32_s2;
  }
  free(storage_decode_1277xint32_s2);
  free(storage_decode_1277xint32_x2);
  free(storage_decode_1277xint32_s);
  free(storage_decode_1277xint32_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

