/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Lognormal distribution mode.
*
* @module @stdlib/stats/base/dists/lognormal/mode
*
* @example
* var mode = require( '@stdlib/stats/base/dists/lognormal/mode' );
*
* var y = mode( 0.0, 1.0 );
* // returns ~0.368
*
* y = mode( 4.0, 2.0 );
* // returns 1.0
*/

// MODULES //

var mode = require( './mode.js' );


// EXPORTS //

module.exports = mode;
