'use strict';

module.exports = exports = function (t, a) { exports.tests(t, a); };

var data = exports.data = [[['.', 'x/b', '..', '/b/c.js'], 'x/b/c.js'],
	[['/.', 'x/b', '..', '/b/c.js'], '/x/b/c.js'],
	[['/foo', '../../../bar'], '/bar'],
	[['foo', '../../../bar'], '../../bar'],
	[['foo/', '../../../bar'], '../../bar'],
	[['foo/x', '../../../bar'], '../bar'],
	[['foo/x', './bar'], 'foo/x/bar'],
	[['foo/x/', './bar'], 'foo/x/bar'],
	[['foo/x/', '.', 'bar'], 'foo/x/bar'],
	[['./'], './'],
	[['.', './'], './'],
	[['.', '.', '.'], '.'],
	[['.', './', '.'], '.'],
	[['.', '/./', '.'], '.'],
	[['.', '/////./', '.'], '.'],
	[['.'], '.'],
	[['', '.'], '.'],
	[['', 'foo'], 'foo'],
	[['foo', '/bar'], 'foo/bar'],
	[['', '/foo'], '/foo'],
	[['', '', '/foo'], '/foo'],
	[['', '', 'foo'], 'foo'],
	[['foo', ''], 'foo'],
	[['foo/', ''], 'foo/'],
	[['foo', '', '/bar'], 'foo/bar'],
	[['./', '..', '/foo'], '../foo'],
	[['./', '..', '..', '/foo'], '../../foo'],
	[['.', '..', '..', '/foo'], '../../foo'],
	[['', '..', '..', '/foo'], '../../foo'],
	[['/'], '/'],
	[['/', '.'], '/'],
	[['/', '..'], '/'],
	[['/', '..', '..'], '/'],
	[[''], '.'],
	[['', ''], '.'],
	[[' /foo'], ' /foo'],
	[[' ', 'foo'], ' /foo'],
	[[' ', '.'], ' '],
	[[' ', '/'], ' /'],
	[[' ', ''], ' '],
	[['/', 'foo'], '/foo'],
	[['/', '/foo'], '/foo'],
	[['/', '//foo'], '/foo'],
	[['/', '', '/foo'], '/foo'],
	[['', '/', 'foo'], '/foo'],
	[['', '/', '/foo'], '/foo']];

exports.tests = function (t, a) {
	data.forEach(function (test, i) {
		a(t.apply(null, test[0]), test[1], i);
	});
};
