// Package models contains the types for schema 'public'.
package models

// Code generated by xo. DO NOT EDIT.

import (
	"database/sql"
)

// SlaveHosts10 represents a row from '[custom slave_hosts10]'.
type SlaveHosts10 struct {
	ApplicationName sql.NullString  // application_name
	ClientAddr      sql.NullString  // client_addr
	State           sql.NullString  // state
	ByteLag         sql.NullFloat64 // byte_lag
}

// GetSlaveHosts10s runs a custom query, returning results as SlaveHosts10.
func GetSlaveHosts10s(db XODB) ([]*SlaveHosts10, error) {
	var err error

	// sql query
	var sqlstr = `SELECT application_name, client_addr, state, sent_offset - (replay_offset - (sent_lsn - replay_lsn) * 255 * 16 ^ 6 ) AS byte_lag ` +
		`FROM ( SELECT application_name, client_addr, client_hostname, state, ` +
		`('x' || lpad(split_part(sent_lsn::TEXT,   '/', 1), 8, '0'))::bit(32)::bigint AS sent_lsn, ` +
		`('x' || lpad(split_part(replay_lsn::TEXT, '/', 1), 8, '0'))::bit(32)::bigint AS replay_lsn, ` +
		`('x' || lpad(split_part(sent_lsn::TEXT,   '/', 2), 8, '0'))::bit(32)::bigint AS sent_offset, ` +
		`('x' || lpad(split_part(replay_lsn::TEXT, '/', 2), 8, '0'))::bit(32)::bigint AS replay_offset ` +
		`FROM pg_stat_replication ) AS s`

	// run query
	XOLog(sqlstr)
	q, err := db.Query(sqlstr)
	if err != nil {
		return nil, err
	}
	defer q.Close()

	// load results
	res := []*SlaveHosts10{}
	for q.Next() {
		sh := SlaveHosts10{}

		// scan
		err = q.Scan(&sh.ApplicationName, &sh.ClientAddr, &sh.State, &sh.ByteLag)
		if err != nil {
			return nil, err
		}

		res = append(res, &sh)
	}

	return res, nil
}
