// Package models contains the types for schema 'public'.
package models

// Code generated by xo. DO NOT EDIT.

// Tablespaces
type Tablespaces struct {
	Name     Name   // name
	Owner    Name   // owner
	Location string // location
}

// GetTablespaces runs a custom query, returning results as Tablespaces.
func GetTablespaces(db XODB) ([]*Tablespaces, error) {
	var err error

	// sql query
	var sqlstr = `SELECT spcname AS Name, ` +
		`pg_catalog.pg_get_userbyid(spcowner) AS Owner, ` +
		`pg_catalog.pg_tablespace_location(oid) AS Location ` +
		`FROM pg_catalog.pg_tablespace ` +
		`ORDER BY 1`

	// run query
	XOLog(sqlstr)
	q, err := db.Query(sqlstr)
	if err != nil {
		return nil, err
	}
	defer q.Close()

	// load results
	res := []*Tablespaces{}
	for q.Next() {
		t := Tablespaces{}

		// scan
		err = q.Scan(&t.Name, &t.Owner, &t.Location)
		if err != nil {
			return nil, err
		}

		res = append(res, &t)
	}

	return res, nil
}
