/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.IoUtils;
import com.tonicsystems.jarjar.StringReader;
import com.tonicsystems.jarjar.StringVisitor;
import com.tonicsystems.jarjar.ext_util.ClassPathIterator;
import com.tonicsystems.jarjar.ext_util.RuntimeIOException;
import java.io.IOException;
import java.io.PrintWriter;

class StringDumper {
    public void run(String classPath, PrintWriter pw) throws IOException {
        StringReader stringReader = new StringReader(new DumpStringVisitor(pw));
        ClassPathIterator cp = new ClassPathIterator(classPath);
        try {
            while (cp.hasNext()) {
                try {
                    IoUtils.readClass(cp.getInputStream(cp.next())).accept(stringReader, 2);
                }
                catch (ClassFormatError e) {}
            }
        }
        catch (RuntimeIOException e) {
            throw (IOException)e.getCause();
        }
    }

    private static class DumpStringVisitor
    implements StringVisitor {
        private final PrintWriter pw;
        private String className;
        private boolean needName;

        public DumpStringVisitor(PrintWriter pw) {
            this.pw = pw;
        }

        public void visitStart(String className) {
            this.className = className;
            this.needName = true;
        }

        public void visitString(String value, int line) {
            if (value.length() > 0) {
                if (this.needName) {
                    this.pw.println(this.className.replace('/', '.'));
                    this.needName = false;
                }
                this.pw.print("\t");
                if (line >= 0) {
                    this.pw.print(line + ": ");
                }
                this.pw.print(IoUtils.escapeStringLiteral(value));
                this.pw.println();
            }
        }

        public void visitEnd() {
            this.pw.flush();
        }
    }
}

