# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import json
import sys
from typing import Any, AsyncIterator, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import _model_base, models as _models
from ..._model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from ..._serialization import Deserializer, Serializer
from ..._vendor import prepare_multipart_form_data
from ...operations._operations import (
    build_discovery_auto_complete_request,
    build_discovery_query_request,
    build_discovery_suggest_request,
    build_entity_add_classification_request,
    build_entity_add_classifications_by_unique_attribute_request,
    build_entity_add_classifications_request,
    build_entity_add_label_request,
    build_entity_add_labels_by_unique_attribute_request,
    build_entity_add_or_update_business_metadata_attributes_request,
    build_entity_add_or_update_business_metadata_request,
    build_entity_batch_create_or_update_request,
    build_entity_batch_delete_request,
    build_entity_batch_get_by_unique_attributes_request,
    build_entity_batch_set_classifications_request,
    build_entity_create_or_update_request,
    build_entity_delete_by_unique_attribute_request,
    build_entity_delete_request,
    build_entity_get_business_metadata_template_request,
    build_entity_get_by_ids_request,
    build_entity_get_by_unique_attribute_request,
    build_entity_get_classification_request,
    build_entity_get_classifications_request,
    build_entity_get_header_request,
    build_entity_get_request,
    build_entity_import_business_metadata_request,
    build_entity_move_entities_to_collection_request,
    build_entity_remove_business_metadata_attributes_request,
    build_entity_remove_business_metadata_request,
    build_entity_remove_classification_by_unique_attribute_request,
    build_entity_remove_classification_request,
    build_entity_remove_labels_by_unique_attribute_request,
    build_entity_remove_labels_request,
    build_entity_set_labels_by_unique_attribute_request,
    build_entity_set_labels_request,
    build_entity_update_attribute_by_id_request,
    build_entity_update_by_unique_attribute_request,
    build_entity_update_classifications_request,
    build_entity_update_classifications_unique_by_attribute_request,
    build_glossary_assign_term_to_entities_request,
    build_glossary_batch_get_request,
    build_glossary_create_categories_request,
    build_glossary_create_category_request,
    build_glossary_create_request,
    build_glossary_create_term_request,
    build_glossary_create_terms_request,
    build_glossary_delete_category_request,
    build_glossary_delete_request,
    build_glossary_delete_term_assignment_from_entities_request,
    build_glossary_delete_term_request,
    build_glossary_get_categories_headers_request,
    build_glossary_get_categories_request,
    build_glossary_get_category_request,
    build_glossary_get_category_terms_request,
    build_glossary_get_detailed_request,
    build_glossary_get_entities_assigned_with_term_request,
    build_glossary_get_related_categories_request,
    build_glossary_get_related_terms_request,
    build_glossary_get_request,
    build_glossary_get_term_headers_request,
    build_glossary_get_term_request,
    build_glossary_get_terms_request,
    build_glossary_partial_update_category_request,
    build_glossary_partial_update_request,
    build_glossary_partial_update_term_request,
    build_glossary_update_category_request,
    build_glossary_update_request,
    build_glossary_update_term_request,
    build_lineage_get_by_unique_attribute_request,
    build_lineage_get_next_page_request,
    build_lineage_get_request,
    build_relationship_create_request,
    build_relationship_delete_request,
    build_relationship_get_request,
    build_relationship_update_request,
    build_type_definition_batch_create_request,
    build_type_definition_batch_delete_request,
    build_type_definition_batch_update_request,
    build_type_definition_delete_request,
    build_type_definition_get_business_metadata_by_id_request,
    build_type_definition_get_business_metadata_by_name_request,
    build_type_definition_get_by_id_request,
    build_type_definition_get_by_name_request,
    build_type_definition_get_classification_by_id_request,
    build_type_definition_get_classification_by_name_request,
    build_type_definition_get_entity_by_id_request,
    build_type_definition_get_entity_by_name_request,
    build_type_definition_get_enum_by_id_request,
    build_type_definition_get_enum_by_name_request,
    build_type_definition_get_headers_request,
    build_type_definition_get_relationship_by_id_request,
    build_type_definition_get_relationship_by_name_request,
    build_type_definition_get_request,
    build_type_definition_get_struct_by_id_request,
    build_type_definition_get_struct_by_name_request,
    build_type_definition_get_term_template_by_id_request,
    build_type_definition_get_term_template_by_name_request,
)
from .._configuration import DataMapClientConfiguration

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class EntityOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.datamap.aio.DataMapClient`'s
        :attr:`entity` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: DataMapClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def create_or_update(
        self,
        body: _models.AtlasEntityWithExtInfo,
        *,
        business_attribute_update_behavior: Optional[Union[str, _models.BusinessAttributeUpdateBehavior]] = None,
        collection_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Create or update an entity.
        Existing entity is matched using its unique guid if
        supplied or by its unique attributes eg: qualifiedName.
        Map and array of
        collections are not well supported. E.g., array<array\\ :code:`<int>`>, array<map<string,
        int>>.
        For each contact type, the maximum number of contacts is 20.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.AtlasEntityWithExtInfo
        :keyword business_attribute_update_behavior: Used to define the update behavior for business
         attributes when updating
         entities. Known values are: "ignore", "replace", and "merge". Default value is None.
        :paramtype business_attribute_update_behavior: str or
         ~azure.purview.datamap.models.BusinessAttributeUpdateBehavior
        :keyword collection_id: The collection where entities will be moved to. Only specify a value if
         you
         need to move an entity to another collection. Default value is None.
        :paramtype collection_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        body: JSON,
        *,
        business_attribute_update_behavior: Optional[Union[str, _models.BusinessAttributeUpdateBehavior]] = None,
        collection_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Create or update an entity.
        Existing entity is matched using its unique guid if
        supplied or by its unique attributes eg: qualifiedName.
        Map and array of
        collections are not well supported. E.g., array<array\\ :code:`<int>`>, array<map<string,
        int>>.
        For each contact type, the maximum number of contacts is 20.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword business_attribute_update_behavior: Used to define the update behavior for business
         attributes when updating
         entities. Known values are: "ignore", "replace", and "merge". Default value is None.
        :paramtype business_attribute_update_behavior: str or
         ~azure.purview.datamap.models.BusinessAttributeUpdateBehavior
        :keyword collection_id: The collection where entities will be moved to. Only specify a value if
         you
         need to move an entity to another collection. Default value is None.
        :paramtype collection_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        body: IO[bytes],
        *,
        business_attribute_update_behavior: Optional[Union[str, _models.BusinessAttributeUpdateBehavior]] = None,
        collection_id: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Create or update an entity.
        Existing entity is matched using its unique guid if
        supplied or by its unique attributes eg: qualifiedName.
        Map and array of
        collections are not well supported. E.g., array<array\\ :code:`<int>`>, array<map<string,
        int>>.
        For each contact type, the maximum number of contacts is 20.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword business_attribute_update_behavior: Used to define the update behavior for business
         attributes when updating
         entities. Known values are: "ignore", "replace", and "merge". Default value is None.
        :paramtype business_attribute_update_behavior: str or
         ~azure.purview.datamap.models.BusinessAttributeUpdateBehavior
        :keyword collection_id: The collection where entities will be moved to. Only specify a value if
         you
         need to move an entity to another collection. Default value is None.
        :paramtype collection_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        body: Union[_models.AtlasEntityWithExtInfo, JSON, IO[bytes]],
        *,
        business_attribute_update_behavior: Optional[Union[str, _models.BusinessAttributeUpdateBehavior]] = None,
        collection_id: Optional[str] = None,
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Create or update an entity.
        Existing entity is matched using its unique guid if
        supplied or by its unique attributes eg: qualifiedName.
        Map and array of
        collections are not well supported. E.g., array<array\\ :code:`<int>`>, array<map<string,
        int>>.
        For each contact type, the maximum number of contacts is 20.

        :param body: Body parameter. Is one of the following types: AtlasEntityWithExtInfo, JSON,
         IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.AtlasEntityWithExtInfo or JSON or IO[bytes]
        :keyword business_attribute_update_behavior: Used to define the update behavior for business
         attributes when updating
         entities. Known values are: "ignore", "replace", and "merge". Default value is None.
        :paramtype business_attribute_update_behavior: str or
         ~azure.purview.datamap.models.BusinessAttributeUpdateBehavior
        :keyword collection_id: The collection where entities will be moved to. Only specify a value if
         you
         need to move an entity to another collection. Default value is None.
        :paramtype collection_id: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.EntityMutationResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_create_or_update_request(
            business_attribute_update_behavior=business_attribute_update_behavior,
            collection_id=collection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.EntityMutationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_by_ids(
        self,
        *,
        guid: List[str],
        min_ext_info: Optional[bool] = None,
        ignore_relationships: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.AtlasEntitiesWithExtInfo:
        """List entities in bulk identified by its GUIDs.

        :keyword guid: An array of GUIDs of entities to list. Required.
        :paramtype guid: list[str]
        :keyword min_ext_info: Whether to return minimal information for referred entities. Default
         value is None.
        :paramtype min_ext_info: bool
        :keyword ignore_relationships: Whether to ignore relationship attributes. Default value is
         None.
        :paramtype ignore_relationships: bool
        :return: AtlasEntitiesWithExtInfo. The AtlasEntitiesWithExtInfo is compatible with
         MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasEntitiesWithExtInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasEntitiesWithExtInfo] = kwargs.pop("cls", None)

        _request = build_entity_get_by_ids_request(
            guid=guid,
            min_ext_info=min_ext_info,
            ignore_relationships=ignore_relationships,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasEntitiesWithExtInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def batch_create_or_update(
        self,
        body: _models.AtlasEntitiesWithExtInfo,
        *,
        collection_id: Optional[str] = None,
        business_attribute_update_behavior: Optional[Union[str, _models.BusinessAttributeUpdateBehavior]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Create or update entities in bulk.
        Existing entity is matched using its unique
        guid if supplied or by its unique attributes eg: qualifiedName.
        Map and array
        of collections are not well supported. E.g., array<array\\ :code:`<int>`>,
        array<map<string, int>>.
        For each contact type, the maximum number of contacts
        is 20.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.AtlasEntitiesWithExtInfo
        :keyword collection_id: The collection where entities will be moved to. Only specify a value if
         you
         need to move an entity to another collection. Default value is None.
        :paramtype collection_id: str
        :keyword business_attribute_update_behavior: Used to define the update behavior for business
         attributes when updating
         entities. Known values are: "ignore", "replace", and "merge". Default value is None.
        :paramtype business_attribute_update_behavior: str or
         ~azure.purview.datamap.models.BusinessAttributeUpdateBehavior
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def batch_create_or_update(
        self,
        body: JSON,
        *,
        collection_id: Optional[str] = None,
        business_attribute_update_behavior: Optional[Union[str, _models.BusinessAttributeUpdateBehavior]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Create or update entities in bulk.
        Existing entity is matched using its unique
        guid if supplied or by its unique attributes eg: qualifiedName.
        Map and array
        of collections are not well supported. E.g., array<array\\ :code:`<int>`>,
        array<map<string, int>>.
        For each contact type, the maximum number of contacts
        is 20.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword collection_id: The collection where entities will be moved to. Only specify a value if
         you
         need to move an entity to another collection. Default value is None.
        :paramtype collection_id: str
        :keyword business_attribute_update_behavior: Used to define the update behavior for business
         attributes when updating
         entities. Known values are: "ignore", "replace", and "merge". Default value is None.
        :paramtype business_attribute_update_behavior: str or
         ~azure.purview.datamap.models.BusinessAttributeUpdateBehavior
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def batch_create_or_update(
        self,
        body: IO[bytes],
        *,
        collection_id: Optional[str] = None,
        business_attribute_update_behavior: Optional[Union[str, _models.BusinessAttributeUpdateBehavior]] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Create or update entities in bulk.
        Existing entity is matched using its unique
        guid if supplied or by its unique attributes eg: qualifiedName.
        Map and array
        of collections are not well supported. E.g., array<array\\ :code:`<int>`>,
        array<map<string, int>>.
        For each contact type, the maximum number of contacts
        is 20.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword collection_id: The collection where entities will be moved to. Only specify a value if
         you
         need to move an entity to another collection. Default value is None.
        :paramtype collection_id: str
        :keyword business_attribute_update_behavior: Used to define the update behavior for business
         attributes when updating
         entities. Known values are: "ignore", "replace", and "merge". Default value is None.
        :paramtype business_attribute_update_behavior: str or
         ~azure.purview.datamap.models.BusinessAttributeUpdateBehavior
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def batch_create_or_update(
        self,
        body: Union[_models.AtlasEntitiesWithExtInfo, JSON, IO[bytes]],
        *,
        collection_id: Optional[str] = None,
        business_attribute_update_behavior: Optional[Union[str, _models.BusinessAttributeUpdateBehavior]] = None,
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Create or update entities in bulk.
        Existing entity is matched using its unique
        guid if supplied or by its unique attributes eg: qualifiedName.
        Map and array
        of collections are not well supported. E.g., array<array\\ :code:`<int>`>,
        array<map<string, int>>.
        For each contact type, the maximum number of contacts
        is 20.

        :param body: Body parameter. Is one of the following types: AtlasEntitiesWithExtInfo, JSON,
         IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.AtlasEntitiesWithExtInfo or JSON or IO[bytes]
        :keyword collection_id: The collection where entities will be moved to. Only specify a value if
         you
         need to move an entity to another collection. Default value is None.
        :paramtype collection_id: str
        :keyword business_attribute_update_behavior: Used to define the update behavior for business
         attributes when updating
         entities. Known values are: "ignore", "replace", and "merge". Default value is None.
        :paramtype business_attribute_update_behavior: str or
         ~azure.purview.datamap.models.BusinessAttributeUpdateBehavior
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.EntityMutationResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_batch_create_or_update_request(
            collection_id=collection_id,
            business_attribute_update_behavior=business_attribute_update_behavior,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.EntityMutationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def batch_delete(self, *, guid: List[str], **kwargs: Any) -> _models.EntityMutationResult:
        """Delete a list of entities in bulk identified by their GUIDs or unique
        attributes.

        :keyword guid: An array of GUIDs of entities to delete. Required.
        :paramtype guid: list[str]
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.EntityMutationResult] = kwargs.pop("cls", None)

        _request = build_entity_batch_delete_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.EntityMutationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def add_classification(
        self, body: _models.ClassificationAssociateOptions, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Associate a classification to multiple entities in bulk.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.ClassificationAssociateOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_classification(self, body: JSON, *, content_type: str = "application/json", **kwargs: Any) -> None:
        """Associate a classification to multiple entities in bulk.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_classification(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Associate a classification to multiple entities in bulk.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_classification(
        self, body: Union[_models.ClassificationAssociateOptions, JSON, IO[bytes]], **kwargs: Any
    ) -> None:
        """Associate a classification to multiple entities in bulk.

        :param body: Body parameter. Is one of the following types: ClassificationAssociateOptions,
         JSON, IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.ClassificationAssociateOptions or JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_add_classification_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get(
        self,
        guid: str,
        *,
        min_ext_info: Optional[bool] = None,
        ignore_relationships: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.AtlasEntityWithExtInfo:
        """Get complete definition of an entity given its GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :keyword min_ext_info: Whether to return minimal information for referred entities. Default
         value is None.
        :paramtype min_ext_info: bool
        :keyword ignore_relationships: Whether to ignore relationship attributes. Default value is
         None.
        :paramtype ignore_relationships: bool
        :return: AtlasEntityWithExtInfo. The AtlasEntityWithExtInfo is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasEntityWithExtInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasEntityWithExtInfo] = kwargs.pop("cls", None)

        _request = build_entity_get_request(
            guid=guid,
            min_ext_info=min_ext_info,
            ignore_relationships=ignore_relationships,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasEntityWithExtInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def update_attribute_by_id(
        self, guid: str, body: Any, *, name: str, **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Update entity partially - create or update entity attribute identified by its
        GUID.
        Supports only primitive attribute type and entity references.
        It does not support updating complex types like arrays, and maps.
        Null updates are not possible.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: The value of the attribute. Required.
        :type body: any
        :keyword name: The name of the attribute. Required.
        :paramtype name: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))
        cls: ClsType[_models.EntityMutationResult] = kwargs.pop("cls", None)

        _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_update_attribute_by_id_request(
            guid=guid,
            name=name,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.EntityMutationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(self, guid: str, **kwargs: Any) -> _models.EntityMutationResult:
        """Delete an entity identified by its GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.EntityMutationResult] = kwargs.pop("cls", None)

        _request = build_entity_delete_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.EntityMutationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_classification(
        self, guid: str, classification_name: str, **kwargs: Any
    ) -> _models.AtlasClassification:
        """Get classification for a given entity represented by a GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param classification_name: The name of the classification. Required.
        :type classification_name: str
        :return: AtlasClassification. The AtlasClassification is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasClassification
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasClassification] = kwargs.pop("cls", None)

        _request = build_entity_get_classification_request(
            guid=guid,
            classification_name=classification_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasClassification, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def remove_classification(self, guid: str, classification_name: str, **kwargs: Any) -> None:
        """Delete a given classification from an existing entity represented by a GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param classification_name: The name of the classification. Required.
        :type classification_name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_entity_remove_classification_request(
            guid=guid,
            classification_name=classification_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_classifications(self, guid: str, **kwargs: Any) -> _models.AtlasClassifications:
        """List classifications for a given entity represented by a GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :return: AtlasClassifications. The AtlasClassifications is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasClassifications
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasClassifications] = kwargs.pop("cls", None)

        _request = build_entity_get_classifications_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasClassifications, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def add_classifications(
        self,
        guid: str,
        body: List[_models.AtlasClassification],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Add classifications to an existing entity represented by a GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: An array of classifications to be added. Required.
        :type body: list[~azure.purview.datamap.models.AtlasClassification]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_classifications(
        self, guid: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Add classifications to an existing entity represented by a GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: An array of classifications to be added. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_classifications(
        self, guid: str, body: Union[List[_models.AtlasClassification], IO[bytes]], **kwargs: Any
    ) -> None:
        """Add classifications to an existing entity represented by a GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: An array of classifications to be added. Is either a [AtlasClassification] type or
         a IO[bytes] type. Required.
        :type body: list[~azure.purview.datamap.models.AtlasClassification] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_add_classifications_request(
            guid=guid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update_classifications(
        self,
        guid: str,
        body: List[_models.AtlasClassification],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Update classifications to an existing entity represented by a guid.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: An array of classifications to be updated. Required.
        :type body: list[~azure.purview.datamap.models.AtlasClassification]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_classifications(
        self, guid: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Update classifications to an existing entity represented by a guid.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: An array of classifications to be updated. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_classifications(
        self, guid: str, body: Union[List[_models.AtlasClassification], IO[bytes]], **kwargs: Any
    ) -> None:
        """Update classifications to an existing entity represented by a guid.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: An array of classifications to be updated. Is either a [AtlasClassification] type
         or a IO[bytes] type. Required.
        :type body: list[~azure.purview.datamap.models.AtlasClassification] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_update_classifications_request(
            guid=guid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_by_unique_attribute(
        self,
        type_name: str,
        *,
        min_ext_info: Optional[bool] = None,
        ignore_relationships: Optional[bool] = None,
        attribute: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AtlasEntityWithExtInfo:
        """Get complete definition of an entity given its type and unique attribute.

        In
        addition to the typeName path parameter, attribute key-value pair(s) can be
        provided in the following format:
        attr:\\\\ :code:`<attrName>`=\\ :code:`<attrValue>`.

        NOTE: The
        attrName and attrValue should be unique across entities, eg.
        qualifiedName.

        The REST request would look something like this:
        GET
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :keyword min_ext_info: Whether to return minimal information for referred entities. Default
         value is None.
        :paramtype min_ext_info: bool
        :keyword ignore_relationships: Whether to ignore relationship attributes. Default value is
         None.
        :paramtype ignore_relationships: bool
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: AtlasEntityWithExtInfo. The AtlasEntityWithExtInfo is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasEntityWithExtInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasEntityWithExtInfo] = kwargs.pop("cls", None)

        _request = build_entity_get_by_unique_attribute_request(
            type_name=type_name,
            min_ext_info=min_ext_info,
            ignore_relationships=ignore_relationships,
            attribute=attribute,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasEntityWithExtInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_by_unique_attribute(
        self,
        type_name: str,
        body: _models.AtlasEntityWithExtInfo,
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Update entity partially - Allow a subset of attributes to be updated on an
        entity which is identified by its type and unique attribute eg:
        Referenceable.qualifiedName. Null updates are not possible.

        In addition to the
        typeName path parameter, attribute key-value pair(s) can be provided in the
        following format:

        attr:\\ :code:`<attrName>`=\\ :code:`<attrValue>`.
        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this:
        PUT
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.AtlasEntityWithExtInfo
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_by_unique_attribute(
        self,
        type_name: str,
        body: JSON,
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Update entity partially - Allow a subset of attributes to be updated on an
        entity which is identified by its type and unique attribute eg:
        Referenceable.qualifiedName. Null updates are not possible.

        In addition to the
        typeName path parameter, attribute key-value pair(s) can be provided in the
        following format:

        attr:\\ :code:`<attrName>`=\\ :code:`<attrValue>`.
        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this:
        PUT
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: Body parameter. Required.
        :type body: JSON
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_by_unique_attribute(
        self,
        type_name: str,
        body: IO[bytes],
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Update entity partially - Allow a subset of attributes to be updated on an
        entity which is identified by its type and unique attribute eg:
        Referenceable.qualifiedName. Null updates are not possible.

        In addition to the
        typeName path parameter, attribute key-value pair(s) can be provided in the
        following format:

        attr:\\ :code:`<attrName>`=\\ :code:`<attrValue>`.
        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this:
        PUT
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_by_unique_attribute(
        self,
        type_name: str,
        body: Union[_models.AtlasEntityWithExtInfo, JSON, IO[bytes]],
        *,
        attribute: Optional[str] = None,
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Update entity partially - Allow a subset of attributes to be updated on an
        entity which is identified by its type and unique attribute eg:
        Referenceable.qualifiedName. Null updates are not possible.

        In addition to the
        typeName path parameter, attribute key-value pair(s) can be provided in the
        following format:

        attr:\\ :code:`<attrName>`=\\ :code:`<attrValue>`.
        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this:
        PUT
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: Body parameter. Is one of the following types: AtlasEntityWithExtInfo, JSON,
         IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.AtlasEntityWithExtInfo or JSON or IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.EntityMutationResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_update_by_unique_attribute_request(
            type_name=type_name,
            attribute=attribute,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.EntityMutationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_by_unique_attribute(
        self, type_name: str, *, attribute: Optional[str] = None, **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Delete an entity identified by its type and unique attributes.
        In addition to
        the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format:
        attr:\\\\ :code:`<attrName>`=\\\\ :code:`<attrValue>`.
        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this:
        DELETE
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.EntityMutationResult] = kwargs.pop("cls", None)

        _request = build_entity_delete_by_unique_attribute_request(
            type_name=type_name,
            attribute=attribute,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.EntityMutationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def remove_classification_by_unique_attribute(  # pylint: disable=name-too-long
        self, type_name: str, classification_name: str, *, attribute: Optional[str] = None, **kwargs: Any
    ) -> None:
        """Delete a given classification from an entity identified by its type and unique
        attributes.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param classification_name: The name of the classification. Required.
        :type classification_name: str
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_entity_remove_classification_by_unique_attribute_request(
            type_name=type_name,
            classification_name=classification_name,
            attribute=attribute,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def add_classifications_by_unique_attribute(
        self,
        type_name: str,
        body: List[_models.AtlasClassification],
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Add classification to the entity identified by its type and unique attributes.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: An array of classification to be added. Required.
        :type body: list[~azure.purview.datamap.models.AtlasClassification]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_classifications_by_unique_attribute(
        self,
        type_name: str,
        body: IO[bytes],
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Add classification to the entity identified by its type and unique attributes.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: An array of classification to be added. Required.
        :type body: IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_classifications_by_unique_attribute(
        self,
        type_name: str,
        body: Union[List[_models.AtlasClassification], IO[bytes]],
        *,
        attribute: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Add classification to the entity identified by its type and unique attributes.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: An array of classification to be added. Is either a [AtlasClassification] type or
         a IO[bytes] type. Required.
        :type body: list[~azure.purview.datamap.models.AtlasClassification] or IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_add_classifications_by_unique_attribute_request(
            type_name=type_name,
            attribute=attribute,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def update_classifications_unique_by_attribute(  # pylint: disable=name-too-long
        self,
        type_name: str,
        body: List[_models.AtlasClassification],
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Update classification on an entity identified by its type and unique attributes.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: An array of classification to be updated. Required.
        :type body: list[~azure.purview.datamap.models.AtlasClassification]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_classifications_unique_by_attribute(  # pylint: disable=name-too-long
        self,
        type_name: str,
        body: IO[bytes],
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Update classification on an entity identified by its type and unique attributes.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: An array of classification to be updated. Required.
        :type body: IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_classifications_unique_by_attribute(  # pylint: disable=name-too-long
        self,
        type_name: str,
        body: Union[List[_models.AtlasClassification], IO[bytes]],
        *,
        attribute: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Update classification on an entity identified by its type and unique attributes.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: An array of classification to be updated. Is either a [AtlasClassification] type
         or a IO[bytes] type. Required.
        :type body: list[~azure.purview.datamap.models.AtlasClassification] or IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_update_classifications_unique_by_attribute_request(
            type_name=type_name,
            attribute=attribute,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def batch_set_classifications(
        self, body: _models.AtlasEntityHeaders, *, content_type: str = "application/json", **kwargs: Any
    ) -> List[str]:
        """Set classifications on entities in bulk.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.AtlasEntityHeaders
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of str
        :rtype: list[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def batch_set_classifications(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> List[str]:
        """Set classifications on entities in bulk.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of str
        :rtype: list[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def batch_set_classifications(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[str]:
        """Set classifications on entities in bulk.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of str
        :rtype: list[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def batch_set_classifications(
        self, body: Union[_models.AtlasEntityHeaders, JSON, IO[bytes]], **kwargs: Any
    ) -> List[str]:
        """Set classifications on entities in bulk.

        :param body: Body parameter. Is one of the following types: AtlasEntityHeaders, JSON, IO[bytes]
         Required.
        :type body: ~azure.purview.datamap.models.AtlasEntityHeaders or JSON or IO[bytes]
        :return: list of str
        :rtype: list[str]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[str]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_batch_set_classifications_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[str], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def batch_get_by_unique_attributes(
        self,
        type_name: str,
        *,
        min_ext_info: Optional[bool] = None,
        ignore_relationships: Optional[bool] = None,
        attr_n_qualified_name: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AtlasEntitiesWithExtInfo:
        """Bulk API to retrieve list of entities identified by its unique attributes.
        In
        addition to the typeName path parameter, attribute key-value pair(s) can be
        provided in the following
        format

        typeName=\\\\ :code:`<typeName>`&attr_1:\\\\ :code:`<attrName>`=\\\\
        :code:`<attrValue>`&attr_2:\\\\ :code:`<attrName>`=\\\\ :code:`<attrValue>`&attr_3:\\\\
        :code:`<attrName>`=\\\\ :code:`<attrValue>`

        NOTE:
        The attrName should be an unique attribute for the given entity-type.
        The REST
        request would look something like this

        GET
        /v2/entity/bulk/uniqueAttribute/type/hive_db?attr_1:qualifiedName=db1@cl1&attr_2:qualifiedName=db2@cl1

        Note:
        at least one unique attribute must be provided.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :keyword min_ext_info: Whether to return minimal information for referred entities. Default
         value is None.
        :paramtype min_ext_info: bool
        :keyword ignore_relationships: Whether to ignore relationship attributes. Default value is
         None.
        :paramtype ignore_relationships: bool
        :keyword attr_n_qualified_name: Qualified name of an entity. E.g. to find 2 entities you can
         set
         attrs_1:qualifiedName=db1@cl1&attrs_2:qualifiedName=db2@cl1. (This is only an
         example. qualifiedName can be changed to other unique attributes). Default value is None.
        :paramtype attr_n_qualified_name: str
        :return: AtlasEntitiesWithExtInfo. The AtlasEntitiesWithExtInfo is compatible with
         MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasEntitiesWithExtInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasEntitiesWithExtInfo] = kwargs.pop("cls", None)

        _request = build_entity_batch_get_by_unique_attributes_request(
            type_name=type_name,
            min_ext_info=min_ext_info,
            ignore_relationships=ignore_relationships,
            attr_n_qualified_name=attr_n_qualified_name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasEntitiesWithExtInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_header(self, guid: str, **kwargs: Any) -> _models.AtlasEntityHeader:
        """Get entity header given its GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :return: AtlasEntityHeader. The AtlasEntityHeader is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasEntityHeader
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasEntityHeader] = kwargs.pop("cls", None)

        _request = build_entity_get_header_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasEntityHeader, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def remove_business_metadata(
        self, guid: str, body: Dict[str, Dict[str, Any]], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Remove business metadata from an entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata payload. Required.
        :type body: dict[str, dict[str, any]]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def remove_business_metadata(
        self, guid: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Remove business metadata from an entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata payload. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def remove_business_metadata(
        self, guid: str, body: Union[Dict[str, Dict[str, Any]], IO[bytes]], **kwargs: Any
    ) -> None:
        """Remove business metadata from an entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata payload. Is either a {str: {str: Any}} type or a IO[bytes] type.
         Required.
        :type body: dict[str, dict[str, any]] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_remove_business_metadata_request(
            guid=guid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def add_or_update_business_metadata(
        self,
        guid: str,
        body: Dict[str, Dict[str, Any]],
        *,
        overwrite: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Add business metadata to an entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: BusinessMetadata payload. Required.
        :type body: dict[str, dict[str, any]]
        :keyword overwrite: Whether to overwrite the existing business metadata on the entity or not,
         default is false. Default value is None.
        :paramtype overwrite: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_or_update_business_metadata(
        self,
        guid: str,
        body: IO[bytes],
        *,
        overwrite: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Add business metadata to an entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: BusinessMetadata payload. Required.
        :type body: IO[bytes]
        :keyword overwrite: Whether to overwrite the existing business metadata on the entity or not,
         default is false. Default value is None.
        :paramtype overwrite: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_or_update_business_metadata(
        self,
        guid: str,
        body: Union[Dict[str, Dict[str, Any]], IO[bytes]],
        *,
        overwrite: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """Add business metadata to an entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: BusinessMetadata payload. Is either a {str: {str: Any}} type or a IO[bytes] type.
         Required.
        :type body: dict[str, dict[str, any]] or IO[bytes]
        :keyword overwrite: Whether to overwrite the existing business metadata on the entity or not,
         default is false. Default value is None.
        :paramtype overwrite: bool
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_add_or_update_business_metadata_request(
            guid=guid,
            overwrite=overwrite,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def remove_business_metadata_attributes(
        self,
        business_metadata_name: str,
        guid: str,
        body: Dict[str, Any],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Delete business metadata attributes from an entity.

        :param business_metadata_name: BusinessMetadata name. Required.
        :type business_metadata_name: str
        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata attribute payload. Required.
        :type body: dict[str, any]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def remove_business_metadata_attributes(
        self,
        business_metadata_name: str,
        guid: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Delete business metadata attributes from an entity.

        :param business_metadata_name: BusinessMetadata name. Required.
        :type business_metadata_name: str
        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata attribute payload. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def remove_business_metadata_attributes(
        self, business_metadata_name: str, guid: str, body: Union[Dict[str, Any], IO[bytes]], **kwargs: Any
    ) -> None:
        """Delete business metadata attributes from an entity.

        :param business_metadata_name: BusinessMetadata name. Required.
        :type business_metadata_name: str
        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata attribute payload. Is either a {str: Any} type or a IO[bytes]
         type. Required.
        :type body: dict[str, any] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_remove_business_metadata_attributes_request(
            business_metadata_name=business_metadata_name,
            guid=guid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def add_or_update_business_metadata_attributes(  # pylint: disable=name-too-long
        self,
        business_metadata_name: str,
        guid: str,
        body: Dict[str, Any],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Add or update business metadata attributes.

        :param business_metadata_name: BusinessMetadata name. Required.
        :type business_metadata_name: str
        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata attribute payload. Required.
        :type body: dict[str, any]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_or_update_business_metadata_attributes(  # pylint: disable=name-too-long
        self,
        business_metadata_name: str,
        guid: str,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Add or update business metadata attributes.

        :param business_metadata_name: BusinessMetadata name. Required.
        :type business_metadata_name: str
        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata attribute payload. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_or_update_business_metadata_attributes(  # pylint: disable=name-too-long
        self, business_metadata_name: str, guid: str, body: Union[Dict[str, Any], IO[bytes]], **kwargs: Any
    ) -> None:
        """Add or update business metadata attributes.

        :param business_metadata_name: BusinessMetadata name. Required.
        :type business_metadata_name: str
        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: Business metadata attribute payload. Is either a {str: Any} type or a IO[bytes]
         type. Required.
        :type body: dict[str, any] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_add_or_update_business_metadata_attributes_request(
            business_metadata_name=business_metadata_name,
            guid=guid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_business_metadata_template(self, **kwargs: Any) -> AsyncIterator[bytes]:
        """Get the sample Template for uploading/creating bulk BusinessMetaData.

        :return: AsyncIterator[bytes]
        :rtype: AsyncIterator[bytes]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_entity_get_business_metadata_template_request(
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", True)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers["content-type"] = self._deserialize("str", response.headers.get("content-type"))

        deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def import_business_metadata(
        self, body: _models.BusinessMetadataOptions, **kwargs: Any
    ) -> _models.BulkImportResult:
        """Upload the file for creating Business Metadata in BULK.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.BusinessMetadataOptions
        :return: BulkImportResult. The BulkImportResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.BulkImportResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def import_business_metadata(self, body: JSON, **kwargs: Any) -> _models.BulkImportResult:
        """Upload the file for creating Business Metadata in BULK.

        :param body: Body parameter. Required.
        :type body: JSON
        :return: BulkImportResult. The BulkImportResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.BulkImportResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def import_business_metadata(
        self, body: Union[_models.BusinessMetadataOptions, JSON], **kwargs: Any
    ) -> _models.BulkImportResult:
        """Upload the file for creating Business Metadata in BULK.

        :param body: Body parameter. Is either a BusinessMetadataOptions type or a JSON type. Required.
        :type body: ~azure.purview.datamap.models.BusinessMetadataOptions or JSON
        :return: BulkImportResult. The BulkImportResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.BulkImportResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.BulkImportResult] = kwargs.pop("cls", None)

        _body = body.as_dict() if isinstance(body, _model_base.Model) else body
        _file_fields: List[str] = ["file"]
        _data_fields: List[str] = []
        _files, _data = prepare_multipart_form_data(_body, _file_fields, _data_fields)

        _request = build_entity_import_business_metadata_request(
            files=_files,
            data=_data,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.BulkImportResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def remove_labels(
        self, guid: str, body: Optional[List[str]] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Delete given labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be deleted. Default value is None.
        :type body: list[str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def remove_labels(
        self, guid: str, body: Optional[IO[bytes]] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Delete given labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be deleted. Default value is None.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def remove_labels(self, guid: str, body: Optional[Union[List[str], IO[bytes]]] = None, **kwargs: Any) -> None:
        """Delete given labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be deleted. Is either a [str] type or a IO[bytes] type. Default
         value is None.
        :type body: list[str] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_entity_remove_labels_request(
            guid=guid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def set_labels(
        self, guid: str, body: Optional[List[str]] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Set labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be set to the entity. Default value is None.
        :type body: list[str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def set_labels(
        self, guid: str, body: Optional[IO[bytes]] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Set labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be set to the entity. Default value is None.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def set_labels(self, guid: str, body: Optional[Union[List[str], IO[bytes]]] = None, **kwargs: Any) -> None:
        """Set labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be set to the entity. Is either a [str] type or a IO[bytes] type.
         Default value is None.
        :type body: list[str] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_entity_set_labels_request(
            guid=guid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def add_label(
        self, guid: str, body: Optional[List[str]] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Add given labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be added. Default value is None.
        :type body: list[str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_label(
        self, guid: str, body: Optional[IO[bytes]] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Add given labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be added. Default value is None.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_label(self, guid: str, body: Optional[Union[List[str], IO[bytes]]] = None, **kwargs: Any) -> None:
        """Add given labels to a given entity.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :param body: set of labels to be added. Is either a [str] type or a IO[bytes] type. Default
         value is None.
        :type body: list[str] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_entity_add_label_request(
            guid=guid,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def remove_labels_by_unique_attribute(
        self,
        type_name: str,
        body: Optional[List[str]] = None,
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Delete given labels to a given entity identified by its type and unique
        attribute.

        If labels is null/empty, no labels will be removed.

        If any labels
        in labels set are non-existing labels, they will be ignored, only existing
        labels will be removed. In addition to the typeName path parameter, attribute
        key-value pair(s) can be provided in the following format:
        attr:\\ :code:`<attrName>`=\\ :code:`<attrValue>`. NOTE: The attrName and attrValue should be
        unique
        across entities, eg. qualifiedName. The REST request would look something like
        this: DELETE
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be deleted. Default value is None.
        :type body: list[str]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def remove_labels_by_unique_attribute(
        self,
        type_name: str,
        body: Optional[IO[bytes]] = None,
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Delete given labels to a given entity identified by its type and unique
        attribute.

        If labels is null/empty, no labels will be removed.

        If any labels
        in labels set are non-existing labels, they will be ignored, only existing
        labels will be removed. In addition to the typeName path parameter, attribute
        key-value pair(s) can be provided in the following format:
        attr:\\ :code:`<attrName>`=\\ :code:`<attrValue>`. NOTE: The attrName and attrValue should be
        unique
        across entities, eg. qualifiedName. The REST request would look something like
        this: DELETE
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be deleted. Default value is None.
        :type body: IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def remove_labels_by_unique_attribute(
        self,
        type_name: str,
        body: Optional[Union[List[str], IO[bytes]]] = None,
        *,
        attribute: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Delete given labels to a given entity identified by its type and unique
        attribute.

        If labels is null/empty, no labels will be removed.

        If any labels
        in labels set are non-existing labels, they will be ignored, only existing
        labels will be removed. In addition to the typeName path parameter, attribute
        key-value pair(s) can be provided in the following format:
        attr:\\ :code:`<attrName>`=\\ :code:`<attrValue>`. NOTE: The attrName and attrValue should be
        unique
        across entities, eg. qualifiedName. The REST request would look something like
        this: DELETE
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be deleted. Is either a [str] type or a IO[bytes] type. Default
         value is None.
        :type body: list[str] or IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_entity_remove_labels_by_unique_attribute_request(
            type_name=type_name,
            attribute=attribute,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def set_labels_by_unique_attribute(
        self,
        type_name: str,
        body: Optional[List[str]] = None,
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Set labels to a given entity identified by its type and unique attributes.

        If
        labels is null/empty, existing labels will all be removed.

        In addition to the
        typeName path parameter, attribute key-value pair(s) can be provided in the
        following format: attr:\\ :code:`<attrName>`=\\ :code:`<attrValue>`.

        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this: POST
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be set. Default value is None.
        :type body: list[str]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def set_labels_by_unique_attribute(
        self,
        type_name: str,
        body: Optional[IO[bytes]] = None,
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Set labels to a given entity identified by its type and unique attributes.

        If
        labels is null/empty, existing labels will all be removed.

        In addition to the
        typeName path parameter, attribute key-value pair(s) can be provided in the
        following format: attr:\\ :code:`<attrName>`=\\ :code:`<attrValue>`.

        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this: POST
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be set. Default value is None.
        :type body: IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def set_labels_by_unique_attribute(
        self,
        type_name: str,
        body: Optional[Union[List[str], IO[bytes]]] = None,
        *,
        attribute: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Set labels to a given entity identified by its type and unique attributes.

        If
        labels is null/empty, existing labels will all be removed.

        In addition to the
        typeName path parameter, attribute key-value pair(s) can be provided in the
        following format: attr:\\ :code:`<attrName>`=\\ :code:`<attrValue>`.

        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this: POST
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be set. Is either a [str] type or a IO[bytes] type. Default value
         is None.
        :type body: list[str] or IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_entity_set_labels_by_unique_attribute_request(
            type_name=type_name,
            attribute=attribute,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def add_labels_by_unique_attribute(
        self,
        type_name: str,
        body: Optional[List[str]] = None,
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Add given labels to a given entity identified by its type and unique
        attributes.

        If labels is null/empty, no labels will be added.

        In addition to
        the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format: attr:\\ :code:`<attrName>`=\\ :code:`<attrValue>`.

        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this: PUT
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be added. Default value is None.
        :type body: list[str]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def add_labels_by_unique_attribute(
        self,
        type_name: str,
        body: Optional[IO[bytes]] = None,
        *,
        attribute: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Add given labels to a given entity identified by its type and unique
        attributes.

        If labels is null/empty, no labels will be added.

        In addition to
        the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format: attr:\\ :code:`<attrName>`=\\ :code:`<attrValue>`.

        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this: PUT
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be added. Default value is None.
        :type body: IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def add_labels_by_unique_attribute(
        self,
        type_name: str,
        body: Optional[Union[List[str], IO[bytes]]] = None,
        *,
        attribute: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """Add given labels to a given entity identified by its type and unique
        attributes.

        If labels is null/empty, no labels will be added.

        In addition to
        the typeName path parameter, attribute key-value pair(s) can be provided in the
        following format: attr:\\ :code:`<attrName>`=\\ :code:`<attrValue>`.

        NOTE: The attrName and
        attrValue should be unique across entities, eg. qualifiedName.

        The REST
        request would look something like this: PUT
        /v2/entity/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :param body: set of labels to be added. Is either a [str] type or a IO[bytes] type. Default
         value is None.
        :type body: list[str] or IO[bytes]
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            if body is not None:
                _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore
            else:
                _content = None

        _request = build_entity_add_labels_by_unique_attribute_request(
            type_name=type_name,
            attribute=attribute,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def move_entities_to_collection(
        self,
        body: _models.MoveEntitiesOptions,
        *,
        collection_id: str,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Move existing entities to the target collection.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.MoveEntitiesOptions
        :keyword collection_id: The collection where entities will be moved to. Required.
        :paramtype collection_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def move_entities_to_collection(
        self, body: JSON, *, collection_id: str, content_type: str = "application/json", **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Move existing entities to the target collection.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword collection_id: The collection where entities will be moved to. Required.
        :paramtype collection_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def move_entities_to_collection(
        self, body: IO[bytes], *, collection_id: str, content_type: str = "application/json", **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Move existing entities to the target collection.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword collection_id: The collection where entities will be moved to. Required.
        :paramtype collection_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def move_entities_to_collection(
        self, body: Union[_models.MoveEntitiesOptions, JSON, IO[bytes]], *, collection_id: str, **kwargs: Any
    ) -> _models.EntityMutationResult:
        """Move existing entities to the target collection.

        :param body: Body parameter. Is one of the following types: MoveEntitiesOptions, JSON,
         IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.MoveEntitiesOptions or JSON or IO[bytes]
        :keyword collection_id: The collection where entities will be moved to. Required.
        :paramtype collection_id: str
        :return: EntityMutationResult. The EntityMutationResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.EntityMutationResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.EntityMutationResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_entity_move_entities_to_collection_request(
            collection_id=collection_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.EntityMutationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class GlossaryOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.datamap.aio.DataMapClient`'s
        :attr:`glossary` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: DataMapClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def batch_get(
        self,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = None,
        ignore_terms_and_categories: Optional[bool] = None,
        **kwargs: Any
    ) -> List[_models.AtlasGlossary]:
        """Get all glossaries. Recommend using limit/offset to get pagination result.
        Recommend using 'ignoreTermsAndCategories=true' and fetch terms/categories
        separately using 'GET /datamap/api/atlas/v2/glossary/{glossaryId}/terms'
        and 'GET '/datamap/api/atlas/v2/glossary/{glossaryId}/categories'.

        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is None.
        :paramtype sort: str
        :keyword ignore_terms_and_categories: Whether ignore terms and categories. Default value is
         None.
        :paramtype ignore_terms_and_categories: bool
        :return: list of AtlasGlossary
        :rtype: list[~azure.purview.datamap.models.AtlasGlossary]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.AtlasGlossary]] = kwargs.pop("cls", None)

        _request = build_glossary_batch_get_request(
            limit=limit,
            offset=offset,
            sort=sort,
            ignore_terms_and_categories=ignore_terms_and_categories,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.AtlasGlossary], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create(
        self, body: _models.AtlasGlossary, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossary:
        """Create a glossary.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossary
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossary. The AtlasGlossary is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossary:
        """Create a glossary.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossary. The AtlasGlossary is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossary:
        """Create a glossary.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossary. The AtlasGlossary is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(self, body: Union[_models.AtlasGlossary, JSON, IO[bytes]], **kwargs: Any) -> _models.AtlasGlossary:
        """Create a glossary.

        :param body: Body parameter. Is one of the following types: AtlasGlossary, JSON, IO[bytes]
         Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossary or JSON or IO[bytes]
        :return: AtlasGlossary. The AtlasGlossary is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasGlossary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_create_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossary, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_categories(
        self, body: List[_models.AtlasGlossaryCategory], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.AtlasGlossaryCategory]:
        """Create glossary category in bulk.

        :param body: An array of glossary category definitions to be created. Required.
        :type body: list[~azure.purview.datamap.models.AtlasGlossaryCategory]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of AtlasGlossaryCategory
        :rtype: list[~azure.purview.datamap.models.AtlasGlossaryCategory]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_categories(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.AtlasGlossaryCategory]:
        """Create glossary category in bulk.

        :param body: An array of glossary category definitions to be created. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of AtlasGlossaryCategory
        :rtype: list[~azure.purview.datamap.models.AtlasGlossaryCategory]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_categories(
        self, body: Union[List[_models.AtlasGlossaryCategory], IO[bytes]], **kwargs: Any
    ) -> List[_models.AtlasGlossaryCategory]:
        """Create glossary category in bulk.

        :param body: An array of glossary category definitions to be created. Is either a
         [AtlasGlossaryCategory] type or a IO[bytes] type. Required.
        :type body: list[~azure.purview.datamap.models.AtlasGlossaryCategory] or IO[bytes]
        :return: list of AtlasGlossaryCategory
        :rtype: list[~azure.purview.datamap.models.AtlasGlossaryCategory]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.AtlasGlossaryCategory]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_create_categories_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.AtlasGlossaryCategory], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_category(
        self, body: _models.AtlasGlossaryCategory, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        """Create a glossary category.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_category(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        """Create a glossary category.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_category(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        """Create a glossary category.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_category(
        self, body: Union[_models.AtlasGlossaryCategory, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        """Create a glossary category.

        :param body: Body parameter. Is one of the following types: AtlasGlossaryCategory, JSON,
         IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossaryCategory or JSON or IO[bytes]
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasGlossaryCategory] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_create_category_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossaryCategory, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_category(self, category_id: str, **kwargs: Any) -> _models.AtlasGlossaryCategory:
        """Get specific glossary category by its GUID.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasGlossaryCategory] = kwargs.pop("cls", None)

        _request = build_glossary_get_category_request(
            category_id=category_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossaryCategory, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_category(
        self,
        category_id: str,
        body: _models.AtlasGlossaryCategory,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        """Update the given glossary category by its GUID.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_category(
        self, category_id: str, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        """Update the given glossary category by its GUID.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :param body: Body parameter. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_category(
        self, category_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        """Update the given glossary category by its GUID.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_category(
        self, category_id: str, body: Union[_models.AtlasGlossaryCategory, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        """Update the given glossary category by its GUID.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :param body: Body parameter. Is one of the following types: AtlasGlossaryCategory, JSON,
         IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossaryCategory or JSON or IO[bytes]
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasGlossaryCategory] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_update_category_request(
            category_id=category_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossaryCategory, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_category(self, category_id: str, **kwargs: Any) -> None:
        """Delete a glossary category.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_glossary_delete_category_request(
            category_id=category_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def partial_update_category(
        self, category_id: str, body: Dict[str, str], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        """Update the glossary category partially. So far we only supports partial
        updating shortDescription and longDescription for category.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :param body: A map containing keys as attribute names and values as corresponding attribute
         values for partial update. Required.
        :type body: dict[str, str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def partial_update_category(
        self, category_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        """Update the glossary category partially. So far we only supports partial
        updating shortDescription and longDescription for category.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :param body: A map containing keys as attribute names and values as corresponding attribute
         values for partial update. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def partial_update_category(
        self, category_id: str, body: Union[Dict[str, str], IO[bytes]], **kwargs: Any
    ) -> _models.AtlasGlossaryCategory:
        """Update the glossary category partially. So far we only supports partial
        updating shortDescription and longDescription for category.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :param body: A map containing keys as attribute names and values as corresponding attribute
         values for partial update. Is either a {str: str} type or a IO[bytes] type. Required.
        :type body: dict[str, str] or IO[bytes]
        :return: AtlasGlossaryCategory. The AtlasGlossaryCategory is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryCategory
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasGlossaryCategory] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_partial_update_category_request(
            category_id=category_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossaryCategory, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_related_categories(
        self,
        category_id: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = None,
        **kwargs: Any
    ) -> Dict[str, List[_models.AtlasRelatedCategoryHeader]]:
        """Get all related categories (parent and children). Limit, offset, and sort
        parameters are currently not being enabled and won't work even they are passed.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is None.
        :paramtype sort: str
        :return: dict mapping str to list of AtlasRelatedCategoryHeader
        :rtype: dict[str, list[~azure.purview.datamap.models.AtlasRelatedCategoryHeader]]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Dict[str, List[_models.AtlasRelatedCategoryHeader]]] = kwargs.pop("cls", None)

        _request = build_glossary_get_related_categories_request(
            category_id=category_id,
            limit=limit,
            offset=offset,
            sort=sort,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(Dict[str, List[_models.AtlasRelatedCategoryHeader]], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_category_terms(
        self,
        category_id: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.AtlasRelatedTermHeader]:
        """Get all terms associated with the specific category.

        :param category_id: The globally unique identifier of the category. Required.
        :type category_id: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is None.
        :paramtype sort: str
        :return: list of AtlasRelatedTermHeader
        :rtype: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.AtlasRelatedTermHeader]] = kwargs.pop("cls", None)

        _request = build_glossary_get_category_terms_request(
            category_id=category_id,
            limit=limit,
            offset=offset,
            sort=sort,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.AtlasRelatedTermHeader], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_term(
        self,
        body: _models.AtlasGlossaryTerm,
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        """Create a glossary term.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_term(
        self,
        body: JSON,
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        """Create a glossary term.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_term(
        self,
        body: IO[bytes],
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        """Create a glossary term.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_term(
        self,
        body: Union[_models.AtlasGlossaryTerm, JSON, IO[bytes]],
        *,
        include_term_hierarchy: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        """Create a glossary term.

        :param body: Body parameter. Is one of the following types: AtlasGlossaryTerm, JSON, IO[bytes]
         Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossaryTerm or JSON or IO[bytes]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasGlossaryTerm] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_create_term_request(
            include_term_hierarchy=include_term_hierarchy,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossaryTerm, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_term(self, term_id: str, **kwargs: Any) -> _models.AtlasGlossaryTerm:
        """Get a specific glossary term by its GUID.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasGlossaryTerm] = kwargs.pop("cls", None)

        _request = build_glossary_get_term_request(
            term_id=term_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossaryTerm, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update_term(
        self,
        term_id: str,
        body: _models.AtlasGlossaryTerm,
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        """Update the given glossary term by its GUID.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_term(
        self,
        term_id: str,
        body: JSON,
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        """Update the given glossary term by its GUID.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: Body parameter. Required.
        :type body: JSON
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update_term(
        self,
        term_id: str,
        body: IO[bytes],
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        """Update the given glossary term by its GUID.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update_term(
        self,
        term_id: str,
        body: Union[_models.AtlasGlossaryTerm, JSON, IO[bytes]],
        *,
        include_term_hierarchy: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        """Update the given glossary term by its GUID.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: Body parameter. Is one of the following types: AtlasGlossaryTerm, JSON, IO[bytes]
         Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossaryTerm or JSON or IO[bytes]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasGlossaryTerm] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_update_term_request(
            term_id=term_id,
            include_term_hierarchy=include_term_hierarchy,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossaryTerm, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete_term(self, term_id: str, **kwargs: Any) -> None:
        """Delete a glossary term.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_glossary_delete_term_request(
            term_id=term_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def partial_update_term(
        self,
        term_id: str,
        body: Dict[str, str],
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        """Update the glossary term partially. So far we only supports partial updating
        shortDescription, longDescription, abbreviation, usage and status for term.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: A map containing keys as attribute names and values as corresponding attribute
         values to be updated. Required.
        :type body: dict[str, str]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def partial_update_term(
        self,
        term_id: str,
        body: IO[bytes],
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        """Update the glossary term partially. So far we only supports partial updating
        shortDescription, longDescription, abbreviation, usage and status for term.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: A map containing keys as attribute names and values as corresponding attribute
         values to be updated. Required.
        :type body: IO[bytes]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def partial_update_term(
        self,
        term_id: str,
        body: Union[Dict[str, str], IO[bytes]],
        *,
        include_term_hierarchy: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.AtlasGlossaryTerm:
        """Update the glossary term partially. So far we only supports partial updating
        shortDescription, longDescription, abbreviation, usage and status for term.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: A map containing keys as attribute names and values as corresponding attribute
         values to be updated. Is either a {str: str} type or a IO[bytes] type. Required.
        :type body: dict[str, str] or IO[bytes]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :return: AtlasGlossaryTerm. The AtlasGlossaryTerm is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryTerm
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasGlossaryTerm] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_partial_update_term_request(
            term_id=term_id,
            include_term_hierarchy=include_term_hierarchy,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossaryTerm, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_terms(
        self,
        body: List[_models.AtlasGlossaryTerm],
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.AtlasGlossaryTerm]:
        """Create glossary terms in bulk.

        :param body: An array of glossary term definitions to be created in bulk. Required.
        :type body: list[~azure.purview.datamap.models.AtlasGlossaryTerm]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of AtlasGlossaryTerm
        :rtype: list[~azure.purview.datamap.models.AtlasGlossaryTerm]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_terms(
        self,
        body: IO[bytes],
        *,
        include_term_hierarchy: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> List[_models.AtlasGlossaryTerm]:
        """Create glossary terms in bulk.

        :param body: An array of glossary term definitions to be created in bulk. Required.
        :type body: IO[bytes]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of AtlasGlossaryTerm
        :rtype: list[~azure.purview.datamap.models.AtlasGlossaryTerm]
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_terms(
        self,
        body: Union[List[_models.AtlasGlossaryTerm], IO[bytes]],
        *,
        include_term_hierarchy: Optional[bool] = None,
        **kwargs: Any
    ) -> List[_models.AtlasGlossaryTerm]:
        """Create glossary terms in bulk.

        :param body: An array of glossary term definitions to be created in bulk. Is either a
         [AtlasGlossaryTerm] type or a IO[bytes] type. Required.
        :type body: list[~azure.purview.datamap.models.AtlasGlossaryTerm] or IO[bytes]
        :keyword include_term_hierarchy: Whether include term hierarchy. Default value is None.
        :paramtype include_term_hierarchy: bool
        :return: list of AtlasGlossaryTerm
        :rtype: list[~azure.purview.datamap.models.AtlasGlossaryTerm]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.AtlasGlossaryTerm]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_create_terms_request(
            include_term_hierarchy=include_term_hierarchy,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.AtlasGlossaryTerm], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_entities_assigned_with_term(
        self,
        term_id: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.AtlasRelatedObjectId]:
        """List all related objects assigned with the specified term. Recommend using
        limit/offset to get pagination result.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is None.
        :paramtype sort: str
        :return: list of AtlasRelatedObjectId
        :rtype: list[~azure.purview.datamap.models.AtlasRelatedObjectId]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.AtlasRelatedObjectId]] = kwargs.pop("cls", None)

        _request = build_glossary_get_entities_assigned_with_term_request(
            term_id=term_id,
            limit=limit,
            offset=offset,
            sort=sort,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.AtlasRelatedObjectId], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def assign_term_to_entities(
        self,
        term_id: str,
        body: List[_models.AtlasRelatedObjectId],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Assign the given term to the provided list of related objects. Recommend using
        small batches with multiple API calls.

        `Entities Create Or Update
        operation
        <https://learn.microsoft.com/en-us/rest/api/purview/datamapdataplane/entity/bulk-create-or-update?tabs=HTTP>`_
        is an alternative to assign a term to multiple entities.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: An array of related object IDs to which the term has to be associated. Required.
        :type body: list[~azure.purview.datamap.models.AtlasRelatedObjectId]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def assign_term_to_entities(
        self, term_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Assign the given term to the provided list of related objects. Recommend using
        small batches with multiple API calls.

        `Entities Create Or Update
        operation
        <https://learn.microsoft.com/en-us/rest/api/purview/datamapdataplane/entity/bulk-create-or-update?tabs=HTTP>`_
        is an alternative to assign a term to multiple entities.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: An array of related object IDs to which the term has to be associated. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def assign_term_to_entities(
        self, term_id: str, body: Union[List[_models.AtlasRelatedObjectId], IO[bytes]], **kwargs: Any
    ) -> None:
        """Assign the given term to the provided list of related objects. Recommend using
        small batches with multiple API calls.

        `Entities Create Or Update
        operation
        <https://learn.microsoft.com/en-us/rest/api/purview/datamapdataplane/entity/bulk-create-or-update?tabs=HTTP>`_
        is an alternative to assign a term to multiple entities.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: An array of related object IDs to which the term has to be associated. Is either a
         [AtlasRelatedObjectId] type or a IO[bytes] type. Required.
        :type body: list[~azure.purview.datamap.models.AtlasRelatedObjectId] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_assign_term_to_entities_request(
            term_id=term_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @overload
    async def delete_term_assignment_from_entities(
        self,
        term_id: str,
        body: List[_models.AtlasRelatedObjectId],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> None:
        """Delete the term assignment for the given list of related objects.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: An array of related object IDs from which the term has to be dissociated.
         Required.
        :type body: list[~azure.purview.datamap.models.AtlasRelatedObjectId]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def delete_term_assignment_from_entities(
        self, term_id: str, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Delete the term assignment for the given list of related objects.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: An array of related object IDs from which the term has to be dissociated.
         Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def delete_term_assignment_from_entities(
        self, term_id: str, body: Union[List[_models.AtlasRelatedObjectId], IO[bytes]], **kwargs: Any
    ) -> None:
        """Delete the term assignment for the given list of related objects.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :param body: An array of related object IDs from which the term has to be dissociated. Is
         either a [AtlasRelatedObjectId] type or a IO[bytes] type. Required.
        :type body: list[~azure.purview.datamap.models.AtlasRelatedObjectId] or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_delete_term_assignment_from_entities_request(
            term_id=term_id,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_related_terms(
        self,
        term_id: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = None,
        **kwargs: Any
    ) -> Dict[str, List[_models.AtlasRelatedTermHeader]]:
        """Get all related terms for a specific term by its GUID. Limit, offset, and sort
        parameters are currently not being enabled and won't work even they are passed.

        :param term_id: The globally unique identifier for glossary term. Required.
        :type term_id: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is None.
        :paramtype sort: str
        :return: dict mapping str to list of AtlasRelatedTermHeader
        :rtype: dict[str, list[~azure.purview.datamap.models.AtlasRelatedTermHeader]]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[Dict[str, List[_models.AtlasRelatedTermHeader]]] = kwargs.pop("cls", None)

        _request = build_glossary_get_related_terms_request(
            term_id=term_id,
            limit=limit,
            offset=offset,
            sort=sort,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(Dict[str, List[_models.AtlasRelatedTermHeader]], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get(self, glossary_id: str, **kwargs: Any) -> _models.AtlasGlossary:
        """Get a specific Glossary by its GUID.

        :param glossary_id: The globally unique identifier for glossary. Required.
        :type glossary_id: str
        :return: AtlasGlossary. The AtlasGlossary is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasGlossary] = kwargs.pop("cls", None)

        _request = build_glossary_get_request(
            glossary_id=glossary_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossary, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update(
        self,
        glossary_id: str,
        body: _models.AtlasGlossary,
        *,
        ignore_terms_and_categories: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossary:
        """Update the given glossary.

        :param glossary_id: The globally unique identifier for glossary. Required.
        :type glossary_id: str
        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossary
        :keyword ignore_terms_and_categories: Whether ignore terms and categories. Default value is
         None.
        :paramtype ignore_terms_and_categories: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossary. The AtlasGlossary is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        glossary_id: str,
        body: JSON,
        *,
        ignore_terms_and_categories: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossary:
        """Update the given glossary.

        :param glossary_id: The globally unique identifier for glossary. Required.
        :type glossary_id: str
        :param body: Body parameter. Required.
        :type body: JSON
        :keyword ignore_terms_and_categories: Whether ignore terms and categories. Default value is
         None.
        :paramtype ignore_terms_and_categories: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossary. The AtlasGlossary is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        glossary_id: str,
        body: IO[bytes],
        *,
        ignore_terms_and_categories: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossary:
        """Update the given glossary.

        :param glossary_id: The globally unique identifier for glossary. Required.
        :type glossary_id: str
        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword ignore_terms_and_categories: Whether ignore terms and categories. Default value is
         None.
        :paramtype ignore_terms_and_categories: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossary. The AtlasGlossary is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        glossary_id: str,
        body: Union[_models.AtlasGlossary, JSON, IO[bytes]],
        *,
        ignore_terms_and_categories: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.AtlasGlossary:
        """Update the given glossary.

        :param glossary_id: The globally unique identifier for glossary. Required.
        :type glossary_id: str
        :param body: Body parameter. Is one of the following types: AtlasGlossary, JSON, IO[bytes]
         Required.
        :type body: ~azure.purview.datamap.models.AtlasGlossary or JSON or IO[bytes]
        :keyword ignore_terms_and_categories: Whether ignore terms and categories. Default value is
         None.
        :paramtype ignore_terms_and_categories: bool
        :return: AtlasGlossary. The AtlasGlossary is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasGlossary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_update_request(
            glossary_id=glossary_id,
            ignore_terms_and_categories=ignore_terms_and_categories,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossary, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(self, glossary_id: str, **kwargs: Any) -> None:
        """Delete a glossary. Will delete underlying terms/categories together. Recommend
        separate delete terms and categories.

        :param glossary_id: The globally unique identifier for glossary. Required.
        :type glossary_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_glossary_delete_request(
            glossary_id=glossary_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_categories(
        self,
        glossary_id: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.AtlasGlossaryCategory]:
        """Get the categories belonging to a specific glossary. Recommend using
        limit/offset to get pagination result.

        :param glossary_id: The globally unique identifier for glossary. Required.
        :type glossary_id: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is None.
        :paramtype sort: str
        :return: list of AtlasGlossaryCategory
        :rtype: list[~azure.purview.datamap.models.AtlasGlossaryCategory]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.AtlasGlossaryCategory]] = kwargs.pop("cls", None)

        _request = build_glossary_get_categories_request(
            glossary_id=glossary_id,
            limit=limit,
            offset=offset,
            sort=sort,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.AtlasGlossaryCategory], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_categories_headers(
        self,
        glossary_id: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.AtlasRelatedCategoryHeader]:
        """Get the category headers belonging to a specific glossary. Recommend using
        limit/offset to get pagination result.

        :param glossary_id: The globally unique identifier for glossary. Required.
        :type glossary_id: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is None.
        :paramtype sort: str
        :return: list of AtlasRelatedCategoryHeader
        :rtype: list[~azure.purview.datamap.models.AtlasRelatedCategoryHeader]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.AtlasRelatedCategoryHeader]] = kwargs.pop("cls", None)

        _request = build_glossary_get_categories_headers_request(
            glossary_id=glossary_id,
            limit=limit,
            offset=offset,
            sort=sort,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.AtlasRelatedCategoryHeader], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_detailed(self, glossary_id: str, **kwargs: Any) -> _models.AtlasGlossaryExtInfo:
        """Get a specific glossary with detailed information. This API is not
        recommend.

        Recommend to fetch terms/categories details separately using

        GET /datamap/api/atlas/v2/glossary/{glossaryId}/terms and

        GET /datamap/api/atlas/v2/glossary/{glossaryId}/categories.

        :param glossary_id: The globally unique identifier for glossary. Required.
        :type glossary_id: str
        :return: AtlasGlossaryExtInfo. The AtlasGlossaryExtInfo is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossaryExtInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasGlossaryExtInfo] = kwargs.pop("cls", None)

        _request = build_glossary_get_detailed_request(
            glossary_id=glossary_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossaryExtInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def partial_update(
        self,
        glossary_id: str,
        body: Dict[str, str],
        *,
        ignore_terms_and_categories: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossary:
        """Update the glossary partially. Some properties such as qualifiedName are not
        allowed to be updated.

        So far we only supports partial updating
        shortDescription, longDescription, language and usage for glossary.

        Recommend
        using 'ignoreTermsAndCategories=true' to reduce response body size.

        :param glossary_id: The globally unique identifier for glossary. Required.
        :type glossary_id: str
        :param body: A map containing keys as attribute names and values as corresponding attribute
         values. Required.
        :type body: dict[str, str]
        :keyword ignore_terms_and_categories: Whether ignore terms and categories. Default value is
         None.
        :paramtype ignore_terms_and_categories: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossary. The AtlasGlossary is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def partial_update(
        self,
        glossary_id: str,
        body: IO[bytes],
        *,
        ignore_terms_and_categories: Optional[bool] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AtlasGlossary:
        """Update the glossary partially. Some properties such as qualifiedName are not
        allowed to be updated.

        So far we only supports partial updating
        shortDescription, longDescription, language and usage for glossary.

        Recommend
        using 'ignoreTermsAndCategories=true' to reduce response body size.

        :param glossary_id: The globally unique identifier for glossary. Required.
        :type glossary_id: str
        :param body: A map containing keys as attribute names and values as corresponding attribute
         values. Required.
        :type body: IO[bytes]
        :keyword ignore_terms_and_categories: Whether ignore terms and categories. Default value is
         None.
        :paramtype ignore_terms_and_categories: bool
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasGlossary. The AtlasGlossary is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossary
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def partial_update(
        self,
        glossary_id: str,
        body: Union[Dict[str, str], IO[bytes]],
        *,
        ignore_terms_and_categories: Optional[bool] = None,
        **kwargs: Any
    ) -> _models.AtlasGlossary:
        """Update the glossary partially. Some properties such as qualifiedName are not
        allowed to be updated.

        So far we only supports partial updating
        shortDescription, longDescription, language and usage for glossary.

        Recommend
        using 'ignoreTermsAndCategories=true' to reduce response body size.

        :param glossary_id: The globally unique identifier for glossary. Required.
        :type glossary_id: str
        :param body: A map containing keys as attribute names and values as corresponding attribute
         values. Is either a {str: str} type or a IO[bytes] type. Required.
        :type body: dict[str, str] or IO[bytes]
        :keyword ignore_terms_and_categories: Whether ignore terms and categories. Default value is
         None.
        :paramtype ignore_terms_and_categories: bool
        :return: AtlasGlossary. The AtlasGlossary is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasGlossary
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasGlossary] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_glossary_partial_update_request(
            glossary_id=glossary_id,
            ignore_terms_and_categories=ignore_terms_and_categories,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasGlossary, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_terms(
        self,
        glossary_id: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.AtlasGlossaryTerm]:
        """Get terms belonging to a specific glossary. Recommend using limit/offset to get
        pagination result.

        :param glossary_id: The globally unique identifier for glossary. Required.
        :type glossary_id: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is None.
        :paramtype sort: str
        :return: list of AtlasGlossaryTerm
        :rtype: list[~azure.purview.datamap.models.AtlasGlossaryTerm]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.AtlasGlossaryTerm]] = kwargs.pop("cls", None)

        _request = build_glossary_get_terms_request(
            glossary_id=glossary_id,
            limit=limit,
            offset=offset,
            sort=sort,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.AtlasGlossaryTerm], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_term_headers(
        self,
        glossary_id: str,
        *,
        limit: Optional[int] = None,
        offset: Optional[int] = None,
        sort: Optional[str] = None,
        **kwargs: Any
    ) -> List[_models.AtlasRelatedTermHeader]:
        """Get term headers belonging to a specific glossary. Recommend using limit/offset
        to get pagination result.

        :param glossary_id: The globally unique identifier for glossary. Required.
        :type glossary_id: str
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword sort: The sort order, ASC (default) or DESC. Default value is None.
        :paramtype sort: str
        :return: list of AtlasRelatedTermHeader
        :rtype: list[~azure.purview.datamap.models.AtlasRelatedTermHeader]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.AtlasRelatedTermHeader]] = kwargs.pop("cls", None)

        _request = build_glossary_get_term_headers_request(
            glossary_id=glossary_id,
            limit=limit,
            offset=offset,
            sort=sort,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.AtlasRelatedTermHeader], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class DiscoveryOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.datamap.aio.DataMapClient`'s
        :attr:`discovery` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: DataMapClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def query(
        self, body: _models.QueryOptions, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.QueryResult:
        """Get data using search.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.QueryOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: QueryResult. The QueryResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.QueryResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def query(self, body: JSON, *, content_type: str = "application/json", **kwargs: Any) -> _models.QueryResult:
        """Get data using search.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: QueryResult. The QueryResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.QueryResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def query(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.QueryResult:
        """Get data using search.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: QueryResult. The QueryResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.QueryResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def query(self, body: Union[_models.QueryOptions, JSON, IO[bytes]], **kwargs: Any) -> _models.QueryResult:
        """Get data using search.

        :param body: Body parameter. Is one of the following types: QueryOptions, JSON, IO[bytes]
         Required.
        :type body: ~azure.purview.datamap.models.QueryOptions or JSON or IO[bytes]
        :return: QueryResult. The QueryResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.QueryResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.QueryResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_discovery_query_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.QueryResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def suggest(
        self, body: _models.SuggestOptions, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.SuggestResult:
        """Get search suggestions by query criteria.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.SuggestOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SuggestResult. The SuggestResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.SuggestResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def suggest(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.SuggestResult:
        """Get search suggestions by query criteria.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SuggestResult. The SuggestResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.SuggestResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def suggest(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.SuggestResult:
        """Get search suggestions by query criteria.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: SuggestResult. The SuggestResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.SuggestResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def suggest(
        self, body: Union[_models.SuggestOptions, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.SuggestResult:
        """Get search suggestions by query criteria.

        :param body: Body parameter. Is one of the following types: SuggestOptions, JSON, IO[bytes]
         Required.
        :type body: ~azure.purview.datamap.models.SuggestOptions or JSON or IO[bytes]
        :return: SuggestResult. The SuggestResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.SuggestResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SuggestResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_discovery_suggest_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.SuggestResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def auto_complete(
        self, body: _models.AutoCompleteOptions, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AutoCompleteResult:
        """Get auto complete options.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.AutoCompleteOptions
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AutoCompleteResult. The AutoCompleteResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AutoCompleteResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def auto_complete(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AutoCompleteResult:
        """Get auto complete options.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AutoCompleteResult. The AutoCompleteResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AutoCompleteResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def auto_complete(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AutoCompleteResult:
        """Get auto complete options.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AutoCompleteResult. The AutoCompleteResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AutoCompleteResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def auto_complete(
        self, body: Union[_models.AutoCompleteOptions, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.AutoCompleteResult:
        """Get auto complete options.

        :param body: Body parameter. Is one of the following types: AutoCompleteOptions, JSON,
         IO[bytes] Required.
        :type body: ~azure.purview.datamap.models.AutoCompleteOptions or JSON or IO[bytes]
        :return: AutoCompleteResult. The AutoCompleteResult is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AutoCompleteResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AutoCompleteResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_discovery_auto_complete_request(
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AutoCompleteResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class LineageOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.datamap.aio.DataMapClient`'s
        :attr:`lineage` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: DataMapClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self, guid: str, *, direction: Union[str, _models.LineageDirection], depth: Optional[int] = None, **kwargs: Any
    ) -> _models.AtlasLineageInfo:
        """Get lineage info of the entity specified by GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :keyword direction: The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Known
         values are: "INPUT", "OUTPUT", and "BOTH". Required.
        :paramtype direction: str or ~azure.purview.datamap.models.LineageDirection
        :keyword depth: The number of hops for lineage. Default value is None.
        :paramtype depth: int
        :return: AtlasLineageInfo. The AtlasLineageInfo is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasLineageInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasLineageInfo] = kwargs.pop("cls", None)

        _request = build_lineage_get_request(
            guid=guid,
            direction=direction,
            depth=depth,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasLineageInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_next_page(
        self,
        guid: str,
        *,
        direction: Union[str, _models.LineageDirection],
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        **kwargs: Any
    ) -> _models.AtlasLineageInfo:
        """Return immediate next page lineage info about entity with pagination.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :keyword direction: The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Known
         values are: "INPUT", "OUTPUT", and "BOTH". Required.
        :paramtype direction: str or ~azure.purview.datamap.models.LineageDirection
        :keyword offset: The offset for pagination purpose. Default value is None.
        :paramtype offset: int
        :keyword limit: The page size - by default there is no paging. Default value is None.
        :paramtype limit: int
        :return: AtlasLineageInfo. The AtlasLineageInfo is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasLineageInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasLineageInfo] = kwargs.pop("cls", None)

        _request = build_lineage_get_next_page_request(
            guid=guid,
            direction=direction,
            offset=offset,
            limit=limit,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasLineageInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_by_unique_attribute(
        self,
        type_name: str,
        *,
        direction: Union[str, _models.LineageDirection],
        depth: Optional[int] = None,
        attribute: Optional[str] = None,
        **kwargs: Any
    ) -> _models.AtlasLineageInfo:
        """Return lineage info about entity.

        In addition to the typeName path parameter,
        attribute key-value pair(s) can be provided in the following
        format

        attr:[attrName]=[attrValue]

        NOTE: The attrName and attrValue should be
        unique across entities, eg. qualifiedName.

        The REST request would look
        something like this:

        GET
        /v2/lineage/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.

        :param type_name: The name of the type. Required.
        :type type_name: str
        :keyword direction: The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Known
         values are: "INPUT", "OUTPUT", and "BOTH". Required.
        :paramtype direction: str or ~azure.purview.datamap.models.LineageDirection
        :keyword depth: The number of hops for lineage. Default value is None.
        :paramtype depth: int
        :keyword attribute: The qualified name of the entity. (This is only an example. qualifiedName
         can
         be changed to other unique attributes). Default value is None.
        :paramtype attribute: str
        :return: AtlasLineageInfo. The AtlasLineageInfo is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasLineageInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasLineageInfo] = kwargs.pop("cls", None)

        _request = build_lineage_get_by_unique_attribute_request(
            type_name=type_name,
            direction=direction,
            depth=depth,
            attribute=attribute,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasLineageInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class RelationshipOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.datamap.aio.DataMapClient`'s
        :attr:`relationship` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: DataMapClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def create(
        self, body: _models.AtlasRelationship, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasRelationship:
        """Create a new relationship between entities.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.AtlasRelationship
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasRelationship. The AtlasRelationship is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasRelationship
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasRelationship:
        """Create a new relationship between entities.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasRelationship. The AtlasRelationship is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasRelationship
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasRelationship:
        """Create a new relationship between entities.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasRelationship. The AtlasRelationship is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasRelationship
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create(
        self, body: Union[_models.AtlasRelationship, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.AtlasRelationship:
        """Create a new relationship between entities.

        :param body: Body parameter. Is one of the following types: AtlasRelationship, JSON, IO[bytes]
         Required.
        :type body: ~azure.purview.datamap.models.AtlasRelationship or JSON or IO[bytes]
        :return: AtlasRelationship. The AtlasRelationship is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasRelationship
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasRelationship] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_relationship_create_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasRelationship, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update(
        self, body: _models.AtlasRelationship, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasRelationship:
        """Update an existing relationship between entities.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.AtlasRelationship
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasRelationship. The AtlasRelationship is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasRelationship
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasRelationship:
        """Update an existing relationship between entities.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasRelationship. The AtlasRelationship is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasRelationship
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasRelationship:
        """Update an existing relationship between entities.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasRelationship. The AtlasRelationship is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasRelationship
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self, body: Union[_models.AtlasRelationship, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.AtlasRelationship:
        """Update an existing relationship between entities.

        :param body: Body parameter. Is one of the following types: AtlasRelationship, JSON, IO[bytes]
         Required.
        :type body: ~azure.purview.datamap.models.AtlasRelationship or JSON or IO[bytes]
        :return: AtlasRelationship. The AtlasRelationship is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasRelationship
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasRelationship] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_relationship_update_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasRelationship, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get(
        self, guid: str, *, extended_info: Optional[bool] = None, **kwargs: Any
    ) -> _models.AtlasRelationshipWithExtInfo:
        """Get relationship information between entities by its GUID.

        :param guid: The globally unique identifier of the relationship. Required.
        :type guid: str
        :keyword extended_info: Limits whether includes extended information. Default value is None.
        :paramtype extended_info: bool
        :return: AtlasRelationshipWithExtInfo. The AtlasRelationshipWithExtInfo is compatible with
         MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasRelationshipWithExtInfo
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasRelationshipWithExtInfo] = kwargs.pop("cls", None)

        _request = build_relationship_get_request(
            guid=guid,
            extended_info=extended_info,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasRelationshipWithExtInfo, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(self, guid: str, **kwargs: Any) -> None:
        """Delete a relationship between entities by its GUID.

        :param guid: The globally unique identifier of the relationship. Required.
        :type guid: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_relationship_delete_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore


class TypeDefinitionOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.purview.datamap.aio.DataMapClient`'s
        :attr:`type_definition` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: DataMapClientConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get_business_metadata_by_id(self, guid: str, **kwargs: Any) -> _models.AtlasBusinessMetadataDef:
        """Get the businessMetadata definition for the given guid.

        :param guid: businessMetadata guid. Required.
        :type guid: str
        :return: AtlasBusinessMetadataDef. The AtlasBusinessMetadataDef is compatible with
         MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasBusinessMetadataDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasBusinessMetadataDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_business_metadata_by_id_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasBusinessMetadataDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_business_metadata_by_name(self, name: str, **kwargs: Any) -> _models.AtlasBusinessMetadataDef:
        """Get the businessMetadata definition by it's name (unique).

        :param name: businessMetadata name. Required.
        :type name: str
        :return: AtlasBusinessMetadataDef. The AtlasBusinessMetadataDef is compatible with
         MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasBusinessMetadataDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasBusinessMetadataDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_business_metadata_by_name_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasBusinessMetadataDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_classification_by_id(self, guid: str, **kwargs: Any) -> _models.AtlasClassificationDef:
        """Get the classification definition for the given GUID.

        :param guid: The globally unique identifier of the classification. Required.
        :type guid: str
        :return: AtlasClassificationDef. The AtlasClassificationDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasClassificationDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasClassificationDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_classification_by_id_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasClassificationDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_classification_by_name(self, name: str, **kwargs: Any) -> _models.AtlasClassificationDef:
        """Get the classification definition by its name (unique).

        :param name: The name of the classification. Required.
        :type name: str
        :return: AtlasClassificationDef. The AtlasClassificationDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasClassificationDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasClassificationDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_classification_by_name_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasClassificationDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_entity_by_id(self, guid: str, **kwargs: Any) -> _models.AtlasEntityDef:
        """Get the Entity definition for the given GUID.

        :param guid: The globally unique identifier of the entity. Required.
        :type guid: str
        :return: AtlasEntityDef. The AtlasEntityDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasEntityDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasEntityDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_entity_by_id_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasEntityDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_entity_by_name(self, name: str, **kwargs: Any) -> _models.AtlasEntityDef:
        """Get the entity definition by its name (unique).

        :param name: The name of the entity. Required.
        :type name: str
        :return: AtlasEntityDef. The AtlasEntityDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasEntityDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasEntityDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_entity_by_name_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasEntityDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_enum_by_id(self, guid: str, **kwargs: Any) -> _models.AtlasEnumDef:
        """Get the enum definition for the given GUID.

        :param guid: The globally unique identifier of the enum. Required.
        :type guid: str
        :return: AtlasEnumDef. The AtlasEnumDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasEnumDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasEnumDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_enum_by_id_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasEnumDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_enum_by_name(self, name: str, **kwargs: Any) -> _models.AtlasEnumDef:
        """Get the enum definition by its name (unique).

        :param name: The name of the enum. Required.
        :type name: str
        :return: AtlasEnumDef. The AtlasEnumDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasEnumDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasEnumDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_enum_by_name_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasEnumDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_relationship_by_id(self, guid: str, **kwargs: Any) -> _models.AtlasRelationshipDef:
        """Get the relationship definition for the given GUID.

        :param guid: The globally unique identifier of the relationship. Required.
        :type guid: str
        :return: AtlasRelationshipDef. The AtlasRelationshipDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasRelationshipDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasRelationshipDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_relationship_by_id_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasRelationshipDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_relationship_by_name(self, name: str, **kwargs: Any) -> _models.AtlasRelationshipDef:
        """Get the relationship definition by its name (unique).

        :param name: The name of the relationship. Required.
        :type name: str
        :return: AtlasRelationshipDef. The AtlasRelationshipDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasRelationshipDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasRelationshipDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_relationship_by_name_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasRelationshipDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_struct_by_id(self, guid: str, **kwargs: Any) -> _models.AtlasStructDef:
        """Get the struct definition for the given GUID.

        :param guid: The globally unique identifier of the struct. Required.
        :type guid: str
        :return: AtlasStructDef. The AtlasStructDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasStructDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasStructDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_struct_by_id_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasStructDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_struct_by_name(self, name: str, **kwargs: Any) -> _models.AtlasStructDef:
        """Get the struct definition by its name (unique).

        :param name: The name of the struct. Required.
        :type name: str
        :return: AtlasStructDef. The AtlasStructDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasStructDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasStructDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_struct_by_name_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasStructDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_by_id(self, guid: str, **kwargs: Any) -> _models.AtlasTypeDef:
        """Get the type definition for the given GUID.

        :param guid: The globally unique identifier of the type. Required.
        :type guid: str
        :return: AtlasTypeDef. The AtlasTypeDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasTypeDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasTypeDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_by_id_request(
            guid=guid,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasTypeDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_by_name(self, name: str, **kwargs: Any) -> _models.AtlasTypeDef:
        """Get the type definition by its name (unique).

        :param name: The name of the type. Required.
        :type name: str
        :return: AtlasTypeDef. The AtlasTypeDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasTypeDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasTypeDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_by_name_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasTypeDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(self, name: str, **kwargs: Any) -> None:
        """Delete API for type identified by its name.

        :param name: The name of the type. Required.
        :type name: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_type_definition_delete_request(
            name=name,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get(
        self,
        *,
        include_term_template: Optional[bool] = None,
        type: Optional[Union[str, _models.TypeCategory]] = None,
        **kwargs: Any
    ) -> _models.AtlasTypesDef:
        """List all type definitions in bulk.

        :keyword include_term_template: Whether include termtemplatedef when return all typedefs.
         This is always true
         when search filter type=term_template. Default value is None.
        :paramtype include_term_template: bool
        :keyword type: Typedef name as search filter when get typedefs. Known values are: "PRIMITIVE",
         "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP",
         and "TERM_TEMPLATE". Default value is None.
        :paramtype type: str or ~azure.purview.datamap.models.TypeCategory
        :return: AtlasTypesDef. The AtlasTypesDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasTypesDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AtlasTypesDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_request(
            include_term_template=include_term_template,
            type=type,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasTypesDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def batch_create(
        self, body: _models.AtlasTypesDef, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasTypesDef:
        """Create all atlas type definitions in bulk. Please avoid recreating existing types.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.AtlasTypesDef
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasTypesDef. The AtlasTypesDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasTypesDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def batch_create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasTypesDef:
        """Create all atlas type definitions in bulk. Please avoid recreating existing types.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasTypesDef. The AtlasTypesDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasTypesDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def batch_create(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasTypesDef:
        """Create all atlas type definitions in bulk. Please avoid recreating existing types.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasTypesDef. The AtlasTypesDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasTypesDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def batch_create(
        self, body: Union[_models.AtlasTypesDef, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.AtlasTypesDef:
        """Create all atlas type definitions in bulk. Please avoid recreating existing types.

        :param body: Body parameter. Is one of the following types: AtlasTypesDef, JSON, IO[bytes]
         Required.
        :type body: ~azure.purview.datamap.models.AtlasTypesDef or JSON or IO[bytes]
        :return: AtlasTypesDef. The AtlasTypesDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasTypesDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasTypesDef] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_type_definition_batch_create_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasTypesDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def batch_update(
        self, body: _models.AtlasTypesDef, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasTypesDef:
        """Update all types in bulk, changes detected in the type definitions would be
        persisted.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.AtlasTypesDef
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasTypesDef. The AtlasTypesDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasTypesDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def batch_update(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasTypesDef:
        """Update all types in bulk, changes detected in the type definitions would be
        persisted.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasTypesDef. The AtlasTypesDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasTypesDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def batch_update(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.AtlasTypesDef:
        """Update all types in bulk, changes detected in the type definitions would be
        persisted.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: AtlasTypesDef. The AtlasTypesDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasTypesDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def batch_update(
        self, body: Union[_models.AtlasTypesDef, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.AtlasTypesDef:
        """Update all types in bulk, changes detected in the type definitions would be
        persisted.

        :param body: Body parameter. Is one of the following types: AtlasTypesDef, JSON, IO[bytes]
         Required.
        :type body: ~azure.purview.datamap.models.AtlasTypesDef or JSON or IO[bytes]
        :return: AtlasTypesDef. The AtlasTypesDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.AtlasTypesDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AtlasTypesDef] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_type_definition_batch_update_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.AtlasTypesDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def batch_delete(
        self, body: _models.AtlasTypesDef, *, content_type: str = "application/json", **kwargs: Any
    ) -> None:
        """Delete API for all types in bulk.

        :param body: Body parameter. Required.
        :type body: ~azure.purview.datamap.models.AtlasTypesDef
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def batch_delete(self, body: JSON, *, content_type: str = "application/json", **kwargs: Any) -> None:
        """Delete API for all types in bulk.

        :param body: Body parameter. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def batch_delete(self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any) -> None:
        """Delete API for all types in bulk.

        :param body: Body parameter. Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def batch_delete(self, body: Union[_models.AtlasTypesDef, JSON, IO[bytes]], **kwargs: Any) -> None:
        """Delete API for all types in bulk.

        :param body: Body parameter. Is one of the following types: AtlasTypesDef, JSON, IO[bytes]
         Required.
        :type body: ~azure.purview.datamap.models.AtlasTypesDef or JSON or IO[bytes]
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[None] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_type_definition_batch_delete_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace_async
    async def get_headers(
        self,
        *,
        include_term_template: Optional[bool] = None,
        type: Optional[Union[str, _models.TypeCategory]] = None,
        **kwargs: Any
    ) -> List[_models.AtlasTypeDefHeader]:
        """List all type definitions returned as a list of minimal information header.

        :keyword include_term_template: Whether include termtemplatedef when return all typedefs.
         This is always true
         when search filter type=term_template. Default value is None.
        :paramtype include_term_template: bool
        :keyword type: Typedef name as search filter when get typedefs. Known values are: "PRIMITIVE",
         "OBJECT_ID_TYPE", "ENUM", "STRUCT", "CLASSIFICATION", "ENTITY", "ARRAY", "MAP", "RELATIONSHIP",
         and "TERM_TEMPLATE". Default value is None.
        :paramtype type: str or ~azure.purview.datamap.models.TypeCategory
        :return: list of AtlasTypeDefHeader
        :rtype: list[~azure.purview.datamap.models.AtlasTypeDefHeader]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.AtlasTypeDefHeader]] = kwargs.pop("cls", None)

        _request = build_type_definition_get_headers_request(
            include_term_template=include_term_template,
            type=type,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.AtlasTypeDefHeader], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_term_template_by_id(self, guid: str, **kwargs: Any) -> _models.TermTemplateDef:
        """Get the term template definition for the given GUID.

        :param guid: The globally unique identifier of the term template. Required.
        :type guid: str
        :return: TermTemplateDef. The TermTemplateDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.TermTemplateDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TermTemplateDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_term_template_by_id_request(
            guid=guid,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TermTemplateDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_term_template_by_name(self, name: str, **kwargs: Any) -> _models.TermTemplateDef:
        """Get the term template definition by its name (unique).

        :param name: The unique name of the term template. Required.
        :type name: str
        :return: TermTemplateDef. The TermTemplateDef is compatible with MutableMapping
        :rtype: ~azure.purview.datamap.models.TermTemplateDef
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.TermTemplateDef] = kwargs.pop("cls", None)

        _request = build_type_definition_get_term_template_by_name_request(
            name=name,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models.AtlasErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.TermTemplateDef, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
