# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class Action(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The action of the command."""

    INSTALL = "Install"
    LAUNCH = "Launch"
    CLOSE = "Close"
    UNINSTALL = "Uninstall"
    CUSTOM = "Custom"


class AnalysisResultName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AnalysisResultName."""

    SCRIPT_EXECUTION = "scriptExecution"
    RELIABILITY = "reliability"
    MEMORY_UTILIZATION = "memoryUtilization"
    CPU_UTILIZATION = "cpuUtilization"
    MEMORY_REGRESSION = "memoryRegression"
    CPU_REGRESSION = "cpuRegression"
    TEST_ANALYSIS = "testAnalysis"


class AnalysisResultType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the Analysis Result."""

    SCRIPT_EXECUTION = "ScriptExecution"
    RELIABILITY = "Reliability"
    CPU_UTILIZATION = "CPUUtilization"
    MEMORY_UTILIZATION = "MemoryUtilization"
    CPU_REGRESSION = "CPURegression"
    MEMORY_REGRESSION = "MemoryRegression"
    TEST_ANALYSIS = "TestAnalysis"


class AnalysisStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The analysis status."""

    NONE = "None"
    COMPLETED = "Completed"
    IN_PROGRESS = "InProgress"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    AVAILABLE = "Available"
    NOT_AVAILABLE = "NotAvailable"


class Category(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The category of the failure."""

    NONE = "None"
    UNIDENTIFIED = "Unidentified"
    PACKAGE = "Package"
    OS_UPDATE = "OSUpdate"
    INFRASTRUCTURE = "Infrastructure"


class ContentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of command content."""

    INLINE = "Inline"
    FILE = "File"
    PATH = "Path"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class ExecutionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The execution status of a test."""

    NONE = "None"
    IN_PROGRESS = "InProgress"
    PROCESSING = "Processing"
    COMPLETED = "Completed"
    NOT_EXECUTED = "NotExecuted"
    INCOMPLETE = "Incomplete"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"


class Grade(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The grade of a test."""

    NONE = "None"
    NOT_AVAILABLE = "NotAvailable"
    PASS = "Pass"
    FAIL = "Fail"


class OsUpdateType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the OS update type to test against."""

    SECURITY_UPDATE = "SecurityUpdate"
    FEATURE_UPDATE = "FeatureUpdate"


class PackageStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the package."""

    UNKNOWN = "Unknown"
    REGISTERED = "Registered"
    READY = "Ready"
    ERROR = "Error"
    VALIDATING_PACKAGE = "ValidatingPackage"
    PRE_VALIDATION_CHECK_PASS = "PreValidationCheckPass"
    DELETED = "Deleted"
    VALIDATION_LONGER_THAN_USUAL = "ValidationLongerThanUsual"
    VERIFYING_PACKAGE = "VerifyingPackage"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ARM provisioning state, see
    https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/Addendum.md#provisioningstate-property.
    """

    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELLED = "Cancelled"
    CREATING = "Creating"
    DELETING = "Deleting"
    UPDATING = "Updating"


class Reason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reason for unavailability of a name. Required if nameAvailable == false."""

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"


class TestAnalysisStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the analysis."""

    NONE = "None"
    ANALYZING = "Analyzing"
    COMPLETED = "Completed"
    FAILED = "Failed"


class TestStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of a test."""

    NONE = "None"
    TEST_EXECUTION_IN_PROGRESS = "TestExecutionInProgress"
    DATA_PROCESSING = "DataProcessing"
    TEST_FAILURE = "TestFailure"
    UPDATE_FAILURE = "UpdateFailure"
    TEST_AND_UPDATE_FAILURE = "TestAndUpdateFailure"
    INFRASTRUCTURE_FAILURE = "InfrastructureFailure"
    COMPLETED = "Completed"


class TestType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The test type."""

    OUT_OF_BOX_TEST = "OutOfBoxTest"
    FUNCTIONAL_TEST = "FunctionalTest"


class Tier(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The tier of this particular SKU."""

    STANDARD = "Standard"


class Type(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of this release (OS update)."""

    SECURITY_UPDATE = "SecurityUpdate"
    FEATURE_UPDATE = "FeatureUpdate"


class ValidationRunStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the validation run of the package."""

    UNKNOWN = "Unknown"
    PENDING = "Pending"
    PASSED = "Passed"
    FAILED = "Failed"
