# coding: utf-8

"""
    CLOUD API

    IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class TargetGroupHealthCheck(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'check_interval': 'int',

        'check_timeout': 'int',

        'retries': 'int',
    }

    attribute_map = {

        'check_interval': 'checkInterval',

        'check_timeout': 'checkTimeout',

        'retries': 'retries',
    }

    def __init__(self, check_interval=None, check_timeout=None, retries=None, local_vars_configuration=None):  # noqa: E501
        """TargetGroupHealthCheck - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._check_interval = None
        self._check_timeout = None
        self._retries = None
        self.discriminator = None

        if check_interval is not None:
            self.check_interval = check_interval
        if check_timeout is not None:
            self.check_timeout = check_timeout
        if retries is not None:
            self.retries = retries


    @property
    def check_interval(self):
        """Gets the check_interval of this TargetGroupHealthCheck.  # noqa: E501

        The interval in milliseconds between consecutive health checks; the default value is '2000'.  # noqa: E501

        :return: The check_interval of this TargetGroupHealthCheck.  # noqa: E501
        :rtype: int
        """
        return self._check_interval

    @check_interval.setter
    def check_interval(self, check_interval):
        """Sets the check_interval of this TargetGroupHealthCheck.

        The interval in milliseconds between consecutive health checks; the default value is '2000'.  # noqa: E501

        :param check_interval: The check_interval of this TargetGroupHealthCheck.  # noqa: E501
        :type check_interval: int
        """

        self._check_interval = check_interval

    @property
    def check_timeout(self):
        """Gets the check_timeout of this TargetGroupHealthCheck.  # noqa: E501

        The maximum time in milliseconds is to wait for a target to respond to a check. For target VMs with a 'Check Interval' set, the smaller of the two values is used once the TCP connection is established.  # noqa: E501

        :return: The check_timeout of this TargetGroupHealthCheck.  # noqa: E501
        :rtype: int
        """
        return self._check_timeout

    @check_timeout.setter
    def check_timeout(self, check_timeout):
        """Sets the check_timeout of this TargetGroupHealthCheck.

        The maximum time in milliseconds is to wait for a target to respond to a check. For target VMs with a 'Check Interval' set, the smaller of the two values is used once the TCP connection is established.  # noqa: E501

        :param check_timeout: The check_timeout of this TargetGroupHealthCheck.  # noqa: E501
        :type check_timeout: int
        """

        self._check_timeout = check_timeout

    @property
    def retries(self):
        """Gets the retries of this TargetGroupHealthCheck.  # noqa: E501

        The maximum number of attempts to reconnect to a target after a connection failure. The valid range is '0 to 65535'; the default value is '3'.  # noqa: E501

        :return: The retries of this TargetGroupHealthCheck.  # noqa: E501
        :rtype: int
        """
        return self._retries

    @retries.setter
    def retries(self, retries):
        """Sets the retries of this TargetGroupHealthCheck.

        The maximum number of attempts to reconnect to a target after a connection failure. The valid range is '0 to 65535'; the default value is '3'.  # noqa: E501

        :param retries: The retries of this TargetGroupHealthCheck.  # noqa: E501
        :type retries: int
        """

        self._retries = retries
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TargetGroupHealthCheck):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TargetGroupHealthCheck):
            return True

        return self.to_dict() != other.to_dict()
