% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{makeExampleDESeqDataSet}
\alias{makeExampleDESeqDataSet}
\title{Make a simulated DESeqDataSet}
\usage{
makeExampleDESeqDataSet(
  n = 1000,
  m = 12,
  betaSD = 0,
  interceptMean = 4,
  interceptSD = 2,
  dispMeanRel = function(x) 4/x + 0.1,
  sizeFactors = rep(1, m)
)
}
\arguments{
\item{n}{number of rows}

\item{m}{number of columns}

\item{betaSD}{the standard deviation for non-intercept betas, i.e. beta ~ N(0,betaSD)}

\item{interceptMean}{the mean of the intercept betas (log2 scale)}

\item{interceptSD}{the standard deviation of the intercept betas (log2 scale)}

\item{dispMeanRel}{a function specifying the relationship of the dispersions on
\code{2^trueIntercept}}

\item{sizeFactors}{multiplicative factors for each sample}
}
\value{
a \code{\link{DESeqDataSet}} with true dispersion,
intercept and beta values in the metadata columns.  Note that the true
betas are provided on the log2 scale.
}
\description{
Constructs a simulated dataset of Negative Binomial data from
two conditions. By default, there are no fold changes between
the two conditions, but this can be adjusted with the \code{betaSD} argument.
}
\examples{

dds <- makeExampleDESeqDataSet()
dds

}
