% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchDataset.R
\name{fetchDataset}
\alias{fetchDataset}
\alias{fetchMetadata}
\title{Fetch a dataset from the gypsum backend}
\usage{
fetchDataset(
  name,
  version,
  path = NA,
  package = "scRNAseq",
  cache = cacheDirectory(),
  overwrite = FALSE,
  realize.assays = FALSE,
  realize.reduced.dims = TRUE,
  ...
)

fetchMetadata(
  name,
  version,
  path = NA,
  package = "scRNAseq",
  cache = cacheDirectory(),
  overwrite = FALSE
)
}
\arguments{
\item{name}{String containing the name of the dataset.}

\item{version}{String containing the version of the dataset.}

\item{path}{String containing the path to a subdataset, if \code{name} contains multiple datasets.
Defaults to \code{NA} if no subdatasets are present.}

\item{package}{String containing the name of the package.}

\item{cache, overwrite}{Arguments to pass to \code{\link[gypsum]{saveVersion}} or \code{\link[gypsum]{saveFile}}.}

\item{realize.assays, realize.reduced.dims}{Logical scalars indicating whether to realize assays and reduced dimensions into memory.
Dense and sparse \linkS4class{ReloadedArray} objects are converted into ordinary arrays and \linkS4class{dgCMatrix} objects, respectively.}

\item{...}{Further arguments to pass to \code{\link{readObject}}.}
}
\value{
\code{fetchDataset} returns the dataset as a \linkS4class{SummarizedExperiment} or one of its subclasses.

\code{fetchMetadata} returns a named list of metadata for the specified dataset.
}
\description{
Fetch a dataset (or its metadata) from the gypsum backend.
}
\examples{
fetchDataset("zeisel-brain-2015", "2023-12-14")
fetchMetadata("zeisel-brain-2015", "2023-12-14")

}
\seealso{
\url{https://github.com/ArtifactDB/bioconductor-metadata-index}, on the expected schema for the metadata.

\code{\link{saveDataset}} and \code{\link{uploadDirectory}}, to save and upload a dataset.

\code{\link{surveyDatasets}} and \code{\link{listVersions}}, to get possible values for \code{name} and \code{version}.
}
\author{
Aaron Lun
}
