% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-number.R
\name{chk_number}
\alias{chk_number}
\alias{vld_number}
\title{Check Number}
\usage{
chk_number(x, x_name = NULL)

vld_number(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if non-missing numeric scalar using

\code{is.numeric(x) && length(x) == 1L && !anyNA(x)}

\strong{Pass}: \code{1}, \code{2L}, \code{log(10)}, \code{-Inf}

\strong{Fail}: \code{"a"}, \code{1:3}, \code{NA_real_}
}
\section{Functions}{
\itemize{
\item \code{vld_number()}: Validate Number

}}
\examples{
# chk_number
chk_number(1.1)
try(chk_number(TRUE))
# vld_number
vld_number(1.1)
}
\seealso{
\code{\link[=is.numeric]{is.numeric()}}

\code{\link[=length]{length()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.
}
\concept{data_type_checkers scalar_checkers}
