% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich.lm.R
\name{get_enrichment_options.lm}
\alias{get_enrichment_options.lm}
\title{Available options for the enrichment objects of class
\code{\link{lm}}}
\usage{
\method{get_enrichment_options}{lm}(object, option,
  all_options = missing(option))
}
\arguments{
\item{object}{the object to be enriched}

\item{option}{a character vector listing the options for enriching
the object}

\item{all_options}{if \code{TRUE} then output a data frame with the
available enrichment options, their descriptions, the names of
the components that each option results in, and the names of
the corresponding \code{compute_*} functions.}
}
\value{
an object of class \code{enrichment_options}
}
\description{
Available options for the enrichment objects of class
\code{\link{lm}}
}
\details{
A check is being made whether the requested option is
    available. No check is being made on whether the functions that
    produce the components exist.
}
\examples{
\dontrun{
get_enrichment_options.lm(option = "all")
get_enrichment_options.lm(all_options = TRUE)
}
}
