% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_stress.R, R/layouts.R
\name{layout_fixed_coords}
\alias{layout_fixed_coords}
\alias{layout_with_fixed_coords}
\alias{layout_igraph_fixed_coords}
\title{Layout with fixed coordinates}
\usage{
layout_with_fixed_coords(
  g,
  coords,
  weights = NA,
  iter = 500,
  tol = 1e-04,
  mds = TRUE,
  bbox = 30
)

layout_igraph_fixed_coords(
  g,
  coords,
  weights = NA,
  iter = 500,
  tol = 1e-04,
  mds = TRUE,
  bbox = 30,
  circular
)
}
\arguments{
\item{g}{igraph object}

\item{coords}{numeric n x 2 matrix, where n is the number of nodes. values
are either NA or fixed coordinates. coordinates are only calculated for the
NA values.}

\item{weights}{possibly a numeric vector with edge weights. If this is NULL and the graph has a weight edge attribute, then the attribute is used. If this is NA then no weights are used (even if the graph has a weight attribute). By default, weights are ignored. See details for more.}

\item{iter}{number of iterations during stress optimization}

\item{tol}{stopping criterion for stress optimization}

\item{mds}{should an MDS layout be used as initial layout (default: TRUE)}

\item{bbox}{constrain dimension of output. Only relevant to determine the placement of disconnected graphs}

\item{circular}{not used}
}
\value{
matrix of xy coordinates
}
\description{
force-directed graph layout based on stress majorization with
fixed coordinates for some nodes
}
\details{
Be careful when using weights. In most cases, the inverse of the edge weights should be used to ensure that the endpoints of an edges with higher weights are closer together (weights=1/E(g)$weight).

The layout_igraph_* function should not be used directly. It is only used as an argument for plotting with 'igraph'.
'ggraph' natively supports the layout.
}
\examples{
library(igraph)
set.seed(12)
g <- sample_bipartite(10, 5, "gnp", 0.5)
fxy <- cbind(c(rep(0, 10), rep(1, 5)), NA)
xy <- layout_with_fixed_coords(g, fxy)
}
\seealso{
\link{layout_constrained_stress}
}
