% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/images.R
\name{plotTag}
\alias{plotTag}
\title{Capture a plot as a self-contained \verb{<img>} tag}
\usage{
plotTag(
  expr,
  alt,
  device = defaultPngDevice(),
  width = 400,
  height = 400,
  pixelratio = 2,
  mimeType = "image/png",
  deviceArgs = list(),
  attribs = list(),
  suppressSize = c("none", "x", "y", "xy")
)
}
\arguments{
\item{expr}{A plotting expression that generates a plot (or yields an object
that generates a plot when printed, like a ggplot2).}

\item{alt}{A single-element character vector that contains a text description
of the image. This is used by accessibility tools, such as screen readers
for vision impaired users.}

\item{device}{A graphics device function; by default, this will be either
\code{\link[grDevices:png]{grDevices::png()}}, \code{\link[ragg:agg_png]{ragg::agg_png()}}, or \code{\link[Cairo:Cairo]{Cairo::CairoPNG()}}, depending on
your system and configuration. See \code{\link[=defaultPngDevice]{defaultPngDevice()}}.}

\item{width, height}{The width/height that the generated tag should be
displayed at, in logical (browser) pixels.}

\item{pixelratio}{Indicates the ratio between physical and logical units of
length. For PNGs that may be displayed on high-DPI screens, use \code{2};
for graphics devices that express width/height in inches (like
\code{\link[grDevices:cairo]{grDevices::svg()}}, try \code{1/72} or \code{1/96}.}

\item{mimeType}{The MIME type associated with the \code{device}. Examples are
\code{image/png}, \code{image/tiff}, \code{image/svg+xml}.}

\item{deviceArgs}{A list of additional arguments that should be included when
the \code{device} function is invoked.}

\item{attribs}{A list of additional attributes that should be included on the
generated \verb{<img>} (e.g. \code{id}, \code{class}).}

\item{suppressSize}{By default, \code{plotTag} will include a \code{style}
attribute with \code{width} and \code{height} properties specified in
pixels. If you'd rather specify the image size using other methods (like
responsive CSS rules) you can use this argument to suppress width
(\code{"x"}), height (\code{"y"}), or both (\code{"xy"}) properties.}
}
\value{
A \code{\link[=browsable]{browsable()}} HTML \verb{<img>} tag object. Print it at
the console to preview, or call \code{\link[=as.character]{as.character()}} on it to view the HTML
source.
}
\description{
Capture a plot as a self-contained \verb{<img>} tag
}
\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
img <- plotTag({
  plot(cars)
}, "A plot of the 'cars' dataset", width = 375, height = 275)

img

if (capabilities("cairo")) {
  plotTag(
    plot(pressure), "A plot of the 'pressure' dataset",
    device = grDevices::svg, width = 375, height = 275, pixelratio = 1/72,
    mimeType = "image/svg+xml"
  )
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=capturePlot]{capturePlot()}} saves plots as an image file.
}
