% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eqSS.R
\name{eqSS}
\alias{eqSS}
\title{Equivalized household size}
\usage{
eqSS(hid, age, year = NULL, data = NULL)
}
\arguments{
\item{hid}{if \code{data=NULL}, a vector containing the household ID.
Otherwise a character string specifying the column of \code{data} that
contains the household ID.}

\item{age}{if \code{data=NULL}, a vector containing the age of the
individuals.  Otherwise a character string specifying the column of
\code{data} that contains the age.}

\item{year}{if \code{data=NULL}, a vector containing the year of the survey.
Otherwise a character string specifying the column of \code{data} that
contains the year.}

\item{data}{a \code{data.frame} containing EU-SILC survey data, or
\code{NULL}.}
}
\value{
A numeric vector containing the equivalized household size for every
observation in \code{data}.
}
\description{
Compute the equivalized household size according to the modified OECD scale
adopted in 1994.
}
\examples{
data(eusilc)

# calculate equivalized household size
eqSS <- eqSS("db030", "age", data=eusilc)

# combine with household ID and household size
tmp <- cbind(eusilc[, c("db030", "hsize")], eqSS)

# show the first 8 rows
head(tmp, 8)

}
\references{
Working group on Statistics on Income and Living Conditions
(2004) Common cross-sectional EU indicators based on EU-SILC; the gender pay
gap.  \emph{EU-SILC 131-rev/04}, Eurostat.
}
\seealso{
\code{\link{eqInc}}
}
\author{
Andreas Alfons
}
\keyword{survey}
