% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access.R
\name{network.indicators}
\alias{network.indicators}
\alias{has.loops}
\alias{is.bipartite}
\alias{is.bipartite.network}
\alias{is.directed}
\alias{is.directed.network}
\alias{is.hyper}
\alias{is.multiplex}
\title{Indicator Functions for Network Properties}
\usage{
has.loops(x)

is.bipartite(x, ...)

\method{is.bipartite}{network}(x, ...)

is.directed(x, ...)

\method{is.directed}{network}(x, ...)

is.hyper(x)

is.multiplex(x)
}
\arguments{
\item{x}{an object of class \code{network}}

\item{...}{other arguments passed to/from other methods}
}
\value{
\code{TRUE} or \code{FALSE}
}
\description{
Various indicators for properties of \code{network} class objects.
}
\details{
These methods are the standard means of assessing the state of a
\code{network} object; other methods can (and should) use these routines in
governing their own behavior.  As such, improper setting of the associated
attributes may result in unpleasantly creative results.  (See the
\code{edge.check} argument to \code{\link{add.edges}} for an example of code
which makes use of these network properties.)

The functions themselves behave has follows:

\code{has.loops} returns \code{TRUE} iff \code{x} is allowed to contain
loops (or loop-like edges, in the hypergraphic case).

\code{is.bipartite} returns \code{TRUE} iff the \code{x} has been explicitly
bipartite-coded. Values of \code{bipartite=NULL}, and \code{bipartite=FALSE}
will evaluate to \code{FALSE}, numeric values of \code{bipartite>=0} will
evaluate to \code{TRUE}. (The value \code{bipartite==0} indicates that it is
a bipartite network with a zero-sized first partition.) Note that
\code{is.bipartite} refers only to the storage properties of \code{x} and
how it should be treated by some algorithms; \code{is.bipartite(x)==FALSE}
it does \emph{not} mean that \code{x} cannot admit a bipartition!

\code{is.directed} returns \code{TRUE} iff the edges of \code{x} are to be
interpreted as directed.

\code{is.hyper} returns \code{TRUE} iff \code{x} is allowed to contain
hypergraphic edges.

\code{is.multiplex} returns \code{TRUE} iff \code{x} is allowed to contain
multiplex edges.
}
\examples{

g<-network.initialize(5)    #Initialize the network
is.bipartite(g)
is.directed(g)
is.hyper(g)
is.multiplex(g)
has.loops(g)

}
\references{
Butts, C. T.  (2008).  \dQuote{network: a Package for Managing
Relational Data in R.} \emph{Journal of Statistical Software}, 24(2).
\doi{10.18637/jss.v024.i02}
}
\seealso{
\code{\link{network}}, \code{\link{get.network.attribute}},
\code{set.network.attribute}, \code{\link{add.edges}}
}
\author{
Carter T. Butts \email{buttsc@uci.edu}
}
\keyword{classes}
\keyword{graphs}
