% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{insertImage}
\alias{insertImage}
\title{Insert an image into a worksheet}
\usage{
insertImage(
  wb,
  sheet,
  file,
  width = 6,
  height = 3,
  startRow = 1,
  startCol = 1,
  units = "in",
  dpi = 300,
  address
)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{file}{An image file. Valid file types are: jpeg, png, bmp}

\item{width}{Width of figure.}

\item{height}{Height of figure.}

\item{startRow}{Row coordinate of upper left corner of the image}

\item{startCol}{Column coordinate of upper left corner of the image}

\item{units}{Units of width and height. Can be "in", "cm" or "px"}

\item{dpi}{Image resolution used for conversion between units.}

\item{address}{An optional character string specifying an external URL, relative or absolute path to a file, or mailto string (e.g. "mailto:example@example.com") that will be opened when the image is clicked.}
}
\description{
Insert an image into a worksheet
}
\examples{
## Create a new workbook
wb <- createWorkbook("Ayanami")

## Add some worksheets
addWorksheet(wb, "Sheet 1")
addWorksheet(wb, "Sheet 2")
addWorksheet(wb, "Sheet 3")
addWorksheet(wb, "Sheet 4")

## Insert images
img <- system.file("extdata", "einstein.jpg", package = "openxlsx")
insertImage(wb, "Sheet 1", img, startRow = 5, startCol = 3, width = 6, height = 5)
insertImage(wb, 2, img, startRow = 2, startCol = 2)
insertImage(wb, 3, img, width = 15, height = 12, startRow = 3, startCol = "G", units = "cm")
insertImage(wb, 4, img, address = "https://github.com/ycphs/openxlsx")

## Save workbook
\dontrun{
saveWorkbook(wb, "insertImageExample.xlsx", overwrite = TRUE)
}
}
\seealso{
\code{\link[=insertPlot]{insertPlot()}}
}
\author{
Alexander Walker
}
