% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infix.R
\name{infix-concatenation}
\alias{infix-concatenation}
\alias{\%<<\%}
\alias{\%\\\%}
\alias{\%<<<\%}
\title{Infix string concatenation.}
\usage{
lhs \%<<\% rhs

lhs \%<<<\% rhs
}
\arguments{
\item{lhs}{left string}

\item{rhs}{right string}
}
\description{
The infix operators listed here are three versions of paste.
\itemize{
\item \code{\%\\\%} is for preserving line breaks
\item \code{\%<<\%} is an infix replacement for \code{\link{paste}}
\item \code{\%<<<\%} is paste with no space and no break."
}
}
\examples{

who <- "world"
'hello_' \%<<<\% who

'Sing with me' \%<<\% head(letters) \%<<\% '...'
}
