% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R
\name{parameters}
\alias{parameters}
\alias{parameters<-}
\title{Get or set a URL's parameters}
\usage{
parameters(x)

parameters(x) <- value
}
\arguments{
\item{x}{a URL, or vector of URLs}

\item{value}{a replacement value (or vector of replacement values)
for x's parameters. If NULL, the parameters will be removed entirely.}
}
\description{
as in the lubridate package, individual components of a URL
can be both extracted or set using the relevant function call - see the
examples.
}
\examples{
# Get the parameters
example_url <- "http://en.wikipedia.org/wiki/Aaron_Halfaker?debug=true"
parameters(example_url)

# Set the parameters
parameters(example_url) <- "debug=false"

# Remove the parameters
parameters(example_url) <- NULL
}
\seealso{
\code{\link{scheme}}, \code{\link{domain}}, \code{\link{port}},
\code{\link{path}} and \code{\link{fragment}} for other accessors.
}
