module MathML
  module Symbol
    MAP = {} unless const_defined?(:MAP)

    module CharacterReference
      Symbol::Default = self unless Symbol.const_defined?(:Default)
      Symbol::MAP[:character] = self

      def self.convert(name)
        MathML.pcstring(MAP[name.to_s.to_sym], true)
      end

      MAP =
        {
          AElig: '&#xc6;',
          Aacute: '&#xc1;',
          Abreve: '&#x102;',
          Acirc: '&#xc2;',
          Acy: '&#x410;',
          Afr: '&#x1d504;',
          Agrave: '&#xc0;',
          Amacr: '&#x100;',
          And: '&#x2a53;',
          Aogon: '&#x104;',
          Aopf: '&#x1d538;',
          ApplyFunction: '&#x2061;',
          Aring: '&#xc5;',
          Ascr: '&#x1d49c;',
          Assign: '&#x2254;',
          Atilde: '&#xc3;',
          Auml: '&#xc4;',
          Backslash: '&#x2216;',
          Barv: '&#x2ae7;',
          Barwed: '&#x2306;',
          Bcy: '&#x411;',
          Because: '&#x2235;',
          Bernoullis: '&#x212c;',
          Bfr: '&#x1d505;',
          Bopf: '&#x1d539;',
          Breve: '&#x2d8;',
          Bscr: '&#x212c;',
          Bumpeq: '&#x224e;',
          CHcy: '&#x427;',
          Cacute: '&#x106;',
          Cap: '&#x22d2;',
          CapitalDifferentialD: '&#x2145;',
          Cayleys: '&#x212d;',
          Ccaron: '&#x10c;',
          Ccedil: '&#xc7;',
          Ccirc: '&#x108;',
          Cconint: '&#x2230;',
          Cdot: '&#x10a;',
          Cedilla: '&#xb8;',
          CenterDot: '&#xb7;',
          Cfr: '&#x212d;',
          CircleDot: '&#x2299;',
          CircleMinus: '&#x2296;',
          CirclePlus: '&#x2295;',
          CircleTimes: '&#x2297;',
          ClockwiseContourIntegral: '&#x2232;',
          CloseCurlyDoubleQuote: '&#x201d;',
          CloseCurlyQuote: '&#x2019;',
          Colon: '&#x2237;',
          Colone: '&#x2a74;',
          Congruent: '&#x2261;',
          Conint: '&#x222f;',
          ContourIntegral: '&#x222e;',
          Copf: '&#x2102;',
          Coproduct: '&#x2210;',
          CounterClockwiseContourIntegral: '&#x2233;',
          Cross: '&#x2a2f;',
          Cscr: '&#x1d49e;',
          Cup: '&#x22d3;',
          CupCap: '&#x224d;',
          DD: '&#x2145;',
          DDotrahd: '&#x2911;',
          DJcy: '&#x402;',
          DScy: '&#x405;',
          DZcy: '&#x40f;',
          Dagger: '&#x2021;',
          Darr: '&#x21a1;',
          Dashv: '&#x2ae4;',
          Dcaron: '&#x10e;',
          Dcy: '&#x414;',
          Del: '&#x2207;',
          Delta: '&#x394;',
          Dfr: '&#x1d507;',
          DiacriticalAcute: '&#xb4;',
          DiacriticalDot: '&#x2d9;',
          DiacriticalDoubleAcute: '&#x2dd;',
          DiacriticalGrave: '&#x60;',
          DiacriticalTilde: '&#x2dc;',
          Diamond: '&#x22c4;',
          DifferentialD: '&#x2146;',
          Dopf: '&#x1d53b;',
          Dot: '&#xa8;',
          DotDot: '&#x20dc;',
          DotEqual: '&#x2250;',
          DoubleContourIntegral: '&#x222f;',
          DoubleDot: '&#xa8;',
          DoubleDownArrow: '&#x21d3;',
          DoubleLeftArrow: '&#x21d0;',
          DoubleLeftRightArrow: '&#x21d4;',
          DoubleLeftTee: '&#x2ae4;',
          DoubleLongLeftArrow: '&#x27f8;',
          DoubleLongLeftRightArrow: '&#x27fa;',
          DoubleLongRightArrow: '&#x27f9;',
          DoubleRightArrow: '&#x21d2;',
          DoubleRightTee: '&#x22a8;',
          DoubleUpArrow: '&#x21d1;',
          DoubleUpDownArrow: '&#x21d5;',
          DoubleVerticalBar: '&#x2225;',
          DownArrow: '&#x2193;',
          DownArrowBar: '&#x2913;',
          DownArrowUpArrow: '&#x21f5;',
          DownBreve: '&#x311;',
          DownLeftRightVector: '&#x2950;',
          DownLeftTeeVector: '&#x295e;',
          DownLeftVector: '&#x21bd;',
          DownLeftVectorBar: '&#x2956;',
          DownRightTeeVector: '&#x295f;',
          DownRightVector: '&#x21c1;',
          DownRightVectorBar: '&#x2957;',
          DownTee: '&#x22a4;',
          DownTeeArrow: '&#x21a7;',
          Downarrow: '&#x21d3;',
          Dscr: '&#x1d49f;',
          Dstrok: '&#x110;',
          ENG: '&#x14a;',
          ETH: '&#xd0;',
          Eacute: '&#xc9;',
          Ecaron: '&#x11a;',
          Ecirc: '&#xca;',
          Ecy: '&#x42d;',
          Edot: '&#x116;',
          Efr: '&#x1d508;',
          Egrave: '&#xc8;',
          Element: '&#x2208;',
          Emacr: '&#x112;',
          EmptySmallSquare: '&#x25fb;',
          EmptyVerySmallSquare: '&#x25ab;',
          Eogon: '&#x118;',
          Eopf: '&#x1d53c;',
          Equal: '&#x2a75;',
          EqualTilde: '&#x2242;',
          Equilibrium: '&#x21cc;',
          Escr: '&#x2130;',
          Esim: '&#x2a73;',
          Euml: '&#xcb;',
          Exists: '&#x2203;',
          ExponentialE: '&#x2147;',
          Fcy: '&#x424;',
          Ffr: '&#x1d509;',
          FilledSmallSquare: '&#x25fc;',
          FilledVerySmallSquare: '&#x25aa;',
          Fopf: '&#x1d53d;',
          ForAll: '&#x2200;',
          Fouriertrf: '&#x2131;',
          Fscr: '&#x2131;',
          GJcy: '&#x403;',
          Gamma: '&#x393;',
          Gammad: '&#x3dc;',
          Gbreve: '&#x11e;',
          Gcedil: '&#x122;',
          Gcirc: '&#x11c;',
          Gcy: '&#x413;',
          Gdot: '&#x120;',
          Gfr: '&#x1d50a;',
          Gg: '&#x22d9;',
          Gopf: '&#x1d53e;',
          GreaterEqual: '&#x2265;',
          GreaterEqualLess: '&#x22db;',
          GreaterFullEqual: '&#x2267;',
          GreaterGreater: '&#x2aa2;',
          GreaterLess: '&#x2277;',
          GreaterSlantEqual: '&#x2a7e;',
          GreaterTilde: '&#x2273;',
          Gscr: '&#x1d4a2;',
          Gt: '&#x226b;',
          HARDcy: '&#x42a;',
          Hacek: '&#x2c7;',
          Hat: '&#x5e;',
          Hcirc: '&#x124;',
          Hfr: '&#x210c;',
          HilbertSpace: '&#x210b;',
          Hopf: '&#x210d;',
          HorizontalLine: '&#x2500;',
          Hscr: '&#x210b;',
          Hstrok: '&#x126;',
          HumpDownHump: '&#x224e;',
          HumpEqual: '&#x224f;',
          IEcy: '&#x415;',
          IJlig: '&#x132;',
          IOcy: '&#x401;',
          Iacute: '&#xcd;',
          Icirc: '&#xce;',
          Icy: '&#x418;',
          Idot: '&#x130;',
          Ifr: '&#x2111;',
          Igrave: '&#xcc;',
          Im: '&#x2111;',
          Imacr: '&#x12a;',
          ImaginaryI: '&#x2148;',
          Implies: '&#x21d2;',
          Int: '&#x222c;',
          Integral: '&#x222b;',
          Intersection: '&#x22c2;',
          InvisibleComma: '&#x2063;',
          InvisibleTimes: '&#x2062;',
          Iogon: '&#x12e;',
          Iopf: '&#x1d540;',
          Iscr: '&#x2110;',
          Itilde: '&#x128;',
          Iukcy: '&#x406;',
          Iuml: '&#xcf;',
          Jcirc: '&#x134;',
          Jcy: '&#x419;',
          Jfr: '&#x1d50d;',
          Jopf: '&#x1d541;',
          Jscr: '&#x1d4a5;',
          Jsercy: '&#x408;',
          Jukcy: '&#x404;',
          KHcy: '&#x425;',
          KJcy: '&#x40c;',
          Kcedil: '&#x136;',
          Kcy: '&#x41a;',
          Kfr: '&#x1d50e;',
          Kopf: '&#x1d542;',
          Kscr: '&#x1d4a6;',
          LJcy: '&#x409;',
          Lacute: '&#x139;',
          Lambda: '&#x39b;',
          Lang: '&#x300a;',
          Laplacetrf: '&#x2112;',
          Larr: '&#x219e;',
          Lcaron: '&#x13d;',
          Lcedil: '&#x13b;',
          Lcy: '&#x41b;',
          LeftAngleBracket: '&#x2329;',
          LeftArrow: '&#x2190;',
          LeftArrowBar: '&#x21e4;',
          LeftArrowRightArrow: '&#x21c6;',
          LeftCeiling: '&#x2308;',
          LeftDoubleBracket: '&#x301a;',
          LeftDownTeeVector: '&#x2961;',
          LeftDownVector: '&#x21c3;',
          LeftDownVectorBar: '&#x2959;',
          LeftFloor: '&#x230a;',
          LeftRightArrow: '&#x2194;',
          LeftRightVector: '&#x294e;',
          LeftTee: '&#x22a3;',
          LeftTeeArrow: '&#x21a4;',
          LeftTeeVector: '&#x295a;',
          LeftTriangle: '&#x22b2;',
          LeftTriangleBar: '&#x29cf;',
          LeftTriangleEqual: '&#x22b4;',
          LeftUpDownVector: '&#x2951;',
          LeftUpTeeVector: '&#x2960;',
          LeftUpVector: '&#x21bf;',
          LeftUpVectorBar: '&#x2958;',
          LeftVector: '&#x21bc;',
          LeftVectorBar: '&#x2952;',
          Leftarrow: '&#x21d0;',
          Leftrightarrow: '&#x21d4;',
          LessEqualGreater: '&#x22da;',
          LessFullEqual: '&#x2266;',
          LessGreater: '&#x2276;',
          LessLess: '&#x2aa1;',
          LessSlantEqual: '&#x2a7d;',
          LessTilde: '&#x2272;',
          Lfr: '&#x1d50f;',
          Ll: '&#x22d8;',
          Lleftarrow: '&#x21da;',
          Lmidot: '&#x13f;',
          LongLeftArrow: '&#x27f5;',
          LongLeftRightArrow: '&#x27f7;',
          LongRightArrow: '&#x27f6;',
          Longleftarrow: '&#x27f8;',
          Longleftrightarrow: '&#x27fa;',
          Longrightarrow: '&#x27f9;',
          Lopf: '&#x1d543;',
          LowerLeftArrow: '&#x2199;',
          LowerRightArrow: '&#x2198;',
          Lscr: '&#x2112;',
          Lsh: '&#x21b0;',
          Lstrok: '&#x141;',
          Lt: '&#x226a;',
          Map: '&#x2905;',
          Mcy: '&#x41c;',
          MediumSpace: '&#x205f;',
          Mellintrf: '&#x2133;',
          Mfr: '&#x1d510;',
          MinusPlus: '&#x2213;',
          Mopf: '&#x1d544;',
          Mscr: '&#x2133;',
          NJcy: '&#x40a;',
          Nacute: '&#x143;',
          Ncaron: '&#x147;',
          Ncedil: '&#x145;',
          Ncy: '&#x41d;',
          NegativeMediumSpace: '&#x200b;',
          NegativeThickSpace: '&#x200b;',
          NegativeThinSpace: '&#x200b;',
          NegativeVeryThinSpace: '&#x200b;',
          NestedGreaterGreater: '&#x226b;',
          NestedLessLess: '&#x226a;',
          NewLine: '&#xa;',
          Nfr: '&#x1d511;',
          NoBreak: '&#x2060;',
          NonBreakingSpace: '&#xa0;',
          Nopf: '&#x2115;',
          Not: '&#x2aec;',
          NotCongruent: '&#x2262;',
          NotCupCap: '&#x226d;',
          NotDoubleVerticalBar: '&#x2226;',
          NotElement: '&#x2209;',
          NotEqual: '&#x2260;',
          NotEqualTilde: '&#x2242;&#x338;',
          NotExists: '&#x2204;',
          NotGreater: '&#x226f;',
          NotGreaterEqual: '&#x2271;',
          NotGreaterFullEqual: '&#x2266;&#x338;',
          NotGreaterGreater: '&#x226b;&#x338;',
          NotGreaterLess: '&#x2279;',
          NotGreaterSlantEqual: '&#x2a7e;&#x338;',
          NotGreaterTilde: '&#x2275;',
          NotHumpDownHump: '&#x224e;&#x338;',
          NotHumpEqual: '&#x224f;&#x338;',
          NotLeftTriangle: '&#x22ea;',
          NotLeftTriangleBar: '&#x29cf;&#x338;',
          NotLeftTriangleEqual: '&#x22ec;',
          NotLess: '&#x226e;',
          NotLessEqual: '&#x2270;',
          NotLessGreater: '&#x2278;',
          NotLessLess: '&#x226a;&#x338;',
          NotLessSlantEqual: '&#x2a7d;&#x338;',
          NotLessTilde: '&#x2274;',
          NotNestedGreaterGreater: '&#x2aa2;&#x338;',
          NotNestedLessLess: '&#x2aa1;&#x338;',
          NotPrecedes: '&#x2280;',
          NotPrecedesEqual: '&#x2aaf;&#x338;',
          NotPrecedesSlantEqual: '&#x22e0;',
          NotReverseElement: '&#x220c;',
          NotRightTriangle: '&#x22eb;',
          NotRightTriangleBar: '&#x29d0;&#x338;',
          NotRightTriangleEqual: '&#x22ed;',
          NotSquareSubset: '&#x228f;&#x338;',
          NotSquareSubsetEqual: '&#x22e2;',
          NotSquareSuperset: '&#x2290;&#x338;',
          NotSquareSupersetEqual: '&#x22e3;',
          NotSubset: '&#x2282;&#x20d2;',
          NotSubsetEqual: '&#x2288;',
          NotSucceeds: '&#x2281;',
          NotSucceedsEqual: '&#x2ab0;&#x338;',
          NotSucceedsSlantEqual: '&#x22e1;',
          NotSucceedsTilde: '&#x227f;&#x338;',
          NotSuperset: '&#x2283;&#x20d2;',
          NotSupersetEqual: '&#x2289;',
          NotTilde: '&#x2241;',
          NotTildeEqual: '&#x2244;',
          NotTildeFullEqual: '&#x2247;',
          NotTildeTilde: '&#x2249;',
          NotVerticalBar: '&#x2224;',
          Nscr: '&#x1d4a9;',
          Ntilde: '&#xd1;',
          OElig: '&#x152;',
          Oacute: '&#xd3;',
          Ocirc: '&#xd4;',
          Ocy: '&#x41e;',
          Odblac: '&#x150;',
          Ofr: '&#x1d512;',
          Ograve: '&#xd2;',
          Omacr: '&#x14c;',
          Omega: '&#x3a9;',
          Oopf: '&#x1d546;',
          OpenCurlyDoubleQuote: '&#x201c;',
          OpenCurlyQuote: '&#x2018;',
          Or: '&#x2a54;',
          Oscr: '&#x1d4aa;',
          Oslash: '&#xd8;',
          Otilde: '&#xd5;',
          Otimes: '&#x2a37;',
          Ouml: '&#xd6;',
          OverBar: '&#xaf;',
          OverBrace: '&#xfe37;',
          OverBracket: '&#x23b4;',
          OverParenthesis: '&#xfe35;',
          PartialD: '&#x2202;',
          Pcy: '&#x41f;',
          Pfr: '&#x1d513;',
          Phi: '&#x3a6;',
          Pi: '&#x3a0;',
          PlusMinus: '&#xb1;',
          Poincareplane: '&#x210c;',
          Popf: '&#x2119;',
          Pr: '&#x2abb;',
          Precedes: '&#x227a;',
          PrecedesEqual: '&#x2aaf;',
          PrecedesSlantEqual: '&#x227c;',
          PrecedesTilde: '&#x227e;',
          Prime: '&#x2033;',
          Product: '&#x220f;',
          Proportion: '&#x2237;',
          Proportional: '&#x221d;',
          Pscr: '&#x1d4ab;',
          Psi: '&#x3a8;',
          Qfr: '&#x1d514;',
          Qopf: '&#x211a;',
          Qscr: '&#x1d4ac;',
          RBarr: '&#x2910;',
          Racute: '&#x154;',
          Rang: '&#x300b;',
          Rarr: '&#x21a0;',
          Rarrtl: '&#x2916;',
          Rcaron: '&#x158;',
          Rcedil: '&#x156;',
          Rcy: '&#x420;',
          Re: '&#x211c;',
          ReverseElement: '&#x220b;',
          ReverseEquilibrium: '&#x21cb;',
          ReverseUpEquilibrium: '&#x296f;',
          Rfr: '&#x211c;',
          RightAngleBracket: '&#x232a;',
          RightArrow: '&#x2192;',
          RightArrowBar: '&#x21e5;',
          RightArrowLeftArrow: '&#x21c4;',
          RightCeiling: '&#x2309;',
          RightDoubleBracket: '&#x301b;',
          RightDownTeeVector: '&#x295d;',
          RightDownVector: '&#x21c2;',
          RightDownVectorBar: '&#x2955;',
          RightFloor: '&#x230b;',
          RightTee: '&#x22a2;',
          RightTeeArrow: '&#x21a6;',
          RightTeeVector: '&#x295b;',
          RightTriangle: '&#x22b3;',
          RightTriangleBar: '&#x29d0;',
          RightTriangleEqual: '&#x22b5;',
          RightUpDownVector: '&#x294f;',
          RightUpTeeVector: '&#x295c;',
          RightUpVector: '&#x21be;',
          RightUpVectorBar: '&#x2954;',
          RightVector: '&#x21c0;',
          RightVectorBar: '&#x2953;',
          Rightarrow: '&#x21d2;',
          Ropf: '&#x211d;',
          RoundImplies: '&#x2970;',
          Rrightarrow: '&#x21db;',
          Rscr: '&#x211b;',
          Rsh: '&#x21b1;',
          RuleDelayed: '&#x29f4;',
          SHCHcy: '&#x429;',
          SHcy: '&#x428;',
          SOFTcy: '&#x42c;',
          Sacute: '&#x15a;',
          Sc: '&#x2abc;',
          Scaron: '&#x160;',
          Scedil: '&#x15e;',
          Scirc: '&#x15c;',
          Scy: '&#x421;',
          Sfr: '&#x1d516;',
          ShortDownArrow: '&#x2193;',
          ShortLeftArrow: '&#x2190;',
          ShortRightArrow: '&#x2192;',
          ShortUpArrow: '&#x2191;',
          Sigma: '&#x3a3;',
          SmallCircle: '&#x2218;',
          Sopf: '&#x1d54a;',
          Sqrt: '&#x221a;',
          Square: '&#x25a1;',
          SquareIntersection: '&#x2293;',
          SquareSubset: '&#x228f;',
          SquareSubsetEqual: '&#x2291;',
          SquareSuperset: '&#x2290;',
          SquareSupersetEqual: '&#x2292;',
          SquareUnion: '&#x2294;',
          Sscr: '&#x1d4ae;',
          Star: '&#x22c6;',
          Sub: '&#x22d0;',
          Subset: '&#x22d0;',
          SubsetEqual: '&#x2286;',
          Succeeds: '&#x227b;',
          SucceedsEqual: '&#x2ab0;',
          SucceedsSlantEqual: '&#x227d;',
          SucceedsTilde: '&#x227f;',
          SuchThat: '&#x220b;',
          Sum: '&#x2211;',
          Sup: '&#x22d1;',
          Superset: '&#x2283;',
          SupersetEqual: '&#x2287;',
          Supset: '&#x22d1;',
          THORN: '&#xde;',
          TSHcy: '&#x40b;',
          TScy: '&#x426;',
          Tab: '&#x9;',
          Tcaron: '&#x164;',
          Tcedil: '&#x162;',
          Tcy: '&#x422;',
          Tfr: '&#x1d517;',
          Therefore: '&#x2234;',
          Theta: '&#x398;',
          ThickSpace: '&#x2009;&#x200a;&#x200a;',
          ThinSpace: '&#x2009;',
          Tilde: '&#x223c;',
          TildeEqual: '&#x2243;',
          TildeFullEqual: '&#x2245;',
          TildeTilde: '&#x2248;',
          Topf: '&#x1d54b;',
          TripleDot: '&#x20db;',
          Tscr: '&#x1d4af;',
          Tstrok: '&#x166;',
          Uacute: '&#xda;',
          Uarr: '&#x219f;',
          Uarrocir: '&#x2949;',
          Ubrcy: '&#x40e;',
          Ubreve: '&#x16c;',
          Ucirc: '&#xdb;',
          Ucy: '&#x423;',
          Udblac: '&#x170;',
          Ufr: '&#x1d518;',
          Ugrave: '&#xd9;',
          Umacr: '&#x16a;',
          UnderBar: '&#x332;',
          UnderBrace: '&#xfe38;',
          UnderBracket: '&#x23b5;',
          UnderParenthesis: '&#xfe36;',
          Union: '&#x22c3;',
          UnionPlus: '&#x228e;',
          Uogon: '&#x172;',
          Uopf: '&#x1d54c;',
          UpArrow: '&#x2191;',
          UpArrowBar: '&#x2912;',
          UpArrowDownArrow: '&#x21c5;',
          UpDownArrow: '&#x2195;',
          UpEquilibrium: '&#x296e;',
          UpTee: '&#x22a5;',
          UpTeeArrow: '&#x21a5;',
          Uparrow: '&#x21d1;',
          Updownarrow: '&#x21d5;',
          UpperLeftArrow: '&#x2196;',
          UpperRightArrow: '&#x2197;',
          Upsi: '&#x3d2;',
          Upsilon: '&#x3a5;',
          Uring: '&#x16e;',
          Uscr: '&#x1d4b0;',
          Utilde: '&#x168;',
          Uuml: '&#xdc;',
          VDash: '&#x22ab;',
          Vbar: '&#x2aeb;',
          Vcy: '&#x412;',
          Vdash: '&#x22a9;',
          Vdashl: '&#x2ae6;',
          Vee: '&#x22c1;',
          Verbar: '&#x2016;',
          Vert: '&#x2016;',
          VerticalBar: '&#x2223;',
          VerticalLine: '&#x7c;',
          VerticalSeparator: '&#x2758;',
          VerticalTilde: '&#x2240;',
          VeryThinSpace: '&#x200a;',
          Vfr: '&#x1d519;',
          Vopf: '&#x1d54d;',
          Vscr: '&#x1d4b1;',
          Vvdash: '&#x22aa;',
          Wcirc: '&#x174;',
          Wedge: '&#x22c0;',
          Wfr: '&#x1d51a;',
          Wopf: '&#x1d54e;',
          Wscr: '&#x1d4b2;',
          Xfr: '&#x1d51b;',
          Xi: '&#x39e;',
          Xopf: '&#x1d54f;',
          Xscr: '&#x1d4b3;',
          YAcy: '&#x42f;',
          YIcy: '&#x407;',
          YUcy: '&#x42e;',
          Yacute: '&#xdd;',
          Ycirc: '&#x176;',
          Ycy: '&#x42b;',
          Yfr: '&#x1d51c;',
          Yopf: '&#x1d550;',
          Yscr: '&#x1d4b4;',
          Yuml: '&#x178;',
          ZHcy: '&#x416;',
          Zacute: '&#x179;',
          Zcaron: '&#x17d;',
          Zcy: '&#x417;',
          Zdot: '&#x17b;',
          ZeroWidthSpace: '&#x200b;',
          Zfr: '&#x2128;',
          Zopf: '&#x2124;',
          Zscr: '&#x1d4b5;',
          aacute: '&#xe1;',
          abreve: '&#x103;',
          ac: '&#x223e;',
          acE: '&#x223e;&#x333;',
          acd: '&#x223f;',
          acirc: '&#xe2;',
          acute: '&#xb4;',
          acy: '&#x430;',
          aelig: '&#xe6;',
          af: '&#x2061;',
          afr: '&#x1d51e;',
          agrave: '&#xe0;',
          aleph: '&#x2135;',
          alpha: '&#x3b1;',
          amacr: '&#x101;',
          amalg: '&#x2a3f;',
          amp: '&#x26;',
          and: '&#x2227;',
          andand: '&#x2a55;',
          andd: '&#x2a5c;',
          andslope: '&#x2a58;',
          andv: '&#x2a5a;',
          ang: '&#x2220;',
          ange: '&#x29a4;',
          angle: '&#x2220;',
          angmsd: '&#x2221;',
          angmsdaa: '&#x29a8;',
          angmsdab: '&#x29a9;',
          angmsdac: '&#x29aa;',
          angmsdad: '&#x29ab;',
          angmsdae: '&#x29ac;',
          angmsdaf: '&#x29ad;',
          angmsdag: '&#x29ae;',
          angmsdah: '&#x29af;',
          angrt: '&#x221f;',
          angrtvb: '&#x22be;',
          angrtvbd: '&#x299d;',
          angsph: '&#x2222;',
          angst: '&#x212b;',
          angzarr: '&#x237c;',
          aogon: '&#x105;',
          aopf: '&#x1d552;',
          ap: '&#x2248;',
          apE: '&#x2a70;',
          apacir: '&#x2a6f;',
          ape: '&#x224a;',
          apid: '&#x224b;',
          apos: '&#x27;',
          approx: '&#x2248;',
          approxeq: '&#x224a;',
          aring: '&#xe5;',
          ascr: '&#x1d4b6;',
          ast: '&#x2a;',
          asymp: '&#x2248;',
          asympeq: '&#x224d;',
          atilde: '&#xe3;',
          auml: '&#xe4;',
          awconint: '&#x2233;',
          awint: '&#x2a11;',
          bNot: '&#x2aed;',
          backcong: '&#x224c;',
          backepsilon: '&#x3f6;',
          backprime: '&#x2035;',
          backsim: '&#x223d;',
          backsimeq: '&#x22cd;',
          barvee: '&#x22bd;',
          barwed: '&#x2305;',
          barwedge: '&#x2305;',
          bbrk: '&#x23b5;',
          bbrktbrk: '&#x23b6;',
          bcong: '&#x224c;',
          bcy: '&#x431;',
          becaus: '&#x2235;',
          because: '&#x2235;',
          bemptyv: '&#x29b0;',
          bepsi: '&#x3f6;',
          bernou: '&#x212c;',
          beta: '&#x3b2;',
          beth: '&#x2136;',
          between: '&#x226c;',
          bfr: '&#x1d51f;',
          bigcap: '&#x22c2;',
          bigcirc: '&#x25ef;',
          bigcup: '&#x22c3;',
          bigodot: '&#x2a00;',
          bigoplus: '&#x2a01;',
          bigotimes: '&#x2a02;',
          bigsqcup: '&#x2a06;',
          bigstar: '&#x2605;',
          bigtriangledown: '&#x25bd;',
          bigtriangleup: '&#x25b3;',
          biguplus: '&#x2a04;',
          bigvee: '&#x22c1;',
          bigwedge: '&#x22c0;',
          bkarow: '&#x290d;',
          blacklozenge: '&#x29eb;',
          blacksquare: '&#x25aa;',
          blacktriangle: '&#x25b4;',
          blacktriangledown: '&#x25be;',
          blacktriangleleft: '&#x25c2;',
          blacktriangleright: '&#x25b8;',
          blank: '&#x2423;',
          blk12: '&#x2592;',
          blk14: '&#x2591;',
          blk34: '&#x2593;',
          block: '&#x2588;',
          bne: '&#x3d;&#x20e5;',
          bnequiv: '&#x2261;&#x20e5;',
          bnot: '&#x2310;',
          bopf: '&#x1d553;',
          bot: '&#x22a5;',
          bottom: '&#x22a5;',
          bowtie: '&#x22c8;',
          boxDL: '&#x2557;',
          boxDR: '&#x2554;',
          boxDl: '&#x2556;',
          boxDr: '&#x2553;',
          boxH: '&#x2550;',
          boxHD: '&#x2566;',
          boxHU: '&#x2569;',
          boxHd: '&#x2564;',
          boxHu: '&#x2567;',
          boxUL: '&#x255d;',
          boxUR: '&#x255a;',
          boxUl: '&#x255c;',
          boxUr: '&#x2559;',
          boxV: '&#x2551;',
          boxVH: '&#x256c;',
          boxVL: '&#x2563;',
          boxVR: '&#x2560;',
          boxVh: '&#x256b;',
          boxVl: '&#x2562;',
          boxVr: '&#x255f;',
          boxbox: '&#x29c9;',
          boxdL: '&#x2555;',
          boxdR: '&#x2552;',
          boxdl: '&#x2510;',
          boxdr: '&#x250c;',
          boxh: '&#x2500;',
          boxhD: '&#x2565;',
          boxhU: '&#x2568;',
          boxhd: '&#x252c;',
          boxhu: '&#x2534;',
          boxminus: '&#x229f;',
          boxplus: '&#x229e;',
          boxtimes: '&#x22a0;',
          boxuL: '&#x255b;',
          boxuR: '&#x2558;',
          boxul: '&#x2518;',
          boxur: '&#x2514;',
          boxv: '&#x2502;',
          boxvH: '&#x256a;',
          boxvL: '&#x2561;',
          boxvR: '&#x255e;',
          boxvh: '&#x253c;',
          boxvl: '&#x2524;',
          boxvr: '&#x251c;',
          bprime: '&#x2035;',
          breve: '&#x2d8;',
          brvbar: '&#xa6;',
          bscr: '&#x1d4b7;',
          bsemi: '&#x204f;',
          bsim: '&#x223d;',
          bsime: '&#x22cd;',
          bsol: '&#x5c;',
          bsolb: '&#x29c5;',
          bsolhsub: '&#x5c;&#x2282;',
          bull: '&#x2022;',
          bullet: '&#x2022;',
          bump: '&#x224e;',
          bumpE: '&#x2aae;',
          bumpe: '&#x224f;',
          bumpeq: '&#x224f;',
          cacute: '&#x107;',
          cap: '&#x2229;',
          capand: '&#x2a44;',
          capbrcup: '&#x2a49;',
          capcap: '&#x2a4b;',
          capcup: '&#x2a47;',
          capdot: '&#x2a40;',
          caps: '&#x2229;&#xfe00;',
          caret: '&#x2041;',
          caron: '&#x2c7;',
          ccaps: '&#x2a4d;',
          ccaron: '&#x10d;',
          ccedil: '&#xe7;',
          ccirc: '&#x109;',
          ccups: '&#x2a4c;',
          ccupssm: '&#x2a50;',
          cdot: '&#x10b;',
          cedil: '&#xb8;',
          cemptyv: '&#x29b2;',
          cent: '&#xa2;',
          centerdot: '&#xb7;',
          cfr: '&#x1d520;',
          chcy: '&#x447;',
          check: '&#x2713;',
          checkmark: '&#x2713;',
          chi: '&#x3c7;',
          cir: '&#x25cb;',
          cirE: '&#x29c3;',
          circ: '&#x2c6;',
          circeq: '&#x2257;',
          circlearrowleft: '&#x21ba;',
          circlearrowright: '&#x21bb;',
          circledR: '&#xae;',
          circledS: '&#x24c8;',
          circledast: '&#x229b;',
          circledcirc: '&#x229a;',
          circleddash: '&#x229d;',
          cire: '&#x2257;',
          cirfnint: '&#x2a10;',
          cirmid: '&#x2aef;',
          cirscir: '&#x29c2;',
          clubs: '&#x2663;',
          clubsuit: '&#x2663;',
          colon: '&#x3a;',
          colone: '&#x2254;',
          coloneq: '&#x2254;',
          comma: '&#x2c;',
          commat: '&#x40;',
          comp: '&#x2201;',
          compfn: '&#x2218;',
          complement: '&#x2201;',
          complexes: '&#x2102;',
          cong: '&#x2245;',
          congdot: '&#x2a6d;',
          conint: '&#x222e;',
          copf: '&#x1d554;',
          coprod: '&#x2210;',
          copy: '&#xa9;',
          copysr: '&#x2117;',
          cross: '&#x2717;',
          cscr: '&#x1d4b8;',
          csub: '&#x2acf;',
          csube: '&#x2ad1;',
          csup: '&#x2ad0;',
          csupe: '&#x2ad2;',
          ctdot: '&#x22ef;',
          cudarrl: '&#x2938;',
          cudarrr: '&#x2935;',
          cuepr: '&#x22de;',
          cuesc: '&#x22df;',
          cularr: '&#x21b6;',
          cularrp: '&#x293d;',
          cup: '&#x222a;',
          cupbrcap: '&#x2a48;',
          cupcap: '&#x2a46;',
          cupcup: '&#x2a4a;',
          cupdot: '&#x228d;',
          cupor: '&#x2a45;',
          cups: '&#x222a;&#xfe00;',
          curarr: '&#x21b7;',
          curarrm: '&#x293c;',
          curlyeqprec: '&#x22de;',
          curlyeqsucc: '&#x22df;',
          curlyvee: '&#x22ce;',
          curlywedge: '&#x22cf;',
          curren: '&#xa4;',
          curvearrowleft: '&#x21b6;',
          curvearrowright: '&#x21b7;',
          cuvee: '&#x22ce;',
          cuwed: '&#x22cf;',
          cwconint: '&#x2232;',
          cwint: '&#x2231;',
          cylcty: '&#x232d;',
          dArr: '&#x21d3;',
          dHar: '&#x2965;',
          dagger: '&#x2020;',
          daleth: '&#x2138;',
          darr: '&#x2193;',
          dash: '&#x2010;',
          dashv: '&#x22a3;',
          dbkarow: '&#x290f;',
          dblac: '&#x2dd;',
          dcaron: '&#x10f;',
          dcy: '&#x434;',
          dd: '&#x2146;',
          ddagger: '&#x2021;',
          ddarr: '&#x21ca;',
          ddotseq: '&#x2a77;',
          deg: '&#xb0;',
          delta: '&#x3b4;',
          demptyv: '&#x29b1;',
          dfisht: '&#x297f;',
          dfr: '&#x1d521;',
          dharl: '&#x21c3;',
          dharr: '&#x21c2;',
          diam: '&#x22c4;',
          diamond: '&#x22c4;',
          diamondsuit: '&#x2666;',
          diams: '&#x2666;',
          die: '&#xa8;',
          digamma: '&#x3dd;',
          disin: '&#x22f2;',
          div: '&#xf7;',
          divide: '&#xf7;',
          divideontimes: '&#x22c7;',
          divonx: '&#x22c7;',
          djcy: '&#x452;',
          dlcorn: '&#x231e;',
          dlcrop: '&#x230d;',
          dollar: '&#x24;',
          dopf: '&#x1d555;',
          dot: '&#x2d9;',
          doteq: '&#x2250;',
          doteqdot: '&#x2251;',
          dotminus: '&#x2238;',
          dotplus: '&#x2214;',
          dotsquare: '&#x22a1;',
          doublebarwedge: '&#x2306;',
          downarrow: '&#x2193;',
          downdownarrows: '&#x21ca;',
          downharpoonleft: '&#x21c3;',
          downharpoonright: '&#x21c2;',
          drbkarow: '&#x2910;',
          drcorn: '&#x231f;',
          drcrop: '&#x230c;',
          dscr: '&#x1d4b9;',
          dscy: '&#x455;',
          dsol: '&#x29f6;',
          dstrok: '&#x111;',
          dtdot: '&#x22f1;',
          dtri: '&#x25bf;',
          dtrif: '&#x25be;',
          duarr: '&#x21f5;',
          duhar: '&#x296f;',
          dwangle: '&#x29a6;',
          dzcy: '&#x45f;',
          dzigrarr: '&#x27ff;',
          eDDot: '&#x2a77;',
          eDot: '&#x2251;',
          eacute: '&#xe9;',
          easter: '&#x2a6e;',
          ecaron: '&#x11b;',
          ecir: '&#x2256;',
          ecirc: '&#xea;',
          ecolon: '&#x2255;',
          ecy: '&#x44d;',
          edot: '&#x117;',
          ee: '&#x2147;',
          efDot: '&#x2252;',
          efr: '&#x1d522;',
          eg: '&#x2a9a;',
          egrave: '&#xe8;',
          egs: '&#x2a96;',
          egsdot: '&#x2a98;',
          el: '&#x2a99;',
          elinters: '&#xfffd;',
          ell: '&#x2113;',
          els: '&#x2a95;',
          elsdot: '&#x2a97;',
          emacr: '&#x113;',
          empty: '&#x2205;',
          emptyset: '&#x2205;',
          emptyv: '&#x2205;',
          emsp: '&#x2003;',
          emsp13: '&#x2004;',
          emsp14: '&#x2005;',
          eng: '&#x14b;',
          ensp: '&#x2002;',
          eogon: '&#x119;',
          eopf: '&#x1d556;',
          epar: '&#x22d5;',
          eparsl: '&#x29e3;',
          eplus: '&#x2a71;',
          epsi: '&#x3f5;',
          epsiv: '&#x3b5;',
          eqcirc: '&#x2256;',
          eqcolon: '&#x2255;',
          eqsim: '&#x2242;',
          eqslantgtr: '&#x2a96;',
          eqslantless: '&#x2a95;',
          equals: '&#x3d;',
          equest: '&#x225f;',
          equiv: '&#x2261;',
          equivDD: '&#x2a78;',
          eqvparsl: '&#x29e5;',
          erDot: '&#x2253;',
          erarr: '&#x2971;',
          escr: '&#x212f;',
          esdot: '&#x2250;',
          esim: '&#x2242;',
          eta: '&#x3b7;',
          eth: '&#xf0;',
          euml: '&#xeb;',
          excl: '&#x21;',
          exist: '&#x2203;',
          expectation: '&#x2130;',
          exponentiale: '&#x2147;',
          fallingdotseq: '&#x2252;',
          fcy: '&#x444;',
          female: '&#x2640;',
          ffilig: '&#xfb03;',
          fflig: '&#xfb00;',
          ffllig: '&#xfb04;',
          ffr: '&#x1d523;',
          filig: '&#xfb01;',
          flat: '&#x266d;',
          fllig: '&#xfb02;',
          fltns: '&#x25b1;',
          fnof: '&#x192;',
          fopf: '&#x1d557;',
          forall: '&#x2200;',
          fork: '&#x22d4;',
          forkv: '&#x2ad9;',
          fpartint: '&#x2a0d;',
          frac12: '&#xbd;',
          frac13: '&#x2153;',
          frac14: '&#xbc;',
          frac15: '&#x2155;',
          frac16: '&#x2159;',
          frac18: '&#x215b;',
          frac23: '&#x2154;',
          frac25: '&#x2156;',
          frac34: '&#xbe;',
          frac35: '&#x2157;',
          frac38: '&#x215c;',
          frac45: '&#x2158;',
          frac56: '&#x215a;',
          frac58: '&#x215d;',
          frac78: '&#x215e;',
          frown: '&#x2322;',
          fscr: '&#x1d4bb;',
          gE: '&#x2267;',
          gEl: '&#x2a8c;',
          gacute: '&#x1f5;',
          gamma: '&#x3b3;',
          gammad: '&#x3dd;',
          gap: '&#x2a86;',
          gbreve: '&#x11f;',
          gcirc: '&#x11d;',
          gcy: '&#x433;',
          gdot: '&#x121;',
          ge: '&#x2265;',
          gel: '&#x22db;',
          geq: '&#x2265;',
          geqq: '&#x2267;',
          geqslant: '&#x2a7e;',
          ges: '&#x2a7e;',
          gescc: '&#x2aa9;',
          gesdot: '&#x2a80;',
          gesdoto: '&#x2a82;',
          gesdotol: '&#x2a84;',
          gesl: '&#x22db;&#xfe00;',
          gesles: '&#x2a94;',
          gfr: '&#x1d524;',
          gg: '&#x226b;',
          ggg: '&#x22d9;',
          gimel: '&#x2137;',
          gjcy: '&#x453;',
          gl: '&#x2277;',
          glE: '&#x2a92;',
          gla: '&#x2aa5;',
          glj: '&#x2aa4;',
          gnE: '&#x2269;',
          gnap: '&#x2a8a;',
          gnapprox: '&#x2a8a;',
          gne: '&#x2a88;',
          gneq: '&#x2a88;',
          gneqq: '&#x2269;',
          gnsim: '&#x22e7;',
          gopf: '&#x1d558;',
          grave: '&#x60;',
          gscr: '&#x210a;',
          gsim: '&#x2273;',
          gsime: '&#x2a8e;',
          gsiml: '&#x2a90;',
          gt: '&#x3e;',
          gtcc: '&#x2aa7;',
          gtcir: '&#x2a7a;',
          gtdot: '&#x22d7;',
          gtlPar: '&#x2995;',
          gtquest: '&#x2a7c;',
          gtrapprox: '&#x2a86;',
          gtrarr: '&#x2978;',
          gtrdot: '&#x22d7;',
          gtreqless: '&#x22db;',
          gtreqqless: '&#x2a8c;',
          gtrless: '&#x2277;',
          gtrsim: '&#x2273;',
          gvertneqq: '&#x2269;&#xfe00;',
          gvnE: '&#x2269;&#xfe00;',
          hArr: '&#x21d4;',
          hairsp: '&#x200a;',
          half: '&#xbd;',
          hamilt: '&#x210b;',
          hardcy: '&#x44a;',
          harr: '&#x2194;',
          harrcir: '&#x2948;',
          harrw: '&#x21ad;',
          hbar: '&#x210f;',
          hcirc: '&#x125;',
          hearts: '&#x2665;',
          heartsuit: '&#x2665;',
          hellip: '&#x2026;',
          hercon: '&#x22b9;',
          hfr: '&#x1d525;',
          hksearow: '&#x2925;',
          hkswarow: '&#x2926;',
          hoarr: '&#x21ff;',
          homtht: '&#x223b;',
          hookleftarrow: '&#x21a9;',
          hookrightarrow: '&#x21aa;',
          hopf: '&#x1d559;',
          horbar: '&#x2015;',
          hscr: '&#x1d4bd;',
          hslash: '&#x210f;',
          hstrok: '&#x127;',
          hybull: '&#x2043;',
          hyphen: '&#x2010;',
          iacute: '&#xed;',
          ic: '&#x2063;',
          icirc: '&#xee;',
          icy: '&#x438;',
          iecy: '&#x435;',
          iexcl: '&#xa1;',
          iff: '&#x21d4;',
          ifr: '&#x1d526;',
          igrave: '&#xec;',
          ii: '&#x2148;',
          iiiint: '&#x2a0c;',
          iiint: '&#x222d;',
          iinfin: '&#x29dc;',
          iiota: '&#x2129;',
          ijlig: '&#x133;',
          imacr: '&#x12b;',
          image: '&#x2111;',
          imagline: '&#x2110;',
          imagpart: '&#x2111;',
          imath: '&#x131;',
          imof: '&#x22b7;',
          imped: '&#x1b5;',
          in: '&#x2208;',
          incare: '&#x2105;',
          infin: '&#x221e;',
          infintie: '&#x29dd;',
          inodot: '&#x131;',
          int: '&#x222b;',
          intcal: '&#x22ba;',
          integers: '&#x2124;',
          intercal: '&#x22ba;',
          intlarhk: '&#x2a17;',
          intprod: '&#x2a3c;',
          iocy: '&#x451;',
          iogon: '&#x12f;',
          iopf: '&#x1d55a;',
          iota: '&#x3b9;',
          iprod: '&#x2a3c;',
          iquest: '&#xbf;',
          iscr: '&#x1d4be;',
          isin: '&#x2208;',
          isinE: '&#x22f9;',
          isindot: '&#x22f5;',
          isins: '&#x22f4;',
          isinsv: '&#x22f3;',
          isinv: '&#x2208;',
          it: '&#x2062;',
          itilde: '&#x129;',
          iukcy: '&#x456;',
          iuml: '&#xef;',
          jcirc: '&#x135;',
          jcy: '&#x439;',
          jfr: '&#x1d527;',
          jmath: '&#x6a;',
          jopf: '&#x1d55b;',
          jscr: '&#x1d4bf;',
          jsercy: '&#x458;',
          jukcy: '&#x454;',
          kappa: '&#x3ba;',
          kappav: '&#x3f0;',
          kcedil: '&#x137;',
          kcy: '&#x43a;',
          kfr: '&#x1d528;',
          kgreen: '&#x138;',
          khcy: '&#x445;',
          kjcy: '&#x45c;',
          kopf: '&#x1d55c;',
          kscr: '&#x1d4c0;',
          lAarr: '&#x21da;',
          lArr: '&#x21d0;',
          lAtail: '&#x291b;',
          lBarr: '&#x290e;',
          lE: '&#x2266;',
          lEg: '&#x2a8b;',
          lHar: '&#x2962;',
          lacute: '&#x13a;',
          laemptyv: '&#x29b4;',
          lagran: '&#x2112;',
          lambda: '&#x3bb;',
          lang: '&#x2329;',
          langd: '&#x2991;',
          langle: '&#x2329;',
          lap: '&#x2a85;',
          laquo: '&#xab;',
          larr: '&#x2190;',
          larrb: '&#x21e4;',
          larrbfs: '&#x291f;',
          larrfs: '&#x291d;',
          larrhk: '&#x21a9;',
          larrlp: '&#x21ab;',
          larrpl: '&#x2939;',
          larrsim: '&#x2973;',
          larrtl: '&#x21a2;',
          lat: '&#x2aab;',
          latail: '&#x2919;',
          late: '&#x2aad;',
          lates: '&#x2aad;&#xfe00;',
          lbarr: '&#x290c;',
          lbbrk: '&#x3014;',
          lbrace: '&#x7b;',
          lbrack: '&#x5b;',
          lbrke: '&#x298b;',
          lbrksld: '&#x298f;',
          lbrkslu: '&#x298d;',
          lcaron: '&#x13e;',
          lcedil: '&#x13c;',
          lceil: '&#x2308;',
          lcub: '&#x7b;',
          lcy: '&#x43b;',
          ldca: '&#x2936;',
          ldquo: '&#x201c;',
          ldquor: '&#x201e;',
          ldrdhar: '&#x2967;',
          ldrushar: '&#x294b;',
          ldsh: '&#x21b2;',
          le: '&#x2264;',
          leftarrow: '&#x2190;',
          leftarrowtail: '&#x21a2;',
          leftharpoondown: '&#x21bd;',
          leftharpoonup: '&#x21bc;',
          leftleftarrows: '&#x21c7;',
          leftrightarrow: '&#x2194;',
          leftrightarrows: '&#x21c6;',
          leftrightharpoons: '&#x21cb;',
          leftrightsquigarrow: '&#x21ad;',
          leftthreetimes: '&#x22cb;',
          leg: '&#x22da;',
          leq: '&#x2264;',
          leqq: '&#x2266;',
          leqslant: '&#x2a7d;',
          les: '&#x2a7d;',
          lescc: '&#x2aa8;',
          lesdot: '&#x2a7f;',
          lesdoto: '&#x2a81;',
          lesdotor: '&#x2a83;',
          lesg: '&#x22da;&#xfe00;',
          lesges: '&#x2a93;',
          lessapprox: '&#x2a85;',
          lessdot: '&#x22d6;',
          lesseqgtr: '&#x22da;',
          lesseqqgtr: '&#x2a8b;',
          lessgtr: '&#x2276;',
          lesssim: '&#x2272;',
          lfisht: '&#x297c;',
          lfloor: '&#x230a;',
          lfr: '&#x1d529;',
          lg: '&#x2276;',
          lgE: '&#x2a91;',
          lhard: '&#x21bd;',
          lharu: '&#x21bc;',
          lharul: '&#x296a;',
          lhblk: '&#x2584;',
          ljcy: '&#x459;',
          ll: '&#x226a;',
          llarr: '&#x21c7;',
          llcorner: '&#x231e;',
          llhard: '&#x296b;',
          lltri: '&#x25fa;',
          lmidot: '&#x140;',
          lmoust: '&#x23b0;',
          lmoustache: '&#x23b0;',
          lnE: '&#x2268;',
          lnap: '&#x2a89;',
          lnapprox: '&#x2a89;',
          lne: '&#x2a87;',
          lneq: '&#x2a87;',
          lneqq: '&#x2268;',
          lnsim: '&#x22e6;',
          loang: '&#x3018;',
          loarr: '&#x21fd;',
          lobrk: '&#x301a;',
          longleftarrow: '&#x27f5;',
          longleftrightarrow: '&#x27f7;',
          longmapsto: '&#x27fc;',
          longrightarrow: '&#x27f6;',
          looparrowleft: '&#x21ab;',
          looparrowright: '&#x21ac;',
          lopar: '&#x2985;',
          lopf: '&#x1d55d;',
          loplus: '&#x2a2d;',
          lotimes: '&#x2a34;',
          lowast: '&#x2217;',
          lowbar: '&#x5f;',
          loz: '&#x25ca;',
          lozenge: '&#x25ca;',
          lozf: '&#x29eb;',
          lpar: '&#x28;',
          lparlt: '&#x2993;',
          lrarr: '&#x21c6;',
          lrcorner: '&#x231f;',
          lrhar: '&#x21cb;',
          lrhard: '&#x296d;',
          lrtri: '&#x22bf;',
          lscr: '&#x1d4c1;',
          lsh: '&#x21b0;',
          lsim: '&#x2272;',
          lsime: '&#x2a8d;',
          lsimg: '&#x2a8f;',
          lsqb: '&#x5b;',
          lsquo: '&#x2018;',
          lsquor: '&#x201a;',
          lstrok: '&#x142;',
          lt: '&#x3c;',
          ltcc: '&#x2aa6;',
          ltcir: '&#x2a79;',
          ltdot: '&#x22d6;',
          lthree: '&#x22cb;',
          ltimes: '&#x22c9;',
          ltlarr: '&#x2976;',
          ltquest: '&#x2a7b;',
          ltrPar: '&#x2996;',
          ltri: '&#x25c3;',
          ltrie: '&#x22b4;',
          ltrif: '&#x25c2;',
          lurdshar: '&#x294a;',
          luruhar: '&#x2966;',
          lvertneqq: '&#x2268;&#xfe00;',
          lvnE: '&#x2268;&#xfe00;',
          mDDot: '&#x223a;',
          macr: '&#xaf;',
          male: '&#x2642;',
          malt: '&#x2720;',
          maltese: '&#x2720;',
          map: '&#x21a6;',
          mapsto: '&#x21a6;',
          mapstodown: '&#x21a7;',
          mapstoleft: '&#x21a4;',
          mapstoup: '&#x21a5;',
          marker: '&#x25ae;',
          mcomma: '&#x2a29;',
          mcy: '&#x43c;',
          mdash: '&#x2014;',
          measuredangle: '&#x2221;',
          mfr: '&#x1d52a;',
          mho: '&#x2127;',
          micro: '&#xb5;',
          mid: '&#x2223;',
          midast: '&#x2a;',
          midcir: '&#x2af0;',
          middot: '&#xb7;',
          minus: '&#x2212;',
          minusb: '&#x229f;',
          minusd: '&#x2238;',
          minusdu: '&#x2a2a;',
          mlcp: '&#x2adb;',
          mldr: '&#x2026;',
          mnplus: '&#x2213;',
          models: '&#x22a7;',
          mopf: '&#x1d55e;',
          mp: '&#x2213;',
          mscr: '&#x1d4c2;',
          mstpos: '&#x223e;',
          mu: '&#x3bc;',
          multimap: '&#x22b8;',
          mumap: '&#x22b8;',
          nGg: '&#x22d9;&#x338;',
          nGt: '&#x226b;&#x20d2;',
          nGtv: '&#x226b;&#x338;',
          nLeftarrow: '&#x21cd;',
          nLeftrightarrow: '&#x21ce;',
          nLl: '&#x22d8;&#x338;',
          nLt: '&#x226a;&#x20d2;',
          nLtv: '&#x226a;&#x338;',
          nRightarrow: '&#x21cf;',
          nVDash: '&#x22af;',
          nVdash: '&#x22ae;',
          nabla: '&#x2207;',
          nacute: '&#x144;',
          nang: '&#x2220;&#x20d2;',
          nap: '&#x2249;',
          napE: '&#x2a70;&#x338;',
          napid: '&#x224b;&#x338;',
          napos: '&#x149;',
          napprox: '&#x2249;',
          natur: '&#x266e;',
          natural: '&#x266e;',
          naturals: '&#x2115;',
          nbsp: '&#xa0;',
          nbump: '&#x224e;&#x338;',
          nbumpe: '&#x224f;&#x338;',
          ncap: '&#x2a43;',
          ncaron: '&#x148;',
          ncedil: '&#x146;',
          ncong: '&#x2247;',
          ncongdot: '&#x2a6d;&#x338;',
          ncup: '&#x2a42;',
          ncy: '&#x43d;',
          ndash: '&#x2013;',
          ne: '&#x2260;',
          neArr: '&#x21d7;',
          nearhk: '&#x2924;',
          nearr: '&#x2197;',
          nearrow: '&#x2197;',
          nedot: '&#x2250;&#x338;',
          nequiv: '&#x2262;',
          nesear: '&#x2928;',
          nesim: '&#x2242;&#x338;',
          nexist: '&#x2204;',
          nexists: '&#x2204;',
          nfr: '&#x1d52b;',
          ngE: '&#x2267;&#x338;',
          nge: '&#x2271;',
          ngeq: '&#x2271;',
          ngeqq: '&#x2267;&#x338;',
          ngeqslant: '&#x2a7e;&#x338;',
          nges: '&#x2a7e;&#x338;',
          ngsim: '&#x2275;',
          ngt: '&#x226f;',
          ngtr: '&#x226f;',
          nhArr: '&#x21ce;',
          nharr: '&#x21ae;',
          nhpar: '&#x2af2;',
          ni: '&#x220b;',
          nis: '&#x22fc;',
          nisd: '&#x22fa;',
          niv: '&#x220b;',
          njcy: '&#x45a;',
          nlArr: '&#x21cd;',
          nlE: '&#x2266;&#x338;',
          nlarr: '&#x219a;',
          nldr: '&#x2025;',
          nle: '&#x2270;',
          nleftarrow: '&#x219a;',
          nleftrightarrow: '&#x21ae;',
          nleq: '&#x2270;',
          nleqq: '&#x2266;&#x338;',
          nleqslant: '&#x2a7d;&#x338;',
          nles: '&#x2a7d;&#x338;',
          nless: '&#x226e;',
          nlsim: '&#x2274;',
          nlt: '&#x226e;',
          nltri: '&#x22ea;',
          nltrie: '&#x22ec;',
          nmid: '&#x2224;',
          nopf: '&#x1d55f;',
          not: '&#xac;',
          notin: '&#x2209;',
          notinE: '&#x22f9;&#x338;',
          notindot: '&#x22f5;&#x338;',
          notinva: '&#x2209;',
          notinvb: '&#x22f7;',
          notinvc: '&#x22f6;',
          notni: '&#x220c;',
          notniva: '&#x220c;',
          notnivb: '&#x22fe;',
          notnivc: '&#x22fd;',
          npar: '&#x2226;',
          nparallel: '&#x2226;',
          nparsl: '&#x2afd;&#x20e5;',
          npart: '&#x2202;&#x338;',
          npolint: '&#x2a14;',
          npr: '&#x2280;',
          nprcue: '&#x22e0;',
          npre: '&#x2aaf;&#x338;',
          nprec: '&#x2280;',
          npreceq: '&#x2aaf;&#x338;',
          nrArr: '&#x21cf;',
          nrarr: '&#x219b;',
          nrarrc: '&#x2933;&#x338;',
          nrarrw: '&#x219d;&#x338;',
          nrightarrow: '&#x219b;',
          nrtri: '&#x22eb;',
          nrtrie: '&#x22ed;',
          nsc: '&#x2281;',
          nsccue: '&#x22e1;',
          nsce: '&#x2ab0;&#x338;',
          nscr: '&#x1d4c3;',
          nshortmid: '&#x2224;',
          nshortparallel: '&#x2226;',
          nsim: '&#x2241;',
          nsime: '&#x2244;',
          nsimeq: '&#x2244;',
          nsmid: '&#x2224;',
          nspar: '&#x2226;',
          nsqsube: '&#x22e2;',
          nsqsupe: '&#x22e3;',
          nsub: '&#x2284;',
          nsubE: '&#x2ac5;&#x338;',
          nsube: '&#x2288;',
          nsubset: '&#x2282;&#x20d2;',
          nsubseteq: '&#x2288;',
          nsubseteqq: '&#x2ac5;&#x338;',
          nsucc: '&#x2281;',
          nsucceq: '&#x2ab0;&#x338;',
          nsup: '&#x2285;',
          nsupE: '&#x2ac6;&#x338;',
          nsupe: '&#x2289;',
          nsupset: '&#x2283;&#x20d2;',
          nsupseteq: '&#x2289;',
          nsupseteqq: '&#x2ac6;&#x338;',
          ntgl: '&#x2279;',
          ntilde: '&#xf1;',
          ntlg: '&#x2278;',
          ntriangleleft: '&#x22ea;',
          ntrianglelefteq: '&#x22ec;',
          ntriangleright: '&#x22eb;',
          ntrianglerighteq: '&#x22ed;',
          nu: '&#x3bd;',
          num: '&#x23;',
          numero: '&#x2116;',
          numsp: '&#x2007;',
          nvDash: '&#x22ad;',
          nvHarr: '&#x2904;',
          nvap: '&#x224d;&#x20d2;',
          nvdash: '&#x22ac;',
          nvge: '&#x2265;&#x20d2;',
          nvgt: '&#x3e;&#x20d2;',
          nvinfin: '&#x29de;',
          nvlArr: '&#x2902;',
          nvle: '&#x2264;&#x20d2;',
          nvlt: '&#x3c;&#x20d2;',
          nvltrie: '&#x22b4;&#x20d2;',
          nvrArr: '&#x2903;',
          nvrtrie: '&#x22b5;&#x20d2;',
          nvsim: '&#x223c;&#x20d2;',
          nwArr: '&#x21d6;',
          nwarhk: '&#x2923;',
          nwarr: '&#x2196;',
          nwarrow: '&#x2196;',
          nwnear: '&#x2927;',
          oS: '&#x24c8;',
          oacute: '&#xf3;',
          oast: '&#x229b;',
          ocir: '&#x229a;',
          ocirc: '&#xf4;',
          ocy: '&#x43e;',
          odash: '&#x229d;',
          odblac: '&#x151;',
          odiv: '&#x2a38;',
          odot: '&#x2299;',
          odsold: '&#x29bc;',
          oelig: '&#x153;',
          ofcir: '&#x29bf;',
          ofr: '&#x1d52c;',
          ogon: '&#x2db;',
          ograve: '&#xf2;',
          ogt: '&#x29c1;',
          ohbar: '&#x29b5;',
          ohm: '&#x2126;',
          oint: '&#x222e;',
          olarr: '&#x21ba;',
          olcir: '&#x29be;',
          olcross: '&#x29bb;',
          olt: '&#x29c0;',
          omacr: '&#x14d;',
          omega: '&#x3c9;',
          omid: '&#x29b6;',
          ominus: '&#x2296;',
          oopf: '&#x1d560;',
          opar: '&#x29b7;',
          operp: '&#x29b9;',
          oplus: '&#x2295;',
          or: '&#x2228;',
          orarr: '&#x21bb;',
          ord: '&#x2a5d;',
          order: '&#x2134;',
          orderof: '&#x2134;',
          ordf: '&#xaa;',
          ordm: '&#xba;',
          origof: '&#x22b6;',
          oror: '&#x2a56;',
          orslope: '&#x2a57;',
          orv: '&#x2a5b;',
          oscr: '&#x2134;',
          oslash: '&#xf8;',
          osol: '&#x2298;',
          otilde: '&#xf5;',
          otimes: '&#x2297;',
          otimesas: '&#x2a36;',
          ouml: '&#xf6;',
          ovbar: '&#x233d;',
          par: '&#x2225;',
          para: '&#xb6;',
          parallel: '&#x2225;',
          parsim: '&#x2af3;',
          parsl: '&#x2afd;',
          part: '&#x2202;',
          pcy: '&#x43f;',
          percnt: '&#x25;',
          period: '&#x2e;',
          permil: '&#x2030;',
          perp: '&#x22a5;',
          pertenk: '&#x2031;',
          pfr: '&#x1d52d;',
          phi: '&#x3d5;',
          phiv: '&#x3c6;',
          phmmat: '&#x2133;',
          phone: '&#x260e;',
          pi: '&#x3c0;',
          pitchfork: '&#x22d4;',
          piv: '&#x3d6;',
          planck: '&#x210f;',
          planckh: '&#x210e;',
          plankv: '&#x210f;',
          plus: '&#x2b;',
          plusacir: '&#x2a23;',
          plusb: '&#x229e;',
          pluscir: '&#x2a22;',
          plusdo: '&#x2214;',
          plusdu: '&#x2a25;',
          pluse: '&#x2a72;',
          plusmn: '&#xb1;',
          plussim: '&#x2a26;',
          plustwo: '&#x2a27;',
          pm: '&#xb1;',
          pointint: '&#x2a15;',
          popf: '&#x1d561;',
          pound: '&#xa3;',
          pr: '&#x227a;',
          prE: '&#x2ab3;',
          prap: '&#x2ab7;',
          prcue: '&#x227c;',
          pre: '&#x2aaf;',
          prec: '&#x227a;',
          precapprox: '&#x2ab7;',
          preccurlyeq: '&#x227c;',
          preceq: '&#x2aaf;',
          precnapprox: '&#x2ab9;',
          precneqq: '&#x2ab5;',
          precnsim: '&#x22e8;',
          precsim: '&#x227e;',
          prime: '&#x2032;',
          primes: '&#x2119;',
          prnE: '&#x2ab5;',
          prnap: '&#x2ab9;',
          prnsim: '&#x22e8;',
          prod: '&#x220f;',
          profalar: '&#x232e;',
          profline: '&#x2312;',
          profsurf: '&#x2313;',
          prop: '&#x221d;',
          propto: '&#x221d;',
          prsim: '&#x227e;',
          prurel: '&#x22b0;',
          pscr: '&#x1d4c5;',
          psi: '&#x3c8;',
          puncsp: '&#x2008;',
          qfr: '&#x1d52e;',
          qint: '&#x2a0c;',
          qopf: '&#x1d562;',
          qprime: '&#x2057;',
          qscr: '&#x1d4c6;',
          quaternions: '&#x210d;',
          quatint: '&#x2a16;',
          quest: '&#x3f;',
          questeq: '&#x225f;',
          quot: '&#x22;',
          rAarr: '&#x21db;',
          rArr: '&#x21d2;',
          rAtail: '&#x291c;',
          rBarr: '&#x290f;',
          rHar: '&#x2964;',
          race: '&#x29da;',
          racute: '&#x155;',
          radic: '&#x221a;',
          raemptyv: '&#x29b3;',
          rang: '&#x232a;',
          rangd: '&#x2992;',
          range: '&#x29a5;',
          rangle: '&#x232a;',
          raquo: '&#xbb;',
          rarr: '&#x2192;',
          rarrap: '&#x2975;',
          rarrb: '&#x21e5;',
          rarrbfs: '&#x2920;',
          rarrc: '&#x2933;',
          rarrfs: '&#x291e;',
          rarrhk: '&#x21aa;',
          rarrlp: '&#x21ac;',
          rarrpl: '&#x2945;',
          rarrsim: '&#x2974;',
          rarrtl: '&#x21a3;',
          rarrw: '&#x219d;',
          ratail: '&#x291a;',
          ratio: '&#x2236;',
          rationals: '&#x211a;',
          rbarr: '&#x290d;',
          rbbrk: '&#x3015;',
          rbrace: '&#x7d;',
          rbrack: '&#x5d;',
          rbrke: '&#x298c;',
          rbrksld: '&#x298e;',
          rbrkslu: '&#x2990;',
          rcaron: '&#x159;',
          rcedil: '&#x157;',
          rceil: '&#x2309;',
          rcub: '&#x7d;',
          rcy: '&#x440;',
          rdca: '&#x2937;',
          rdldhar: '&#x2969;',
          rdquo: '&#x201d;',
          rdquor: '&#x201d;',
          rdsh: '&#x21b3;',
          real: '&#x211c;',
          realine: '&#x211b;',
          realpart: '&#x211c;',
          reals: '&#x211d;',
          rect: '&#x25ad;',
          reg: '&#xae;',
          rfisht: '&#x297d;',
          rfloor: '&#x230b;',
          rfr: '&#x1d52f;',
          rhard: '&#x21c1;',
          rharu: '&#x21c0;',
          rharul: '&#x296c;',
          rho: '&#x3c1;',
          rhov: '&#x3f1;',
          rightarrow: '&#x2192;',
          rightarrowtail: '&#x21a3;',
          rightharpoondown: '&#x21c1;',
          rightharpoonup: '&#x21c0;',
          rightleftarrows: '&#x21c4;',
          rightleftharpoons: '&#x21cc;',
          rightrightarrows: '&#x21c9;',
          rightsquigarrow: '&#x219d;',
          rightthreetimes: '&#x22cc;',
          ring: '&#x2da;',
          risingdotseq: '&#x2253;',
          rlarr: '&#x21c4;',
          rlhar: '&#x21cc;',
          rmoust: '&#x23b1;',
          rmoustache: '&#x23b1;',
          rnmid: '&#x2aee;',
          roang: '&#x3019;',
          roarr: '&#x21fe;',
          robrk: '&#x301b;',
          ropar: '&#x2986;',
          ropf: '&#x1d563;',
          roplus: '&#x2a2e;',
          rotimes: '&#x2a35;',
          rpar: '&#x29;',
          rpargt: '&#x2994;',
          rppolint: '&#x2a12;',
          rrarr: '&#x21c9;',
          rscr: '&#x1d4c7;',
          rsh: '&#x21b1;',
          rsqb: '&#x5d;',
          rsquo: '&#x2019;',
          rsquor: '&#x2019;',
          rthree: '&#x22cc;',
          rtimes: '&#x22ca;',
          rtri: '&#x25b9;',
          rtrie: '&#x22b5;',
          rtrif: '&#x25b8;',
          rtriltri: '&#x29ce;',
          ruluhar: '&#x2968;',
          rx: '&#x211e;',
          sacute: '&#x15b;',
          sc: '&#x227b;',
          scE: '&#x2ab4;',
          scap: '&#x2ab8;',
          scaron: '&#x161;',
          sccue: '&#x227d;',
          sce: '&#x2ab0;',
          scedil: '&#x15f;',
          scirc: '&#x15d;',
          scnE: '&#x2ab6;',
          scnap: '&#x2aba;',
          scnsim: '&#x22e9;',
          scpolint: '&#x2a13;',
          scsim: '&#x227f;',
          scy: '&#x441;',
          sdot: '&#x22c5;',
          sdotb: '&#x22a1;',
          sdote: '&#x2a66;',
          seArr: '&#x21d8;',
          searhk: '&#x2925;',
          searr: '&#x2198;',
          searrow: '&#x2198;',
          sect: '&#xa7;',
          semi: '&#x3b;',
          seswar: '&#x2929;',
          setminus: '&#x2216;',
          setmn: '&#x2216;',
          sext: '&#x2736;',
          sfr: '&#x1d530;',
          sfrown: '&#x2322;',
          sharp: '&#x266f;',
          shchcy: '&#x449;',
          shcy: '&#x448;',
          shortmid: '&#x2223;',
          shortparallel: '&#x2225;',
          shy: '&#xad;',
          sigma: '&#x3c3;',
          sigmav: '&#x3c2;',
          sim: '&#x223c;',
          simdot: '&#x2a6a;',
          sime: '&#x2243;',
          simeq: '&#x2243;',
          simg: '&#x2a9e;',
          simgE: '&#x2aa0;',
          siml: '&#x2a9d;',
          simlE: '&#x2a9f;',
          simne: '&#x2246;',
          simplus: '&#x2a24;',
          simrarr: '&#x2972;',
          slarr: '&#x2190;',
          smallsetminus: '&#x2216;',
          smashp: '&#x2a33;',
          smeparsl: '&#x29e4;',
          smid: '&#x2223;',
          smile: '&#x2323;',
          smt: '&#x2aaa;',
          smte: '&#x2aac;',
          smtes: '&#x2aac;&#xfe00;',
          softcy: '&#x44c;',
          sol: '&#x2f;',
          solb: '&#x29c4;',
          solbar: '&#x233f;',
          sopf: '&#x1d564;',
          spades: '&#x2660;',
          spadesuit: '&#x2660;',
          spar: '&#x2225;',
          sqcap: '&#x2293;',
          sqcaps: '&#x2293;&#xfe00;',
          sqcup: '&#x2294;',
          sqcups: '&#x2294;&#xfe00;',
          sqsub: '&#x228f;',
          sqsube: '&#x2291;',
          sqsubset: '&#x228f;',
          sqsubseteq: '&#x2291;',
          sqsup: '&#x2290;',
          sqsupe: '&#x2292;',
          sqsupset: '&#x2290;',
          sqsupseteq: '&#x2292;',
          squ: '&#x25a1;',
          square: '&#x25a1;',
          squarf: '&#x25aa;',
          squf: '&#x25aa;',
          srarr: '&#x2192;',
          sscr: '&#x1d4c8;',
          ssetmn: '&#x2216;',
          ssmile: '&#x2323;',
          sstarf: '&#x22c6;',
          star: '&#x2606;',
          starf: '&#x2605;',
          straightepsilon: '&#x3f5;',
          straightphi: '&#x3d5;',
          strns: '&#xaf;',
          sub: '&#x2282;',
          subE: '&#x2ac5;',
          subdot: '&#x2abd;',
          sube: '&#x2286;',
          subedot: '&#x2ac3;',
          submult: '&#x2ac1;',
          subnE: '&#x2acb;',
          subne: '&#x228a;',
          subplus: '&#x2abf;',
          subrarr: '&#x2979;',
          subset: '&#x2282;',
          subseteq: '&#x2286;',
          subseteqq: '&#x2ac5;',
          subsetneq: '&#x228a;',
          subsetneqq: '&#x2acb;',
          subsim: '&#x2ac7;',
          subsub: '&#x2ad5;',
          subsup: '&#x2ad3;',
          succ: '&#x227b;',
          succapprox: '&#x2ab8;',
          succcurlyeq: '&#x227d;',
          succeq: '&#x2ab0;',
          succnapprox: '&#x2aba;',
          succneqq: '&#x2ab6;',
          succnsim: '&#x22e9;',
          succsim: '&#x227f;',
          sum: '&#x2211;',
          sung: '&#x266a;',
          sup: '&#x2283;',
          sup1: '&#xb9;',
          sup2: '&#xb2;',
          sup3: '&#xb3;',
          supE: '&#x2ac6;',
          supdot: '&#x2abe;',
          supdsub: '&#x2ad8;',
          supe: '&#x2287;',
          supedot: '&#x2ac4;',
          suphsol: '&#x2283;&#x2f;',
          suphsub: '&#x2ad7;',
          suplarr: '&#x297b;',
          supmult: '&#x2ac2;',
          supnE: '&#x2acc;',
          supne: '&#x228b;',
          supplus: '&#x2ac0;',
          supset: '&#x2283;',
          supseteq: '&#x2287;',
          supseteqq: '&#x2ac6;',
          supsetneq: '&#x228b;',
          supsetneqq: '&#x2acc;',
          supsim: '&#x2ac8;',
          supsub: '&#x2ad4;',
          supsup: '&#x2ad6;',
          swArr: '&#x21d9;',
          swarhk: '&#x2926;',
          swarr: '&#x2199;',
          swarrow: '&#x2199;',
          swnwar: '&#x292a;',
          szlig: '&#xdf;',
          target: '&#x2316;',
          tau: '&#x3c4;',
          tbrk: '&#x23b4;',
          tcaron: '&#x165;',
          tcedil: '&#x163;',
          tcy: '&#x442;',
          tdot: '&#x20db;',
          telrec: '&#x2315;',
          tfr: '&#x1d531;',
          there4: '&#x2234;',
          therefore: '&#x2234;',
          theta: '&#x3b8;',
          thetav: '&#x3d1;',
          thickapprox: '&#x2248;',
          thicksim: '&#x223c;',
          thinsp: '&#x2009;',
          thkap: '&#x2248;',
          thksim: '&#x223c;',
          thorn: '&#xfe;',
          tilde: '&#x2dc;',
          times: '&#xd7;',
          timesb: '&#x22a0;',
          timesbar: '&#x2a31;',
          timesd: '&#x2a30;',
          tint: '&#x222d;',
          toea: '&#x2928;',
          top: '&#x22a4;',
          topbot: '&#x2336;',
          topcir: '&#x2af1;',
          topf: '&#x1d565;',
          topfork: '&#x2ada;',
          tosa: '&#x2929;',
          tprime: '&#x2034;',
          trade: '&#x2122;',
          triangle: '&#x25b5;',
          triangledown: '&#x25bf;',
          triangleleft: '&#x25c3;',
          trianglelefteq: '&#x22b4;',
          triangleq: '&#x225c;',
          triangleright: '&#x25b9;',
          trianglerighteq: '&#x22b5;',
          tridot: '&#x25ec;',
          trie: '&#x225c;',
          triminus: '&#x2a3a;',
          triplus: '&#x2a39;',
          trisb: '&#x29cd;',
          tritime: '&#x2a3b;',
          trpezium: '&#xfffd;',
          tscr: '&#x1d4c9;',
          tscy: '&#x446;',
          tshcy: '&#x45b;',
          tstrok: '&#x167;',
          twixt: '&#x226c;',
          twoheadleftarrow: '&#x219e;',
          twoheadrightarrow: '&#x21a0;',
          uArr: '&#x21d1;',
          uHar: '&#x2963;',
          uacute: '&#xfa;',
          uarr: '&#x2191;',
          ubrcy: '&#x45e;',
          ubreve: '&#x16d;',
          ucirc: '&#xfb;',
          ucy: '&#x443;',
          udarr: '&#x21c5;',
          udblac: '&#x171;',
          udhar: '&#x296e;',
          ufisht: '&#x297e;',
          ufr: '&#x1d532;',
          ugrave: '&#xf9;',
          uharl: '&#x21bf;',
          uharr: '&#x21be;',
          uhblk: '&#x2580;',
          ulcorn: '&#x231c;',
          ulcorner: '&#x231c;',
          ulcrop: '&#x230f;',
          ultri: '&#x25f8;',
          umacr: '&#x16b;',
          uml: '&#xa8;',
          uogon: '&#x173;',
          uopf: '&#x1d566;',
          uparrow: '&#x2191;',
          updownarrow: '&#x2195;',
          upharpoonleft: '&#x21bf;',
          upharpoonright: '&#x21be;',
          uplus: '&#x228e;',
          upsi: '&#x3c5;',
          upsilon: '&#x3c5;',
          upuparrows: '&#x21c8;',
          urcorn: '&#x231d;',
          urcorner: '&#x231d;',
          urcrop: '&#x230e;',
          uring: '&#x16f;',
          urtri: '&#x25f9;',
          uscr: '&#x1d4ca;',
          utdot: '&#x22f0;',
          utilde: '&#x169;',
          utri: '&#x25b5;',
          utrif: '&#x25b4;',
          uuarr: '&#x21c8;',
          uuml: '&#xfc;',
          uwangle: '&#x29a7;',
          vArr: '&#x21d5;',
          vBar: '&#x2ae8;',
          vBarv: '&#x2ae9;',
          vDash: '&#x22a8;',
          vangrt: '&#x299c;',
          varepsilon: '&#x3b5;',
          varkappa: '&#x3f0;',
          varnothing: '&#x2205;',
          varphi: '&#x3c6;',
          varpi: '&#x3d6;',
          varpropto: '&#x221d;',
          varr: '&#x2195;',
          varrho: '&#x3f1;',
          varsigma: '&#x3c2;',
          varsubsetneq: '&#x228a;&#xfe00;',
          varsubsetneqq: '&#x2acb;&#xfe00;',
          varsupsetneq: '&#x228b;&#xfe00;',
          varsupsetneqq: '&#x2acc;&#xfe00;',
          vartheta: '&#x3d1;',
          vartriangleleft: '&#x22b2;',
          vartriangleright: '&#x22b3;',
          vcy: '&#x432;',
          vdash: '&#x22a2;',
          vee: '&#x2228;',
          veebar: '&#x22bb;',
          veeeq: '&#x225a;',
          vellip: '&#x22ee;',
          verbar: '&#x7c;',
          vert: '&#x7c;',
          vfr: '&#x1d533;',
          vltri: '&#x22b2;',
          vnsub: '&#x2282;&#x20d2;',
          vnsup: '&#x2283;&#x20d2;',
          vopf: '&#x1d567;',
          vprop: '&#x221d;',
          vrtri: '&#x22b3;',
          vscr: '&#x1d4cb;',
          vsubnE: '&#x2acb;&#xfe00;',
          vsubne: '&#x228a;&#xfe00;',
          vsupnE: '&#x2acc;&#xfe00;',
          vsupne: '&#x228b;&#xfe00;',
          vzigzag: '&#x299a;',
          wcirc: '&#x175;',
          wedbar: '&#x2a5f;',
          wedge: '&#x2227;',
          wedgeq: '&#x2259;',
          weierp: '&#x2118;',
          wfr: '&#x1d534;',
          wopf: '&#x1d568;',
          wp: '&#x2118;',
          wr: '&#x2240;',
          wreath: '&#x2240;',
          wscr: '&#x1d4cc;',
          xcap: '&#x22c2;',
          xcirc: '&#x25ef;',
          xcup: '&#x22c3;',
          xdtri: '&#x25bd;',
          xfr: '&#x1d535;',
          xhArr: '&#x27fa;',
          xharr: '&#x27f7;',
          xi: '&#x3be;',
          xlArr: '&#x27f8;',
          xlarr: '&#x27f5;',
          xmap: '&#x27fc;',
          xnis: '&#x22fb;',
          xodot: '&#x2a00;',
          xopf: '&#x1d569;',
          xoplus: '&#x2a01;',
          xotime: '&#x2a02;',
          xrArr: '&#x27f9;',
          xrarr: '&#x27f6;',
          xscr: '&#x1d4cd;',
          xsqcup: '&#x2a06;',
          xuplus: '&#x2a04;',
          xutri: '&#x25b3;',
          xvee: '&#x22c1;',
          xwedge: '&#x22c0;',
          yacute: '&#xfd;',
          yacy: '&#x44f;',
          ycirc: '&#x177;',
          ycy: '&#x44b;',
          yen: '&#xa5;',
          yfr: '&#x1d536;',
          yicy: '&#x457;',
          yopf: '&#x1d56a;',
          yscr: '&#x1d4ce;',
          yucy: '&#x44e;',
          yuml: '&#xff;',
          zacute: '&#x17a;',
          zcaron: '&#x17e;',
          zcy: '&#x437;',
          zdot: '&#x17c;',
          zeetrf: '&#x2128;',
          zeta: '&#x3b6;',
          zfr: '&#x1d537;',
          zhcy: '&#x436;',
          zigrarr: '&#x21dd;',
          zopf: '&#x1d56b;',
          zscr: '&#x1d4cf;'
        }
    end
  end
end

require 'math_ml'
