# frozen_string_literal: true

require 'erb'
require 'active_record'
require 'with_advisory_lock'
require 'tmpdir'
require 'securerandom'
begin
  require 'activerecord-trilogy-adapter'
  ActiveSupport.on_load(:active_record) do
    require "trilogy_adapter/connection"
    ActiveRecord::Base.public_send :extend, TrilogyAdapter::Connection
  end
rescue LoadError
  # do nothing
end

ActiveRecord::Base.configurations = {
  default_env: {
    url: ENV.fetch('DATABASE_URL', "sqlite3://#{Dir.tmpdir}/#{SecureRandom.hex}.sqlite3"),
    properties: { allowPublicKeyRetrieval: true } # for JRuby madness
  }
}

ENV['WITH_ADVISORY_LOCK_PREFIX'] ||= SecureRandom.hex

ActiveRecord::Base.establish_connection

def env_db
  @env_db ||= ActiveRecord::Base.connection_db_config.adapter.to_sym
end

ActiveRecord::Migration.verbose = false

require 'test_models'
require 'minitest'
require 'maxitest/autorun'
require 'mocha/minitest'

class GemTestCase < ActiveSupport::TestCase
  setup do
    ENV['FLOCK_DIR'] = Dir.mktmpdir
    Tag.delete_all
    TagAudit.delete_all
    Label.delete_all
  end
  teardown do
    FileUtils.remove_entry_secure ENV['FLOCK_DIR']
  end
end

puts "Testing with #{env_db} database, ActiveRecord #{ActiveRecord.gem_version} and #{RUBY_ENGINE} #{RUBY_ENGINE_VERSION} as #{RUBY_VERSION}"
