var list = {

	"en": {

		"Manual": {

			"Getting Started": {
				"Creating a scene": "manual/en/introduction/Creating-a-scene",
				"Import via modules": "manual/en/introduction/Import-via-modules",
				"Browser support": "manual/en/introduction/Browser-support",
				"WebGL compatibility check": "manual/en/introduction/WebGL-compatibility-check",
				"How to run things locally": "manual/en/introduction/How-to-run-things-locally",
				"How to use WebGL 2": "manual/en/introduction/How-to-use-WebGL2",
				"Drawing lines": "manual/en/introduction/Drawing-lines",
				"Creating text": "manual/en/introduction/Creating-text",
				"Loading 3D models": "manual/en/introduction/Loading-3D-models",
				"FAQ": "manual/en/introduction/FAQ",
				"Useful links": "manual/en/introduction/Useful-links"
			},

			"Next Steps": {
				"How to update things": "manual/en/introduction/How-to-update-things",
				"How to dispose of objects": "manual/en/introduction/How-to-dispose-of-objects",
				"How to create VR content": "manual/en/introduction/How-to-create-VR-content",
				"How to use post-processing": "manual/en/introduction/How-to-use-post-processing",
				"Matrix transformations": "manual/en/introduction/Matrix-transformations",
				"Animation system": "manual/en/introduction/Animation-system"
			},

			"Build Tools": {
				"Testing with NPM": "manual/en/buildTools/Testing-with-NPM"
			}

		},

		"Reference": {

			"Animation": {
				"AnimationAction": "api/en/animation/AnimationAction",
				"AnimationClip": "api/en/animation/AnimationClip",
				"AnimationMixer": "api/en/animation/AnimationMixer",
				"AnimationObjectGroup": "api/en/animation/AnimationObjectGroup",
				"AnimationUtils": "api/en/animation/AnimationUtils",
				"KeyframeTrack": "api/en/animation/KeyframeTrack",
				"PropertyBinding": "api/en/animation/PropertyBinding",
				"PropertyMixer": "api/en/animation/PropertyMixer"
			},

			"Animation / Tracks": {
				"BooleanKeyframeTrack": "api/en/animation/tracks/BooleanKeyframeTrack",
				"ColorKeyframeTrack": "api/en/animation/tracks/ColorKeyframeTrack",
				"NumberKeyframeTrack": "api/en/animation/tracks/NumberKeyframeTrack",
				"QuaternionKeyframeTrack": "api/en/animation/tracks/QuaternionKeyframeTrack",
				"StringKeyframeTrack": "api/en/animation/tracks/StringKeyframeTrack",
				"VectorKeyframeTrack": "api/en/animation/tracks/VectorKeyframeTrack"
			},

			"Audio": {
				"Audio": "api/en/audio/Audio",
				"AudioAnalyser": "api/en/audio/AudioAnalyser",
				"AudioContext": "api/en/audio/AudioContext",
				"AudioListener": "api/en/audio/AudioListener",
				"PositionalAudio": "api/en/audio/PositionalAudio"
			},

			"Cameras": {
				"ArrayCamera": "api/en/cameras/ArrayCamera",
				"Camera": "api/en/cameras/Camera",
				"CubeCamera": "api/en/cameras/CubeCamera",
				"OrthographicCamera": "api/en/cameras/OrthographicCamera",
				"PerspectiveCamera": "api/en/cameras/PerspectiveCamera",
				"StereoCamera": "api/en/cameras/StereoCamera"
			},

			"Constants": {
				"Animation": "api/en/constants/Animation",
				"Core": "api/en/constants/Core",
				"CustomBlendingEquation": "api/en/constants/CustomBlendingEquations",
				"DrawModes": "api/en/constants/DrawModes",
				"Materials": "api/en/constants/Materials",
				"Renderer": "api/en/constants/Renderer",
				"Textures": "api/en/constants/Textures"
			},

			"Core": {
				"BufferAttribute": "api/en/core/BufferAttribute",
				"BufferGeometry": "api/en/core/BufferGeometry",
				"Clock": "api/en/core/Clock",
				"DirectGeometry": "api/en/core/DirectGeometry",
				"EventDispatcher": "api/en/core/EventDispatcher",
				"Face3": "api/en/core/Face3",
				"Geometry": "api/en/core/Geometry",
				"InstancedBufferAttribute": "api/en/core/InstancedBufferAttribute",
				"InstancedBufferGeometry": "api/en/core/InstancedBufferGeometry",
				"InstancedInterleavedBuffer": "api/en/core/InstancedInterleavedBuffer",
				"InterleavedBuffer": "api/en/core/InterleavedBuffer",
				"InterleavedBufferAttribute": "api/en/core/InterleavedBufferAttribute",
				"Layers": "api/en/core/Layers",
				"Object3D": "api/en/core/Object3D",
				"Raycaster": "api/en/core/Raycaster",
				"Uniform": "api/en/core/Uniform"
			},

			"Core / BufferAttributes": {
				"BufferAttribute Types": "api/en/core/bufferAttributeTypes/BufferAttributeTypes"
			},

			"Deprecated": {
				"DeprecatedList": "api/en/deprecated/DeprecatedList"
			},

			"Extras": {
				"Earcut": "api/en/extras/Earcut",
				"ShapeUtils": "api/en/extras/ShapeUtils"
			},

			"Extras / Core": {
				"Curve": "api/en/extras/core/Curve",
				"CurvePath": "api/en/extras/core/CurvePath",
				"Font": "api/en/extras/core/Font",
				"Interpolations": "api/en/extras/core/Interpolations",
				"Path": "api/en/extras/core/Path",
				"Shape": "api/en/extras/core/Shape",
				"ShapePath": "api/en/extras/core/ShapePath"
			},

			"Extras / Curves": {
				"ArcCurve": "api/en/extras/curves/ArcCurve",
				"CatmullRomCurve3": "api/en/extras/curves/CatmullRomCurve3",
				"CubicBezierCurve": "api/en/extras/curves/CubicBezierCurve",
				"CubicBezierCurve3": "api/en/extras/curves/CubicBezierCurve3",
				"EllipseCurve": "api/en/extras/curves/EllipseCurve",
				"LineCurve": "api/en/extras/curves/LineCurve",
				"LineCurve3": "api/en/extras/curves/LineCurve3",
				"QuadraticBezierCurve": "api/en/extras/curves/QuadraticBezierCurve",
				"QuadraticBezierCurve3": "api/en/extras/curves/QuadraticBezierCurve3",
				"SplineCurve": "api/en/extras/curves/SplineCurve"
			},

			"Extras / Objects": {
				"ImmediateRenderObject": "api/en/extras/objects/ImmediateRenderObject",
			},

			"Geometries": {
				"BoxBufferGeometry": "api/en/geometries/BoxBufferGeometry",
				"BoxGeometry": "api/en/geometries/BoxGeometry",
				"CircleBufferGeometry": "api/en/geometries/CircleBufferGeometry",
				"CircleGeometry": "api/en/geometries/CircleGeometry",
				"ConeBufferGeometry": "api/en/geometries/ConeBufferGeometry",
				"ConeGeometry": "api/en/geometries/ConeGeometry",
				"CylinderBufferGeometry": "api/en/geometries/CylinderBufferGeometry",
				"CylinderGeometry": "api/en/geometries/CylinderGeometry",
				"DodecahedronBufferGeometry": "api/en/geometries/DodecahedronBufferGeometry",
				"DodecahedronGeometry": "api/en/geometries/DodecahedronGeometry",
				"EdgesGeometry": "api/en/geometries/EdgesGeometry",
				"ExtrudeBufferGeometry": "api/en/geometries/ExtrudeBufferGeometry",
				"ExtrudeGeometry": "api/en/geometries/ExtrudeGeometry",
				"IcosahedronBufferGeometry": "api/en/geometries/IcosahedronBufferGeometry",
				"IcosahedronGeometry": "api/en/geometries/IcosahedronGeometry",
				"LatheBufferGeometry": "api/en/geometries/LatheBufferGeometry",
				"LatheGeometry": "api/en/geometries/LatheGeometry",
				"OctahedronBufferGeometry": "api/en/geometries/OctahedronBufferGeometry",
				"OctahedronGeometry": "api/en/geometries/OctahedronGeometry",
				"ParametricBufferGeometry": "api/en/geometries/ParametricBufferGeometry",
				"ParametricGeometry": "api/en/geometries/ParametricGeometry",
				"PlaneBufferGeometry": "api/en/geometries/PlaneBufferGeometry",
				"PlaneGeometry": "api/en/geometries/PlaneGeometry",
				"PolyhedronBufferGeometry": "api/en/geometries/PolyhedronBufferGeometry",
				"PolyhedronGeometry": "api/en/geometries/PolyhedronGeometry",
				"RingBufferGeometry": "api/en/geometries/RingBufferGeometry",
				"RingGeometry": "api/en/geometries/RingGeometry",
				"ShapeBufferGeometry": "api/en/geometries/ShapeBufferGeometry",
				"ShapeGeometry": "api/en/geometries/ShapeGeometry",
				"SphereBufferGeometry": "api/en/geometries/SphereBufferGeometry",
				"SphereGeometry": "api/en/geometries/SphereGeometry",
				"TetrahedronBufferGeometry": "api/en/geometries/TetrahedronBufferGeometry",
				"TetrahedronGeometry": "api/en/geometries/TetrahedronGeometry",
				"TextBufferGeometry": "api/en/geometries/TextBufferGeometry",
				"TextGeometry": "api/en/geometries/TextGeometry",
				"TorusBufferGeometry": "api/en/geometries/TorusBufferGeometry",
				"TorusGeometry": "api/en/geometries/TorusGeometry",
				"TorusKnotBufferGeometry": "api/en/geometries/TorusKnotBufferGeometry",
				"TorusKnotGeometry": "api/en/geometries/TorusKnotGeometry",
				"TubeBufferGeometry": "api/en/geometries/TubeBufferGeometry",
				"TubeGeometry": "api/en/geometries/TubeGeometry",
				"WireframeGeometry": "api/en/geometries/WireframeGeometry"
			},

			"Helpers": {
				"ArrowHelper": "api/en/helpers/ArrowHelper",
				"AxesHelper": "api/en/helpers/AxesHelper",
				"BoxHelper": "api/en/helpers/BoxHelper",
				"Box3Helper": "api/en/helpers/Box3Helper",
				"CameraHelper": "api/en/helpers/CameraHelper",
				"DirectionalLightHelper": "api/en/helpers/DirectionalLightHelper",
				"FaceNormalsHelper": "api/en/helpers/FaceNormalsHelper",
				"GridHelper": "api/en/helpers/GridHelper",
				"PolarGridHelper": "api/en/helpers/PolarGridHelper",
				"PositionalAudioHelper": "api/en/helpers/PositionalAudioHelper",
				"HemisphereLightHelper": "api/en/helpers/HemisphereLightHelper",
				"PlaneHelper": "api/en/helpers/PlaneHelper",
				"PointLightHelper": "api/en/helpers/PointLightHelper",
				"RectAreaLightHelper": "api/en/helpers/RectAreaLightHelper",
				"SkeletonHelper": "api/en/helpers/SkeletonHelper",
				"SpotLightHelper": "api/en/helpers/SpotLightHelper",
				"VertexNormalsHelper": "api/en/helpers/VertexNormalsHelper"
			},

			"Lights": {
				"AmbientLight": "api/en/lights/AmbientLight",
				"DirectionalLight": "api/en/lights/DirectionalLight",
				"HemisphereLight": "api/en/lights/HemisphereLight",
				"Light": "api/en/lights/Light",
				"PointLight": "api/en/lights/PointLight",
				"RectAreaLight": "api/en/lights/RectAreaLight",
				"SpotLight": "api/en/lights/SpotLight"
			},

			"Lights / Shadows": {
				"LightShadow": "api/en/lights/shadows/LightShadow",
				"PointLightShadow": "api/en/lights/shadows/PointLightShadow",
				"DirectionalLightShadow": "api/en/lights/shadows/DirectionalLightShadow",
				"SpotLightShadow": "api/en/lights/shadows/SpotLightShadow"
			},

			"Loaders": {
				"AnimationLoader": "api/en/loaders/AnimationLoader",
				"AudioLoader": "api/en/loaders/AudioLoader",
				"BufferGeometryLoader": "api/en/loaders/BufferGeometryLoader",
				"Cache": "api/en/loaders/Cache",
				"CompressedTextureLoader": "api/en/loaders/CompressedTextureLoader",
				"CubeTextureLoader": "api/en/loaders/CubeTextureLoader",
				"DataTextureLoader": "api/en/loaders/DataTextureLoader",
				"FileLoader": "api/en/loaders/FileLoader",
				"FontLoader": "api/en/loaders/FontLoader",
				"ImageBitmapLoader": "api/en/loaders/ImageBitmapLoader",
				"ImageLoader": "api/en/loaders/ImageLoader",
				"Loader": "api/en/loaders/Loader",
				"LoaderUtils": "api/en/loaders/LoaderUtils",
				"MaterialLoader": "api/en/loaders/MaterialLoader",
				"ObjectLoader": "api/en/loaders/ObjectLoader",
				"TextureLoader": "api/en/loaders/TextureLoader"
			},

			"Loaders / Managers": {
				"DefaultLoadingManager": "api/en/loaders/managers/DefaultLoadingManager",
				"LoadingManager": "api/en/loaders/managers/LoadingManager"
			},

			"Materials": {
				"LineBasicMaterial": "api/en/materials/LineBasicMaterial",
				"LineDashedMaterial": "api/en/materials/LineDashedMaterial",
				"Material": "api/en/materials/Material",
				"MeshBasicMaterial": "api/en/materials/MeshBasicMaterial",
				"MeshDepthMaterial": "api/en/materials/MeshDepthMaterial",
				"MeshDistanceMaterial": "api/en/materials/MeshDistanceMaterial",
				"MeshLambertMaterial": "api/en/materials/MeshLambertMaterial",
				"MeshMatcapMaterial": "api/en/materials/MeshMatcapMaterial",
				"MeshNormalMaterial": "api/en/materials/MeshNormalMaterial",
				"MeshPhongMaterial": "api/en/materials/MeshPhongMaterial",
				"MeshPhysicalMaterial": "api/en/materials/MeshPhysicalMaterial",
				"MeshStandardMaterial": "api/en/materials/MeshStandardMaterial",
				"MeshToonMaterial": "api/en/materials/MeshToonMaterial",
				"PointsMaterial": "api/en/materials/PointsMaterial",
				"RawShaderMaterial": "api/en/materials/RawShaderMaterial",
				"ShaderMaterial": "api/en/materials/ShaderMaterial",
				"ShadowMaterial": "api/en/materials/ShadowMaterial",
				"SpriteMaterial": "api/en/materials/SpriteMaterial"
			},

			"Math": {
				"Box2": "api/en/math/Box2",
				"Box3": "api/en/math/Box3",
				"Color": "api/en/math/Color",
				"Cylindrical": "api/en/math/Cylindrical",
				"Euler": "api/en/math/Euler",
				"Frustum": "api/en/math/Frustum",
				"Interpolant": "api/en/math/Interpolant",
				"Line3": "api/en/math/Line3",
				"Math": "api/en/math/Math",
				"Matrix3": "api/en/math/Matrix3",
				"Matrix4": "api/en/math/Matrix4",
				"Plane": "api/en/math/Plane",
				"Quaternion": "api/en/math/Quaternion",
				"Ray": "api/en/math/Ray",
				"Sphere": "api/en/math/Sphere",
				"Spherical": "api/en/math/Spherical",
				"Triangle": "api/en/math/Triangle",
				"Vector2": "api/en/math/Vector2",
				"Vector3": "api/en/math/Vector3",
				"Vector4": "api/en/math/Vector4"
			},

			"Math / Interpolants": {
				"CubicInterpolant": "api/en/math/interpolants/CubicInterpolant",
				"DiscreteInterpolant": "api/en/math/interpolants/DiscreteInterpolant",
				"LinearInterpolant": "api/en/math/interpolants/LinearInterpolant",
				"QuaternionLinearInterpolant": "api/en/math/interpolants/QuaternionLinearInterpolant"
			},

			"Objects": {
				"Bone": "api/en/objects/Bone",
				"Group": "api/en/objects/Group",
				"InstancedMesh": "api/en/objects/InstancedMesh",
				"Line": "api/en/objects/Line",
				"LineLoop": "api/en/objects/LineLoop",
				"LineSegments": "api/en/objects/LineSegments",
				"LOD": "api/en/objects/LOD",
				"Mesh": "api/en/objects/Mesh",
				"Points": "api/en/objects/Points",
				"Skeleton": "api/en/objects/Skeleton",
				"SkinnedMesh": "api/en/objects/SkinnedMesh",
				"Sprite": "api/en/objects/Sprite"
			},

			"Renderers": {
				"WebGLMultisampleRenderTarget": "api/en/renderers/WebGLMultisampleRenderTarget",
				"WebGLRenderer": "api/en/renderers/WebGLRenderer",
				"WebGLRenderTarget": "api/en/renderers/WebGLRenderTarget",
				"WebGLRenderTargetCube": "api/en/renderers/WebGLRenderTargetCube"
			},

			"Renderers / Shaders": {
				"ShaderChunk": "api/en/renderers/shaders/ShaderChunk",
				"ShaderLib": "api/en/renderers/shaders/ShaderLib",
				"UniformsLib": "api/en/renderers/shaders/UniformsLib",
				"UniformsUtils": "api/en/renderers/shaders/UniformsUtils"
			},

			"Scenes": {
				"Fog": "api/en/scenes/Fog",
				"FogExp2": "api/en/scenes/FogExp2",
				"Scene": "api/en/scenes/Scene"
			},

			"Textures": {
				"CanvasTexture": "api/en/textures/CanvasTexture",
				"CompressedTexture": "api/en/textures/CompressedTexture",
				"CubeTexture": "api/en/textures/CubeTexture",
				"DataTexture": "api/en/textures/DataTexture",
				"DataTexture3D": "api/en/textures/DataTexture3D",
				"DepthTexture": "api/en/textures/DepthTexture",
				"Texture": "api/en/textures/Texture",
				"VideoTexture": "api/en/textures/VideoTexture"
			}

		},

		"Examples": {

			"Animations": {
				"CCDIKSolver": "examples/en/animations/CCDIKSolver",
				"MMDAnimationHelper": "examples/en/animations/MMDAnimationHelper",
				"MMDPhysics": "examples/en/animations/MMDPhysics"
			},

			"Controls": {
				"DeviceOrientationControls": "examples/en/controls/DeviceOrientationControls",
				"DragControls": "examples/en/controls/DragControls",
				"FirstPersonControls": "examples/en/controls/FirstPersonControls",
				"FlyControls": "examples/en/controls/FlyControls",
				"OrbitControls": "examples/en/controls/OrbitControls",
				"PointerLockControls": "examples/en/controls/PointerLockControls",
				"TrackballControls": "examples/en/controls/TrackballControls",
				"TransformControls": "examples/en/controls/TransformControls"
			},

			"Geometries": {
				"ConvexBufferGeometry": "examples/en/geometries/ConvexBufferGeometry",
				"ConvexGeometry": "examples/en/geometries/ConvexGeometry",
				"DecalGeometry": "examples/en/geometries/DecalGeometry"
			},

			"Loaders": {
				"BasisTextureLoader": "examples/en/loaders/BasisTextureLoader",
				"DRACOLoader": "examples/en/loaders/DRACOLoader",
				"GLTFLoader": "examples/en/loaders/GLTFLoader",
				"MMDLoader": "examples/en/loaders/MMDLoader",
				"MTLLoader": "examples/en/loaders/MTLLoader",
				"OBJLoader": "examples/en/loaders/OBJLoader",
				"OBJLoader2": "examples/en/loaders/OBJLoader2",
				"OBJLoader2Parallel": "examples/en/loaders/OBJLoader2Parallel",
				"PCDLoader": "examples/en/loaders/PCDLoader",
				"PDBLoader": "examples/en/loaders/PDBLoader",
				"PRWMLoader": "examples/en/loaders/PRWMLoader",
				"SVGLoader": "examples/en/loaders/SVGLoader",
				"TGALoader": "examples/en/loaders/TGALoader"
			},

			"Objects": {
				"Lensflare": "examples/en/objects/Lensflare",
			},

			"Post-Processing": {
				"EffectComposer": "examples/en/postprocessing/EffectComposer"
			},

			"Exporters": {
				"GLTFExporter": "examples/en/exporters/GLTFExporter",
				"PLYExporter": "examples/en/exporters/PLYExporter",
				"ColladaExporter": "examples/en/exporters/ColladaExporter"
			},

			"Plugins": {
				"LookupTable": "examples/en/Lut",
			},

			"ConvexHull": {
				"Face": "examples/en/math/convexhull/Face",
				"HalfEdge": "examples/en/math/convexhull/HalfEdge",
				"ConvexHull": "examples/en/math/convexhull/ConvexHull",
				"VertexNode": "examples/en/math/convexhull/VertexNode",
				"VertexList": "examples/en/math/convexhull/VertexList"
			},

			"Renderers": {
				"CSS2DRenderer": "examples/en/renderers/CSS2DRenderer",
				"CSS3DRenderer": "examples/en/renderers/CSS3DRenderer",
				"SVGRenderer": "examples/en/renderers/SVGRenderer"

			},

			"Utils": {
				"BufferGeometryUtils": "examples/en/utils/BufferGeometryUtils",
				"SceneUtils": "examples/en/utils/SceneUtils",
				"SkeletonUtils": "examples/en/utils/SkeletonUtils"
			}

		},

		"Developer Reference": {

			"Polyfills": {
				"Polyfills": "api/en/Polyfills"
			},

			"WebGLRenderer": {
				"WebGLProgram": "api/en/renderers/webgl/WebGLProgram",
				"WebGLShader": "api/en/renderers/webgl/WebGLShader",
				"WebGLState": "api/en/renderers/webgl/WebGLState"
			}

		}

	},

	"zh": {

		"手册": {

			"起步": {
				"创建一个场景": "manual/zh/introduction/Creating-a-scene",
				"通过模块来引入": "manual/zh/introduction/Import-via-modules",
				"浏览器支持": "manual/zh/introduction/Browser-support",
				"WebGL兼容性检查": "manual/zh/introduction/WebGL-compatibility-check",
				"如何在本地运行Three.js": "manual/zh/introduction/How-to-run-things-locally",
				"如何使用WebGL 2": "manual/zh/introduction/How-to-use-WebGL2",
				"画线": "manual/zh/introduction/Drawing-lines",
				"创建文字": "manual/zh/introduction/Creating-text",
				"载入3D模型": "manual/zh/introduction/Loading-3D-models",
				"常见问题": "manual/zh/introduction/FAQ",
				"一些有用的链接": "manual/zh/introduction/Useful-links"
			},

			"进阶": {
				"如何更新场景": "manual/zh/introduction/How-to-update-things",
				"如何废置对象": "manual/zh/introduction/How-to-dispose-of-objects",
				"如何创建VR内容": "manual/zh/introduction/How-to-create-VR-content",
				"如何使用后期处理": "manual/zh/introduction/How-to-use-post-processing",
				"矩阵变换": "manual/zh/introduction/Matrix-transformations",
				"动画系统": "manual/zh/introduction/Animation-system"
			},

			"构建工具": {
				"使用NPM进行测试": "manual/zh/buildTools/Testing-with-NPM"
			}

		},

		"参考": {

			"动画": {
				"AnimationAction": "api/zh/animation/AnimationAction",
				"AnimationClip": "api/zh/animation/AnimationClip",
				"AnimationMixer": "api/zh/animation/AnimationMixer",
				"AnimationObjectGroup": "api/zh/animation/AnimationObjectGroup",
				"AnimationUtils": "api/zh/animation/AnimationUtils",
				"KeyframeTrack": "api/zh/animation/KeyframeTrack",
				"PropertyBinding": "api/zh/animation/PropertyBinding",
				"PropertyMixer": "api/zh/animation/PropertyMixer"
			},

			"动画 / 轨道": {
				"BooleanKeyframeTrack": "api/zh/animation/tracks/BooleanKeyframeTrack",
				"ColorKeyframeTrack": "api/zh/animation/tracks/ColorKeyframeTrack",
				"NumberKeyframeTrack": "api/zh/animation/tracks/NumberKeyframeTrack",
				"QuaternionKeyframeTrack": "api/zh/animation/tracks/QuaternionKeyframeTrack",
				"StringKeyframeTrack": "api/zh/animation/tracks/StringKeyframeTrack",
				"VectorKeyframeTrack": "api/zh/animation/tracks/VectorKeyframeTrack"
			},

			"音频": {
				"Audio": "api/zh/audio/Audio",
				"AudioAnalyser": "api/zh/audio/AudioAnalyser",
				"AudioContext": "api/zh/audio/AudioContext",
				"AudioListener": "api/zh/audio/AudioListener",
				"PositionalAudio": "api/zh/audio/PositionalAudio"
			},

			"摄像机": {
				"ArrayCamera": "api/zh/cameras/ArrayCamera",
				"Camera": "api/zh/cameras/Camera",
				"CubeCamera": "api/zh/cameras/CubeCamera",
				"OrthographicCamera": "api/zh/cameras/OrthographicCamera",
				"PerspectiveCamera": "api/zh/cameras/PerspectiveCamera",
				"StereoCamera": "api/zh/cameras/StereoCamera"
			},

			"常量": {
				"Animation": "api/zh/constants/Animation",
				"Core": "api/zh/constants/Core",
				"CustomBlendingEquation": "api/zh/constants/CustomBlendingEquations",
				"DrawModes": "api/zh/constants/DrawModes",
				"Materials": "api/zh/constants/Materials",
				"Renderer": "api/zh/constants/Renderer",
				"Textures": "api/zh/constants/Textures"
			},

			"核心": {
				"BufferAttribute": "api/zh/core/BufferAttribute",
				"BufferGeometry": "api/zh/core/BufferGeometry",
				"Clock": "api/zh/core/Clock",
				"DirectGeometry": "api/zh/core/DirectGeometry",
				"EventDispatcher": "api/zh/core/EventDispatcher",
				"Face3": "api/zh/core/Face3",
				"Geometry": "api/zh/core/Geometry",
				"InstancedBufferAttribute": "api/zh/core/InstancedBufferAttribute",
				"InstancedBufferGeometry": "api/zh/core/InstancedBufferGeometry",
				"InstancedInterleavedBuffer": "api/zh/core/InstancedInterleavedBuffer",
				"InterleavedBuffer": "api/zh/core/InterleavedBuffer",
				"InterleavedBufferAttribute": "api/zh/core/InterleavedBufferAttribute",
				"Layers": "api/zh/core/Layers",
				"Object3D": "api/zh/core/Object3D",
				"Raycaster": "api/zh/core/Raycaster",
				"Uniform": "api/zh/core/Uniform"
			},

			"核心 / BufferAttributes": {
				"BufferAttribute Types": "api/zh/core/bufferAttributeTypes/BufferAttributeTypes"
			},

			"弃用列表": {
				"DeprecatedList": "api/zh/deprecated/DeprecatedList"
			},

			"附件": {
				"Earcut": "api/zh/extras/Earcut",
				"ShapeUtils": "api/zh/extras/ShapeUtils"
			},

			"附件 / 核心": {
				"Curve": "api/zh/extras/core/Curve",
				"CurvePath": "api/zh/extras/core/CurvePath",
				"Font": "api/zh/extras/core/Font",
				"Interpolations": "api/zh/extras/core/Interpolations",
				"Path": "api/zh/extras/core/Path",
				"Shape": "api/zh/extras/core/Shape",
				"ShapePath": "api/zh/extras/core/ShapePath"
			},

			"附件 / 曲线": {
				"ArcCurve": "api/zh/extras/curves/ArcCurve",
				"CatmullRomCurve3": "api/zh/extras/curves/CatmullRomCurve3",
				"CubicBezierCurve": "api/zh/extras/curves/CubicBezierCurve",
				"CubicBezierCurve3": "api/zh/extras/curves/CubicBezierCurve3",
				"EllipseCurve": "api/zh/extras/curves/EllipseCurve",
				"LineCurve": "api/zh/extras/curves/LineCurve",
				"LineCurve3": "api/zh/extras/curves/LineCurve3",
				"QuadraticBezierCurve": "api/zh/extras/curves/QuadraticBezierCurve",
				"QuadraticBezierCurve3": "api/zh/extras/curves/QuadraticBezierCurve3",
				"SplineCurve": "api/zh/extras/curves/SplineCurve"
			},

			"附件 / 物体": {
				"ImmediateRenderObject": "api/zh/extras/objects/ImmediateRenderObject",
			},

			"几何体": {
				"BoxBufferGeometry": "api/zh/geometries/BoxBufferGeometry",
				"BoxGeometry": "api/zh/geometries/BoxGeometry",
				"CircleBufferGeometry": "api/zh/geometries/CircleBufferGeometry",
				"CircleGeometry": "api/zh/geometries/CircleGeometry",
				"ConeBufferGeometry": "api/zh/geometries/ConeBufferGeometry",
				"ConeGeometry": "api/zh/geometries/ConeGeometry",
				"CylinderBufferGeometry": "api/zh/geometries/CylinderBufferGeometry",
				"CylinderGeometry": "api/zh/geometries/CylinderGeometry",
				"DodecahedronBufferGeometry": "api/zh/geometries/DodecahedronBufferGeometry",
				"DodecahedronGeometry": "api/zh/geometries/DodecahedronGeometry",
				"EdgesGeometry": "api/zh/geometries/EdgesGeometry",
				"ExtrudeBufferGeometry": "api/zh/geometries/ExtrudeBufferGeometry",
				"ExtrudeGeometry": "api/zh/geometries/ExtrudeGeometry",
				"IcosahedronBufferGeometry": "api/zh/geometries/IcosahedronBufferGeometry",
				"IcosahedronGeometry": "api/zh/geometries/IcosahedronGeometry",
				"LatheBufferGeometry": "api/zh/geometries/LatheBufferGeometry",
				"LatheGeometry": "api/zh/geometries/LatheGeometry",
				"OctahedronBufferGeometry": "api/zh/geometries/OctahedronBufferGeometry",
				"OctahedronGeometry": "api/zh/geometries/OctahedronGeometry",
				"ParametricBufferGeometry": "api/zh/geometries/ParametricBufferGeometry",
				"ParametricGeometry": "api/zh/geometries/ParametricGeometry",
				"PlaneBufferGeometry": "api/zh/geometries/PlaneBufferGeometry",
				"PlaneGeometry": "api/zh/geometries/PlaneGeometry",
				"PolyhedronBufferGeometry": "api/zh/geometries/PolyhedronBufferGeometry",
				"PolyhedronGeometry": "api/zh/geometries/PolyhedronGeometry",
				"RingBufferGeometry": "api/zh/geometries/RingBufferGeometry",
				"RingGeometry": "api/zh/geometries/RingGeometry",
				"ShapeBufferGeometry": "api/zh/geometries/ShapeBufferGeometry",
				"ShapeGeometry": "api/zh/geometries/ShapeGeometry",
				"SphereBufferGeometry": "api/zh/geometries/SphereBufferGeometry",
				"SphereGeometry": "api/zh/geometries/SphereGeometry",
				"TetrahedronBufferGeometry": "api/zh/geometries/TetrahedronBufferGeometry",
				"TetrahedronGeometry": "api/zh/geometries/TetrahedronGeometry",
				"TextBufferGeometry": "api/zh/geometries/TextBufferGeometry",
				"TextGeometry": "api/zh/geometries/TextGeometry",
				"TorusBufferGeometry": "api/zh/geometries/TorusBufferGeometry",
				"TorusGeometry": "api/zh/geometries/TorusGeometry",
				"TorusKnotBufferGeometry": "api/zh/geometries/TorusKnotBufferGeometry",
				"TorusKnotGeometry": "api/zh/geometries/TorusKnotGeometry",
				"TubeBufferGeometry": "api/zh/geometries/TubeBufferGeometry",
				"TubeGeometry": "api/zh/geometries/TubeGeometry",
				"WireframeGeometry": "api/zh/geometries/WireframeGeometry"
			},

			"辅助对象": {
				"ArrowHelper": "api/zh/helpers/ArrowHelper",
				"AxesHelper": "api/zh/helpers/AxesHelper",
				"BoxHelper": "api/zh/helpers/BoxHelper",
				"Box3Helper": "api/zh/helpers/Box3Helper",
				"CameraHelper": "api/zh/helpers/CameraHelper",
				"DirectionalLightHelper": "api/zh/helpers/DirectionalLightHelper",
				"FaceNormalsHelper": "api/zh/helpers/FaceNormalsHelper",
				"GridHelper": "api/zh/helpers/GridHelper",
				"PolarGridHelper": "api/zh/helpers/PolarGridHelper",
				"PositionalAudioHelper": "api/zh/helpers/PositionalAudioHelper",
				"HemisphereLightHelper": "api/zh/helpers/HemisphereLightHelper",
				"PlaneHelper": "api/zh/helpers/PlaneHelper",
				"PointLightHelper": "api/zh/helpers/PointLightHelper",
				"RectAreaLightHelper": "api/zh/helpers/RectAreaLightHelper",
				"SkeletonHelper": "api/zh/helpers/SkeletonHelper",
				"SpotLightHelper": "api/zh/helpers/SpotLightHelper",
				"VertexNormalsHelper": "api/zh/helpers/VertexNormalsHelper"
			},

			"灯光": {
				"AmbientLight": "api/zh/lights/AmbientLight",
				"DirectionalLight": "api/zh/lights/DirectionalLight",
				"HemisphereLight": "api/zh/lights/HemisphereLight",
				"Light": "api/zh/lights/Light",
				"PointLight": "api/zh/lights/PointLight",
				"RectAreaLight": "api/zh/lights/RectAreaLight",
				"SpotLight": "api/zh/lights/SpotLight"
			},

			"灯光 / 阴影": {
				"LightShadow": "api/zh/lights/shadows/LightShadow",
				"PointLightShadow": "api/zh/lights/shadows/PointLightShadow",
				"DirectionalLightShadow": "api/zh/lights/shadows/DirectionalLightShadow",
				"SpotLightShadow": "api/zh/lights/shadows/SpotLightShadow"
			},

			"加载器": {
				"AnimationLoader": "api/zh/loaders/AnimationLoader",
				"AudioLoader": "api/zh/loaders/AudioLoader",
				"BufferGeometryLoader": "api/zh/loaders/BufferGeometryLoader",
				"Cache": "api/zh/loaders/Cache",
				"CompressedTextureLoader": "api/zh/loaders/CompressedTextureLoader",
				"CubeTextureLoader": "api/zh/loaders/CubeTextureLoader",
				"DataTextureLoader": "api/zh/loaders/DataTextureLoader",
				"FileLoader": "api/zh/loaders/FileLoader",
				"FontLoader": "api/zh/loaders/FontLoader",
				"ImageBitmapLoader": "api/zh/loaders/ImageBitmapLoader",
				"ImageLoader": "api/zh/loaders/ImageLoader",
				"Loader": "api/zh/loaders/Loader",
				"LoaderUtils": "api/zh/loaders/LoaderUtils",
				"MaterialLoader": "api/zh/loaders/MaterialLoader",
				"ObjectLoader": "api/zh/loaders/ObjectLoader",
				"TextureLoader": "api/zh/loaders/TextureLoader"
			},

			"加载器 / 管理器": {
				"DefaultLoadingManager": "api/zh/loaders/managers/DefaultLoadingManager",
				"LoadingManager": "api/zh/loaders/managers/LoadingManager"
			},

			"材质": {
				"LineBasicMaterial": "api/zh/materials/LineBasicMaterial",
				"LineDashedMaterial": "api/zh/materials/LineDashedMaterial",
				"Material": "api/zh/materials/Material",
				"MeshBasicMaterial": "api/zh/materials/MeshBasicMaterial",
				"MeshDepthMaterial": "api/zh/materials/MeshDepthMaterial",
				"MeshDistanceMaterial": "api/zh/materials/MeshDistanceMaterial",
				"MeshLambertMaterial": "api/zh/materials/MeshLambertMaterial",
				"MeshMatcapMaterial": "api/zh/materials/MeshMatcapMaterial",
				"MeshNormalMaterial": "api/zh/materials/MeshNormalMaterial",
				"MeshPhongMaterial": "api/zh/materials/MeshPhongMaterial",
				"MeshPhysicalMaterial": "api/zh/materials/MeshPhysicalMaterial",
				"MeshStandardMaterial": "api/zh/materials/MeshStandardMaterial",
				"MeshToonMaterial": "api/zh/materials/MeshToonMaterial",
				"PointsMaterial": "api/zh/materials/PointsMaterial",
				"RawShaderMaterial": "api/zh/materials/RawShaderMaterial",
				"ShaderMaterial": "api/zh/materials/ShaderMaterial",
				"ShadowMaterial": "api/zh/materials/ShadowMaterial",
				"SpriteMaterial": "api/zh/materials/SpriteMaterial"
			},

			"数学库": {
				"Box2": "api/zh/math/Box2",
				"Box3": "api/zh/math/Box3",
				"Color": "api/zh/math/Color",
				"Cylindrical": "api/zh/math/Cylindrical",
				"Euler": "api/zh/math/Euler",
				"Frustum": "api/zh/math/Frustum",
				"Interpolant": "api/zh/math/Interpolant",
				"Line3": "api/zh/math/Line3",
				"Math": "api/zh/math/Math",
				"Matrix3": "api/zh/math/Matrix3",
				"Matrix4": "api/zh/math/Matrix4",
				"Plane": "api/zh/math/Plane",
				"Quaternion": "api/zh/math/Quaternion",
				"Ray": "api/zh/math/Ray",
				"Sphere": "api/zh/math/Sphere",
				"Spherical": "api/zh/math/Spherical",
				"Triangle": "api/zh/math/Triangle",
				"Vector2": "api/zh/math/Vector2",
				"Vector3": "api/zh/math/Vector3",
				"Vector4": "api/zh/math/Vector4"
			},

			"数学库 / 插值": {
				"CubicInterpolant": "api/zh/math/interpolants/CubicInterpolant",
				"DiscreteInterpolant": "api/zh/math/interpolants/DiscreteInterpolant",
				"LinearInterpolant": "api/zh/math/interpolants/LinearInterpolant",
				"QuaternionLinearInterpolant": "api/zh/math/interpolants/QuaternionLinearInterpolant"
			},

			"物体": {
				"Bone": "api/zh/objects/Bone",
				"Group": "api/zh/objects/Group",
				"InstancedMesh": "api/zh/objects/InstancedMesh",
				"Line": "api/zh/objects/Line",
				"LineLoop": "api/zh/objects/LineLoop",
				"LineSegments": "api/zh/objects/LineSegments",
				"LOD": "api/zh/objects/LOD",
				"Mesh": "api/zh/objects/Mesh",
				"Points": "api/zh/objects/Points",
				"Skeleton": "api/zh/objects/Skeleton",
				"SkinnedMesh": "api/zh/objects/SkinnedMesh",
				"Sprite": "api/zh/objects/Sprite"
			},

			"渲染器": {
				"WebGLMultisampleRenderTarget": "api/zh/renderers/WebGLMultisampleRenderTarget",
				"WebGLRenderer": "api/zh/renderers/WebGLRenderer",
				"WebGLRenderTarget": "api/zh/renderers/WebGLRenderTarget",
				"WebGLRenderTargetCube": "api/zh/renderers/WebGLRenderTargetCube"
			},

			"渲染器 / 着色器": {
				"ShaderChunk": "api/zh/renderers/shaders/ShaderChunk",
				"ShaderLib": "api/zh/renderers/shaders/ShaderLib",
				"UniformsLib": "api/zh/renderers/shaders/UniformsLib",
				"UniformsUtils": "api/zh/renderers/shaders/UniformsUtils"
			},

			"场景": {
				"Fog": "api/zh/scenes/Fog",
				"FogExp2": "api/zh/scenes/FogExp2",
				"Scene": "api/zh/scenes/Scene"
			},

			"纹理贴图": {
				"CanvasTexture": "api/zh/textures/CanvasTexture",
				"CompressedTexture": "api/zh/textures/CompressedTexture",
				"CubeTexture": "api/zh/textures/CubeTexture",
				"DataTexture": "api/zh/textures/DataTexture",
				"DataTexture3D": "api/zh/textures/DataTexture3D",
				"DepthTexture": "api/zh/textures/DepthTexture",
				"Texture": "api/zh/textures/Texture",
				"VideoTexture": "api/zh/textures/VideoTexture"
			}

		},

		"示例": {

			"动画": {
				"CCDIKSolver": "examples/zh/animations/CCDIKSolver",
				"MMDAnimationHelper": "examples/zh/animations/MMDAnimationHelper",
				"MMDPhysics": "examples/zh/animations/MMDPhysics"
			},

			"控制": {
				"DeviceOrientationControls": "examples/zh/controls/DeviceOrientationControls",
				"DragControls": "examples/zh/controls/DragControls",
				"FirstPersonControls": "examples/zh/controls/FirstPersonControls",
				"FlyControls": "examples/zh/controls/FlyControls",
				"OrbitControls": "examples/zh/controls/OrbitControls",
				"PointerLockControls": "examples/zh/controls/PointerLockControls",
				"TrackballControls": "examples/zh/controls/TrackballControls",
				"TransformControls": "examples/zh/controls/TransformControls"
			},

			"几何体": {
				"ConvexBufferGeometry": "examples/zh/geometries/ConvexBufferGeometry",
				"ConvexGeometry": "examples/zh/geometries/ConvexGeometry",
				"DecalGeometry": "examples/zh/geometries/DecalGeometry"
			},

			"加载器": {
				"BasisTextureLoader": "examples/zh/loaders/BasisTextureLoader",
				"DRACOLoader": "examples/zh/loaders/DRACOLoader",
				"GLTFLoader": "examples/zh/loaders/GLTFLoader",
				"MMDLoader": "examples/zh/loaders/MMDLoader",
				"MTLLoader": "examples/zh/loaders/MTLLoader",
				"OBJLoader": "examples/zh/loaders/OBJLoader",
				"OBJLoader2": "examples/zh/loaders/OBJLoader2",
				"PCDLoader": "examples/zh/loaders/PCDLoader",
				"PDBLoader": "examples/zh/loaders/PDBLoader",
				"PRWMLoader": "examples/zh/loaders/PRWMLoader",
				"SVGLoader": "examples/zh/loaders/SVGLoader",
				"TGALoader": "examples/zh/loaders/TGALoader"
			},

			"物体": {
				"Lensflare": "examples/zh/objects/Lensflare",
			},

			"后期处理": {
				"EffectComposer": "examples/zh/postprocessing/EffectComposer"
			},

			"导出器": {
				"GLTFExporter": "examples/zh/exporters/GLTFExporter",
				"PLYExporter": "examples/zh/exporters/PLYExporter",
				"ColladaExporter": "examples/zh/exporters/ColladaExporter"
			},

			"插件": {
				"LookupTable": "examples/zh/Lut",
			},

			"QuickHull": {
				"Face": "examples/zh/math/convexhull/Face",
				"HalfEdge": "examples/zh/math/convexhull/HalfEdge",
				"ConvexHull": "examples/zh/math/convexhull/ConvexHull",
				"VertexNode": "examples/zh/math/convexhull/VertexNode",
				"VertexList": "examples/zh/math/convexhull/VertexList"
			},

			"渲染器": {
				"CSS2DRenderer": "examples/zh/renderers/CSS2DRenderer",
				"CSS3DRenderer": "examples/zh/renderers/CSS3DRenderer",
				"SVGRenderer": "examples/zh/renderers/SVGRenderer"
			},

			"实用工具": {
				"BufferGeometryUtils": "examples/zh/utils/BufferGeometryUtils",
				"SceneUtils": "examples/zh/utils/SceneUtils",
				"SkeletonUtils": "examples/zh/utils/SkeletonUtils"
			}

		},

		"开发者参考": {

			"差异化支持": {
				"Polyfills": "api/zh/Polyfills"
			},

			"WebGL渲染器": {
				"WebGLProgram": "api/zh/renderers/webgl/WebGLProgram",
				"WebGLShader": "api/zh/renderers/webgl/WebGLShader",
				"WebGLState": "api/zh/renderers/webgl/WebGLState"
			}

		}

	}

};
