---------------------------------------------------------------------------------------
-- Title          : Wishbone slave core for WR Core System Controller
---------------------------------------------------------------------------------------
-- File           : wrc_syscon_wb.vhd
-- Author         : auto-generated by wbgen2 from wrc_syscon_wb.wb
-- Created        : Mon Nov 27 13:37:56 2017
-- Standard       : VHDL'87
---------------------------------------------------------------------------------------
-- THIS FILE WAS GENERATED BY wbgen2 FROM SOURCE FILE wrc_syscon_wb.wb
-- DO NOT HAND-EDIT UNLESS IT'S ABSOLUTELY NECESSARY!
---------------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

use work.sysc_wbgen2_pkg.all;


entity wrc_syscon_wb is
  port (
    rst_n_i                                  : in     std_logic;
    clk_sys_i                                : in     std_logic;
    wb_adr_i                                 : in     std_logic_vector(4 downto 0);
    wb_dat_i                                 : in     std_logic_vector(31 downto 0);
    wb_dat_o                                 : out    std_logic_vector(31 downto 0);
    wb_cyc_i                                 : in     std_logic;
    wb_sel_i                                 : in     std_logic_vector(3 downto 0);
    wb_stb_i                                 : in     std_logic;
    wb_we_i                                  : in     std_logic;
    wb_ack_o                                 : out    std_logic;
    wb_stall_o                               : out    std_logic;
    regs_i                                   : in     t_sysc_in_registers;
    regs_o                                   : out    t_sysc_out_registers
  );
end wrc_syscon_wb;

architecture syn of wrc_syscon_wb is

signal sysc_rstr_rst_int                        : std_logic      ;
signal sysc_gpsr_led_stat_dly0                  : std_logic      ;
signal sysc_gpsr_led_stat_int                   : std_logic      ;
signal sysc_gpsr_led_link_dly0                  : std_logic      ;
signal sysc_gpsr_led_link_int                   : std_logic      ;
signal sysc_gpsr_net_rst_dly0                   : std_logic      ;
signal sysc_gpsr_net_rst_int                    : std_logic      ;
signal sysc_gpcr_led_stat_dly0                  : std_logic      ;
signal sysc_gpcr_led_stat_int                   : std_logic      ;
signal sysc_gpcr_led_link_dly0                  : std_logic      ;
signal sysc_gpcr_led_link_int                   : std_logic      ;
signal sysc_gpcr_fmc_scl_dly0                   : std_logic      ;
signal sysc_gpcr_fmc_scl_int                    : std_logic      ;
signal sysc_gpcr_fmc_sda_dly0                   : std_logic      ;
signal sysc_gpcr_fmc_sda_int                    : std_logic      ;
signal sysc_gpcr_sfp_scl_dly0                   : std_logic      ;
signal sysc_gpcr_sfp_scl_int                    : std_logic      ;
signal sysc_gpcr_sfp_sda_dly0                   : std_logic      ;
signal sysc_gpcr_sfp_sda_int                    : std_logic      ;
signal sysc_gpcr_spi_sclk_dly0                  : std_logic      ;
signal sysc_gpcr_spi_sclk_int                   : std_logic      ;
signal sysc_gpcr_spi_cs_dly0                    : std_logic      ;
signal sysc_gpcr_spi_cs_int                     : std_logic      ;
signal sysc_gpcr_spi_mosi_dly0                  : std_logic      ;
signal sysc_gpcr_spi_mosi_int                   : std_logic      ;
signal sysc_tcr_enable_int                      : std_logic      ;
signal sysc_diag_cr_rw_int                      : std_logic      ;
signal sysc_wdiag_ctrl_data_valid_int           : std_logic      ;
signal sysc_wdiag_sstat_wr_mode_int             : std_logic      ;
signal sysc_wdiag_sstat_servostate_int          : std_logic_vector(3 downto 0);
signal sysc_wdiag_pstat_link_int                : std_logic      ;
signal sysc_wdiag_pstat_locked_int              : std_logic      ;
signal sysc_wdiag_ptpstat_ptpstate_int          : std_logic_vector(7 downto 0);
signal sysc_wdiag_astat_aux_int                 : std_logic_vector(7 downto 0);
signal sysc_wdiag_txfcnt_int                    : std_logic_vector(31 downto 0);
signal sysc_wdiag_rxfcnt_int                    : std_logic_vector(31 downto 0);
signal sysc_wdiag_sec_msb_int                   : std_logic_vector(31 downto 0);
signal sysc_wdiag_sec_lsb_int                   : std_logic_vector(31 downto 0);
signal sysc_wdiag_ns_int                        : std_logic_vector(31 downto 0);
signal sysc_wdiag_mu_msb_int                    : std_logic_vector(31 downto 0);
signal sysc_wdiag_mu_lsb_int                    : std_logic_vector(31 downto 0);
signal sysc_wdiag_dms_msb_int                   : std_logic_vector(31 downto 0);
signal sysc_wdiag_dms_lsb_int                   : std_logic_vector(31 downto 0);
signal sysc_wdiag_asym_int                      : std_logic_vector(31 downto 0);
signal sysc_wdiag_cko_int                       : std_logic_vector(31 downto 0);
signal sysc_wdiag_setp_int                      : std_logic_vector(31 downto 0);
signal sysc_wdiag_ucnt_int                      : std_logic_vector(31 downto 0);
signal sysc_wdiag_temp_int                      : std_logic_vector(31 downto 0);
signal ack_sreg                                 : std_logic_vector(9 downto 0);
signal rddata_reg                               : std_logic_vector(31 downto 0);
signal wrdata_reg                               : std_logic_vector(31 downto 0);
signal rwaddr_reg                               : std_logic_vector(4 downto 0);
signal ack_in_progress                          : std_logic      ;

begin
-- Some internal signals assignments
  wrdata_reg <= wb_dat_i;
-- 
-- Main register bank access process.
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      ack_sreg <= "0000000000";
      ack_in_progress <= '0';
      rddata_reg <= "00000000000000000000000000000000";
      regs_o.rstr_trig_wr_o <= '0';
      sysc_rstr_rst_int <= '0';
      sysc_gpsr_led_stat_int <= '0';
      sysc_gpsr_led_link_int <= '0';
      regs_o.gpsr_fmc_scl_load_o <= '0';
      regs_o.gpsr_fmc_sda_load_o <= '0';
      sysc_gpsr_net_rst_int <= '0';
      regs_o.gpsr_sfp_scl_load_o <= '0';
      regs_o.gpsr_sfp_sda_load_o <= '0';
      regs_o.gpsr_spi_sclk_load_o <= '0';
      regs_o.gpsr_spi_ncs_load_o <= '0';
      regs_o.gpsr_spi_mosi_load_o <= '0';
      sysc_gpcr_led_stat_int <= '0';
      sysc_gpcr_led_link_int <= '0';
      sysc_gpcr_fmc_scl_int <= '0';
      sysc_gpcr_fmc_sda_int <= '0';
      sysc_gpcr_sfp_scl_int <= '0';
      sysc_gpcr_sfp_sda_int <= '0';
      sysc_gpcr_spi_sclk_int <= '0';
      sysc_gpcr_spi_cs_int <= '0';
      sysc_gpcr_spi_mosi_int <= '0';
      sysc_tcr_enable_int <= '0';
      regs_o.diag_cr_adr_load_o <= '0';
      sysc_diag_cr_rw_int <= '0';
      regs_o.diag_dat_load_o <= '0';
      sysc_wdiag_ctrl_data_valid_int <= '0';
      sysc_wdiag_sstat_wr_mode_int <= '0';
      sysc_wdiag_sstat_servostate_int <= "0000";
      sysc_wdiag_pstat_link_int <= '0';
      sysc_wdiag_pstat_locked_int <= '0';
      sysc_wdiag_ptpstat_ptpstate_int <= "00000000";
      sysc_wdiag_astat_aux_int <= "00000000";
      sysc_wdiag_txfcnt_int <= "00000000000000000000000000000000";
      sysc_wdiag_rxfcnt_int <= "00000000000000000000000000000000";
      sysc_wdiag_sec_msb_int <= "00000000000000000000000000000000";
      sysc_wdiag_sec_lsb_int <= "00000000000000000000000000000000";
      sysc_wdiag_ns_int <= "00000000000000000000000000000000";
      sysc_wdiag_mu_msb_int <= "00000000000000000000000000000000";
      sysc_wdiag_mu_lsb_int <= "00000000000000000000000000000000";
      sysc_wdiag_dms_msb_int <= "00000000000000000000000000000000";
      sysc_wdiag_dms_lsb_int <= "00000000000000000000000000000000";
      sysc_wdiag_asym_int <= "00000000000000000000000000000000";
      sysc_wdiag_cko_int <= "00000000000000000000000000000000";
      sysc_wdiag_setp_int <= "00000000000000000000000000000000";
      sysc_wdiag_ucnt_int <= "00000000000000000000000000000000";
      sysc_wdiag_temp_int <= "00000000000000000000000000000000";
    elsif rising_edge(clk_sys_i) then
-- advance the ACK generator shift register
      ack_sreg(8 downto 0) <= ack_sreg(9 downto 1);
      ack_sreg(9) <= '0';
      if (ack_in_progress = '1') then
        if (ack_sreg(0) = '1') then
          regs_o.rstr_trig_wr_o <= '0';
          sysc_gpsr_led_stat_int <= '0';
          sysc_gpsr_led_link_int <= '0';
          regs_o.gpsr_fmc_scl_load_o <= '0';
          regs_o.gpsr_fmc_sda_load_o <= '0';
          sysc_gpsr_net_rst_int <= '0';
          regs_o.gpsr_sfp_scl_load_o <= '0';
          regs_o.gpsr_sfp_sda_load_o <= '0';
          regs_o.gpsr_spi_sclk_load_o <= '0';
          regs_o.gpsr_spi_ncs_load_o <= '0';
          regs_o.gpsr_spi_mosi_load_o <= '0';
          sysc_gpcr_led_stat_int <= '0';
          sysc_gpcr_led_link_int <= '0';
          sysc_gpcr_fmc_scl_int <= '0';
          sysc_gpcr_fmc_sda_int <= '0';
          sysc_gpcr_sfp_scl_int <= '0';
          sysc_gpcr_sfp_sda_int <= '0';
          sysc_gpcr_spi_sclk_int <= '0';
          sysc_gpcr_spi_cs_int <= '0';
          sysc_gpcr_spi_mosi_int <= '0';
          regs_o.diag_cr_adr_load_o <= '0';
          regs_o.diag_dat_load_o <= '0';
          ack_in_progress <= '0';
        else
          regs_o.rstr_trig_wr_o <= '0';
          regs_o.gpsr_fmc_scl_load_o <= '0';
          regs_o.gpsr_fmc_sda_load_o <= '0';
          regs_o.gpsr_sfp_scl_load_o <= '0';
          regs_o.gpsr_sfp_sda_load_o <= '0';
          regs_o.gpsr_spi_sclk_load_o <= '0';
          regs_o.gpsr_spi_ncs_load_o <= '0';
          regs_o.gpsr_spi_mosi_load_o <= '0';
          regs_o.diag_cr_adr_load_o <= '0';
          regs_o.diag_dat_load_o <= '0';
        end if;
      else
        if ((wb_cyc_i = '1') and (wb_stb_i = '1')) then
          case rwaddr_reg(4 downto 0) is
          when "00000" => 
            if (wb_we_i = '1') then
              regs_o.rstr_trig_wr_o <= '1';
              sysc_rstr_rst_int <= wrdata_reg(28);
            end if;
            rddata_reg(28) <= sysc_rstr_rst_int;
            rddata_reg(0) <= 'X';
            rddata_reg(1) <= 'X';
            rddata_reg(2) <= 'X';
            rddata_reg(3) <= 'X';
            rddata_reg(4) <= 'X';
            rddata_reg(5) <= 'X';
            rddata_reg(6) <= 'X';
            rddata_reg(7) <= 'X';
            rddata_reg(8) <= 'X';
            rddata_reg(9) <= 'X';
            rddata_reg(10) <= 'X';
            rddata_reg(11) <= 'X';
            rddata_reg(12) <= 'X';
            rddata_reg(13) <= 'X';
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "00001" => 
            if (wb_we_i = '1') then
              sysc_gpsr_led_stat_int <= wrdata_reg(0);
              sysc_gpsr_led_link_int <= wrdata_reg(1);
              regs_o.gpsr_fmc_scl_load_o <= '1';
              regs_o.gpsr_fmc_sda_load_o <= '1';
              sysc_gpsr_net_rst_int <= wrdata_reg(4);
              regs_o.gpsr_sfp_scl_load_o <= '1';
              regs_o.gpsr_sfp_sda_load_o <= '1';
              regs_o.gpsr_spi_sclk_load_o <= '1';
              regs_o.gpsr_spi_ncs_load_o <= '1';
              regs_o.gpsr_spi_mosi_load_o <= '1';
            end if;
            rddata_reg(0) <= '0';
            rddata_reg(1) <= '0';
            rddata_reg(2) <= regs_i.gpsr_fmc_scl_i;
            rddata_reg(3) <= regs_i.gpsr_fmc_sda_i;
            rddata_reg(4) <= '0';
            rddata_reg(5) <= regs_i.gpsr_btn1_i;
            rddata_reg(6) <= regs_i.gpsr_btn2_i;
            rddata_reg(7) <= regs_i.gpsr_sfp_det_i;
            rddata_reg(8) <= regs_i.gpsr_sfp_scl_i;
            rddata_reg(9) <= regs_i.gpsr_sfp_sda_i;
            rddata_reg(10) <= regs_i.gpsr_spi_sclk_i;
            rddata_reg(11) <= regs_i.gpsr_spi_ncs_i;
            rddata_reg(12) <= regs_i.gpsr_spi_mosi_i;
            rddata_reg(13) <= regs_i.gpsr_spi_miso_i;
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(2) <= '1';
            ack_in_progress <= '1';
          when "00010" => 
            if (wb_we_i = '1') then
              sysc_gpcr_led_stat_int <= wrdata_reg(0);
              sysc_gpcr_led_link_int <= wrdata_reg(1);
              sysc_gpcr_fmc_scl_int <= wrdata_reg(2);
              sysc_gpcr_fmc_sda_int <= wrdata_reg(3);
              sysc_gpcr_sfp_scl_int <= wrdata_reg(8);
              sysc_gpcr_sfp_sda_int <= wrdata_reg(9);
              sysc_gpcr_spi_sclk_int <= wrdata_reg(10);
              sysc_gpcr_spi_cs_int <= wrdata_reg(11);
              sysc_gpcr_spi_mosi_int <= wrdata_reg(12);
            end if;
            rddata_reg(0) <= '0';
            rddata_reg(1) <= '0';
            rddata_reg(2) <= '0';
            rddata_reg(3) <= '0';
            rddata_reg(8) <= '0';
            rddata_reg(9) <= '0';
            rddata_reg(10) <= '0';
            rddata_reg(11) <= '0';
            rddata_reg(12) <= '0';
            rddata_reg(0) <= 'X';
            rddata_reg(1) <= 'X';
            rddata_reg(2) <= 'X';
            rddata_reg(3) <= 'X';
            rddata_reg(4) <= 'X';
            rddata_reg(5) <= 'X';
            rddata_reg(6) <= 'X';
            rddata_reg(7) <= 'X';
            rddata_reg(8) <= 'X';
            rddata_reg(9) <= 'X';
            rddata_reg(10) <= 'X';
            rddata_reg(11) <= 'X';
            rddata_reg(12) <= 'X';
            rddata_reg(13) <= 'X';
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(2) <= '1';
            ack_in_progress <= '1';
          when "00011" => 
            if (wb_we_i = '1') then
            end if;
            rddata_reg(3 downto 0) <= regs_i.hwfr_memsize_i;
            rddata_reg(9 downto 8) <= regs_i.hwfr_storage_type_i;
            rddata_reg(31 downto 16) <= regs_i.hwfr_storage_sec_i;
            rddata_reg(4) <= 'X';
            rddata_reg(5) <= 'X';
            rddata_reg(6) <= 'X';
            rddata_reg(7) <= 'X';
            rddata_reg(10) <= 'X';
            rddata_reg(11) <= 'X';
            rddata_reg(12) <= 'X';
            rddata_reg(13) <= 'X';
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "00100" => 
            if (wb_we_i = '1') then
            end if;
            rddata_reg(31 downto 0) <= regs_i.hwir_name_i;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "00101" => 
            if (wb_we_i = '1') then
            end if;
            rddata_reg(31 downto 0) <= regs_i.sdbfs_baddr_i;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "00110" => 
            if (wb_we_i = '1') then
              sysc_tcr_enable_int <= wrdata_reg(31);
            end if;
            rddata_reg(11 downto 0) <= regs_i.tcr_tdiv_i;
            rddata_reg(31) <= sysc_tcr_enable_int;
            rddata_reg(12) <= 'X';
            rddata_reg(13) <= 'X';
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "00111" => 
            if (wb_we_i = '1') then
            end if;
            rddata_reg(31 downto 0) <= regs_i.tvr_i;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "01000" => 
            if (wb_we_i = '1') then
            end if;
            rddata_reg(15 downto 0) <= regs_i.diag_info_ver_i;
            rddata_reg(31 downto 16) <= regs_i.diag_info_id_i;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "01001" => 
            if (wb_we_i = '1') then
            end if;
            rddata_reg(15 downto 0) <= regs_i.diag_nw_rw_i;
            rddata_reg(31 downto 16) <= regs_i.diag_nw_ro_i;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "01010" => 
            if (wb_we_i = '1') then
              regs_o.diag_cr_adr_load_o <= '1';
              sysc_diag_cr_rw_int <= wrdata_reg(31);
            end if;
            rddata_reg(15 downto 0) <= regs_i.diag_cr_adr_i;
            rddata_reg(31) <= sysc_diag_cr_rw_int;
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "01011" => 
            if (wb_we_i = '1') then
              regs_o.diag_dat_load_o <= '1';
            end if;
            rddata_reg(31 downto 0) <= regs_i.diag_dat_i;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "01100" => 
            if (wb_we_i = '1') then
              sysc_wdiag_ctrl_data_valid_int <= wrdata_reg(0);
            end if;
            rddata_reg(0) <= sysc_wdiag_ctrl_data_valid_int;
            rddata_reg(8) <= regs_i.wdiag_ctrl_data_snapshot_i;
            rddata_reg(1) <= 'X';
            rddata_reg(2) <= 'X';
            rddata_reg(3) <= 'X';
            rddata_reg(4) <= 'X';
            rddata_reg(5) <= 'X';
            rddata_reg(6) <= 'X';
            rddata_reg(7) <= 'X';
            rddata_reg(9) <= 'X';
            rddata_reg(10) <= 'X';
            rddata_reg(11) <= 'X';
            rddata_reg(12) <= 'X';
            rddata_reg(13) <= 'X';
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "01101" => 
            if (wb_we_i = '1') then
              sysc_wdiag_sstat_wr_mode_int <= wrdata_reg(0);
              sysc_wdiag_sstat_servostate_int <= wrdata_reg(11 downto 8);
            end if;
            rddata_reg(0) <= sysc_wdiag_sstat_wr_mode_int;
            rddata_reg(11 downto 8) <= sysc_wdiag_sstat_servostate_int;
            rddata_reg(1) <= 'X';
            rddata_reg(2) <= 'X';
            rddata_reg(3) <= 'X';
            rddata_reg(4) <= 'X';
            rddata_reg(5) <= 'X';
            rddata_reg(6) <= 'X';
            rddata_reg(7) <= 'X';
            rddata_reg(12) <= 'X';
            rddata_reg(13) <= 'X';
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "01110" => 
            if (wb_we_i = '1') then
              sysc_wdiag_pstat_link_int <= wrdata_reg(0);
              sysc_wdiag_pstat_locked_int <= wrdata_reg(1);
            end if;
            rddata_reg(0) <= sysc_wdiag_pstat_link_int;
            rddata_reg(1) <= sysc_wdiag_pstat_locked_int;
            rddata_reg(2) <= 'X';
            rddata_reg(3) <= 'X';
            rddata_reg(4) <= 'X';
            rddata_reg(5) <= 'X';
            rddata_reg(6) <= 'X';
            rddata_reg(7) <= 'X';
            rddata_reg(8) <= 'X';
            rddata_reg(9) <= 'X';
            rddata_reg(10) <= 'X';
            rddata_reg(11) <= 'X';
            rddata_reg(12) <= 'X';
            rddata_reg(13) <= 'X';
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "01111" => 
            if (wb_we_i = '1') then
              sysc_wdiag_ptpstat_ptpstate_int <= wrdata_reg(7 downto 0);
            end if;
            rddata_reg(7 downto 0) <= sysc_wdiag_ptpstat_ptpstate_int;
            rddata_reg(8) <= 'X';
            rddata_reg(9) <= 'X';
            rddata_reg(10) <= 'X';
            rddata_reg(11) <= 'X';
            rddata_reg(12) <= 'X';
            rddata_reg(13) <= 'X';
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "10000" => 
            if (wb_we_i = '1') then
              sysc_wdiag_astat_aux_int <= wrdata_reg(7 downto 0);
            end if;
            rddata_reg(7 downto 0) <= sysc_wdiag_astat_aux_int;
            rddata_reg(8) <= 'X';
            rddata_reg(9) <= 'X';
            rddata_reg(10) <= 'X';
            rddata_reg(11) <= 'X';
            rddata_reg(12) <= 'X';
            rddata_reg(13) <= 'X';
            rddata_reg(14) <= 'X';
            rddata_reg(15) <= 'X';
            rddata_reg(16) <= 'X';
            rddata_reg(17) <= 'X';
            rddata_reg(18) <= 'X';
            rddata_reg(19) <= 'X';
            rddata_reg(20) <= 'X';
            rddata_reg(21) <= 'X';
            rddata_reg(22) <= 'X';
            rddata_reg(23) <= 'X';
            rddata_reg(24) <= 'X';
            rddata_reg(25) <= 'X';
            rddata_reg(26) <= 'X';
            rddata_reg(27) <= 'X';
            rddata_reg(28) <= 'X';
            rddata_reg(29) <= 'X';
            rddata_reg(30) <= 'X';
            rddata_reg(31) <= 'X';
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "10001" => 
            if (wb_we_i = '1') then
              sysc_wdiag_txfcnt_int <= wrdata_reg(31 downto 0);
            end if;
            rddata_reg(31 downto 0) <= sysc_wdiag_txfcnt_int;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "10010" => 
            if (wb_we_i = '1') then
              sysc_wdiag_rxfcnt_int <= wrdata_reg(31 downto 0);
            end if;
            rddata_reg(31 downto 0) <= sysc_wdiag_rxfcnt_int;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "10011" => 
            if (wb_we_i = '1') then
              sysc_wdiag_sec_msb_int <= wrdata_reg(31 downto 0);
            end if;
            rddata_reg(31 downto 0) <= sysc_wdiag_sec_msb_int;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "10100" => 
            if (wb_we_i = '1') then
              sysc_wdiag_sec_lsb_int <= wrdata_reg(31 downto 0);
            end if;
            rddata_reg(31 downto 0) <= sysc_wdiag_sec_lsb_int;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "10101" => 
            if (wb_we_i = '1') then
              sysc_wdiag_ns_int <= wrdata_reg(31 downto 0);
            end if;
            rddata_reg(31 downto 0) <= sysc_wdiag_ns_int;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "10110" => 
            if (wb_we_i = '1') then
              sysc_wdiag_mu_msb_int <= wrdata_reg(31 downto 0);
            end if;
            rddata_reg(31 downto 0) <= sysc_wdiag_mu_msb_int;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "10111" => 
            if (wb_we_i = '1') then
              sysc_wdiag_mu_lsb_int <= wrdata_reg(31 downto 0);
            end if;
            rddata_reg(31 downto 0) <= sysc_wdiag_mu_lsb_int;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "11000" => 
            if (wb_we_i = '1') then
              sysc_wdiag_dms_msb_int <= wrdata_reg(31 downto 0);
            end if;
            rddata_reg(31 downto 0) <= sysc_wdiag_dms_msb_int;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "11001" => 
            if (wb_we_i = '1') then
              sysc_wdiag_dms_lsb_int <= wrdata_reg(31 downto 0);
            end if;
            rddata_reg(31 downto 0) <= sysc_wdiag_dms_lsb_int;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "11010" => 
            if (wb_we_i = '1') then
              sysc_wdiag_asym_int <= wrdata_reg(31 downto 0);
            end if;
            rddata_reg(31 downto 0) <= sysc_wdiag_asym_int;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "11011" => 
            if (wb_we_i = '1') then
              sysc_wdiag_cko_int <= wrdata_reg(31 downto 0);
            end if;
            rddata_reg(31 downto 0) <= sysc_wdiag_cko_int;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "11100" => 
            if (wb_we_i = '1') then
              sysc_wdiag_setp_int <= wrdata_reg(31 downto 0);
            end if;
            rddata_reg(31 downto 0) <= sysc_wdiag_setp_int;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "11101" => 
            if (wb_we_i = '1') then
              sysc_wdiag_ucnt_int <= wrdata_reg(31 downto 0);
            end if;
            rddata_reg(31 downto 0) <= sysc_wdiag_ucnt_int;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when "11110" => 
            if (wb_we_i = '1') then
              sysc_wdiag_temp_int <= wrdata_reg(31 downto 0);
            end if;
            rddata_reg(31 downto 0) <= sysc_wdiag_temp_int;
            ack_sreg(0) <= '1';
            ack_in_progress <= '1';
          when others =>
-- prevent the slave from hanging the bus on invalid address
            ack_in_progress <= '1';
            ack_sreg(0) <= '1';
          end case;
        end if;
      end if;
    end if;
  end process;
  
  
-- Drive the data output bus
  wb_dat_o <= rddata_reg;
-- Reset trigger
-- pass-through field: Reset trigger in register: Syscon reset register
  regs_o.rstr_trig_o <= wrdata_reg(27 downto 0);
-- Reset line state value
  regs_o.rstr_rst_o <= sysc_rstr_rst_int;
-- Status LED
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      sysc_gpsr_led_stat_dly0 <= '0';
      regs_o.gpsr_led_stat_o <= '0';
    elsif rising_edge(clk_sys_i) then
      sysc_gpsr_led_stat_dly0 <= sysc_gpsr_led_stat_int;
      regs_o.gpsr_led_stat_o <= sysc_gpsr_led_stat_int and (not sysc_gpsr_led_stat_dly0);
    end if;
  end process;
  
  
-- Link LED
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      sysc_gpsr_led_link_dly0 <= '0';
      regs_o.gpsr_led_link_o <= '0';
    elsif rising_edge(clk_sys_i) then
      sysc_gpsr_led_link_dly0 <= sysc_gpsr_led_link_int;
      regs_o.gpsr_led_link_o <= sysc_gpsr_led_link_int and (not sysc_gpsr_led_link_dly0);
    end if;
  end process;
  
  
-- FMC I2C bitbanged SCL
  regs_o.gpsr_fmc_scl_o <= wrdata_reg(2);
-- FMC I2C bitbanged SDA
  regs_o.gpsr_fmc_sda_o <= wrdata_reg(3);
-- Network AP reset
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      sysc_gpsr_net_rst_dly0 <= '0';
      regs_o.gpsr_net_rst_o <= '0';
    elsif rising_edge(clk_sys_i) then
      sysc_gpsr_net_rst_dly0 <= sysc_gpsr_net_rst_int;
      regs_o.gpsr_net_rst_o <= sysc_gpsr_net_rst_int and (not sysc_gpsr_net_rst_dly0);
    end if;
  end process;
  
  
-- SPEC Pushbutton 1 state
-- SPEC Pushbutton 2 state
-- SFP detect (MOD_DEF0 signal)
-- SFP I2C bitbanged SCL
  regs_o.gpsr_sfp_scl_o <= wrdata_reg(8);
-- SFP I2C bitbanged SDA
  regs_o.gpsr_sfp_sda_o <= wrdata_reg(9);
-- SPI bitbanged SCLK
  regs_o.gpsr_spi_sclk_o <= wrdata_reg(10);
-- SPI bitbanged NCS
  regs_o.gpsr_spi_ncs_o <= wrdata_reg(11);
-- SPI bitbanged MOSI
  regs_o.gpsr_spi_mosi_o <= wrdata_reg(12);
-- SPI bitbanged MISO
-- Status LED
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      sysc_gpcr_led_stat_dly0 <= '0';
      regs_o.gpcr_led_stat_o <= '0';
    elsif rising_edge(clk_sys_i) then
      sysc_gpcr_led_stat_dly0 <= sysc_gpcr_led_stat_int;
      regs_o.gpcr_led_stat_o <= sysc_gpcr_led_stat_int and (not sysc_gpcr_led_stat_dly0);
    end if;
  end process;
  
  
-- Link LED
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      sysc_gpcr_led_link_dly0 <= '0';
      regs_o.gpcr_led_link_o <= '0';
    elsif rising_edge(clk_sys_i) then
      sysc_gpcr_led_link_dly0 <= sysc_gpcr_led_link_int;
      regs_o.gpcr_led_link_o <= sysc_gpcr_led_link_int and (not sysc_gpcr_led_link_dly0);
    end if;
  end process;
  
  
-- FMC I2C bitbanged SCL
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      sysc_gpcr_fmc_scl_dly0 <= '0';
      regs_o.gpcr_fmc_scl_o <= '0';
    elsif rising_edge(clk_sys_i) then
      sysc_gpcr_fmc_scl_dly0 <= sysc_gpcr_fmc_scl_int;
      regs_o.gpcr_fmc_scl_o <= sysc_gpcr_fmc_scl_int and (not sysc_gpcr_fmc_scl_dly0);
    end if;
  end process;
  
  
-- FMC I2C bitbanged SDA
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      sysc_gpcr_fmc_sda_dly0 <= '0';
      regs_o.gpcr_fmc_sda_o <= '0';
    elsif rising_edge(clk_sys_i) then
      sysc_gpcr_fmc_sda_dly0 <= sysc_gpcr_fmc_sda_int;
      regs_o.gpcr_fmc_sda_o <= sysc_gpcr_fmc_sda_int and (not sysc_gpcr_fmc_sda_dly0);
    end if;
  end process;
  
  
-- SFP I2C bitbanged SCL
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      sysc_gpcr_sfp_scl_dly0 <= '0';
      regs_o.gpcr_sfp_scl_o <= '0';
    elsif rising_edge(clk_sys_i) then
      sysc_gpcr_sfp_scl_dly0 <= sysc_gpcr_sfp_scl_int;
      regs_o.gpcr_sfp_scl_o <= sysc_gpcr_sfp_scl_int and (not sysc_gpcr_sfp_scl_dly0);
    end if;
  end process;
  
  
-- FMC I2C bitbanged SDA
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      sysc_gpcr_sfp_sda_dly0 <= '0';
      regs_o.gpcr_sfp_sda_o <= '0';
    elsif rising_edge(clk_sys_i) then
      sysc_gpcr_sfp_sda_dly0 <= sysc_gpcr_sfp_sda_int;
      regs_o.gpcr_sfp_sda_o <= sysc_gpcr_sfp_sda_int and (not sysc_gpcr_sfp_sda_dly0);
    end if;
  end process;
  
  
-- SPI bitbanged SCLK
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      sysc_gpcr_spi_sclk_dly0 <= '0';
      regs_o.gpcr_spi_sclk_o <= '0';
    elsif rising_edge(clk_sys_i) then
      sysc_gpcr_spi_sclk_dly0 <= sysc_gpcr_spi_sclk_int;
      regs_o.gpcr_spi_sclk_o <= sysc_gpcr_spi_sclk_int and (not sysc_gpcr_spi_sclk_dly0);
    end if;
  end process;
  
  
-- SPI bitbanged CS
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      sysc_gpcr_spi_cs_dly0 <= '0';
      regs_o.gpcr_spi_cs_o <= '0';
    elsif rising_edge(clk_sys_i) then
      sysc_gpcr_spi_cs_dly0 <= sysc_gpcr_spi_cs_int;
      regs_o.gpcr_spi_cs_o <= sysc_gpcr_spi_cs_int and (not sysc_gpcr_spi_cs_dly0);
    end if;
  end process;
  
  
-- SPI bitbanged MOSI
  process (clk_sys_i, rst_n_i)
  begin
    if (rst_n_i = '0') then 
      sysc_gpcr_spi_mosi_dly0 <= '0';
      regs_o.gpcr_spi_mosi_o <= '0';
    elsif rising_edge(clk_sys_i) then
      sysc_gpcr_spi_mosi_dly0 <= sysc_gpcr_spi_mosi_int;
      regs_o.gpcr_spi_mosi_o <= sysc_gpcr_spi_mosi_int and (not sysc_gpcr_spi_mosi_dly0);
    end if;
  end process;
  
  
-- Memory size
-- Storage type
-- Storage sector size
-- Board name
-- Base address
-- Timer Divider
-- Timer Enable
  regs_o.tcr_enable_o <= sysc_tcr_enable_int;
-- Timer Counter Value
-- Ver
-- Id
-- Read/write words
-- Read-only words
-- Address
  regs_o.diag_cr_adr_o <= wrdata_reg(15 downto 0);
-- R/W
  regs_o.diag_cr_rw_o <= sysc_diag_cr_rw_int;
-- Data
  regs_o.diag_dat_o <= wrdata_reg(31 downto 0);
-- WR DIAG data valid
  regs_o.wdiag_ctrl_data_valid_o <= sysc_wdiag_ctrl_data_valid_int;
-- WR DIAG data snapshot
-- WR valid
  regs_o.wdiag_sstat_wr_mode_o <= sysc_wdiag_sstat_wr_mode_int;
-- Servo State
  regs_o.wdiag_sstat_servostate_o <= sysc_wdiag_sstat_servostate_int;
-- Link Status
  regs_o.wdiag_pstat_link_o <= sysc_wdiag_pstat_link_int;
-- PLL Locked
  regs_o.wdiag_pstat_locked_o <= sysc_wdiag_pstat_locked_int;
-- PTP State
  regs_o.wdiag_ptpstat_ptpstate_o <= sysc_wdiag_ptpstat_ptpstate_int;
-- AUX channel
  regs_o.wdiag_astat_aux_o <= sysc_wdiag_astat_aux_int;
-- Data
  regs_o.wdiag_txfcnt_o <= sysc_wdiag_txfcnt_int;
-- Data
  regs_o.wdiag_rxfcnt_o <= sysc_wdiag_rxfcnt_int;
-- Data
  regs_o.wdiag_sec_msb_o <= sysc_wdiag_sec_msb_int;
-- Data
  regs_o.wdiag_sec_lsb_o <= sysc_wdiag_sec_lsb_int;
-- Data
  regs_o.wdiag_ns_o <= sysc_wdiag_ns_int;
-- Data
  regs_o.wdiag_mu_msb_o <= sysc_wdiag_mu_msb_int;
-- Data
  regs_o.wdiag_mu_lsb_o <= sysc_wdiag_mu_lsb_int;
-- Data
  regs_o.wdiag_dms_msb_o <= sysc_wdiag_dms_msb_int;
-- Data
  regs_o.wdiag_dms_lsb_o <= sysc_wdiag_dms_lsb_int;
-- Data
  regs_o.wdiag_asym_o <= sysc_wdiag_asym_int;
-- Data
  regs_o.wdiag_cko_o <= sysc_wdiag_cko_int;
-- Data
  regs_o.wdiag_setp_o <= sysc_wdiag_setp_int;
-- Data
  regs_o.wdiag_ucnt_o <= sysc_wdiag_ucnt_int;
-- Data
  regs_o.wdiag_temp_o <= sysc_wdiag_temp_int;
  rwaddr_reg <= wb_adr_i;
  wb_stall_o <= (not ack_sreg(0)) and (wb_stb_i and wb_cyc_i);
-- ACK signal generation. Just pass the LSB of ACK counter.
  wb_ack_o <= ack_sreg(0);
end syn;
