/*****************************************************************************/
/* Stream Class Library Copyright (c) 1999-2000 Sakai Hiroaki.               */
/* All Rights Reserved.                                                      */
/*===========================================================================*/
/* This program is free software; you can redistribute it and/or modify      */
/* it under the terms of the GNU General Public License as published by      */
/* the Free Software Foundation; either version 2, or (at your option)       */
/* any later version.                                                        */
/*                                                                           */
/* This program is distributed in the hope that it will be useful,           */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of            */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             */
/* GNU General Public License for more details.                              */
/*                                                                           */
/* You should have received a copy of the GNU General Public License         */
/* along with this program; see the file COPYING.  If not, write to          */
/* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.     */
/*****************************************************************************/

#ifndef _STREAM_H_INCLUDED_
#define _STREAM_H_INCLUDED_

/*****************************************************************************/
/*                                                                   */
/*****************************************************************************/

/*****************************************************************************/
/* Stream                                                            */
/*****************************************************************************/

typedef struct _Stream * Stream;

/*****************************************************************************/
/* إåեΥ󥯥롼                                              */
/*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>

/*****************************************************************************/
/* (˸)                                              */
/*****************************************************************************/

/*===========================================================================*/
/* Stream κΥ                                                 */
/*===========================================================================*/

typedef enum {
  CREATE_NO_STREAM,                /* ̵ */
  CREATE_STREAM_FROM_FILE,         /* ե̾ */
  CREATE_STREAM_FROM_FILE_POINTER, /* եݥ󥿤 */
  CREATE_STREAM_FROM_CHARACTERS    /* ʸ(char * ) */
} CreateStreamFrom;

/*****************************************************************************/
/* ؿȥ᥽åɤ(˸)                                  */
/*****************************************************************************/

/*===========================================================================*/
/* ֥Ȥ                                                        */
/*===========================================================================*/

/*---------------------------------------------------------------------------*/
/* ֥Ȥ                                                        */
/*---------------------------------------------------------------------------*/

Stream Stream_Create(CreateStreamFrom from, void * object);

/*---------------------------------------------------------------------------*/
/* ʤˤʤȤ(ߡ)                                        */
/*---------------------------------------------------------------------------*/

Stream Stream_CreateFromNone();

/*---------------------------------------------------------------------------*/
/* ե뤫                                                          */
/*---------------------------------------------------------------------------*/

Stream Stream_CreateFromFile(char * filename);
  
/*---------------------------------------------------------------------------*/
/* եݥ󥿤                                                  */
/*---------------------------------------------------------------------------*/

Stream Stream_CreateFromFilePointer(FILE * fp);

/*---------------------------------------------------------------------------*/
/* ʸ(char * )                                                 */
/*---------------------------------------------------------------------------*/

Stream Stream_CreateFromCharacters(char * characters);

/*===========================================================================*/
/* ֥Ȥξõ                                                        */
/*===========================================================================*/

int Stream_Destroy(Stream this);

/*===========================================================================*/
/* ʸμ                                                              */
/*===========================================================================*/

/*---------------------------------------------------------------------------*/
/* ɤ߹ʸޤ뤫ɤ                                            */
/*---------------------------------------------------------------------------*/

int Stream_IsEnd(Stream this);

/*---------------------------------------------------------------------------*/
/* Stream 飱ʸ(get)롥                                        */
/*---------------------------------------------------------------------------*/

int Stream_GetCharacter(Stream this);

/*---------------------------------------------------------------------------*/
/* Stream ˣʸֵ(unget)롥                                        */
/*---------------------------------------------------------------------------*/

int Stream_UngetCharacter(Stream this, int c);

/*---------------------------------------------------------------------------*/
/* Stream ʸֵ(unget)롥                                        */
/*---------------------------------------------------------------------------*/

int Stream_UngetCharacters(Stream this, char * characters);

/*---------------------------------------------------------------------------*/
/* Stream ȡǶڤäʸɤ߹ߡʸ(String )֤  */
/* 䥳ȹԤβԤ                                          */
/*---------------------------------------------------------------------------*/
/* split1 ϡʣζڤʸϢ³ˤ⡤̥ʸȤڤʬ롥 */
/* split2 ϡʣζڤʸϢ³ˤϡҤȤĤζڤʸȤ   */
/* 롥                                                                */
/*---------------------------------------------------------------------------*/

char * Stream_GetWord(Stream this,      /* ɤ߹߸ Stream */
		      char * buffer,
		      int buffer_length,
		      char * split1,    /* ʸڤʬ */
		      char * split2,    /* ʸǤڤʬ */
		      char * comment,   /* ȹԤƬʸ '#' ʤ */
		      char * lineend,   /* ʸ '\n' ʤ */
		      char * quotation, /* ʸ '\"' ʤ */
		      char * head_skip, /* ʸƬɤߤȤФʸ */
		      char * tail_skip  /* ʸɤߤȤФʸ */
		      );

/*****************************************************************************/
/* ޤ                                                                  */
/*****************************************************************************/

#endif

/*****************************************************************************/
/* End of File.                                                              */
/*****************************************************************************/
