#ifndef UTIL_H_included
#define UTIL_H_included 1
#include <libintl.h>
#include <errno.h>
#include <stdbool.h>
#include <stdio.h>
#include<stdlib.h>
#include <limits.h>
#include <assert.h>

static inline bool isempty(const char *p) {
        return !p || !p[0];
}

/*汉化相关*/
#define N_(String) gettext(String)
#define _(String) gettext(String)


/*跟内存清理相关的操作*/
#define DEFINE_TRIVIAL_CLEANUP_FUNC(type, func)                 \
        static inline void func##p(type *p) {                   \
                if (*p)                                         \
                        func(*p);                               \
        }
void freep(void *p);
#define _cleanup_(x) __attribute__((__cleanup__(x)))
#define _cleanup_free_ _cleanup_(freep)
void strv_clear(char **l);
char **strv_free(char **l);
DEFINE_TRIVIAL_CLEANUP_FUNC(char**, strv_free);
#define _cleanup_strv_free_ _cleanup_(strv_freep)

/*跟加密计算相关*/
int calculateFileMD5(const char* file_path, unsigned char* md5Digest);
int calculate_sha256(const char* file_path, unsigned char* sha256_hash);
/*字符串处理相关*/
int str_endsWith(const char *str, const char *suffix);
int start_process(const char *cmd_path, const char *arg_string, char **output);
#endif