// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef LLAMACPPMODELCONFIG_H
#define LLAMACPPMODELCONFIG_H

#include "global_header.h"

#include <QObject>
#include <QVariantHash>

GLOBAL_BEGIN_NAMESPACE

class LlamacppModelConfig : public QObject
{
public:
    explicit LlamacppModelConfig(const QString &file);
    inline QString bin() const {
        return read("bin");
    }
    QStringList architectures() const;
    QVariantHash params() const;
protected:
    QString read(const QString &key) const {
        return configs.value(key, QString()).toString();
    }
private:
    QVariantHash configs;
};

GLOBAL_END_NAMESPACE

#endif // LLAMACPPMODELCONFIG_H
