/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.gui.MainFrameModel;
import com.puppycrawl.tools.checkstyle.gui.ParseTreeTablePresentation;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class ParseTreeTableModel
implements TreeModel {
    private final ParseTreeTablePresentation pModel;
    private final EventListenerList listenerList = new EventListenerList();

    public ParseTreeTableModel(DetailAST parseTree) {
        this.pModel = new ParseTreeTablePresentation(parseTree);
        this.setParseTree(parseTree);
    }

    protected final void setParseTree(DetailAST parseTree) {
        this.pModel.setRoot(parseTree);
        Object[] path = new Object[]{this.pModel.getRoot()};
        this.fireTreeStructureChanged(this, path, null, null);
    }

    protected void setParseMode(MainFrameModel.ParseMode mode) {
        this.pModel.setParseMode(mode);
    }

    public int getColumnCount() {
        return this.pModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.pModel.getColumnName(column);
    }

    public Class<?> getColumnClass(int column) {
        return this.pModel.getColumnClass(column);
    }

    public Object getValueAt(Object node, int column) {
        return this.pModel.getValueAt(node, column);
    }

    @Override
    public Object getChild(Object parent, int index) {
        return this.pModel.getChild(parent, index);
    }

    @Override
    public int getChildCount(Object parent) {
        return this.pModel.getChildCount(parent);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public Object getRoot() {
        return this.pModel.getRoot();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.pModel.isLeaf(node);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.pModel.getIndexOfChild(parent, child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.listenerList.add(TreeModelListener.class, listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.listenerList.remove(TreeModelListener.class, listener);
    }

    private void fireTreeStructureChanged(Object source, Object[] path, int[] childIndices, Object ... children) {
        Object[] listeners = this.listenerList.getListenerList();
        TreeModelEvent event = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (event == null) {
                event = new TreeModelEvent(source, path, childIndices, children);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(event);
        }
    }

    public boolean isCellEditable(int column) {
        return this.pModel.isCellEditable(column);
    }
}

