/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.xpath;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.XpathUtil;
import com.puppycrawl.tools.checkstyle.xpath.AbstractNode;
import com.puppycrawl.tools.checkstyle.xpath.iterators.DescendantIterator;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.iter.ArrayIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;

public class RootNode
extends AbstractNode {
    private static final String ROOT_NAME = "ROOT";
    private static final AbstractNode[] EMPTY_ABSTRACT_NODE_ARRAY = new AbstractNode[0];
    private final DetailAST detailAst;

    public RootNode(DetailAST detailAst) {
        super(new GenericTreeInfo(Configuration.newConfiguration()));
        this.detailAst = detailAst;
    }

    @Override
    public int compareOrder(NodeInfo nodeInfo) {
        throw RootNode.throwUnsupportedOperationException();
    }

    @Override
    protected List<AbstractNode> createChildren() {
        return XpathUtil.createChildren(this, this, this.detailAst);
    }

    @Override
    public boolean hasChildNodes() {
        return this.detailAst != null;
    }

    @Override
    public String getAttributeValue(String namespace, String localPart) {
        throw RootNode.throwUnsupportedOperationException();
    }

    @Override
    public String getLocalPart() {
        return ROOT_NAME;
    }

    @Override
    public int getNodeKind() {
        return 9;
    }

    @Override
    public NodeInfo getParent() {
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        return this;
    }

    @Override
    public AxisIterator iterateAxis(int axisNumber) {
        AxisIterator result;
        switch (axisNumber) {
            case 0: 
            case 2: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                result = EmptyIterator.ofNodes();
                break;
            }
            case 1: 
            case 12: {
                result = SingleNodeIterator.makeIterator(this);
                break;
            }
            case 3: {
                if (this.hasChildNodes()) {
                    result = new ArrayIterator.OfNodes((NodeInfo[])this.getChildren().toArray(EMPTY_ABSTRACT_NODE_ARRAY));
                    break;
                }
                result = EmptyIterator.ofNodes();
                break;
            }
            case 4: {
                if (this.hasChildNodes()) {
                    result = new DescendantIterator(this, DescendantIterator.StartWith.CHILDREN);
                    break;
                }
                result = EmptyIterator.ofNodes();
                break;
            }
            case 5: {
                result = new DescendantIterator(this, DescendantIterator.StartWith.CURRENT_NODE);
                break;
            }
            default: {
                throw RootNode.throwUnsupportedOperationException();
            }
        }
        return result;
    }

    @Override
    public int getLineNumber() {
        return this.detailAst.getLineNo();
    }

    @Override
    public int getColumnNumber() {
        return this.detailAst.getColumnNo();
    }

    @Override
    public int getTokenType() {
        return 1;
    }

    @Override
    public DetailAST getUnderlyingNode() {
        return this.detailAst;
    }

    @Override
    public int getDepth() {
        return 0;
    }

    private static UnsupportedOperationException throwUnsupportedOperationException() {
        return new UnsupportedOperationException("Operation is not supported");
    }
}

