// Code generated by smithy-go-codegen DO NOT EDIT.

package smithyrpcv2cbor

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/internal/protocoltest/smithyrpcv2cbor/types"
	smithy "github.com/aws/smithy-go"
	smithycbor "github.com/aws/smithy-go/encoding/cbor"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"io/ioutil"
	"strings"
	"time"
)

func deserializeS3Expires(v string) (*time.Time, error) {
	t, err := smithytime.ParseHTTPDate(v)
	if err != nil {
		return nil, nil
	}
	return &t, nil
}

type smithyRpcv2cbor_deserializeOpEmptyInputOutput struct {
}

func (*smithyRpcv2cbor_deserializeOpEmptyInputOutput) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpEmptyInputOutput) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorEmptyInputOutput(resp)
	}

	if _, err = io.Copy(ioutil.Discard, resp.Body); err != nil {
		return out, metadata, fmt.Errorf("discard response body: %w", err)
	}

	out.Result = &EmptyInputOutputOutput{}

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpFloat16 struct {
}

func (*smithyRpcv2cbor_deserializeOpFloat16) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpFloat16) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorFloat16(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &Float16Output{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_Float16Output(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpFractionalSeconds struct {
}

func (*smithyRpcv2cbor_deserializeOpFractionalSeconds) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpFractionalSeconds) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorFractionalSeconds(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &FractionalSecondsOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_FractionalSecondsOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpGreetingWithErrors struct {
}

func (*smithyRpcv2cbor_deserializeOpGreetingWithErrors) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpGreetingWithErrors) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorGreetingWithErrors(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &GreetingWithErrorsOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_GreetingWithErrorsOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpNoInputOutput struct {
}

func (*smithyRpcv2cbor_deserializeOpNoInputOutput) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpNoInputOutput) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorNoInputOutput(resp)
	}

	if _, err = io.Copy(ioutil.Discard, resp.Body); err != nil {
		return out, metadata, fmt.Errorf("discard response body: %w", err)
	}

	out.Result = &NoInputOutputOutput{}

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpOperationWithDefaults struct {
}

func (*smithyRpcv2cbor_deserializeOpOperationWithDefaults) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpOperationWithDefaults) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorOperationWithDefaults(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &OperationWithDefaultsOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_OperationWithDefaultsOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpOptionalInputOutput struct {
}

func (*smithyRpcv2cbor_deserializeOpOptionalInputOutput) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpOptionalInputOutput) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorOptionalInputOutput(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &OptionalInputOutputOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_OptionalInputOutputOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpRecursiveShapes struct {
}

func (*smithyRpcv2cbor_deserializeOpRecursiveShapes) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpRecursiveShapes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorRecursiveShapes(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &RecursiveShapesOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_RecursiveShapesOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpRpcV2CborDenseMaps struct {
}

func (*smithyRpcv2cbor_deserializeOpRpcV2CborDenseMaps) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpRpcV2CborDenseMaps) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorRpcV2CborDenseMaps(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &RpcV2CborDenseMapsOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_RpcV2CborDenseMapsOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpRpcV2CborLists struct {
}

func (*smithyRpcv2cbor_deserializeOpRpcV2CborLists) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpRpcV2CborLists) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorRpcV2CborLists(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &RpcV2CborListsOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_RpcV2CborListsOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpRpcV2CborSparseMaps struct {
}

func (*smithyRpcv2cbor_deserializeOpRpcV2CborSparseMaps) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpRpcV2CborSparseMaps) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorRpcV2CborSparseMaps(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &RpcV2CborSparseMapsOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_RpcV2CborSparseMapsOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpSimpleScalarProperties struct {
}

func (*smithyRpcv2cbor_deserializeOpSimpleScalarProperties) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpSimpleScalarProperties) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorSimpleScalarProperties(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &SimpleScalarPropertiesOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_SimpleScalarPropertiesOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}

type smithyRpcv2cbor_deserializeOpSparseNullsOperation struct {
}

func (*smithyRpcv2cbor_deserializeOpSparseNullsOperation) ID() string {
	return "OperationDeserializer"
}

func (m *smithyRpcv2cbor_deserializeOpSparseNullsOperation) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	resp, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, fmt.Errorf("unexpected transport type %T", out.RawResponse)
	}

	if resp.Header.Get("smithy-protocol") != "rpc-v2-cbor" {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf(
				"unexpected smithy-protocol response header '%s' (HTTP status: %s)",
				resp.Header.Get("smithy-protocol"),
				resp.Status,
			),
		}
	}

	if resp.StatusCode != 200 {
		return out, metadata, rpc2_deserializeOpErrorSparseNullsOperation(resp)
	}

	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return out, metadata, err
	}

	if len(payload) == 0 {
		out.Result = &SparseNullsOperationOutput{}
		return out, metadata, nil
	}

	cv, err := smithycbor.Decode(payload)
	if err != nil {
		return out, metadata, err
	}

	output, err := deserializeCBOR_SparseNullsOperationOutput(cv)
	if err != nil {
		return out, metadata, err
	}

	out.Result = output

	return out, metadata, nil
}
func deserializeCBOR_Blob(v smithycbor.Value) ([]byte, error) {
	av, ok := v.(smithycbor.Slice)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	return []byte(av), nil
}

func deserializeCBOR_Bool(v smithycbor.Value) (bool, error) {
	av, ok := v.(smithycbor.Bool)
	if !ok {
		return false, fmt.Errorf("unexpected value type %T", v)
	}
	return bool(av), nil
}

func deserializeCBOR_Float32(v smithycbor.Value) (float32, error) {
	return smithycbor.AsFloat32(v)
}

func deserializeCBOR_Float64(v smithycbor.Value) (float64, error) {
	return smithycbor.AsFloat64(v)
}

func deserializeCBOR_Int16(v smithycbor.Value) (int16, error) {
	return smithycbor.AsInt16(v)
}

func deserializeCBOR_Int32(v smithycbor.Value) (int32, error) {
	return smithycbor.AsInt32(v)
}

func deserializeCBOR_Int64(v smithycbor.Value) (int64, error) {
	return smithycbor.AsInt64(v)
}

func deserializeCBOR_Int8(v smithycbor.Value) (int8, error) {
	return smithycbor.AsInt8(v)
}

func deserializeCBOR_String(v smithycbor.Value) (string, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return "", fmt.Errorf("unexpected value type %T", v)
	}
	return string(av), nil
}

func deserializeCBOR_Time(v smithycbor.Value) (time.Time, error) {
	return smithycbor.AsTime(v)
}

func deserializeCBOR_ValidationException(v smithycbor.Value) (*types.ValidationException, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.ValidationException{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "message" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Message = ptr.String(dv)
		}

		if key == "fieldList" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_ValidationExceptionFieldList(sv)
			if err != nil {
				return nil, err
			}
			ds.FieldList = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_ValidationExceptionField(v smithycbor.Value) (*types.ValidationExceptionField, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.ValidationExceptionField{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "path" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Path = ptr.String(dv)
		}

		if key == "message" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Message = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_ValidationExceptionFieldList(v smithycbor.Value) ([]types.ValidationExceptionField, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.ValidationExceptionField
	for _, si := range av {

		di, err := deserializeCBOR_ValidationExceptionField(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_Float16Output(v smithycbor.Value) (*Float16Output, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &Float16Output{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "value" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Float64(sv)
			if err != nil {
				return nil, err
			}
			ds.Value = ptr.Float64(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_FractionalSecondsOutput(v smithycbor.Value) (*FractionalSecondsOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &FractionalSecondsOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "datetime" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Time(sv)
			if err != nil {
				return nil, err
			}
			ds.Datetime = ptr.Time(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_GreetingWithErrorsOutput(v smithycbor.Value) (*GreetingWithErrorsOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &GreetingWithErrorsOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "greeting" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Greeting = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_OperationWithDefaultsOutput(v smithycbor.Value) (*OperationWithDefaultsOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &OperationWithDefaultsOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "defaultString" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.DefaultString = ptr.String(dv)
		}

		if key == "defaultBoolean" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Bool(sv)
			if err != nil {
				return nil, err
			}
			ds.DefaultBoolean = ptr.Bool(dv)
		}

		if key == "defaultList" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_TestStringList(sv)
			if err != nil {
				return nil, err
			}
			ds.DefaultList = dv
		}

		if key == "defaultTimestamp" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Time(sv)
			if err != nil {
				return nil, err
			}
			ds.DefaultTimestamp = ptr.Time(dv)
		}

		if key == "defaultBlob" {

			dv, err := deserializeCBOR_Blob(sv)
			if err != nil {
				return nil, err
			}
			ds.DefaultBlob = dv
		}

		if key == "defaultByte" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int8(sv)
			if err != nil {
				return nil, err
			}
			ds.DefaultByte = ptr.Int8(dv)
		}

		if key == "defaultShort" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int16(sv)
			if err != nil {
				return nil, err
			}
			ds.DefaultShort = ptr.Int16(dv)
		}

		if key == "defaultInteger" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.DefaultInteger = ptr.Int32(dv)
		}

		if key == "defaultLong" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int64(sv)
			if err != nil {
				return nil, err
			}
			ds.DefaultLong = ptr.Int64(dv)
		}

		if key == "defaultFloat" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Float32(sv)
			if err != nil {
				return nil, err
			}
			ds.DefaultFloat = ptr.Float32(dv)
		}

		if key == "defaultDouble" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Float64(sv)
			if err != nil {
				return nil, err
			}
			ds.DefaultDouble = ptr.Float64(dv)
		}

		if key == "defaultMap" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_TestStringMap(sv)
			if err != nil {
				return nil, err
			}
			ds.DefaultMap = dv
		}

		if key == "defaultEnum" {

			dv, err := deserializeCBOR_TestEnum(sv)
			if err != nil {
				return nil, err
			}
			ds.DefaultEnum = dv
		}

		if key == "defaultIntEnum" {

			dv, err := deserializeCBOR_TestIntEnum(sv)
			if err != nil {
				return nil, err
			}
			ds.DefaultIntEnum = dv
		}

		if key == "emptyString" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.EmptyString = ptr.String(dv)
		}

		if key == "falseBoolean" {

			dv, err := deserializeCBOR_Bool(sv)
			if err != nil {
				return nil, err
			}
			ds.FalseBoolean = dv
		}

		if key == "emptyBlob" {

			dv, err := deserializeCBOR_Blob(sv)
			if err != nil {
				return nil, err
			}
			ds.EmptyBlob = dv
		}

		if key == "zeroByte" {

			dv, err := deserializeCBOR_Int8(sv)
			if err != nil {
				return nil, err
			}
			ds.ZeroByte = dv
		}

		if key == "zeroShort" {

			dv, err := deserializeCBOR_Int16(sv)
			if err != nil {
				return nil, err
			}
			ds.ZeroShort = dv
		}

		if key == "zeroInteger" {

			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.ZeroInteger = dv
		}

		if key == "zeroLong" {

			dv, err := deserializeCBOR_Int64(sv)
			if err != nil {
				return nil, err
			}
			ds.ZeroLong = dv
		}

		if key == "zeroFloat" {

			dv, err := deserializeCBOR_Float32(sv)
			if err != nil {
				return nil, err
			}
			ds.ZeroFloat = dv
		}

		if key == "zeroDouble" {

			dv, err := deserializeCBOR_Float64(sv)
			if err != nil {
				return nil, err
			}
			ds.ZeroDouble = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_OptionalInputOutputOutput(v smithycbor.Value) (*OptionalInputOutputOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &OptionalInputOutputOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "value" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Value = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_RecursiveShapesOutput(v smithycbor.Value) (*RecursiveShapesOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &RecursiveShapesOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "nested" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_RecursiveShapesInputOutputNested1(sv)
			if err != nil {
				return nil, err
			}
			ds.Nested = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_RpcV2CborDenseMapsOutput(v smithycbor.Value) (*RpcV2CborDenseMapsOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &RpcV2CborDenseMapsOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "denseStructMap" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_DenseStructMap(sv)
			if err != nil {
				return nil, err
			}
			ds.DenseStructMap = dv
		}

		if key == "denseNumberMap" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_DenseNumberMap(sv)
			if err != nil {
				return nil, err
			}
			ds.DenseNumberMap = dv
		}

		if key == "denseBooleanMap" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_DenseBooleanMap(sv)
			if err != nil {
				return nil, err
			}
			ds.DenseBooleanMap = dv
		}

		if key == "denseStringMap" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_DenseStringMap(sv)
			if err != nil {
				return nil, err
			}
			ds.DenseStringMap = dv
		}

		if key == "denseSetMap" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_DenseSetMap(sv)
			if err != nil {
				return nil, err
			}
			ds.DenseSetMap = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_RpcV2CborListsOutput(v smithycbor.Value) (*RpcV2CborListsOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &RpcV2CborListsOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "stringList" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_StringList(sv)
			if err != nil {
				return nil, err
			}
			ds.StringList = dv
		}

		if key == "stringSet" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_StringSet(sv)
			if err != nil {
				return nil, err
			}
			ds.StringSet = dv
		}

		if key == "integerList" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_IntegerList(sv)
			if err != nil {
				return nil, err
			}
			ds.IntegerList = dv
		}

		if key == "booleanList" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_BooleanList(sv)
			if err != nil {
				return nil, err
			}
			ds.BooleanList = dv
		}

		if key == "timestampList" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_TimestampList(sv)
			if err != nil {
				return nil, err
			}
			ds.TimestampList = dv
		}

		if key == "enumList" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_FooEnumList(sv)
			if err != nil {
				return nil, err
			}
			ds.EnumList = dv
		}

		if key == "intEnumList" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_IntegerEnumList(sv)
			if err != nil {
				return nil, err
			}
			ds.IntEnumList = dv
		}

		if key == "nestedStringList" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_NestedStringList(sv)
			if err != nil {
				return nil, err
			}
			ds.NestedStringList = dv
		}

		if key == "structureList" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_StructureList(sv)
			if err != nil {
				return nil, err
			}
			ds.StructureList = dv
		}

		if key == "blobList" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_BlobList(sv)
			if err != nil {
				return nil, err
			}
			ds.BlobList = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_RpcV2CborSparseMapsOutput(v smithycbor.Value) (*RpcV2CborSparseMapsOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &RpcV2CborSparseMapsOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "sparseStructMap" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_SparseStructMap(sv)
			if err != nil {
				return nil, err
			}
			ds.SparseStructMap = dv
		}

		if key == "sparseNumberMap" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_SparseNumberMap(sv)
			if err != nil {
				return nil, err
			}
			ds.SparseNumberMap = dv
		}

		if key == "sparseBooleanMap" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_SparseBooleanMap(sv)
			if err != nil {
				return nil, err
			}
			ds.SparseBooleanMap = dv
		}

		if key == "sparseStringMap" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_SparseStringMap(sv)
			if err != nil {
				return nil, err
			}
			ds.SparseStringMap = dv
		}

		if key == "sparseSetMap" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_SparseSetMap(sv)
			if err != nil {
				return nil, err
			}
			ds.SparseSetMap = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_SimpleScalarPropertiesOutput(v smithycbor.Value) (*SimpleScalarPropertiesOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &SimpleScalarPropertiesOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "trueBooleanValue" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Bool(sv)
			if err != nil {
				return nil, err
			}
			ds.TrueBooleanValue = ptr.Bool(dv)
		}

		if key == "falseBooleanValue" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Bool(sv)
			if err != nil {
				return nil, err
			}
			ds.FalseBooleanValue = ptr.Bool(dv)
		}

		if key == "byteValue" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int8(sv)
			if err != nil {
				return nil, err
			}
			ds.ByteValue = ptr.Int8(dv)
		}

		if key == "doubleValue" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Float64(sv)
			if err != nil {
				return nil, err
			}
			ds.DoubleValue = ptr.Float64(dv)
		}

		if key == "floatValue" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Float32(sv)
			if err != nil {
				return nil, err
			}
			ds.FloatValue = ptr.Float32(dv)
		}

		if key == "integerValue" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int32(sv)
			if err != nil {
				return nil, err
			}
			ds.IntegerValue = ptr.Int32(dv)
		}

		if key == "longValue" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int64(sv)
			if err != nil {
				return nil, err
			}
			ds.LongValue = ptr.Int64(dv)
		}

		if key == "shortValue" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_Int16(sv)
			if err != nil {
				return nil, err
			}
			ds.ShortValue = ptr.Int16(dv)
		}

		if key == "stringValue" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.StringValue = ptr.String(dv)
		}

		if key == "blobValue" {

			dv, err := deserializeCBOR_Blob(sv)
			if err != nil {
				return nil, err
			}
			ds.BlobValue = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_SparseNullsOperationOutput(v smithycbor.Value) (*SparseNullsOperationOutput, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &SparseNullsOperationOutput{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "sparseStringList" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_SparseStringList(sv)
			if err != nil {
				return nil, err
			}
			ds.SparseStringList = dv
		}

		if key == "sparseStringMap" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_SparseStringMap(sv)
			if err != nil {
				return nil, err
			}
			ds.SparseStringMap = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_ComplexError(v smithycbor.Value) (*types.ComplexError, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.ComplexError{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "TopLevel" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.TopLevel = ptr.String(dv)
		}

		if key == "Nested" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_ComplexNestedErrorData(sv)
			if err != nil {
				return nil, err
			}
			ds.Nested = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_ComplexNestedErrorData(v smithycbor.Value) (*types.ComplexNestedErrorData, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.ComplexNestedErrorData{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "Foo" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Foo = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_DenseBooleanMap(v smithycbor.Value) (map[string]bool, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	dm := map[string]bool{}
	for key, sv := range av {

		dv, err := deserializeCBOR_Bool(sv)
		if err != nil {
			return nil, err
		}
		dm[key] = dv
	}
	return dm, nil
}

func deserializeCBOR_DenseNumberMap(v smithycbor.Value) (map[string]int32, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	dm := map[string]int32{}
	for key, sv := range av {

		dv, err := deserializeCBOR_Int32(sv)
		if err != nil {
			return nil, err
		}
		dm[key] = dv
	}
	return dm, nil
}

func deserializeCBOR_DenseSetMap(v smithycbor.Value) (map[string][]string, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	dm := map[string][]string{}
	for key, sv := range av {
		if _, ok := sv.(*smithycbor.Nil); ok {
			dm[key] = nil
			continue
		}
		dv, err := deserializeCBOR_StringSet(sv)
		if err != nil {
			return nil, err
		}
		dm[key] = dv
	}
	return dm, nil
}

func deserializeCBOR_DenseStringMap(v smithycbor.Value) (map[string]string, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	dm := map[string]string{}
	for key, sv := range av {

		dv, err := deserializeCBOR_String(sv)
		if err != nil {
			return nil, err
		}
		dm[key] = dv
	}
	return dm, nil
}

func deserializeCBOR_DenseStructMap(v smithycbor.Value) (map[string]types.GreetingStruct, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	dm := map[string]types.GreetingStruct{}
	for key, sv := range av {

		dv, err := deserializeCBOR_GreetingStruct(sv)
		if err != nil {
			return nil, err
		}
		dm[key] = *dv
	}
	return dm, nil
}

func deserializeCBOR_InvalidGreeting(v smithycbor.Value) (*types.InvalidGreeting, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.InvalidGreeting{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "Message" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Message = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_RecursiveShapesInputOutputNested1(v smithycbor.Value) (*types.RecursiveShapesInputOutputNested1, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.RecursiveShapesInputOutputNested1{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "foo" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Foo = ptr.String(dv)
		}

		if key == "nested" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_RecursiveShapesInputOutputNested2(sv)
			if err != nil {
				return nil, err
			}
			ds.Nested = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_RecursiveShapesInputOutputNested2(v smithycbor.Value) (*types.RecursiveShapesInputOutputNested2, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.RecursiveShapesInputOutputNested2{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "bar" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Bar = ptr.String(dv)
		}

		if key == "recursiveMember" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_RecursiveShapesInputOutputNested1(sv)
			if err != nil {
				return nil, err
			}
			ds.RecursiveMember = dv
		}
	}
	return ds, nil
}

func deserializeCBOR_SparseBooleanMap(v smithycbor.Value) (map[string]*bool, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	dm := map[string]*bool{}
	for key, sv := range av {
		if _, ok := sv.(*smithycbor.Nil); ok {
			dm[key] = nil
			continue
		}
		dv, err := deserializeCBOR_Bool(sv)
		if err != nil {
			return nil, err
		}
		dm[key] = &dv
	}
	return dm, nil
}

func deserializeCBOR_SparseNumberMap(v smithycbor.Value) (map[string]*int32, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	dm := map[string]*int32{}
	for key, sv := range av {
		if _, ok := sv.(*smithycbor.Nil); ok {
			dm[key] = nil
			continue
		}
		dv, err := deserializeCBOR_Int32(sv)
		if err != nil {
			return nil, err
		}
		dm[key] = &dv
	}
	return dm, nil
}

func deserializeCBOR_SparseSetMap(v smithycbor.Value) (map[string][]string, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	dm := map[string][]string{}
	for key, sv := range av {
		if _, ok := sv.(*smithycbor.Nil); ok {
			dm[key] = nil
			continue
		}
		dv, err := deserializeCBOR_StringSet(sv)
		if err != nil {
			return nil, err
		}
		dm[key] = dv
	}
	return dm, nil
}

func deserializeCBOR_SparseStructMap(v smithycbor.Value) (map[string]*types.GreetingStruct, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	dm := map[string]*types.GreetingStruct{}
	for key, sv := range av {
		if _, ok := sv.(*smithycbor.Nil); ok {
			dm[key] = nil
			continue
		}
		dv, err := deserializeCBOR_GreetingStruct(sv)
		if err != nil {
			return nil, err
		}
		dm[key] = dv
	}
	return dm, nil
}

func deserializeCBOR_StructureList(v smithycbor.Value) ([]types.StructureListMember, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.StructureListMember
	for _, si := range av {

		di, err := deserializeCBOR_StructureListMember(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, *di)
	}
	return dl, nil
}

func deserializeCBOR_StructureListMember(v smithycbor.Value) (*types.StructureListMember, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.StructureListMember{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "a" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.A = ptr.String(dv)
		}

		if key == "b" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.B = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_TestEnum(v smithycbor.Value) (types.TestEnum, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.TestEnum(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.TestEnum(av), nil
}

func deserializeCBOR_TestIntEnum(v smithycbor.Value) (types.TestIntEnum, error) {
	av, err := smithycbor.AsInt32(v)
	if err != nil {
		return 0, err
	}
	return types.TestIntEnum(av), nil
}

func deserializeCBOR_TestStringList(v smithycbor.Value) ([]string, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []string
	for _, si := range av {

		di, err := deserializeCBOR_String(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, di)
	}
	return dl, nil
}

func deserializeCBOR_TestStringMap(v smithycbor.Value) (map[string]string, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	dm := map[string]string{}
	for key, sv := range av {

		dv, err := deserializeCBOR_String(sv)
		if err != nil {
			return nil, err
		}
		dm[key] = dv
	}
	return dm, nil
}

func deserializeCBOR_BlobList(v smithycbor.Value) ([][]byte, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl [][]byte
	for _, si := range av {

		di, err := deserializeCBOR_Blob(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, di)
	}
	return dl, nil
}

func deserializeCBOR_BooleanList(v smithycbor.Value) ([]bool, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []bool
	for _, si := range av {

		di, err := deserializeCBOR_Bool(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, di)
	}
	return dl, nil
}

func deserializeCBOR_FooEnum(v smithycbor.Value) (types.FooEnum, error) {
	av, ok := v.(smithycbor.String)
	if !ok {
		return types.FooEnum(""), fmt.Errorf("unexpected value type %T", v)
	}
	return types.FooEnum(av), nil
}

func deserializeCBOR_FooEnumList(v smithycbor.Value) ([]types.FooEnum, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.FooEnum
	for _, si := range av {

		di, err := deserializeCBOR_FooEnum(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, di)
	}
	return dl, nil
}

func deserializeCBOR_GreetingStruct(v smithycbor.Value) (*types.GreetingStruct, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	ds := &types.GreetingStruct{}
	for key, sv := range av {
		_, _ = key, sv
		if key == "hi" {
			if _, ok := sv.(*smithycbor.Nil); ok {
				continue
			}
			dv, err := deserializeCBOR_String(sv)
			if err != nil {
				return nil, err
			}
			ds.Hi = ptr.String(dv)
		}
	}
	return ds, nil
}

func deserializeCBOR_IntegerEnum(v smithycbor.Value) (types.IntegerEnum, error) {
	av, err := smithycbor.AsInt32(v)
	if err != nil {
		return 0, err
	}
	return types.IntegerEnum(av), nil
}

func deserializeCBOR_IntegerEnumList(v smithycbor.Value) ([]types.IntegerEnum, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []types.IntegerEnum
	for _, si := range av {

		di, err := deserializeCBOR_IntegerEnum(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, di)
	}
	return dl, nil
}

func deserializeCBOR_IntegerList(v smithycbor.Value) ([]int32, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []int32
	for _, si := range av {

		di, err := deserializeCBOR_Int32(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, di)
	}
	return dl, nil
}

func deserializeCBOR_NestedStringList(v smithycbor.Value) ([][]string, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl [][]string
	for _, si := range av {
		if _, ok := si.(*smithycbor.Nil); ok {
			dl = append(dl, nil)
			continue
		}
		di, err := deserializeCBOR_StringList(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, di)
	}
	return dl, nil
}

func deserializeCBOR_SparseStringList(v smithycbor.Value) ([]*string, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []*string
	for _, si := range av {
		if _, ok := si.(*smithycbor.Nil); ok {
			dl = append(dl, nil)
			continue
		}
		di, err := deserializeCBOR_String(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, &di)
	}
	return dl, nil
}

func deserializeCBOR_SparseStringMap(v smithycbor.Value) (map[string]*string, error) {
	av, ok := v.(smithycbor.Map)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	dm := map[string]*string{}
	for key, sv := range av {
		if _, ok := sv.(*smithycbor.Nil); ok {
			dm[key] = nil
			continue
		}
		dv, err := deserializeCBOR_String(sv)
		if err != nil {
			return nil, err
		}
		dm[key] = &dv
	}
	return dm, nil
}

func deserializeCBOR_StringList(v smithycbor.Value) ([]string, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []string
	for _, si := range av {

		di, err := deserializeCBOR_String(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, di)
	}
	return dl, nil
}

func deserializeCBOR_StringSet(v smithycbor.Value) ([]string, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []string
	for _, si := range av {

		di, err := deserializeCBOR_String(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, di)
	}
	return dl, nil
}

func deserializeCBOR_TimestampList(v smithycbor.Value) ([]time.Time, error) {
	av, ok := v.(smithycbor.List)
	if !ok {
		return nil, fmt.Errorf("unexpected value type %T", v)
	}
	var dl []time.Time
	for _, si := range av {

		di, err := deserializeCBOR_Time(si)
		if err != nil {
			return nil, err
		}
		dl = append(dl, di)
	}
	return dl, nil
}
func rpc2_deserializeOpErrorEmptyInputOutput(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	switch string(typ) {

	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorFloat16(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	switch string(typ) {

	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorFractionalSeconds(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	switch string(typ) {

	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorGreetingWithErrors(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	switch string(typ) {
	case "smithy.protocoltests.rpcv2Cbor#InvalidGreeting":
		verr, err := deserializeCBOR_InvalidGreeting(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize smithy.protocoltests.rpcv2Cbor#InvalidGreeting: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	case "smithy.protocoltests.rpcv2Cbor#ComplexError":
		verr, err := deserializeCBOR_ComplexError(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize smithy.protocoltests.rpcv2Cbor#ComplexError: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorNoInputOutput(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	switch string(typ) {

	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorOperationWithDefaults(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	switch string(typ) {
	case "smithy.framework#ValidationException":
		verr, err := deserializeCBOR_ValidationException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize smithy.framework#ValidationException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorOptionalInputOutput(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	switch string(typ) {

	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorRecursiveShapes(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	switch string(typ) {

	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorRpcV2CborDenseMaps(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	switch string(typ) {
	case "smithy.framework#ValidationException":
		verr, err := deserializeCBOR_ValidationException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize smithy.framework#ValidationException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorRpcV2CborLists(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	switch string(typ) {
	case "smithy.framework#ValidationException":
		verr, err := deserializeCBOR_ValidationException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize smithy.framework#ValidationException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorRpcV2CborSparseMaps(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	switch string(typ) {
	case "smithy.framework#ValidationException":
		verr, err := deserializeCBOR_ValidationException(v)
		if err != nil {
			return &smithy.DeserializationError{
				Err:      fmt.Errorf("deserialize smithy.framework#ValidationException: %w", err),
				Snapshot: payload,
			}
		}

		return verr
	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorSimpleScalarProperties(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	switch string(typ) {

	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}

func rpc2_deserializeOpErrorSparseNullsOperation(resp *smithyhttp.Response) error {
	payload, err := io.ReadAll(resp.Body)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("read response body: %w", err)}
	}

	typ, msg, v, err := getProtocolErrorInfo(payload)
	if err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("get error info: %w", err)}
	}

	if len(typ) == 0 {
		typ = "UnknownError"
	}
	if len(msg) == 0 {
		msg = "UnknownError"
	}

	_ = v
	switch string(typ) {

	default:

		return &smithy.GenericAPIError{Code: typ, Message: msg}
	}
}
func getProtocolErrorInfo(payload []byte) (typ, msg string, v smithycbor.Value, err error) {
	v, err = smithycbor.Decode(payload)
	if err != nil {
		return "", "", nil, fmt.Errorf("decode: %w", err)
	}

	mv, ok := v.(smithycbor.Map)
	if !ok {
		return "", "", nil, fmt.Errorf("unexpected payload type %T", v)
	}

	if ctyp, ok := mv["__type"]; ok {
		if ttyp, ok := ctyp.(smithycbor.String); ok {
			typ = string(ttyp)
		}
	}

	if cmsg, ok := mv["message"]; ok {
		if tmsg, ok := cmsg.(smithycbor.String); ok {
			msg = string(tmsg)
		}
	}

	return typ, msg, mv, nil
}
func getAwsQueryErrorCode(resp *smithyhttp.Response) string {
	header := resp.Header.Get("x-amzn-query-error")
	if header == "" {
		return ""
	}

	parts := strings.Split(header, ";")
	if len(parts) != 2 {
		return ""
	}

	return parts[0]
}
