// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A summary of findings metrics for an account on a specified date.
type AccountFindingsMetric struct {

	// The number of closed findings of each severity on the specified date.
	ClosedFindings *FindingMetricsValuePerSeverity

	// The date from which the findings metrics were retrieved.
	Date *time.Time

	// The average time in days it takes to close findings of each severity as of a
	// specified date.
	MeanTimeToClose *FindingMetricsValuePerSeverity

	// The number of new findings of each severity on the specified date.
	NewFindings *FindingMetricsValuePerSeverity

	// The number of open findings of each severity as of the specified date.
	OpenFindings *FindingMetricsValuePerSeverity

	noSmithyDocumentSerde
}

// Contains information about the error that caused a finding to fail to be
// retrieved.
type BatchGetFindingsError struct {

	// A code associated with the type of error.
	//
	// This member is required.
	ErrorCode ErrorCode

	// The finding ID of the finding that was not fetched.
	//
	// This member is required.
	FindingId *string

	// Describes the error.
	//
	// This member is required.
	Message *string

	// The name of the scan that generated the finding.
	//
	// This member is required.
	ScanName *string

	noSmithyDocumentSerde
}

// Information about a finding category with open findings.
type CategoryWithFindingNum struct {

	// The name of the finding category. A finding category is determined by the
	// detector that detected the finding.
	CategoryName *string

	// The number of open findings in the category.
	FindingNumber *int32

	noSmithyDocumentSerde
}

// The line of code where a finding was detected.
type CodeLine struct {

	// The code that contains a vulnerability.
	Content *string

	// The code line number.
	Number *int32

	noSmithyDocumentSerde
}

// Information about the encryption configuration for an account. Required to call
// UpdateAccountConfiguration .
type EncryptionConfig struct {

	// The KMS key ARN that is used for encryption. If an AWS-managed key is used for
	// encryption, returns empty.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Information about the location of security vulnerabilities that Amazon CodeGuru
// Security detected in your code.
type FilePath struct {

	// A list of CodeLine objects that describe where the security vulnerability
	// appears in your code.
	CodeSnippet []CodeLine

	// The last line number of the code snippet where the security vulnerability
	// appears in your code.
	EndLine *int32

	// The name of the file.
	Name *string

	// The path to the resource with the security vulnerability.
	Path *string

	// The first line number of the code snippet where the security vulnerability
	// appears in your code.
	StartLine *int32

	noSmithyDocumentSerde
}

// Information about a finding that was detected in your code.
type Finding struct {

	// The time when the finding was created.
	CreatedAt *time.Time

	// A description of the finding.
	Description *string

	// The identifier for the detector that detected the finding in your code. A
	// detector is a defined rule based on industry standards and AWS best practices.
	DetectorId *string

	// The name of the detector that identified the security vulnerability in your
	// code.
	DetectorName *string

	// One or more tags or categorizations that are associated with a detector. These
	// tags are defined by type, programming language, or other classification such as
	// maintainability or consistency.
	DetectorTags []string

	// The identifier for the component that generated a finding such as
	// AmazonCodeGuruSecurity.
	GeneratorId *string

	// The identifier for a finding.
	Id *string

	// An object that contains the details about how to remediate a finding.
	Remediation *Remediation

	// The resource where Amazon CodeGuru Security detected a finding.
	Resource *Resource

	// The identifier for the rule that generated the finding.
	RuleId *string

	// The severity of the finding. Severity can be critical, high, medium, low, or
	// informational. For information on severity levels, see [Finding severity]in the Amazon CodeGuru
	// Security User Guide.
	//
	// [Finding severity]: https://docs.aws.amazon.com/codeguru/latest/security-ug/findings-overview.html#severity-distribution
	Severity Severity

	// The status of the finding. A finding status can be open or closed.
	Status Status

	// The title of the finding.
	Title *string

	// The type of finding.
	Type *string

	// The time when the finding was last updated. Findings are updated when you
	// remediate them or when the finding code location changes.
	UpdatedAt *time.Time

	// An object that describes the detected security vulnerability.
	Vulnerability *Vulnerability

	noSmithyDocumentSerde
}

// An object that contains information about a finding and the scan that generated
// it.
type FindingIdentifier struct {

	// The identifier for a finding.
	//
	// This member is required.
	FindingId *string

	// The name of the scan that generated the finding.
	//
	// This member is required.
	ScanName *string

	noSmithyDocumentSerde
}

// A numeric value corresponding to the severity of a finding, such as the number
// of open findings or the average time it takes to close findings of a given
// severity.
type FindingMetricsValuePerSeverity struct {

	// A numeric value corresponding to a critical finding.
	Critical *float64

	// A numeric value corresponding to a high severity finding.
	High *float64

	// A numeric value corresponding to an informational finding.
	Info *float64

	// A numeric value corresponding to a low severity finding.
	Low *float64

	// A numeric value corresponding to a medium severity finding.
	Medium *float64

	noSmithyDocumentSerde
}

// A summary of metrics for an account as of a specified date.
type MetricsSummary struct {

	// A list of CategoryWithFindingNum objects for the top 5 finding categories with
	// the most findings.
	CategoriesWithMostFindings []CategoryWithFindingNum

	// The date from which the metrics summary information was retrieved.
	Date *time.Time

	// The number of open findings of each severity.
	OpenFindings *FindingMetricsValuePerSeverity

	// A list of ScanNameWithFindingNum objects for the top 3 scans with the most
	// number of open critical findings.
	ScansWithMostOpenCriticalFindings []ScanNameWithFindingNum

	// A list of ScanNameWithFindingNum objects for the top 3 scans with the most
	// number of open findings.
	ScansWithMostOpenFindings []ScanNameWithFindingNum

	noSmithyDocumentSerde
}

// Information about the recommended course of action to remediate a finding.
type Recommendation struct {

	// The recommended course of action to remediate the finding.
	Text *string

	// The URL address to the recommendation for remediating the finding.
	Url *string

	noSmithyDocumentSerde
}

// Information about how to remediate a finding.
type Remediation struct {

	// An object that contains information about the recommended course of action to
	// remediate a finding.
	Recommendation *Recommendation

	// A list of SuggestedFix objects. Each object contains information about a
	// suggested code fix to remediate the finding.
	SuggestedFixes []SuggestedFix

	noSmithyDocumentSerde
}

// Information about a resource that contains a finding.
type Resource struct {

	// The scanName of the scan that was run on the resource.
	Id *string

	// The identifier for a section of the resource.
	SubResourceId *string

	noSmithyDocumentSerde
}

// The identifier for a resource object that contains resources to scan.
// Specifying a codeArtifactId is required to create a scan.
//
// The following types satisfy this interface:
//
//	ResourceIdMemberCodeArtifactId
type ResourceId interface {
	isResourceId()
}

// The identifier for the code file uploaded to the resource object. Returned by
// CreateUploadUrl when you upload resources to be scanned.
type ResourceIdMemberCodeArtifactId struct {
	Value string

	noSmithyDocumentSerde
}

func (*ResourceIdMemberCodeArtifactId) isResourceId() {}

// Information about the number of findings generated by a scan.
type ScanNameWithFindingNum struct {

	// The number of findings generated by a scan.
	FindingNumber *int32

	// The name of the scan.
	ScanName *string

	noSmithyDocumentSerde
}

// Information about a scan.
type ScanSummary struct {

	//  The time when the scan was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The identifier for the scan run.
	//
	// This member is required.
	RunId *string

	// The name of the scan.
	//
	// This member is required.
	ScanName *string

	// The state of the scan. A scan can be In Progress , Complete , or Failed .
	//
	// This member is required.
	ScanState ScanState

	// The ARN for the scan name.
	ScanNameArn *string

	// The time the scan was last updated. A scan is updated when it is re-run.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Information about the suggested code fix to remediate a finding.
type SuggestedFix struct {

	// The suggested code fix. If applicable, includes code patch to replace your
	// source code.
	Code *string

	// A description of the suggested code fix and why it is being suggested.
	Description *string

	noSmithyDocumentSerde
}

// Information about a validation exception.
type ValidationExceptionField struct {

	// Describes the exception.
	//
	// This member is required.
	Message *string

	// The name of the exception.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Information about a security vulnerability that Amazon CodeGuru Security
// detected.
type Vulnerability struct {

	//  An object that describes the location of the detected security vulnerability
	// in your code.
	FilePath *FilePath

	// The identifier for the vulnerability.
	Id *string

	// The number of times the vulnerability appears in your code.
	//
	// Deprecated: This shape is not used.
	ItemCount *int32

	// One or more URL addresses that contain details about a vulnerability.
	ReferenceUrls []string

	// One or more vulnerabilities that are related to the vulnerability being
	// described.
	RelatedVulnerabilities []string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isResourceId() {}
