// Code generated by smithy-go-codegen DO NOT EDIT.

package licensemanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/licensemanager/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a license.
func (c *Client) CreateLicense(ctx context.Context, params *CreateLicenseInput, optFns ...func(*Options)) (*CreateLicenseOutput, error) {
	if params == nil {
		params = &CreateLicenseInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateLicense", params, optFns, c.addOperationCreateLicenseMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateLicenseOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateLicenseInput struct {

	// License beneficiary.
	//
	// This member is required.
	Beneficiary *string

	// Unique, case-sensitive identifier that you provide to ensure the idempotency of
	// the request.
	//
	// This member is required.
	ClientToken *string

	// Configuration for consumption of the license. Choose a provisional
	// configuration for workloads running with continuous connectivity. Choose a
	// borrow configuration for workloads with offline usage.
	//
	// This member is required.
	ConsumptionConfiguration *types.ConsumptionConfiguration

	// License entitlements.
	//
	// This member is required.
	Entitlements []types.Entitlement

	// Home Region for the license.
	//
	// This member is required.
	HomeRegion *string

	// License issuer.
	//
	// This member is required.
	Issuer *types.Issuer

	// License name.
	//
	// This member is required.
	LicenseName *string

	// Product name.
	//
	// This member is required.
	ProductName *string

	// Product SKU.
	//
	// This member is required.
	ProductSKU *string

	// Date and time range during which the license is valid, in ISO8601-UTC format.
	//
	// This member is required.
	Validity *types.DatetimeRange

	// Information about the license.
	LicenseMetadata []types.Metadata

	noSmithyDocumentSerde
}

type CreateLicenseOutput struct {

	// Amazon Resource Name (ARN) of the license.
	LicenseArn *string

	// License status.
	Status types.LicenseStatus

	// License version.
	Version *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateLicenseMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateLicense{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateLicense{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateLicense"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateLicenseValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateLicense(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateLicense(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateLicense",
	}
}
