// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Details about an Active Directory identity provider.
type ActiveDirectoryIdentityProvider struct {

	// The directory ID for an Active Directory identity provider.
	DirectoryId *string

	noSmithyDocumentSerde
}

// A filter name and value pair that is used to return more specific results from
// a describe operation. Filters can be used to match a set of resources by
// specific criteria, such as tags, attributes, or IDs.
type Filter struct {

	// The name of an attribute to use as a filter.
	Attribute *string

	// The type of search (For example, eq, geq, leq)
	Operation *string

	// Value of the filter.
	Value *string

	noSmithyDocumentSerde
}

// Details about an identity provider.
//
// The following types satisfy this interface:
//
//	IdentityProviderMemberActiveDirectoryIdentityProvider
type IdentityProvider interface {
	isIdentityProvider()
}

// An object that details an Active Directory identity provider.
type IdentityProviderMemberActiveDirectoryIdentityProvider struct {
	Value ActiveDirectoryIdentityProvider

	noSmithyDocumentSerde
}

func (*IdentityProviderMemberActiveDirectoryIdentityProvider) isIdentityProvider() {}

// Describes an identity provider.
type IdentityProviderSummary struct {

	// An object that specifies details for the identity provider.
	//
	// This member is required.
	IdentityProvider IdentityProvider

	// The name of the user-based subscription product.
	//
	// This member is required.
	Product *string

	// An object that details the registered identity provider’s product related
	// configuration settings such as the subnets to provision VPC endpoints.
	//
	// This member is required.
	Settings *Settings

	// The status of an identity provider.
	//
	// This member is required.
	Status *string

	// The failure message associated with an identity provider.
	FailureMessage *string

	noSmithyDocumentSerde
}

// Describes an EC2 instance providing user-based subscriptions.
type InstanceSummary struct {

	// The ID of the EC2 instance, which provides user-based subscriptions.
	//
	// This member is required.
	InstanceId *string

	// A list of provided user-based subscription products.
	//
	// This member is required.
	Products []string

	// The status of an EC2 instance resource.
	//
	// This member is required.
	Status *string

	// The date of the last status check.
	LastStatusCheckDate *string

	// The status message for an EC2 instance.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Describes users of an EC2 instance providing user-based subscriptions.
type InstanceUserSummary struct {

	// An object that specifies details for the identity provider.
	//
	// This member is required.
	IdentityProvider IdentityProvider

	// The ID of the EC2 instance, which provides user-based subscriptions.
	//
	// This member is required.
	InstanceId *string

	// The status of a user associated with an EC2 instance.
	//
	// This member is required.
	Status *string

	// The user name from the identity provider for the user.
	//
	// This member is required.
	Username *string

	// The date a user was associated with an EC2 instance.
	AssociationDate *string

	// The date a user was disassociated from an EC2 instance.
	DisassociationDate *string

	// The domain name of the user.
	Domain *string

	// The status message for users of an EC2 instance.
	StatusMessage *string

	noSmithyDocumentSerde
}

// The summary of the user-based subscription products for a user.
type ProductUserSummary struct {

	// An object that specifies details for the identity provider.
	//
	// This member is required.
	IdentityProvider IdentityProvider

	// The name of the user-based subscription product.
	//
	// This member is required.
	Product *string

	// The status of a product for a user.
	//
	// This member is required.
	Status *string

	// The user name from the identity provider of the user.
	//
	// This member is required.
	Username *string

	// The domain name of the user.
	Domain *string

	// The status message for a product for a user.
	StatusMessage *string

	// The end date of a subscription.
	SubscriptionEndDate *string

	// The start date of a subscription.
	SubscriptionStartDate *string

	noSmithyDocumentSerde
}

// The registered identity provider’s product related configuration settings such
// as the subnets to provision VPC endpoints, and the security group ID that is
// associated with the VPC endpoints. The security group should permit inbound TCP
// port 1688 communication from resources in the VPC.
type Settings struct {

	// A security group ID that allows inbound TCP port 1688 communication between
	// resources in your VPC and the VPC endpoint for activation servers.
	//
	// This member is required.
	SecurityGroupId *string

	// The subnets defined for the registered identity provider.
	//
	// This member is required.
	Subnets []string

	noSmithyDocumentSerde
}

// Updates the registered identity provider’s product related configuration
// settings such as the subnets to provision VPC endpoints.
type UpdateSettings struct {

	// The ID of one or more subnets in which License Manager will create a VPC
	// endpoint for products that require connectivity to activation servers.
	//
	// This member is required.
	AddSubnets []string

	// The ID of one or more subnets to remove.
	//
	// This member is required.
	RemoveSubnets []string

	// A security group ID that allows inbound TCP port 1688 communication between
	// resources in your VPC and the VPC endpoints for activation servers.
	SecurityGroupId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isIdentityProvider() {}
