// Code generated by smithy-go-codegen DO NOT EDIT.

package personalizeevents

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/personalizeevents/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpPutActionInteractions struct {
}

func (*validateOpPutActionInteractions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutActionInteractions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutActionInteractionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutActionInteractionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutActions struct {
}

func (*validateOpPutActions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutActions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutActionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutActionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutEvents struct {
}

func (*validateOpPutEvents) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutEvents) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutEventsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutEventsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutItems struct {
}

func (*validateOpPutItems) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutItems) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutItemsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutItemsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutUsers struct {
}

func (*validateOpPutUsers) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutUsers) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutUsersInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutUsersInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpPutActionInteractionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutActionInteractions{}, middleware.After)
}

func addOpPutActionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutActions{}, middleware.After)
}

func addOpPutEventsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutEvents{}, middleware.After)
}

func addOpPutItemsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutItems{}, middleware.After)
}

func addOpPutUsersValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutUsers{}, middleware.After)
}

func validateAction(v *types.Action) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Action"}
	if v.ActionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateActionInteraction(v *types.ActionInteraction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionInteraction"}
	if v.ActionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionId"))
	}
	if v.SessionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SessionId"))
	}
	if v.Timestamp == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Timestamp"))
	}
	if v.EventType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EventType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateActionInteractionsList(v []types.ActionInteraction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionInteractionsList"}
	for i := range v {
		if err := validateActionInteraction(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateActionList(v []types.Action) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ActionList"}
	for i := range v {
		if err := validateAction(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEvent(v *types.Event) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Event"}
	if v.EventType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EventType"))
	}
	if v.SentAt == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SentAt"))
	}
	if v.MetricAttribution != nil {
		if err := validateMetricAttribution(v.MetricAttribution); err != nil {
			invalidParams.AddNested("MetricAttribution", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEventList(v []types.Event) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EventList"}
	for i := range v {
		if err := validateEvent(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateItem(v *types.Item) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Item"}
	if v.ItemId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ItemId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateItemList(v []types.Item) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ItemList"}
	for i := range v {
		if err := validateItem(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateMetricAttribution(v *types.MetricAttribution) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MetricAttribution"}
	if v.EventAttributionSource == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EventAttributionSource"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUser(v *types.User) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "User"}
	if v.UserId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UserId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUserList(v []types.User) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UserList"}
	for i := range v {
		if err := validateUser(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutActionInteractionsInput(v *PutActionInteractionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutActionInteractionsInput"}
	if v.TrackingId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TrackingId"))
	}
	if v.ActionInteractions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionInteractions"))
	} else if v.ActionInteractions != nil {
		if err := validateActionInteractionsList(v.ActionInteractions); err != nil {
			invalidParams.AddNested("ActionInteractions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutActionsInput(v *PutActionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutActionsInput"}
	if v.DatasetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatasetArn"))
	}
	if v.Actions == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Actions"))
	} else if v.Actions != nil {
		if err := validateActionList(v.Actions); err != nil {
			invalidParams.AddNested("Actions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutEventsInput(v *PutEventsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutEventsInput"}
	if v.TrackingId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TrackingId"))
	}
	if v.SessionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SessionId"))
	}
	if v.EventList == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EventList"))
	} else if v.EventList != nil {
		if err := validateEventList(v.EventList); err != nil {
			invalidParams.AddNested("EventList", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutItemsInput(v *PutItemsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutItemsInput"}
	if v.DatasetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatasetArn"))
	}
	if v.Items == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Items"))
	} else if v.Items != nil {
		if err := validateItemList(v.Items); err != nil {
			invalidParams.AddNested("Items", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutUsersInput(v *PutUsersInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutUsersInput"}
	if v.DatasetArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DatasetArn"))
	}
	if v.Users == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Users"))
	} else if v.Users != nil {
		if err := validateUserList(v.Users); err != nil {
			invalidParams.AddNested("Users", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
