// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Stops an inference experiment.
func (c *Client) StopInferenceExperiment(ctx context.Context, params *StopInferenceExperimentInput, optFns ...func(*Options)) (*StopInferenceExperimentOutput, error) {
	if params == nil {
		params = &StopInferenceExperimentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StopInferenceExperiment", params, optFns, c.addOperationStopInferenceExperimentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StopInferenceExperimentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StopInferenceExperimentInput struct {

	//  Array of key-value pairs, with names of variants mapped to actions. The
	// possible actions are the following:
	//
	//   - Promote - Promote the shadow variant to a production variant
	//
	//   - Remove - Delete the variant
	//
	//   - Retain - Keep the variant as it is
	//
	// This member is required.
	ModelVariantActions map[string]types.ModelVariantAction

	// The name of the inference experiment to stop.
	//
	// This member is required.
	Name *string

	//  An array of ModelVariantConfig objects. There is one for each variant that you
	// want to deploy after the inference experiment stops. Each ModelVariantConfig
	// describes the infrastructure configuration for deploying the corresponding
	// variant.
	DesiredModelVariants []types.ModelVariantConfig

	//  The desired state of the experiment after stopping. The possible states are
	// the following:
	//
	//   - Completed : The experiment completed successfully
	//
	//   - Cancelled : The experiment was canceled
	DesiredState types.InferenceExperimentStopDesiredState

	// The reason for stopping the experiment.
	Reason *string

	noSmithyDocumentSerde
}

type StopInferenceExperimentOutput struct {

	// The ARN of the stopped inference experiment.
	//
	// This member is required.
	InferenceExperimentArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStopInferenceExperimentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpStopInferenceExperiment{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpStopInferenceExperiment{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StopInferenceExperiment"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpStopInferenceExperimentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStopInferenceExperiment(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStopInferenceExperiment(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StopInferenceExperiment",
	}
}
