// Code generated by smithy-go-codegen DO NOT EDIT.

package supportapp

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/supportapp/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the configuration for a Slack channel, such as case update
// notifications.
func (c *Client) UpdateSlackChannelConfiguration(ctx context.Context, params *UpdateSlackChannelConfigurationInput, optFns ...func(*Options)) (*UpdateSlackChannelConfigurationOutput, error) {
	if params == nil {
		params = &UpdateSlackChannelConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateSlackChannelConfiguration", params, optFns, c.addOperationUpdateSlackChannelConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateSlackChannelConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateSlackChannelConfigurationInput struct {

	// The channel ID in Slack. This ID identifies a channel within a Slack workspace.
	//
	// This member is required.
	ChannelId *string

	// The team ID in Slack. This ID uniquely identifies a Slack workspace, such as
	// T012ABCDEFG .
	//
	// This member is required.
	TeamId *string

	// The Slack channel name that you want to update.
	ChannelName *string

	// The Amazon Resource Name (ARN) of an IAM role that you want to use to perform
	// operations on Amazon Web Services. For more information, see [Managing access to the Amazon Web Services Support App]in the Amazon Web
	// Services Support User Guide.
	//
	// [Managing access to the Amazon Web Services Support App]: https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html
	ChannelRoleArn *string

	// Whether you want to get notified when a support case has a new correspondence.
	NotifyOnAddCorrespondenceToCase *bool

	// The case severity for a support case that you want to receive notifications.
	//
	// If you specify high or all , at least one of the following parameters must be
	// true :
	//
	//   - notifyOnAddCorrespondenceToCase
	//
	//   - notifyOnCreateOrReopenCase
	//
	//   - notifyOnResolveCase
	//
	// If you specify none , any of the following parameters that you specify in your
	// request must be false :
	//
	//   - notifyOnAddCorrespondenceToCase
	//
	//   - notifyOnCreateOrReopenCase
	//
	//   - notifyOnResolveCase
	//
	// If you don't specify these parameters in your request, the Amazon Web Services
	// Support App uses the current values by default.
	NotifyOnCaseSeverity types.NotificationSeverityLevel

	// Whether you want to get notified when a support case is created or reopened.
	NotifyOnCreateOrReopenCase *bool

	// Whether you want to get notified when a support case is resolved.
	NotifyOnResolveCase *bool

	noSmithyDocumentSerde
}

type UpdateSlackChannelConfigurationOutput struct {

	// The channel ID in Slack. This ID identifies a channel within a Slack workspace.
	ChannelId *string

	// The name of the Slack channel that you configure for the Amazon Web Services
	// Support App.
	ChannelName *string

	// The Amazon Resource Name (ARN) of an IAM role that you want to use to perform
	// operations on Amazon Web Services. For more information, see [Managing access to the Amazon Web Services Support App]in the Amazon Web
	// Services Support User Guide.
	//
	// [Managing access to the Amazon Web Services Support App]: https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html
	ChannelRoleArn *string

	// Whether you want to get notified when a support case has a new correspondence.
	NotifyOnAddCorrespondenceToCase *bool

	// The case severity for a support case that you want to receive notifications.
	NotifyOnCaseSeverity types.NotificationSeverityLevel

	// Whether you want to get notified when a support case is created or reopened.
	NotifyOnCreateOrReopenCase *bool

	// Whether you want to get notified when a support case is resolved.
	NotifyOnResolveCase *bool

	// The team ID in Slack. This ID uniquely identifies a Slack workspace, such as
	// T012ABCDEFG .
	TeamId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateSlackChannelConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateSlackChannelConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateSlackChannelConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateSlackChannelConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateSlackChannelConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateSlackChannelConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateSlackChannelConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateSlackChannelConfiguration",
	}
}
